
/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_AUDIOPLUGIN_H_
#define _RG_AUDIOPLUGIN_H_

#include "base/AudioPluginInstance.h"
#include <tqcolor.h>
#include <tqstring.h>
#include <vector>




namespace Rosegarden
{



class AudioPlugin
{
public:
    AudioPlugin(const TQString &identifier,
                const TQString &name,
                unsigned long uniqueId,
                const TQString &label,
                const TQString &author,
                const TQString &copyright,
                bool isSynth,
                bool isGrouped,
                const TQString &category);

    TQString getIdentifier() const { return m_identifier; }

    TQString getName() const { return m_name; }
    unsigned long getUniqueId() const { return m_uniqueId; }
    TQString getLabel() const { return m_label; }
    TQString getAuthor() const { return m_author; }
    TQString getCopyright() const { return m_copyright; }
    bool isSynth() const { return m_isSynth; }
    bool isEffect() const { // true if >0 audio inputs
        for (unsigned int i = 0; i < m_ports.size(); ++i) {
            if ((m_ports[i]->getType() & PluginPort::Input) &&
                (m_ports[i]->getType() & PluginPort::Audio)) {
                return true;
            }
        }
        return false;
    }
    bool isGrouped() const { return m_isGrouped; }
    TQString getCategory() const { return m_category; }

    void addPort(int number,
                 const TQString &name,
                 PluginPort::PortType type,
                 PluginPort::PortDisplayHint hint,
                 PortData lowerBound,
                 PortData upperBound,
                 PortData defaultVale);

    typedef std::vector<PluginPort*>::iterator PortIterator;

    PortIterator begin() { return m_ports.begin(); }
    PortIterator end() { return m_ports.end(); }

    TQColor getColour() const { return m_colour; }
    void setColour(const TQColor &colour) { m_colour = colour; }

protected:

    TQString                    m_identifier;

    TQString                    m_name;
    unsigned long              m_uniqueId;
    TQString                    m_label;
    TQString                    m_author;
    TQString                    m_copyright;
    bool                       m_isSynth;
    bool                       m_isGrouped;
    TQString                    m_category;

    // our ports and associated hints
    std::vector<PluginPort*>   m_ports;

    // Colour of this activated plugin
    //
    TQColor                    m_colour;
};

typedef std::vector<AudioPlugin*>::iterator PluginIterator;


}

#endif
