/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>
 
    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "PasteNotationDialog.h"

#include <tdelocale.h>
#include "commands/edit/PasteEventsCommand.h"
#include <kdialogbase.h>
#include <tqbuttongroup.h>
#include <tqcheckbox.h>
#include <tqobject.h>
#include <tqradiobutton.h>
#include <tqvbox.h>
#include <tqwidget.h>


namespace Rosegarden
{

PasteNotationDialog::PasteNotationDialog(TQWidget *parent,
        PasteEventsCommand::PasteType defaultType) :
        KDialogBase(parent, 0, true, i18n("Paste"), Ok | Cancel | Help ),
        m_defaultType(defaultType)
{
    setHelp("nv-paste-types");

    TQVBox *vbox = makeVBoxMainWidget();

    TQButtonGroup *pasteTypeGroup = new TQButtonGroup
                                   (1, Qt::Horizontal, i18n("Paste type"), vbox);

    PasteEventsCommand::PasteTypeMap pasteTypes =
        PasteEventsCommand::getPasteTypes();

    for (PasteEventsCommand::PasteTypeMap::iterator i = pasteTypes.begin();
            i != pasteTypes.end(); ++i) {

        TQRadioButton *button = new TQRadioButton(i->second, pasteTypeGroup);
        button->setChecked(m_defaultType == i->first);
        TQObject::connect(button, TQT_SIGNAL(clicked()),
                         this, TQT_SLOT(slotPasteTypeChanged()));

        m_pasteTypeButtons.push_back(button);
    }

    TQButtonGroup *setAsDefaultGroup = new TQButtonGroup
                                      (1, Qt::Horizontal, i18n("Options"), vbox);

    m_setAsDefaultButton = new TQCheckBox
                           (i18n("Make this the default paste type"), setAsDefaultGroup);
    m_setAsDefaultButton->setChecked(true);
}

PasteEventsCommand::PasteType
PasteNotationDialog::getPasteType() const
{
    for (unsigned int i = 0; i < m_pasteTypeButtons.size(); ++i) {
        if (m_pasteTypeButtons[i]->isChecked()) {
            return (PasteEventsCommand::PasteType)i;
        }
    }

    return PasteEventsCommand::Restricted;
}

bool
PasteNotationDialog::setAsDefault() const
{
    return m_setAsDefaultButton->isChecked();
}

void
PasteNotationDialog::slotPasteTypeChanged()
{
    m_setAsDefaultButton->setChecked(m_defaultType == getPasteType());
}

}
#include "PasteNotationDialog.moc"
