#################################################
#
#  (C) 2011 Timothy Pearson
#  kb9vqf (AT) pearsoncomputing.net
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support #########

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( )


# Initialize some variables
SET(HAVE_XFT FALSE)
SET(HAVE_ALSA FALSE)
SET(HAVE_JACK FALSE)
SET(HAVE_DSSI FALSE)
SET(HAVE_LIBLO FALSE)
SET(HAVE_LIBLRDF FALSE)
SET(HAVE_LADSPA FALSE)
SET(HAVE_LIRC FALSE)
SET(HAVE_FFTW3F FALSE)

# Check for Xft
PKG_CHECK_MODULES(XFT xft>=2.1.0)
IF(XFT_FOUND)
    ADD_DEFINITIONS(-DHAVE_XFT)
    SET(HAVE_XFT TRUE)
    SET(XFT_LIBS ${XFT_LIBRARIES})
    #MESSAGE("XFT_LIBS: ${XFT_LIBS}")
    LIST(APPEND XFT_LIB_DIR ${XFT_LIBRARY_DIRS} ${XFT_LIBDIR})
    #MESSAGE("XFT_LIB_DIR: ${XFT_LIB_DIR}")
    LIST(APPEND XFT_INC_DIR ${XFT_INCLUDE_DIRS} ${XFT_INCLUDEDIR})
    #MESSAGE("XFT_INC_DIR: ${XFT_INC_DIR}")
ENDIF(XFT_FOUND)

IF(WANT_SOUND)

    # Check for ALSA 1.0
    PKG_CHECK_MODULES(ALSA REQUIRED alsa>=1.0)
    IF(ALSA_FOUND)
        SET(HAVE_ALSA TRUE)
        ADD_DEFINITIONS(-DHAVE_ALSA)
        SET(ALSA_LIBS ${ALSA_LIBRARIES})
        #MESSAGE("ALSA_LIBS: ${ALSA_LIBS}")
        LIST(APPEND ALSA_LIB_DIR ${ALSA_LIBRARY_DIRS} ${ALSA_LIBDIR} )
        #MESSAGE("ALSA_LIB_DIR: ${ALSA_LIB_DIR}")
        LIST(APPEND ALSA_INC_DIR ${ALSA_INCLUDE_DIRS} ${ALSA_INCLUDEDIR})
        #MESSAGE("ALSA_INC_DIR: ${ALSA_INC_DIR}")
    ELSE(ALSA_FOUND)
        MESSAGE(FATAL_ERROR "Please install the required package. Aborting")
    ENDIF(ALSA_FOUND)

    IF(WANT_JACK)
        PKG_CHECK_MODULES(JACK jack>=0.77)
        IF(JACK_FOUND)
            ADD_DEFINITIONS(-DHAVE_LIBJACK)
            SET(HAVE_JACK TRUE)
            SET(JACK_LIBS ${JACK_LIBRARIES})
            #MESSAGE("JACK_LIBS: ${JACK_LIBS}")
            LIST(APPEND JACK_LIB_DIR ${JACK_LIBDIR} ${JACK_LIBRARY_DIRS})
            #MESSAGE("JACK_LIB_DIR: ${JACK_LIB_DIR}")
            LIST(APPEND JACK_INC_DIR ${JACK_INCLUDEDIR} ${JACK_INCLUDE_DIRS})
            #MESSAGE("JACK_INC_DIR: ${JACK_INC_DIR}")
        ENDIF(JACK_FOUND)
    ENDIF(WANT_JACK)

    IF(WANT_DSSI)
        PKG_CHECK_MODULES(DSSI dssi>=0.4)
        IF(DSSI_FOUND)
            ADD_DEFINITIONS(-DHAVE_DSSI)
            SET(HAVE_DSSI TRUE)
            LIST(APPEND DSSI_INC_DIR ${DSSI_INCLUDE_DIRS} ${DSSI_INCLUDEDIR})
            #MESSAGE("DSSI_INC_DIR: ${DSSI_INC_DIR}")
        ENDIF(DSSI_FOUND)
    ENDIF(WANT_DSSI)

    PKG_CHECK_MODULES(LIBLO liblo>=0.7)
    IF(LIBLO_FOUND)
        ADD_DEFINITIONS(-DHAVE_LIBLO)
        SET(HAVE_LIBLO TRUE)
        SET(LIBLO_LIBS ${LIBLO_LIBRARIES})
        #MESSAGE("LIBLO_LIBS: ${LIBLO_LIBS}")
        LIST(APPEND LIBLO_LIB_DIR ${LIBLO_LIBDIR} ${LIBLO_LIBRARY_DIRS})
        #MESSAGE("LIBLO_LIB_DIR: ${LIBLO_LIB_DIR}")
        LIST(APPEND LIBLO_INC_DIR ${LIBLO_INCLUDEDIR} ${LIBLO_INCLUDE_DIRS})
        #MESSAGE("LIBLO_INC_DIR: ${LIBLO_INC_DIR}")
    ENDIF(LIBLO_FOUND)

    PKG_CHECK_MODULES(LRDF lrdf>=0.3)
    IF(LRDF_FOUND)
        SET(HAVE_LIBLRDF TRUE)
        ADD_DEFINITIONS(-DHAVE_LIBLRDF)
        SET(LRDF_LIBS ${LRDF_LIBRARIES})
        #MESSAGE("LRDF_LIBS: ${LRDF_LIBS}")
        LIST(APPEND LRDF_LIB_DIR ${LRDF_LIBDIR} ${LRDF_LIBRARY_DIRS})
        #MESSAGE("LRDF_LIB_DIR: ${LRDF_LIB_DIR}")
        LIST(APPEND LRDF_INC_DIR ${LRDF_INCLUDEDIR} ${LRDF_INCLUDE_DIRS})
        #MESSAGE("LRDF_INC_DIR: ${LRDF_INC_DIR}")
    ENDIF(LRDF_FOUND)

    ##################################################################
    # - Try to find LADSPA header
    # Once done this will define:
    #
    #  LADSPA_FOUND - system has LADSPA
    #  LADSPA_INCLUDE_DIR - LADSPA header path
    IF(LADSPA_INCLUDE_DIR)
       SET(LADSPA_FIND_QUIETLY TRUE)
    ENDIF(LADSPA_INCLUDE_DIR)
    FIND_PATH(LADSPA_INCLUDE_DIR "ladspa.h"
       /usr/include
       /usr/local/include
    )
    IF(LADSPA_INCLUDE_DIR)
       SET(LADSPA_FOUND TRUE)
    ELSE(LADSPA_INCLUDE_DIR)
       SET(LADSPA_FOUND FALSE)
       SET(LADSPA_INCLUDE_DIR "")
    ENDIF(LADSPA_INCLUDE_DIR)
    IF(LADSPA_FOUND)
        IF(NOT LADSPA_FIND_QUIETLY)
            MESSAGE(STATUS "Found LADSPA: ${LADSPA_INCLUDE_DIR}")
        ENDIF(NOT LADSPA_FIND_QUIETLY)
    ELSE(LADSPA_FOUND)
        IF(LADSPA_FIND_REQUIRED)
            MESSAGE(FATAL_ERROR "Could not find LADSPA")
        ENDIF(LADSPA_FIND_REQUIRED)
    ENDIF(LADSPA_FOUND)
    MARK_AS_ADVANCED(LADSPA_INCLUDE_DIR)
    ##################################################################

    IF(LADSPA_FOUND)
        SET(HAVE_LADSPA TRUE)
        ADD_DEFINITIONS(-DHAVE_LADSPA)
        SET(LADSPA_INC_DIR ${LADSPA_INCLUDE_DIR})
    ENDIF(LADSPA_FOUND)

ENDIF(WANT_SOUND)

PKG_CHECK_MODULES(FFTW3F REQUIRED fftw3f>=3.0.0)
IF(FFTW3F_FOUND)
    ADD_DEFINITIONS(-DHAVE_FFTW3F)
    SET(HAVE_FFTW3F TRUE)
    SET(FFTW3F_LIBS ${FFTW3F_LIBRARIES})
    #MESSAGE("FFTW3F_LIBS: ${FFTW3F_LIBS}")
    LIST(APPEND FFTW3F_LIB_DIR ${FFTW3F_LIBDIR} ${FFTW3F_LIBRARY_DIRS})
    #MESSAGE("FFTW3F_LIB_DIR: ${FFTW3F_LIB_DIR}")
    LIST(APPEND FFTW3F_INC_DIR ${FFTW3F_INCLUDEDIR} ${FFTW3F_INCLUDE_DIRS})
    #MESSAGE("FFTW3F_INC_DIR: ${FFTW3F_INC_DIR}")
ELSE(FFTW3F_FOUND)
    MESSAGE(FATAL_ERROR "Please install the required package. Aborting")
ENDIF(FFTW3F_FOUND)

IF(WANT_LIRC)
    FIND_PACKAGE(LIRC QUIET)
    IF(LIRC_FOUND)
        SET(HAVE_LIRC TRUE)
        ADD_DEFINITIONS(-DHAVE_LIRC)
        MESSAGE(STATUS "Found LIRC (${LIRC_LIBRARY})")
        SET(LIRC_LIBS ${LIRC_LIBRARY})
        SET(LIRC_INC_DIR ${LIRC_INCLUDE_DIR})
        SET(LIRC_LIB_DIR ${LIRC_LIBRARY_DIR})
        #MESSAGE("LIRC_LIBS: ${LIRC_LIBS}")
        #MESSAGE("LIRC_LIB_DIR: ${LIRC_LIB_DIR}")
        #MESSAGE("LIRC_INC_DIR: ${LIRC_INC_DIR}")
    ENDIF(LIRC_FOUND)
ENDIF(WANT_LIRC)

# Check GCC for PCH support
SET(USE_PCH FALSE)
IF(WANT_PCH)
    FIND_PACKAGE(PCHSupport)
    IF(PCHSupport_FOUND)
        SET(USE_PCH TRUE)
        ADD_DEFINITIONS(-DUSE_PCH)
        MESSAGE(STATUS "Enabling precompiled headers for GCC ${gcc_compiler_version}")
    ENDIF(PCHSupport_FOUND)
ENDIF(WANT_PCH)

# Check PTHREAD_MUTEX_RECURSIVE
INCLUDE(CheckCSourceCompiles)
CHECK_C_SOURCE_COMPILES(
    "#include <pthread.h>
     int main(int argc, char **argv) {
         pthread_mutexattr_t attr;
         pthread_mutexattr_settype(&attr, PTHREAD_MUTEX_RECURSIVE);
         return 0;
     }" PTHREAD_HAS_MUTEX_RECURSIVE)
IF(PTHREAD_HAS_MUTEX_RECURSIVE)
    ADD_DEFINITIONS(-DHAVE_PTHREAD_MUTEX_RECURSIVE)
ENDIF(PTHREAD_HAS_MUTEX_RECURSIVE)
# End of PTHREAD_MUTEX_RECURSIVE Test

SET(CMAKE_CXX_FLAGS_RELEASE         "-O2 -w -fexceptions -DNDEBUG -include tqt.h")
SET(CMAKE_CXX_FLAGS_RELWITHDEBINFO  "-O2 -g -Wall -fexceptions -DDEBUG -include tqt.h")
SET(CMAKE_CXX_FLAGS_DEBUG           "-O0 -g3 -Wall -fexceptions -DDEBUG -include tqt.h")

MESSAGE(STATUS "Rosegarden ${VERSION} will be built for install into ${CMAKE_INSTALL_PREFIX}")

IF(WANT_DEBUG)
    IF(WANT_FULLDBG)
        MESSAGE(STATUS "Configured to compile including full debug information in the executables")
        SET(CMAKE_BUILD_TYPE Debug CACHE STRING
            "Choose the type of build, options are: Debug Release RelWithDebInfo" FORCE)
    ELSE(WANT_FULLDBG)
        MESSAGE(STATUS "Configured to compile including debug information in the executables")
        SET(CMAKE_BUILD_TYPE RelWithDebInfo CACHE STRING
            "Choose the type of build, options are: Debug Release RelWithDebInfo" FORCE)
    ENDIF(WANT_FULLDBG)
ELSE(WANT_DEBUG)
    MESSAGE(STATUS "Configured to compile for release without debug information")
    SET(CMAKE_BUILD_TYPE Release CACHE STRING
        "Choose the type of build, options are: Debug Release RelWithDebInfo" FORCE)
ENDIF(WANT_DEBUG)
MARK_AS_ADVANCED(CMAKE_BUILD_TYPE)

check_type_size( "int" SIZEOF_INT BUILTIN_TYPES_ONLY )
check_type_size( "long" SIZEOF_LONG BUILTIN_TYPES_ONLY )

check_include_file( stdint.h HAVE_STDINT_H )
check_include_file( systems.h HAVE_SYSTEMS_H )
check_include_file( linux/inotify.h HAVE_INOTIFY )

check_function_exists( statvfs HAVE_STATVFS )
