
/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_AUDIOPLUGINMANAGER_H_
#define _RG_AUDIOPLUGINMANAGER_H_

#include "AudioPluginClipboard.h"
#include <tqmutex.h>
#include <tqstring.h>
#include <tqthread.h>
#include <vector>
#include "AudioPlugin.h"




namespace Rosegarden
{

class AudioPlugin;


class AudioPluginManager
{
public:
    AudioPluginManager();

    // Get a straight list of names
    //
    std::vector<TQString> getPluginNames();

    // Some useful members
    //
    AudioPlugin* getPlugin(int number);

    AudioPlugin* getPluginByIdentifier(TQString identifier);
    int getPositionByIdentifier(TQString identifier);

    // Deprecated -- the GUI shouldn't be using unique ID because it's
    // bound to a particular plugin type (and not necessarily unique
    // anyway).  It should use the identifier instead, which is a
    // structured string managed by the sequencer.  Keep this in only
    // for compatibility with old .rg files.
    //
    AudioPlugin* getPluginByUniqueId(unsigned long uniqueId);

    PluginIterator begin();
    PluginIterator end();

    // Sample rate
    //
    void setSampleRate(unsigned int rate) { m_sampleRate = rate; }
    unsigned int getSampleRate() const { return m_sampleRate; }

    AudioPluginClipboard* getPluginClipboard() { return &m_pluginClipboard; }

protected:
    AudioPlugin* addPlugin(const TQString &identifier,
                           const TQString &name,
                           unsigned long uniqueId,
                           const TQString &label,
                           const TQString &author,
                           const TQString &copyright,
                           bool isSynth,
                           bool isGrouped,
                           const TQString &category);

    bool removePlugin(const TQString &identifier);

    class Enumerator : public TQThread
    {
    public:
        Enumerator(AudioPluginManager *);
        virtual void run();
        bool isDone() const { return m_done; }
        
    protected:
        AudioPluginManager *m_manager;
        bool m_done;
    };

    void awaitEnumeration();
    void fetchSampleRate();

    std::vector<AudioPlugin*> m_plugins;
    unsigned int              m_sampleRate;
    AudioPluginClipboard      m_pluginClipboard;
    Enumerator                m_enumerator;
    TQMutex                    m_mutex;
};



}

#endif
