/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#ifndef _RG_CHORDXMLHANDLER_H_
#define _RG_CHORDXMLHANDLER_H_

#include "gui/general/ProgressReporter.h"
#include "Chord.h"
#include "ChordMap.h"

#include <tqxml.h>


namespace Rosegarden
{

class ChordXmlHandler : public ProgressReporter, public TQXmlDefaultHandler
{
public:
	ChordXmlHandler(Guitar::ChordMap&);
    virtual ~ChordXmlHandler();
    
    /// overloaded handler functions
    virtual bool startDocument();
    virtual bool startElement(const TQString& namespaceURI,
                              const TQString& localName,
                              const TQString& qName,
                              const TQXmlAttributes& atts);

    virtual bool endElement(const TQString& namespaceURI,
                            const TQString& localName,
                            const TQString& qName);

    virtual bool characters(const TQString& ch);

    virtual bool endDocument ();

    /// Return the error string set during the parsing (if any)
    TQString errorString() { return m_errorString; }
    bool error(const TQXmlParseException& exception);
    bool fatalError(const TQXmlParseException& exception);

protected:

    bool parseFingering(const TQString& ch);

    Guitar::Chord m_currentChord;
    TQString m_currentRoot;
    TQString m_errorString;
    bool m_inFingering;
    Guitar::ChordMap& m_chordMap;
};

}

#endif /*_RG_CHORDXMLHANDLER_H_*/
