/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _AUDIO_FILE_TIME_STRETCHER_H_
#define _AUDIO_FILE_TIME_STRETCHER_H_

#include <tqobject.h>
#include "AudioFile.h"
#include "base/Exception.h"

namespace Rosegarden {

class AudioFileManager;

class AudioFileTimeStretcher : public TQObject
{
    Q_OBJECT
  
    
public:
    AudioFileTimeStretcher(AudioFileManager *mgr);
    virtual ~AudioFileTimeStretcher();

    /**
     * Stretch an audio file and return the ID of the stretched
     * version.  May throw SoundFile::BadSoundFileException,
     * AudioFileManager::BadAudioPathException, CancelledException
     */
    AudioFileId getStretchedAudioFile(AudioFileId source,
                                      float ratio);

    class CancelledException : public Exception
    {
    public:
	CancelledException() : Exception("Cancelled") { }
	~CancelledException() throw() { }
    };

signals:
    void setProgress(int);

public slots:
    /**
     * Cancel an ongoing getStretchedAudioFile
     */
    void slotStopTimestretch();
    
protected:
    AudioFileManager *m_manager;

    bool m_timestretchCancelled;
};

}

#endif
