/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_EVENTEDITDIALOG_H_
#define _RG_EVENTEDITDIALOG_H_

#include "base/Event.h"
#include "gui/editors/notation/NotePixmapFactory.h"
#include <string>
#include <kdialogbase.h>


class TQWidget;
class TQString;
class TQScrollView;
class TQLabel;
class TQGrid;


namespace Rosegarden
{

class PropertyName;


class EventEditDialog : public KDialogBase
{
    Q_OBJECT
  

public:
    /**
     * Construct an event-edit dialog showing the properties of the
     * given event.  If editable is false, the user will not be allowed
     * to modify the event; otherwise the event will be editable and
     * the resulting edited version can subsequently be queried
     * through getEvent().
     */
    EventEditDialog(TQWidget *parent,
                    const Event &event,
                    bool editable = true);

    bool isModified() const { return m_modified; }
    Event getEvent() const;

public slots:
    void slotEventTypeChanged(const TQString &);
    void slotAbsoluteTimeChanged(int value);
    void slotDurationChanged(int value);
    void slotSubOrderingChanged(int value);

    void slotIntPropertyChanged(int);
    void slotRealTimePropertyChanged(int);
    void slotBoolPropertyChanged();
    void slotStringPropertyChanged(const TQString &);

    void slotPropertyDeleted();
    void slotPropertyMadePersistent();

protected:
    void addPersistentProperty(const PropertyName &);

    //--------------- Data members ---------------------------------
    NotePixmapFactory m_notePixmapFactory;

    TQLabel *m_durationDisplay;
    TQLabel *m_durationDisplayAux;

    TQGrid *m_persistentGrid;
    TQGrid *m_nonPersistentGrid;

    TQScrollView *m_nonPersistentView;

    const Event &m_originalEvent;
    Event m_event;

    std::string m_type;
    timeT m_absoluteTime;
    timeT m_duration;
    int m_subOrdering;

    bool m_modified;
};

/*
 * A simpler event editor for use by the EventView and MatrixView
 * and people who want to remain sane.
 */

}

#endif
