/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_COUNTDOWNDIALOG_H_
#define _RG_COUNTDOWNDIALOG_H_

#include <kdialogbase.h>
#include <tqdialog.h>


class TQWidget;
class TQString;
class TQPushButton;
class TQLabel;
class TQAccel;


namespace Rosegarden
{

class CountdownBar;


class CountdownDialog : public TQDialog // KDialogBase
{
    Q_OBJECT
  

public:
    CountdownDialog(TQWidget *parent, int seconds = 300);

    void setLabel(const TQString &label);
    void setElapsedTime(int seconds);

    int getTotalTime() const { return m_totalTime; }
    void setTotalTime(int seconds);

    TQAccel* getAccelerators() { return m_accelerators; }

signals:
    void completed(); // m_totalTime has elapsed
    void stopped();   // someone pushed the stop button

protected:
    void setPastEndMode();

    bool          m_pastEndMode;

    int           m_totalTime;

    TQLabel       *m_label;
    TQLabel       *m_time;
    CountdownBar *m_progressBar;

    TQPushButton  *m_stopButton;

    int           m_progressBarWidth;
    int           m_progressBarHeight;

    TQAccel       *m_accelerators;
};


}

#endif
