/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_AUDIOSPLITDIALOG_H_
#define _RG_AUDIOSPLITDIALOG_H_

#include <kdialogbase.h>
#include <vector>
#include <tqspinbox.h>


class TQWidget;
class TQCanvasView;
class TQCanvasRectangle;
class TQCanvas;


namespace Rosegarden
{

class Segment;
class RosegardenGUIDoc;


class AudioSplitDialog : public KDialogBase
{
    Q_OBJECT
  
public:
    AudioSplitDialog(TQWidget *parent,
                     Segment *segment,
                     RosegardenGUIDoc *doc);

    // Draw an audio preview over the segment and draw
    // the potential splits along it.
    //
    void drawPreview();
    void drawSplits(int threshold);

    // Get the threshold
    //
    int getThreshold() { return m_thresholdSpin->value(); }

public slots:
    void slotThresholdChanged(int);

protected:
    RosegardenGUIDoc              *m_doc;
    Segment           *m_segment;
    TQCanvas                       *m_canvas;
    TQCanvasView                   *m_canvasView;
    TQSpinBox                      *m_thresholdSpin;

    int                            m_canvasWidth;
    int                            m_canvasHeight;
    int                            m_previewWidth;
    int                            m_previewHeight;

    std::vector<TQCanvasRectangle*> m_previewBoxes;

};



}

#endif
