/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_TIMESIGNATUREDIALOG_H_
#define _RG_TIMESIGNATUREDIALOG_H_

#include "base/NotationTypes.h"
#include <kdialogbase.h>
#include <tqstring.h>
#include "base/Event.h"


class TQWidget;
class TQRadioButton;
class TQLabel;
class TQCheckBox;


namespace Rosegarden
{

class TimeWidget;
class Composition;


class TimeSignatureDialog : public KDialogBase
{
    Q_OBJECT
  

public:
    TimeSignatureDialog(TQWidget *parent,
                        Composition *composition,
                        timeT insertionTime,
                        TimeSignature defaultSig =
                            TimeSignature::DefaultTimeSignature,
                        bool timeEditable = false,
                        TQString explanatoryText = 0);

    TimeSignature getTimeSignature() const;

    timeT getTime() const;
    bool shouldNormalizeRests() const;

public slots:
    void slotNumUp();
    void slotNumDown();
    void slotDenomUp();
    void slotDenomDown();
    void slotUpdateCommonTimeButton();

protected:
    //--------------- Data members ---------------------------------

    Composition *m_composition;
    TimeSignature m_timeSignature;
    timeT m_time;

    TQLabel *m_numLabel;
    TQLabel *m_denomLabel;
    TQLabel *m_explanatoryLabel;

    TQCheckBox *m_commonTimeButton;
    TQCheckBox *m_hideSignatureButton;
    TQCheckBox *m_hideBarsButton;
    TQCheckBox *m_normalizeRestsButton;

    TQRadioButton *m_asGivenButton;
    TQRadioButton *m_startOfBarButton;

    TimeWidget *m_timeEditor;
};



}

#endif
