#!/bin/bash
QT_VERSION=@QT_VERSION@

if [[ $1 == "" ]]; then
	echo "Usage: tqt-replace <input_file>"
else
	if [[ $QT_VERSION == 3 ]]; then
		sed -i 's/^TQ\([^T_]\)/Q\1/g' "$1"
		sed -i 's/\([^_]\)TQ\([^T_]\)/\1Q\2/g' "$1"
		sed -i 's/TQT\([^_]\)/QT\1/g' "$1"
		sed -i 's/Q_SLOTS>/slots>/g' "$1"
		sed -i 's/Q_SIGNALS>/signals>/g' "$1"
		sed -i 's/Q\([^ _]*\)_OBJECT_NAME_STRING/TQ\1_OBJECT_NAME_STRING/g' "$1"
		sed -i 's/tqApp/qApp/g' "$1"
		sed -i 's/\([ \t]\)tq\([^:(_)\t ]\)/\1\2/g' "$1"
		sed -i 's/TQ_PROPERTY/Q_PROPERTY/g' "$1"
		sed -i 's/TQ_ENUMS/Q_ENUMS/g' "$1"
		sed -i 's/TQ_SETS/Q_SETS/g' "$1"
		sed -i 's/TQ_OVERRIDE/Q_OVERRIDE/g' "$1"
		sed -i 's/TQ_CLASSINFO/Q_CLASSINFO/g' "$1"
		sed -i 's/Qt::Orientation/Orientation/g' "$1"
		sed -i 's/TQ_INT8/Q_INT8/g' "$1"
		sed -i 's/TQ_INT16/Q_INT16/g' "$1"
		sed -i 's/TQ_INT32/Q_INT32/g' "$1"
		sed -i 's/TQ_INT64/Q_INT64/g' "$1"
		sed -i 's/TQ_UINT8/Q_UINT8/g' "$1"
		sed -i 's/TQ_UINT16/Q_UINT16/g' "$1"
		sed -i 's/TQ_UINT32/Q_UINT32/g' "$1"
		sed -i 's/TQ_UINT64/Q_UINT64/g' "$1"
		sed -i 's/TQ_LONG/Q_LONG/g' "$1"
		sed -i 's/TQ_LLONG/Q_LLONG/g' "$1"
		sed -i 's/TQ_ULONG/Q_ULONG/g' "$1"
		sed -i 's/TQ_ULLONG/Q_ULLONG/g' "$1"
		exit 0
	fi

	if [[ $QT_VERSION == 4 ]]; then
		sed -i 's/TQAccel/Q3Accel/g' "$1"
		sed -i 's/TQAccessible/QAccessible/g' "$1"
		sed -i 's/TQAccessibleObject/QAccessibleObject/g' "$1"
		sed -i 's/TQAction/Q3Action/g' "$1"
		sed -i 's/TQActionGroup/Q3ActionGroup/g' "$1"
		sed -i 's/TQApplication/QApplication/g' "$1"
		sed -i 's/TQAsciiCache/Q3AsciiCache/g' "$1"
		sed -i 's/TQAsciiCacheIterator/Q3AsciiCacheIterator/g' "$1"
		sed -i 's/TQAsciiDict/Q3AsciiDict/g' "$1"
		sed -i 's/TQAsciiDictIterator/Q3AsciiDictIterator/g' "$1"
		sed -i 's/TQImageConsumer/QImageConsumer/g' "$1"
		sed -i 's/TQImageFormat/QImageFormat/g' "$1"
		sed -i 's/TQImageFormatType/QImageFormatType/g' "$1"
		sed -i 's/TQImageDecoder/QImageDecoder/g' "$1"
		sed -i 's/TQAsyncIO/QAsyncIO/g' "$1"
		sed -i 's/TQByteArray/QByteArray/g' "$1"
		sed -i 's/TQDataSink/QDataSink/g' "$1"
		sed -i 's/TQDataSource/QDataSource/g' "$1"
		sed -i 's/TQIODeviceSource/QIODeviceSource/g' "$1"
		sed -i 's/TQDataPump/QDataPump/g' "$1"
		sed -i 's/TQBig5Codec/QBig5Codec/g' "$1"
		sed -i 's/TQBig5hkscsCodec/QBig5hkscsCodec/g' "$1"
		sed -i 's/TQBitVal/QBitVal/g' "$1"
		sed -i 's/TQBitArray/QBitArray/g' "$1"
		sed -i 's/TQBitmap/QBitmap/g' "$1"
		sed -i 's/TQBrush/QBrush/g' "$1"
		sed -i 's/TQBuffer/QBuffer/g' "$1"
		sed -i 's/TQButtonGroup/Q3ButtonGroup/g' "$1"
		sed -i 's/TQButton/Q3Button/g' "$1"
		sed -i 's/TQCache/Q3Cache/g' "$1"
		sed -i 's/TQCacheIterator/Q3CacheIterator/g' "$1"
		sed -i 's/TQCanvasChunk/Q3CanvasChunk/g' "$1"
		sed -i 's/TQCanvasItemList/Q3CanvasItemList/g' "$1"
		sed -i 's/TQCanvasItemExtra/Q3CanvasItemExtra/g' "$1"
		sed -i 's/TQCanvasItem/Q3CanvasItem/g' "$1"
		sed -i 's/TQCanvasData/Q3CanvasData/g' "$1"
		sed -i 's/TQCanvas/Q3Canvas/g' "$1"
		sed -i 's/TQCanvasViewData/Q3CanvasViewData/g' "$1"
		sed -i 's/TQCanvasView/Q3CanvasView/g' "$1"
		sed -i 's/TQCanvasPixmap/Q3CanvasPixmap/g' "$1"
		sed -i 's/TQCanvasPixmapArray/Q3CanvasPixmapArray/g' "$1"
		sed -i 's/TQCanvasSprite/Q3CanvasSprite/g' "$1"
		sed -i 's/TQPolygonalProcessor/QPolygonalProcessor/g' "$1"
		sed -i 's/TQCanvasPolygonalItem/Q3CanvasPolygonalItem/g' "$1"
		sed -i 's/TQCanvasRectangle/Q3CanvasRectangle/g' "$1"
		sed -i 's/TQCanvasPolygon/Q3CanvasPolygon/g' "$1"
		sed -i 's/TQCanvasSpline/Q3CanvasSpline/g' "$1"
		sed -i 's/TQCanvasLine/Q3CanvasLine/g' "$1"
		sed -i 's/TQCanvasEllipse/Q3CanvasEllipse/g' "$1"
		sed -i 's/TQCanvasTextExtra/Q3CanvasTextExtra/g' "$1"
		sed -i 's/TQCanvasText/Q3CanvasText/g' "$1"
		sed -i 's/TQCDEStyle/QCDEStyle/g' "$1"
		sed -i 's/TQCheckBox/QCheckBox/g' "$1"
		sed -i 's/TQCleanupHandler/QCleanupHandler/g' "$1"
		sed -i 's/TQSingleCleanupHandler/QSingleCleanupHandler/g' "$1"
		sed -i 's/TQSharedCleanupHandler/QSharedCleanupHandler/g' "$1"
		sed -i 's/TQShared/Q3Shared/g' "$1"
		sed -i 's/TQColor/QColor/g' "$1"
		sed -i 's/TQColorDialog/QColorDialog/g' "$1"
#		sed -i 's/TQStrList/QStrList/g' "$1"
#		sed -i 's/TQStringList/QStringList/g' "$1"
		sed -i 's/TQStringPairList/Q3StringPairList/g' "$1"
		sed -i 's/TQLineEdit/QLineEdit/g' "$1"
		sed -i 's/TQValidator/QValidator/g' "$1"
		sed -i 's/TQListBox/QListBox/g' "$1"
		sed -i 's/TQComboBoxData/Q3ComboBoxData/g' "$1"
		sed -i 's/TQComboTableItem/Q3ComboTableItem/g' "$1"
		sed -i 's/TQWheelEvent/QWheelEvent/g' "$1"
		sed -i 's/TQComboBox/Q3ComboBox/g' "$1"
		sed -i 's/TQCommonStyle/QCommonStyle/g' "$1"
		sed -i 's/TQCompactStyle/QCompactStyle/g' "$1"
		sed -i 's/TQConnection/QConnection/g' "$1"
		sed -i 's/TQCString/Q3CString/g' "$1"
		sed -i 's/TQCursor/QCursor/g' "$1"
		sed -i 's/TQSqlForm/QSqlForm/g' "$1"
		sed -i 's/TQDataBrowserPrivate/Q3DataBrowserPrivate/g' "$1"
		sed -i 's/TQDataBrowser/Q3DataBrowser/g' "$1"
		sed -i 's/TQDataStream/QDataStream/g' "$1"
		sed -i 's/TQPainter/QPainter/g' "$1"
		sed -i 's/TQSqlField/QSqlField/g' "$1"
		sed -i 's/TQSqlPropertyMap/QSqlPropertyMap/g' "$1"
		sed -i 's/TQDataTablePrivate/QDataTablePrivate/g' "$1"
		sed -i 's/TQDataTable/Q3DataTable/g' "$1"
		sed -i 's/TQDataView/Q3DataView/g' "$1"
		sed -i 's/TQDateEdit/Q3DateEdit/g' "$1"
		sed -i 's/TQTimeEdit/Q3TimeEdit/g' "$1"
		sed -i 's/TQDateTimeEdit/Q3DateTimeEdit/g' "$1"
		sed -i 's/TQDateTimeEditBase/Q3DateTimeEditBase/g' "$1"
		sed -i 's/TQDate/QDate/g' "$1"
		sed -i 's/TQTime/QTime/g' "$1"
		sed -i 's/TQDateTime/Q3DateTime/g' "$1"
		sed -i 's/TQDeepCopy/Q3DeepCopy/g' "$1"
		sed -i 's/TQDesktopWidget/QDesktopWidget/g' "$1"
		sed -i 's/TQDial/QDial/g' "$1"
		sed -i 's/TQDialog/QDialog/g' "$1"
		sed -i 's/TQDict/Q3Dict/g' "$1"
		sed -i 's/TQDictIterator/Q3DictIterator/g' "$1"
		sed -i 's/TQDir/QDir/g' "$1"
		sed -i 's/TQDirLineEdit/QDirLineEdit/g' "$1"
		sed -i 's/TQDirMultiLineEdit/QDirMultiLineEdit/g' "$1"
		sed -i 's/TQDns/Q3Dns/g' "$1"
		sed -i 's/TQDnsSocket/QDnsSocket/g' "$1"
		sed -i 's/TQDockArea/Q3DockArea/g' "$1"
		sed -i 's/TQDockAreaLayout/QDockAreaLayout/g' "$1"
		sed -i 's/TQDockWindow/Q3DockWindow/g' "$1"
		sed -i 's/TQDomImplementation/QDomImplementation/g' "$1"
		sed -i 's/TQDomNodeList/QDomNodeList/g' "$1"
		sed -i 's/TQDomDocumentType/QDomDocumentType/g' "$1"
		sed -i 's/TQDomDocument/QDomDocument/g' "$1"
		sed -i 's/TQDomNamedNodeMap/QDomNamedNodeMap/g' "$1"
		sed -i 's/TQDomDocumentFragment/QDomDocumentFragment/g' "$1"
		sed -i 's/TQDomCharacterData/QDomCharacterData/g' "$1"
		sed -i 's/TQDomAttr/QDomAttr/g' "$1"
		sed -i 's/TQDomElement/QDomElement/g' "$1"
		sed -i 's/TQDomText/QDomText/g' "$1"
		sed -i 's/TQDomComment/QDomComment/g' "$1"
		sed -i 's/TQDomCDATASection/QDomCDATASection/g' "$1"
		sed -i 's/TQDomNotation/QDomNotation/g' "$1"
		sed -i 's/TQDomEntity/QDomEntity/g' "$1"
		sed -i 's/TQDomEntityReference/QDomEntityReference/g' "$1"
		sed -i 's/TQDomProcessingInstruction/QDomProcessingInstruction/g' "$1"
		sed -i 's/TQDomNode/QDomNode/g' "$1"
		sed -i 's/TQDragObject/Q3DragObject/g' "$1"
		sed -i 's/TQStoredDrag/Q3StoredDrag/g' "$1"
		sed -i 's/TQTextDrag/Q3TextDrag/g' "$1"
		sed -i 's/TQImageDrag/Q3ImageDrag/g' "$1"
		sed -i 's/TQUriDrag/Q3UriDrag/g' "$1"
		sed -i 's/TQColorDrag/Q3ColorDrag/g' "$1"
		sed -i 's/TQDropSite/Q3DropSite/g' "$1"
		sed -i 's/TQEditorFactory/Q3EditorFactory/g' "$1"
		sed -i 's/TQErrorMessage/QErrorMessage/g' "$1"
		sed -i 's/TQEucJpCodec/QEucJpCodec/g' "$1"
		sed -i 's/TQEucKrCodec/QEucKrCodec/g' "$1"
		sed -i 's/TQEvent/QEvent/g' "$1"
		sed -i 's/TQTimerEvent/QTimerEvent/g' "$1"
		sed -i 's/TQMouseEvent/QMouseEvent/g' "$1"
		sed -i 's/TQWheelEvent/QWheelEvent/g' "$1"
		sed -i 's/TQTabletEvent/QTabletEvent/g' "$1"
		sed -i 's/TQKeyEvent/QKeyEvent/g' "$1"
		sed -i 's/TQFocusEvent/QFocusEvent/g' "$1"
		sed -i 's/TQPaintEvent/QPaintEvent/g' "$1"
		sed -i 's/TQMoveEvent/QMoveEvent/g' "$1"
		sed -i 's/TQResizeEvent/QResizeEvent/g' "$1"
		sed -i 's/TQCloseEvent/QCloseEvent/g' "$1"
		sed -i 's/TQIconDragEvent/QIconDragEvent/g' "$1"
		sed -i 's/TQShowEvent/QShowEvent/g' "$1"
		sed -i 's/TQHideEvent/QHideEvent/g' "$1"
		sed -i 's/TQContextMenuEvent/QContextMenuEvent/g' "$1"
		sed -i 's/TQIMEvent/QIMEvent/g' "$1"
		sed -i 's/TQIMComposeEvent/QIMComposeEvent/g' "$1"
		sed -i 's/TQDropEvent/QDropEvent/g' "$1"
		sed -i 's/TQDragMoveEvent/QDragMoveEvent/g' "$1"
		sed -i 's/TQDragEnterEvent/QDragEnterEvent/g' "$1"
		sed -i 's/TQDragResponseEvent/QDragResponseEvent/g' "$1"
		sed -i 's/TQDragLeaveEvent/QDragLeaveEvent/g' "$1"
		sed -i 's/TQChildEvent/QChildEvent/g' "$1"
		sed -i 's/TQCustomEvent/QCustomEvent/g' "$1"
		sed -i 's/TQEventLoop/QEventLoop/g' "$1"
		sed -i 's/TQFileIconProvider/Q3FileIconProvider/g' "$1"
		sed -i 's/TQFilePreview/Q3FilePreview/g' "$1"
		sed -i 's/TQFileDialog/Q3FileDialog/g' "$1"
		sed -i 's/TQFile/QFile/g' "$1"
		sed -i 's/TQFileInfo/QFileInfo/g' "$1"
		sed -i 's/TQFileInfoList/QFileInfoList/g' "$1"
		sed -i 's/TQFileInfoListIterator/QFileInfoListIterator/g' "$1"
		sed -i 's/TQFocusData/QFocusData/g' "$1"
		sed -i 's/TQFontDatabase/QFontDatabase/g' "$1"
		sed -i 's/TQFont/QFont/g' "$1"
		sed -i 's/TQFontInfo/QFontInfo/g' "$1"
		sed -i 's/TQFontMetrics/QFontMetrics/g' "$1"
		sed -i 's/TQFrame/Q3Frame/g' "$1"
		sed -i 's/TQFtp/Q3Ftp/g' "$1"
		sed -i 's/TQGArray/QGArray/g' "$1"
		sed -i 's/TQGb18030Codec/QGb18030Codec/g' "$1"
		sed -i 's/TQGbkCodec/QGbkCodec/g' "$1"
		sed -i 's/TQGb2312Codec/QGb2312Codec/g' "$1"
		sed -i 's/TQGCache/QGCache/g' "$1"
		sed -i 's/TQGCacheIterator/QGCacheIterator/g' "$1"
		sed -i 's/TQBaseBucket/QBaseBucket/g' "$1"
		sed -i 's/TQStringBucket/QStringBucket/g' "$1"
		sed -i 's/TQAsciiBucket/QAsciiBucket/g' "$1"
		sed -i 's/TQIntBucket/QIntBucket/g' "$1"
		sed -i 's/TQPtrBucket/QPtrBucket/g' "$1"
		sed -i 's/TQGDict/QGDict/g' "$1"
		sed -i 's/TQGDictIterator/QGDictIterator/g' "$1"
		sed -i 's/TQGLColormap/QGLColormap/g' "$1"
		sed -i 's/TQGL/QGL/g' "$1"
		sed -i 's/TQGLFormat/QGLFormat/g' "$1"
		sed -i 's/TQGLContext/QGLContext/g' "$1"
		sed -i 's/TQGLWidget/QGLWidget/g' "$1"
		sed -i 's/TQLNode/QLNode/g' "$1"
		sed -i 's/TQGList/QGList/g' "$1"
		sed -i 's/TQGListIterator/QGListIterator/g' "$1"
		sed -i 's/TQGListStdIterator/QGListStdIterator/g' "$1"
		sed -i 's/TQGPlugin/QGPlugin/g' "$1"
		sed -i 's/TQGrid/Q3Grid/g' "$1"
		sed -i 's/TQGridView/Q3GridView/g' "$1"
		sed -i 's/TQGroupBox/Q3GroupBox/g' "$1"
		sed -i 's/TQGuardedPtr/QGuardedPtr/g' "$1"
		sed -i 's/TQGuardedPtrPrivate/QGuardedPtrPrivate/g' "$1"
		sed -i 's/TQGVector/QGVector/g' "$1"
		sed -i 's/TQHBox/Q3HBox/g' "$1"
		sed -i 's/TQHButtonGroup/Q3HButtonGroup/g' "$1"
		sed -i 's/TQHeader/Q3Header/g' "$1"
		sed -i 's/TQHGroupBox/Q3HGroupBox/g' "$1"
		sed -i 's/TQHostAddress/QHostAddress/g' "$1"
		sed -i 's/TQHttpHeader/Q3HttpHeader/g' "$1"
		sed -i 's/TQHttpResponseHeader/Q3HttpResponseHeader/g' "$1"
		sed -i 's/TQHttpRequestHeader/Q3HttpRequestHeader/g' "$1"
		sed -i 's/TQHttp/Q3Http/g' "$1"
		sed -i 's/TQIconSet/QIconSet/g' "$1"
		sed -i 's/TQIconFactory/QIconFactory/g' "$1"
		sed -i 's/TQIconDragItem/Q3IconDragItem/g' "$1"
		sed -i 's/TQIconDrag/Q3IconDrag/g' "$1"
		sed -i 's/TQIconViewItem/Q3IconViewItem/g' "$1"
		sed -i 's/TQIconView/Q3IconView/g' "$1"
		sed -i 's/TQImageFormatPlugin/QImageFormatPlugin/g' "$1"
		sed -i 's/TQImageTextKeyLang/QImageTextKeyLang/g' "$1"
		sed -i 's/TQImage/QImage/g' "$1"
		sed -i 's/TQImageIO/QImageIO/g' "$1"
		sed -i 's/TQInputContextFactory/QInputContextFactory/g' "$1"
		sed -i 's/TQInputContext/QInputContext/g' "$1"
		sed -i 's/TQIntCache/Q3IntCache/g' "$1"
		sed -i 's/TQIntCacheIterator/Q3IntCacheIterator/g' "$1"
		sed -i 's/TQIntDict/Q3IntDict/g' "$1"
		sed -i 's/TQIntDictIterator/Q3IntDictIterator/g' "$1"
		sed -i 's/TQIODevice/QIODevice/g' "$1"
		sed -i 's/TQJisCodec/QJisCodec/g' "$1"
		sed -i 's/TQJpUnicodeConv/QJpUnicodeConv/g' "$1"
		sed -i 's/TQKeySequence/QKeySequence/g' "$1"
		sed -i 's/TQLabel/QLabel/g' "$1"
		sed -i 's/TQGLayoutIterator/QGLayoutIterator/g' "$1"
		sed -i 's/TQLayoutIterator/QLayoutIterator/g' "$1"
		sed -i 's/TQLayoutItem/QLayoutItem/g' "$1"
		sed -i 's/TQSpacerItem/QSpacerItem/g' "$1"
		sed -i 's/TQWidgetItem/QWidgetItem/g' "$1"
		sed -i 's/TQLayout/QLayout/g' "$1"
		sed -i 's/TQGridLayout/QGridLayout/g' "$1"
		sed -i 's/TQBoxLayout/QBoxLayout/g' "$1"
		sed -i 's/TQHBoxLayout/QHBoxLayout/g' "$1"
		sed -i 's/TQVBoxLayout/QVBoxLayout/g' "$1"
		sed -i 's/TQLCDNumber/QLCDNumber/g' "$1"
		sed -i 's/TQLibrary/QLibrary/g' "$1"
		sed -i 's/TQLineEdit/QLineEdit/g' "$1"
		sed -i 's/TQListBox/Q3ListBox/g' "$1"
		sed -i 's/TQListBoxItem/Q3ListBoxItem/g' "$1"
		sed -i 's/TQListBoxText/Q3ListBoxText/g' "$1"
		sed -i 's/TQListBoxPixmap/Q3ListBoxPixmap/g' "$1"
		sed -i 's/TQListViewItem/Q3ListViewItem/g' "$1"
		sed -i 's/TQListView/Q3ListView/g' "$1"
		sed -i 's/TQCheckListItem/Q3CheckListItem/g' "$1"
		sed -i 's/TQListViewItemIterator/Q3ListViewItemIterator/g' "$1"
		sed -i 's/TQLocale/QLocale/g' "$1"
		sed -i 's/TQLocalFs/Q3LocalFs/g' "$1"
		sed -i 's/TQMainWindow/Q3MainWindow/g' "$1"
		sed -i 's/TQMapIterator/QMapIterator/g' "$1"
		sed -i 's/TQMapConstIterator/QMapConstIterator/g' "$1"
		sed -i 's/TQMapPrivateBase/QMapPrivateBase/g' "$1"
		sed -i 's/TQMapPrivate/QMapPrivate/g' "$1"
		sed -i 's/TQMap/QMap/g' "$1"
		sed -i 's/TQMemArray/Q3MemArray/g' "$1"
		sed -i 's/TQMenuBar/QMenuBar/g' "$1"
		sed -i 's/TQMenuItem/QMenuItem/g' "$1"
		sed -i 's/TQCustomMenuItem/QCustomMenuItem/g' "$1"
		sed -i 's/TQMenuData/QMenuData/g' "$1"
		sed -i 's/TQMessageBox/QMessageBox/g' "$1"
		sed -i 's/TQMetaProperty/QMetaProperty/g' "$1"
		sed -i 's/TQMetaObject/QMetaObject/g' "$1"
		sed -i 's/TQMetaObjectCleanUp/QMetaObjectCleanUp/g' "$1"
		sed -i 's/TQMimeSource/QMimeSource/g' "$1"
		sed -i 's/TQMimeSourceFactory/Q3MimeSourceFactory/g' "$1"
		sed -i 's/TQWindowsMime/QWindowsMime/g' "$1"
		sed -i 's/TQMacMime/QMacMime/g' "$1"
		sed -i 's/TQMotifPlusStyle/QMotifPlusStyle/g' "$1"
		sed -i 's/TQMotifStyle/QMotifStyle/g' "$1"
		sed -i 's/TQMovie/QMovie/g' "$1"
		sed -i 's/TQMultiLineEdit/Q3MultiLineEdit/g' "$1"
		sed -i 's/TQMutex/QMutex/g' "$1"
		sed -i 's/TQMutexLocker/QMutexLocker/g' "$1"
		sed -i 's/TQt/Qt/g' "$1"
		sed -i 's/TQInternal/QInternal/g' "$1"
		sed -i 's/TQNetworkProtocolFactoryBase/QNetworkProtocolFactoryBase/g' "$1"
		sed -i 's/TQNetworkProtocolFactory/QNetworkProtocolFactory/g' "$1"
		sed -i 's/TQNetworkProtocol/Q3NetworkProtocol/g' "$1"
		sed -i 's/TQNetworkOperation/Q3NetworkOperation/g' "$1"
		sed -i 's/TQObjectCleanupHandler/QObjectCleanupHandler/g' "$1"
		sed -i 's/TQObjectDictionary/QObjectDictionary/g' "$1"
		sed -i 's/TQObject/QObject/g' "$1"
		sed -i 's/TQObjectUserData/QObjectUserData/g' "$1"
		sed -i 's/TQObject/QObject/g' "$1"
		sed -i 's/TQObjectList/QObjectList/g' "$1"
		sed -i 's/TQObjectListIterator/QObjectListIterator/g' "$1"
		sed -i 's/TQObjectListIt/QObjectListIt/g' "$1"
		sed -i 's/TQPaintDevice/QPaintDevice/g' "$1"
		sed -i 's/TQPaintDeviceMetrics/Q3PaintDeviceMetrics/g' "$1"
		sed -i 's/TQPainter/Q3Painter/g' "$1"
		sed -i 's/TQColorGroup/QColorGroup/g' "$1"
		sed -i 's/TQPalette/QPalette/g' "$1"
		sed -i 's/TQPen/QPen/g' "$1"
		sed -i 's/TQPicture/Q3Picture/g' "$1"
		sed -i 's/TQPixmapCache/QPixmapCache/g' "$1"
		sed -i 's/TQPixmap/QPixmap/g' "$1"
		sed -i 's/TQPlatinumStyle/QPlatinumStyle/g' "$1"
		sed -i 's/TQPNGImageWriter/QPNGImageWriter/g' "$1"
		sed -i 's/TQPNGImagePacker/QPNGImagePacker/g' "$1"
		sed -i 's/TQPointArray/Q3PointArray/g' "$1"
		sed -i 's/TQPoint/QPoint/g' "$1"
		sed -i 's/TQPolygonScanner/QPolygonScanner/g' "$1"
		sed -i 's/TQPopupMenu/Q3PopupMenu/g' "$1"
		sed -i 's/TQPrintDialog/QPrintDialog/g' "$1"
		sed -i 's/TQPrinter/QPrinter/g' "$1"
		sed -i 's/TQProcess/Q3Process/g' "$1"
		sed -i 's/TQProgressBar/QP3rogressBar/g' "$1"
		sed -i 's/TQProgressDialog/Q3ProgressDialog/g' "$1"
		sed -i 's/TQPtrCollection/Q3PtrCollection/g' "$1"
		sed -i 's/TQPtrDict/Q3PtrDict/g' "$1"
		sed -i 's/TQPtrDictIterator/Q3PtrDictIterator/g' "$1"
		sed -i 's/TQPtrListStdIterator/Q3PtrListStdIterator/g' "$1"
		sed -i 's/TQPtrList/Q3PtrList/g' "$1"
		sed -i 's/TQPtrListIterator/Q3PtrListIterator/g' "$1"
		sed -i 's/TQPtrQueue/Q3PtrQueue/g' "$1"
		sed -i 's/TQPtrStack/Q3PtrStack/g' "$1"
		sed -i 's/TQPtrVector/Q3PtrVector/g' "$1"
		sed -i 's/TQPushButton/QPushButton/g' "$1"
		sed -i 's/TQRadioButton/QRadioButton/g' "$1"
		sed -i 's/TQRangeControl/Q3RangeControl/g' "$1"
		sed -i 's/TQSpinWidget/QSpinWidget/g' "$1"
		sed -i 's/TQRect/QRect/g' "$1"
		sed -i 's/TQRegExp/QRegExp/g' "$1"
		sed -i 's/TQRegion/QRegion/g' "$1"
		sed -i 's/TQHebrewCodec/QHebrewCodec/g' "$1"
		sed -i 's/TQScrollBar/QScrollBar/g' "$1"
		sed -i 's/TQScrollView/Q3ScrollView/g' "$1"
		sed -i 's/TQSemaphore/Q3Semaphore/g' "$1"
		sed -i 's/TQSemiModal/QSemiModal/g' "$1"
		sed -i 's/TQServerSocket/Q3ServerSocket/g' "$1"
		sed -i 's/TQSettings/QSettings/g' "$1"
		sed -i 's/TQSGIStyle/QSGIStyle/g' "$1"
		sed -i 's/TQSignal/Q3Signal/g' "$1"
		sed -i 's/TQSignalMapper/QSignalMapper/g' "$1"
		sed -i 's/TQConnectionList/QConnectionList/g' "$1"
		sed -i 's/TQConnectionListIt/QConnectionListIt/g' "$1"
		sed -i 's/TQSignalVec/QSignalVec/g' "$1"
		sed -i 's/TQSimpleRichText/Q3SimpleRichText/g' "$1"
		sed -i 's/TQSizeGrip/QSizeGrip/g' "$1"
		sed -i 's/TQSize/QSize/g' "$1"
		sed -i 's/TQSizePolicy/QSizePolicy/g' "$1"
		sed -i 's/TQSjisCodec/QSjisCodec/g' "$1"
		sed -i 's/TQSlider/QSlider/g' "$1"
		sed -i 's/TQSocketDevice/Q3SocketDevice/g' "$1"
		sed -i 's/TQSocket/Q3Socket/g' "$1"
		sed -i 's/TQSocketNotifier/QSocketNotifier/g' "$1"
		sed -i 's/TQSortedList/QSortedList/g' "$1"
		sed -i 's/TQSound/QSound/g' "$1"
		sed -i 's/TQSpinBox/QSpinBox/g' "$1"
		sed -i 's/TQSplashScreen/QSplashScreen/g' "$1"
		sed -i 's/TQSplitter/QSplitter/g' "$1"
		sed -i 's/TQSqlCursor/Q3SqlCursor/g' "$1"
		sed -i 's/TQSqlDatabase/QSqlDatabase/g' "$1"
		sed -i 's/TQSqlDriver/QSqlDriver/g' "$1"
		sed -i 's/TQSqlDriverPlugin/QSqlDriverPlugin/g' "$1"
		sed -i 's/TQSqlEditorFactory/Q3SqlEditorFactory/g' "$1"
		sed -i 's/TQSqlError/QSqlError/g' "$1"
		sed -i 's/TQSqlFieldPrivate/QSqlFieldPrivate/g' "$1"
		sed -i 's/TQSqlField/QSqlField/g' "$1"
		sed -i 's/TQSqlFieldInfo/Q3SqlFieldInfo/g' "$1"
		sed -i 's/TQSqlForm/Q3SqlForm/g' "$1"
		sed -i 's/TQSql/QSql/g' "$1"
		sed -i 's/TQSqlIndex/QSqlIndex/g' "$1"
		sed -i 's/TQSqlPropertyMap/Q3SqlPropertyMap/g' "$1"
		sed -i 's/TQSqlQuery/QSqlQuery/g' "$1"
		sed -i 's/TQSqlResultShared/QSqlResultShared/g' "$1"
		sed -i 's/TQSqlRecordShared/QSqlRecordShared/g' "$1"
		sed -i 's/TQSqlRecord/QSqlRecord/g' "$1"
		sed -i 's/TQSqlRecordInfo/Q3SqlRecordInfo/g' "$1"
		sed -i 's/TQSqlResult/QSqlResult/g' "$1"
		sed -i 's/TQSqlSelectCursorPrivate/QSqlSelectCursorPrivate/g' "$1"
		sed -i 's/TQSqlSelectCursor/Q3SqlSelectCursor/g' "$1"
		sed -i 's/TQStatusBar/QStatusBar/g' "$1"
		sed -i 's/TQChar/QChar/g' "$1"
		sed -i 's/TQString/QString/g' "$1"
		sed -i 's/TQCharRef/QCharRef/g' "$1"
		sed -i 's/TQConstString/QConstString/g' "$1"
#		sed -i 's/TQStringList/QStringList/g' "$1"
#		sed -i 's/TQStrListIterator/Q3StrListIterator/g' "$1"
#		sed -i 's/TQStrIList/Q3StrIList/g' "$1"
#		sed -i 's/TQStrList/Q3StrList/g' "$1"
#		sed -i 's/TQStrVec/QStrVec/g' "$1"
#		sed -i 's/TQStrIVec/QStrIVec/g' "$1"
		sed -i 's/TQStyleFactory/QStyleFactory/g' "$1"
		sed -i 's/TQStyleOption/QStyleOption/g' "$1"
		sed -i 's/TQStyle/QStyle/g' "$1"
		sed -i 's/TQStyleHintReturn/QStyleHintReturn/g' "$1"
		sed -i 's/TQStylePlugin/QStylePlugin/g' "$1"
		sed -i 's/TQStyleSheetItem/Q3StyleSheetItem/g' "$1"
		sed -i 's/TQStyleSheet/Q3StyleSheet/g' "$1"
		sed -i 's/TQSyntaxHighlighter/Q3SyntaxHighlighter/g' "$1"
		sed -i 's/TQTab/QTab/g' "$1"
		sed -i 's/TQTabBar/QTabBar/g' "$1"
		sed -i 's/TQTabDialog/Q3TabDialog/g' "$1"
		sed -i 's/TQTableSelection/Q3TableSelection/g' "$1"
		sed -i 's/TQTableItem/Q3TableItem/g' "$1"
		sed -i 's/TQComboTableItem/QComboTableItem/g' "$1"
		sed -i 's/TQCheckTableItem/Q3CheckTableItem/g' "$1"
		sed -i 's/TQTable/Q3Table/g' "$1"
		sed -i 's/TQTabWidget/QTabWidget/g' "$1"
		sed -i 's/TQTextBrowser/Q3TextBrowser/g' "$1"
		sed -i 's/TQTextCodecFactory/QTextCodecFactory/g' "$1"
		sed -i 's/TQTextEncoder/QTextEncoder/g' "$1"
		sed -i 's/TQTextDecoder/QTextDecoder/g' "$1"
		sed -i 's/TQTextCodec/QTextCodec/g' "$1"
		sed -i 's/TQTextCodecPlugin/QTextCodecPlugin/g' "$1"
		sed -i 's/TQTextEdit/Q3TextEdit/g' "$1"
		sed -i 's/TQTextStream/Q3TextStream/g' "$1"
		sed -i 's/TQTextIStream/QTextIStream/g' "$1"
		sed -i 's/TQTextOStream/QTextOStream/g' "$1"
		sed -i 's/TQTSManip/QTSManip/g' "$1"
		sed -i 's/TQTextView/Q3TextView/g' "$1"
		sed -i 's/TQThread/QThread/g' "$1"
		sed -i 's/TQThreadStorageData/QThreadStorageData/g' "$1"
		sed -i 's/TQThreadStorage/QThreadStorage/g' "$1"
		sed -i 's/TQTimer/QTimer/g' "$1"
		sed -i 's/TQTextOStreamIterator/QTextOStreamIterator/g' "$1"
		sed -i 's/TQBackInsertIterator/QBackInsertIterator/g' "$1"
		sed -i 's/TQtMsgType/QtMsgType/g' "$1"
		sed -i 's/TQtMsgHandler/QtMsgHandler/g' "$1"
		sed -i 's/TQToolBar/Q3ToolBar/g' "$1"
		sed -i 's/TQToolBox/QToolBox/g' "$1"
		sed -i 's/TQToolButton/QToolButton/g' "$1"
		sed -i 's/TQToolTipGroup/QToolTipGroup/g' "$1"
		sed -i 's/TQToolTip/QToolTip/g' "$1"
		sed -i 's/TQTsciiCodec/QTsciiCodec/g' "$1"
		sed -i 's/TQUrl/Q3Url/g' "$1"
		sed -i 's/TQUrlInfo/QUrlInfo/g' "$1"
		sed -i 's/TQUrlOperator/Q3UrlOperator/g' "$1"
		sed -i 's/TQUtf8Codec/QUtf8Codec/g' "$1"
		sed -i 's/TQUtf16Codec/QUtf16Codec/g' "$1"
		sed -i 's/TQValidator/QValidator/g' "$1"
		sed -i 's/TQIntValidator/QIntValidator/g' "$1"
		sed -i 's/TQDoubleValidator/QDoubleValidator/g' "$1"
		sed -i 's/TQRegExpValidator/QRegExpValidator/g' "$1"
		sed -i 's/TQValueListNode/QValueListNode/g' "$1"
		sed -i 's/TQValueListIterator/Q3ValueListIterator/g' "$1"
		sed -i 's/TQValueListConstIterator/Q3ValueListConstIterator/g' "$1"
		sed -i 's/TQValueListPrivate/QValueListPrivate/g' "$1"
		sed -i 's/TQValueList/Q3ValueList/g' "$1"
		sed -i 's/TQValueStack/Q3ValueStack/g' "$1"
		sed -i 's/TQValueVectorPrivate/QValueVectorPrivate/g' "$1"
		sed -i 's/TQValueVector/Q3ValueVector/g' "$1"
		sed -i 's/TQVariant/QVariant/g' "$1"
		sed -i 's/TQVBox/Q3VBox/g' "$1"
		sed -i 's/TQVButtonGroup/Q3VButtonGroup/g' "$1"
		sed -i 's/TQVGroupBox/Q3VGroupBox/g' "$1"
		sed -i 's/TQWaitCondition/QWaitCondition/g' "$1"
		sed -i 's/TQWhatsThis/Q3WhatsThis/g' "$1"
		sed -i 's/TQWidgetFactory/QWidgetFactory/g' "$1"
		sed -i 's/TQWidget/QWidget/g' "$1"
		sed -i 's/TQWidgetIntDict/QWidgetIntDict/g' "$1"
		sed -i 's/TQWidgetIntDictIt/QWidgetIntDictIt/g' "$1"
		sed -i 's/TQWidgetList/QWidgetList/g' "$1"
		sed -i 's/TQWidgetListIt/QWidgetListIt/g' "$1"
		sed -i 's/TQWidgetPlugin/QWidgetPlugin/g' "$1"
		sed -i 's/TQWidgetContainerPlugin/QWidgetContainerPlugin/g' "$1"
		sed -i 's/TQWidgetStack/Q3WidgetStack/g' "$1"
		sed -i 's/TQWidgetStackAccelManager/Q3WidgetStackAccelManager/g' "$1"
		sed -i 's/TQWindowsStyle/QWindowsStyle/g' "$1"
		sed -i 's/TQWizard/Q3Wizard/g' "$1"
		sed -i 's/TQWMatrix/QWMatrix/g' "$1"
		sed -i 's/TQWorkspace/QWorkspace/g' "$1"
		sed -i 's/TQXmlNamespaceSupport/QXmlNamespaceSupport/g' "$1"
		sed -i 's/TQXmlAttributes/QXmlAttributes/g' "$1"
		sed -i 's/TQXmlInputSource/QXmlInputSource/g' "$1"
		sed -i 's/TQXmlParseException/QXmlParseException/g' "$1"
		sed -i 's/TQXmlReader/QXmlReader/g' "$1"
		sed -i 's/TQXmlSimpleReader/QXmlSimpleReader/g' "$1"
		sed -i 's/TQXmlLocator/QXmlLocator/g' "$1"
		sed -i 's/TQXmlContentHandler/QXmlContentHandler/g' "$1"
		sed -i 's/TQXmlErrorHandler/QXmlErrorHandler/g' "$1"
		sed -i 's/TQXmlDTDHandler/QXmlDTDHandler/g' "$1"
		sed -i 's/TQXmlEntityResolver/QXmlEntityResolver/g' "$1"
		sed -i 's/TQXmlLexicalHandler/QXmlLexicalHandler/g' "$1"
		sed -i 's/TQXmlDeclHandler/QXmlDeclHandler/g' "$1"
		sed -i 's/TQXmlDefaultHandler/QXmlDefaultHandler/g' "$1"
		exit 0

# 		echo "ERROR: Not Yet Implemented"
# 		exit 1
	fi
fi
