#################################################
#
#  (C) 2010-2011 Serghei Amelian
#  serghei (DOT) amelian (AT) gmail.com
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################

macro( qt_message )
  message( STATUS "${ARGN}" )
endmacro( )


if( DEFINED USE_QT3 )
  set( QT_VERSION "3" )
elseif( DEFINED USE_QT4 )
  set( QT_VERSION "4" )
endif()


if( NOT DEFINED QT_VERSION )
  tde_message_fatal( "You must select a Qt version, like this:\n \n cmake -DQT_VERSION=3 [arguments...]\n or\n cmake -DUSE_QT3=ON [arguments...]" )
endif( )


if( NOT (QT_VERSION STREQUAL "3" OR QT_VERSION STREQUAL "4") )
  tde_message_fatal( "You have chosen an invalid version.\n QT_VERSION should be 3 or 4." )
else( )
  qt_message( "Checking for Qt${QT_VERSION}..." )
endif( )


# qt prefix directory
if( NOT DEFINED QT_PREFIX_DIR )
  if( NOT $ENV{QTDIR} STREQUAL "" AND QT_VERSION STREQUAL "3" )
    set( QT_PREFIX_DIR "$ENV{QTDIR}" )
    qt_message( "  QT_PREFIX_DIR is set to QTDIR" )
  else( )
    set( QT_PREFIX_DIR "/usr" )
  endif( )
endif( )
qt_message( "  QT_PREFIX_DIR : ${QT_PREFIX_DIR}" )


# qt headers
if( NOT DEFINED QT_INCLUDE_DIR )
  if( QT_PREFIX_DIR STREQUAL "/usr" )
    if( EXISTS "${QT_PREFIX_DIR}/include/tqt${QT_VERSION}" )
      set( QT_INCLUDE_DIR "${QT_PREFIX_DIR}/include/tqt${QT_VERSION}" )
    else( )
      set( QT_INCLUDE_DIR "${QT_PREFIX_DIR}/include/qt${QT_VERSION}" )
    endif( )
  else( )
    set( QT_INCLUDE_DIR "${QT_PREFIX_DIR}/include" )
  endif( )
endif( )
qt_message( "  QT_INCLUDE_DIR: ${QT_INCLUDE_DIR}" )

# detect native tqt
if( EXISTS "${QT_INCLUDE_DIR}/ntqglobal.h" )
  set( HAVE_REAL_TQT ON CACHE BOOL "Native TQt3 detected" )
  qt_message( "Native TQt3 detected" )
else( )
  qt_message( "Qt3 detected" )
endif( )

# qt library path
if( NOT DEFINED QT_LIBRARY_DIR )
  set( QT_LIBRARY_DIR "${QT_PREFIX_DIR}/lib${LIB_SUFFIX}" )
  if( QT_VERSION STREQUAL "4" )
    if( NOT EXISTS "${QT_LIBRARY_DIR}/libQtGui.so" )
      if( EXISTS "${QT_LIBRARY_DIR}/qt4/libQtGui.so" )
        set( QT_LIBRARY_DIR "${QT_PREFIX_DIR}/lib${LIB_SUFFIX}/qt4" )
      endif( )
    endif( )
  endif( )
endif( )
qt_message( "  QT_LIBRARY_DIR: ${QT_LIBRARY_DIR}" )


# qt library name
if( NOT DEFINED QT_LIBRARIES )
  if( QT_VERSION STREQUAL "3" )
    set( QT_LIBRARIES qt-mt )
  elseif( QT_VERSION STREQUAL "4" )
    set( QT_LIBRARIES QtCore QtGui )
  endif( )
endif( )


# qt tools
if( NOT DEFINED QT_BINARY_DIR )
  set( QT_BINARY_DIR "${QT_PREFIX_DIR}/bin" )
endif( )
qt_message( "  QT_BINARY_DIR : ${QT_BINARY_DIR}" )


# find moc
if( DEFINED MOC_EXECUTABLE )
  if( IS_DIRECTORY "${MOC_EXECUTABLE}" OR NOT EXISTS "${MOC_EXECUTABLE}" )
    tde_message_fatal( "moc was NOT found.\n MOC_EXECUTABLE may not be set correctly." )
  endif( )
else( )
  if( QT_VERSION STREQUAL "3" )
    find_program( MOC_EXECUTABLE NAMES tqmoc moc-qt3 moc HINTS "${QT_BINARY_DIR}" )
  elseif( QT_VERSION STREQUAL "4" )
    find_program( MOC_EXECUTABLE NAMES moc-qt4 moc HINTS "${QT_BINARY_DIR}" )
  endif( )
  if( NOT MOC_EXECUTABLE )
    tde_message_fatal( "moc was NOT found.\n Please check if your Qt${QT_VERSION} is correctly installed." )
  endif( )
endif( )

# attempt to run moc, to check which qt version is using
execute_process( COMMAND ${MOC_EXECUTABLE} -v ERROR_VARIABLE __output
  RESULT_VARIABLE __result ERROR_STRIP_TRAILING_WHITESPACE )

if( __result EQUAL 1 )
  string( REGEX MATCH "^.*Qt (.+)\\)$" __dummy  "${__output}" )
  set( __version  "${CMAKE_MATCH_1}" )
  if( NOT __version )
    tde_message_fatal( "Invalid response from moc:\n ${__output}" )
  endif( )
else( )
  tde_message_fatal( "Unable to run moc!\n Qt${VERSION} are correctly installed?\n LD_LIBRARY_PATH are correctly set?" )
endif( )

qt_message( "  MOC_EXECUTABLE: ${MOC_EXECUTABLE} (using Qt ${CMAKE_MATCH_1})" )

if( QT_VERSION STREQUAL "3" AND NOT "${CMAKE_MATCH_1}" VERSION_LESS "4" )
  tde_message_fatal( "Strange, you want Qt3, but your moc using Qt4." )
elseif( QT_VERSION STREQUAL "4" AND "${CMAKE_MATCH_1}" VERSION_LESS "4" )
  tde_message_fatal( "Strange, you want Qt4, but your moc using Qt3." )
endif( )


# find uic (only for Qt3)
if( QT_VERSION STREQUAL "3" )
  if( DEFINED UIC_EXECUTABLE )
    if( IS_DIRECTORY "${UIC_EXECUTABLE}" OR NOT EXISTS "${UIC_EXECUTABLE}" )
      tde_message_fatal( "uic was NOT found.\n MOC_EXECUTABLE may not be set correctly" )
    endif( )
  else( )
    find_program( UIC_EXECUTABLE NAMES tquic uic-qt3 uic HINTS "${QT_BINARY_DIR}" )
    if( NOT UIC_EXECUTABLE )
      tde_message_fatal( "uic was NOT found.\n Please check if your Qt${QT_VERSION} is correctly installed." )
    endif( )
  endif( )
  qt_message( "  UIC_EXECUTABLE: ${UIC_EXECUTABLE}" )
endif( )


# definitions
if( QT_VERSION STREQUAL "3" )
  set( QT_DEFINITIONS "-DQT_NO_ASCII_CAST -DQT_CLEAN_NAMESPACE -DQT_NO_STL -DQT_NO_COMPAT -DQT_NO_TRANSLATION -DQT_THREAD_SUPPORT -D_REENTRANT" )
elseif( QT_VERSION STREQUAL "4" )
  set( QT_DEFINITIONS "-DQT_NO_ASCII_CAST -DQT_CLEAN_NAMESPACE -DQT_NO_STL -DQT_NO_COMPAT -DQT_NO_TRANSLATION -DQT_THREAD_SUPPORT -D_REENTRANT" )
endif( )


tde_save( CMAKE_REQUIRED_INCLUDES CMAKE_REQUIRED_LIBRARIES )
set( CMAKE_REQUIRED_INCLUDES ${QT_INCLUDE_DIR} )
set( CMAKE_REQUIRED_LIBRARIES -L${QT_LIBRARY_DIR} ${QT_LIBRARIES} )

# check if Qt3 is usable
if( QT_VERSION STREQUAL "3" )
  check_cxx_source_compiles("
    #include <qapplication.h>
    int main(int argc, char **argv) { QApplication app(argc, argv); return 0; } "
    HAVE_USABLE_QT${QT_VERSION} )
    if( NOT HAVE_USABLE_QT${QT_VERSION} )
      # Unset the Qt detection variable
      unset( HAVE_USABLE_QT${QT_VERSION} CACHE )
      # Reset libraries
      set( QT_LIBRARIES tqt-mt )
      set( CMAKE_REQUIRED_LIBRARIES -L${QT_LIBRARY_DIR} ${QT_LIBRARIES} )
      qt_message( "Looking for native TQt3..." )
      check_cxx_source_compiles("
        #include <ntqapplication.h>
        int main(int argc, char **argv) { TQApplication app(argc, argv); return 0; } "
        HAVE_USABLE_QT${QT_VERSION} )
    endif( )
# check if Qt4 is usable
elseif( QT_VERSION STREQUAL "4" )
  check_cxx_source_compiles("
    #include <QtGui/QApplication>
    int main(int argc, char **argv) { QApplication app(argc, argv); return 0; } "
    HAVE_USABLE_QT${QT_VERSION} )
endif( )
if( NOT HAVE_USABLE_QT${QT_VERSION} )
  tde_message_fatal( "Unable to build a simple Qt${QT_VERSION} test." )
endif( )

# check if Qt3 is patched for compatibility with TQt
if( QT_VERSION STREQUAL "3" )
  check_cxx_source_compiles("
    #include <qobjectlist.h>
    #include <qobject.h>
    int main(int, char**) { QObject::objectTreesListObject(); return 0; } "
    HAVE_PATCHED_QT3 )
    if( NOT HAVE_PATCHED_QT3 )
      # Unset the Qt detection variable
      unset( HAVE_PATCHED_QT3 CACHE )
      # Reset libraries
      set( QT_LIBRARIES tqt-mt )
      set( CMAKE_REQUIRED_LIBRARIES -L${QT_LIBRARY_DIR} ${QT_LIBRARIES} )
      qt_message( "Looking for patched native TQt3..." )
      check_cxx_source_compiles("
        #include <ntqobjectlist.h>
        #include <ntqobject.h>
        int main(int, char**) { TQObject::objectTreesListObject(); return 0; } "
        HAVE_PATCHED_QT3 )
    endif( )
  if( NOT HAVE_PATCHED_QT3 )
    tde_message_fatal( "Your Qt3 is not patched for compatibility with tqtinterface." )
  endif( )
endif( )

tde_restore( CMAKE_REQUIRED_INCLUDES CMAKE_REQUIRED_LIBRARIES )
