/*

Copyright (C) 2010 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#ifndef TQT_TQWIDGETLIST_H
#define TQT_TQWIDGETLIST_H

#include <tqt.h>

#ifdef USE_QT3

// Reimplement the TQWidgetList class
// For Qt3, no changes are needed

#include <qwidgetlist.h>

#endif // USE_QT3

#ifdef USE_QT4

// Reimplement the TQWidgetList class
// For Qt4, this class was removed!

#include <tqwidget.h>
#include <tqptrlist.h>

class TQWidgetList : public TQPtrList<QWidget>
{
public:
    TQWidgetList() : TQPtrList<QWidget>() {}
    TQWidgetList( const TQWidgetList &list ) : TQPtrList<QWidget>(list) {}
   ~TQWidgetList() { clear(); }
    TQWidgetList &operator=(const TQWidgetList &list)
	{ return (TQWidgetList&)TQPtrList<QWidget>::operator=(list); }

    // Interoperability
    TQWidgetList(const QWidgetList& l)
    {
        for (int i = 0; i < l.size(); ++i) append(l.at(i));
    }

    TQWidgetList& operator= (const QWidgetList& l)
    {
        this->clear();
        for (int i = 0; i < l.size(); ++i) append(l.at(i));
        return *this;
    }

    operator QWidgetList() const {
        QWidgetList list;
        for (TQWidgetList::const_iterator it = TQWidgetList::constBegin();
             it != TQWidgetList::constEnd(); ++it)
            list.append(*it);
        return list;
    }

    operator TQWidgetList*() {
        TQWidgetList *qwl;
        qwl = new TQWidgetList(*this);
        return qwl;
    }
};

class TQWidgetListIt : public TQPtrListIterator<QWidget>
{
public:
    TQWidgetListIt( const TQWidgetList &l ) : TQPtrListIterator<QWidget>(l) {}
    TQWidgetListIt &operator=(const TQWidgetListIt &i)
	{ return (TQWidgetListIt&)TQPtrListIterator<QWidget>::operator=(i); }
};

#endif // USE_QT4

#endif /* TQT_TQWIDGETLIST_H */
