/*

Copyright (C) 2010 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#ifndef TQT_TQPTRLIST_H
#define TQT_TQPTRLIST_H

#include <tqt.h>

#ifdef USE_QT3

// Reimplement the TQPtrList class
// For Qt3, no changes are needed

#include <qptrlist.h>

#endif // USE_QT3

#ifdef USE_QT4

// Reimplement the TQPtrList class
// For Qt4, some changes are needed

#include <Qt/q3ptrlist.h>
#include <Qt/q3glist.h>
#include <Qt/q3gvector.h>
#include <Qt/q3ptrcollection.h>
#include <Qt/qlist.h>

/****************************************************************************
**
** Definition of TQPtrList template/macro class
**
** Copyright (C) 1992-2008 Trolltech ASA.  All rights reserved.
**
** This file is part of the tools module of the Qt GUI Toolkit.
**
** This file may be used under the terms of the GNU General
** Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the files LICENSE.GPL2
** and LICENSE.GPL3 included in the packaging of this file.
** Alternatively you may (at your option) use any later version
** of the GNU General Public License if such license has been
** publicly approved by Trolltech ASA (or its successors, if any)
** and the KDE Free Qt Foundation.
**
** Please review the following information to ensure GNU General
** Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/.
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** This file may be used under the terms of the Q Public License as
** defined by Trolltech ASA and appearing in the file LICENSE.QPL
** included in the packaging of this file.  Licensees holding valid Qt
** Commercial licenses may use this file in accordance with the Qt
** Commercial License Agreement provided with the Software.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not granted
** herein.
**
**********************************************************************/

template<class type>
class TQPtrListStdIterator : public Q3GListStdIterator
{
public:
    inline TQPtrListStdIterator( Q3LNode* n ): Q3GListStdIterator(n) {}
    type *operator*() { return node ? (type *)node->getData() : 0; }
    inline TQPtrListStdIterator<type> operator++()
    { node = next(); return *this; }
    inline TQPtrListStdIterator<type> operator++(int)
    { Q3LNode* n = node; node = next(); return TQPtrListStdIterator<type>( n ); }
    inline bool operator==( const TQPtrListStdIterator<type>& it ) const { return node == it.node; }
    inline bool operator!=( const TQPtrListStdIterator<type>& it ) const { return node != it.node; }
};


template<class type>
class TQPtrList
#ifdef Q_QDOC
	: public Q3PtrCollection
#else
	: public Q3GList
#endif
{
public:

    TQPtrList()				{}
    TQPtrList( const TQPtrList<type> &l ) : Q3GList(l) {}
    ~TQPtrList()				{ clear(); }
    TQPtrList<type> &operator=(const TQPtrList<type> &l)
			{ return (TQPtrList<type>&)Q3GList::operator=(l); }
    bool operator==( const TQPtrList<type> &list ) const
    { return Q3GList::operator==( list ); }
    bool operator!=( const TQPtrList<type> &list ) const
    { return !Q3GList::operator==( list ); }

    // Interoperability
    TQPtrList(const QList<type*>& l)
    {
        for (int i = 0; i < l.size(); ++i) append(l.at(i));
    }

    TQPtrList<type>& operator= (const QList<type*>& l)
    {
        this->clear();
        for (int i = 0; i < l.size(); ++i) append(l.at(i));
        return *this;
    }

    operator QList<type*>() const {
        QList<type*> list;
        for (typename TQPtrList<type>::const_iterator it = TQPtrList<type>::constBegin();
             it != TQPtrList<type>::constEnd(); ++it)
            list.append(*it);
        return list;
    }

    uint  count()   const		{ return Q3GList::count(); }
    bool  isEmpty() const		{ return Q3GList::count() == 0; }
    bool  insert( uint i, const type *d){ return Q3GList::insertAt(i,(Q3PtrCollection::Item)d); }
    void  inSort( const type *d )	{ Q3GList::inSort((Q3PtrCollection::Item)d); }
    void  prepend( const type *d )	{ Q3GList::insertAt(0,(Q3PtrCollection::Item)d); }
    void  append( const type *d )	{ Q3GList::append((Q3PtrCollection::Item)d); }
    bool  remove( uint i )		{ return Q3GList::removeAt(i); }
    bool  remove()			{ return Q3GList::remove((Q3PtrCollection::Item)0); }
    bool  remove( const type *d )	{ return Q3GList::remove((Q3PtrCollection::Item)d); }
    bool  removeRef( const type *d )	{ return Q3GList::removeRef((Q3PtrCollection::Item)d); }
    void  removeNode( Q3LNode *n )	{ Q3GList::removeNode(n); }
    bool  removeFirst()			{ return Q3GList::removeFirst(); }
    bool  removeLast()			{ return Q3GList::removeLast(); }
    type *take( uint i )		{ return (type *)Q3GList::takeAt(i); }
    type *take()			{ return (type *)Q3GList::take(); }
    type *takeNode( Q3LNode *n )		{ return (type *)Q3GList::takeNode(n); }
    void  clear()			{ Q3GList::clear(); }
    void  sort()			{ Q3GList::sort(); }
    int	  find( const type *d )		{ return Q3GList::find((Q3PtrCollection::Item)d); }
    int	  findNext( const type *d )	{ return Q3GList::find((Q3PtrCollection::Item)d,FALSE); }
    int	  findRef( const type *d )	{ return Q3GList::findRef((Q3PtrCollection::Item)d); }
    int	  findNextRef( const type *d ){ return Q3GList::findRef((Q3PtrCollection::Item)d,FALSE);}
    uint  contains( const type *d ) const { return Q3GList::contains((Q3PtrCollection::Item)d); }
    uint  containsRef( const type *d ) const
					{ return Q3GList::containsRef((Q3PtrCollection::Item)d); }
    bool replace( uint i, const type *d ) { return Q3GList::replaceAt( i, (Q3PtrCollection::Item)d ); }
    type *at( uint i )			{ return (type *)Q3GList::at(i); }
    int	  at() const			{ return Q3GList::at(); }
    type *current()  const		{ return (type *)Q3GList::get(); }
    Q3LNode *currentNode()  const	{ return Q3GList::currentNode(); }
    type *getFirst() const		{ return (type *)Q3GList::cfirst(); }
    type *getLast()  const		{ return (type *)Q3GList::clast(); }
    type *first()			{ return (type *)Q3GList::first(); }
    type *last()			{ return (type *)Q3GList::last(); }
    type *next()			{ return (type *)Q3GList::next(); }
    type *prev()			{ return (type *)Q3GList::prev(); }
    void  toVector( Q3GVector *vec )const{ Q3GList::toVector(vec); }


    // standard iterators
    typedef TQPtrListStdIterator<type> Iterator;
    typedef TQPtrListStdIterator<type> ConstIterator;
    inline Iterator begin() { return Q3GList::begin(); }
    inline ConstIterator begin() const { return Q3GList::begin(); }
    inline ConstIterator constBegin() const { return Q3GList::begin(); }
    inline Iterator end() { return Q3GList::end(); }
    inline ConstIterator end() const { return Q3GList::end(); }
    inline ConstIterator constEnd() const { return Q3GList::end(); }
    inline Iterator erase( Iterator it ) { return Q3GList::erase( it ); }
    // stl syntax compatibility
    typedef Iterator iterator;
    typedef ConstIterator const_iterator;


#ifdef Q_QDOC
protected:
    virtual int compareItems( Q3PtrCollection::Item, Q3PtrCollection::Item );
    virtual QDataStream& read( QDataStream&, Q3PtrCollection::Item& );
    virtual QDataStream& write( QDataStream&, Q3PtrCollection::Item ) const;
#endif

private:
    void  deleteItem( Item d );
};

#if !defined(Q_BROKEN_TEMPLATE_SPECIALIZATION)
template<> inline void TQPtrList<void>::deleteItem( Q3PtrCollection::Item )
{
}
#endif

template<class type> inline void TQPtrList<type>::deleteItem( Q3PtrCollection::Item d )
{
    if ( del_item ) delete (type *)d;
}

template<class type>
class TQPtrListIterator : public Q3GListIterator
{
public:
    TQPtrListIterator(const TQPtrList<type> &l) :Q3GListIterator((Q3GList &)l) {}
   ~TQPtrListIterator()	      {}
    uint  count()   const     { return list->count(); }
    bool  isEmpty() const     { return list->count() == 0; }
    bool  atFirst() const     { return Q3GListIterator::atFirst(); }
    bool  atLast()  const     { return Q3GListIterator::atLast(); }
    type *toFirst()	      { return (type *)Q3GListIterator::toFirst(); }
    type *toLast()	      { return (type *)Q3GListIterator::toLast(); }
    operator type *() const   { return (type *)Q3GListIterator::get(); }
    type *operator*()         { return (type *)Q3GListIterator::get(); }

    // No good, since TQPtrList<char> (ie. QStrList fails...
    //
    // MSVC++ gives warning
    // Sunpro C++ 4.1 gives error
    //    type *operator->()        { return (type *)Q3GListIterator::get(); }

    type *current()   const   { return (type *)Q3GListIterator::get(); }
    type *operator()()	      { return (type *)Q3GListIterator::operator()();}
    type *operator++()	      { return (type *)Q3GListIterator::operator++(); }
    type *operator+=(uint j)  { return (type *)Q3GListIterator::operator+=(j);}
    type *operator--()	      { return (type *)Q3GListIterator::operator--(); }
    type *operator-=(uint j)  { return (type *)Q3GListIterator::operator-=(j);}
    TQPtrListIterator<type>& operator=(const TQPtrListIterator<type>&it)
			      { Q3GListIterator::operator=(it); return *this; }
};

#ifndef QT_NO_COMPAT
#define TQT_TQList TQPtrList
#define TQT_TQListIterator TQPtrListIterator
#endif

/**********************************************************************/

#endif // USE_QT4

#endif /* TQT_TQPTRLIST_H */
