package LCDRange;
use strict;
use TQt;
use TQt::isa qw(TQt::VBox);
use TQt::slots 
	setValue => ['int'],
	setRange => ['int', 'int'];
use TQt::signals
	valueChanged => ['int'];
use TQt::attributes qw(
	slider
);

sub NEW {
    shift->SUPER::NEW(@_);

    my $lcd = TQt::LCDNumber(2, this, "lcd");

    slider = TQt::Slider(&Horizontal, this, "slider");
    slider->setRange(0, 99);
    slider->setValue(0);
    $lcd->connect(slider, TQT_SIGNAL('valueChanged(int)'), TQT_SLOT('display(int)'));
    this->connect(slider, TQT_SIGNAL('valueChanged(int)'), TQT_SIGNAL('valueChanged(int)'));

    setFocusProxy(slider);
}

sub value { slider->value }

sub setValue { slider->setValue(shift) }

sub setRange {
    my($minVal, $maxVal) = @_;
    if($minVal < 0 || $maxVal > 99 || $minVal > $maxVal) {
	warn "LCDRange::setRange($minVal,$maxVal)\n" .
	     "\tRange must be 0..99\n" .
	     "\tand minVal must not be greater than maxVal\n";
	return;
    }
    slider->setRange($minVal, $maxVal);
}

1;
