/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
** Copyright (c) 2001 Phil Thompson <phil@river-bank.demon.co.uk>
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef UIC_H
#define UIC_H
#include <ntqdom.h>
#include <ntqstring.h>
#include <ntqstringlist.h>
#include <ntqmap.h>
#include <ntqtextstream.h>
#include <ntqpalette.h>
#include <ntqvariant.h>

#ifndef TQ_DUMMY_COMPARISON_OPERATOR
# warning "Defining TQ_DUMMY_COMPARISON_OPERATOR"
# ifdef TTQ_FULL_TEMPLATE_INSTANTIATION
#  define TQ_DUMMY_COMPARISON_OPERATOR(C) \
    bool operator==( const C& ) const { \
        tqWarning( #C"::operator==( const "#C"& ) got called." ); \
        return FALSE; \
    }
# else
#  define TQ_DUMMY_COMPARISON_OPERATOR(C)
# endif
#endif

class PyIndent
{
public:
	PyIndent() : tabStop(4), current(0) {calc();}

	void setTabStop(uint n) {tabStop = n; calc();}
	void operator++() {++current; calc();}
	void operator--() {--current; calc();}
	operator TQString() {return indstr;}

private:
	uint tabStop;
	uint current;
	TQString indstr;

	void calc();
};


class Uic : public TQt
{
public:
    Uic( const TQString &fn, const char *outputFn, TQTextStream& outStream,
	TQDomDocument doc, bool subcl, const TQString &trm,
	const TQString& subClass, bool omitForwardDecls, TQString &uicClass );

    static void setIndent(const PyIndent &pyind) {indent = pyind;}

    void createFormImpl( const TQDomElement &e );

    void createSubImpl( const TQDomElement &e, const TQString& subclname );

    void createObjectDecl( const TQDomElement& e );
    void createAttrDecl( const TQDomElement& e );
    void createActionDecl( const TQDomElement& e );
    void createActionImpl( const TQDomElement& e, const TQString &parent );
    void createToolbarImpl( const TQDomElement &e, const TQString &parentClass, const TQString &parent );
    void createMenuBarImpl( const TQDomElement &e, const TQString &parentClass, const TQString &parent );
    void createPopupMenuImpl( const TQDomElement &e, const TQString &parentClass, const TQString &parent );
    TQString createObjectImpl( const TQDomElement &e, const TQString& parentClass, const TQString& parent, const TQString& layout = TQString::null );
    TQString createLayoutImpl( const TQDomElement &e, const TQString& parentClass, const TQString& parent, const TQString& layout = TQString::null );
    TQString createObjectInstance( const TQString& objClass, const TQString& parent, const TQString& objName );
    TQString createSpacerImpl( const TQDomElement &e, const TQString& parentClass, const TQString& parent, const TQString& layout = TQString::null );
    void createExclusiveProperty( const TQDomElement & e, const TQString& exclusiveProp );
    TQString createListBoxItemImpl( const TQDomElement &e, const TQString &parent, TQString *value = 0 );
    TQString createIconViewItemImpl( const TQDomElement &e, const TQString &parent );
    TQString createListViewColumnImpl( const TQDomElement &e, const TQString &parent, TQString *value = 0 );
    TQString createTableRowColumnImpl( const TQDomElement &e, const TQString &parent, TQString *value = 0 );
    TQString createListViewItemImpl( const TQDomElement &e, const TQString &parent,
				    const TQString &parentItem );
    void createColorGroupImpl( const TQString& cg, const TQDomElement& e );
    TQColorGroup loadColorGroup( const TQDomElement &e );

    TQDomElement getObjectProperty( const TQDomElement& e, const TQString& name );
    TQString getPixmapLoaderFunction( const TQDomElement& e );
    TQString getFormClassName( const TQDomElement& e );
    TQString getClassName( const TQDomElement& e );
    TQString getObjectName( const TQDomElement& e );
    TQString getLayoutName( const TQDomElement& e );
    TQString getInclude( const TQString& className );

    TQString setObjectProperty( const TQString& objClass, const TQString& obj, const TQString &prop, const TQDomElement &e, bool stdset );

    TQString registerObject( const TQString& name );
    TQString registeredName( const TQString& name );
    bool isObjectRegistered( const TQString& name );
    TQStringList unique( const TQStringList& );

    TQString trcall( const TQString& sourceText, const TQString& comment = "" );

    static void embed( TQTextStream& out, const char* project, const TQStringList& images );

    friend void getDBConnections(Uic& uic, TQString& s);

private:
    void registerLayouts ( const TQDomElement& e );

    TQTextStream& out;
    TQTextOStream trout;
    TQString languageChangeBody;
    TQCString outputFileName;
    TQStringList objectNames;
    TQMap<TQString,TQString> objectMapper;
    TQStringList tags;
    TQStringList layouts;
    TQString formName;
    TQString lastItem;
    TQString trmacro;

    bool nofwd;
    static PyIndent indent;

    struct Buddy
    {
	Buddy( const TQString& k, const TQString& b )
	    : key( k ), buddy( b ) {}
	Buddy(){} // for valuelist
	TQString key;
	TQString buddy;
	bool operator==( const Buddy& other ) const
	    { return (key == other.key); }
    };
    struct CustomInclude
    {
	TQString header;
	TQString location;
	TQ_DUMMY_COMPARISON_OPERATOR(CustomInclude)
    };
    TQValueList<Buddy> buddies;

    TQStringList layoutObjects;
    bool isLayout( const TQString& name ) const;

    uint item_used : 1;
    uint cg_used : 1;
    uint pal_used : 1;
    uint stdsetdef : 1;
    uint externPixmaps : 1;

    TQString nameOfClass;
    TQStringList namespaces;
    TQString bareNameOfClass;
    TQString pixmapLoaderFunction;

    void registerDatabases( const TQDomElement& e );
    bool isWidgetInTable( const TQDomElement& e, const TQString& connection, const TQString& table );
    bool isFrameworkCodeGenerated( const TQDomElement& e );
    TQString getDatabaseInfo( const TQDomElement& e, const TQString& tag );
    void createFormImpl( const TQDomElement& e, const TQString& form, const TQString& connection, const TQString& table );
    void writeFunctionsSubImpl( const TQStringList &fuLst, const TQStringList &typLst, const TQStringList &specLst,
                                const TQString &subClass, const TQString &descr );
    TQStringList dbConnections;
    TQMap< TQString, TQStringList > dbCursors;
    TQMap< TQString, TQStringList > dbForms;

    static bool isMainWindow;
    static TQString mkBool( bool b );
    static TQString mkBool( const TQString& s );
    bool toBool( const TQString& s );
    static TQString fixString( const TQString &str, bool encode = FALSE );
    static bool onlyAscii;
    static TQString mkStdSet( const TQString& prop );
    static TQString getComment( const TQDomNode& n );
    TQVariant defSpacing, defMargin;
    TQString fileName;
    bool writeFunctImpl;

    void perlSlot(TQStringList::Iterator &it);
};

#endif
