/***************************************************************************
                           kxetextviewsettings.cpp
                           ----------------------
    begin                : Tue Dec 23 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : hartig@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxetextviewsettings.h"
#include "kxetextviewsettingspage.h"

#include <tdelocale.h>
#include <tdeconfig.h>
#include <kdebug.h>
#include <kcolorbutton.h>
#include <tqcheckbox.h>

#include <tqframe.h>
#include <tqspinbox.h>

#define CONF_ENTRY_NAME_COLOR_DEFAULT_TEXT "DefaultText"
#define DFLT_VALUE_COLOR_DEFAULT_TEXT TQColor( "#000000" )

#define CONF_ENTRY_NAME_COLOR_ELEMENT_NAMES "ElementNames"
#define DFLT_VALUE_COLOR_ELEMENT_NAMES TQColor( "#800000" )

#define CONF_ENTRY_NAME_COLOR_ATTR_NAMES "AttributeNames"
#define DFLT_VALUE_COLOR_ATTR_NAMES TQColor( "#00ffff" )

#define CONF_ENTRY_NAME_COLOR_ATTR_VALUES "AttributeValues"
#define DFLT_VALUE_COLOR_ATTR_VALUES TQColor( "#00ff00" )

#define CONF_ENTRY_NAME_COLOR_SYNTAX_CHARS "SyntaxChars"
#define DFLT_VALUE_COLOR_SYNTAX_CHARS TQColor( "#000080" )

#define CONF_ENTRY_NAME_COLOR_COMENTS "Comments"
#define DFLT_VALUE_COLOR_COMENTS TQColor( "#808080" )

#define CONF_ENTRY_NAME_COLOR_ERRORS "SyntaxError"
#define DFLT_VALUE_COLOR_ERRORS TQColor( "#ff0000" )

#define CONF_ENTRY_NAME_INDENT_STEPS "XML indentation"
#define DFLT_VALUE_INDENT_STEPS 2

#define CONF_ENTRY_WRAP_ON "Text Wrap On"
#define DFLT_VALUE_WRAP_ON false

KXETextViewSettings::KXETextViewSettings( TQObject * pParent, const char * pszName )
 : KXESettings( "Text editor", pParent, pszName ),
   m_colorDfltText( DFLT_VALUE_COLOR_DEFAULT_TEXT ),
   m_colorElemNames( DFLT_VALUE_COLOR_ELEMENT_NAMES ),
   m_colorAttrNames( DFLT_VALUE_COLOR_ATTR_NAMES ),
   m_colorAttrValues( DFLT_VALUE_COLOR_ATTR_VALUES ),
   m_colorSyntaxChars( DFLT_VALUE_COLOR_SYNTAX_CHARS ),
   m_colorComments( DFLT_VALUE_COLOR_COMENTS ),
   m_colorErrors( DFLT_VALUE_COLOR_ERRORS ),
   m_iIndentSteps( DFLT_VALUE_INDENT_STEPS ),
   m_bWrapOn(DFLT_VALUE_WRAP_ON),
	 m_pDialogPage(0)
	 
{
}


void KXETextViewSettings::write( TDEConfig * pConfig ) const
{
	pConfig->writeEntry( CONF_ENTRY_NAME_COLOR_DEFAULT_TEXT, m_colorDfltText );
	pConfig->writeEntry( CONF_ENTRY_NAME_COLOR_ELEMENT_NAMES, m_colorElemNames );
	pConfig->writeEntry( CONF_ENTRY_NAME_COLOR_ATTR_NAMES, m_colorAttrNames );
	pConfig->writeEntry( CONF_ENTRY_NAME_COLOR_ATTR_VALUES, m_colorAttrValues );
	pConfig->writeEntry( CONF_ENTRY_NAME_COLOR_SYNTAX_CHARS, m_colorSyntaxChars );
	pConfig->writeEntry( CONF_ENTRY_NAME_COLOR_COMENTS, m_colorComments );
	pConfig->writeEntry( CONF_ENTRY_NAME_COLOR_ERRORS, m_colorErrors );
  pConfig->writeEntry( CONF_ENTRY_NAME_INDENT_STEPS, m_iIndentSteps );
	pConfig->writeEntry( CONF_ENTRY_WRAP_ON, m_bWrapOn );
}


void KXETextViewSettings::read( const TDEConfig * pConfig )
{
	const TQColor tempColor1 = DFLT_VALUE_COLOR_DEFAULT_TEXT;
	m_colorDfltText = pConfig->readColorEntry( CONF_ENTRY_NAME_COLOR_DEFAULT_TEXT, &tempColor1 );
	const TQColor tempColor2 = DFLT_VALUE_COLOR_ELEMENT_NAMES;
	m_colorElemNames = pConfig->readColorEntry( CONF_ENTRY_NAME_COLOR_ELEMENT_NAMES, &tempColor2 );
	const TQColor tempColor3 = DFLT_VALUE_COLOR_ATTR_NAMES;
	m_colorAttrNames = pConfig->readColorEntry( CONF_ENTRY_NAME_COLOR_ATTR_NAMES, &tempColor3 );
	const TQColor tempColor4 = DFLT_VALUE_COLOR_ATTR_VALUES;
	m_colorAttrValues = pConfig->readColorEntry( CONF_ENTRY_NAME_COLOR_ATTR_VALUES, &tempColor4 );
	const TQColor tempColor5 = DFLT_VALUE_COLOR_SYNTAX_CHARS;
	m_colorSyntaxChars = pConfig->readColorEntry( CONF_ENTRY_NAME_COLOR_SYNTAX_CHARS, &tempColor5 );
	const TQColor tempColor6 = DFLT_VALUE_COLOR_COMENTS;
	m_colorComments = pConfig->readColorEntry( CONF_ENTRY_NAME_COLOR_COMENTS, &tempColor6 );
	const TQColor tempColor7 = DFLT_VALUE_COLOR_ERRORS;
	m_colorErrors = pConfig->readColorEntry( CONF_ENTRY_NAME_COLOR_ERRORS, &tempColor7  );
  m_iIndentSteps = pConfig->readNumEntry( CONF_ENTRY_NAME_INDENT_STEPS, DFLT_VALUE_INDENT_STEPS );
	m_bWrapOn = pConfig->readNumEntry( CONF_ENTRY_WRAP_ON, DFLT_VALUE_WRAP_ON );
}


TQString KXETextViewSettings::dialogPageName() const
{
	return i18n( "Text view" );
}

TQString KXETextViewSettings::dialogPageHeader() const
{
	return i18n( "Text view properties" );
}

TQString KXETextViewSettings::dialogPageIcon() const
{
	return "colorize";
}


TQWidget * KXETextViewSettings::dialogPage( TQFrame * pParent )
{
	if ( ! m_pDialogPage )
	{
		// create the page if necessary
		m_pDialogPage = new KXETextViewSettingsPage( pParent, "text view config.dialog page" );

		// and fill its widgets with the corresponding values
		updatePage();

		connect( m_pDialogPage->m_pColorDfltText, SIGNAL(changed(const TQColor&)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pColorElemNames, SIGNAL(changed(const TQColor&)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pColorAttrNames, SIGNAL(changed(const TQColor&)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pColorAttrValues, SIGNAL(changed(const TQColor&)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pColorSyntaxChars, SIGNAL(changed(const TQColor&)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pColorComments, SIGNAL(changed(const TQColor&)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pColorErrors, SIGNAL(changed(const TQColor&)), this, SIGNAL(sigDialogPageChanged()) );
 		connect( m_pDialogPage->m_pIndentSteps, SIGNAL(valueChanged(int)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pCheckBoxWrapOn, SIGNAL(toggled(bool)), this, SIGNAL(sigDialogPageChanged()) );
	}

	return m_pDialogPage;
}


void KXETextViewSettings::setFromPage()
{
	if ( m_pDialogPage )
	{
		m_colorDfltText = m_pDialogPage->m_pColorDfltText->color();
		m_colorElemNames = m_pDialogPage->m_pColorElemNames->color();
		m_colorAttrNames = m_pDialogPage->m_pColorAttrNames->color();
		m_colorAttrValues = m_pDialogPage->m_pColorAttrValues->color();
		m_colorSyntaxChars = m_pDialogPage->m_pColorSyntaxChars->color();
		m_colorComments = m_pDialogPage->m_pColorComments->color();
		m_colorErrors = m_pDialogPage->m_pColorErrors->color();
    m_iIndentSteps = m_pDialogPage->m_pIndentSteps->value();
		m_bWrapOn = m_pDialogPage->m_pCheckBoxWrapOn->isChecked();
	}
}

void KXETextViewSettings::updatePage() const
{
	if ( m_pDialogPage )
	{
		m_pDialogPage->m_pColorDfltText->setColor( m_colorDfltText );
		m_pDialogPage->m_pColorElemNames->setColor( m_colorElemNames );
		m_pDialogPage->m_pColorAttrNames->setColor( m_colorAttrNames );
		m_pDialogPage->m_pColorAttrValues->setColor( m_colorAttrValues );
		m_pDialogPage->m_pColorSyntaxChars->setColor( m_colorSyntaxChars );
		m_pDialogPage->m_pColorComments->setColor( m_colorComments );
		m_pDialogPage->m_pColorErrors->setColor( m_colorErrors );
    m_pDialogPage->m_pIndentSteps->setValue( m_iIndentSteps );
		m_pDialogPage->m_pCheckBoxWrapOn->setChecked( m_bWrapOn );
	}
}
