/***************************************************************************
                          kxeprocinstrdialog.h  -  description
                          --------------------
    begin                : Mit Apr 24 2002
    copyright            : (C) 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXEPROCINSTRDIALOG_H
#define KXEPROCINSTRDIALOG_H

#include "kxeprocinstrdialogbase.h"

class KXEProcInstrDialog : public KXEProcInstrDialogBase
{
		Q_OBJECT

	public:
		KXEProcInstrDialog( TQWidget * pParent = 0, const char * pszName = 0, bool fModal = true, WFlags fl = 0 );

    const bool atTop() const { return m_bAtTop; }
    const TQString target() const { return m_strTarget; }
    const TQString data() const { return  m_strData; }

    void  setTarget(const TQString strTarget) { m_strTarget = strTarget; }
    void  setData(const TQString strData) {  m_strData = strData; }
    
	public:
		
    /**
		 * To be used for inserting a proc.instruction as child
		 * of the given parent node.
		 *
		 * @return see @ref TQDialog::exec
		 */ 
		int exec( bool, bool );

		/**
		 * Clears the dialogs widgets.
		 */
		void clearDialog();

    // check target
    static TQString checkTarget(const TQString);

    // check data
    static TQString checkData(const TQString);
    
	protected:
		/**
		 * Don't use this function directly, it's for internal use only.
		 * Use one of the other @ref KXEProcInstrDialog::exec functions instead.
		 */
		int exec();
    
  protected slots:
		/**
		 * Called, when the data edit box is changed.
		 * Disables the OK button, if the editbox is empty.
		 */
		void slotDataChanged();

    /**
		 * Called, when the target edit box is changed.
		 * Disables the OK button, if the editbox is empty.
		 */
		void slotTargetChanged(const TQString &);

    /** Called when user press OK button */
    void slotAccept();

  protected:
    TQString m_strTarget;
    TQString m_strData;
    bool m_bAtTop;
};

#endif
