/***************************************************************************
                          kxe_viewelement.cpp  -  description
                             -------------------
    begin                : Mon Oct 15 2001
    copyright            : (C) 2001, 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxe_viewelement.h"
#include "kxe_viewattributes.h"
#include "kxesyntaxhighlighter.h"

#include "kxmleditorfactory.h"
#include "kxeconfiguration.h"
#include "kxetextviewsettings.h"

#include <tdeconfig.h>
#include <ktextedit.h>

#include <tqdom.h>
#include <tqcolor.h>
#include <tqpalette.h>


#include "qdom_add.h"

#define CONFIG_SPLITTER_SIZES "View Element splitter sizes"

KXE_ViewElement::KXE_ViewElement( TQWidget * pParent, TDEConfig *pConfig, const char * pszName )
	: TQSplitter( TQt::Vertical, pParent, pszName )
{
	setOpaqueResize(true);
	m_pConfig = pConfig;
	m_pViewAttributes = new KXE_ViewAttributes( this, "table of element attributes");
	connect( m_pViewAttributes, SIGNAL(sigContextMenuRequested(const TQString&,const TQPoint&)), this, SIGNAL(sigContextMenuRequested(const TQString&,const TQPoint&)) );

  connect( m_pViewAttributes, SIGNAL(sigAttributeNameChangedInplace(const TQDomAttr&, const TQString)), this, SIGNAL(sigAttributeNameChangedInplace(const TQDomAttr&, const TQString)) );
  connect( m_pViewAttributes, SIGNAL(sigAttributeValueChangedInplace(const TQDomAttr&, const TQString)), this, SIGNAL(sigAttributeValueChangedInplace(const TQDomAttr&, const TQString)) );

	m_pViewPlainXML = new KTextEdit( this, "plain XML" );
	m_pViewPlainXML->setReadOnly(true);
	m_pViewPlainXML->setTextFormat(KTextEdit::PlainText);
	m_pViewPlainXML->setPaletteBackgroundColor(pParent->palette().active().base()); // Owerwrite read-only background color
  m_pViewPlainXML->setWordWrap( TQTextEdit::NoWrap );
  m_pSyntaxHighlighter = new KXESyntaxHighlighter(m_pViewPlainXML);

  	// configuring splitter sizes
	if (m_pConfig)
	{
		TQValueList<int> list = m_pConfig->readIntListEntry(CONFIG_SPLITTER_SIZES);
		if (!list.isEmpty())
			setSizes(list);
  }

	// Apply current configuration
	slotTextViewSettingsChanged();
	// and make sure to be informed about its changes.
	connect( KXMLEditorFactory::configuration()->textview(), SIGNAL(sigChanged()), this, SLOT(slotTextViewSettingsChanged()) );
}

KXE_ViewElement::~KXE_ViewElement()
{
	// saving splitter sizes
	if (m_pConfig)
		m_pConfig->writeEntry( CONFIG_SPLITTER_SIZES, sizes() );

  delete m_pSyntaxHighlighter;
}

TQDomAttr KXE_ViewElement::getSelectedAttribute() const
{
	return m_pViewAttributes->getSelectedAttribute();
}

void KXE_ViewElement::setReadWrite( bool fReadWrite )
{
	m_pViewAttributes->setReadWrite(fReadWrite);
}

void KXE_ViewElement::slotChange( const TQDomElement & element )
{
	// change attribute view
	m_pViewAttributes->slotChange(element);

  int iIndent = KXMLEditorFactory::configuration()->textview()->indentSteps();

	// change plain XML view
	m_pViewPlainXML->setText( domTool_save(element, iIndent) );
}

//////////////////////////////////////////////////////////////
// configuration slots
//////////////////////////////////////////////////////////////

void KXE_ViewElement::slotTextViewSettingsChanged()
{
	m_pSyntaxHighlighter->setColorDefaultText( KXMLEditorFactory::configuration()->textview()->colorDfltText() );
	m_pSyntaxHighlighter->setColorElementNames( KXMLEditorFactory::configuration()->textview()->colorElemNames() );
	m_pSyntaxHighlighter->setColorAttributeNames( KXMLEditorFactory::configuration()->textview()->colorAttrNames() );
	m_pSyntaxHighlighter->setColorAttributeValues( KXMLEditorFactory::configuration()->textview()->colorAttrValues() );
	m_pSyntaxHighlighter->setColorXmlSyntaxChars( KXMLEditorFactory::configuration()->textview()->colorSyntaxChars() );
	m_pSyntaxHighlighter->setColorComments( KXMLEditorFactory::configuration()->textview()->colorComments() );
	m_pSyntaxHighlighter->setColorSyntaxError( KXMLEditorFactory::configuration()->textview()->colorErrors() );

	if(KXMLEditorFactory::configuration()->textview()->isWrapOn())
	{
		m_pViewPlainXML->setHScrollBarMode(TQScrollView::AlwaysOff);
		m_pViewPlainXML->setWordWrap(TQTextEdit::WidgetWidth);
	}
	else
	{
		m_pViewPlainXML->setHScrollBarMode(TQScrollView::Auto);
		m_pViewPlainXML->setWordWrap(TQTextEdit::NoWrap);
	}
	
	m_pSyntaxHighlighter->rehighlight();
}

#include "kxe_viewelement.moc"
