/***************************************************************************
                           kxeconfiguration.h
                           ------------------
    begin                : Tue Dec 02 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : hartig@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXECONFIGURATION_H
#define KXECONFIGURATION_H

#include <tqobject.h>

class KXETreeViewSettings;
class KXETextViewSettings;
class KXENewFileSettings;
class KXEPrintSettings;
class KXEArchiveExtsSettings;

class TDEConfig;
class KDialogBase;

/**
 * This class is a container for KXMLEditor's configuration data.
 * It consists of objects for the different groups of settings
 * (objects of child classes of KXESettings) and manages the configuration
 * dialog (@ref m_pDialog). This dialog consists of one page per settings
 * group, that are initialized by them (using their dialogPage* functions).
 *
 * @short container for KXMLEditor's configuration data
 * @author Olaf Hartig
 */
class KXEConfiguration : public TQObject
{
		Q_OBJECT

	public:

		/**
		 * The constructor initializes the configuration setting groups
		 * (objects of KXESettings' child classes) and restores the
		 * configuration data from the config file by calling @ref restore.
		 */
		KXEConfiguration();
		/**
		 * The destructor deletes the configuration dialog, if there is one.
		 */
		~KXEConfiguration();

		/**
		 * Stores all configuration to the given @ref TDEConfig object by
		 * using @ref KXESettings's @ref store function.
		 * If no @ref TDEConfig object is given, @ref TDEGlobal::config is
		 * used.
		 */
		void store( TDEConfig * pConfig = 0 ) const;
		/**
		 * Restores all configuration from the given @ref TDEConfig object
		 * by using @ref KXESettings's @ref restore function.
		 * If no @ref TDEConfig object is given, @ref TDEGlobal::config is
		 * used.
		 */
		void restore( TDEConfig * pConfig = 0 );
		/**
		 * Shows the configuration dialog.
		 * If there is no one yet, it is created by.
		 */
		void showDialog();

		// The following functions return pointers to the configuration setting
		// groups (objects of KXESettings' child classes), that can be used to
		// access their data (or to connect to their signals).

		KXETreeViewSettings * const treeview() const { return m_pTreeView; }
		KXETextViewSettings * const textview() const { return m_pTextView; }
		KXENewFileSettings * const newfile() const { return m_pNewFile; }
		KXEPrintSettings * const print() const { return m_pPrint; }
		KXEArchiveExtsSettings * const archexts() const { return m_pArcExts; }

	protected slots:

		/**
		 * Applies the new data in the dialog's pages to our setting groups
		 * by using @ref KXESettings's @ref apply function and stores
		 * all settings with @ref store.
		 * After applying, the dialog's state is reseted (disabled Apply- and
		 * OK-buttons).
		 */
		void slotDlgApplied();
		/**
		 * Enables the configuration dialog's Apply- and OK-button.
		 */
		void slotDlgChanged();

	protected:

		// The following members are the configuration setting
		// groups (objects of KXESettings' child classes).

		KXETreeViewSettings * m_pTreeView;
		KXETextViewSettings * m_pTextView;
		KXENewFileSettings * m_pNewFile;
		KXEPrintSettings * m_pPrint;
		KXEArchiveExtsSettings * m_pArcExts;

		/**
		 * This is a pointer to our configuration dialog.
		 * The dialog itself is created on demand in @ref showDialog.
		 * It consists of one page per settings group.
		 */
		KDialogBase * m_pDialog;
};

#endif
