/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
//BEGIN INCLUDES

#include <tdelocale.h>
#include <tqlabel.h>
#include <tqhbox.h>
#include <tqvbox.h>
#include <tqpushbutton.h>
#include <tqradiobutton.h>
#include <tqcheckbox.h>
#include <klineedit.h>
#include <tqlineedit.h>
#include <tdemessagebox.h>
#include <kcombobox.h>
#include <kurlrequester.h>
#include <knuminput.h>
#include <kpassdlg.h>
#include <tdefiledialog.h>
#include <tqspinbox.h>
#include <tqcursor.h>
#include <tqbuttongroup.h>
#include <tqtooltip.h>
#include <iostream>

#include <kstddirs.h>
#include <kinputdialog.h>

#include "kvpncconfig.h"
#include "networkinterface.h"
#include "newprofilewizard.h"
#include "addnetworkroutedialog.h"
#include "utils.h"
//END INCLUDES

NewProfileWizard::NewProfileWizard ( KVpncConfig* GlobalConfig )
{
	this->GlobalConfig = GlobalConfig;

	newProfileCreated = false;
	setCaption ( i18n ( "Add new profile..." ) );
	//setMinimumSize( 400,300);

	SetupPixmap = new TQPixmap ( locate ( "data", "kvpnc/newprofilewizard.png" ) );
	SetupPixmapFinal = new TQPixmap ( locate ( "data", "kvpnc/newprofilewizard_final.png" ) );

	// currently static for new profile
	VpnAccountData::ConnectionType ConnType = VpnAccountData::ConnectionType ( VpnAccountData::other );
	Port = 500;
	Gateway = "";
	ID = "";
	Username = "";
	UserPassword = "";
	PreSharedKey = "";
	ApplicationVersion = "";
	NtDomainName = "";
	PerfectForwardSecrecy = "";
	IkeGroup = "";
	Description = "";
	Name = "None";
	useApplicationVersion = false;
	useGlobalIpsecSecret = false;
	useIkeGroup = false;
	useLocalPort = false;
	useNtDomainName = false;
	useSingleDes = false;
	useAdvancedSettings = false;
	usePerfectSecrecy = false;
	saveUserPassword = false;
	savePsk = false;
	useUdp = false;
	useUdpPort = false;
	useDnsServer = false;
	DnsServer = "";
	useGetDnsFromPeer = true;
	refuse40BitEncryption = true;
	refuse128BitEncryption = false;
	allowStatefulMode = false;
	requireMppe = true;
	useNoBsdComp = true;
	useNoDeflate = true;
	savePsk = false;
	connectaftercreating = true;
	daemonavailable = false;
	enterdatamanually = false;
	importOK = false;

	currentpage = 0;
	previouspage = 0;

	profileData = new VpnAccountData ( ConnType, Name );
	profileData->setGateway ( Gateway );
	profileData->setID ( ID );
	profileData->setPreSharedKey ( PreSharedKey );
	profileData->setSavePsk ( savePsk );
	profileData->setUserName ( Username );
	profileData->setUserPassword ( UserPassword );
	profileData->setSaveUserPassword ( saveUserPassword );
	profileData->setSavePsk ( savePsk );
	profileData->setApplicationVersion ( ApplicationVersion );
	profileData->setUseLocalPort ( useLocalPort );
	profileData->setLocalPort ( Port );
	profileData->setUseSingleDes ( useSingleDes );
	profileData->setPerfectForwardSecrety ( PerfectForwardSecrecy );
	profileData->setIkeGroup ( IkeGroup );
	profileData->setUseGlobalIpsecSecret ( useGlobalIpsecSecret );
	profileData->setUseIkeGroup ( useIkeGroup );
	profileData->setNtDomainName ( NtDomainName );
	profileData->setUseAdvancedSettings ( useAdvancedSettings );
	profileData->setUsePerfectForwardSecrety ( usePerfectSecrecy );
	profileData->setUseTlsAuth ( false );

	setupPages();

	// 	// tmp
	// 	newprofilewizardtypeselectionpagecontent->FreeswanRadioButton->setEnabled(false);
	// 	newprofilewizardtypeselectionpagecontent->RacoonRadioButton->setEnabled(false);
}

void NewProfileWizard::accept()
{

	if ( !enterdatamanually )
	{
		if ( profileData->getConnectionType() == VpnAccountData::cisco )
		{
// 			importProfile( VpnAccountData::cisco );
// 			if ( importOK )
// 				newProfileCreated = true;
// 			else
// 				newProfileCreated = false;
		}
	}
	else
	{
		newProfileCreated = true;
	}
	finished = true;

	if ( newProfileCreated && profileData->getAuthType() == VpnAccountData::cert )
		{}

	TQWizard::accept();
}

void NewProfileWizard::reject()
{
	finished = false;
	TQWizard::reject();
}

void NewProfileWizard::setupPages()
{

	// setup start page
	page1 = new TQHBox ( 0 );
	// 	page1->setSpacing(8);
	TQLabel *setupPixmapContent1 = new TQLabel ( page1 );
	setupPixmapContent1->setPixmap ( *SetupPixmap );
	setupPixmapContent1->resize ( setupPixmapContent1->sizeHint() );
	newprofilewizardstartcontent = new NewProfileWizardStart ( page1 );
	newprofilewizardstartcontent->resize ( newprofilewizardstartcontent->sizeHint() );
	page1->sizeHint();
	addPage ( page1, "<b>" + i18n ( "Welcome" ) + "</b>" );

	// type selection
	newprofilewizardtypeselectionpage = new TQHBox ( 0 );
	// 	newprofilewizardtypeselectionpage->setSpacing(8);
	TQLabel *setupPixmapContent2 = new TQLabel ( newprofilewizardtypeselectionpage );
	setupPixmapContent2->setPixmap ( *SetupPixmap );
	setupPixmapContent2->resize ( setupPixmapContent2->sizeHint() );
	newprofilewizardtypeselectionpagecontent = new NewProfileWizardTypeSelection ( newprofilewizardtypeselectionpage );
	newprofilewizardtypeselectionpagecontent->FreeswanRadioButton->setText ( i18n ( "IPSec (%1)" ).arg ( "FreeS/WAN/Openswan/strongSwan" ) );
	newprofilewizardtypeselectionpagecontent->L2tpFreeswanRadioButton->setText ( i18n ( "L2TP over IPSec (%1)" ).arg ( "FreeS/WAN/Openswan/strongSwan" ) );
	newprofilewizardtypeselectionpage->sizeHint();
	addPage ( newprofilewizardtypeselectionpage, "<b>" + i18n ( "Type selection" ) + "</b>" );

	// cisco
	newprofilewizardciscoselectionpage = new TQHBox ( 0 );
	// 	newprofilewizardciscoselectionpage->setSpacing(8);
	TQLabel *setupPixmapContent3 = new TQLabel ( newprofilewizardciscoselectionpage );
	setupPixmapContent3->setPixmap ( *SetupPixmap );
	setupPixmapContent3->resize ( setupPixmapContent3->sizeHint() );
	newprofilewizardciscoselectionpagecontent = new NewProfileWizardCiscoSelection ( newprofilewizardciscoselectionpage );
	newprofilewizardciscoselectionpage->sizeHint();

	newprofilewizardciscomanuallypage = new TQHBox ( 0 );
	// 	newprofilewizardciscomanuallypage->setSpacing(8);
	TQLabel *setupPixmapContent4 = new TQLabel ( newprofilewizardciscomanuallypage );
	setupPixmapContent4->setPixmap ( *SetupPixmap );
	setupPixmapContent4->resize ( setupPixmapContent4->sizeHint() );
	newprofilewizardciscomanuallypagecontent = new NewProfileWizardCiscoManually ( newprofilewizardciscomanuallypage );
	newprofilewizardciscomanuallypage->sizeHint();

	connect ( newprofilewizardciscomanuallypagecontent->GroupPasswordLineEdit , TQT_SIGNAL ( textChanged ( const TQString& ) ), this, TQT_SLOT ( pskToggled ( const TQString& ) ) );

	// racoon
	newprofilewizardracoonpage = new TQHBox ( 0 );
	// 	newprofilewizardracoonpage->setSpacing(8);
	TQLabel *setupPixmapContent5 = new TQLabel ( newprofilewizardracoonpage );
	setupPixmapContent5->setPixmap ( *SetupPixmap );
	setupPixmapContent5->resize ( setupPixmapContent5->sizeHint() );
	newprofilewizardracoonpagecontent = new NewProfileWizardRacoon ( newprofilewizardracoonpage );
	newprofilewizardracoonpagecontent->ExchangeModeComboBox->insertItem ( "main", 0 );
	newprofilewizardracoonpagecontent->ExchangeModeComboBox->insertItem ( "aggressive", 1 );
	newprofilewizardracoonpagecontent->ExchangeModeComboBox->insertItem ( "base", 2 );
	newprofilewizardracoonpagecontent->ExchangeModeComboBox->setCurrentItem ( 0 ); // main

	newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem ( "SHA1" );
	newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem ( "MD5" );
	newprofilewizardracoonpagecontent->HashAlgoComboBox->setCurrentItem ( 0 ); //SHA1

	newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem ( "modp768" );
	newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem ( "modp1024" );
	newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem ( "ec2n155" );
	newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem ( "ec2n185" );
	newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem ( "modp1536" );
	newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem ( "modp2048" );
	newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem ( "modp3072" );
	newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem ( "modp4096" );
	newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem ( "modp6144" );
	newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem ( "modp8192" );

	newprofilewizardracoonpagecontent->LocalIdTypeCombobox->insertItem("none");
	newprofilewizardracoonpagecontent->LocalIdTypeCombobox->insertItem("address");
	newprofilewizardracoonpagecontent->LocalIdTypeCombobox->insertItem("user_fqdn");
	newprofilewizardracoonpagecontent->LocalIdTypeCombobox->insertItem("fqdn");
	newprofilewizardracoonpagecontent->LocalIdTypeCombobox->insertItem("keyid (file)");
	newprofilewizardracoonpagecontent->LocalIdTypeCombobox->insertItem("keyid");
	newprofilewizardracoonpagecontent->LocalIdTypeCombobox->insertItem("asn1dn");
	
	newprofilewizardracoonpagecontent->RemoteIdTypeCombobox->insertItem("none");
	newprofilewizardracoonpagecontent->RemoteIdTypeCombobox->insertItem("address");
	newprofilewizardracoonpagecontent->RemoteIdTypeCombobox->insertItem("user_fqdn");
	newprofilewizardracoonpagecontent->RemoteIdTypeCombobox->insertItem("fqdn");
	newprofilewizardracoonpagecontent->RemoteIdTypeCombobox->insertItem("keyid (file)");
	newprofilewizardracoonpagecontent->RemoteIdTypeCombobox->insertItem("keyid");
	newprofilewizardracoonpagecontent->RemoteIdTypeCombobox->insertItem("asn1dn");

	TQToolTip::add( newprofilewizardracoonpagecontent->RemoteIdTypeCombobox, i18n("<b>Remote ID type</b><br><table>"
	"<tr><td>none:</td><td>No ID</td></tr>"
	"<tr><td>address:</td><td>The type is the IP address. This is the default type if you do not specify an identifier to use</td></tr>"
	"<tr><td>user_fqdn:</td><td>The type is a USER_FTQDN (user fully-qualified domain name)</td></tr>"
	"<tr><td>fqdn:</td><td>The type is a FTQDN (fully-qualified domain name)</td></tr>"
	"<tr><td>keyid (file):</td><td>The type is a KEY_ID, read from the file</td></tr>"
	"<tr><td>keyid:</td><td>The type is a KEY_ID, specified in field</td></tr>"
	"<tr><td>asn1dn:</td><td>The type is an ASN.1 distinguished name. If empty, DN from the Subject field in the certificate will be used"
	"<table>"));

	TQToolTip::add( newprofilewizardracoonpagecontent->LocalIdTypeCombobox, i18n("<b>Local ID type</b><br><table>"
	"<tr><td>none:</td><td>No ID</td></tr>"
	"<tr><td>address:</td><td>The type is the IP address. This is the default type if you do not specify an identifier to use</td></tr>"
	"<tr><td>user_fqdn:</td><td>The type is a USER_FTQDN (user fully-qualified domain name)</td></tr>"
	"<tr><td>fqdn:</td><td>The type is a FTQDN (fully-qualified domain name)</td></tr>"
	"<tr><td>keyid (file):</td><td>The type is a KEY_ID, read from the file</td></tr>"
	"<tr><td>keyid:</td><td>The type is a KEY_ID, specified in field</td></tr>"
	"<tr><td>asn1dn:</td><td>The type is an ASN.1 distinguished name. If empty, DN from the Subject field in the certificate will be used"
	"<table>"));

	newprofilewizardracoonpagecontent->PerfectForwardSecurityCheckbox->setChecked(true);
	newprofilewizardracoonpagecontent->PerfectForwardSecrecyCombobox->setCurrentText("modp2048");

	connect ( newprofilewizardracoonpagecontent->LocalIdTypeCombobox, TQT_SIGNAL ( highlighted ( const TQString& ) ), this, TQT_SLOT ( localIDTypeRacoonToggled ( const TQString& ) ) );
	connect ( newprofilewizardracoonpagecontent->RemoteIdTypeCombobox, TQT_SIGNAL ( highlighted ( const TQString& ) ), this, TQT_SLOT ( remoteIDTypeRacoonToggled ( const TQString& ) ) );

	connect ( newprofilewizardracoonpagecontent->IkeGroupCheckbox, TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( ikeGroupToggled ( bool ) ) );
	connect ( newprofilewizardracoonpagecontent->UseXauthCheckBox, TQT_SIGNAL(toggled(bool)),this, TQT_SLOT(useXauthRacoonToggled(bool)));

	Utils::IpsecAlgos KernelCrypto = Utils ( GlobalConfig ).getKernelCrypto();

	// man racoon.conf
	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("des" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("3des" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("blowfish" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("cast128" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("aes" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("camellia" );

	// man racoon.conf
	newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem( "md5" );
	newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem( "sha1" );
	newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem( "sha256" );
	newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem( "sha384" );
	newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem( "sha512" );




//  	// phase 2 encr algos from kernel
// 	for ( TQStringList::Iterator it = KernelCrypto.IpsecEspEncryptionAlgorithms.begin(); it != KernelCrypto.IpsecEspEncryptionAlgorithms.end(); ++it )
// 	{
// 		newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem ( *it );
// 	}
// 
// 	// phase 2 auth algos from kernel
// 	for ( TQStringList::Iterator it = KernelCrypto.IpsecEspAuthenticationAlgorithms.begin(); it != KernelCrypto.IpsecEspAuthenticationAlgorithms.end(); ++it )
// 	{
// 		newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem ( *it );
// 	}

	// vpn mit linux book
	newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("des" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("3des" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("des_iv64" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("des_iv32" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("rc5" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("rc4" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("idea" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("3idea" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("cast128" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("blowfish" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("null_enc" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("twofish" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("rijndael" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("aes" );

	newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "des" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "3des" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "des_iv64" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "des_iv32" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_md5" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_sha1" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_sha256" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_sha384" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_sha512" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "non_auth" );


	// FIXME save not implemented yet
	newprofilewizardracoonpagecontent->PerfectForwardSecurityCheckbox->hide();
	newprofilewizardracoonpagecontent->PerfectForwardSecrecyCombobox->hide();

	newprofilewizardracoonpage->sizeHint();

	//freeswan
	newprofilewizardfreeswanselectionpage = new TQHBox ( 0 );
	// 	newprofilewizardfreeswanselectionpage->setSpacing(8);
	TQLabel *setupPixmapContent711 = new TQLabel ( newprofilewizardfreeswanselectionpage );
	setupPixmapContent711->setPixmap ( *SetupPixmap );
	setupPixmapContent711->resize ( setupPixmapContent711->sizeHint() );
	newprofilewizardfreeswanselectionpagecontent	 = new NewProfileWizardOpenvpnSelection ( newprofilewizardfreeswanselectionpage );
	newprofilewizardfreeswanselectionpagecontent->OpenvpnImportRadioButton->setText(i18n("Import &Ipsec config file"));
	newprofilewizardfreeswanselectionpage->sizeHint();

	newprofilewizardfreeswanpage = new TQHBox ( 0 );
	// 	newprofilewizardfreeswanpage->setSpacing(8);
	TQLabel *setupPixmapContent6 = new TQLabel ( newprofilewizardfreeswanpage );
	setupPixmapContent6->setPixmap ( *SetupPixmap );
	setupPixmapContent6->resize ( setupPixmapContent6->sizeHint() );
	newprofilewizardfreeswanpagecontent = new NewProfileWizardFreeswan ( newprofilewizardfreeswanpage );
	newprofilewizardfreeswanpage->sizeHint();

	//freeswan
	newprofilewizardfreeswanpage = new TQHBox ( 0 );
	// 	newprofilewizardfreeswanpage->setSpacing(8);
	TQLabel *setupPixmapContent66 = new TQLabel ( newprofilewizardfreeswanpage );
	setupPixmapContent66->setPixmap ( *SetupPixmap );
	setupPixmapContent66->resize ( setupPixmapContent66->sizeHint() );
	newprofilewizardfreeswanpagecontent = new NewProfileWizardFreeswan ( newprofilewizardfreeswanpage );
	
	newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox->insertItem(i18n("Certificate ID"));
	newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox->insertItem("asn1dn");
	newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox->insertItem("address");
	newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox->insertItem("fqdn");
	newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox->insertItem("keyid");
	newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox->insertItem("user_fqdn");

	newprofilewizardfreeswanpagecontent->RemoteIdTypeCombobox->insertItem("asn1dn");
	newprofilewizardfreeswanpagecontent->RemoteIdTypeCombobox->insertItem("address");
	newprofilewizardfreeswanpagecontent->RemoteIdTypeCombobox->insertItem("fqdn");
	newprofilewizardfreeswanpagecontent->RemoteIdTypeCombobox->insertItem("keyid");
	newprofilewizardfreeswanpagecontent->RemoteIdTypeCombobox->insertItem("user_fqdn");
	newprofilewizardfreeswanpagecontent->RemoteIdTypeCombobox->insertItem("none");

	newprofilewizardfreeswanpagecontent->IpsecVpnModeCombobox->insertItem( "transport" );
	newprofilewizardfreeswanpagecontent->IpsecVpnModeCombobox->insertItem( "tunnel" );

	newprofilewizardfreeswanpagecontent->IpsecVpnModeCombobox->setCurrentItem(1);
	newprofilewizardfreeswanpagecontent->DisableOpportunisticEncryptionCheckBox->setChecked(true);
	newprofilewizardfreeswanpagecontent->UseModeConfigCheckBox->hide();
	newprofilewizardfreeswanpagecontent->PerfectForwardSecurityCheckbox->setChecked(true);

	connect ( newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox, TQT_SIGNAL ( highlighted ( const TQString& ) ), this, TQT_SLOT ( localIDTypeIpsecToggled ( const TQString& ) ) );

	connect( newprofilewizardfreeswanpagecontent->UseCustomEspCheckBox, TQT_SIGNAL( toggled(bool) ), this, TQT_SLOT( useEspToogled(bool) ) );
	connect( newprofilewizardfreeswanpagecontent->UseCustomIkeCheckBox, TQT_SIGNAL( toggled(bool) ), this, TQT_SLOT( useIkeToggled(bool) ) );
	connect( newprofilewizardfreeswanpagecontent->UseLeftNextHopCheckBox, TQT_SIGNAL( toggled(bool) ), this, TQT_SLOT( useLeftNextHopToggled(bool) ) );
	connect( newprofilewizardfreeswanpagecontent->UseRightNextHopCheckBox, TQT_SIGNAL( toggled(bool) ), this, TQT_SLOT( useRightNextHopToggled(bool) ) );
	connect (newprofilewizardfreeswanpagecontent->UseXauthCheckBox, TQT_SIGNAL(toggled(bool)),this, TQT_SLOT(useXauthFreeswanToggled(bool)));

	connect ( newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox, TQT_SIGNAL ( highlighted ( const TQString& ) ), this, TQT_SLOT ( localIDTypeIpsecToggled ( const TQString& ) ) );
	connect ( newprofilewizardfreeswanpagecontent->RemoteIdTypeCombobox, TQT_SIGNAL ( highlighted ( const TQString& ) ), this, TQT_SLOT ( remoteIDTypeIpsecToggled ( const TQString& ) ) );

	newprofilewizardfreeswanpage->sizeHint();

	// openvpn
	newprofilewizardopenvpnselectionpage = new TQHBox ( 0 );
	// 	newprofilewizardopenvpnselectionpage->setSpacing(8);
	TQLabel *setupPixmapContent7 = new TQLabel ( newprofilewizardopenvpnselectionpage );
	setupPixmapContent7->setPixmap ( *SetupPixmap );
	setupPixmapContent7->resize ( setupPixmapContent7->sizeHint() );
	newprofilewizardopenvpnselectionpagecontent = new NewProfileWizardOpenvpnSelection ( newprofilewizardopenvpnselectionpage );
	newprofilewizardopenvpnselectionpage->sizeHint();

	newprofilewizardopenvpnauthpage = new TQHBox ( 0 );
	// 	newprofilewizardopenvpnauthpage->setSpacing(8);
	TQLabel *setupPixmapContent71 = new TQLabel ( newprofilewizardopenvpnauthpage );
	setupPixmapContent71->setPixmap ( *SetupPixmap );
	setupPixmapContent71->resize ( setupPixmapContent71->sizeHint() );
	newprofilewizardopenvpnauthpagecontent = new NewProfileWizardOpenvpnAuth ( newprofilewizardopenvpnauthpage );
	newprofilewizardopenvpnauthpage->sizeHint();
	connect ( newprofilewizardopenvpnauthpagecontent->AuthWithUsernameAndPasswordCheckBox, TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( authenticateWithUsernameAndPasswordToggled ( bool ) ) );
	connect ( newprofilewizardopenvpnauthpagecontent->UseAuthenticationAlgorithmCheckBox, TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( useAuthenticationAlgorithmToggled ( bool ) ) );

	newprofilewizardopenvpnpage = new TQHBox ( 0 );
	// 	newprofilewizardopenvpnpage->setSpacing(8);
	TQLabel *setupPixmapContent8 = new TQLabel ( newprofilewizardopenvpnpage );
	setupPixmapContent8->setPixmap ( *SetupPixmap );
	setupPixmapContent8->resize ( setupPixmapContent8->sizeHint() );
	newprofilewizardopenvpnpagecontent = new NewProfileWizardOpenvpn ( newprofilewizardopenvpnpage );
	newprofilewizardopenvpnpage->sizeHint();
	newprofilewizardopenvpnpagecontent->TunnelDeviceTypeComboBox->insertItem ( "tun" );
	newprofilewizardopenvpnpagecontent->TunnelDeviceTypeComboBox->insertItem ( "tap" );
	newprofilewizardopenvpnpagecontent->NsCertTypeComboBox->insertItem ( "client" );
	newprofilewizardopenvpnpagecontent->NsCertTypeComboBox->insertItem ( "server" );
	newprofilewizardopenvpnpagecontent->NsCertTypeComboBox->setEnabled ( false );
	newprofilewizardopenvpnpagecontent->UserdefinedPortSpinBox->setEnabled ( false );

	newprofilewizardopenvpnpagecontent->UseUserdefinedPortCheckBox->setChecked ( false );
	newprofilewizardopenvpnpagecontent->UseNsCertTypeCheckBox->setChecked ( false );
	newprofilewizardopenvpnpagecontent->UseTlsAuthCheckBox->setChecked ( false );
	newprofilewizardopenvpnpagecontent->UseTlsRemoteHostCheckBox->setChecked ( false );
	newprofilewizardopenvpnpagecontent->UseUserdefiniedCipherCheckBox->setChecked ( false );
	newprofilewizardopenvpnpagecontent->UseHttpProxyCheckBox->setChecked ( false );

	connect ( newprofilewizardopenvpnpagecontent->UseUserdefinedPortCheckBox , TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( userdefinedOpenvpnPortToggeled ( bool ) ) );
	connect ( newprofilewizardopenvpnpagecontent->UseNsCertTypeCheckBox , TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( nsCertTypeOpenvpnToggled ( bool ) ) );
	connect ( newprofilewizardopenvpnpagecontent->UseUserdefinedPortCheckBox, TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( userdefinedOpenvpnPortToggeled ( bool ) ) );
	connect ( newprofilewizardopenvpnpagecontent->UseTlsAuthCheckBox, TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( useTlsAuthToggled ( bool ) ) );
	connect ( newprofilewizardopenvpnpagecontent->UseTlsRemoteHostCheckBox, TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( useTlsRemoteHostToggled ( bool ) ) );
	connect ( newprofilewizardopenvpnpagecontent->UseUserdefiniedCipherCheckBox, TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( useUserdefiniedCipherToggled ( bool ) ) );
	connect ( newprofilewizardopenvpnpagecontent->UseHttpProxyCheckBox, TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( useHttpProxyToggeled ( bool ) ) );

	TQStringList ciphers = Utils ( GlobalConfig ).getOpenvpnCiphers();
	TQStringList digests = Utils ( GlobalConfig ).getOpenvpnDigests();

	for ( TQStringList::Iterator it = ciphers.begin(); it != ciphers.end(); ++it )
	{
		newprofilewizardopenvpnpagecontent->UserdefiniedCipherComboBox->insertItem ( *it );
	}

	for ( TQStringList::Iterator it = digests.begin(); it != digests.end(); ++it )
	{
		newprofilewizardopenvpnauthpagecontent->UserdefiniedDigestComboBox->insertItem ( *it );
	}

	// pptp
	newprofilewizardpptppage = new TQHBox ( 0 );
	// 	newprofilewizardpptppage->setSpacing(8);
	TQLabel *setupPixmapContent9 = new TQLabel ( newprofilewizardpptppage );
	setupPixmapContent9->setPixmap ( *SetupPixmap );
	setupPixmapContent9->resize ( setupPixmapContent9->sizeHint() );
	newprofilewizardpptppagecontent = new NewProfileWizardPptp ( newprofilewizardpptppage );
	newprofilewizardpptppage->sizeHint();
	newprofilewizardpptppagecontent->DnsServerLineedit->setEnabled ( false );
	newprofilewizardpptppagecontent->RequireMppeCheckbox->setChecked( profileData->getRequireMppe() );
	newprofilewizardpptppagecontent->Refuse128BitEncryptionCheckbox->setChecked( profileData->getRefuse128BitEncryption() );
	newprofilewizardpptppagecontent->Refuse40BitEncryptionCheckbox->setChecked( profileData->getRefuse40BitEncryption() );
	newprofilewizardpptppagecontent->UseNoMPPECompressionCheckbox->setChecked( profileData->getDisableMPPEComp() );
	newprofilewizardpptppagecontent->DnsServerCheckbox->setChecked( profileData->getUseDnsUpdate() );
	newprofilewizardpptppagecontent->DnsServerCheckbox->setChecked( profileData->getUseDnsServer() );
	newprofilewizardpptppagecontent->DnsServerLineedit->setText( profileData->getDnsServer() );
	newprofilewizardpptppagecontent->UseNoBsdCompCheckbox->setChecked( profileData->getUseNoBsdComp() );
	newprofilewizardpptppagecontent->UseNoDeflateCheckbox->setChecked( profileData->getUseNoDeflate() );
	newprofilewizardpptppagecontent->AllowStatefulModeCheckbox->setChecked( profileData->getAllowStatefulMode() );
	newprofilewizardpptppagecontent->UseNoIpDefaultCheckbox->setChecked( profileData->getUseNoIpDefault() );
	newprofilewizardpptppagecontent->DisableCcpCheckbox->setChecked( profileData->getDisableCcp() );
	newprofilewizardpptppagecontent->DisableHeaderCompressionCheckbox->setChecked(profileData->getDisableHeaderCompression());
	newprofilewizardpptppagecontent->DisableMagicNumberNegotiationCheckbox->setChecked(profileData->getDisableMagicNumberNegotiation());
	newprofilewizardpptppagecontent->DisableIpxCheckbox->setChecked(profileData->getDisableIpx());
	newprofilewizardpptppagecontent->DisableAdressControlCompressionCheckbox->setChecked(profileData->getDisableAdressControlCompression());
	newprofilewizardpptppagecontent->DisableProtocolFieldCompressionCheckbox->setChecked(profileData->getDisableProtocolFieldCompression());
	

	newprofilewizardpptppagecontent->AuthMethodComboBox->insertItem ( "chap" );
	newprofilewizardpptppagecontent->AuthMethodComboBox->insertItem ( "pap" );
	newprofilewizardpptppagecontent->AuthMethodComboBox->insertItem ( "mschap" );
	newprofilewizardpptppagecontent->AuthMethodComboBox->insertItem ( "mschap-v2" );

	connect( newprofilewizardpptppagecontent->DnsServerCheckbox, TQT_SIGNAL( toggled(bool) ), this, TQT_SLOT( useDnsServerToggled(bool) ) );
	connect( newprofilewizardpptppagecontent->UseSearchDomainInResolvConfCheckbox, TQT_SIGNAL( toggled(bool) ), this, TQT_SLOT( useSearchDomainInResolvConfToggled(bool) ) );
	connect( newprofilewizardpptppagecontent->UseDomainInResolvConfCheckbox, TQT_SIGNAL( toggled(bool) ), this, TQT_SLOT( useDomainInResolvConfToggled(bool) ) );

	// vtun
	newprofilewizardvtunpage = new TQHBox ( 0 );
	// 	newprofilewizardvtunpage->setSpacing(8);
	TQLabel *setupPixmapContent19 = new TQLabel ( newprofilewizardvtunpage );
	setupPixmapContent19->setPixmap ( *SetupPixmap );
	setupPixmapContent19->resize ( setupPixmapContent19->sizeHint() );
	newprofilewizardvtunpagecontent = new ProfileVtunOptions ( newprofilewizardvtunpage );
	newprofilewizardvtunpage->sizeHint();
	connect ( newprofilewizardvtunpagecontent->PortCheckbox, TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( usePortToggled ( bool ) ) );

	// ssh
	newprofilewizardsshpage = new TQHBox ( 0 );
	// 	newprofilewizardsshpage->setSpacing(8);
	TQLabel *setupPixmapContent191 = new TQLabel ( newprofilewizardsshpage );
	setupPixmapContent191->setPixmap ( *SetupPixmap );
	setupPixmapContent191->resize ( setupPixmapContent191->sizeHint() );
	newprofilewizardsshpagecontent = new ProfileSshOptions ( newprofilewizardsshpage );
	newprofilewizardsshpage->sizeHint();

	TQString Home= TQString(getenv("HOME"));
	if (!Home.isEmpty())
	{
		TQDir dir( Home+"/.ssh" );
		TQStringList KeyFiles = dir.entryList( "*" );
		
		//if (GlobalConfig->KvpncDebugLevel > 2)
		//{
		//	GlobalConfig->appendLogEntry(i18n("SSH files: %1").arg(KeyFiles.join(",")),GlobalConfig->debug);
		//}
		
		if (KeyFiles.size() > 1)
		{
			for ( TQStringList::Iterator it = KeyFiles.begin(); it != KeyFiles.end(); ++it )
			{
				TQString item = TQString(*it);
				if (GlobalConfig->KvpncDebugLevel > 2)
				{
					//GlobalConfig->appendLogEntry(i18n("processing entry: %1").arg(item),GlobalConfig->debug);
				}
				if (!item.contains (".pub", false)  && !item.contains ("authorized_keys", false)  && !item.contains ("known_hosts", false) && !item.contains (".", false) && !item.contains ("..", false) && !item.contains ("config", false) )
				{
					if (GlobalConfig->KvpncDebugLevel > 2)
					{
						GlobalConfig->appendLogEntry(i18n("SSH key found: %1").arg(*it),GlobalConfig->debug);
					}
						newprofilewizardsshpagecontent->SshKeyComboBox->insertItem(*it);
				}
			}
		}
	}


	newprofilewizardauthselectionpage = new TQHBox ( 0 );
	// 	newprofilewizardauthselectionpage->setSpacing(8);
	TQLabel *setupPixmapContent81 = new TQLabel ( newprofilewizardauthselectionpage );
	setupPixmapContent81->setPixmap ( *SetupPixmap );
	setupPixmapContent81->resize ( setupPixmapContent81->sizeHint() );
	newprofilewizardauthselectioncontent = new NewProfileWizardAuthSelection ( newprofilewizardauthselectionpage );
	newprofilewizardauthselectionpage->sizeHint();
	newprofilewizardauthselectioncontent->CertificateRadioButton->setChecked ( true );
	newprofilewizardauthselectioncontent->HybridRadioButton->hide ();


	// virtual ip
	newprofilewizardvirtualipaddresspage = new TQHBox ( 0 );
	TQLabel *setupPixmapContent_virtualip = new TQLabel ( newprofilewizardvirtualipaddresspage );
	setupPixmapContent_virtualip->setPixmap ( *SetupPixmap );
	setupPixmapContent_virtualip->resize ( setupPixmapContent_virtualip->sizeHint() );
	profilenetworkvirtualipoptionscontent = new ProfileNetworkVirtualIpOptions ( newprofilewizardvirtualipaddresspage );
	newprofilewizardvirtualipaddresspage->sizeHint();
	insertPage ( newprofilewizardvirtualipaddresspage, "<b>" + i18n ( "Virtual IP address options" ) + "</b>",-1 );
	connect ( profilenetworkvirtualipoptionscontent->UseVirtualIPCheckBox, TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( useVirtualIpAddressToggled ( bool ) ) );

	// psk
	newprofilewizardpskpage = new TQHBox ( 0 );
	// 	newprofilewizardpskpage->setSpacing(8);
	TQLabel *setupPixmapContent72 = new TQLabel ( newprofilewizardpskpage );
	setupPixmapContent72->setPixmap ( *SetupPixmap );
	setupPixmapContent72->resize ( setupPixmapContent72->sizeHint() );
	newprofilewizardpskcontent = new NewProfileWizardPsk ( newprofilewizardpskpage );
	newprofilewizardpskpage->sizeHint();

	connect ( newprofilewizardpskcontent->PskInFileCheckBox , TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( pskIsInFileToggled ( bool ) ) );
	connect ( newprofilewizardpskcontent->PSKLineEdit , TQT_SIGNAL ( textChanged ( const TQString & ) ), this, TQT_SLOT ( pskInputToggled ( const TQString& ) ) );

	newprofilewizardp12certselectionpage = new TQHBox ( 0 );
	// 	newprofilewizardp12certselectionpage->setSpacing(8);
	TQLabel *setupPixmapContent74 = new TQLabel ( newprofilewizardp12certselectionpage );
	setupPixmapContent74->setPixmap ( *SetupPixmap );
	setupPixmapContent74->resize ( setupPixmapContent74->sizeHint() );
	newprofilewizardp12certselectioncontent = new NewProfileWizardP12CertSelection ( newprofilewizardp12certselectionpage );
	newprofilewizardp12certselectionpage->sizeHint();
	connect ( newprofilewizardp12certselectioncontent->UseSmartcardCheckBox, TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( useSmartcardOnCertFormateToggled ( bool ) ) );

	// cert
	newprofilewizardcertpage = new TQHBox ( 0 );
	// 	newprofilewizardcertpage->setSpacing(8);
	TQLabel *setupPixmapContent73 = new TQLabel ( newprofilewizardcertpage );
	setupPixmapContent73->setPixmap ( *SetupPixmap );
	setupPixmapContent73->resize ( setupPixmapContent73->sizeHint() );
	newprofilewizardcertcontent = new NewProfileWizardCert ( newprofilewizardcertpage );
	newprofilewizardcertpage->sizeHint();
	connect ( newprofilewizardcertcontent->UseSpecialServerCertificateCheckBox , TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( useSpecialServerCertificateToggled ( bool ) ) );
	connect ( newprofilewizardcertcontent->UseSmartcardCheckBox, TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( useSmartcardToggled ( bool ) ) );
	connect ( newprofilewizardcertcontent->UsePkcs11ProvidersCheckBox, TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( usePkcs11ProvidersToggled ( bool ) ) );
	connect ( newprofilewizardcertcontent->DetectPkcs11SlotsPushButton, TQT_SIGNAL ( clicked() ), this, TQT_SLOT ( detectPkcs11Slots() ) );
	connect ( newprofilewizardcertcontent->DetectPkcs11IdPushButton, TQT_SIGNAL ( clicked() ), this, TQT_SLOT ( detectPkcs11Ids() ) );
	newprofilewizardcertcontent->Pkcs11SlotTypeComboBox->setEnabled ( false );
	newprofilewizardcertcontent->Pkcs11SlotTypeLabel->setEnabled ( false );
	newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->setURL ( TQString ( "/usr/local/lib/libetpkcs11.so" ) );


	// user
	newprofilewizarduserpage = new TQHBox ( 0 );
	// 	newprofilewizarduserpage->setSpacing(8);
	TQLabel *setupPixmapContent75 = new TQLabel ( newprofilewizarduserpage );
	setupPixmapContent75->setPixmap ( *SetupPixmap );
	setupPixmapContent75->resize ( setupPixmapContent75->sizeHint() );
	newprofilewizarduserpagecontent = new NewProfileWizardUser ( newprofilewizarduserpage );
	newprofilewizarduserpage->sizeHint();

	connect ( newprofilewizarduserpagecontent->PasswordEdit , TQT_SIGNAL ( textChanged ( const TQString& ) ), this, TQT_SLOT ( userpassToggled ( const TQString& ) ) );
	connect ( newprofilewizarduserpagecontent->UsernameLineEdit , TQT_SIGNAL ( textChanged ( const TQString& ) ), this, TQT_SLOT ( usernameToggled ( const TQString& ) ) );
	connect ( newprofilewizarduserpagecontent->NtDomainNameCheckbox, TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( domainNameToggled ( bool ) ) );
	newprofilewizarduserpagecontent ->NtDomainNameCheckbox->setEnabled ( true );
	newprofilewizarduserpagecontent ->NtDomainNameCheckbox->hide();
	newprofilewizarduserpagecontent ->NtDomainNameLineedit->hide();


	// network
	newprofilewizardnetworkpage = new TQHBox ( 0 );
	// 	newprofilewizardnetworkpage->setSpacing(8);
	TQLabel *setupPixmapContent76 = new TQLabel ( newprofilewizardnetworkpage );
	setupPixmapContent76->setPixmap ( *SetupPixmap );
	setupPixmapContent76->resize ( setupPixmapContent76->sizeHint() );
	newprofilewizardnetworkcontent = new NewProfileWizardNetwork ( newprofilewizardnetworkpage );
	newprofilewizardnetworkpage->sizeHint();
	newprofilewizardnetworkcontent->NetworkDeviceComboBox->insertItem ( "default" );

	NetworkInterface iface ( GlobalConfig, GlobalConfig->appPointer );
	TQStringList list = iface.getAllNetworkInterfaces();
	for ( TQStringList::Iterator it = list.begin(); it != list.end(); ++it )
		newprofilewizardnetworkcontent->NetworkDeviceComboBox->insertItem ( TQString ( *it ) );

	newprofilewizardnetworkcontent->MtuSpinbox->hide();
	newprofilewizardnetworkcontent->MtuCheckbox->hide();
	newprofilewizardnetworkcontent->MruSpinbox->hide();
	newprofilewizardnetworkcontent->MruCheckbox->hide();

	newprofilewizardnetworkcontent->TunnelDeviceTypeLabel->hide();
	newprofilewizardnetworkcontent->TunnelDeviceTypeComboBox->hide();

	newprofilewizardnetworkcontent->TunnelDeviceTypeComboBox->insertItem("tun");
	newprofilewizardnetworkcontent->TunnelDeviceTypeComboBox->insertItem("tap");

	connect ( newprofilewizardnetworkcontent->MtuCheckbox, TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( mtuToggled ( bool ) ) );
	connect ( newprofilewizardnetworkcontent->MtuCheckbox, TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( mtuToggled ( bool ) ) );
	connect ( newprofilewizardnetworkcontent->UseRemoteNetworkCheckBox, TQT_SIGNAL ( toggled ( bool ) ) , this, TQT_SLOT( useRemoteNetworkToggled (bool )));
	connect ( newprofilewizardnetworkcontent->TunnelDeviceTypeComboBox, TQT_SIGNAL(activated ( const TQString & )),this, TQT_SLOT(tunnelDeviceTypeChanged(const TQString& )));

	// network routes
	newprofilewizardnetworkroutepage = new TQHBox ( 0 );
	// 	newprofilewizardnetworkroutepage->setSpacing(8);
	TQLabel *setupPixmapContent761 = new TQLabel ( newprofilewizardnetworkroutepage );
	setupPixmapContent761->setPixmap ( *SetupPixmap );
	setupPixmapContent761->resize ( setupPixmapContent761->sizeHint() );
	newprofilewizardnetworkroutecontent = new ProfileNetworkRouteOptions ( newprofilewizardnetworkroutepage );
	newprofilewizardnetworkroutepage->sizeHint();

	connect(newprofilewizardnetworkroutecontent->DefaultRouteComboBox, TQT_SIGNAL(activated(const TQString&)), this, TQT_SLOT(defaultRouteToggled(const TQString&)));

	newprofilewizardnetworkroutecontent->DefaultRouteComboBox->setCurrentItem(1);


	// nat
	newprofilewizardnatpage = new TQHBox ( 0 );
	// 	newprofilewizardnatpage->setSpacing(8);
	TQLabel *setupPixmapContent77 = new TQLabel ( newprofilewizardnatpage );
	setupPixmapContent77->setPixmap ( *SetupPixmap );
	setupPixmapContent77->resize ( setupPixmapContent77->sizeHint() );
	newprofilewizardnatcontent = new NewProfileWizardNat ( newprofilewizardnatpage );
	newprofilewizardnatpage->sizeHint();
	newprofilewizardnatcontent->UseUdpCheckbox->setChecked ( true );
	newprofilewizardnatcontent->UseNatCheckbox->setChecked ( true );
	connect ( newprofilewizardnatcontent->UseNatCheckbox, TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( useNatToggled ( bool ) ) );
	connect ( newprofilewizardnatcontent->UdpPortCheckbox, TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( udpPortToggled ( bool ) ) );
	useNatToggled(true);

	// connectionstatuscheck
	newprofilewizardconnectionstatuscheckpage = new TQHBox ( 0 );
	// 	newprofilewizardconnectionstatuscheckpage->setSpacing(8);
	TQLabel *setupPixmapContent79 = new TQLabel ( newprofilewizardconnectionstatuscheckpage );
	setupPixmapContent79->setPixmap ( *SetupPixmap );
	setupPixmapContent79->resize ( setupPixmapContent79->sizeHint() );
	newprofilewizardconnectionstatuscheckcontent = new NewProfileWizardConnectionStatusCheck ( newprofilewizardconnectionstatuscheckpage );
	newprofilewizardconnectionstatuscheckpage->sizeHint();
	insertPage ( newprofilewizardconnectionstatuscheckpage, "<b>" + i18n ( "Connection status check" ) + "</b>", -1 );
	connect ( newprofilewizardconnectionstatuscheckcontent->PingUserdefiniedAddressCheckBox, TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( pingIpAfterConnectToggled ( bool ) ) );
	connect ( newprofilewizardconnectionstatuscheckcontent->UseConnectionStatusCheckCheckBox, TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( connectionStatusCheckToggled ( bool ) ) );

	// connectoptions
	newprofilewizardconnectoptionspage = new TQHBox ( 0 );

	// 	newprofilewizardconnectoptionspage->setSpacing(8);
	TQLabel *setupPixmapContent80 = new TQLabel ( newprofilewizardconnectoptionspage );
	setupPixmapContent80->setPixmap ( *SetupPixmap );
	setupPixmapContent80->resize ( setupPixmapContent80->sizeHint() );
	newprofilewizardconnectoptionscontent = new NewProfileWizardConnectOptions ( newprofilewizardconnectoptionspage );
	newprofilewizardconnectoptionspage->sizeHint();
	newprofilewizardconnectoptionscontent->DoAutoConnectCheckBox->hide(); //TODO later
	newprofilewizardconnectoptionscontent->AutoConnectProfileComboBox->hide(); //TODO_ later
	insertPage ( newprofilewizardconnectoptionspage, "<b>" + i18n ( "Connect options" ) + "</b>", -1 );

	// general
	newprofilewizardgeneralpage = new TQHBox ( 0 );
	// 	newprofilewizardgeneralpage->setSpacing(8);
	TQLabel *setupPixmapContent78 = new TQLabel ( newprofilewizardgeneralpage );
	setupPixmapContent78->setPixmap ( *SetupPixmap );
	setupPixmapContent78->resize ( setupPixmapContent78->sizeHint() );
	newprofilewizardgeneralpagecontent = new NewProfileWizardGeneral ( newprofilewizardgeneralpage );
	newprofilewizardgeneralpage->sizeHint();
	insertPage ( newprofilewizardgeneralpage, "<b>" + i18n ( "General settings" ) + "</b>", -1 );

	// setup end page
	endpage = new TQHBox ( 0 );
	// 	endpage->setSpacing(8);
	TQLabel *setupPixmapContent11 = new TQLabel ( endpage );
	setupPixmapContent11->setPixmap ( *SetupPixmapFinal );
	setupPixmapContent11->resize ( setupPixmapContent11->sizeHint() );
	TQLabel *endpagecontent = new TQLabel ( endpage );
	endpagecontent->setMargin ( 11 );
	endpagecontent->setText ( i18n ( "Now you have completed all steps for creating a new profile.\nClick \"Finish\" to continue." ) );
	endpagecontent->setMaximumSize ( endpagecontent->sizeHint() );
	endpage->sizeHint();
	insertPage ( endpage, "<b>" + i18n ( "Finish" ) + "</b>", -1 ); // last page
}

void NewProfileWizard::next ()
{
	// called at each finish of a page
	bool ok = true;
	TQString msg = i18n ( "Please fill in all fields!" );

	if ( currentpage == page1 )
	{
		// nothing here
	}
	else if ( currentpage == newprofilewizardgeneralpage )
	{
		msg = i18n ( "These fields must be filled in:\n" );
		if ( newprofilewizardgeneralpagecontent->NameLineEdit->text().isEmpty() )
		{
			msg += "- " + i18n ( "Name" ) + "\n";
			GlobalConfig->appendLogEntry ( i18n ( "Name is empty!" ), GlobalConfig->error );
		}
		else
		{
			TQString Name = newprofilewizardgeneralpagecontent->NameLineEdit->text();


			bool nameOk = true;
			if ( Name.contains ( ' ' ) )
			{
				KMessageBox::error ( this, i18n ( "Profile name can not contain spaces!" ), i18n ( "Spaces Not Allowed" ) );
				GlobalConfig->appendLogEntry ( i18n ( "Profile name can not contain spaces!" ) , GlobalConfig->error );
				msg += "- " + i18n ( "Name" ) + "\n";
				nameOk = FALSE;
				ok = false;
			}

			if ( Name.isEmpty() )
			{
				KMessageBox::error ( this, i18n ( "Profile name can not be empty!" ), i18n ( "No Name Entered" ) );
				GlobalConfig->appendLogEntry ( i18n ( "Profile name can not be empty!" ) , GlobalConfig->error );
				msg += "- " + i18n ( "Name" ) + "\n";
				nameOk = FALSE;
				ok = false;
			}

			VpnAccountData * it;

			while ( nameOk == false )
			{
				for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
				{
					if ( it->getName() == Name )
					{
						//account->setName( TQString( account->getName() + "_2" ) );
						// 				KMessageBox::information ( this, i18n( "Profile name exists!\n It will be renamed to \"%1\"." ).arg( account->getName() ), i18n( "Name exist, renamed" ) );
						KMessageBox::error ( this, i18n ( "Profile name exists!" ), i18n ( "Name Exists" ) );

						TQString newName = KInputDialog::getText ( i18n ( "New Name" ), i18n ( "New name for profile:" ), TQString ( Name += "_2" ), &ok );

						if ( !Name.isEmpty() )
						{
							nameOk = true;
							break;
						}
					}
					nameOk = true;
				}
				nameOk = true;
			}

			if ( nameOk )
			{
				profileData->setName ( Name );

				if ( GlobalConfig->KvpncDebugLevel > 0 )
					GlobalConfig->appendLogEntry ( i18n ( "Profile name: %1" ).arg ( profileData->getName() ), KVpncConfig::debug );

				newProfileCreated = TRUE;
			}
			else
			{
				return ;
			}
		}

		if ( newprofilewizardgeneralpagecontent->gatewayLineEdit->text().isEmpty() )
		{
			ok = false;
			msg += "- " + i18n ( "Gateway" ) + "\n";
			GlobalConfig->appendLogEntry ( i18n ( "Gateway is empty!" ), GlobalConfig->error );
		}
		else
		{
			profileData->setGateway ( newprofilewizardgeneralpagecontent->gatewayLineEdit->text() );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Gateway: %1" ).arg ( newprofilewizardgeneralpagecontent->gatewayLineEdit->text() ), KVpncConfig::debug );
		}
		profileData->setDescription ( newprofilewizardgeneralpagecontent->DescriptionLineEdit->text() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n ( "Description: %1" ).arg ( newprofilewizardgeneralpagecontent->DescriptionLineEdit->text() ), KVpncConfig::debug );
	}
	else if ( currentpage == newprofilewizardtypeselectionpage )
	{
		if ( newprofilewizardtypeselectionpagecontent->CiscoRadioButton->isChecked() )
		{
			profileData->setConnectionType ( VpnAccountData::cisco );
			removePage ( newprofilewizardcertpage );
			removePage ( newprofilewizardpskpage );
			removePage ( newprofilewizardp12certselectionpage );
			removePage ( newprofilewizardfreeswanpage );
			removePage ( newprofilewizardfreeswanselectionpage );
			removePage ( newprofilewizardracoonpage );
			removePage ( newprofilewizardopenvpnpage );
			removePage ( newprofilewizardopenvpnselectionpage );
			removePage ( newprofilewizardpptppage );
			removePage ( newprofilewizardvirtualipaddresspage );
			newprofilewizardnetworkcontent->RemoteNetworkGroupBox->hide();
// 			newprofilewizardnetworkcontent->LabelRemoteNetwork->hide();
// 			newprofilewizardnetworkcontent->RemoteNetMaskComboBox->hide();
// 			newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->hide();
// 			newprofilewizardnetworkcontent->RemoteNetDividetextLabel->hide();
// 			newprofilewizardp12certselectioncontent->UseSmartcardCheckBox->hide();

			newprofilewizarduserpagecontent ->NtDomainNameCheckbox->show();
			newprofilewizarduserpagecontent ->NtDomainNameLineedit->show();
			
			insertPage ( newprofilewizardciscoselectionpage, "<b>" + i18n ( "Cisco selection" ) + "</b>", indexOf ( currentpage ) + 1 );

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Selected type: %1" ).arg ( "Cisco (free)" ), KVpncConfig::debug );
		}
		else if ( newprofilewizardtypeselectionpagecontent->CiscoVpncRadioButton->isChecked() )
		{
			profileData->setConnectionType ( VpnAccountData::ciscoorig );
// 			removePage ( newprofilewizardcertpage );
			removePage ( newprofilewizardpskpage );
			removePage ( newprofilewizardp12certselectionpage );
			removePage ( newprofilewizardfreeswanpage );
			removePage ( newprofilewizardfreeswanselectionpage );
			removePage ( newprofilewizardracoonpage );
			removePage ( newprofilewizardopenvpnpage );
			removePage ( newprofilewizardopenvpnselectionpage );
			removePage ( newprofilewizardpptppage );
			removePage ( newprofilewizardvirtualipaddresspage );
			newprofilewizardnetworkcontent->LabelRemoteNetwork->hide();
			newprofilewizardnetworkcontent->RemoteNetMaskComboBox->hide();
			newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->hide();
			newprofilewizardnetworkcontent->RemoteNetDividetextLabel->hide();
			newprofilewizardp12certselectioncontent->UseSmartcardCheckBox->hide();

			newprofilewizarduserpagecontent ->NtDomainNameCheckbox->show();
			newprofilewizarduserpagecontent ->NtDomainNameLineedit->show();

			insertPage ( newprofilewizardciscoselectionpage, "<b>" + i18n ( "Cisco selection" ) + "</b>", indexOf ( currentpage ) + 1 );


			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Selected type: %1" ).arg ( "Cisco (propritary)" ), KVpncConfig::debug );
		}
		else if ( newprofilewizardtypeselectionpagecontent->FreeswanRadioButton->isChecked() )
		{
			profileData->setConnectionType ( VpnAccountData::freeswan );
			removePage ( newprofilewizardciscoselectionpage );
			removePage ( newprofilewizardciscomanuallypage );
			removePage ( newprofilewizardopenvpnpage );
			removePage ( newprofilewizardopenvpnselectionpage );
			removePage ( newprofilewizardpptppage );
			removePage ( newprofilewizardvirtualipaddresspage );

			insertPage ( newprofilewizardfreeswanpage, "<b>" + i18n ( "FreeSWAN/OpenSWAN settings" ) + "</b>", indexOf ( currentpage ) + 1 );

			newprofilewizardfreeswanpagecontent->ExchangeModeComboBox->insertItem ( "main", 0 );
			newprofilewizardfreeswanpagecontent->ExchangeModeComboBox->insertItem ( "aggressive", 1 );
			newprofilewizardfreeswanpagecontent->ExchangeModeComboBox->setCurrentItem ( 0 ); // main
			newprofilewizardfreeswanpagecontent->ExchangeModeComboBox->setEnabled ( true );

			newprofilewizardfreeswanpagecontent->IpsecVpnModeCombobox->setCurrentItem(1); // tunnel

			newprofilewizardcertcontent->certpathURLRequester->setURL ( "/etc/ipsec.d/cacerts" );
			newprofilewizardcertcontent->Pkcs11IdTypeComboBox->setEnabled ( false );
			newprofilewizardcertcontent->Pkcs11IdTypeComboBox->setCurrentText ( i18n ( "ID" ) );
			
// 			profileData->setIkeGroup ( "modp2048" ); // default for windows?!
// 			profileData->setAuthenticationAlgorithm ( "hmac_md5" ); // default for windows?!
// 			profileData->setHashAlgo ( "sha1" ); // default for windows?!


// 			newprofilewizardfreeswanpagecontent->InfoLabel->setText ( i18n ( "Please enter %1 specific settings:" ).arg ( "FreeS/WAN/Openswan/strongSwan" ) );
			insertPage ( newprofilewizardfreeswanselectionpage, "<b>" + i18n ( "IPSec selection" ) + "</b>", indexOf ( currentpage ) + 1 );


			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Selected type: %1" ).arg ( "FreeS/WAN/Openswan/strongSwan" ), KVpncConfig::debug );
		}
		else if ( newprofilewizardtypeselectionpagecontent->RacoonRadioButton->isChecked() )
		{
			profileData->setConnectionType ( VpnAccountData::racoon );
			removePage ( newprofilewizardciscoselectionpage );
			removePage ( newprofilewizardciscomanuallypage );
			removePage ( newprofilewizardfreeswanpage );
			removePage ( newprofilewizardfreeswanselectionpage );
			removePage ( newprofilewizardopenvpnpage );
			removePage ( newprofilewizardopenvpnselectionpage );
			removePage ( newprofilewizardpptppage );
			removePage ( newprofilewizardvirtualipaddresspage );


// 			profileData->setIkeGroup ( "modp2048" ); // default for windows?!
// 			profileData->setHashAlgo ( "sha1" ); // default for windows?!
// 			profileData->setAuthenticationAlgorithm ( "hmac_md5" );

			profileData->setUseMailAddressAsIdentifier ( false );

// 			newprofilewizardracoonpagecontent->DHGroupComboBox->setCurrentText ( profileData->getIkeGroup() );
// 			newprofilewizardracoonpagecontent->AuthenticationAlgorithmComboBox->setCurrentText ( profileData->getAuthenticationAlgorithm() );
// 			newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->setCurrentText ( profileData->getEncryptionAlgorithm() );

			Utils::IpsecAlgos KernelCrypto = Utils ( GlobalConfig ).getKernelCrypto();

			// man racoon.conf
			newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("des" );
			newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("3des" );
			newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("blowfish" );
			newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("cast128" );
			newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("aes" );
			newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("camellia" );

			newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->setCurrentText("3des");
			
			// man racoon.conf
			newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem( "md5" );
			newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem( "sha1" );
			newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem( "sha256" );
			newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem( "sha384" );
			newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem( "sha512" );

			newprofilewizardracoonpagecontent->HashAlgoComboBox->setCurrentText("md5");
			
			// vpn mit linux book
			newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("des" );
			newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("3des" );
			newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("des_iv64" );
			newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("des_iv32" );
			newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("rc5" );
			newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("rc4" );
			newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("idea" );
			newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("3idea" );
			newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("cast128" );
			newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("blowfish" );
			newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("null_enc" );
			newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("twofish" );
			newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("rijndael" );
			newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem("aes" );

			newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->setCurrentText("3des");

			newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "des" );
			newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "3des" );
			newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "des_iv64" );
			newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "des_iv32" );
			newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_md5" );
			newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_sha1" );
			newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_sha256" );
			newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_sha384" );
			newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_sha512" );
			newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "non_auth" );

			newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->setCurrentText( "hmac_md5" );
			
			for ( TQStringList::Iterator it = KernelCrypto.IpsecEspEncryptionAlgorithms.begin(); it != KernelCrypto.IpsecEspEncryptionAlgorithms.end(); ++it )
			{
				newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem ( *it );
			}

			newprofilewizardcertcontent->UseSmartcardCheckBox->hide();
			newprofilewizardcertcontent->SmartcardGroupBox->hide();
			newprofilewizardp12certselectioncontent->UseSmartcardCheckBox->hide();


			insertPage ( newprofilewizardauthselectionpage, i18n ( "Authentication settings" ), indexOf ( currentpage ) + 1 );
			insertPage ( newprofilewizardracoonpage, "<b>" + i18n ( "Racoon settings" ) + "</b>", indexOf ( currentpage ) + 2 );

			newprofilewizardauthselectioncontent->HybridRadioButton->show();


			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Selected type: %1" ).arg ( "Racoon" ), KVpncConfig::debug );
		}
		else if ( newprofilewizardtypeselectionpagecontent->L2tpRacoonRadioButton->isChecked() )
		{
			profileData->setConnectionType ( VpnAccountData::l2tpd_racoon );
			removePage ( newprofilewizardciscoselectionpage );
			removePage ( newprofilewizardciscomanuallypage );
			removePage ( newprofilewizardfreeswanpage );
			removePage ( newprofilewizardfreeswanselectionpage );
			removePage ( newprofilewizardopenvpnpage );
			removePage ( newprofilewizardopenvpnselectionpage );
			removePage ( newprofilewizardpptppage );
			removePage ( newprofilewizardnetworkpage );
			removePage ( newprofilewizardvirtualipaddresspage );

			profileData->setUseMailAddressAsIdentifier ( false );

// 			profileData->setIkeGroup ( "modp2048" ); // default for windows?!
// 			profileData->setHashAlgo ( "sha1" ); // default for windows?!
// 			profileData->setAuthenticationAlgorithm ( "hmac_md5" ); // default for windows?

	Utils::IpsecAlgos KernelCrypto = Utils ( GlobalConfig ).getKernelCrypto();

	//FIXME why this is not in kernel crypto list???
// 	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem ( "3des" );

	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("des" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("des_iv64" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("des_iv32" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("rc5" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("rc4" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("idea" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("3idea" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("cast128" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("blowfish" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("null_enc" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("twofish" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("rijndael" );
	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("aes" );

	newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem( "md5" );
	newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem( "sha1" );
	newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem( "sha256" );
	newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem( "sha384" );
	newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem( "sha512" );

	newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "des" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "3des" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "des_iv64" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "des_iv32" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_md5" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_sha1" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_sha256" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_sha384" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_sha512" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem( "non_auth" );

// 	for ( TQStringList::Iterator it = KernelCrypto.IpsecIkeEncryptionAlgorithms.begin(); it !=  KernelCrypto.IpsecIkeEncryptionAlgorithms.end(); ++it )
// 	{
// 		newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem ( *it );
// 	}
// 
// 	for ( TQStringList::Iterator it = KernelCrypto.IpsecIkeHashAlgorithms.begin(); it != KernelCrypto.IpsecIkeHashAlgorithms.end(); ++it )
// 	{
// 		newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem ( *it );
// 	}

	for ( TQStringList::Iterator it = KernelCrypto.IpsecEspEncryptionAlgorithms.begin(); it != KernelCrypto.IpsecEspEncryptionAlgorithms.end(); ++it )
	{
		newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem ( *it );
	}

// 	for ( TQStringList::Iterator it = KernelCrypto.IpsecEspAuthenticationAlgorithms.begin(); it != KernelCrypto.IpsecEspAuthenticationAlgorithms.end(); ++it )
// 	{
// 		newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem ( *it );
// 	}
			insertPage ( newprofilewizardracoonpage, "<b>" + i18n ( "Racoon settings" ) + "</b>", indexOf ( currentpage ) + 1 );
			insertPage ( newprofilewizardauthselectionpage, i18n ( "Authentication settings" ), indexOf ( currentpage ) + 2 );
			insertPage ( newprofilewizarduserpage, "<b>" + i18n ( "User settings" ) + "</b>", indexOf ( currentpage ) + 3 );

			newprofilewizardnetworkcontent->LabelRemoteNetwork->hide();
			newprofilewizardnetworkcontent->RemoteNetMaskComboBox->hide();
			newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->hide();
			newprofilewizardnetworkcontent->RemoteNetDividetextLabel->hide();
			newprofilewizarduserpagecontent ->NtDomainNameCheckbox->show();
			newprofilewizarduserpagecontent ->NtDomainNameLineedit->show();
			newprofilewizardcertcontent->UseSmartcardCheckBox->hide();
			newprofilewizardcertcontent->SmartcardGroupBox->hide();
			newprofilewizardp12certselectioncontent->UseSmartcardCheckBox->hide();
			newprofilewizardcertcontent->certpathURLRequester->setURL ( "/etc/racoon/" );


			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Selected type: %1" ).arg ( "L2TP (racoon)" ), KVpncConfig::debug );
		}
		else if ( newprofilewizardtypeselectionpagecontent->L2tpFreeswanRadioButton->isChecked() )
		{
			profileData->setConnectionType ( VpnAccountData::l2tpd_freeswan );
			removePage ( newprofilewizardciscoselectionpage );
			removePage ( newprofilewizardciscomanuallypage );
			removePage ( newprofilewizardopenvpnpage );
			removePage ( newprofilewizardopenvpnselectionpage );
			removePage ( newprofilewizardpptppage );
			removePage ( newprofilewizardnetworkpage );
			removePage ( newprofilewizardvirtualipaddresspage );

			profileData->setUseMailAddressAsIdentifier ( false );

			newprofilewizardfreeswanpagecontent->ExchangeModeComboBox->insertItem ( "main", 0 );
			newprofilewizardfreeswanpagecontent->ExchangeModeComboBox->insertItem ( "aggressive", 1 );
			newprofilewizardfreeswanpagecontent->ExchangeModeComboBox->setCurrentItem ( 0 ); // main
			newprofilewizardfreeswanpagecontent->ExchangeModeComboBox->setEnabled ( true );
			newprofilewizardfreeswanpagecontent->IpsecVpnModeCombobox->setCurrentItem(1); // transport
			newprofilewizardfreeswanpagecontent->IpsecVpnModeCombobox->setEnabled(false);


			newprofilewizarduserpagecontent ->NtDomainNameCheckbox->show();
			newprofilewizarduserpagecontent ->NtDomainNameLineedit->show();
			newprofilewizardcertcontent->Pkcs11IdTypeComboBox->setEnabled ( false );
			newprofilewizardcertcontent->Pkcs11IdTypeComboBox->setCurrentText ( i18n ( "ID" ) );
			newprofilewizardauthselectioncontent->CertificateRadioButton->setText ( i18n ( "&Certificate/Smartcard" ) );
			newprofilewizardcertcontent->certpathURLRequester->setURL ( "/etc/ipsec.d/cacerts" );

// 			newprofilewizardfreeswanpagecontent->InfoLabel->setText ( i18n ( "Please enter %1 specific settings:" ).arg ( "FreeS/WAN/Openswan/strongSwan" ) );

			insertPage ( newprofilewizardfreeswanselectionpage, "<b>" + i18n ( "IPSec selection" ) + "</b>", indexOf ( currentpage ) + 1 );

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Selected type: %1" ).arg ( "L2TP (OpenS/WAN)" ), KVpncConfig::debug );
		}
		else if ( newprofilewizardtypeselectionpagecontent->OpenvpnRadioButton->isChecked() )
		{
			profileData->setConnectionType ( VpnAccountData::openvpn );
			profileData->setLocalPort ( 1194 );
			profileData->setRemotePort ( 1194 );
			profileData->setUserdefinedPort ( 1194 );
			profileData->setUseSmartcard ( false );
			profileData->setCertPath ( "/etc/openvpn" );
			profileData->setHashAlgo ( "SHA1" );
			profileData->setAuthenticationAlgorithm ( "MD5" );
			removePage ( newprofilewizardciscoselectionpage );
			removePage ( newprofilewizardciscomanuallypage );
			removePage ( newprofilewizardracoonpage );
			removePage ( newprofilewizardpptppage );
			removePage ( newprofilewizardfreeswanpage );
			removePage ( newprofilewizardfreeswanselectionpage );
			newprofilewizardnetworkcontent->LabelRemoteNetwork->hide();
			newprofilewizardnetworkcontent->RemoteNetMaskComboBox->hide();
			newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->hide();
			newprofilewizardnetworkcontent->RemoteNetDividetextLabel->hide();

			newprofilewizardcertcontent->UseSmartcardCheckBox->show();
			newprofilewizardcertcontent->SmartcardGroupBox->show();
			newprofilewizardp12certselectioncontent->UseSmartcardCheckBox->show();
			newprofilewizardauthselectioncontent->CertificateRadioButton->setText ( i18n ( "&Certificate/Smartcard" ) );
			newprofilewizardcertcontent->certpathURLRequester->setURL ( "/etc/openvpn" );

			profilenetworkvirtualipoptionscontent->SourceIpgroupBox->hide();

			insertPage ( newprofilewizardopenvpnauthpage, "<b>" + i18n ( "OpenVPN authentication settings" ) + "</b>", indexOf ( currentpage ) + 1 );

			connect ( newprofilewizardopenvpnauthpagecontent->AuthWithUsernameAndPasswordCheckBox, TQT_SIGNAL ( toggled ( bool ) ), this, TQT_SLOT ( authenticateWithUsernameAndPasswordToggled ( bool ) ) );
			newprofilewizardopenvpnauthpagecontent->UserdefiniedDigestComboBox->setCurrentText ( "SHA1" );


			insertPage ( newprofilewizardopenvpnselectionpage, "<b>" + i18n ( "OpenVPN selection" ) + "</b>", indexOf ( currentpage ) + 1 );

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Selected type: %1" ).arg ( "OpenVPN" ), KVpncConfig::debug );
		}
		else if ( newprofilewizardtypeselectionpagecontent->PptpRadioButton->isChecked() )
		{
			profileData->setConnectionType ( VpnAccountData::pptp );
			profileData->setUseMtu ( false );
			profileData->setUseMru ( false );
			profileData->setMtu ( 1500 );
			profileData->setMru ( 1500 );
			newprofilewizardnetworkcontent->MtuSpinbox->show();
			newprofilewizardnetworkcontent->MtuCheckbox->show();
			newprofilewizardnetworkcontent->MruSpinbox->show();
			newprofilewizardnetworkcontent->MruCheckbox->show();
			newprofilewizardnetworkcontent->MtuSpinbox->setValue ( profileData->getMtu() );
			newprofilewizardnetworkcontent->MruSpinbox->setValue ( profileData->getMru() );
			newprofilewizardnetworkcontent->MtuSpinbox->setEnabled ( false );
			newprofilewizardnetworkcontent->MruSpinbox->setEnabled ( false );
			newprofilewizardnetworkcontent->MtuCheckbox->setChecked ( false );
			newprofilewizardnetworkcontent->MruCheckbox->setChecked ( false );

			newprofilewizardpptppagecontent->AuthMethodComboBox->setCurrentText ( profileData->getAuthMethod() );
			newprofilewizardpptppagecontent->L2tpDaemonComboBox->hide();
			newprofilewizardpptppagecontent->L2tpdDaemonLabel->hide();
			newprofilewizardpptppagecontent->AuthGroupBox->hide();
			newprofilewizardpptppagecontent->UseNoDeflateCheckbox->setChecked( ! profileData->getUseNoDeflate());
			newprofilewizardpptppagecontent->UseNoBsdCompCheckbox->setChecked( ! profileData->getUseNoBsdComp());

			removePage ( newprofilewizardciscoselectionpage );
			removePage ( newprofilewizardciscomanuallypage );
			removePage ( newprofilewizardcertpage );
			removePage ( newprofilewizardpskpage );
			removePage ( newprofilewizardp12certselectionpage );
			removePage ( newprofilewizardfreeswanpage );
			removePage ( newprofilewizardfreeswanselectionpage );
			removePage ( newprofilewizardracoonpage );
			removePage ( newprofilewizardopenvpnpage );
			removePage ( newprofilewizardopenvpnselectionpage );
			insertPage ( newprofilewizardpptppage, "<b>" + i18n ( "PPTP settings" ) + "</b>", indexOf ( currentpage ) + 1 );
			insertPage ( newprofilewizardnetworkpage, "<b>" + i18n ( "Network settings" ) + "</b>", indexOf ( currentpage ) + 2 );
			insertPage ( newprofilewizardnetworkroutepage, "<b>" + i18n ( "Network routes" ) + "</b>", indexOf ( currentpage ) + 3 );
			
			newprofilewizarduserpagecontent ->NtDomainNameCheckbox->show();
			newprofilewizarduserpagecontent ->NtDomainNameLineedit->show();
			newprofilewizardcertcontent->UseSmartcardCheckBox->hide();
			newprofilewizardcertcontent->SmartcardGroupBox->hide();
			
			profilenetworkvirtualipoptionscontent->SourceIpgroupBox->hide();


			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Selected type: %1" ).arg ( "PPTP" ), KVpncConfig::debug );
		}
		else if ( newprofilewizardtypeselectionpagecontent->VtunRadioButton->isChecked() )
		{
			profileData->setConnectionType ( VpnAccountData::vtun );
			profileData->setLocalPort ( 5000 );
			profileData->setRemotePort ( 5000 );
			profileData->setUserdefinedPort ( 5000 );
			profileData->setUseSmartcard ( false );
// 			profileData->setCertPath( "/etc/openvpn" );
// 			profileData->setHashAlgo("SHA1");
// 			profileData->setAuthenticationAlgorithm("MD5");
			removePage ( newprofilewizardciscoselectionpage );
			removePage ( newprofilewizardciscomanuallypage );
			removePage ( newprofilewizardracoonpage );
			removePage ( newprofilewizardpptppage );
			removePage ( newprofilewizardfreeswanpage );
			removePage ( newprofilewizardfreeswanselectionpage );
			removePage ( newprofilewizardopenvpnpage );
			newprofilewizardnetworkcontent->LabelRemoteNetwork->hide();
			newprofilewizardnetworkcontent->RemoteNetMaskComboBox->hide();
			newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->hide();
			newprofilewizardnetworkcontent->RemoteNetDividetextLabel->hide();


			insertPage ( newprofilewizardvtunpage, "<b>" + i18n ( "Vtun options" ) + "</b>",2 );
			insertPage ( newprofilewizardnetworkpage, "<b>" + i18n ( "Network settings" ) + "</b>", indexOf ( currentpage ) + 3 );
			insertPage ( newprofilewizardnetworkroutepage, "<b>" + i18n ( "Network routes" ) + "</b>", indexOf ( currentpage ) + 4 );


			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Selected type: %1" ).arg ( "Vtun" ), KVpncConfig::debug );
		}
		else if ( newprofilewizardtypeselectionpagecontent->SshRadioButton->isChecked() )
		{
			profileData->setConnectionType ( VpnAccountData::ssh );
			profileData->setRemotePort ( 22 );
			profileData->setUseSmartcard ( false );
			profileData->setTunnelDeviceType("tun");
			removePage ( newprofilewizardvtunpage);
			removePage ( newprofilewizardciscoselectionpage );
			removePage ( newprofilewizardciscomanuallypage );
			removePage ( newprofilewizardracoonpage );
			removePage ( newprofilewizardpptppage );
			removePage ( newprofilewizardfreeswanpage );
			removePage ( newprofilewizardfreeswanselectionpage );
			removePage ( newprofilewizardopenvpnpage );
			newprofilewizardnetworkcontent->LabelRemoteNetwork->hide();
			newprofilewizardnetworkcontent->RemoteNetMaskComboBox->hide();
			newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->hide();
			newprofilewizardnetworkcontent->RemoteNetDividetextLabel->hide();
			
			profilenetworkvirtualipoptionscontent->SourceIpgroupBox->hide();
			
			newprofilewizardnetworkcontent->LabelRemoteNetwork->hide();
			newprofilewizardnetworkcontent->RemoteNetMaskComboBox->hide();
			newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->hide();
			newprofilewizardnetworkcontent->RemoteNetDividetextLabel->hide();
			newprofilewizardnetworkcontent->UseRemoteNetworkCheckBox->hide();
			newprofilewizardnetworkcontent->RemoteNetworkGroupBox->hide();

			newprofilewizardnetworkcontent->TunnelDeviceTypeLabel->show();
			newprofilewizardnetworkcontent->TunnelDeviceTypeComboBox->show();
			newprofilewizardnetworkcontent->TunnelDeviceTypeLabel->setEnabled(true);
			newprofilewizardnetworkcontent->TunnelDeviceTypeComboBox->setEnabled(true);
			

			profilenetworkvirtualipoptionscontent->UseVirtualIPCheckBox->setChecked(true);
			newprofilewizarduserpagecontent->UsernameLineEdit->setText("root");
	
			insertPage ( newprofilewizarduserpage, "<b>" + i18n ( "User settings" ) + "</b>", indexOf ( currentpage ) + 1 );
			insertPage ( newprofilewizardsshpage, "<b>" + i18n ( "SSH options" ) + "</b>",2 );
			insertPage ( newprofilewizardnetworkpage, "<b>" + i18n ( "Network settings" ) + "</b>", indexOf ( currentpage ) + 3 );
			insertPage ( newprofilewizardnetworkroutepage, "<b>" + i18n ( "Network routes" ) + "</b>", indexOf ( currentpage ) + 4 );

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Selected type: %1" ).arg ( "SSH" ), KVpncConfig::debug );
		}


		TQString type = ""; // visible name
		TQString bin = "";  // executable name
		if ( profileData->getConnectionType() == VpnAccountData::cisco )
		{
			type = "vpnc";
			bin = "vpnc";
		}
		else if ( profileData->getConnectionType() == VpnAccountData::freeswan )
		{
			type = "freeswan";
			bin = "ipsec";
		}
		else if ( profileData->getConnectionType() == VpnAccountData::racoon )
		{
			type = "racoon";
			bin = "racoon";
		}
		else if ( profileData->getConnectionType() == VpnAccountData::l2tpd_racoon )
		{
			type = "L2TP (racoon)";
			bin = "racoon";
		}
		else if ( profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan )
		{
			type = "L2TP (OpenSWAN)";
			bin = "ipsec";
		}
		else if ( profileData->getConnectionType() == VpnAccountData::pptp )
		{
			type = "pptp";
			bin = "pppd pptp";
		}
		else if ( profileData->getConnectionType() == VpnAccountData::openvpn )
		{
			type = "openvpn";
			bin = "openvpn";
		}
		else if ( profileData->getConnectionType() == VpnAccountData::vtun )
		{
			type = "vtun";
			bin = "vtund";
		}
		else if ( profileData->getConnectionType() == VpnAccountData::ssh )
		{
			type = "ssh";
			bin = "ssh";
		}
		else
		{
			type = "other";
			bin = "";
		}

		ToolInfo *it = 0;
		//std::cout << "Tool (bin): " << bin << std::endl;

		if ( !GlobalConfig->ToolList->isEmpty() )
		{
			if ( type != "pptp" )
			{
				it = Utils ( GlobalConfig ).getToolInfo ( bin );
				if ( it != 0 )
				{
					if ( it->PathToExec.section ( '/', -1 ) == bin )
					{
						if ( GlobalConfig->KvpncDebugLevel > 0 )
							GlobalConfig->appendLogEntry ( i18n ( "The required daemon (%1) is available, you will be able to use this connection." ).arg ( bin ), KVpncConfig::info );
						daemonavailable = true;
					}
					else
					{
						KMessageBox::information ( this, i18n ( "The required daemon (%1) isn't available, you will not be able to use this connection until the daemon is not installed." ).arg ( bin ) );
						if ( GlobalConfig->KvpncDebugLevel > 0 )
							GlobalConfig->appendLogEntry ( i18n ( "The required daemon (%1) isn't available, you will not be able to use this connection until the daemon is not installed." ).arg ( bin ), KVpncConfig::error );
						daemonavailable = false;
						removePage ( newprofilewizardconnectoptionspage );
					}
				}
				if ( type == "ipsec" )
				{

					TQString realversion = it->Version.section ( ' ', 1, 1 ).section ( '/', 0, 0 ).right ( it->Version.section ( ' ', 1, 1 ).section ( '/', 0, 0 ).length() - 1 );
					TQString realtype = it->Version.section ( ' ', 0, 0 ).lower();

					if ( realversion.find ( "1.", 0, -1 ) > -1 )
					{
						KMessageBox::information ( this, i18n ( "The required version (%1) of FreeSWAN/OpenSWAN was not found. You will not be able to use the Agressive Mode. It will be used the Main Mode." ).arg ( "2" ) );
						if ( GlobalConfig->KvpncDebugLevel > 0 )
							GlobalConfig->appendLogEntry ( i18n ( "The required version (%1) of FreeSWAN/OpenSWAN was not found. You will not be able to use the Agressive Mode. It will be used the Main Mode." ).arg ( "2" ).arg ( bin ), KVpncConfig::error );
					}
				}
			}
			else
			{
				bool pppd_and_pptp_available = false;
				it = Utils ( GlobalConfig ).getToolInfo ( "pppd" );
				if ( it->PathToExec.section ( '/', -1 ) == "pppd" )
				{
					it = Utils ( GlobalConfig ).getToolInfo ( "pptp" );
					if ( it->PathToExec.section ( '/', -1 ) == "pptp" )
						pppd_and_pptp_available = true;
				}
				if ( pppd_and_pptp_available )
				{
					// programs are installed
					daemonavailable = true;
					if ( GlobalConfig->KvpncDebugLevel > 0 )
						GlobalConfig->appendLogEntry ( i18n ( "The required daemons (%1 and %2) are available." ).arg ( "pppd" ).arg ( "pptp" ), KVpncConfig::info );
				}
				else
				{
					KMessageBox::information ( this, i18n ( "The required daemons (%1 and %2) aren't available, you will not be able to use this connection until the daemons are not installed." ).arg ( "pppd" ).arg ( "pptpd" ) );
					GlobalConfig->appendLogEntry ( i18n ( "The required daemons (%1 and %2) are not available, connect will be disabled." ).arg ( "pppd" ).arg ( "pptpd" ), KVpncConfig::error );
					daemonavailable = false;
					removePage ( newprofilewizardconnectoptionspage );
				}
			}

		}

	}
	else if ( currentpage == newprofilewizardciscoselectionpage )
	{
		if ( newprofilewizardciscoselectionpagecontent->PcfImportRadioButton->isChecked() )
		{
			enterdatamanually = false;
			removePage ( newprofilewizardciscomanuallypage );
			removePage ( newprofilewizardgeneralpage );
			//insertPage ( newprofilewizarduserpage, "<b>" + i18n ( "User settings" ) + "</b>", indexOf ( currentpage ) + 1 );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Cisco selection: import PCF file" ), KVpncConfig::debug );

			if ( profileData->getConnectionType() == VpnAccountData::cisco )
				importProfile ( VpnAccountData::cisco );
			if ( profileData->getConnectionType() == VpnAccountData::ciscoorig )
				importProfile ( VpnAccountData::ciscoorig );
			if ( importOK )
				newProfileCreated = true;
			else
				newProfileCreated = false;

		}
		else
		{
			enterdatamanually = true;

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Cisco selection: enter data manually" ), KVpncConfig::debug );

			if ( profileData->getConnectionType() == VpnAccountData::cisco )
			{
				if ( GlobalConfig->KvpncDebugLevel > 0 )
					GlobalConfig->appendLogEntry ( i18n ( "Cisco selection: cisco" ), KVpncConfig::debug );

				insertPage ( newprofilewizarduserpage, "<b>" + i18n ( "User settings" ) + "</b>", indexOf ( currentpage ) + 1 );
				insertPage ( newprofilewizardciscomanuallypage, "<b>" + i18n ( "Cisco settings" ) + "</b>", indexOf ( currentpage ) + 2 );
				insertPage ( newprofilewizardnetworkpage, "<b>" + i18n ( "Network settings" ) + "</b>", indexOf ( currentpage ) + 3 );
    				insertPage ( newprofilewizardnetworkroutepage, "<b>" + i18n ( "Network routes" ) + "</b>", indexOf ( currentpage ) + 4 );
			}
			if ( profileData->getConnectionType() == VpnAccountData::ciscoorig )
			{
				if ( GlobalConfig->KvpncDebugLevel > 0 )
					GlobalConfig->appendLogEntry ( i18n ( "Cisco selection: ciscoorig" ), KVpncConfig::debug );

				insertPage ( newprofilewizardauthselectionpage, "<b>"+ i18n ( "Authentication settings" ) +"</b>",  indexOf ( currentpage ) + 1 );
				insertPage ( newprofilewizarduserpage, "<b>" + i18n ( "User settings" ) + "</b>", indexOf ( currentpage ) + 2 );
				insertPage ( newprofilewizardnetworkpage, "<b>" + i18n ( "Network settings" ) + "</b>", indexOf ( currentpage ) + 4 );
				insertPage ( newprofilewizardnetworkroutepage, "<b>" + i18n ( "Network routes" ) + "</b>", indexOf ( currentpage ) + 5 );

				newprofilewizardauthselectioncontent->PskRadioButton->setChecked(true);
			}

		}
	}
	else if ( currentpage == newprofilewizardciscomanuallypage )
	{
		msg = i18n ( "These fields must be filled in:\n" );
		if ( newprofilewizardciscomanuallypagecontent->IDLineEdit->text().isEmpty() )
		{
			ok = false;
			msg += "- " + i18n ( "Cisco IPSec ID" ) + "\n";
			GlobalConfig->appendLogEntry ( i18n ( "Cisco IPSec ID is empty!" ), GlobalConfig->error );
		}
		profileData->setGateway ( newprofilewizardciscomanuallypagecontent->IDLineEdit->text() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n ( "Cisco IPSec ID: %1" ).arg ( newprofilewizardciscomanuallypagecontent->IDLineEdit->text() ), KVpncConfig::debug );

		profileData->setAllowEmptyGroupPassword ( newprofilewizardciscomanuallypagecontent->AllowEmptyGroupPasswordCheckBox->isChecked() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
		{
			if ( newprofilewizardciscomanuallypagecontent->AllowEmptyGroupPasswordCheckBox->isChecked() )
				GlobalConfig->appendLogEntry ( i18n ( "Allow empty group password: true" ), KVpncConfig::debug );
			else
				GlobalConfig->appendLogEntry ( i18n ( "Allow empty group password: false" ), KVpncConfig::debug );
		}

// 		if ( !newprofilewizardciscomanuallypagecontent->AllowEmptyGroupPasswordCheckBox->isChecked() && newprofilewizardciscomanuallypagecontent->GroupPasswordLineEdit->text().isEmpty() )
// 		{
// 			ok = false;
// 			msg += "- " + i18n( "Group password" ) + "\n";
// 			GlobalConfig->appendLogEntry( i18n( "Group password  is empty but you dont have checked to allow that!" ), GlobalConfig->error );
// 		}
// 		else
		profileData->setPreSharedKey ( newprofilewizardciscomanuallypagecontent->GroupPasswordLineEdit->text() );

		profileData->setSavePsk ( newprofilewizardciscomanuallypagecontent->CheckSavePsk->isChecked() );
		
		profileData->setID ( newprofilewizardciscomanuallypagecontent->IDLineEdit->text() );
		profileData->setAllowEmptyGroupPassword ( newprofilewizardciscomanuallypagecontent->AllowEmptyGroupPasswordCheckBox->isChecked() );
		
		profileData->setUseDpdIdleTimeout(true);
		if (profileData->getConnectionType() == VpnAccountData::cisco )
			profileData->setDpdIdleTimeout(300);
		if (profileData->getConnectionType() == VpnAccountData::ciscoorig )
			profileData->setDpdIdleTimeout(90);
		
		insertPage ( newprofilewizarduserpage, "<b>" + i18n ( "User settings" ) + "</b>", indexOf ( currentpage ) + 1 );
		insertPage ( newprofilewizardnetworkpage, "<b>" + i18n ( "Network settings" ) + "</b>", indexOf ( currentpage ) + 2 );
		insertPage ( newprofilewizardnatpage, "<b>" + i18n ( "NAT settings" ) + "</b>", indexOf ( currentpage ) + 3 );
		insertPage ( newprofilewizardnetworkroutepage, "<b>" + i18n ( "Network routes" ) + "</b>", indexOf ( currentpage ) + 4 );

	}
	else if ( currentpage == newprofilewizardfreeswanpage )
	{
		msg = i18n ( "These fields must be filled in:\n" );
		profileData->setUseModeConfig ( newprofilewizardfreeswanpagecontent->UseModeConfigCheckBox->isChecked() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
		{
			if ( newprofilewizardfreeswanpagecontent->UseModeConfigCheckBox->isChecked() )
				GlobalConfig->appendLogEntry ( i18n ( "Use Mode Config: %1" ).arg ( i18n ( "yes" ) ), KVpncConfig::debug );
			else
				GlobalConfig->appendLogEntry ( i18n ( "Use Mode Config: %1" ).arg ( i18n ( "no" ) ), KVpncConfig::debug );
		}

		profileData->setExchangeMode ( newprofilewizardfreeswanpagecontent->ExchangeModeComboBox->currentText() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n ( "Exchange mode (%1): %2" ).arg ( "ipsec" ).arg ( newprofilewizardfreeswanpagecontent->ExchangeModeComboBox->currentText() ), KVpncConfig::debug );

		profileData->setLeftNextHop ( newprofilewizardfreeswanpagecontent->LeftNextHopLineEdit->text() ); //TODO check valid IP
		profileData->setRightNextHop ( newprofilewizardfreeswanpagecontent->RightNextHopLineEdit->text( ) ); //TODO check valid IP
		profileData->setDisableOpportunisticEncryption ( newprofilewizardfreeswanpagecontent->DisableOpportunisticEncryptionCheckBox->isChecked( ) );

		// xauth
		if (newprofilewizardfreeswanpagecontent->UseXauthCheckBox->isChecked())
		{
			profileData->setAuthWithUsernameAndPassword(true);
		}
		else
		{
			profileData->setAuthWithUsernameAndPassword(false);
		}

		if ( GlobalConfig->KvpncDebugLevel > 0 )
		{
			if ( newprofilewizardfreeswanpagecontent->DisableOpportunisticEncryptionCheckBox->isChecked() )
				GlobalConfig->appendLogEntry ( i18n ( "Disable opportunistic encryption: %1" ).arg ( i18n ( "yes" ) ), KVpncConfig::debug );
			else
				GlobalConfig->appendLogEntry ( i18n ( "Disable opportunistic encryption: %1" ).arg ( i18n ( "no" ) ), KVpncConfig::debug );
			GlobalConfig->appendLogEntry ( i18n ( "Right next hop: %1" ).arg ( newprofilewizardfreeswanpagecontent->RightNextHopLineEdit->text() ), KVpncConfig::debug );
			GlobalConfig->appendLogEntry ( i18n ( "Left next hop: %1" ).arg ( newprofilewizardfreeswanpagecontent->LeftNextHopLineEdit->text() ), KVpncConfig::debug );
			GlobalConfig->appendLogEntry ( i18n ( "Use PFS: %1" ).arg ( profileData->getPerfectForwardSecrety() ), KVpncConfig::debug );

		}

		profileData->setExchangeMode ( newprofilewizardfreeswanpagecontent->ExchangeModeComboBox->currentText() );

		if (newprofilewizardfreeswanpagecontent->UseXauthCheckBox->isChecked())
		{
			if ( newprofilewizardfreeswanpagecontent->LocalIDLineEdit->text().isEmpty() )
			{
				ok = false;
				msg += "- " + i18n ( "Local ID  (Group ID)" ) + "\n";
				GlobalConfig->appendLogEntry ( i18n ( "Local ID (Group ID)  is empty!" ), GlobalConfig->error );
			}
			profileData->setUseSpecialLocalID(true);
		}
		
		profileData->setLocalIDType ( newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox->currentText() );

		if (newprofilewizardfreeswanpagecontent->RemoteIdTypeCombobox->currentText() != "none" && newprofilewizardfreeswanpagecontent->RemoteIDLineEdit->text().isEmpty() )
		{
			ok = false;
			msg += "- " + i18n ( "Remote ID" ) + "\n";
			GlobalConfig->appendLogEntry ( i18n ( "Remote ID is empty!" ), GlobalConfig->error );
		}
		if (newprofilewizardfreeswanpagecontent->RemoteIdTypeCombobox->currentText() != "none")
			profileData->setUseSpecialRemoteID(true);
		else
			profileData->setUseSpecialRemoteID(false);
		
		profileData->setRemoteIDType ( newprofilewizardfreeswanpagecontent->RemoteIdTypeCombobox->currentText() );


		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n ( "Type of local ID: %1" ).arg ( newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox->currentText() ), KVpncConfig::debug );

		profileData->setSpecialLocalID ( newprofilewizardfreeswanpagecontent->LocalIDLineEdit->text() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n ( "Local ID value: %1" ).arg ( newprofilewizardfreeswanpagecontent->LocalIDLineEdit->text() ), KVpncConfig::debug );

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n ( "Type of remote ID: %1" ).arg ( newprofilewizardfreeswanpagecontent->RemoteIdTypeCombobox->currentText() ), KVpncConfig::debug );

		profileData->setSpecialRemoteID ( newprofilewizardfreeswanpagecontent->RemoteIDLineEdit->text() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n ( "Remote ID value: %1" ).arg ( newprofilewizardfreeswanpagecontent->RemoteIDLineEdit->text() ), KVpncConfig::debug );


				// ike + esp
				TQStringList IkeList;
				TQStringList EspList;

				if (newprofilewizardfreeswanpagecontent->IkeAes256Sha1CheckBox->isChecked())
					IkeList.append("aes256-sha1");
				if (newprofilewizardfreeswanpagecontent->IkeAes128Sha1CheckBox->isChecked())
					IkeList.append("aes128-sha1");
				if (newprofilewizardfreeswanpagecontent->IkeDesSha1Modp2048CheckBox->isChecked())
					IkeList.append("3des-sha1-modp2048");
				if (newprofilewizardfreeswanpagecontent->IkeDesMd5CheckBox->isChecked())
					IkeList.append("3des-md5");
				if (newprofilewizardfreeswanpagecontent->IkeDesSha1CheckBox->isChecked())
					IkeList.append("3des-sha1");

				if (!newprofilewizardfreeswanpagecontent->OtherIkeLineEdit->text().isEmpty())
					IkeList.append(newprofilewizardfreeswanpagecontent->OtherIkeLineEdit->text());

				if (newprofilewizardfreeswanpagecontent->Esp3desMd5CheckBox->isChecked())
					EspList.append("3des-md5");
				if (newprofilewizardfreeswanpagecontent->EspDesSha1CheckBox->isChecked())
					EspList.append("3des-sha1");
				if (newprofilewizardfreeswanpagecontent->EspAes128Sha1CheckBox->isChecked())
					EspList.append( "aes128-sha1");
				if (newprofilewizardfreeswanpagecontent->EspAes256Sha1CheckBox->isChecked())
					EspList.append( "aes256-sha1");

				if (!newprofilewizardfreeswanpagecontent->OtherEspLineEdit->text().isEmpty())
					EspList.append(newprofilewizardfreeswanpagecontent->OtherEspLineEdit->text());

// 				for ( TQStringList::Iterator ikeit = IkeList.begin(); ikeit != IkeList.end(); ++ikeit )
// 					std::cout << "ike: " << *ikeit << ":" << std::endl;

// 				for ( TQStringList::Iterator espit = EspList.begin(); espit != EspList.end(); ++espit )
// 					std::cout << "esp: " << *espit << ":" << std::endl;

				if(newprofilewizardfreeswanpagecontent->UseCustomEspCheckBox->isChecked() && !EspList.isEmpty())
				{
					profileData->setUseCustomEsp(true);
					if ( GlobalConfig->KvpncDebugLevel > 0 )
						GlobalConfig->appendLogEntry ( i18n ( "Use custom %1: %2" ).arg ( i18n("ESP") ).arg(i18n("yes")), KVpncConfig::debug );

					profileData->setIpsecEsp(EspList.join(","));

					if ( GlobalConfig->KvpncDebugLevel > 0 )
						GlobalConfig->appendLogEntry ( i18n ( "ESP settings: %1" ).arg ( EspList.join(",") ), KVpncConfig::debug );
		
				}
				else if(newprofilewizardfreeswanpagecontent->UseCustomEspCheckBox->isChecked() && EspList.isEmpty())
				{
					ok = false;
					msg += "- " + i18n ( "Use custom ESP checked but none selected!" ) + "\n";
					GlobalConfig->appendLogEntry ( i18n ( "Use custom ESP checked but none selected!" ), GlobalConfig->error );
				}
				else if(!newprofilewizardfreeswanpagecontent->UseCustomEspCheckBox->isChecked())
				{
					profileData->setUseCustomEsp(false);
					if ( GlobalConfig->KvpncDebugLevel > 0 )
						GlobalConfig->appendLogEntry ( i18n ( "Use custom %1: %2" ).arg ( i18n("ESP") ).arg(i18n("no")), KVpncConfig::debug );
				}

				if(newprofilewizardfreeswanpagecontent->UseCustomIkeCheckBox->isChecked() && !IkeList.isEmpty())
				{
					profileData->setUseCustomIke(true);
					if ( GlobalConfig->KvpncDebugLevel > 0 )
						GlobalConfig->appendLogEntry ( i18n ( "Use custom %1: %2" ).arg ( i18n("IKE") ).arg(i18n("yes")), KVpncConfig::debug );

					profileData->setIpsecIke(IkeList.join(","));

					if ( GlobalConfig->KvpncDebugLevel > 0 )
						GlobalConfig->appendLogEntry ( i18n ( "IKE settings: %1" ).arg ( IkeList.join(",") ), KVpncConfig::debug );
		
				}
				else if(newprofilewizardfreeswanpagecontent->UseCustomIkeCheckBox->isChecked() && IkeList.isEmpty())
				{
					ok = false;
					msg += "- " + i18n ( "Use custom IKE checked but none selected!" ) + "\n";
					GlobalConfig->appendLogEntry ( i18n ( "Use custom IKE checked but none selected!" ), GlobalConfig->error );
				}
				else if (!newprofilewizardfreeswanpagecontent->UseCustomIkeCheckBox->isChecked())
				{
					profileData->setUseCustomIke(false);
					if ( GlobalConfig->KvpncDebugLevel > 0 )
						GlobalConfig->appendLogEntry ( i18n ( "Use custom %1: %2" ).arg ( i18n("IKE") ).arg(i18n("false")), KVpncConfig::debug );
				}

			if (ok)
			{
				if (newprofilewizardfreeswanpagecontent->UseXauthCheckBox->isChecked())
				{
					if (GlobalConfig->KvpncDebugLevel > 1)
						GlobalConfig->appendLogEntry ( i18n ( "Authenticate with username and password: %1" ).arg ( i18n ( "yes" ) ), KVpncConfig::debug );
					profileData->setAuthWithUsernameAndPassword(true);
					
					insertPage ( newprofilewizarduserpage, "<b>" + i18n ( "User settings" ) + "</b>", indexOf ( currentpage ) + 1 );
					insertPage ( newprofilewizardnetworkpage, "<b>" + i18n ( "Network settings" ) + "</b>", indexOf ( currentpage ) + 2 );
					insertPage ( newprofilewizardnatpage, "<b>" + i18n ( "NAT settings" ) + "</b>", indexOf ( currentpage ) + 3 );
					insertPage ( newprofilewizardnetworkroutepage, "<b>" + i18n ( "Network routes" ) + "</b>", indexOf ( currentpage ) + 4 );
				}
				else
				{
					if (GlobalConfig->KvpncDebugLevel > 1)
						GlobalConfig->appendLogEntry ( i18n ( "Authenticate with username and password: %1" ).arg ( i18n ( "no" ) ), KVpncConfig::debug );
					
					insertPage ( newprofilewizardnetworkpage, "<b>" + i18n ( "Network settings" ) + "</b>", indexOf ( currentpage ) + 1 );
					insertPage ( newprofilewizardnatpage, "<b>" + i18n ( "NAT settings" ) + "</b>", indexOf ( currentpage ) + 2 );
					insertPage ( newprofilewizardnetworkroutepage, "<b>" + i18n ( "Network routes" ) + "</b>", indexOf ( currentpage ) + 3 );
				}
			}

	}
	else if ( currentpage == newprofilewizardfreeswanselectionpage )
	{
		if ( newprofilewizardfreeswanselectionpagecontent->OpenvpnImportRadioButton->isChecked() )
		{
			enterdatamanually = false;
			removePage ( newprofilewizardfreeswanpage );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "IPSec selection: import profile file" ), KVpncConfig::debug );

			// 			removePage ( newprofilewizardgeneralpage );
// 			removePage ( newprofilewizardvirtualipaddresspage );

			if ( importProfile ( VpnAccountData::freeswan ) == true )
			{
				newProfileCreated = true;
				newprofilewizardgeneralpagecontent->NameLineEdit->setText ( profileData->getName() );
				newprofilewizardgeneralpagecontent->gatewayLineEdit->setText ( profileData->getGateway() );
				newprofilewizardgeneralpagecontent->DescriptionLineEdit->setText ( profileData->getDescription() );

			}
			else
			{
				newProfileCreated = false;
				ok = false;
			}
		}
		else
		{
			enterdatamanually = true;
			insertPage ( newprofilewizardfreeswanpage, "<b>" + i18n ( "IPSec settings" ) + "</b>", indexOf ( currentpage ) + 1 );
			insertPage ( newprofilewizardauthselectionpage, i18n ( "Authentication settings" ), indexOf ( currentpage ) + 1 );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "IPSec selection: enter data manually" ), KVpncConfig::debug );
		}

	}
	else if ( currentpage == newprofilewizardracoonpage )
	{
		if ( newprofilewizardracoonpagecontent->HashAlgoComboBox->currentText() == "SHA1" )
		{
			profileData->setHashAlgo ( "sha1" );
		}
		if ( newprofilewizardracoonpagecontent->HashAlgoComboBox->currentText() == "MD5" )
		{
			profileData->setHashAlgo ( "md5" );
		}

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n ( "Hash algorithm (%1): %2" ).arg ( "racoon" ).arg ( profileData->getHashAlgo() ), KVpncConfig::debug );

		if ( newprofilewizardtypeselectionpagecontent->RacoonRadioButton->isChecked() )
		{
			profileData->setUseModeConfig ( newprofilewizardracoonpagecontent->UseModeConfigCheckBox->isChecked() );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
			{
				if ( newprofilewizardracoonpagecontent->UseModeConfigCheckBox->isChecked() )
					GlobalConfig->appendLogEntry ( i18n ( "Use Mode Config: %1" ).arg ( i18n ( "yes" ) ), KVpncConfig::debug );
				else
					GlobalConfig->appendLogEntry ( i18n ( "Use Mode Config: %1" ).arg ( i18n ( "no" ) ), KVpncConfig::debug );
			}
		}

		profileData->setExchangeMode ( newprofilewizardracoonpagecontent->ExchangeModeComboBox->currentText() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n ( "Exchange mode (%1): %2" ).arg ( "racoon" ).arg ( newprofilewizardracoonpagecontent->ExchangeModeComboBox->currentText() ), KVpncConfig::debug );

		profileData->setIkeGroup ( newprofilewizardracoonpagecontent->DHGroupComboBox->currentText() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n ( "DH group (%1): %2" ).arg ( "racoon" ).arg ( newprofilewizardracoonpagecontent->DHGroupComboBox->currentText() ), KVpncConfig::debug );

		profileData->setAuthenticationAlgorithm( newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->currentText() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n ( "Authentication algorithm (%1) (phase 2): %2" ).arg ( "racoon" ).arg ( newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->currentText() ),KVpncConfig::debug );

		profileData->setIpsecIke(newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->currentText());
		profileData->setUseAuthenticationAlgorithm(true);
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n ( "Encryption algorithm (%1) (phase 1): %2" ).arg ( "racoon" ).arg ( newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->currentText() ), KVpncConfig::debug );

		profileData->setLocalIDType ( newprofilewizardracoonpagecontent->LocalIdTypeCombobox->currentText() );

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n ( "Type of local ID: %1" ).arg ( newprofilewizardracoonpagecontent->LocalIdTypeCombobox->currentText() ), KVpncConfig::debug );

		profileData->setSpecialLocalID ( newprofilewizardracoonpagecontent->LocalIDLineEdit->text() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n ( "Local ID value: %1" ).arg ( newprofilewizardracoonpagecontent->LocalIDLineEdit->text() ), KVpncConfig::debug );

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n ( "Type of remote ID: %1" ).arg ( newprofilewizardracoonpagecontent->RemoteIdTypeCombobox->currentText() ), KVpncConfig::debug );

		profileData->setSpecialRemoteID ( newprofilewizardracoonpagecontent->RemoteIDLineEdit->text() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n ( "Remote ID value: %1" ).arg ( newprofilewizardracoonpagecontent->RemoteIDLineEdit->text() ), KVpncConfig::debug );


		if (newprofilewizardracoonpagecontent->UseXauthCheckBox->isChecked())
		{
			profileData->setAuthWithUsernameAndPassword(true);
			if ( GlobalConfig->KvpncDebugLevel > 1 )
				GlobalConfig->appendLogEntry ( i18n ( "Authenticate with username and password: %1" ).arg ( i18n ( "yes" ) ), KVpncConfig::debug );
			insertPage ( newprofilewizarduserpage, "<b>" + i18n ( "User settings" ) + "</b>", indexOf ( currentpage ) + 1 );
			insertPage ( newprofilewizardnetworkpage, "<b>" + i18n ( "Network settings" ) + "</b>", indexOf ( currentpage ) + 2 );
			insertPage ( newprofilewizardnatpage, "<b>" + i18n ( "NAT settings" ) + "</b>", indexOf ( currentpage ) + 3 );
			insertPage ( newprofilewizardnetworkroutepage, "<b>" + i18n ( "Network routes" ) + "</b>", indexOf ( currentpage ) +4 );

		}
		else
		{
			if ( GlobalConfig->KvpncDebugLevel > 1 )
				GlobalConfig->appendLogEntry ( i18n ( "Authenticate with username and password: %1" ).arg ( i18n ( "no" ) ), KVpncConfig::debug );
			insertPage ( newprofilewizardnetworkpage, "<b>" + i18n ( "Network settings" ) + "</b>", indexOf ( currentpage ) + 1 );
			insertPage ( newprofilewizardnatpage, "<b>" + i18n ( "NAT settings" ) + "</b>", indexOf ( currentpage ) + 2 );
			insertPage ( newprofilewizardnetworkroutepage, "<b>" + i18n ( "Network routes" ) + "</b>", indexOf ( currentpage ) +3 );
		}
	}
	else if ( currentpage == newprofilewizardopenvpnpage )
	{
		msg = i18n ( "These fields must be filled in:\n" );
		profileData->setTunnelDeviceType ( newprofilewizardopenvpnpagecontent->TunnelDeviceTypeComboBox->currentText() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n ( "Tunnel device type (%1): %2" ).arg ( "OpenVPN" ).arg ( newprofilewizardopenvpnpagecontent->TunnelDeviceTypeComboBox->currentText() ), KVpncConfig::debug );

		if ( newprofilewizardopenvpnpagecontent->NsCertTypeComboBox->currentText() == "client" )
			profileData->setNsCertType ( "client" );
		else
			profileData->setNsCertType ( "server" );

		profileData->setTunnelDeviceType ( newprofilewizardopenvpnpagecontent->TunnelDeviceTypeComboBox->currentText() );

		insertPage ( newprofilewizardauthselectionpage, "<b>" + i18n ( "Authentication settings" ) + "</b>", indexOf ( currentpage ) + 1 );
		insertPage ( newprofilewizardnetworkpage, "<b>" + i18n ( "Network settings" ) + "</b>", indexOf ( currentpage ) + 2 );
		insertPage ( newprofilewizardnetworkroutepage, "<b>" + i18n ( "Network routes" ) + "</b>", indexOf ( currentpage ) + 3 );
		insertPage ( newprofilewizardnatpage, "<b>" + i18n ( "NAT settings" ) + "</b>", indexOf ( currentpage ) + 4 );

		profileData->setUserdefiniedCipher ( newprofilewizardopenvpnpagecontent->UserdefiniedCipherComboBox->currentText() );
		profileData->setUseUserdefiniedCipher ( newprofilewizardopenvpnpagecontent->UseUserdefiniedCipherCheckBox->isChecked() );

		profileData->setRemotePort ( newprofilewizardopenvpnpagecontent->UserdefinedPortSpinBox->value() );
		profileData->setUseRemotePort ( newprofilewizardopenvpnpagecontent->UseUserdefinedPortCheckBox->isChecked() );

		if ( newprofilewizardopenvpnpagecontent->UseTlsAuthCheckBox->isChecked() )
		{
			if ( newprofilewizardopenvpnpagecontent->TlsAuthURLRequester->url().isEmpty() )
			{
				ok = false;
				msg += i18n ( "TLS auth file" ) + "\n";
			}
			else
			{
				profileData->setUseTlsAuth ( true );
				profileData->setTlsAuthFile ( newprofilewizardopenvpnpagecontent->TlsAuthURLRequester->url() );
			}
		}

		if ( newprofilewizardopenvpnpagecontent->UseTlsRemoteHostCheckBox->isChecked() )
		{
			if ( newprofilewizardopenvpnpagecontent->TlsRemoteHostLineEdit->text().isEmpty() )
			{
				ok = false;
				msg += i18n ( "TLS remote host" ) + "\n";
			}
			else
			{
				profileData->setUseTlsRemoteHost ( newprofilewizardopenvpnpagecontent->UseTlsAuthCheckBox->isChecked() );
				profileData->setTlsRemoteHost ( newprofilewizardopenvpnpagecontent->TlsRemoteHostLineEdit->text() );
			}
		}

		profileData->setDisableLzoCompression ( newprofilewizardopenvpnpagecontent->DisableLzoCompressionCheckBox->isChecked() );

		if ( newprofilewizardopenvpnpagecontent->UseHttpProxyCheckBox->isChecked() )
		{
			if ( newprofilewizardopenvpnpagecontent->HttpProxyLineEdit->text().isEmpty() )
			{
				ok = false;
				msg += i18n ( "HTTP proxy host" ) + "\n";
			}
			else
			{
				profileData->setUseHttpProxy ( newprofilewizardopenvpnpagecontent->UseHttpProxyCheckBox->isChecked() );
				profileData->setHttpProxy ( newprofilewizardopenvpnpagecontent->HttpProxyLineEdit->text( ) );
			}
		}

		if ( newprofilewizardopenvpnpagecontent->AllowIpAddressChangeOfPeerCheckBox->isChecked() )
			profileData->setAllowIpAddressChangeOfPeer ( true );
		else
			profileData->setAllowIpAddressChangeOfPeer ( false );

		profileData->setHttpProxyPort ( newprofilewizardopenvpnpagecontent->HttpProxyPortIntNumInput->value( ) );
		profileData->setHttpProxyTimeout ( newprofilewizardopenvpnpagecontent->HttpProxyTimeoutIntSpinBox->value() );


	}
	else if ( currentpage == newprofilewizardauthselectionpage )
	{
		if ( newprofilewizardauthselectioncontent->PskRadioButton->isChecked() )
		{
			useCert = false;

			profileData->setAuthType ( VpnAccountData::psk );
			insertPage ( newprofilewizardpskpage, "<b>" + i18n ( "PSK settings" ) + "</b>", indexOf ( currentpage ) + 1 );

			// racoon or freeswan
			if ( profileData->getConnectionType() == VpnAccountData::freeswan || profileData->getConnectionType() == VpnAccountData::racoon ||
			        profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan || profileData->getConnectionType() == VpnAccountData::l2tpd_racoon )
			{
				newprofilewizardpskcontent->PSKLineEdit->setEnabled ( true );
				newprofilewizardfreeswanpagecontent->UseXauthCheckBox->setEnabled ( true );
				newprofilewizardracoonpagecontent->UseXauthCheckBox->setEnabled ( true );
			}

			else if ( profileData->getConnectionType() == VpnAccountData::openvpn )
			{
				newprofilewizardpskcontent->PSKLineEdit->setEnabled ( true );
				newprofilewizardpskcontent->LabelPsk->setEnabled ( true );
			}

			else if ( profileData->getConnectionType() == VpnAccountData::ciscoorig )
			{
				insertPage ( newprofilewizardciscomanuallypage, "<b>" + i18n ( "Cisco settings" ) + "</b>", indexOf ( currentpage ) + 1 );
				removePage( newprofilewizardpskpage);
			}
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Auth selection: use PSK" ), KVpncConfig::debug );
		}
		if ( newprofilewizardauthselectioncontent->CertificateRadioButton->isChecked() )
		{
			useCert = true;
			profileData->setAuthType ( VpnAccountData::cert );

			newprofilewizardcertcontent->x509certURLRequester->show();
			newprofilewizardcertcontent->x509certURLRequester->sizeHint();
			newprofilewizardcertcontent->x509certComboBox->hide();


			if (profileData->getConnectionType() != VpnAccountData::ciscoorig)
				insertPage ( newprofilewizardp12certselectionpage, "<b>" + i18n ( "Certificate format" ) + "</b>", indexOf ( currentpage ) + 1 );
			// racoon or freeswan
			if ( profileData->getConnectionType() == VpnAccountData::freeswan || profileData->getConnectionType() == VpnAccountData::racoon ||
			        profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan || profileData->getConnectionType() == VpnAccountData::l2tpd_racoon )
			{
				newprofilewizardcertcontent->x509certURLRequester->setEnabled ( true );
				newprofilewizardcertcontent->LabelCertificate->setEnabled ( true );
				newprofilewizardcertcontent->certpathURLRequester->setEnabled ( true );
				newprofilewizardcertcontent->LabelCertificatePath->setEnabled ( true );

				newprofilewizardfreeswanpagecontent->UseXauthCheckBox->setEnabled ( false );
				newprofilewizardracoonpagecontent->UseXauthCheckBox->setEnabled ( false );
			}

			else if ( profileData->getConnectionType() == VpnAccountData::openvpn )
			{
				newprofilewizardcertcontent->CaCertpathURLRequester->setEnabled ( true );
				newprofilewizardcertcontent->certpathURLRequester->setEnabled ( true );
				newprofilewizardcertcontent->LabelCertificatePath->setEnabled ( true );


				if ( profileData->getUseOnlyCaCertAndUserAuth() )
				{
					newprofilewizardcertcontent->x509certURLRequester->setEnabled ( false );
					newprofilewizardcertcontent->privkeypathURLRequester->setEnabled ( false );
					newprofilewizardcertcontent->PrivkeyPasswordEdit->setEnabled ( false );
					newprofilewizardcertcontent->LabelPrivateKeyPath->setEnabled ( false );
					newprofilewizardcertcontent->LabelCertificate->setEnabled ( false );
					newprofilewizardcertcontent->LabelPrivateKeyPassword->setEnabled ( false );

				}
				else
				{
					newprofilewizardcertcontent->x509certURLRequester->setEnabled ( true );
					newprofilewizardcertcontent->privkeypathURLRequester->setEnabled ( true );
					newprofilewizardcertcontent->PrivkeyPasswordEdit->setEnabled ( true );
					newprofilewizardcertcontent->LabelPrivateKeyPath->setEnabled ( true );
					newprofilewizardcertcontent->LabelCertificate->setEnabled ( true );
					newprofilewizardcertcontent->LabelPrivateKeyPassword->setEnabled ( true );
				}
			}

			else if ( profileData->getConnectionType() == VpnAccountData::ciscoorig )
			{
				newprofilewizardcertcontent->x509certURLRequester->setEnabled ( true );
				newprofilewizardcertcontent->LabelCertificate->setEnabled ( true );
				newprofilewizardcertcontent->certpathURLRequester->setEnabled ( false );
				newprofilewizardcertcontent->LabelCertificatePath->setEnabled ( false );
				newprofilewizardcertcontent->certpathURLRequester->hide();
				newprofilewizardcertcontent->LabelCertificatePath->hide();
				newprofilewizardcertcontent->UseSmartcardCheckBox->hide();
				newprofilewizardcertcontent->SmartcardGroupBox->hide();
				newprofilewizardcertcontent->UseSpecialServerCertificateCheckBox->hide();
				newprofilewizardcertcontent->SpecialServerCertificateURLRequester->hide();
				newprofilewizardcertcontent->CaCertpathURLRequester->hide();
				newprofilewizardcertcontent->LabelPrivateKeyPath->hide();
				newprofilewizardcertcontent->privkeypathURLRequester->hide();
				newprofilewizardcertcontent->LabelCaCertificatePath->hide();
				newprofilewizardcertcontent->CertificateGroupBox->resize(newprofilewizardcertcontent->CertificateGroupBox->sizeHint());
				

				insertPage ( newprofilewizardcertpage, "<b>" + i18n ( "Certificate settings" ) + "</b>", indexOf ( currentpage ) + 1 );
				
				
// 				newprofilewizardciscomanuallypagecontent->AllowEmptyGroupPasswordCheckBox->hide();
// 				newprofilewizardciscomanuallypagecontent->LabelPsk->hide();
// 				newprofilewizardciscomanuallypagecontent->GroupPasswordLineEdit->hide();
// 				newprofilewizardciscomanuallypagecontent->CheckSavePsk->hide();

				if ( importCertificate() )
				{
					// success :)
				}
				else
				{
					newProfileCreated = false;
				}
				newprofilewizardcertcontent->LabelPrivateKeyPassword->setText("Certificate password:");
				// newprofilewizardcertcontent->LabelCertificate->setText(i18n("Certificate (enter name here):"));
				newprofilewizardcertcontent->x509certURLRequester->hide();
				newprofilewizardcertcontent->x509certComboBox->show();
				newprofilewizardcertcontent->x509certComboBox->sizeHint();
				newprofilewizardcertcontent->x509certComboBox->setCurrentItem(0);
				
			}

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Auth selection: use certificate" ), KVpncConfig::debug );
		}
		if ( newprofilewizardauthselectioncontent->HybridRadioButton->isChecked() )
		{
			useCert = false;

			profileData->setAuthType ( VpnAccountData::hybrid );
			insertPage ( newprofilewizardcertpage, "<b>" + i18n ( "Certificate settings" ) + "</b>", indexOf ( currentpage ) + 1 );

			// racoon or freeswan
			if ( profileData->getConnectionType() == VpnAccountData::racoon  || profileData->getConnectionType() == VpnAccountData::l2tpd_racoon )
			{
				newprofilewizardpskcontent->PSKLineEdit->setEnabled ( true );
				newprofilewizardfreeswanpagecontent->UseXauthCheckBox->setEnabled ( true );
				newprofilewizardracoonpagecontent->UseXauthCheckBox->setEnabled ( true );

				newprofilewizardcertpage->setEnabled(true);
				newprofilewizardcertcontent->x509certComboBox->setEnabled(false);
				newprofilewizardcertcontent->x509certURLRequester->setEnabled(false);
				newprofilewizardcertcontent->CaCertpathURLRequester->setEnabled(true);
				newprofilewizardcertcontent->certpathURLRequester->setURL("/etc/racoon/certs");
				newprofilewizardcertcontent->LabelCertificate->setEnabled(false);
				newprofilewizardcertcontent->LabelPrivateKeyPath->setEnabled(false);
				newprofilewizardcertcontent->LabelPrivateKeyPassword->setEnabled(false);
				newprofilewizardcertcontent->SpecialServerCertificateURLRequester->setEnabled(false);
				newprofilewizardcertcontent->PrivkeyPasswordEdit->setEnabled(false);
				newprofilewizardcertcontent->UseSpecialServerCertificateCheckBox->setEnabled(false);
				newprofilewizardcertcontent->privkeypathURLRequester->setEnabled(false);
				newprofilewizardpskcontent->setEnabled(false);


			}
			else if ( profileData->getConnectionType() == VpnAccountData::ciscoorig )
			{
				insertPage ( newprofilewizardciscomanuallypage, "<b>" + i18n ( "Cisco settings" ) + "</b>", indexOf ( currentpage ) + 1 );
				removePage( newprofilewizardpskpage);
			}
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Auth selection: use Hybrid" ), KVpncConfig::debug );
		}
	}
	else if ( currentpage == newprofilewizardp12certselectionpage )
	{
		insertPage ( newprofilewizardcertpage, "<b>" + i18n ( "Certificate settings" ) + "</b>", indexOf ( currentpage ) + 1 );

		if ( newprofilewizardp12certselectioncontent->UseSmartcardCheckBox->isChecked() )
		{
			profileData->setUseSmartcard ( true );
			newprofilewizardcertcontent->UseSmartcardCheckBox->setChecked ( true );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "P12 cert selection: use smartcard" ), KVpncConfig::debug );
		}
		else
		{
			if ( newprofilewizardp12certselectioncontent->P12CertYesRadioButton->isChecked() )
			{
				// yes we have p12 cert
				if ( GlobalConfig->KvpncDebugLevel > 0 )
					GlobalConfig->appendLogEntry ( i18n ( "P12 cert selection: cert type is PKCS12" ), KVpncConfig::debug );

				if ( importCertificate() )
				{
					// success :)
				}
				else
				{
					newProfileCreated = false;
				}
			}
			else
			{

				if ( GlobalConfig->KvpncDebugLevel > 0 )
					GlobalConfig->appendLogEntry ( i18n ( "P12 cert selection: cert type is other" ), KVpncConfig::debug );
			}
		}
	}
	else if ( currentpage == newprofilewizardopenvpnselectionpage )
	{
		if ( newprofilewizardopenvpnselectionpagecontent->OpenvpnImportRadioButton->isChecked() )
		{
			enterdatamanually = false;
			removePage ( newprofilewizardopenvpnpage );
			removePage ( newprofilewizardopenvpnauthpage );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "OpenVPN selection: import profile file" ), KVpncConfig::debug );

			// 			removePage ( newprofilewizardgeneralpage );
			removePage ( newprofilewizardvirtualipaddresspage );

			if ( importProfile ( VpnAccountData::openvpn ) == true )
			{
				newProfileCreated = true;
				newprofilewizardgeneralpagecontent->NameLineEdit->setText ( profileData->getName() );
				newprofilewizardgeneralpagecontent->gatewayLineEdit->setText ( profileData->getGateway() );
				newprofilewizardgeneralpagecontent->DescriptionLineEdit->setText ( profileData->getDescription() );

				if ( profileData->getAuthWithUsernameAndPassword() )
				{
					if ( GlobalConfig->KvpncDebugLevel > 0 )
						GlobalConfig->appendLogEntry ( i18n ( "OpenVPN auth: authenticate with username and password" ), KVpncConfig::debug );
					insertPage ( newprofilewizarduserpage, "<b>" + i18n ( "User settings" ) + "</b>", indexOf ( currentpage ) + 1 );
				}
			}
			else
			{
				newProfileCreated = false;
				ok = false;
			}
		}
		else
		{
			enterdatamanually = true;
			insertPage ( newprofilewizardopenvpnpage, "<b>" + i18n ( "OpenVPN settings" ) + "</b>", indexOf ( currentpage ) + 1 );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "OpenVPN selection: enter data manually" ), KVpncConfig::debug );
		}

	}
	else if ( currentpage == newprofilewizardopenvpnauthpage )
	{
		if ( newprofilewizardopenvpnauthpagecontent->AuthWithUsernameAndPasswordCheckBox->isChecked() )
		{
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "OpenVPN auth: authenticate with username and password" ), KVpncConfig::debug );
			insertPage ( newprofilewizarduserpage, "<b>" + i18n ( "User settings" ) + "</b>", indexOf ( currentpage ) + 1 );

			profileData->setAuthWithUsernameAndPassword ( true );

			if ( newprofilewizardopenvpnauthpagecontent->UseOnlyCaCertAndUserAuthCheckBox->isChecked() )
			{
				profileData->setUseOnlyCaCertAndUserAuth ( true );

				if ( GlobalConfig->KvpncDebugLevel > 0 )
					GlobalConfig->appendLogEntry ( i18n ( "OpenVPN auth: use only CA cert authenticate with username and password" ), KVpncConfig::debug );
			}
			else
			{
				profileData->setUseOnlyCaCertAndUserAuth ( false );

			}
		}
		else
		{
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "OpenVPN auth: dont authenticate with username and password" ), KVpncConfig::debug );

			profileData->setAuthWithUsernameAndPassword ( false );
			profileData->setUseOnlyCaCertAndUserAuth ( false );
		}

		if ( newprofilewizardopenvpnauthpagecontent->UseAuthenticationAlgorithmCheckBox->isChecked() )
		{
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "OpenVPN auth: use special authentication algorithm: %1" ).arg ( newprofilewizardopenvpnauthpagecontent->UserdefiniedDigestComboBox->currentText() ), KVpncConfig::debug );
			profileData->setUseAuthenticationAlgorithm ( true );
			profileData->setAuthenticationAlgorithm ( newprofilewizardopenvpnauthpagecontent->UserdefiniedDigestComboBox->currentText() );
		}
		else
		{
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "OpenVPN auth: dont use special authentication algorithm" ), KVpncConfig::debug );
			profileData->setUseAuthenticationAlgorithm ( false );
		}

		profileData->setAuthenticationAlgorithm ( newprofilewizardopenvpnauthpagecontent->UserdefiniedDigestComboBox->currentText() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n ( "OpenVPN auth: use authentication method: %1" ).arg ( profileData->getAuthenticationAlgorithm() ), KVpncConfig::debug );


	}
	else if ( currentpage == newprofilewizardpptppage )
	{

		msg = i18n ( "These fields must be filled in:\n" );
		profileData->setAllowStatefulMode( newprofilewizardpptppagecontent->AllowStatefulModeCheckbox->isChecked() );
		profileData->setUseNoIpDefault( newprofilewizardpptppagecontent->UseNoIpDefaultCheckbox->isChecked() );
		profileData->setDisableMPPEComp( newprofilewizardpptppagecontent->UseNoMPPECompressionCheckbox->isChecked() );
		profileData->setRequireMppe( newprofilewizardpptppagecontent->RequireMppeCheckbox->isChecked() );
		profileData->setRefuse128BitEncryption( newprofilewizardpptppagecontent->Refuse128BitEncryptionCheckbox->isChecked() );
		profileData->setRefuse40BitEncryption( newprofilewizardpptppagecontent->Refuse40BitEncryptionCheckbox->isChecked() );
		profileData->setDisableMPPEComp( newprofilewizardpptppagecontent->UseNoMPPECompressionCheckbox->isChecked() );
		profileData->setUseNoBsdComp( newprofilewizardpptppagecontent->UseNoBsdCompCheckbox->isChecked() );
		profileData->setUseNoDeflate( newprofilewizardpptppagecontent->UseNoDeflateCheckbox->isChecked() );
		profileData->setDisableHeaderCompression(newprofilewizardpptppagecontent->DisableHeaderCompressionCheckbox->isChecked());
		profileData->setDisableMagicNumberNegotiation(newprofilewizardpptppagecontent->DisableMagicNumberNegotiationCheckbox->isChecked());
		profileData->setDisableIpx(newprofilewizardpptppagecontent->DisableIpxCheckbox->isChecked());
		profileData->setDisableAdressControlCompression(newprofilewizardpptppagecontent->DisableAdressControlCompressionCheckbox->isChecked());
		profileData->setDisableProtocolFieldCompression(newprofilewizardpptppagecontent->DisableProtocolFieldCompressionCheckbox->isChecked());
		profileData->setRequireEap(newprofilewizardpptppagecontent->RequireEapCheckbox->isChecked());
		
		if ( newprofilewizardpptppagecontent->DnsServerCheckbox->isChecked() )
		{
			profileData->setUseDnsServer( true );
			profileData->setDnsServer( newprofilewizardpptppagecontent->DnsServerLineedit->text() );
			
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Using custom DNS server: %1" ).arg ( profileData->getDnsServer() ), KVpncConfig::debug );
		}
		else
		{
			profileData->setUseDnsServer( false );
		}
		
		if ( newprofilewizardpptppagecontent->UseSearchDomainInResolvConfCheckbox ->isChecked() )
		{
			profileData->setUseSearchDomainInResolvConf(true);
			profileData->setSearchDomainInResolvConf(newprofilewizardpptppagecontent->SearchDomainInResolvConfLineedit->text());
			
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Using custom DNS search domain: %1" ).arg ( profileData->getSearchDomainInResolvConf() ), KVpncConfig::debug );
		}
		else
		{
			profileData->setUseSearchDomainInResolvConf(false);
		}
		
		if ( newprofilewizardpptppagecontent->UseDomainInResolvConfCheckbox ->isChecked() )
		{
			profileData->setUseDomainInResolvConf(true);
			profileData->setDomainInResolvConf(newprofilewizardpptppagecontent->DomainInResolvConfLineedit->text());
			
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Using custom DNS domain: %1" ).arg ( profileData->getDomainInResolvConf() ), KVpncConfig::debug );
		}
		else
		{
			profileData->setUseDomainInResolvConf(false);
		}
		
		if ( newprofilewizardpptppagecontent->AuthMethodComboBox->currentItem() == 0 )
			profileData->setAuthMethod ( "chap" );
		if ( newprofilewizardpptppagecontent->AuthMethodComboBox->currentItem() == 1 )
			profileData->setAuthMethod ( "pap" );
		if ( newprofilewizardpptppagecontent->AuthMethodComboBox->currentItem() == 2 )
			profileData->setAuthMethod ( "mschap" );
		if ( newprofilewizardpptppagecontent->AuthMethodComboBox->currentItem() == 3 )
			profileData->setAuthMethod ( "mschap-v2" );

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n ( "Using auth method: %1" ).arg ( profileData->getAuthMethod() ), KVpncConfig::debug );

		newprofilewizardnetworkcontent->LabelRemoteNetwork->hide();
		newprofilewizardnetworkcontent->RemoteNetMaskComboBox->hide();
		newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->hide();
		newprofilewizardnetworkcontent->RemoteNetDividetextLabel->hide();
		newprofilewizardnetworkcontent->UseRemoteNetworkCheckBox->hide();
		newprofilewizardnetworkcontent->RemoteNetworkGroupBox->hide();

		insertPage ( newprofilewizarduserpage, "<b>" + i18n ( "User settings" ) + "</b>", indexOf ( currentpage ) + 1 );

	}
	else if ( currentpage == newprofilewizardvtunpage )
	{
		msg = i18n ( "These fields must be filled in:\n" );
		profileData->setUseLocalPort ( newprofilewizardvtunpagecontent->PortCheckbox->isChecked() );
		profileData->setLocalPort ( newprofilewizardvtunpagecontent->PortSpinbox->value() );

		if ( newprofilewizardvtunpagecontent->PortCheckbox->isChecked() )
		{
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Vtun: use userdefined port: %1" ).arg ( TQString().setNum ( newprofilewizardvtunpagecontent->PortSpinbox->value() ) ), KVpncConfig::debug );
		}

		if ( newprofilewizardvtunpagecontent->VtunProfileLineEdit->text().isEmpty() )
		{
			KMessageBox::error ( this, i18n ( "No profile name entered!" ), i18n ( "No profile name" ) );
			ok = false;
			msg += "- " + i18n ( "Vtun profile name" ) + "\n";
			GlobalConfig->appendLogEntry ( i18n ( "No profile name entered!" ), GlobalConfig->error );
		}
		else
			profileData->setVtunProfile ( newprofilewizardvtunpagecontent->VtunProfileLineEdit->text() );
	}
	else if ( currentpage == newprofilewizardsshpage )
	{
		msg = i18n ( "These fields must be filled in:\n" );
		profileData->setUseRemotePort( newprofilewizardsshpagecontent->UseUserdefinedRemotePortCheckBox->isChecked() );
		profileData->setRemotePort ( newprofilewizardsshpagecontent->UserdefinedRemotePortSpinBox->value() );

		if ( newprofilewizardsshpagecontent->UseUserdefinedRemotePortCheckBox->isChecked() )
		{
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "SSH: use userdefined port: %1" ).arg ( TQString().setNum ( newprofilewizardsshpagecontent->UserdefinedRemotePortSpinBox->value() ) ), KVpncConfig::debug );
		}
	
		// password or key auth
		if (newprofilewizardsshpagecontent->AuthPassRadioButton->isChecked())
		{
			profileData->setAuthWithUsernameAndPassword(true);
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "SSH: use user password authentication" ) , KVpncConfig::debug );
		}
		else
		{
			profileData->setAuthWithUsernameAndPassword(false);
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "SSH: use key authentication" ) , KVpncConfig::debug );
		}

		profileData->setPreSharedKeyFile(newprofilewizardsshpagecontent->CostumkeyURLRequester->url());

		if (newprofilewizardsshpagecontent->CostumKeyRadioButton->isChecked())
		{
			profileData->setPskIsInFile(newprofilewizardsshpagecontent->CostumKeyRadioButton->isChecked());
			profileData->setPreSharedKeyFile(newprofilewizardsshpagecontent->CostumkeyURLRequester->url());
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "SSH: use costum key: %1" ).arg(newprofilewizardsshpagecontent->CostumkeyURLRequester->url()) , KVpncConfig::debug );
		}
		else
		{
			profileData->setPreSharedKey(newprofilewizardsshpagecontent->SshKeyComboBox->currentText());
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "SSH: use autotected key: %1" ).arg(newprofilewizardsshpagecontent->SshKeyComboBox->currentText()) , KVpncConfig::debug );
		}

		if (newprofilewizardsshpagecontent->UseSshConfigRemoteScriptCheckBox->isChecked() && !newprofilewizardsshpagecontent->SshConfigRemoteScriptLineEdit->text().isEmpty())
		{
			profileData->setUseSshConfigRemoteScript(true);
			profileData->setSshConfigRemoteScript(newprofilewizardsshpagecontent->SshConfigRemoteScriptLineEdit->text());

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "SSH: use ssh config remote script: %1" ).arg(newprofilewizardsshpagecontent->SshConfigRemoteScriptLineEdit->text()) , KVpncConfig::debug );

		}
		else
			profileData->setUseSshConfigRemoteScript(false);

		if (newprofilewizardsshpagecontent->UseSshConfigRemoteScriptCheckBox->isChecked() && newprofilewizardsshpagecontent->SshConfigRemoteScriptLineEdit->text().isEmpty())
		{
				ok = false;
				msg += "- " + i18n ( "Special server certificate" ) + "\n";
				GlobalConfig->appendLogEntry( i18n( "%1 cant be empty!" ).arg(i18n("ssh config remote script")), GlobalConfig->error);
		}

	}
	else if ( currentpage == newprofilewizardvirtualipaddresspage )
	{
		msg = i18n ( "These fields must be filled in:\n" );
		bool IPOk=true;
		TQString wrongAddress="";
		ok = true;
		
		if ( profilenetworkvirtualipoptionscontent->UseVirtualIPCheckBox->isChecked() &&  !profilenetworkvirtualipoptionscontent->LocalVirtualIpEdit->text().isEmpty() )
		{
			TQString LocalVirtualIp = profilenetworkvirtualipoptionscontent->LocalVirtualIpEdit->text();
			if ( Utils ( GlobalConfig ).isValidIPv4Address ( LocalVirtualIp ) == false )
			{
				// 			KMessageBox::error ( this, i18n( "No valid IP address for local IP address entered!" ), i18n( "No Valid IP Address" ) );
				IPOk=false;
				wrongAddress=i18n ( "local IP address" );
				ok=false;
			}
			else
			{
				profileData->setLocalVirtualIP ( LocalVirtualIp );
			}
		}
		else
		{
			msg += "- " + i18n ( "Local IP address for virtual IP" ) + "\n";
			ok =false;
			IPOk=false;
		}

		if ( profileData->getConnectionType() != VpnAccountData::openvpn || profileData->getConnectionType() != VpnAccountData::ssh )
		{
			if(profileData->getTunnelDeviceType() == "tun")
			{
				if ( profilenetworkvirtualipoptionscontent->UseVirtualIPCheckBox->isChecked() && !profilenetworkvirtualipoptionscontent->RemoteVirtualIpLineEdit->text().isEmpty() )
				{
					TQString RemoteVirtualIp = profilenetworkvirtualipoptionscontent->RemoteVirtualIpLineEdit->text();
					if ( Utils ( GlobalConfig ).isValidIPv4Address ( RemoteVirtualIp ) == false )
					{
		
						IPOk=false;
						ok=false;
						if ( wrongAddress=="" )
							wrongAddress = i18n ( "remote IP address" );
						else
							wrongAddress = i18n ( "local and remote IP address" );
					}
					else
					{
						profileData->setRemoteVirtualIP ( RemoteVirtualIp );
					}
				}
				else
				{
					msg += "- " + i18n ( "Remote IP address for virtual IP" ) + "\n";
					ok =false;
					IPOk=false;
		
				}
			}
			if (profileData->getTunnelDeviceType() == "tap")
			{
				TQString RemoteVirtualIp = profilenetworkvirtualipoptionscontent->RemoteVirtualIpLineEdit->text();
				if (Utils( GlobalConfig ).isValidIPv4Netmask (RemoteVirtualIp) == false)
				{
					KMessageBox::error ( this, i18n( "No valid netmask entered!" ), i18n( "No valid netmask" ) );
					IPOk=false;
				}
				else
				{
					profileData->setRemoteVirtualIP( RemoteVirtualIp);
				}
			}
		}


		if ( profilenetworkvirtualipoptionscontent->UseVirtualIPCheckBox->isChecked() && IPOk )
		{
			profileData->setUseVirtualIP ( profilenetworkvirtualipoptionscontent->UseVirtualIPCheckBox->isChecked() );

			if ( profilenetworkvirtualipoptionscontent->UseVirtualIPCheckBox->isChecked() )
			{

				if (profileData->getTunnelDeviceType() == "tun")
				{
					if ( GlobalConfig->KvpncDebugLevel > 0 )
						GlobalConfig->appendLogEntry ( i18n ( "Using virtual IP addresses (local: %1, remote: %2): " ).arg ( profileData->getLocalVirtualIP() ).arg ( profileData->getRemoteVirtualIP() ), KVpncConfig::debug );
				}
				if (profileData->getTunnelDeviceType() == "tap")
				{
					if ( GlobalConfig->KvpncDebugLevel > 0 )
						GlobalConfig->appendLogEntry ( i18n ( "Using virtual IP address (local: %1, netmask: %2): " ).arg ( profileData->getLocalVirtualIP() ).arg ( profileData->getRemoteVirtualIP() ), KVpncConfig::debug );
				}
			}
			else
			{
				if ( GlobalConfig->KvpncDebugLevel > 0 )
					GlobalConfig->appendLogEntry ( i18n ( "Not using virtual IP addresses" ), KVpncConfig::debug );
			}
		}
		else
		{
			if ( wrongAddress!= "" )
				KMessageBox::error ( this, i18n ( "No valid IP address for %1 entered!" ).arg ( wrongAddress ), i18n ( "No Valid IP Address" ) );
			profileData->setUseVirtualIP ( false );
		}

		if ( !profilenetworkvirtualipoptionscontent->UseVirtualIPCheckBox->isChecked() )
			ok=true;

	}
	else if ( currentpage == newprofilewizardpskpage )
	{
		msg = i18n ( "These fields must be filled in:\n" );
		if ( newprofilewizardpskcontent->CheckSavePsk->isChecked() )
		{
			if ( !newprofilewizardpskcontent->PskInFileCheckBox->isChecked() )
			{
				profileData->setSavePsk ( true );
				profileData->setPskIsInFile ( false );
				if ( !newprofilewizardpskcontent->PSKLineEdit->text().isEmpty() )
				{
					profileData->setPreSharedKey ( newprofilewizardpskcontent->PSKLineEdit->text() );
				}
				else
				{
					msg += "- " + i18n ( "Pre shared key" ) + "\n";
					ok = false;
				}
			}
			else
			{
				profileData->setSavePsk ( true );
				profileData->setPskIsInFile ( true );
				if ( !newprofilewizardpskcontent->PSKFileURLRequester->url().isEmpty() )
				{
					profileData->setPreSharedKey ( newprofilewizardpskcontent->PSKLineEdit->text() );
				}
				else
				{
					ok = false;
					msg += "- " + i18n ( "Pre shared key file" ) + "\n";
				}
			}

		}
		else
		{
			profileData->setSavePsk ( false );
		}

		if ( newprofilewizardpskcontent->PskInFileCheckBox->isChecked() )
		{
			profileData->setSavePsk ( newprofilewizardpskcontent->CheckSavePsk->isChecked() );
			if ( !newprofilewizardpskcontent->PSKFileURLRequester->url().isEmpty() )
			{
				profileData->setPreSharedKeyFile ( newprofilewizardpskcontent->PSKFileURLRequester->url() );
			}
			else
			{
				ok = false;
				msg += "- " + i18n ( "Pre shared key file" ) + "\n";
			}
		}
		if ( newprofilewizardpskcontent->CheckSavePsk->isChecked() )
			profileData->setPreSharedKey ( newprofilewizardpskcontent->PSKLineEdit->text( ) );
		else
			profileData->setPreSharedKey ( "" );

		profileData->setPreSharedKey ( newprofilewizardpskcontent->PSKLineEdit->text() );

	}
	else if ( currentpage == newprofilewizardcertpage )
	{

		profileData->setX509Certificate ( newprofilewizardcertcontent->x509certURLRequester->url() );
		profileData->setCaCertificate ( newprofilewizardcertcontent->CaCertpathURLRequester->url() );
		profileData->setCertPath ( newprofilewizardcertcontent->certpathURLRequester->url() );
		profileData->setPrivateKey ( newprofilewizardcertcontent->privkeypathURLRequester->url() );
		profileData->setPrivateKeyPass ( newprofilewizardcertcontent->PrivkeyPasswordEdit->text() );
		profileData->setX509Certificate ( newprofilewizardcertcontent->x509certURLRequester->url() );
		profileData->setCertPath ( newprofilewizardcertcontent->certpathURLRequester->url() );
		profileData->setUseSpecialServerCertificate ( newprofilewizardcertcontent->UseSpecialServerCertificateCheckBox->isChecked() );
		profileData->setSpecialServerCertificate ( newprofilewizardcertcontent->SpecialServerCertificateURLRequester->url() );

		if ( !newprofilewizardcertcontent->PrivkeyPasswordEdit->text().isEmpty() )
			profileData->setSavePrivateKeyPassword ( true );
		else
			profileData->setSavePrivateKeyPassword ( false );

		msg = i18n ( "These fields must be filled in:\n" );

		if ( newprofilewizardcertcontent->UseSpecialServerCertificateCheckBox->isChecked() )
		{
			if ( newprofilewizardcertcontent->SpecialServerCertificateURLRequester->url().isEmpty() )
			{
				ok = false;
				msg += "- " + i18n ( "Special server certificate" ) + "\n";
				// 				KMessageBox::error ( this, i18n( "Special server certificate can't be empty!" ), i18n( "No Server Certificate" ) );
				GlobalConfig->appendLogEntry ( i18n ( "Special server certificate can't be empty!" ) , GlobalConfig->error );
			}
		}

		if ( newprofilewizardcertcontent->CaCertpathURLRequester->url().isEmpty() )
		{
			ok = false;
			msg += "- " + i18n ( "CA certificate" ) + "\n";
			GlobalConfig->appendLogEntry ( i18n ( "CA Certificate can't be empty!" ) , GlobalConfig->error );
		}

		if ( !newprofilewizardcertcontent->UseSmartcardCheckBox->isChecked() &&  !profileData->getAuthType() == VpnAccountData::hybrid)
		{
			if ( (!profileData->getUseOnlyCaCertAndUserAuth() && newprofilewizardcertcontent->x509certURLRequester->url().isEmpty()) || ( profileData->getConnectionType() == VpnAccountData::ciscoorig && newprofilewizardcertcontent->x509certURLRequester->url().isEmpty())) 
			{
				ok = false;
				msg += "- " + i18n ( "Certificate" ) + "\n";
				GlobalConfig->appendLogEntry ( i18n ( "Certificate can't be empty!" ) , GlobalConfig->error );
			}

			if ( !profileData->getUseOnlyCaCertAndUserAuth() && newprofilewizardcertcontent->privkeypathURLRequester->url().isEmpty() &&  !profileData->getAuthType() == VpnAccountData::hybrid)
			{
				ok = false;
				msg += "- " + i18n ( "Path to private key" ) + "\n";
				GlobalConfig->appendLogEntry ( i18n ( "Path to private key can't be empty!" ) , GlobalConfig->error );
			}
// 			if ( ! ( profileData->getConnectionType() == VpnAccountData::racoon || profileData->getConnectionType() == VpnAccountData::l2tpd_racoon ) && !profileData->getUseOnlyCaCertAndUserAuth() && newprofilewizardcertcontent->PrivkeyPasswordEdit->text().isEmpty() )
// 			{
// 				if ( Utils ( GlobalConfig ).getNeedsPassphrase ( newprofilewizardcertcontent->privkeypathURLRequester->url() ) )
// 				{
// 					ok = false;
// 					msg += "- " + i18n ( "Private key password, private key needs passphrase" ) + "\n";
// 					GlobalConfig->appendLogEntry ( i18n ( "Private key password can't be empty  because private key is protected with a passphrase." ) , GlobalConfig->error );
// 				}
// 			}

		}
		else
		{
			if ( newprofilewizardcertcontent->Pkcs11SlotComboBox->currentText().isEmpty() || newprofilewizardcertcontent->Pkcs11IdComboBox->currentText().isEmpty() )
				nextButton()->setEnabled ( false );
			else
				nextButton()->setEnabled ( true );
		}

		if ( newprofilewizardcertcontent->UseSmartcardCheckBox->isEnabled() && newprofilewizardcertcontent->UseSmartcardCheckBox->isChecked() )
		{
			if ( !newprofilewizardcertcontent->Pkcs11SlotComboBox->currentText().isEmpty() )
				profileData->setPkcs11Slot ( newprofilewizardcertcontent->Pkcs11SlotComboBox->currentText() );
			else
			{
				KMessageBox::error ( this, i18n ( "Slot at smartcard can't be empty!" ), i18n ( "No smartcard slot" ) );
				// 			GlobalConfig->appendLogEntry( i18n( "Slot at smartcard can't be empty!" ) ,GlobalConfig->error);
				ok = false;
			}
			if ( !newprofilewizardcertcontent->Pkcs11IdComboBox->currentText().isEmpty() )
				profileData->setPkcs11Id ( newprofilewizardcertcontent->Pkcs11IdComboBox->currentText() );
			else
			{
				KMessageBox::error ( this, i18n ( "ID for certificate at smartcard can't be empty!" ), i18n ( "No certificate ID" ) );
				// 			GlobalConfig->appendLogEntry( i18n( "ID for certificate at smartcard can't be empty!" ) ,GlobalConfig->error);
				ok = false;
			}
			TQString Pkcs11SlotType = newprofilewizardcertcontent->Pkcs11SlotTypeComboBox->currentText();
			if ( Pkcs11SlotType == i18n ( "ID" ) )
				profileData->setPkcs11SlotType ( "id" );
			else if ( Pkcs11SlotType == i18n ( "Name" ) )
				profileData->setPkcs11SlotType ( "name" );
			else
				profileData->setPkcs11SlotType ( "label" );

			TQString Pkcs11IdType = newprofilewizardcertcontent->Pkcs11IdTypeComboBox->currentText();
			if ( Pkcs11IdType == i18n ( "ID" ) )
				profileData->setPkcs11IdType ( "id" );
			else if ( Pkcs11IdType == i18n ( "Label" ) )
				profileData->setPkcs11IdType ( "label" );
			else
				profileData->setPkcs11IdType ( "subject" );

			TQString Pkcs11SignMode = newprofilewizardcertcontent->Pkcs11SignModeComboBox->currentText();
			if ( Pkcs11SignMode == i18n ( "auto" ) )
				profileData->setPkcs11SignMode ( "auto" );
			else if ( Pkcs11SignMode == i18n ( "sign" ) )
				profileData->setPkcs11SignMode ( "sign" );
			else if ( Pkcs11SignMode == i18n ( "recover" ) )
				profileData->setPkcs11SignMode ( "recover" );
			else
				profileData->setPkcs11SignMode ( "any" );

			if ( newprofilewizardcertcontent->UsePkcs11ProvidersCheckBox->isChecked() )
			{
				if ( !newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->url().isEmpty() )
					profileData->setPkcs11Providers ( newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->url() );
				else
				{
					KMessageBox::error ( this, i18n ( "Library path to lib for use with smartcard can't be empty!" ), i18n ( "No providers lib" ) );
					// 			GlobalConfig->appendLogEntry( i18n( "Library path to lib for use with smartcard can't be empty!" ) ,GlobalConfig->error);
					ok = false;
				}
			}
			profileData->setUsePkcs11Providers ( newprofilewizardcertcontent->UsePkcs11ProvidersCheckBox->isChecked() );
		}

	}
	else if ( currentpage == newprofilewizarduserpage )
	{
		msg = i18n ( "These fields must be filled in:\n" );
		if ( newprofilewizarduserpagecontent->UsernameLineEdit->text().isEmpty() )
		{
			ok = false;
			msg += "- " + i18n ( "Username" ) + "\n";
			GlobalConfig->appendLogEntry ( i18n ( "Username  is empty!" ), GlobalConfig->error );
		}
		else
		{
			profileData->setUserName ( newprofilewizarduserpagecontent->UsernameLineEdit->text() );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "User options: username: %1" ).arg ( profileData->getUserName() ), KVpncConfig::debug );
		}

		if ( !newprofilewizarduserpagecontent->PasswordEdit->text().isEmpty() )
		{
			profileData->setUserPassword ( newprofilewizarduserpagecontent->PasswordEdit->text() );

		}
		else
		{
			if ( newprofilewizarduserpagecontent->CheckUserPass->isChecked() )
			{
				ok = false;
				msg += "- " + i18n ( "Password" ) + "\n";
				GlobalConfig->appendLogEntry ( i18n ( "Password  is empty but you have checked to store it!" ), GlobalConfig->error );
			}
		}
		profileData->setUserPassword ( newprofilewizarduserpagecontent->PasswordEdit->text() );
		profileData->setSaveUserPassword ( newprofilewizarduserpagecontent->CheckUserPass->isChecked() );

		profileData->setNtDomainName ( newprofilewizarduserpagecontent->NtDomainNameLineedit->text() );


		if ( profileData->getConnectionType () == VpnAccountData::cisco || profileData->getConnectionType() == VpnAccountData::pptp ||
		        profileData->getConnectionType () == VpnAccountData::l2tpd_racoon || profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan
		   )
		{
			if ( newprofilewizarduserpagecontent->NtDomainNameCheckbox->isChecked() )
			{
				if ( newprofilewizarduserpagecontent->NtDomainNameLineedit->text().isEmpty() )
				{
					ok = false;
					msg += "- " + i18n ( "NT domain name" ) + "\n";
					GlobalConfig->appendLogEntry ( i18n ( "NT domain name  is empty but you have checked to specifiy one!" ), GlobalConfig->error );
				}
				else
				{
					profileData->setNtDomainName ( newprofilewizarduserpagecontent->NtDomainNameLineedit->text() );
					profileData->setUseNtDomainName ( true );
					if ( GlobalConfig->KvpncDebugLevel > 0 )
						GlobalConfig->appendLogEntry ( i18n ( "User options: NT domain name: %1" ).arg ( profileData->getNtDomainName() ), KVpncConfig::debug );
				}
			}
			else
			{
				profileData->setUseNtDomainName ( false );
			}
		}
	}
	else if ( currentpage == newprofilewizardnetworkpage )
	{
		msg = i18n ( "These fields must be filled in:\n" );
		bool validAddr = true;
		if ( ( profileData->getConnectionType() == VpnAccountData::freeswan || profileData->getConnectionType() == VpnAccountData::racoon ||
		        profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan || profileData->getConnectionType() == VpnAccountData::l2tpd_racoon ) )
		{
			if (newprofilewizardnetworkcontent->UseRemoteNetworkCheckBox->isChecked())
			{
				if ( !newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->text().isEmpty() )
				{
					if ( newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->text().contains ( '.' ) != 3 )
					{
						KMessageBox::error ( this, i18n ( "No remote network entered!" ), i18n ( "No remote network" ) );
						validAddr = false;
						return ;
					}
					else
					{
						TQString addr = newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->text();
						int part0 = addr.section ( '.', 0, 0 ).toInt();
						int part1 = addr.section ( '.', 1, 1 ).toInt();
						int part2 = addr.section ( '.', 2, 2 ).toInt();
						int part3 = addr.section ( '.', 3, 3 ).toInt();

						/*
									LogOutput->append ("part0: "+TQString().setNum(part0));
									LogOutput->append ("part1: "+TQString().setNum(part1));
									LogOutput->append ("part2: "+TQString().setNum(part2));
									LogOutput->append ("part3: "+TQString().setNum(part3));
						*/

						if ( ( part0 < 1 || part0 > 254 ) || ( part1 < 0 || part1 > 254 ) || ( part2 < 0 || part2 > 254 ) || ( part3 < 0 || part3 > 254 ) )
						{
							KMessageBox::error ( this, i18n ( "Invalid values in IP address (remote net)!" ), i18n ( "Invalid Values in IP Address" ) );
							GlobalConfig->appendLogEntry ( i18n ( "Invalid values in IP address (remote net)!" ) , GlobalConfig->error );
							validAddr = false;
							return ;
						}

						if ( validAddr == true )
						{
							if ( GlobalConfig->KvpncDebugLevel > 0 )
								GlobalConfig->appendLogEntry ( i18n ( "Use remote network: %1/%2" ).arg ( addr ).arg(newprofilewizardnetworkcontent->RemoteNetMaskComboBox->currentText()), KVpncConfig::debug );
							profileData->setUseRemoteNetwork(true);
							profileData->setRemoteNetAddr ( addr );
							profileData->setRemoteNetMask ( newprofilewizardnetworkcontent->RemoteNetMaskComboBox->currentText() );
						}

					}
				}
				else
				{
					ok = false;
					msg += "- " + i18n ( "Remote network" ) + "\n";
					GlobalConfig->appendLogEntry ( i18n ( "Remote network  is empty!" ), GlobalConfig->error );
				}
			}
		}
		profileData->setNetworkDevice ( newprofilewizardnetworkcontent->NetworkDeviceComboBox->currentText() );

		profileData->setMtu ( newprofilewizardnetworkcontent->MtuSpinbox->value() );
		if ( newprofilewizardnetworkcontent->MtuCheckbox->isChecked() )
		{
			profileData->setUseMtu ( true );
			if ( GlobalConfig->KvpncDebugLevel > 1 )
				GlobalConfig->appendLogEntry ( i18n ( "Network options: use own MTU size: %1" ).arg ( profileData->getMtu() ) , GlobalConfig->debug );
		}
		else
			profileData->setUseMtu ( false );

		profileData->setMru ( newprofilewizardnetworkcontent->MruSpinbox->value() );
		if ( newprofilewizardnetworkcontent->MruCheckbox->isChecked() )
		{
			profileData->setUseMru ( true );
			if ( GlobalConfig->KvpncDebugLevel > 1 )
				GlobalConfig->appendLogEntry ( i18n ( "Network options: use own MRU size: %1" ).arg ( profileData->getMtu() ) , GlobalConfig->debug );
		}
		else
			profileData->setUseMru ( false );

		if ( profileData->getConnectionType() == VpnAccountData::ssh )
		{
			profileData->setTunnelDeviceType(newprofilewizardnetworkcontent->TunnelDeviceTypeComboBox->currentText());
			if ( GlobalConfig->KvpncDebugLevel > 1 )
				GlobalConfig->appendLogEntry ( i18n ( "Network options: Tunnel device type: %1" ).arg ( profileData->getTunnelDeviceType() ) , GlobalConfig->debug );

			tunnelDeviceTypeChanged(profileData->getTunnelDeviceType());
		}

	}
	else if ( currentpage == newprofilewizardnetworkroutepage )
	{
		msg = i18n ( "These fields must be filled in:\n" );

		if ( newprofilewizardnetworkroutecontent->DefaultRouteComboBox->currentItem() == 1 )
		{
			profileData->setReplaceDefaultRoute ( true );

			if ( GlobalConfig->KvpncDebugLevel > 1 )
				GlobalConfig->appendLogEntry ( i18n ( "Network route options: replace default route"  ) , GlobalConfig->debug );
		}
		else
		{
			profileData->setReplaceDefaultRoute ( false );
			if ( GlobalConfig->KvpncDebugLevel > 1 )
				GlobalConfig->appendLogEntry ( i18n ( "Network route options: dont replace default route" )  , GlobalConfig->debug );
		}

		profileData->setUseAdditionalNetworkRoutes ( newprofilewizardnetworkroutecontent->UseExtraNetworkRoutesCheckbox->isChecked() );

		if ( newprofilewizardnetworkroutecontent->UseExtraNetworkRoutesCheckbox->isChecked() && newprofilewizardnetworkroutecontent->NetworkListView->childCount() > 0 )
		{
			if ( GlobalConfig->KvpncDebugLevel > 1 )
				GlobalConfig->appendLogEntry ( i18n ( "Network route options: use additional network routes" ) , GlobalConfig->debug );

			TQStringList AdditionalNetworkRoutes;
			TQListViewItemIterator it ( newprofilewizardnetworkroutecontent->NetworkListView );
			for ( ; it.current(); ++it )
			{
				// example entry:
				// <network>/<netmask>#<gateway>
				TQString network = TQString ( it.current() ->text ( 0 ) + "/" + it.current() ->text ( 1 ) );
				network.append ( "#" );
				network.append ( it.current() ->text ( 2 ) ); // gateway
				network.append ( "#" );
				network.append ( it.current() ->text ( 3 ) ); // interface
				AdditionalNetworkRoutes.append ( network );

				if ( GlobalConfig->KvpncDebugLevel > 1 )
					GlobalConfig->appendLogEntry ( i18n ( "Network route options: additional network: %1/%2 gw %3 %4" ).arg ( it.current() ->text ( 0 ) ).arg ( it.current() ->text ( 1 ) ).arg ( it.current() ->text ( 2 ) ).arg ( it.current() ->text ( 3 ) ) , GlobalConfig->debug );
			}
			profileData->setAdditionalNetworkRoutes ( AdditionalNetworkRoutes );
		}

	}
	else if ( currentpage == newprofilewizardnatpage )
	{
		profileData->setUseUdp ( newprofilewizardnatcontent->UseUdpCheckbox->isChecked() );
		profileData->setUseNat ( newprofilewizardnatcontent->UseNatCheckbox->isChecked() );
		profileData->setUseUdpPort ( newprofilewizardnatcontent->UdpPortCheckbox->isChecked() );
		profileData->setUdpPort ( newprofilewizardnatcontent->UdpPortSpinbox->value() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
		{
			if ( profileData->getUseNat() )
				GlobalConfig->appendLogEntry ( i18n ( "NAT settings: use NAT" ), KVpncConfig::debug );
			else
				GlobalConfig->appendLogEntry ( i18n ( "NAT settings: use no NAT" ), KVpncConfig::debug );
			if ( profileData->getUseUdp() )
				GlobalConfig->appendLogEntry ( i18n ( "NAT settings: use UDP" ), KVpncConfig::debug );
			else
				GlobalConfig->appendLogEntry ( i18n ( "NAT settings: use UDP" ), KVpncConfig::debug );

			if ( profileData->getUseUdpPort() )
				GlobalConfig->appendLogEntry ( i18n ( "NAT settings: use userdefined Port: %1" ).arg ( TQString().setNum ( profileData->getUdpPort() ) ), KVpncConfig::debug );
		}


	}
	else if ( currentpage == newprofilewizardconnectoptionspage )
	{
		connectaftercreating = newprofilewizardconnectoptionscontent->ConnectAfterCreatingProfileCheckBox->isChecked();

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			if ( connectaftercreating )
				GlobalConfig->appendLogEntry ( i18n ( "Connect options: connecting to profile \"%1\" after creating it." ).arg ( profileData->getName() ) , GlobalConfig->debug );

	}
	else if ( currentpage == newprofilewizardconnectionstatuscheckpage )
	{
		msg = i18n ( "These fields must be filled in:\n" );
		if ( newprofilewizardconnectionstatuscheckcontent->UseConnectionStatusCheckCheckBox->isChecked() )
		{
			profileData->setUseConnectionStatusCheck ( true );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Connection status check: use connection status check" ), KVpncConfig::debug );
		}
		else
		{
			profileData->setUseConnectionStatusCheck ( false );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Connection status check: dont use connection status check" ), KVpncConfig::debug );
		}

		if ( newprofilewizardconnectionstatuscheckcontent->DoReconnectAfterConnectionLostCheckBox->isChecked() )
		{
			profileData->setDoReconnectAfterConnectionLost ( true );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Connection status check: do reconnect after connection lost" ), KVpncConfig::debug );
		}
		else
		{
			profileData->setDoReconnectAfterConnectionLost ( false );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Connection status check: dont reconnect after connection lost" ), KVpncConfig::debug );
		}

		if ( newprofilewizardconnectionstatuscheckcontent->PingUserdefiniedAddressCheckBox->isChecked() )
		{
			profileData->setDoPingIP ( true );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Connection status check: ping userdefined IP address" ), KVpncConfig::debug );
		}
		else
		{
			profileData->setDoPingIP ( false );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Connection status check: dont ping userdefined IP address" ), KVpncConfig::debug );
		}

		profileData->setConnectionStatusInterval ( newprofilewizardconnectionstatuscheckcontent->ConnectionStatusCheckIntervalNumInput->value() );
		profileData->setConnectionStatusCheckSuccessCount ( newprofilewizardconnectionstatuscheckcontent->ConnectionStatusSuccessCountNumInput->value() );

		if ( GlobalConfig->KvpncDebugLevel > 0 )
		{
			GlobalConfig->appendLogEntry ( i18n ( "Connection status check: use connection interval: %1" ).arg ( TQString().setNum ( newprofilewizardconnectionstatuscheckcontent->ConnectionStatusCheckIntervalNumInput->value() ) ), KVpncConfig::debug );
			GlobalConfig->appendLogEntry ( i18n ( "Connection status check: success count: %1" ).arg ( TQString().setNum ( newprofilewizardconnectionstatuscheckcontent->ConnectionStatusSuccessCountNumInput->value() ) ), KVpncConfig::debug );
		}

		if ( newprofilewizardconnectionstatuscheckcontent->UseConnectionStatusCheckCheckBox->isChecked() )
		{
			if ( newprofilewizardconnectionstatuscheckcontent->PingUserdefiniedAddressCheckBox->isChecked() )
			{
				if ( !newprofilewizardconnectionstatuscheckcontent->UserdefiniedPingIPLineEdit->text().isEmpty() )
				{
					if ( Utils ( GlobalConfig ).isValidIPv4Address ( newprofilewizardconnectionstatuscheckcontent->UserdefiniedPingIPLineEdit->text() ) )
						profileData->setPingHostIP ( newprofilewizardconnectionstatuscheckcontent->UserdefiniedPingIPLineEdit->text() );
					else
					{
						ok = false;
						msg = i18n ( "The value of userdefined IP address is not a valid IP address!" );
					}
				}
				else
				{
					ok = false;
					msg += i18n ( "Userdefinied IP for ping" ) + "\n";
				}
			}
		}
	}
	else if ( currentpage == endpage )
		{}
	if ( ok )
	{
		previouspage = currentpage;
		TQWizard::next();
	}
	else
	{
		KMessageBox::error ( this, msg );
	}
}

void NewProfileWizard::back()
{
	/*
	currentpage=previouspage;
	// 	showPage(previouspage);

	if ( currentpage == page1 )
	{
		// nothing here
	}
	else if ( currentpage == newprofilewizardgeneralpage )
	{
		newprofilewizardgeneralpagecontent->NameLineEdit->setText(profileData->getName());
		newprofilewizardgeneralpagecontent->gatewayLineEdit->setText(profileData->getGateway());
		newprofilewizardgeneralpagecontent->DescriptionLineEdit->setText(profileData->getDescription());
	}
	else if ( currentpage == newprofilewizardtypeselectionpage )
	{
		if ( profileData->getConnectionType() == VpnAccountData::cisco )
			newprofilewizardtypeselectionpagecontent->CiscoRadioButton->setChecked(true);
		else if ( profileData->getConnectionType() == VpnAccountData::freeswan  ||
					profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan )
			newprofilewizardtypeselectionpagecontent->FreeswanRadioButton->setChecked(true);
		else if ( profileData->getConnectionType() == VpnAccountData::racoon  || profileData->getConnectionType() == VpnAccountData::l2tpd_racoon)
			newprofilewizardtypeselectionpagecontent->FreeswanRadioButton->setChecked(true);
		else if ( profileData->getConnectionType() == VpnAccountData::pptp )
			newprofilewizardtypeselectionpagecontent->PptpRadioButton->setChecked(true);
		else if ( profileData->getConnectionType() == VpnAccountData::openvpn )
			newprofilewizardtypeselectionpagecontent->OpenvpnRadioButton->setChecked(true);
	}
	else if ( currentpage == newprofilewizardciscoselectionpage )
	{}
	else if ( currentpage == newprofilewizardciscomanuallypage )
	{
		newprofilewizardciscomanuallypagecontent->IDLineEdit->setText(profileData->getGateway());
		newprofilewizardciscomanuallypagecontent->AllowEmptyGroupPasswordCheckBox->setChecked(profileData->getAllowEmptyGroupPassword());
		newprofilewizardciscomanuallypagecontent->GroupPasswordLineEdit->setText(profileData->getPreSharedKey());
		profileData->setID(newprofilewizardciscomanuallypagecontent->IDLineEdit->text());

		insertPage ( newprofilewizardciscoselectionpage, "<b>"+ i18n("Cisco selection")+"</b>", 2 );

	}
	else if ( currentpage == newprofilewizardracoonpage )
	{
		newprofilewizardracoonpagecontent->HashAlgoComboBox->setCurrentText(profileData->getHashAlgo());

		insertPage ( newprofilewizardciscoselectionpage,"<b>"+ i18n("Cisco selection")+"</b>" ,  2 );
		insertPage ( newprofilewizardciscomanuallypage, "<b>"+ i18n("Cisco settings")+"</b>",  3 );
		insertPage ( newprofilewizardopenvpnselectionpage, "<b>"+ i18n("FreeS/WAN settings")  , 4 );
		insertPage ( newprofilewizardopenvpnselectionpage, "<b>"+ i18n("OpenVPN settings")+"</b>"  , 5 );
		insertPage ( newprofilewizardpptppage,  "<b>"+ i18n("PPTP settings")+"</b>",  6 );
	}
	else if ( currentpage == newprofilewizardfreeswanpage )
	{
		insertPage ( newprofilewizardciscoselectionpage,"<b>"+ i18n("Cisco selection")+"</b>" ,  2 );
		insertPage ( newprofilewizardciscomanuallypage, "<b>"+ i18n("Cisco settings")+"</b>",  3 );
		insertPage ( newprofilewizardracoonpage, "<b>"+ i18n("Racoon settings")+"</b>"  , 4 );
		insertPage ( newprofilewizardopenvpnselectionpage, "<b>"+ i18n("FreeS/WAN settings")  , 4 );
		insertPage ( newprofilewizardpptppage,  "<b>"+ i18n("PPTP settings")+"</b>",  5 );
	}
	else if ( currentpage == newprofilewizardopenvpnpage )
	{
		newprofilewizardopenvpnpagecontent->TunnelDeviceTypeComboBox->setCurrentText(profileData->getTunnelDeviceType() );
		newprofilewizardopenvpnpagecontent->NsCertTypeComboBox->setCurrentText(profileData->getNsCertType());
		newprofilewizardopenvpnpagecontent->TunnelDeviceTypeComboBox->setCurrentText(profileData->getTunnelDeviceType() );
		newprofilewizardopenvpnpagecontent->UseRedirectGatewayCheckBox->setChecked(profileData->getUseRedirectGateway() );

		newprofilewizardopenvpnpagecontent->UserdefiniedCipherComboBox->setCurrentText(profileData->getUserdefiniedCipher());
		newprofilewizardopenvpnpagecontent->UseUserdefiniedCipherCheckBox->setChecked(profileData->getUseUserdefiniedCipher());
		newprofilewizardopenvpnpagecontent->UseTlsAuthCheckBox->setChecked(profileData->getUseTlsAuth());
		newprofilewizardopenvpnpagecontent->TlsAuthURLRequester->setURL(profileData->getTlsAuthFile());

		profileData->setUseTlsRemoteHost( newprofilewizardopenvpnpagecontent->UseTlsAuthCheckBox->isChecked());
		profileData->setTlsRemoteHost( newprofilewizardopenvpnpagecontent->TlsRemoteHostLineEdit->text());

		profileData->setUseHttpProxy( newprofilewizardopenvpnpagecontent->UseHttpProxyCheckBox->isChecked() );
		profileData->setHttpProxy( newprofilewizardopenvpnpagecontent->HttpProxyLineEdit->text( ) );
		profileData->setHttpProxyPort( newprofilewizardopenvpnpagecontent->HttpProxyPortIntNumInput->value( ) );
		profileData->setHttpProxyTimeout( newprofilewizardopenvpnpagecontent->HttpProxyTimeoutIntSpinBox->value() );

		insertPage ( newprofilewizardciscoselectionpage,"<b>"+ i18n("Cisco selection")+"</b>" , 2 );
		insertPage ( newprofilewizardciscomanuallypage, "<b>"+ i18n("Cisco settings")+"</b>",  3 );
		insertPage ( newprofilewizardfreeswanpage, "<b>"+ i18n("Ipsec settings")  ,  4 );
		insertPage ( newprofilewizardracoonpage, "<b>"+ i18n("Racoon settings")+"</b>"  ,  5 );
		insertPage ( newprofilewizardpptppage,  "<b>"+ i18n("PPTP settings")+"</b>",  6 );
	}
	else if ( currentpage == newprofilewizardpptppage )
	{
		insertPage ( newprofilewizardciscoselectionpage,"<b>"+ i18n("Cisco selection")+"</b>" , 2 );
		insertPage ( newprofilewizardciscomanuallypage, "<b>"+ i18n("Cisco settings")+"</b>",  3 );
		insertPage ( newprofilewizardfreeswanpage, "<b>"+ i18n("IPsec settings")  ,  4 );
		insertPage ( newprofilewizardracoonpage, "<b>"+ i18n("Racoon settings")+"</b>"  ,  5 );
		insertPage ( newprofilewizardopenvpnpage,   "<b>"+i18n("OpenVPN settings")+"</b>", 6 );
	}
	else if ( currentpage == newprofilewizarduserpage )
	{
		newprofilewizarduserpagecontent->UsernameLineEdit->setText(profileData->getUserName());
		newprofilewizarduserpagecontent->PasswordEdit->setText(profileData->getUserPassword() );
		newprofilewizarduserpagecontent->CheckUserPass->setChecked(profileData->getSaveUserPassword());
	}
	else if ( currentpage == newprofilewizardnetworkpage )
	{
		newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->setText(profileData->getRemoteNetAddr() );
		newprofilewizardnetworkcontent->RemoteNetMaskComboBox->setCurrentText(profileData->getRemoteNetMask());
		newprofilewizardnetworkcontent->NetworkDeviceComboBox->setCurrentText(profileData->getNetworkDevice());
	}
	else if ( currentpage == newprofilewizardnatpage )
	{
		newprofilewizardnatcontent->UseUdpCheckbox->setChecked(profileData->getUseUdp());
		newprofilewizardnatcontent->UdpPortCheckbox->setChecked(profileData->getUseUdpPort ());
		newprofilewizardnatcontent->UdpPortSpinbox->setValue(profileData->getUdpPort());
	}
	*/
	TQWizard::back();
}

TQString NewProfileWizard::getName()
{
	return profileData->getName();
}

bool NewProfileWizard::getFinished()
{
	return finished;
}

// void NewProfileDialog::reject()
// {
//
// }

void NewProfileWizard::showPage ( TQWidget* page )
{
	currentpage = page;
	TQWizard::showPage ( page );


	// FIXME set currentpage at back()
	//backButton()->setEnabled(false);

	helpButton() ->setEnabled ( false );

	if ( page == endpage )
	{
		finishButton() ->setEnabled ( TRUE );
		finishButton() ->setFocus();
	}
}

void NewProfileWizard::dataChanged ( const TQString & )
{
	//     if ( !firstName->text().isEmpty() &&
	//          !lastName->text().isEmpty() &&
	//          !email->text().isEmpty() )
	//         nextButton()->setEnabled( TRUE );
	//     else
	//         nextButton()->setEnabled( FALSE );
}

void NewProfileWizard::userdefinedOpenvpnPortToggeled ( bool )
{
	if ( newprofilewizardopenvpnpagecontent->UseUserdefinedPortCheckBox->isChecked() )
		newprofilewizardopenvpnpagecontent->UserdefinedPortSpinBox->setEnabled ( true );
	else
		newprofilewizardopenvpnpagecontent->UserdefinedPortSpinBox->setEnabled ( false );
}

void NewProfileWizard::nsCertTypeOpenvpnToggled ( bool )
{
	if ( newprofilewizardopenvpnpagecontent->UseNsCertTypeCheckBox->isChecked() )
		newprofilewizardopenvpnpagecontent->NsCertTypeComboBox->setEnabled ( true );
	else
		newprofilewizardopenvpnpagecontent->NsCertTypeComboBox->setEnabled ( false );
}

void NewProfileWizard::pskIsInFileToggled ( bool )
{
	if ( newprofilewizardpskcontent->PskInFileCheckBox->isChecked() )
	{
		newprofilewizardpskcontent->LabelPskFile->setEnabled ( TRUE );
		newprofilewizardpskcontent->PSKFileURLRequester->setEnabled ( TRUE );
		newprofilewizardpskcontent->LabelPsk->setEnabled ( FALSE );
		newprofilewizardpskcontent->PSKLineEdit->setEnabled ( FALSE );
	}
	else
	{
		newprofilewizardpskcontent->LabelPskFile->setEnabled ( FALSE );
		newprofilewizardpskcontent->PSKFileURLRequester->setEnabled ( FALSE );
		newprofilewizardpskcontent->LabelPsk->setEnabled ( TRUE );
		newprofilewizardpskcontent->PSKLineEdit->setEnabled ( TRUE );
	}
}

void NewProfileWizard::useNatToggled ( bool )
{
	if ( newprofilewizardnatcontent->UseNatCheckbox->isChecked() )
	{
		newprofilewizardnatcontent->UdpPortCheckbox->setEnabled ( TRUE );
		newprofilewizardnatcontent->UdpPortSpinbox->setEnabled ( FALSE );
	}
	else
	{
		newprofilewizardnatcontent->UdpPortCheckbox->setEnabled ( FALSE );
		newprofilewizardnatcontent->UdpPortSpinbox->setEnabled ( FALSE );
	}
}

void NewProfileWizard::udpPortToggled ( bool )
{
	if ( newprofilewizardnatcontent->UdpPortCheckbox->isChecked() )
	{
		newprofilewizardnatcontent->UdpPortSpinbox->setEnabled ( TRUE );
	}
	else
	{
		newprofilewizardnatcontent->UdpPortSpinbox->setEnabled ( FALSE );
	}
}

void NewProfileWizard::pingIpAfterConnectToggled ( bool )
{
	if ( newprofilewizardconnectionstatuscheckcontent->PingUserdefiniedAddressCheckBox->isChecked() )
		newprofilewizardconnectionstatuscheckcontent->UserdefiniedPingIPLineEdit->setEnabled ( true );
	else
		newprofilewizardconnectionstatuscheckcontent->UserdefiniedPingIPLineEdit->setEnabled ( false );
}

void NewProfileWizard::useUserdefiniedCipherToggled ( bool )
{
	if ( newprofilewizardopenvpnpagecontent->UseUserdefiniedCipherCheckBox->isChecked() )
		newprofilewizardopenvpnpagecontent->UserdefiniedCipherComboBox->setEnabled ( true );
	else
		newprofilewizardopenvpnpagecontent->UserdefiniedCipherComboBox->setEnabled ( false );
}

void NewProfileWizard::useSpecialServerCertificateToggled ( bool )
{
	if ( newprofilewizardcertcontent->UseSpecialServerCertificateCheckBox->isChecked() )
	{
		newprofilewizardcertcontent->SpecialServerCertificateURLRequester->setEnabled ( TRUE );
	}
	else
	{
		newprofilewizardcertcontent->SpecialServerCertificateURLRequester->setEnabled ( FALSE );
	}
}

void NewProfileWizard::useTlsAuthToggled ( bool )
{
	if ( newprofilewizardopenvpnpagecontent->UseTlsAuthCheckBox ->isChecked() )
	{
		newprofilewizardopenvpnpagecontent->TlsAuthURLRequester->setEnabled ( true );
		newprofilewizardopenvpnpagecontent->UseTlsRemoteHostCheckBox->setEnabled ( true );
	}
	else
	{
		newprofilewizardopenvpnpagecontent->TlsAuthURLRequester->setEnabled ( false );
		newprofilewizardopenvpnpagecontent->UseTlsRemoteHostCheckBox->setEnabled ( false );
	}
}

void NewProfileWizard::useHttpProxyToggeled ( bool )
{
	if ( newprofilewizardopenvpnpagecontent->UseHttpProxyCheckBox->isChecked() )
	{
		newprofilewizardopenvpnpagecontent->HostTextLabel->setEnabled ( true );
		newprofilewizardopenvpnpagecontent->HttpProxyLineEdit->setEnabled ( true );
		newprofilewizardopenvpnpagecontent->TimeoutTextLabel->setEnabled ( true );
		newprofilewizardopenvpnpagecontent->HttpProxyTimeoutIntSpinBox->setEnabled ( true );
		newprofilewizardopenvpnpagecontent->PortTextextLabel->setEnabled ( true );
		newprofilewizardopenvpnpagecontent->HttpProxyPortIntNumInput->setEnabled ( true );
	}
	else
	{
		newprofilewizardopenvpnpagecontent->HostTextLabel->setEnabled ( false );
		newprofilewizardopenvpnpagecontent->HttpProxyLineEdit->setEnabled ( false );
		newprofilewizardopenvpnpagecontent->TimeoutTextLabel->setEnabled ( false );
		newprofilewizardopenvpnpagecontent->HttpProxyTimeoutIntSpinBox->setEnabled ( false );
		newprofilewizardopenvpnpagecontent->PortTextextLabel->setEnabled ( false );
		newprofilewizardopenvpnpagecontent->HttpProxyPortIntNumInput->setEnabled ( false );
	}
}

void NewProfileWizard::useTlsRemoteHostToggled ( bool )
{
	if ( newprofilewizardopenvpnpagecontent->UseTlsRemoteHostCheckBox->isChecked() )
		newprofilewizardopenvpnpagecontent->TlsRemoteHostLineEdit->setEnabled ( true );
	else
		newprofilewizardopenvpnpagecontent->TlsRemoteHostLineEdit->setEnabled ( false );
}

void NewProfileWizard::connectionStatusCheckToggled ( bool )
{
	if ( !newprofilewizardconnectionstatuscheckcontent->UseConnectionStatusCheckCheckBox->isChecked() )
	{
		newprofilewizardconnectionstatuscheckcontent->ConnectionStatusCheckIntervalNumInput->setEnabled ( false );
		newprofilewizardconnectionstatuscheckcontent->ConnectionStatusSuccessCountNumInput->setEnabled ( false );
	}
	else
	{
		newprofilewizardconnectionstatuscheckcontent->ConnectionStatusCheckIntervalNumInput->setEnabled ( true );
		newprofilewizardconnectionstatuscheckcontent->ConnectionStatusSuccessCountNumInput->setEnabled ( true );
	}
}

bool NewProfileWizard::importProfile ( VpnAccountData::ConnectionType ConnType )
{
	// FIXME make dlg dynamiclly

	bool success = true;

	if ( ConnType == VpnAccountData::cisco || ConnType == VpnAccountData::ciscoorig )
	{
		ImportProfileDialog dlg ( GlobalConfig, this, i18n ( "Import Cisco PCF profile" ), "" );
		dlg.exec();
		importOK = dlg.importOk;
		if ( importOK )
		{
			profileData = dlg.acc;
			KMessageBox::information ( 0, i18n ( "Import of \"%1\" was successful." ).arg ( profileData->getName() ) );
			GlobalConfig->appendLogEntry ( i18n ( "Import of \"%1\" (%2) was successful." ).arg ( profileData->getName() ).arg ( "PCF" ), GlobalConfig->info );
		}
		else
		{
			KMessageBox::sorry ( 0, i18n ( "Import of \"%1\" has been failed." ).arg ( profileData->getName() ) );
			GlobalConfig->appendLogEntry ( i18n ( "Import of \"%1\" (%2) has been failed." ).arg ( profileData->getName() ).arg ( "PCF" ), GlobalConfig->error );
			success = false;
		}
	}
	if ( ConnType == VpnAccountData::openvpn )
	{
		ImportOpenvpnProfileDialog dlg ( GlobalConfig, this, i18n ( "Import OpenVPN profile" ), "" );
		dlg.exec();
		importOK = dlg.importOk;
		if ( importOK )
		{
			profileData = dlg.acc;
			KMessageBox::information ( 0, i18n ( "Import of \"%1\" was successful." ).arg ( profileData->getName() ) );
			GlobalConfig->appendLogEntry ( i18n ( "Import of \"%1\" (%2) was successful." ).arg ( profileData->getName() ).arg ( "OpenVPN" ), GlobalConfig->info );
		}
		else
		{
			KMessageBox::sorry ( 0, i18n ( "Import of \"%1\" has been failed." ).arg ( profileData->getName() ) );
			GlobalConfig->appendLogEntry ( i18n ( "Import of \"%1\" (%2) has been failed." ).arg ( profileData->getName() ).arg ( "OpenVPN" ), GlobalConfig->error );
			success = false;
		}
	}
	if ( ConnType == VpnAccountData::freeswan )
	{
		ImportIpsecProfileDialog dlg ( GlobalConfig, this, i18n ( "Import IPSec profile" ), "" );
		dlg.setCaption(i18n("Import IPSec config"));
		dlg.exec();
		importOK = dlg.importOk;
		if ( importOK )
		{
			profileData = dlg.acc;
			KMessageBox::information ( 0, i18n ( "Import of \"%1\" was successful." ).arg ( profileData->getName() ) );
				GlobalConfig->appendLogEntry ( i18n ( "Import of \"%1\" (%2) was successful." ).arg ( dlg.main->FilenameUrlrequester->url() ).arg ( "IPSec" ), GlobalConfig->info );
		}
		else
		{
			KMessageBox::sorry ( 0, i18n ( "Import of \"%1\" has been failed." ).arg ( profileData->getName() ) );
			GlobalConfig->appendLogEntry ( i18n ( "Import of \"%1\" (%2) has been failed." ).arg ( dlg.main->FilenameUrlrequester->url() ).arg ( "IPsec" ), GlobalConfig->error );
			success = false;
		}
	}

	return success;

}

bool NewProfileWizard::importCertificate()
{
	bool success = true;

	newprofilewizardcertcontent->CaCertpathURLRequester->clear();
	newprofilewizardcertcontent->certpathURLRequester->clear();
	newprofilewizardcertcontent->PrivkeyPasswordEdit->clear();
	ImportCertificateDialog dlg ( this, i18n ( "Import Certificate..." ).ascii(), GlobalConfig );

	if ( profileData->getConnectionType() == VpnAccountData::freeswan ||
	        profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan )
	{
		dlg.main->ImporttypeComboBox->setCurrentItem ( ImportCertificateDialog::pkcs12_freeswan );
		dlg.typeToggeled ( ImportCertificateDialog::pkcs12_freeswan );
	}
	else if ( profileData->getConnectionType() == VpnAccountData::racoon || profileData->getConnectionType() == VpnAccountData::l2tpd_racoon )
	{
		dlg.main->ImporttypeComboBox->setCurrentItem ( ImportCertificateDialog::pkcs12_racoon );
		dlg.main->PrivateKeyPassGroupBox->setEnabled ( false );
		dlg.main->UsePrivateKeyPasswordCheckBox->setChecked(false);
		dlg.typeToggeled ( ImportCertificateDialog::pkcs12_racoon );
	}
	else if ( profileData->getConnectionType() == VpnAccountData::openvpn )
	{
		dlg.main->ImporttypeComboBox->setCurrentItem ( ImportCertificateDialog::pkcs12_openvpn );
		dlg.typeToggeled ( ImportCertificateDialog::pkcs12_openvpn );
		dlg.main->RacoonCertificatePathUrlrequester->setEnabled ( true );
		dlg.main->RacoonCertificatePathUrlrequester->setURL ( profileData->getCertPath() );
		dlg.main->PrivateKeyPassGroupBox->setEnabled ( true );
		dlg.main->PrivateKeyPasswordEdit->setEnabled ( true );
		dlg.main->PrivateKeyAgainPasswordEdit->setEnabled ( true );
	}
	else if ( profileData->getConnectionType() == VpnAccountData::ciscoorig )
	{
		dlg.main->ImporttypeComboBox->setCurrentItem ( ImportCertificateDialog::cisco );
		dlg.typeToggeled ( ImportCertificateDialog::cisco);
		dlg.main->RacoonCertificatePathUrlrequester->setEnabled ( false );
// 		dlg.main->RacoonCertificatePathUrlrequester->hide();
		dlg.main->PrivateKeyPassGroupBox->setEnabled ( true );
		dlg.main->PrivateKeyPasswordEdit->setEnabled ( true );
		dlg.main->PrivateKeyAgainPasswordEdit->setEnabled ( true );
	}


	dlg.exec();
	importOK = dlg.importOk;
	TQString filename = dlg.filename;
	if ( importOK )
	{
		TQString certpath = dlg.certpath;
		TQString CertFullPath = dlg.CertFullPath;
		TQString CaCertFullPath = dlg.CaCertFullPath;
		TQString importpassword = dlg.main->ImportPasswordEdit->text();
		TQString privatekeypassword = dlg.main->PrivateKeyPasswordEdit->password();
		TQString certificate = TQString ( "mykeys_" + dlg.certName + ".pem" );
		TQString privatekey = TQString ( dlg.certName + ".pem" );

		TQString certpostfix = "";
		TQString privatepostfix = "";
		if ( profileData->getConnectionType() == VpnAccountData::freeswan ||
		        profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan )
		{
			certpostfix = "certs/";
			privatepostfix = "private/";
		}

		newprofilewizardcertcontent->CaCertpathURLRequester->setURL ( CaCertFullPath );


		if ( profileData->getConnectionType() == VpnAccountData::openvpn )
			newprofilewizardcertcontent->PrivkeyPasswordEdit->setText ( importpassword );
		else
			newprofilewizardcertcontent->PrivkeyPasswordEdit->setText ( privatekeypassword );

		if ( profileData->getConnectionType() == VpnAccountData::l2tpd_racoon ||
		        profileData->getConnectionType() == VpnAccountData::racoon )
			newprofilewizardcertcontent->PrivkeyPasswordEdit->setEnabled ( false );


		newprofilewizardcertcontent->certpathURLRequester->setURL ( certpath );

		if ( profileData->getConnectionType() == VpnAccountData::l2tpd_racoon ||
		        profileData->getConnectionType() == VpnAccountData::racoon )
		{
			newprofilewizardcertcontent->privkeypathURLRequester->setURL ( certpath + "/" + certpostfix + certificate );
			newprofilewizardcertcontent->LabelPrivateKeyPassword->setEnabled ( false );
		}
		else
			newprofilewizardcertcontent->privkeypathURLRequester->setURL ( certpath + "/" + privatepostfix + privatekey );
		newprofilewizardcertcontent->x509certURLRequester->setURL ( certpath + "/" + certpostfix + certificate );

		KMessageBox::information ( 0, i18n ( "Import of \"%1\" was successful." ).arg ( filename ) );
		GlobalConfig->appendLogEntry ( i18n ( "Import of \"%1\" (%2) was successful." ).arg ( filename ).arg ( "P12 certificate" ), GlobalConfig->info );
	}
	else
	{
		GlobalConfig->appendLogEntry ( i18n ( "Import of \"%1\" (%2) has been failed." ).arg ( filename ).arg ( "P12 certificate" ), GlobalConfig->info );
		success = false;
	}
	return success;
}

void NewProfileWizard::authenticateWithUsernameAndPasswordToggled ( bool )
{
	if ( newprofilewizardopenvpnauthpagecontent->AuthWithUsernameAndPasswordCheckBox->isChecked() )
		newprofilewizardopenvpnauthpagecontent->UseOnlyCaCertAndUserAuthCheckBox->setEnabled ( true );
	else
		newprofilewizardopenvpnauthpagecontent->UseOnlyCaCertAndUserAuthCheckBox->setEnabled ( false );
}

void NewProfileWizard::pskInputToggled ( const TQString& )
{
	if ( !newprofilewizardpskcontent->PSKLineEdit->text().isEmpty() )
		newprofilewizardpskcontent->CheckSavePsk->setChecked ( true );
	else
		newprofilewizardpskcontent->CheckSavePsk->setChecked ( false );
}

void NewProfileWizard::userpassToggled ( const TQString& )
{
	if ( !newprofilewizarduserpagecontent->PasswordEdit->text().isEmpty() )
		newprofilewizarduserpagecontent->CheckUserPass->setChecked ( true );
	else
		newprofilewizarduserpagecontent->CheckUserPass->setChecked ( false );
}

void NewProfileWizard::usernameToggled ( const TQString& )
{
	// 	if (newprofilewizarduserpagecontent->UsernameLineEdit->text().isEmpty())
	// 		newprofilewizarduserpagecontent->DontSaveUsernameCheckBox->setChecked(true);
	// 	else
	// 		newprofilewizarduserpagecontent->DontSaveUsernameCheckBox->setChecked(false);
}

void NewProfileWizard::pskToggled ( const TQString& )
{
	if ( !newprofilewizardciscomanuallypagecontent->GroupPasswordLineEdit->text().isEmpty() )
		newprofilewizardciscomanuallypagecontent->CheckSavePsk->setChecked ( true );
	else
		newprofilewizardciscomanuallypagecontent->CheckSavePsk->setChecked ( false );
}

void NewProfileWizard::useRightNextHopToggled ( bool )
{
	if ( newprofilewizardfreeswanpagecontent->UseRightNextHopCheckBox->isChecked() )
		newprofilewizardfreeswanpagecontent->RightNextHopLineEdit->setEnabled ( true );
	else
		newprofilewizardfreeswanpagecontent->RightNextHopLineEdit->setEnabled ( false );
}

void NewProfileWizard::useLeftNextHopToggled ( bool )
{
	if ( newprofilewizardfreeswanpagecontent->UseLeftNextHopCheckBox->isChecked() )
		newprofilewizardfreeswanpagecontent->LeftNextHopLineEdit->setEnabled ( true );
	else
		newprofilewizardfreeswanpagecontent->LeftNextHopLineEdit->setEnabled ( false );
}

void NewProfileWizard::additionalNetworkRoutesToggled ( bool )
{
	if ( newprofilewizardnetworkroutecontent->UseExtraNetworkRoutesCheckbox->isChecked() )
	{
		newprofilewizardnetworkroutecontent->NetworkListView->setEnabled ( TRUE );
		newprofilewizardnetworkroutecontent->DeleteNetworkRoutePushButton->setEnabled ( TRUE );
		newprofilewizardnetworkroutecontent->AddRoutePushButton->setEnabled ( TRUE );
	}
	else
	{
		newprofilewizardnetworkroutecontent->NetworkListView->setEnabled ( FALSE );
		newprofilewizardnetworkroutecontent->DeleteNetworkRoutePushButton->setEnabled ( FALSE );
		newprofilewizardnetworkroutecontent->AddRoutePushButton->setEnabled ( FALSE );
	}
}

void NewProfileWizard::delNetworkRouteClicked()
{
	if ( newprofilewizardnetworkroutecontent->NetworkListView->childCount() > 0 && newprofilewizardnetworkroutecontent->NetworkListView->currentItem() != 0 )
	{
		TQListViewItem * item = newprofilewizardnetworkroutecontent->NetworkListView->currentItem();
		TQString Network = item->text ( 0 );
		TQString Netmask = item->text ( 1 );
		int result = KMessageBox::questionYesNo ( this, i18n ( "Do you really want to delete the network \"%1/%2\"?" ).arg ( Network ).arg ( Netmask ), i18n ( "Delete?" ) );
		//LogOutput->append( "Result: "+ TQString().setNum(result) ) ;
		if ( result == 3 )  // Yes
		{
			newprofilewizardnetworkroutecontent->NetworkListView->removeItem ( item );
		}
	}
}

void NewProfileWizard::addNetworkRouteClicked()
{
	AddNetworkRouteDialog dlg ( this, i18n ( "Add Network Route..." ) );


	dlg.main->InterfaceComboBox->insertItem ( "default" ); // interface where default route points

	//FIXME
	dlg.main->InterfaceComboBox->insertItem ( "eth0" );
	dlg.main->InterfaceComboBox->insertItem ( "eth1" );
	dlg.main->InterfaceComboBox->insertItem ( "eth2" );
	dlg.main->InterfaceComboBox->insertItem ( "ipsec0" );
	dlg.main->InterfaceComboBox->insertItem ( "tun0" );
	dlg.main->InterfaceComboBox->insertItem ( "ppp0" );

	if ( dlg.exec() )
	{
		TQString gateway = dlg.getGateway();
		TQString interface = dlg.getInterface();
		if ( !dlg.getUseGateway() )
			gateway = "-";
		if ( !dlg.getUseInterface() )
			interface = "-";
		newprofilewizardnetworkroutecontent->NetworkListView->insertItem ( new TQListViewItem ( newprofilewizardnetworkroutecontent->NetworkListView, dlg.getNetwork(), dlg.getNetmask(), gateway, interface ) );
	}
}

void NewProfileWizard::domainNameToggled ( bool )
{
	if ( newprofilewizarduserpagecontent->NtDomainNameCheckbox->isChecked() )
		newprofilewizarduserpagecontent->NtDomainNameLineedit->setEnabled ( true );
	else
		newprofilewizarduserpagecontent->NtDomainNameLineedit->setEnabled ( false );
}

void NewProfileWizard::useSmartcardToggled ( bool )
{
	if ( newprofilewizardcertcontent->UseSmartcardCheckBox->isChecked() )
	{
		newprofilewizardcertcontent->SmartcardGroupBox->setEnabled ( true );
		newprofilewizardcertcontent->x509certURLRequester->setEnabled ( false );
		newprofilewizardcertcontent->PrivkeyPasswordEdit->setEnabled ( false );
		newprofilewizardcertcontent->privkeypathURLRequester->setEnabled ( false );
		newprofilewizardcertcontent->LabelCertificate->setEnabled ( false );
		newprofilewizardcertcontent->LabelPrivateKeyPath->setEnabled ( false );
		newprofilewizardcertcontent->LabelPrivateKeyPassword->setEnabled ( false );
		newprofilewizardcertcontent->Pkcs11IdTypeComboBox->setEnabled ( false );

// 		newprofilewizardcertcontent->CertificateGroupBox->setEnabled(false);


// 		if ( profileData->getConnectionType() == VpnAccountData::freeswan || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan )
// 		{
// 			ToolInfo IpsecToolInfo( GlobalConfig->programsInPath , "ipsec" );
// 			if ( GlobalConfig->programsInPath )
// 			{
// 				IpsecToolInfo.addSearchPath( "/sbin" );
// 				IpsecToolInfo.addSearchPath( "/usr/local/sbin" );
// 				IpsecToolInfo.addSearchPath( "/usr/sbin" );
// 				IpsecToolInfo.addSearchPath( "/bin" );
// 				IpsecToolInfo.addSearchPath( "/usr/local/bin" );
// 				IpsecToolInfo.addSearchPath( "/usr/bin" );
// 			}
// 			IpsecToolInfo.collectToolInfo();
// 			if (IpsecToolInfo.Version.contains("Openswan") || IpsecToolInfo.Version.contains("Free"))
// 				KMessageBox::information(0,i18n("%1 (IPSec) currently has no working smartcard support (pkcs11). Please use strongSwan instead with enabled smartcard support.").arg(IpsecToolInfo.Version.section(' ',0,0)),i18n("Unsupported IPSec version"));
// 		}

	}
	else
	{
		newprofilewizardcertcontent->SmartcardGroupBox->setEnabled ( false );
		newprofilewizardcertcontent->x509certURLRequester->setEnabled ( true );
		newprofilewizardcertcontent->PrivkeyPasswordEdit->setEnabled ( true );
		newprofilewizardcertcontent->privkeypathURLRequester->setEnabled ( true );
		newprofilewizardcertcontent->LabelCertificate->setEnabled ( true );
		newprofilewizardcertcontent->LabelPrivateKeyPath->setEnabled ( true );
		newprofilewizardcertcontent->LabelPrivateKeyPassword->setEnabled ( true );

// 		newprofilewizardcertcontent->CertificateGroupBox->setEnabled(true);
	}
}

void NewProfileWizard::useSmartcardOnCertFormateToggled ( bool )
{
	if ( newprofilewizardp12certselectioncontent->UseSmartcardCheckBox->isChecked() )
	{
		newprofilewizardp12certselectioncontent->P12Group->setEnabled ( false );
// 		if ( profileData->getConnectionType() == VpnAccountData::freeswan || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan )
// 		{
// 			ToolInfo IpsecToolInfo( GlobalConfig->programsInPath , "ipsec" );
// 			if ( GlobalConfig->programsInPath )
// 			{
// 				IpsecToolInfo.addSearchPath( "/sbin" );
// 				IpsecToolInfo.addSearchPath( "/usr/local/sbin" );
// 				IpsecToolInfo.addSearchPath( "/usr/sbin" );
// 				IpsecToolInfo.addSearchPath( "/bin" );
// 				IpsecToolInfo.addSearchPath( "/usr/local/bin" );
// 				IpsecToolInfo.addSearchPath( "/usr/bin" );
// 			}
// 			IpsecToolInfo.collectToolInfo();
// 			if (IpsecToolInfo.Version.contains("Openswan") || IpsecToolInfo.Version.contains("Free"))
// 				KMessageBox::information(0,i18n("%1 (IPSec) currently has no working smartcard support (pkcs11). Please use strongSwan instead with enabled smartcard support.").arg(IpsecToolInfo.Version.section(' ',0,0)),i18n("Unsupported IPSec version"));
// 		}
	}
	else
	{
		newprofilewizardp12certselectioncontent->P12Group->setEnabled ( true );
	}
}

void NewProfileWizard::usePkcs11ProvidersToggled ( bool )
{
	if ( newprofilewizardcertcontent->UsePkcs11ProvidersCheckBox->isChecked() )
		newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->setEnabled ( true );
	else
		newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->setEnabled ( false );
}

void NewProfileWizard::idTypeToggled()
{
	// 	if (newprofilewizardcertcontent->Pkcs11IdTypeComboBox->currentItem() == 0)
	// 		newprofilewizardcertcontent->IdLabel->setText(i18n("ID"));
	// 	else if (newprofilewizardcertcontent->Pkcs11IdTypeComboBox->currentItem() == 1)
	// 		newprofilewizardcertcontent->IdLabel->setText(i18n("Label"));
	// 	else
	// 		newprofilewizardcertcontent->IdLabel->setText(i18n("Description"));
}

void NewProfileWizard::detectPkcs11Ids()
{
	GlobalConfig->appPointer->setOverrideCursor ( TQCursor ( TQt::WaitCursor ) );
	newprofilewizardcertcontent->Pkcs11IdComboBox->clear();

	int Pkcs11IdType = newprofilewizardcertcontent->Pkcs11IdTypeComboBox->currentItem();
	TQString Pkcs11IdTypeTmp;
	if ( Pkcs11IdType == 0 )
	{
		Pkcs11IdTypeTmp = "id";

		if ( GlobalConfig->KvpncDebugLevel > 1 )
			GlobalConfig->appendLogEntry ( i18n ( "Pkcs11IdType: %1" ).arg ( Pkcs11IdTypeTmp ), KVpncConfig::debug );
	}
	else if ( Pkcs11IdType == 1 )
	{
		Pkcs11IdTypeTmp = "label";
		if ( GlobalConfig->KvpncDebugLevel > 1 )
			GlobalConfig->appendLogEntry ( i18n ( "Pkcs11IdType: %1" ).arg ( Pkcs11IdTypeTmp ), KVpncConfig::debug );
	}
	else
	{
		Pkcs11IdTypeTmp = "subject";
		if ( GlobalConfig->KvpncDebugLevel > 1 )
			GlobalConfig->appendLogEntry ( i18n ( "Pkcs11IdType: %1" ).arg ( Pkcs11IdTypeTmp ), KVpncConfig::debug );
	}

	TQString ProviderLib = "";
	if ( newprofilewizardcertcontent->UsePkcs11ProvidersCheckBox->isChecked() && !newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->url().isEmpty() )
		ProviderLib = newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->url();

	// we have to split slot id and name ("0 : foobar") => 0
	TQString Pkcs11Slot = newprofilewizardcertcontent->Pkcs11SlotComboBox->currentText().section ( ':', 0, 0 ).stripWhiteSpace();

	TQStringList Pkcs11Ids = Utils ( GlobalConfig ).getSmartcardCertsFromSlot ( Pkcs11Slot, Pkcs11IdTypeTmp, ProviderLib );
	for ( TQStringList::Iterator it = Pkcs11Ids.begin(); it != Pkcs11Ids.end(); ++it )
		newprofilewizardcertcontent->Pkcs11IdComboBox->insertItem ( TQString ( *it ) );

	if ( newprofilewizardcertcontent->Pkcs11SlotComboBox->currentText() == "" || newprofilewizardcertcontent->Pkcs11IdComboBox->currentText() == "" )
		nextButton()->setEnabled ( false );
	else
		nextButton()->setEnabled ( true );

	GlobalConfig->appPointer->restoreOverrideCursor();
}

void NewProfileWizard::detectPkcs11Slots()
{
	GlobalConfig->appPointer->setOverrideCursor ( TQCursor ( TQt::WaitCursor ) );
	newprofilewizardcertcontent->Pkcs11SlotComboBox->clear();
	TQString ProviderLib = "";
	if ( newprofilewizardcertcontent->UsePkcs11ProvidersCheckBox->isChecked() && !newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->url().isEmpty() )
		ProviderLib = newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->url();
	TQStringList Pkcs11Slots = Utils ( GlobalConfig ).getSmartcardSlots ( ProviderLib );
	for ( TQStringList::Iterator it = Pkcs11Slots.begin(); it != Pkcs11Slots.end(); ++it )
		newprofilewizardcertcontent->Pkcs11SlotComboBox->insertItem ( TQString ( *it ) );

	if ( !Pkcs11Slots.isEmpty() )
		newprofilewizardcertcontent->Pkcs11IdTypeComboBox->setEnabled ( true );
	if ( newprofilewizardcertcontent->Pkcs11SlotComboBox->currentText() == "" || newprofilewizardcertcontent->Pkcs11IdComboBox->currentText() == "" )
		nextButton()->setEnabled ( false );
	else
		nextButton()->setEnabled ( true );

	GlobalConfig->appPointer->restoreOverrideCursor();
}

void NewProfileWizard::mtuToggled ( bool )
{
	if ( newprofilewizardnetworkcontent->MtuCheckbox->isChecked() )
		newprofilewizardnetworkcontent->MtuSpinbox->setEnabled ( true );
	else
		newprofilewizardnetworkcontent->MtuSpinbox->setEnabled ( false );
}

void NewProfileWizard::mruToggled ( bool )
{
	if ( newprofilewizardnetworkcontent->MruCheckbox->isChecked() )
		newprofilewizardnetworkcontent->MruSpinbox->setEnabled ( true );
	else
		newprofilewizardnetworkcontent->MruSpinbox->setEnabled ( false );
}

void NewProfileWizard::useVirtualIpAddressToggled ( bool )
{
	if ( profilenetworkvirtualipoptionscontent->UseVirtualIPCheckBox->isChecked() )
	{
		profilenetworkvirtualipoptionscontent->LocalVirtualIpEdit->setEnabled ( TRUE );
		profilenetworkvirtualipoptionscontent->RemoteVirtualIpLineEdit->setEnabled ( TRUE );
	}
	else
	{
		profilenetworkvirtualipoptionscontent->LocalVirtualIpEdit->setEnabled ( FALSE );
		profilenetworkvirtualipoptionscontent->RemoteVirtualIpLineEdit->setEnabled ( FALSE );
	}
}

void NewProfileWizard::usePortToggled ( bool )
{
	if ( newprofilewizardvtunpagecontent->PortCheckbox->isChecked() )
		newprofilewizardvtunpagecontent->PortSpinbox->setEnabled ( true );
	else
		newprofilewizardvtunpagecontent->PortSpinbox->setEnabled ( false );
}

void NewProfileWizard::useAuthenticationAlgorithmToggled ( bool )
{
	if ( newprofilewizardopenvpnauthpagecontent->UseAuthenticationAlgorithmCheckBox->isChecked() )
		newprofilewizardopenvpnauthpagecontent->UserdefiniedDigestComboBox ->setEnabled ( true );
	else
		newprofilewizardopenvpnauthpagecontent->UserdefiniedDigestComboBox->setEnabled ( false );
}

void NewProfileWizard::useRemoteNetworkToggled(bool)
{
	if ( newprofilewizardnetworkcontent->UseRemoteNetworkCheckBox->isChecked() )
		newprofilewizardnetworkcontent->RemoteNetworkGroupBox ->setEnabled ( true );
	else
		newprofilewizardnetworkcontent->RemoteNetworkGroupBox->setEnabled ( false );
}

void NewProfileWizard::useIkeToggled(bool)
{
	if (newprofilewizardfreeswanpagecontent->UseCustomIkeCheckBox->isChecked())
		newprofilewizardfreeswanpagecontent->IkeGroupBox->setEnabled(true);
	else
		newprofilewizardfreeswanpagecontent->IkeGroupBox->setEnabled(false);
}

void NewProfileWizard::useEspToogled(bool)
{
	if (newprofilewizardfreeswanpagecontent->UseCustomEspCheckBox->isChecked())
		newprofilewizardfreeswanpagecontent->EspGroupBox->setEnabled(true);
	else
		newprofilewizardfreeswanpagecontent->EspGroupBox->setEnabled(false);
}

void NewProfileWizard::remoteIDTypeRacoonToggled(const TQString& text)
{
	if (text == "asn1dn")
	{
		newprofilewizardracoonpagecontent->RemoteIDLineEdit->setDisabled(true);
		newprofilewizardracoonpagecontent->RemoteIDLabel->setDisabled(true);
	}
	else
	{
		newprofilewizardracoonpagecontent->RemoteIDLineEdit->setDisabled(false);
		newprofilewizardracoonpagecontent->RemoteIDLabel->setDisabled(false);
	}
}

void NewProfileWizard::localIDTypeRacoonToggled(const TQString& text)
{
	if (text == "none")
	{
		newprofilewizardracoonpagecontent->LocalIDLineEdit->setDisabled(true);
		newprofilewizardracoonpagecontent->LocalIDLabel->setDisabled(true);
	}
	else
	{
		newprofilewizardracoonpagecontent->LocalIDLineEdit->setDisabled(false);
		newprofilewizardracoonpagecontent->LocalIDLabel->setDisabled(false);
	}
}

void NewProfileWizard::remoteIDTypeIpsecToggled(const TQString& text)
{
	if (text == "asn1dn" || text == "none")
	{
		newprofilewizardfreeswanpagecontent->RemoteIDLineEdit->setDisabled(true);
		newprofilewizardfreeswanpagecontent->RemoteIDLabel->setDisabled(true);
	}
	else
	{
		newprofilewizardfreeswanpagecontent->RemoteIDLineEdit->setDisabled(false);
		newprofilewizardfreeswanpagecontent->RemoteIDLabel->setDisabled(false);
	}

}

void NewProfileWizard::localIDTypeIpsecToggled(const TQString& text)
{
	if (text == "asn1dn" || text == i18n("Certificate ID"))
	{
		newprofilewizardfreeswanpagecontent->LocalIDLineEdit->setDisabled(true);
		newprofilewizardfreeswanpagecontent->LocalIDLabel->setDisabled(true);
	}
	else
	{
		newprofilewizardfreeswanpagecontent->LocalIDLineEdit->setDisabled(false);
		newprofilewizardfreeswanpagecontent->LocalIDLabel->setDisabled(false);
	}
}

void NewProfileWizard::defaultRouteToggled(const TQString&)
{

	if (newprofilewizardnetworkroutecontent->DefaultRouteComboBox->currentText() == i18n("Keep default route") || newprofilewizardnetworkroutecontent->DefaultRouteComboBox->currentItem() == 0)
	{
		KMessageBox::information(0,i18n("Additional network route is needed:\n\nYou have selected to keep the default route. You have to add additional network routes to your remote network. Otherwise you probably dont have access to it."),i18n("Route needed"));
	}

}

void NewProfileWizard::ikeGroupToggled(bool)
{
	if (newprofilewizardracoonpagecontent->IkeGroupCheckbox->isChecked())
		newprofilewizardracoonpagecontent->DHGroupComboBox->setEnabled(true);
	else
		newprofilewizardracoonpagecontent->DHGroupComboBox->setEnabled(false);
}

void NewProfileWizard::useXauthFreeswanToggled(bool)
{
	if (newprofilewizardfreeswanpagecontent->UseXauthCheckBox->isChecked())
	{
		newprofilewizarduserpagecontent->setEnabled(true);
		newprofilewizardpskcontent->setEnabled(true);
		newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox->setEnabled(false);
		newprofilewizardfreeswanpagecontent->LocalIDLineEdit->setEnabled(true);
		newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox->setCurrentText("keyid");
	}
	else
	{
		newprofilewizarduserpagecontent->setEnabled(false);
		newprofilewizardpskcontent->setEnabled(false);
		newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox->setEnabled(true);
		newprofilewizardfreeswanpagecontent->LocalIDLineEdit->setEnabled(false);
		newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox->setCurrentText("asn1dn");
	}
}

void NewProfileWizard::useXauthRacoonToggled(bool)
{
	if (newprofilewizardracoonpagecontent->UseXauthCheckBox->isChecked())
	{
		newprofilewizarduserpagecontent->setEnabled(true);
		newprofilewizardpskcontent->setEnabled(true);
		newprofilewizardracoonpagecontent->LocalIdTypeCombobox->setEnabled(false);
		newprofilewizardracoonpagecontent->LocalIDLineEdit->setEnabled(true);
		newprofilewizardracoonpagecontent->LocalIdTypeCombobox->setCurrentText("keyid");
	}
	else
	{
		newprofilewizarduserpagecontent->setEnabled(false);
		newprofilewizardpskcontent->setEnabled(false);
		newprofilewizardracoonpagecontent->LocalIdTypeCombobox->setEnabled(true);
		newprofilewizardracoonpagecontent->LocalIDLineEdit->setEnabled(false);
		newprofilewizardracoonpagecontent->LocalIdTypeCombobox->setCurrentText("asn1dn");
	}
}

void NewProfileWizard::tunnelDeviceTypeChanged(const TQString & string )
{
	if ( profileData->getConnectionType() == VpnAccountData::openvpn || profileData->getConnectionType() == VpnAccountData::ssh)
	{
		if (string.lower() == "tun")
		{
			profilenetworkvirtualipoptionscontent->LabelRemoteVirtualIp->setText(i18n("Remote IP (virtual):"));
		}
		if (string.lower() == "tap")
		{
			profilenetworkvirtualipoptionscontent->LabelRemoteVirtualIp->setText(i18n("Netmask for local IP address:"));
		}
	}
}

void NewProfileWizard::useDnsServerToggled(bool)
{
	if ( newprofilewizardpptppagecontent->DnsServerCheckbox->isChecked() )
		newprofilewizardpptppagecontent->DnsServerLineedit->setEnabled( true );
	else
		newprofilewizardpptppagecontent->DnsServerLineedit->setEnabled( false );
}

void NewProfileWizard::useSearchDomainInResolvConfToggled(bool)
{
	if ( newprofilewizardpptppagecontent->UseSearchDomainInResolvConfCheckbox ->isChecked() )
		newprofilewizardpptppagecontent->SearchDomainInResolvConfLineedit->setEnabled( true );
	else
		newprofilewizardpptppagecontent->SearchDomainInResolvConfLineedit->setEnabled( false );
}

void NewProfileWizard::useDomainInResolvConfToggled(bool)
{
	if ( newprofilewizardpptppagecontent->UseDomainInResolvConfCheckbox ->isChecked() )
		newprofilewizardpptppagecontent->DomainInResolvConfLineedit->setEnabled( true );
	else
		newprofilewizardpptppagecontent->DomainInResolvConfLineedit->setEnabled( false );
}

#include "newprofilewizard.moc"
