/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//BEGIN INCLUDES
#include "toolsinfodialog.h"
#include "listviewtooltip.h"
#include <tdelistview.h>
//#include <tqlistviewitem.h>
#include <tqpixmap.h>
#include <tdeglobal.h>
#include <tqstring.h>
#include <kiconloader.h>
#include <iostream>
#include <tdelocale.h>
#include <tqcursor.h>

#include "utils.h"
//END INCLUDES

ToolsInfoDialog::ToolsInfoDialog(KVpncConfig *GlobalConfig, TQWidget *parent, const char *)
		:KDialogBase( parent, "Tool_information", true, "",
		              KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true )
{
	main = new ToolsInfoWidgetBase(this);
	setMainWidget(main);
	main->InfoListView->setMinimumSize(main->InfoListView->sizeHint());

	TQPixmap ok_icon = TDEGlobal::iconLoader()->loadIcon( "button_ok", TDEIcon::NoGroup, 16 );
	TQPixmap wrong_icon = TDEGlobal::iconLoader()->loadIcon( "button_cancel", TDEIcon::NoGroup, 16 );
	ToolInfo *tool=0;
	main->InfoListView->setSorting(1);

	GlobalConfig->appPointer->setOverrideCursor( TQCursor(TQt::WaitCursor) );

	for ( tool = GlobalConfig->ToolList->first(); tool; tool = GlobalConfig->ToolList->next() )
	{
// 		std::cout << "tool: " << tool->Name.ascii() << std::endl;
		// 		std::cout << "Version: " << tool->Version << std::endl;
		// 		std::cout << "Path: " << tool->PathToExec << std::endl << std::endl;
		TQString state="";
		TQString usability="";
		TQString requiredBy="";
		TQString comment="";

		tool->programsInPath =  GlobalConfig->programsInPath;

// 		tool->collectToolInfo();

		if (!tool->PathToExec.isEmpty() && TQFile (tool->PathToExec).exists() && TQFileInfo(tool->PathToExec).isFile() )
		{
// 			state=i18n("Found");
			if (tool->Name == "vpnc")
			{
				// FIXME use major/minor/subminor version
				if ( tool->Version.find("0.3.",0,-1) > -1 || tool->Version.find("0.4.",0,-1) > -1)
				{
					usability=i18n("good");
					comment=i18n("no certificate support");
				}
				if ( tool->Version.find("0.5.",0,-1) > -1 )
				{
					usability=i18n("good");
					if( tool->Capabilities.find(i18n("openssl (certificate) support"),0,-1) > -1)
						comment=i18n("hybrid support");
					else
						comment=i18n("no certificate support");
				}
				else if ( tool->Version.find("0.3.2",0,-1) > -1)
				{
					usability=i18n("limited");
					comment=i18n("no split DNS support");
				}
				else if ( tool->Version.find("0.2.",0,-1) > -1)
				{
					usability=i18n("basic");
					comment=i18n("no NAT-T, IPSec over IP, no split DNS support");
				}

			}
			else if (tool->Name == "ciscovpnc")
			{
				usability=i18n("full");
			}
			else if (tool->Name == "ipsec")
			{
				// version is like this: "Openswan U2.4.4/K2.6.15" or "strongSwan U2.4.4/K2.6.15"
				TQString realversion=tool->Version.section(' ',1,1).section('/',0,0).right(tool->Version.section(' ',1,1).section('/',0,0).length()-1);
				int majorversion = realversion.section('.',0,0).toInt();
				int minorversion = realversion.section('.',1,1).toInt();
				int subminorversion = realversion.section('.',2,2).toInt();
				TQString realtype=tool->Version.section(' ',0,0).lower();

				if ( tool->Version.contains("Openswan"))
				{
					comment="Openswan";
					comment+=", "+i18n("kernel %1 support").arg("2.6");
					comment+=", "+i18n("smartcard support");
				}
				else if ( tool->Version.contains("strongSwan"))
				{
					comment="strongSwan";
					comment+=", "+i18n("no aggressive mode");
					comment+=", "+i18n("kernel %1 support").arg("2.4");
					if (!(majorversion <= 2 && minorversion <= 8 && subminorversion <= 1))
						comment+=", "+i18n("kernel %1 support").arg("2.6");
					comment+=", "+i18n("smartcard support");
				}
				else
				{
					comment+="FreeS/WAN";
				}

				if ( realversion.find("2.",0,-1) > -1)
					usability=i18n("full");
				else if ( realversion.find("1.",0,-1) > -1)
				{
					usability=i18n("limited");
					comment=+", "+i18n("no aggressive mode");
				}
				else
					usability=i18n("unknown");

			}
			else if (tool->Name == "racoon")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "openvpn")
			{
				if ( tool->Version.find("2.",0,-1) > -1)
				{
					usability=i18n("full");
// 					int major=tool->Version.section('.',0,0).toInt();
// 					int minor=tool->Version.section('.',1,1).toInt();
// 					int subminor=tool->Version.section('.',2,2).toInt();

// 					if ( major >= 2 && minor >= 1)
						if (tool->Capabilities.find( i18n("pkcs11 support"), 0, FALSE ) > -1 )
						{
							if (!comment.isEmpty())
								comment+=", ";
							comment+=i18n("smartcard support");
						}
				}
				else if ( tool->Version.find("1.",0,-1) > -1)
					//else
					usability=i18n("limited");
			}
			else if (tool->Name == "pppd")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");

				Utils::PppdCapabilities pppdcap = Utils ( GlobalConfig ).checkPppdCapabilities();
				comment="";
				if (pppdcap.pppdHasMppeRequiredSupport==true)
				{
					if (!comment.isEmpty())
						comment+=",";
					comment+= "mppe required";
				}
				if (pppdcap.pppdHasRequireMppeSupport==true)
				{
					if (!comment.isEmpty())
						comment+=",";
					comment+= "require-mppe";
				}
				if (pppdcap.pppdHasReplacedefaultrouteSupport==true)
				{
					if (!comment.isEmpty())
						comment+=",";
					comment+="replacedefaultroute";
				}
				if (pppdcap.pppdHasMppeSupport==true)
				{
					if (!comment.isEmpty())
						comment+=",";
					comment+= "mppe support";
				}
			}
			else if (tool->Name == "pptp")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "vtund")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "ping")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "pkcs11-tool")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "cisco_cert_mgr")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
				requiredBy=i18n("Cisco (propritary)");
			}
			else if (tool->Name == "kill")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "ip")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "ifconfig")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "route")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "bash")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "iptables")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "killall")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "openssl")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "setkey")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "vpnclient")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "l2tpd")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
// 				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "xl2tpd")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
// 				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "openl2tp")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
// 				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "tail")
			{
// 				comment+=", "+i18n("kernel %1 support").arg("2.6");
			}
			else if (tool->Name == "ssh")
			{
				int major=tool->Version.section('.',0,0).toInt();
				int minor=tool->Version.section('.',1,1).section('p',0,0).toInt();
// 				std::cout << "ssh version: major: " << TQString().setNum(major).ascii() << " minor: " << TQString().setNum(minor).ascii() << std::endl;
				if ( major > 4 || ( major == 4 && minor >= 3) )
				{
					usability=i18n("full");
				}
				else
				{
					if ( major < 4  )
						//else
						usability=i18n("unuseable");
						comment=+i18n("no vpn support");
				}
			}

			else
			{
				// other tools
				usability=i18n("full");
			}

		}
		else
		{
// 			state=i18n("Not found");
			usability=i18n("none");
		}

// 		state=i18n("Found");
		if (tool->Name == "vpnc")
		{
			requiredBy=i18n("Cisco (free)");
		}
		else if (tool->Name == "ciscovpnc")
		{
			requiredBy=i18n("Cisco (propritary)");
		}
		else if (tool->Name == "ipsec")
		{
			TQString realversion=tool->Version.section(' ',1,1).section('/',0,0).right(tool->Version.section(' ',1,1).section('/',0,0).length()-1);
			TQString realtype=tool->Version.section(' ',0,0).lower();

			if ( tool->Version.contains("Openswan"))
			{
				requiredBy=i18n("Openswan");
			}
			else if ( tool->Version.contains("strongSwan"))
			{
				requiredBy=i18n("strongSwan");
			}
			else
			{
				requiredBy=i18n("FreeS/WAN");
			}

		}

// 		std::cout << "Tool: " << tool->Name.ascii() << " Path: "<< tool->PathToExec.ascii() << " Version: " << tool->Version.ascii() << " Found: " << state.ascii() << std::endl;

		else if (tool->Name == "racoon")
		{
			requiredBy=i18n("ipsec-tools (racoon)");
		}
		else if (tool->Name == "openvpn")
		{
			requiredBy=i18n("OpenVPN");
		}
		else if (tool->Name == "pppd")
		{
			requiredBy=i18n("PPTP");
		}
		else if (tool->Name == "pptp")
		{
			requiredBy=i18n("PPTP");
		}
		else if (tool->Name == "vtund")
		{
			requiredBy=i18n("VTun");
		}
		else if (tool->Name == "ping")
		{
			requiredBy=i18n("KVpnc");
		}
		else if (tool->Name == "pkcs11-tool")
		{
			requiredBy=i18n("Smartcard support");
		}

		else if (tool->Name == "cisco_cert_mgr")
		{
			requiredBy=i18n("Cisco (propritary)");
		}

		else if (tool->Name == "kill")
		{
			requiredBy=i18n("KVpnc");
		}
		else if (tool->Name == "ip")
		{
			requiredBy=i18n("KVpnc");
		}
		else if (tool->Name == "ifconfig")
		{
			requiredBy=i18n("KVpnc");
		}
		else if (tool->Name == "route")
		{
			requiredBy=i18n("KVpnc");
		}
		else if (tool->Name == "bash")
		{
			requiredBy=i18n("KVpnc");
		}
		else if (tool->Name == "iptables")
		{
			requiredBy=i18n("KVpnc");
		}
		else if (tool->Name == "killall")
		{
			requiredBy=i18n("KVpnc");
		}
		else if (tool->Name == "openssl")
		{
			requiredBy=i18n("Certificate support");
		}
		else if (tool->Name == "setkey")
		{
			requiredBy=i18n("ipsec-tools (racoon)");
		}
		else if (tool->Name == "vpnclient")
		{
			requiredBy=i18n("Cisco (propritary)");
		}
		else if (tool->Name == "l2tpd")
		{
			requiredBy=i18n("L2TP");
		}
		else if (tool->Name == "xl2tpd")
		{
			requiredBy=i18n("L2TP");
		}
		else if (tool->Name == "openl2tpd")
		{
			requiredBy=i18n("L2TP");
		}
		else if (tool->Name == "tail")
		{
			requiredBy=i18n("ipsec (Openswan, strongSwan, racoon)");
		}
		else if (tool->Name == "ssh")
		{
			requiredBy=i18n("SSH VPN");
		}
		else if (tool->Name == "ksshaskpass")
		{
			requiredBy=i18n("SSH VPN");
		}
		else if (tool->Name == "gnome-ssh-askpass")
		{
			requiredBy=i18n("SSH VPN");
		}
		else if (tool->Name == "netstat")
		{
			requiredBy = i18n("ipsec (Openswan, strongSwan, racoon)");
  		}
		else
		{
			// other tools
		}



		TQListViewItem *item = new TQListViewItem(main->InfoListView, tool->Name,state, tool->Version, usability,requiredBy , tool->PathToExec, comment);
		if (tool->found)
			item->setPixmap(1,ok_icon);
		else
			item->setPixmap(1,wrong_icon);
		main->InfoListView->insertItem(item);

	}

	TQToolTip::remove( main->InfoListView );
	new ListViewToolTip( main->InfoListView );

	this->resize(800,600);
	main->InfoListView->resize(main->InfoListView->sizeHint());
	main->resize(main->sizeHint());
	//this->resize(sizeHint());

	GlobalConfig->appPointer->restoreOverrideCursor();
}

