/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "profilenetworkvirtualipoptions.h"

#include <tqcheckbox.h>
#include <tqlabel.h>
#include <klineedit.h>
#include "widgetnotifyhelper.h"
#include <iostream>

ProfileNetworkVirtualIpOptions::ProfileNetworkVirtualIpOptions(TQWidget *parent)
		: ProfileNetworkVirtualIpOptionsBase(parent)
{
	WidgetNotifyHelper h;
	h.setupChangedAction(this);
	dialogModified=false;
}


ProfileNetworkVirtualIpOptions::~ProfileNetworkVirtualIpOptions()
{}

void ProfileNetworkVirtualIpOptions::useVirtualIpAddressToggled(bool)
{
	if (UseVirtualIPCheckBox->isChecked()){
		LocalVirtualIpEdit->setEnabled( TRUE );
		LabelLocalVirtualIp->setEnabled( TRUE );
		RemoteVirtualIpLineEdit->setEnabled( TRUE );
		LabelRemoteVirtualIp->setEnabled( TRUE );
	}
	else {
		LocalVirtualIpEdit->setEnabled( FALSE );
		LabelLocalVirtualIp->setEnabled( FALSE );
		RemoteVirtualIpLineEdit->setEnabled( FALSE );
		LabelRemoteVirtualIp->setEnabled( FALSE );
	}
}

void ProfileNetworkVirtualIpOptions::dialogChanged()
{
// 	std::cout << "ProfileNetworkVirtualIpOptions::dialogChanged()" << std::endl;
	dialogModified=true;
}

void ProfileNetworkVirtualIpOptions::useLeftSourceIpToggeled(bool)
{
	if (UseLeftSourceIpCheckBox->isChecked())
		LeftSourceIpLineEdit->setEnabled(true);
	else
		LeftSourceIpLineEdit->setEnabled(false);
}

void ProfileNetworkVirtualIpOptions::useRightSourceIpToggeled(bool)
{
	if (UseRightSourceIpCheckBox->isChecked())
		RightSourceIpLineEdit->setEnabled(true);
	else
		RightSourceIpLineEdit->setEnabled(false);
}

void ProfileNetworkVirtualIpOptions::useVirtualSubnetsToggled(bool)
{
	if (UseVirtualSubnetsCheckBox->isChecked())
		VirtualSubnetsLineEdit->setEnabled(true);
	else
		VirtualSubnetsLineEdit->setEnabled(false);
}


