/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   Contains parts of code of the konversation project (konvisettingsdialog.cpp)
*   http://konversation.kde.org/                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/ 
//BEGIN INCLUDES
#include "preferencesdialog.h"
#include <tqtabwidget.h>
#include <tqpushbutton.h>
#include <tdelocale.h>
#include <tqcheckbox.h>
#include <tqwhatsthis.h>
#include <tdemessagebox.h>
#include <tqspinbox.h>
#include <tqpixmap.h>
#include <kurlrequester.h>
#include <kcolordialog.h>
#include <kcombobox.h>
#include <tqlabel.h>
#include <tqstringlist.h>
#include <tqcursor.h>
#include <tqobjectlist.h>
#include <kiconloader.h>
#include <klineedit.h>
#include <kinputdialog.h>
#include <knuminput.h>
#include <tdelistview.h>
#include <ktextedit.h>
#include <kpassdlg.h>
#include <tqlayout.h>
#include <tqhbox.h>
#include <tqcursor.h>
#include <tqradiobutton.h>
#include <tqbuttongroup.h>
#include "networkinterface.h"
#include "utils.h"
#include "importcertificatedialog.h"
#include "newprofiledialog.h"

#include <iostream> 
//END INCLUDES

PreferencesDialog::PreferencesDialog( TQWidget *parent, TQApplication *app, TQTextEdit *LogOutput, KVpncConfig *GlobalConfig, bool showOnlyProfiles ) : KDialogBase ( KDialogBase::TreeList, i18n( "Preferences..." ),
		        KDialogBase::Ok | KDialogBase::Apply | KDialogBase::Cancel | KDialogBase::Help, KDialogBase::Ok,
		        parent, "configdialog" )
{
	GlobalConfig->appPointer->setOverrideCursor( TQCursor(TQt::WaitCursor) );
	GlobalConfig->prefDlgOpen = true;
	//main = new PreferencesDialogBase(this);

	//setMainWidget(main);
	//main->setMinimumSize(main->sizeHint())
	
	this->AccountList = GlobalConfig->AccountList;
	this->LogOutput = LogOutput;
	this->currentProfile = GlobalConfig->currentProfile;
	this->KvpncDebugLevel = GlobalConfig->KvpncDebugLevel;
	this->app = app;
	this->GlobalConfig = GlobalConfig;

	lastProfileName = "";
	profileHasChanged=false;
	prev_page=0;
	current_page=0;
	
	this->showOnlyProfiles = showOnlyProfiles;
	if ( showOnlyProfiles )
	{
		setCaption( i18n( "Manage Profiles" ) );
	}
	setupGui();

	// 	DaemonOptionsWidget->ProgramsInPathcheckBox->setChecked(GlobalConfig->programsInPath);
	// 	programsInPathToggled(GlobalConfig->programsInPath);
	//

	ok_icon = TDEGlobal::iconLoader() ->loadIcon( "button_ok", TDEIcon::NoGroup, 16 );
	wrong_icon = TDEGlobal::iconLoader() ->loadIcon( "button_cancel", TDEIcon::NoGroup, 16 );

	unfoldTreeList ();
	if ( !showOnlyProfiles )
	{
		ConfigDaemonOptionsWidget->RacoonDebugLevelComboBox->clear();

		/* these levels must be deactivated because we need informational output !!! */
		//ConfigDaemonOptionsWidget->RacoonDebugLevelComboBox->insertItem( "none" );
		//ConfigDaemonOptionsWidget->RacoonDebugLevelComboBox->insertItem( "warning" );
 		//ConfigDaemonOptionsWidget->RacoonDebugLevelComboBox->insertItem( "notify" );
		
		ConfigDaemonOptionsWidget->RacoonDebugLevelComboBox->insertItem( "info" );
		ConfigDaemonOptionsWidget->RacoonDebugLevelComboBox->insertItem( "debug" );
		ConfigDaemonOptionsWidget->RacoonDebugLevelComboBox->insertItem( "debug2" );
		

		if ( GlobalConfig->PptpLogLevel == 0 )
			ConfigDaemonOptionsWidget->PptpLogLevelComboBox->setCurrentText( i18n( "low" ) );
		else if ( GlobalConfig->PptpLogLevel == 1 )
			ConfigDaemonOptionsWidget->PptpLogLevelComboBox->setCurrentText( i18n( "default" ) );
		else if ( GlobalConfig->PptpLogLevel == 2 )
			ConfigDaemonOptionsWidget->PptpLogLevelComboBox->setCurrentText( i18n( "high" ) );

		ConfigDaemonOptionsWidget->DoKillL2tpdIfStillRunningCheckBox->setChecked(GlobalConfig->doKillL2tpdIfStillRunning);
		ConfigDaemonOptionsWidget->DoKillXl2tpdIfStillRunningCheckBox->setChecked(GlobalConfig->doKillXl2tpdIfStillRunning);
		ConfigDaemonOptionsWidget->DoKillRacoonIfStillRunningCheckBox->setChecked(GlobalConfig->doKillRacoonIfStillRunning);

		slotStatusMsg ( i18n( "Collecting daemon tool data..."), ID_STATUS_MSG );

		ToolInfo *VpncInfo = Utils( GlobalConfig ).getToolInfo ( "vpnc" );
		VpncInfo->collectToolInfo();
		ToolInfo *CiscoVpncInfo = Utils( GlobalConfig ).getToolInfo ( "vpnclient" );
		CiscoVpncInfo->collectToolInfo();
		ToolInfo *IpsecInfo = Utils( GlobalConfig ).getToolInfo ( "ipsec" );
		IpsecInfo->collectToolInfo();
		ToolInfo *RacoonInfo = Utils( GlobalConfig ).getToolInfo ( "racoon" );
		RacoonInfo->collectToolInfo();
		ToolInfo *PppdInfo = Utils( GlobalConfig ).getToolInfo ( "pppd" );
		PppdInfo->collectToolInfo();
		ToolInfo *PptpInfo = Utils( GlobalConfig ).getToolInfo ( "pptp" );
		PptpInfo->collectToolInfo();
		ToolInfo *L2tpdInfo = Utils( GlobalConfig ).getToolInfo ( "l2tpd" );
		L2tpdInfo->collectToolInfo();
		ToolInfo *Xl2tpdInfo = Utils( GlobalConfig ).getToolInfo ( "xl2tpd" );
		Xl2tpdInfo->collectToolInfo();
		ToolInfo *Openl2tpInfo = Utils( GlobalConfig ).getToolInfo ( "openl2tpd" );
		Openl2tpInfo->collectToolInfo();
		ToolInfo *OpenvpnInfo = Utils( GlobalConfig ).getToolInfo ( "openvpn" );
		OpenvpnInfo->collectToolInfo();
		ToolInfo *VtunInfo = Utils( GlobalConfig ).getToolInfo ( "vtund" );
		VtunInfo->collectToolInfo();
		ToolInfo *SshInfo = Utils( GlobalConfig ).getToolInfo ( "ssh" );
		SshInfo->collectToolInfo();

		ConfigDaemonOptionsWidget->VpncVersionLineEdit->setText( VpncInfo->Version );
		ConfigDaemonOptionsWidget->CiscoVpncVersionLineEdit->setText( CiscoVpncInfo->Version );
		ConfigDaemonOptionsWidget->IpsecVersionLineEdit->setText( IpsecInfo->Version );
		ConfigDaemonOptionsWidget->RacoonVersionLineEdit->setText( RacoonInfo->Version );
		ConfigDaemonOptionsWidget->PppdVersionLineEdit->setText( PppdInfo->Version );
		ConfigDaemonOptionsWidget->PptpVersionLineEdit->setText( PptpInfo->Version );
		ConfigDaemonOptionsWidget->OpenvpnVersionLineEdit->setText( OpenvpnInfo->Version );
		ConfigDaemonOptionsWidget->L2tpdVersionLineEdit->setText( L2tpdInfo->Version );
		ConfigDaemonOptionsWidget->Xl2tpdVersionLineEdit->setText( Xl2tpdInfo->Version );
		ConfigDaemonOptionsWidget->Openl2tpVersionLineEdit->setText( Openl2tpInfo->Version );
		ConfigDaemonOptionsWidget->VtunVersionLineEdit->setText( VtunInfo->Version );
		ConfigDaemonOptionsWidget->SshVersionLineEdit->setText( SshInfo->Version );

		if (GlobalConfig->pathToVpnc.isEmpty() && !VpncInfo->PathToExec.isEmpty())
			ConfigDaemonOptionsWidget->VpncPathInput->setURL( VpncInfo->PathToExec );
		else
			ConfigDaemonOptionsWidget->VpncPathInput->setURL( GlobalConfig->pathToVpnc );

		if (GlobalConfig->pathToVpnc.isEmpty() && !VpncInfo->PathToExec.isEmpty())
			ConfigDaemonOptionsWidget->CiscoVpncPathInput->setURL( CiscoVpncInfo->PathToExec );
		else
			ConfigDaemonOptionsWidget->CiscoVpncPathInput->setURL( GlobalConfig->pathToCiscoVpnc );

		if (GlobalConfig->pathToIpsec.isEmpty() && !IpsecInfo->PathToExec.isEmpty())
			ConfigDaemonOptionsWidget->FreeswanPathInput->setURL( IpsecInfo->PathToExec );
		else
			ConfigDaemonOptionsWidget->FreeswanPathInput->setURL( GlobalConfig->pathToIpsec );

		if (GlobalConfig->pathToRacoon.isEmpty() && !RacoonInfo->PathToExec.isEmpty())
			ConfigDaemonOptionsWidget->RacoonPathInput->setURL( RacoonInfo->PathToExec );
		else
			ConfigDaemonOptionsWidget->RacoonPathInput->setURL( GlobalConfig->pathToRacoon );

		if (GlobalConfig->pathToPppd.isEmpty() && !PppdInfo->PathToExec.isEmpty())
			ConfigDaemonOptionsWidget->PppdPathInput->setURL( PppdInfo->PathToExec );
		else
			ConfigDaemonOptionsWidget->PppdPathInput->setURL( GlobalConfig->pathToPppd );

		if (GlobalConfig->pathToPptp.isEmpty() && !PptpInfo->PathToExec.isEmpty())
			ConfigDaemonOptionsWidget->PptpPathInput->setURL( PptpInfo->PathToExec );
		else
			ConfigDaemonOptionsWidget->PptpPathInput->setURL( GlobalConfig->pathToPptp );

		if (GlobalConfig->pathToOpenvpn.isEmpty() && !OpenvpnInfo->PathToExec.isEmpty())
			ConfigDaemonOptionsWidget->OpenvpnPathInput->setURL( OpenvpnInfo->PathToExec );
		else
			ConfigDaemonOptionsWidget->OpenvpnPathInput->setURL( GlobalConfig->pathToOpenvpn );

		if (GlobalConfig->pathToL2tpd.isEmpty() && !L2tpdInfo->PathToExec.isEmpty())
			ConfigDaemonOptionsWidget->L2tpdPathInput->setURL( L2tpdInfo->PathToExec );
		else
			ConfigDaemonOptionsWidget->L2tpdPathInput->setURL( GlobalConfig->pathToL2tpd );

		if (GlobalConfig->pathToXl2tpd.isEmpty() && !Xl2tpdInfo->PathToExec.isEmpty())
			ConfigDaemonOptionsWidget->Xl2tpdPathInput->setURL( Xl2tpdInfo->PathToExec );
		else
			ConfigDaemonOptionsWidget->Xl2tpdPathInput->setURL( GlobalConfig->pathToXl2tpd );

		if (GlobalConfig->pathToOpenl2tp.isEmpty() && !Openl2tpInfo->PathToExec.isEmpty())
			ConfigDaemonOptionsWidget->Openl2tpPathInput->setURL( Openl2tpInfo->PathToExec );
		else
			ConfigDaemonOptionsWidget->Openl2tpPathInput->setURL( GlobalConfig->pathToOpenl2tp );

		if (GlobalConfig->pathToVtund.isEmpty() && !VtunInfo->PathToExec.isEmpty())
			ConfigDaemonOptionsWidget->VtundPathInput->setURL( VtunInfo->PathToExec );
		else
			ConfigDaemonOptionsWidget->VtundPathInput->setURL( GlobalConfig->pathToVtund );

		if (GlobalConfig->pathToSsh.isEmpty() && !SshInfo->PathToExec.isEmpty())
			ConfigDaemonOptionsWidget->SshPathInput->setURL( VtunInfo->PathToExec );
		else
			ConfigDaemonOptionsWidget->SshPathInput->setURL( GlobalConfig->pathToSsh );


		if ( VpncInfo->found && TQFileInfo( VpncInfo->PathToExec ).isFile() && VpncInfo->found )
			ConfigDaemonOptionsWidget->VpncStatePixmapLabel->setPixmap( ok_icon );
		else
			ConfigDaemonOptionsWidget->CiscoVpncStatePixmapLabel->setPixmap( wrong_icon );
		if ( VpncInfo->found && TQFileInfo( CiscoVpncInfo->PathToExec ).isFile() && CiscoVpncInfo->found )
			ConfigDaemonOptionsWidget->CiscoVpncStatePixmapLabel->setPixmap( ok_icon );
		else
			ConfigDaemonOptionsWidget->CiscoVpncStatePixmapLabel->setPixmap( wrong_icon );

		if ( VtunInfo->found && TQFileInfo( VtunInfo->PathToExec ).isFile() && VtunInfo->found )
			ConfigDaemonOptionsWidget->VtundStatePixmapLabel->setPixmap( ok_icon );
		else
			ConfigDaemonOptionsWidget->VtundStatePixmapLabel->setPixmap( wrong_icon );

		if ( SshInfo->found && TQFileInfo( SshInfo->PathToExec ).isFile() && SshInfo->found )
			ConfigDaemonOptionsWidget->SshStatePixmapLabel->setPixmap( ok_icon );
		else
			ConfigDaemonOptionsWidget->SshStatePixmapLabel->setPixmap( wrong_icon );

		if ( IpsecInfo->found )
			ConfigDaemonOptionsWidget->IpsecStatePixmapLabel->setPixmap( ok_icon );
		else
			ConfigDaemonOptionsWidget->IpsecStatePixmapLabel->setPixmap( wrong_icon );
		if ( RacoonInfo->found )
			ConfigDaemonOptionsWidget->RacoonStatePixmapLabel->setPixmap( ok_icon );
		else
			ConfigDaemonOptionsWidget->RacoonStatePixmapLabel->setPixmap( wrong_icon );
		if ( PppdInfo->found )
			ConfigDaemonOptionsWidget->PppdStatePixmapLabel->setPixmap( ok_icon );
		else
			ConfigDaemonOptionsWidget->PppdStatePixmapLabel->setPixmap( wrong_icon );
		if ( PptpInfo->found )
			ConfigDaemonOptionsWidget->PptpStatePixmapLabel->setPixmap( ok_icon );
		else
			ConfigDaemonOptionsWidget->PptpStatePixmapLabel->setPixmap( wrong_icon );
		if ( OpenvpnInfo->found )
			ConfigDaemonOptionsWidget->OpenvpnStatePixmapLabel->setPixmap( ok_icon );
		else
			ConfigDaemonOptionsWidget->OpenvpnStatePixmapLabel->setPixmap( wrong_icon );
		if ( L2tpdInfo->found )
			ConfigDaemonOptionsWidget->L2tpdStatePixmapLabel->setPixmap( ok_icon );
		else
			ConfigDaemonOptionsWidget->L2tpdStatePixmapLabel->setPixmap( wrong_icon );
		if ( Xl2tpdInfo->found )
			ConfigDaemonOptionsWidget->Xl2tpdStatePixmapLabel->setPixmap( ok_icon );
		else
			ConfigDaemonOptionsWidget->Xl2tpdStatePixmapLabel->setPixmap( wrong_icon );
		if ( Openl2tpInfo->found )
			ConfigDaemonOptionsWidget->Openl2tpStatePixmapLabel->setPixmap( ok_icon );
		else
			ConfigDaemonOptionsWidget->Openl2tpStatePixmapLabel->setPixmap( wrong_icon );


		HelperProgramOptionsWidget->IptablesPathInput->setURL( GlobalConfig->pathToIptables );
		HelperProgramOptionsWidget->OpenSSLPathInput->setURL( GlobalConfig->pathToOpenssl );
		HelperProgramOptionsWidget->KillPathInput->setURL( GlobalConfig->pathToKill );
		HelperProgramOptionsWidget->KillallPathInput->setURL( GlobalConfig->pathToKillall );
		HelperProgramOptionsWidget->PingPathInput->setURL( GlobalConfig->pathToPing );
		HelperProgramOptionsWidget->IpPathInput->setURL( GlobalConfig->pathToIp );
		HelperProgramOptionsWidget->IfconfigPathInput->setURL( GlobalConfig->pathToIfconfig );
		HelperProgramOptionsWidget->RoutePathInput->setURL( GlobalConfig->pathToRoute );
		HelperProgramOptionsWidget->Pkcs11ToolPathInput->setURL( GlobalConfig->pathToPkcs11Tool );
		HelperProgramOptionsWidget->CiscoCertMgrPathInput->setURL( GlobalConfig->pathToCiscoCertMgr );
		HelperProgramOptionsWidget->TailPathInput->setURL( GlobalConfig->pathToTail );
		HelperProgramOptionsWidget->KsshaskpassPathInput->setURL( GlobalConfig->pathToKsshAskpass );
		HelperProgramOptionsWidget->GnomeaskpassPathInput->setURL( GlobalConfig->pathToGnomeSshAskpass );

		slotStatusMsg ( i18n( "Collecting helper tool data..."), ID_STATUS_MSG );

		ToolInfo *OpensslInfo = Utils( GlobalConfig ).getToolInfo ( "openssl" );
		OpensslInfo->collectToolInfo();
		ToolInfo *IptablesInfo = Utils( GlobalConfig ).getToolInfo ( "iptables" );
		IptablesInfo->collectToolInfo();
		ToolInfo *KillInfo = Utils( GlobalConfig ).getToolInfo ( "kill" );
		KillInfo->collectToolInfo();
		ToolInfo *KillallInfo = Utils( GlobalConfig ).getToolInfo ( "killall" );
		KillallInfo->collectToolInfo();
		ToolInfo *PingInfo = Utils( GlobalConfig ).getToolInfo ( "ping" );
		PingInfo->collectToolInfo();
		ToolInfo *IpInfo = Utils( GlobalConfig ).getToolInfo ( "ip" );
		IpInfo->collectToolInfo();
		ToolInfo *IfconfigInfo = Utils( GlobalConfig ).getToolInfo ( "ifconfig" );
		IfconfigInfo->collectToolInfo();
		ToolInfo *RouteInfo = Utils( GlobalConfig ).getToolInfo ( "route" );
		RouteInfo->collectToolInfo();
		ToolInfo *Pkcs11ToolInfo = Utils( GlobalConfig ).getToolInfo ( "pkcs11-tool" );
		Pkcs11ToolInfo->collectToolInfo();
		ToolInfo *CiscoCertMgrInfo = Utils( GlobalConfig ).getToolInfo ( "cisco_cert_mgr" );
		CiscoCertMgrInfo->collectToolInfo();
		ToolInfo *TailInfo = Utils( GlobalConfig ).getToolInfo ( "tail" );
		TailInfo->collectToolInfo();
		ToolInfo *KsshaskpassInfo = Utils( GlobalConfig ).getToolInfo ( "ksshaskpass" );
		KsshaskpassInfo->collectToolInfo();
		ToolInfo *GnomeaskpassInfo = Utils( GlobalConfig ).getToolInfo ( "gnome-ssh-askpass" );
		GnomeaskpassInfo->collectToolInfo();


		HelperProgramOptionsWidget->OpensslVersionLineEdit->setText( OpensslInfo->Version );
		HelperProgramOptionsWidget->IptablesVersionLineEdit->setText( IptablesInfo->Version );
		HelperProgramOptionsWidget->KillVersionLineEdit->setText( KillInfo->Version );
		HelperProgramOptionsWidget->KillallVersionLineEdit->setText( KillallInfo->Version );
		HelperProgramOptionsWidget->PingVersionLineEdit->setText( PingInfo->Version );
		HelperProgramOptionsWidget->IpVersionLineEdit->setText( IpInfo->Version );
		HelperProgramOptionsWidget->IfconfigVersionLineEdit->setText( IfconfigInfo->Version );
		HelperProgramOptionsWidget->RouteVersionLineEdit->setText( RouteInfo->Version );
		HelperProgramOptionsWidget->Pkcs11ToolVersionLineEdit->setText( Pkcs11ToolInfo->Version );
		HelperProgramOptionsWidget->CiscoCertMgrVersionLineEdit->setText( CiscoCertMgrInfo->Version );
		HelperProgramOptionsWidget->TailVersionLineEdit->setText( TailInfo->Version );
		HelperProgramOptionsWidget->KsshaskpassVersionLineEdit->setText( KsshaskpassInfo->Version );
		HelperProgramOptionsWidget->GnomeaskpassVersionLineEdit->setText( GnomeaskpassInfo->Version );

		if ( OpensslInfo->found )
			HelperProgramOptionsWidget->OpensslStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->OpensslStatePixmapLabel->setPixmap( wrong_icon );
		if ( IptablesInfo->found )
			HelperProgramOptionsWidget->IptablesStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->IptablesStatePixmapLabel->setPixmap( wrong_icon );
		if ( KillInfo->found )
			HelperProgramOptionsWidget->KillStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->KillStatePixmapLabel->setPixmap( wrong_icon );
		if ( KillallInfo->found )
			HelperProgramOptionsWidget->KillallStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->KillallStatePixmapLabel->setPixmap( wrong_icon );
		if ( PingInfo->found )
			HelperProgramOptionsWidget->PingStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->PingStatePixmapLabel->setPixmap( wrong_icon );
		if ( IpInfo->found )
			HelperProgramOptionsWidget->IpStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->IpStatePixmapLabel->setPixmap( wrong_icon );
		if ( IfconfigInfo->found )
			HelperProgramOptionsWidget->IfconfigStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->IfconfigStatePixmapLabel->setPixmap( wrong_icon );
		if ( RouteInfo->found )
			HelperProgramOptionsWidget->RouteStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->RouteStatePixmapLabel->setPixmap( wrong_icon );
		if ( Pkcs11ToolInfo->found )
			HelperProgramOptionsWidget->Pkcs11ToolStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->Pkcs11ToolStatePixmapLabel->setPixmap( wrong_icon );
		if ( CiscoCertMgrInfo->found )
			HelperProgramOptionsWidget->CiscoCertMgrStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->CiscoCertMgrStatePixmapLabel->setPixmap( wrong_icon );
		if ( TailInfo->found )
			HelperProgramOptionsWidget->TailStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->TailStatePixmapLabel->setPixmap( wrong_icon );
		if ( KsshaskpassInfo->found )
			HelperProgramOptionsWidget->KsshaskpassStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->KsshaskpassStatePixmapLabel->setPixmap( wrong_icon );
		if ( GnomeaskpassInfo->found )
			HelperProgramOptionsWidget->GnomeaskpassStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->GnomeaskpassStatePixmapLabel->setPixmap( wrong_icon );

		slotStatusMsg ( i18n("Ready."), ID_STATUS_MSG );

		ConnectOptionsWidget->checkMinimizeAfterConnectCheck->setChecked( GlobalConfig->minimizeAfterConnect );
		DebugOptionsWidget->showDebugCheck->setChecked( GlobalConfig->showDebugConsole );
		DebugOptionsWidget->WriteLogCheck->setChecked( GlobalConfig->writeLogFile );
		DebugOptionsWidget->spinKvpncDebugLevel->setValue ( GlobalConfig->KvpncDebugLevel );
		
		if (GlobalConfig->RacoonDebugLevel != "info" && GlobalConfig->RacoonDebugLevel != "debug" && GlobalConfig->RacoonDebugLevel != "debug2" )
			GlobalConfig->RacoonDebugLevel = "info";
		ConfigDaemonOptionsWidget->RacoonDebugLevelComboBox->setCurrentText ( GlobalConfig->RacoonDebugLevel );
		ConfigDaemonOptionsWidget->spinVpncDebugLevel->setValue ( GlobalConfig->VpncDebugLevel );
		ConfigDaemonOptionsWidget->spinOpenvpnDebugLevel->setValue ( GlobalConfig->OpenvpnDebugLevel - 1 );
		ConfigDaemonOptionsWidget->DebugPppdcheckBox->setChecked( GlobalConfig->enableDebugPppd );
		ConfigDaemonOptionsWidget->DebugPptpdcheckBox->setChecked( GlobalConfig->enableDebugPptpd );
		ConfigDaemonOptionsWidget->spinSshDebugLevel->setValue ( GlobalConfig->SshDebugLevel  );


		ConfigDaemonOptionsWidget->EnableDebugXl2tpdtunnelCheckBox->setChecked( GlobalConfig->enableDebugXl2tpdtunnel );
		ConfigDaemonOptionsWidget->EnableDebugXl2tpdstateCheckBox ->setChecked( GlobalConfig->enableDebugXl2tpdstate );
		ConfigDaemonOptionsWidget->EnableDebugXl2tpdpacketCheckBox->setChecked( GlobalConfig->enableDebugXl2tpdpacket );
		ConfigDaemonOptionsWidget->EnableDebugXl2tpdNetworkCheckBox->setChecked( GlobalConfig->enableDebugXl2tpdNetwork );

		ConfigDaemonOptionsWidget->DebugOpenl2tpCheckBox->setChecked( GlobalConfig->enableDebugOpenl2tp );

		
		ConfigDaemonOptionsWidget->PppdKernelLogLevelComboBox->setCurrentText(i18n("none"));
		if (GlobalConfig->PppdKernelLogLevel ==0)
			ConfigDaemonOptionsWidget->PppdKernelLogLevelComboBox->setCurrentText(i18n("none"));
		if (GlobalConfig->PppdKernelLogLevel ==1)
			ConfigDaemonOptionsWidget->PppdKernelLogLevelComboBox->setCurrentText(i18n("general"));
		if (GlobalConfig->PppdKernelLogLevel ==4)
			ConfigDaemonOptionsWidget->PppdKernelLogLevelComboBox->setCurrentText(i18n("general + packets"));

		ConfigDaemonOptionsWidget->DebugL2tpdCheckBox->setChecked( GlobalConfig->enableDebugL2tpd );
		for ( TQStringList::Iterator it = GlobalConfig->PlutoDebug.begin(); it != GlobalConfig->PlutoDebug.end(); ++it )
		{
			if (*it == "raw")
				ConfigDaemonOptionsWidget->IpsecRawDebugCheckBox->setChecked(true);
			if (*it == "crypt")
				ConfigDaemonOptionsWidget->IpsecCryptDebugCheckBox->setChecked(true);
			if (*it == "parsing")
				ConfigDaemonOptionsWidget->IpsecParsingDebugCheckBox->setChecked(true);
			if (*it == "emitting")
				ConfigDaemonOptionsWidget->IpsecEmittingDebugCheckBox->setChecked(true);
			if (*it == "control")
				ConfigDaemonOptionsWidget->IpsecControlDebugCheckBox->setChecked(true);
			if (*it == "klips")
				ConfigDaemonOptionsWidget->IpsecKlipsDebugCheckBox->setChecked(true);
			if (*it == "private")
				ConfigDaemonOptionsWidget->IpsecPrivateDebugCheckBox->setChecked(true);
			
    		}

		for ( TQStringList::Iterator it = GlobalConfig->KlipsDebug.begin(); it != GlobalConfig->KlipsDebug.end(); ++it )
		{
			if (*it == "tunnel-xmit")
				ConfigDaemonOptionsWidget->KlipsDebugTunnel_xmitCheckBox->setChecked(true);
			if (*it == "pfkey")
				ConfigDaemonOptionsWidget->KlipsDebugPfkeyCheckBox->setChecked(true);
			if (*it == "xform")
				ConfigDaemonOptionsWidget->KlipsDebugXformCheckBox->setChecked(true);
			if (*it == "eroute")
				ConfigDaemonOptionsWidget->KlipsDebugErouteCheckBox->setChecked(true);
			if (*it == "spi")
				ConfigDaemonOptionsWidget->KlipsDebugSpiCheckBox->setChecked(true);
			if (*it == "radij")
				ConfigDaemonOptionsWidget->KlipsDebugRadijCheckBox->setChecked(true);
			if (*it == "esp")
				ConfigDaemonOptionsWidget->KlipsDebugEspCheckBox->setChecked(true);
			if (*it == "ah")
				ConfigDaemonOptionsWidget->KlipsDebugAhCheckBox->setChecked(true);
			if (*it == "ipcomp")
				ConfigDaemonOptionsWidget->KlipsDebugIpcompCheckBox->setChecked(true);
			if (*it == "verbose")
				ConfigDaemonOptionsWidget->KlipsDebugVerboseCheckBox->setChecked(true);
    		}

		ProfileCiscoOptionsWidget->PeerTimeoutIntNumInput->setValue( GlobalConfig->tryConnectTimeout );
		ConnectOptionsWidget->SilentQuitcheckBox->setChecked( GlobalConfig->useSilentQuit );
		GeneralOptionsWidget->DontQuitOnCloseEventCheckBox->setChecked( GlobalConfig->dontQuitOnCloseEvent );
		GeneralOptionsWidget->HideOnStartupCheckBox->setChecked (GlobalConfig->hideMainWindow);
		GeneralOptionsWidget->useTDEwalletCheckBox->setChecked( GlobalConfig->useTDEwallet );
		ConfigDaemonOptionsWidget->ProgramsInPathcheckBox->setChecked( GlobalConfig->programsInPath );
		DebugOptionsWidget->KeepConnectionFilesCheckBox->setChecked( GlobalConfig->holdGeneratedScripts );
		LogOptionsWidget->InfoLogLabel->setPaletteBackgroundColor ( GlobalConfig->InfoLogColor );
		LogOptionsWidget->RemoteLogLabel->setPaletteBackgroundColor ( GlobalConfig->RemoteLogColor );
		LogOptionsWidget->ErrorLogLabel->setPaletteBackgroundColor ( GlobalConfig->ErrorLogColor );
		LogOptionsWidget->SuccessLogLabel->setPaletteBackgroundColor ( GlobalConfig->SuccessLogColor );
		LogOptionsWidget->DebugLogLabel->setPaletteBackgroundColor ( GlobalConfig->DebugLogColor );
		LogOptionsWidget->BackgroundLogLabel->setPaletteBackgroundColor ( GlobalConfig->DebugBackgroundcolor );
		LogOptionsWidget->UseColorizedLogOutputcheckBox->setChecked( GlobalConfig->useColorizedLogOutput );
		ConfigDaemonOptionsWidget->ShowInterfaceIPinTooltipCheckBox->setChecked( GlobalConfig->showInterfaceIPinTooltip );
		ConnectOptionsWidget->DoAutoConnectCheckBox->setChecked( GlobalConfig->doAutoConnectAtStartup );
		LogOptionsWidget->LogFontSizeSpinBox->setValue( GlobalConfig->LogViewerFontSize );
		
		/* keep english names! */
		ConfigDaemonOptionsWidget->KlipsDebugTunnel_xmitCheckBox->setText( TQString( "&tunnel-xmit" ) );
		ConfigDaemonOptionsWidget->KlipsDebugPfkeyCheckBox->setText( TQString( "pfkey" ) );
		ConfigDaemonOptionsWidget->KlipsDebugXformCheckBox->setText( TQString( "xform" ) );
		ConfigDaemonOptionsWidget->KlipsDebugErouteCheckBox->setText( TQString( "eroute" ) );
		ConfigDaemonOptionsWidget->KlipsDebugSpiCheckBox->setText( TQString( "spi" ) );
		ConfigDaemonOptionsWidget->KlipsDebugRadijCheckBox->setText( TQString( "radij" ) );
		ConfigDaemonOptionsWidget->KlipsDebugEspCheckBox->setText( TQString( "esp" ) );
		ConfigDaemonOptionsWidget->KlipsDebugAhCheckBox->setText( TQString( "ah" ) );
		ConfigDaemonOptionsWidget->KlipsDebugIpcompCheckBox->setText( TQString( "ipcomp" ) );
		ConfigDaemonOptionsWidget->KlipsDebugVerboseCheckBox->setText( TQString( "verbose" ) );
		
		ConfigDaemonOptionsWidget->IpsecEmittingDebugCheckBox->setText( TQString( "emitting" ) );
		ConfigDaemonOptionsWidget->IpsecCryptDebugCheckBox->setText( TQString( "cr&ypt" ) );
		ConfigDaemonOptionsWidget->IpsecRawDebugCheckBox->setText( TQString( "&raw" ) );
		ConfigDaemonOptionsWidget->IpsecKlipsDebugCheckBox->setText( TQString( "&klips" ) );
		ConfigDaemonOptionsWidget->IpsecParsingDebugCheckBox->setText( TQString( "&parsing" ) );
		ConfigDaemonOptionsWidget->IpsecPrivateDebugCheckBox->setText( TQString( "&private" ) );
		ConfigDaemonOptionsWidget->IpsecControlDebugCheckBox->setText( TQString( "&control" ) );

		bool profileInList = false;
		for ( uint i = 0; i < GlobalConfig->AccountList->count();i++ )
		{
			ConnectOptionsWidget->AutoConnectProfileComboBox->insertItem( GlobalConfig->AccountList->at( i ) ->getName() );
			if ( GlobalConfig->AccountList->at( i ) ->getName() == GlobalConfig->AutoConnectProfile )
			{
				profileInList = true;
			}
		}

		ProfileCertOptionsWidget->x509certComboBox->clear();

		if ( profileInList )
		{
			ConnectOptionsWidget->AutoConnectProfileComboBox->setCurrentText( GlobalConfig->AutoConnectProfile );
		}
		else
		{
			GlobalConfig->doAutoConnectAtStartup = false;
			ConnectOptionsWidget->DoAutoConnectCheckBox->setChecked( GlobalConfig->doAutoConnectAtStartup );
		}
	}
	KDialogBase::adjustSize();

	// TODO read types from list
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "Cisco (vpnc)" ), VpnAccountData::cisco );
	
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "IPSec (%1)" ).arg("racoon"), VpnAccountData::racoon );
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "IPSec (%1)" ).arg("Openswan/strongSwan"), VpnAccountData::freeswan );
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "PPTP" ), VpnAccountData::pptp );
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "OpenVPN" ), VpnAccountData::openvpn );
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "L2TP (%1)" ).arg("racoon"), VpnAccountData::l2tpd_racoon );
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "L2TP (%1)" ).arg("Openswan/strongSwan"), VpnAccountData::l2tpd_freeswan );
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "Cisco (proprietary)" ), VpnAccountData::ciscoorig );
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "Vtun" ), VpnAccountData::vtun );
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "SSH" ), VpnAccountData::ssh );
	//ConnectionTypeComboBox->insertItem( "-", 5 );


// 	modp768	1
// 	modp1024	2
// 	modp1536	5
// 	modp2048	14
// 	modp3072	15
// 	modp4096	16
// 	modp6144	17
// 	modp8192	18

	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp768" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp1024" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "ec2n155" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "ec2n185" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp1536" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp2048" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp3072" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp4096" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp6144" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp8192" );

// 	ProfileRacoonOptionsWidget->HashAlgoComboBox->insertItem("SHA1");
// 	ProfileRacoonOptionsWidget->HashAlgoComboBox->insertItem("MD5");

	/*
	none:		No ID
	address:		The type is the IP address. This is the default type if you do not specify an identifier to use
	user_fqdn:	The type is a USER_FTQDN (user fully-qualified domain name)
	fqdn:		The type is a FTQDN (fully-qualified domain name)
	keyid:		The type is a KEY_ID, read from the file
	keyid:		The type is a KEY_ID, specified in the quoted string
	asn1dn:		The type is an ASN.1 distinguished name. If empty, DN from the Subject field in the certificate will be used
	*/
	
	ProfileRacoonOptionsWidget->LocalIdTypeCombobox->insertItem("none");
	ProfileRacoonOptionsWidget->LocalIdTypeCombobox->insertItem("address");
	ProfileRacoonOptionsWidget->LocalIdTypeCombobox->insertItem("user_fqdn");
	ProfileRacoonOptionsWidget->LocalIdTypeCombobox->insertItem("fqdn");
	ProfileRacoonOptionsWidget->LocalIdTypeCombobox->insertItem("keyid (file)");
	ProfileRacoonOptionsWidget->LocalIdTypeCombobox->insertItem("keyid");
	ProfileRacoonOptionsWidget->LocalIdTypeCombobox->insertItem("asn1dn");
	
	ProfileRacoonOptionsWidget->RemoteIdTypeCombobox->insertItem("none");
	ProfileRacoonOptionsWidget->RemoteIdTypeCombobox->insertItem("address");
	ProfileRacoonOptionsWidget->RemoteIdTypeCombobox->insertItem("user_fqdn");
	ProfileRacoonOptionsWidget->RemoteIdTypeCombobox->insertItem("fqdn");	
	ProfileRacoonOptionsWidget->RemoteIdTypeCombobox->insertItem("keyid (file)");
	ProfileRacoonOptionsWidget->RemoteIdTypeCombobox->insertItem("keyid");
	ProfileRacoonOptionsWidget->RemoteIdTypeCombobox->insertItem("asn1dn");
	
	
	ProfileIpsecOptionsWidget->LocalIdTypeCombobox->insertItem(i18n("Certificate ID"));
	ProfileIpsecOptionsWidget->LocalIdTypeCombobox->insertItem("asn1dn");
	ProfileIpsecOptionsWidget->LocalIdTypeCombobox->insertItem("address");
	ProfileIpsecOptionsWidget->LocalIdTypeCombobox->insertItem("fqdn");
	ProfileIpsecOptionsWidget->LocalIdTypeCombobox->insertItem("keyid");
	ProfileIpsecOptionsWidget->LocalIdTypeCombobox->insertItem("user_fqdn");

	ProfileIpsecOptionsWidget->RemoteIdTypeCombobox->insertItem("asn1dn");
	ProfileIpsecOptionsWidget->RemoteIdTypeCombobox->insertItem("address");
	ProfileIpsecOptionsWidget->RemoteIdTypeCombobox->insertItem("fqdn");
	ProfileIpsecOptionsWidget->RemoteIdTypeCombobox->insertItem("keyid");
	ProfileIpsecOptionsWidget->RemoteIdTypeCombobox->insertItem("user_fqdn");
	ProfileIpsecOptionsWidget->RemoteIdTypeCombobox->insertItem("none");



	slotStatusMsg ( i18n( "Collecting kernel crypto..."), ID_FLASH_MSG );
	Utils::IpsecAlgos KernelCrypto = Utils ( GlobalConfig ).getKernelCrypto();

	// man racoon.conf
	ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem("des" );
	ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem("3des" );
	ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem("blowfish" );
	ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem("cast128" );
	ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem("aes" );
	ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem("camellia" );

	// man racoon.conf
	ProfileRacoonOptionsWidget->HashAlgoComboBox->insertItem( "md5" );
	ProfileRacoonOptionsWidget->HashAlgoComboBox->insertItem( "sha1" );
	ProfileRacoonOptionsWidget->HashAlgoComboBox->insertItem( "sha256" );
	ProfileRacoonOptionsWidget->HashAlgoComboBox->insertItem( "sha384" );
	ProfileRacoonOptionsWidget->HashAlgoComboBox->insertItem( "sha512" );




//  	// phase 2 encr algos from kernel
// 	for ( TQStringList::Iterator it = KernelCrypto.IpsecEspEncryptionAlgorithms.begin(); it != KernelCrypto.IpsecEspEncryptionAlgorithms.end(); ++it )
// 	{
// 		ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem ( *it );
// 	}
// 
// 	// phase 2 auth algos from kernel
// 	for ( TQStringList::Iterator it = KernelCrypto.IpsecEspAuthenticationAlgorithms.begin(); it != KernelCrypto.IpsecEspAuthenticationAlgorithms.end(); ++it )
// 	{
// 		ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem ( *it );
// 	}

	// vpn mit linux book
	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("des" );
	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("3des" );
	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("des_iv64" );
	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("des_iv32" );
	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("rc5" );
	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("rc4" );
	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("idea" );
	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("3idea" );
	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("cast128" );
	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("blowfish" );
	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("null_enc" );
	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("twofish" );
	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("rijndael" );
	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("aes" );

	ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem( "des" );
	ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem( "3des" );
	ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem( "des_iv64" );
	ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem( "des_iv32" );
	ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_md5" );
	ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_sha1" );
	ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_sha256" );
	ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_sha384" );
	ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_sha512" );
	ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem( "non_auth" );
	
	ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->insertItem( "Basic" );
	ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->insertItem( "NTLM" );


	slotStatusMsg ( i18n( "Collecting OpenVPN capabilities..."), ID_FLASH_MSG );
	TQStringList ciphers = Utils( GlobalConfig ).getOpenvpnCiphers();
	TQStringList digests = Utils( GlobalConfig ).getOpenvpnDigests();

	for ( TQStringList::Iterator it = ciphers.begin(); it != ciphers.end(); ++it )
	{
		ProfileOpenvpnOptionsWidget->UserdefiniedCipherComboBox->insertItem( *it );
	}

	for ( TQStringList::Iterator it = digests.begin(); it != digests.end(); ++it )
	{
		ProfileOpenvpnOptionsWidget->UserdefiniedDigestComboBox->insertItem( *it );
	}
	slotStatusMsg ( i18n("Ready."), ID_STATUS_MSG );

	ProfilePptpOptionsWidget->AuthMethodComboBox->insertItem("chap");
	ProfilePptpOptionsWidget->AuthMethodComboBox->insertItem("pap");
	ProfilePptpOptionsWidget->AuthMethodComboBox->insertItem("mschap");
	ProfilePptpOptionsWidget->AuthMethodComboBox->insertItem("mschap-v2");

	ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->insertItem("TUN");
	ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->insertItem("TAP");

	ProfileCiscoOptionsWidget->CiscoNatModeComboBox->insertItem("natt");
	ProfileCiscoOptionsWidget->CiscoNatModeComboBox->insertItem("force-natt");
	ProfileCiscoOptionsWidget->CiscoNatModeComboBox->insertItem("cisco-udp");
	ProfileCiscoOptionsWidget->CiscoNatModeComboBox->insertItem("none");
	connect (ProfileCiscoOptionsWidget->CiscoNatModeComboBox, TQT_SIGNAL(textChanged ( const TQString &)), this, TQT_SLOT(natModeToggled( const TQString &)));


	profileAddedOrDeleted = false;
	NewProfileName = "";
	bool vpnclient_profile_in_list=false;

	// profile data
	VpnAccountData * it;
	if ( !GlobalConfig->AccountList->isEmpty() )
	{

		for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
		{
			if ( it != 0 )
			{
				if ( GlobalConfig->KvpncDebugLevel > 3 )
					GlobalConfig->appendLogEntry( "item found: " + it->getName(), KVpncConfig::debug );

				ProfileGeneralSelector->insertItem( it->getName() );
				ProfileNetworkRouteSelector->insertItem( it->getName() );
				ProfileNetworkGeneralSelector->insertItem( it->getName() );
				ProfileNetworkNatSelector->insertItem( it->getName() );
				ProfileNetworkHttpProxySelector->insertItem( it->getName() );
				ProfileNetworkVirtualIpSelector->insertItem( it->getName() );
				ProfileCertSelector->insertItem( it->getName() );
				ProfileSmartcardSelector->insertItem( it->getName() );
				ProfilePskSelector->insertItem( it->getName() );
				ProfileUserSelector->insertItem( it->getName() );
				ProfileOpenvpnSelector->insertItem( it->getName() );
				ProfilePptpSelector->insertItem( it->getName() );
				ProfileVtunSelector->insertItem( it->getName() );
				ProfileSshSelector->insertItem( it->getName() );
				ProfileRacoonSelector->insertItem( it->getName() );
				ProfileIpsecSelector->insertItem( it->getName() );
				ProfileCiscoSelector->insertItem( it->getName() );
				ProfileCmdExecBeforeConnectSelector->insertItem( it->getName() );
				ProfileCmdExecBeforeDisconnectSelector->insertItem( it->getName() );
				ProfileCmdExecAfterConnectSelector->insertItem( it->getName() );
				ProfileCmdExecAfterDisconnectSelector->insertItem( it->getName() );

				if (vpnclient_profile_in_list==false)
					if (it->getConnectionType() == VpnAccountData::ciscoorig)
						vpnclient_profile_in_list=true;
			}
		}

		if ( Utils ( GlobalConfig ).getToolInfo ( "vpnclient" )->found == true && vpnclient_profile_in_list==true )
		{
			slotStatusMsg ( i18n("Collecting cisco certs from Cisco certificate store..."), ID_STATUS_MSG );
			CiscoCerts.clear();
			if (GlobalConfig->KvpncDebugLevel > 2)
				GlobalConfig->appendLogEntry(i18n("Looking for certs in Cisco certificate store..."),GlobalConfig->debug);
			CiscoCerts  = Utils(GlobalConfig).getCertsFromCiscoCertStore();

			slotStatusMsg ( i18n("Collecting cisco CA certs from Cisco certificate store..."), ID_STATUS_MSG );
			CiscoCaCerts.clear();
			if (GlobalConfig->KvpncDebugLevel > 2)
				GlobalConfig->appendLogEntry(i18n("Looking for CA certs in Cisco certificate store..."),GlobalConfig->debug);
			CiscoCaCerts  = Utils(GlobalConfig).getCertsFromCiscoCertStore("ca");

			if (GlobalConfig->KvpncDebugLevel > 2)
				GlobalConfig->appendLogEntry(i18n("done."),GlobalConfig->debug);

			slotStatusMsg ( i18n("Ready."), ID_STATUS_MSG );
		}


		if ( GlobalConfig->currentProfile != 0 )
		{
			// set only if in list of current ciphers
			//		if ( ciphers.contains(GlobalConfig->currentProfile->getUserdefiniedCipher())) {
			if ( !GlobalConfig->currentProfile->getUserdefiniedCipher().isEmpty() )
				ProfileOpenvpnOptionsWidget->UserdefiniedCipherComboBox->setCurrentText( GlobalConfig->currentProfile->getUserdefiniedCipher() );
			else
				ProfileOpenvpnOptionsWidget->UserdefiniedCipherComboBox->setCurrentText( ciphers.first() );
			ProfileOpenvpnOptionsWidget->UseUserdefiniedCipherCheckBox->setChecked( GlobalConfig->currentProfile->getUseUserdefiniedCipher() );
			// 		}
			// 		else
			// 			ProfileOpenvpnOptionsWidget->UseUserdefinedPortCheckBox->setChecked(false);


			ProfileOpenvpnOptionsWidget->UseTlsAuthCheckBox->setChecked( GlobalConfig->currentProfile->getUseTlsAuth() );
			ProfileOpenvpnOptionsWidget->TlsAuthURLRequester->setURL( GlobalConfig->currentProfile->getTlsAuthFile() );

			ProfileOpenvpnOptionsWidget->UseTlsRemoteHostCheckBox->setChecked( GlobalConfig->currentProfile->getUseTlsRemoteHost() );
			ProfileOpenvpnOptionsWidget->TlsRemoteHostLineEdit->setText( GlobalConfig->currentProfile->getTlsRemoteHost() );
			ProfileOpenvpnOptionsWidget->AuthenticationDirectionComboBox->insertItem(i18n("None"));
			ProfileOpenvpnOptionsWidget->AuthenticationDirectionComboBox->insertItem(i18n("0"));
			ProfileOpenvpnOptionsWidget->AuthenticationDirectionComboBox->insertItem(i18n("1"));

			ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyCheckBox->setChecked( GlobalConfig->currentProfile->getUseHttpProxy() );
			ProfileNetworkHttpProxyOptionsWidget->HttpProxyLineEdit->setText( GlobalConfig->currentProfile->getHttpProxy() );
			ProfileNetworkHttpProxyOptionsWidget->HttpProxyTimeoutIntSpinBox->setValue( GlobalConfig->currentProfile->getHttpProxyTimeout() );
			ProfileNetworkHttpProxyOptionsWidget->HttpProxyPortIntNumInput->setValue( GlobalConfig->currentProfile->getHttpProxyPort() );
			ProfileNetworkHttpProxyOptionsWidget->useHttpProxyToggeled(GlobalConfig->currentProfile->getUseHttpProxy());

			if ( GlobalConfig->currentProfile->getHttpProxyAuthType() == "basic" )
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->setCurrentText( "Basic" );
			else if ( GlobalConfig->currentProfile->getHttpProxyAuthType() == "ntlm" )
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->setCurrentText( "NTLM" );
			else
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->setCurrentText( "Basic" );

			ProfileNetworkHttpProxyOptionsWidget->HttpProxyUserLineEdit->setText( GlobalConfig->currentProfile->getHttpProxyUser() );
			ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthPasswordEdit->setText( GlobalConfig->currentProfile->getHttpProxyPass() );

			ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyAuthCheckBox->setChecked( GlobalConfig->currentProfile->getUseHttpProxyAuth() );

			ProfileGeneralSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileNetworkRouteSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileNetworkGeneralSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileNetworkNatSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileNetworkHttpProxySelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileNetworkVirtualIpSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCertSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileSmartcardSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfilePskSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileUserSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileOpenvpnSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfilePptpSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileVtunSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileSshSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileRacoonSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileIpsecSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCiscoSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCmdExecBeforeConnectSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCmdExecBeforeDisconnectSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCmdExecAfterConnectSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCmdExecAfterDisconnectSelector->setCurrentText( GlobalConfig->currentProfile->getName() );

			ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setChecked( GlobalConfig->currentProfile->getUseMtu() );
			ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setValue( GlobalConfig->currentProfile->getMtu() );
			ProfileNetworkGeneralOptionsWidget->MruCheckbox->setChecked( GlobalConfig->currentProfile->getUseMru() );
			ProfileNetworkGeneralOptionsWidget->MruSpinbox->setValue( GlobalConfig->currentProfile->getMru() );

			if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::cisco ||
			     GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::pptp ||
			     GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::freeswan ||
			     GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan ||
					GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn )
			{
				ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setEnabled( true );
				ProfileNetworkGeneralOptionsWidget->MruCheckbox->setEnabled( true );

				if ( GlobalConfig->currentProfile->getUseMtu() )
					ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled( true );
				else
					ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled( false );

				if ( GlobalConfig->currentProfile->getUseMru() )
					ProfileNetworkGeneralOptionsWidget->MruSpinbox->setEnabled( true );
				else
					ProfileNetworkGeneralOptionsWidget->MruSpinbox->setEnabled( false );
			}
			else
			{
				ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setEnabled( false );
				ProfileNetworkGeneralOptionsWidget->MruCheckbox->setEnabled( false );
			}

		}
		else
		{
			// 			ProfileGeneralOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileNetworkRouteOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileNetworkNatOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileCertPskOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileUserOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileOpenvpnOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfilePptpOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileRacoonOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileCiscoOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->setCurrentText( "" );

			ProfileGeneralOptionsWidget->setEnabled( false );
			ProfileNetworkRouteOptionsWidget->setEnabled( false );
			ProfileNetworkNatOptionsWidget->setEnabled( false );
			ProfileNetworkVirtualIpOptionsWidget->setEnabled( false );
			ProfileCertOptionsWidget->setEnabled( false );
			ProfilePskOptionsWidget->setEnabled( false );
			ProfileUserOptionsWidget->setEnabled( false );
			ProfileOpenvpnOptionsWidget->setEnabled( false );
			ProfilePptpOptionsWidget->setEnabled( false );
			ProfileRacoonOptionsWidget->setEnabled( false );
			ProfileIpsecOptionsWidget->setEnabled( false );
			ProfileCiscoOptionsWidget->setEnabled( false );
			ProfileCmdExecBeforeConnectOptionsWidget->setEnabled( false );
			ProfileCmdExecBeforeDisconnectOptionsWidget->setEnabled( false );
			ProfileCmdExecAfterConnectOptionsWidget->setEnabled( false );
			ProfileCmdExecAfterDisconnectOptionsWidget->setEnabled( false );
			ProfileGeneralOptionsWidget->NewSessionPushButton->setEnabled( true );

		}
	}
	else
	{
		ProfileGeneralOptionsWidget->RenameSessionPushButton->setEnabled( false );
		ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled( false );
		ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled( false );
	}


	NetworkInterface iface( GlobalConfig, GlobalConfig->appPointer );
	TQStringList list = iface.getAllNetworkInterfaces();
	ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->insertItem( "default" );

	// 	// pppd settings
	ProfilePptpOptionsWidget->DnsServerLineedit->setEnabled( false );

	// disabled for now
	ProfileCertOptionsWidget->AllowEmptyPrivateKeyPasswordCheckBox->hide();

	ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setEnabled( true );
// 	ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled( true );
// 	ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled( true );
// 	ProfileNetworkVirtualIpOptionsWidget->LabelRemoteVirtualIp->setEnabled( true );
// 	ProfileNetworkVirtualIpOptionsWidget->LabelLocalVirtualIp->setEnabled( true );

	for ( TQStringList::Iterator it = list.begin(); it != list.end(); ++it )
	{
		ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->insertItem( TQString( *it ) );
	}
	ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled( true );
	ProfileNetworkGeneralOptionsWidget->LabelNetworkDevice->setEnabled( true );

	if ( GlobalConfig->currentProfile != 0 )
	{
		profileChanged( GlobalConfig->currentProfile->getName() );
	}

	configChanged=false;
	canAccept = true;
	KDialogBase::adjustSize();
	GlobalConfig->appPointer->restoreOverrideCursor();
}

void PreferencesDialog::setupGui()
{

	setShowIconsInTreeList( true );

	TQStringList path;
	path.clear();
	path << i18n( "KVpnc" );
	setFolderIcon ( path, SmallIcon( "application", TDEIcon::SizeSmall ) );

	path.clear();

	TQVBoxLayout *lo;

	if ( !showOnlyProfiles )
	{
		/* called as preferences dialog */

		// General page
		path << i18n( "Application" ) << i18n( "General" );
		GeneralFrame = addPage( path, i18n( "General" ), BarIcon( "kvpnc", TDEIcon::SizeSmall ) );
		lo = new TQVBoxLayout( GeneralFrame, 0, KDialog::spacingHint() );
		GeneralOptionsWidget = new ConfigGeneralOptions( GeneralFrame );
		lo->addWidget( GeneralOptionsWidget );
		connect(GeneralOptionsWidget->useTDEwalletCheckBox, TQT_SIGNAL(toggled(bool)),this, TQT_SLOT(useTDEwalletToggled(bool)));

		// 		const TQObjectList *GeneralOptionsWidgetList = GeneralOptionsWidget->queryList( TQCHECKBOX_OBJECT_NAME_STRING );
		// 		TQObjectListIt it( *GeneralOptionsWidgetList );
		//
		// 		for ( TQObject *child = it.current(); it; ++it)
		// 		{
		// // 			std::cout << "name: " << child->name() << std::endl;
		// 			connect(child, TQT_SIGNAL(stateChanged(int)), this, TQT_SLOT(checkboxStateChanged(int)));
		// 		}

		// Debug
		path.clear();
		path << i18n( "Application" ) << i18n( "Debug" );
		DebugFrame = addPage( path, i18n( "Debug" ), BarIcon( "bug", TDEIcon::SizeSmall ) );
		lo = new TQVBoxLayout( DebugFrame );
		lo->setSpacing( KDialog::spacingHint() );
		DebugOptionsWidget = new ConfigDebugOptions( DebugFrame, "Debug" );
		lo->addWidget( DebugOptionsWidget );

		path.clear();
		path << i18n( "Application" ) << i18n( "Connect" );
		ConfigConnectOptionsFrame = addPage( path, i18n( "Connect" ), BarIcon( "connecting", TDEIcon::SizeSmall ) );
		lo = new TQVBoxLayout( ConfigConnectOptionsFrame );
		lo->setSpacing( KDialog::spacingHint() );
		ConnectOptionsWidget = new ConfigConnectOptions( ConfigConnectOptionsFrame );
		lo->addWidget( ConnectOptionsWidget );

		path.clear();
		path << i18n( "Application" ) << i18n( "Log" );
		LogFrame = addPage( path, i18n( "Log" ), BarIcon( "text_center", TDEIcon::SizeSmall ) );
		lo = new TQVBoxLayout( LogFrame );
		lo->setSpacing( KDialog::spacingHint() );
		LogOptionsWidget = new ConfigLogOptions( LogFrame );
		lo->addWidget( LogOptionsWidget );

		path << i18n( "Programs" );
		setFolderIcon ( path, SmallIcon( "kvpnc", TDEIcon::SizeSmall ) );

		path.clear();
		path << i18n( "Programs" ) << i18n( "Daemons" );
		DaemonOptionsFrame = addVBoxPage( path, i18n( "Daemons" ), BarIcon( "fork", TDEIcon::SizeSmall ) );
// 		DaemonOptionsFrame->resize(DaemonOptionsFrame->sizeHint());
// 		lo = new TQVBoxLayout( DaemonOptionsFrame );
		DaemonScrollView = new TQScrollView(DaemonOptionsFrame, "daemonscrollview");
		lo = new TQVBoxLayout( DaemonScrollView );
		lo->setSpacing( KDialog::spacingHint() );
		lo->addWidget(DaemonScrollView);
		ConfigDaemonOptionsWidget = new ConfigDaemonOptions( DaemonScrollView->viewport() );
		DaemonScrollView->addChild(ConfigDaemonOptionsWidget);
// 		ConfigDaemonOptionsWidget->setFixedSize(520,ConfigDaemonOptionsWidget->height());
// 		ConfigDaemonOptionsWidget->setFixedSize(DaemonScrollView->contentsWidth ()-DaemonScrollView->verticalScrollBar()->height()-95,ConfigDaemonOptionsWidget->height());

		
// 		DaemonScrollView->adjustSize();
		TQSize deamonsize = ConfigDaemonOptionsWidget->sizeHint();
		ConfigDaemonOptionsWidget->resize(TQSize(deamonsize.width()-4,deamonsize.height()));
		ConfigDaemonOptionsWidget->setFixedSize(TQSize(deamonsize.width()-4,deamonsize.height()));
// 		DaemonScrollView->resize(sv->sizeHint());
// 		lo->addWidget( DaemonScrollView );
// 		DaemonFrame->adjustSize();
		

		connect(ConfigDaemonOptionsWidget->OpenvpnPathInput, TQT_SIGNAL( urlSelected( const TQString& ) ), this, TQT_SLOT( OpenvpnPathChanged( const TQString& ) ) );
		connect(ConfigDaemonOptionsWidget->FreeswanPathInput, TQT_SIGNAL( urlSelected( const TQString& ) ), this, TQT_SLOT( FreeswanPathChanged( const TQString& ) ) );
		connect(ConfigDaemonOptionsWidget->PppdPathInput, TQT_SIGNAL( urlSelected( const TQString& ) ), this, TQT_SLOT( PppdPathChanged( const TQString& ) ) );
		connect(ConfigDaemonOptionsWidget->PptpPathInput, TQT_SIGNAL( urlSelected( const TQString& ) ), this, TQT_SLOT( PptpPathChanged( const TQString& ) ) );
		connect(ConfigDaemonOptionsWidget->RacoonPathInput, TQT_SIGNAL( urlSelected( const TQString& ) ), this, TQT_SLOT( RacoonPathChanged( const TQString& ) ) );
		connect(ConfigDaemonOptionsWidget->VpncPathInput, TQT_SIGNAL( urlSelected( const TQString& ) ), this, TQT_SLOT( VpncPathChanged( const TQString& ) ) );
		connect(ConfigDaemonOptionsWidget->L2tpdPathInput, TQT_SIGNAL( urlSelected( const TQString& ) ), this, TQT_SLOT( L2tpdPathChanged( const TQString& ) ) );
		connect(ConfigDaemonOptionsWidget->Xl2tpdPathInput, TQT_SIGNAL( urlSelected( const TQString& ) ), this, TQT_SLOT( Xl2tpdPathChanged( const TQString& ) ) );
		connect(ConfigDaemonOptionsWidget->VtundPathInput, TQT_SIGNAL( urlSelected( const TQString& ) ), this, TQT_SLOT( VtundPathChanged( const TQString& ) ) );
		connect(ConfigDaemonOptionsWidget->SshPathInput, TQT_SIGNAL( urlSelected( const TQString& ) ), this, TQT_SLOT( SshPathChanged( const TQString& ) ) );

		path.clear();
		path << i18n( "Programs" ) << i18n( "Helper Programs" );
		HelperProgramFrame = addPage( path, i18n( "Helper Programs" ), BarIcon( "tool", TDEIcon::SizeSmall ) );
		lo = new TQVBoxLayout( HelperProgramFrame );
		lo->setSpacing( KDialog::spacingHint() );
		
		HelperProgramOptionsWidget = new ConfigHelperProgramOptions( HelperProgramFrame );
		lo->addWidget( HelperProgramFrame );

		setTreeListAutoResize( false );
	}

	// Profile page
	path.clear();
	path << i18n( "Profile" );
	setFolderIcon ( path, SmallIcon( "view_icon", TDEIcon::SizeSmall ) );

	path.clear();
	path << i18n( "Profile" ) << i18n( "General" );
	ProfileGeneralOptionsFrame = addPage( path, i18n( "General" ), BarIcon( "application", TDEIcon::SizeSmall ) );
	lo = new TQVBoxLayout( ProfileGeneralOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	TQWidget *ProfileGeneralSelectorWidget = new TQWidget( ProfileGeneralOptionsFrame );
	TQHBoxLayout *ProfileGeneralSelectorLayout = new TQHBoxLayout( ProfileGeneralSelectorWidget );
	TQLabel *ProfileGeneralSelectorLabel = new TQLabel( ProfileGeneralSelectorWidget );
	ProfileGeneralSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileGeneralSelector = new TQComboBox( ProfileGeneralSelectorWidget );
	ProfileGeneralSelectorLayout->addWidget( ProfileGeneralSelectorLabel );
	ProfileGeneralSelectorLayout->addWidget( ProfileGeneralSelector );

	ProfileGeneralOptionsWidget = new ProfileGeneralOptions( ProfileGeneralOptionsFrame, GlobalConfig );

	lo->addWidget( ProfileGeneralSelectorWidget );
	lo->addWidget( ProfileGeneralOptionsWidget );
	ProfileGeneralSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Authenticate" ) << i18n( "User data" );
	ProfileUserOptionsFrame = addPage( path, i18n( "User Data" ), BarIcon( "user", TDEIcon::SizeSmall ) );
	lo = new TQVBoxLayout( ProfileUserOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	TQWidget *ProfileUserSelectorWidget = new TQWidget( ProfileUserOptionsFrame );
	TQHBoxLayout *ProfileUserSelectorLayout = new TQHBoxLayout( ProfileUserSelectorWidget );
	TQLabel *ProfileUserSelectorLabel = new TQLabel( ProfileUserSelectorWidget );
	ProfileUserSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileUserSelector = new TQComboBox( ProfileUserSelectorWidget );
	ProfileUserSelectorLayout->addWidget( ProfileUserSelectorLabel );
	ProfileUserSelectorLayout->addWidget( ProfileUserSelector );
	

	ProfileUserOptionsWidget = new ProfileUserOptions( ProfileUserOptionsFrame );
	lo->addWidget( ProfileUserSelectorWidget );
	lo->addWidget( ProfileUserOptionsWidget );
	ProfileUserSelector->setEnabled( true );
	connect(ProfileUserOptionsWidget->NtDomainNameCheckbox, TQT_SIGNAL(toggled(bool)), ProfileUserOptionsWidget, TQT_SLOT( domainNameToggled(bool) ));

	path.clear();
	path << i18n( "Profile" ) << i18n( "Authenticate" ) << i18n( "Certificate" );
	ProfileCertOptionsFrame = addVBoxPage( path, i18n( "Certificate" ), BarIcon( "certimport", TDEIcon::SizeSmall ) );
	lo = new TQVBoxLayout( ProfileCertOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );
	TQWidget *ProfileCertSelectorWidget = new TQWidget( ProfileCertOptionsFrame );
	TQHBoxLayout *ProfileCertSelectorLayout = new TQHBoxLayout( ProfileCertSelectorWidget );
	TQLabel *ProfileCertSelectorLabel = new TQLabel( ProfileCertSelectorWidget );
	ProfileCertSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileCertSelector = new TQComboBox( ProfileCertSelectorWidget );
	ProfileCertSelectorLayout->addWidget( ProfileCertSelectorLabel );
	ProfileCertSelectorLayout->addWidget( ProfileCertSelector );

	ProfileCertOptionsWidget = new ProfileCertOptions( ProfileCertOptionsFrame);
	lo->addWidget( ProfileCertSelectorWidget );
	lo->addWidget( ProfileCertOptionsWidget );
	ProfileCertSelector->setEnabled( true );
	connect(ProfileCertOptionsWidget->ImportCertificatePushButton, TQT_SIGNAL(clicked()), this, TQT_SLOT(importCertificate()));
	connect(ProfileCertOptionsWidget->UseCiscoCertStoreCheckBox, TQT_SIGNAL(toggled(bool)), this, TQT_SLOT(useCiscoCertStoreToggled(bool)));

	path.clear();
	path << i18n( "Profile" ) << i18n( "Authenticate" ) << i18n( "Smartcard" );
	ProfileSmartcardOptionsFrame = addPage( path, i18n( "Smartcard" ), BarIcon( "smartcard", TDEIcon::SizeSmall ) );
	lo = new TQVBoxLayout( ProfileSmartcardOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	TQWidget *ProfileSmartcardSelectorWidget = new TQWidget( ProfileSmartcardOptionsFrame );
	TQHBoxLayout *ProfileSmartcardSelectorLayout = new TQHBoxLayout( ProfileSmartcardSelectorWidget );
	TQLabel *ProfileSmartcardSelectorLabel = new TQLabel( ProfileSmartcardSelectorWidget );
	ProfileSmartcardSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileSmartcardSelector = new TQComboBox( ProfileSmartcardSelectorWidget );
	ProfileSmartcardSelectorLayout->addWidget( ProfileSmartcardSelectorLabel );
	ProfileSmartcardSelectorLayout->addWidget( ProfileSmartcardSelector );

	ProfileSmartcardOptionsWidget = new ProfileSmartcardOptions( ProfileSmartcardOptionsFrame );
	lo->addWidget( ProfileSmartcardSelectorWidget );
	lo->addWidget( ProfileSmartcardOptionsWidget );
	ProfileSmartcardSelector->setEnabled( true );
	connect(ProfileSmartcardOptionsWidget->DetectPkcs11SlotsPushButton, TQT_SIGNAL(clicked()), this, TQT_SLOT(detectPkcs11Slots()));
	connect(ProfileSmartcardOptionsWidget->DetectPkcs11IdPushButton, TQT_SIGNAL(clicked()), this, TQT_SLOT(detectPkcs11Ids()));

	path.clear();
	path << i18n( "Profile" ) << i18n( "Authenticate" ) << i18n( "PSK" );
	ProfilePskOptionsFrame = addPage( path, i18n( "PSK" ), BarIcon( "password", TDEIcon::SizeSmall ) );
	lo = new TQVBoxLayout( ProfilePskOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	TQWidget *ProfilePskSelectorWidget = new TQWidget( ProfilePskOptionsFrame );
	TQHBoxLayout *ProfilePskSelectorLayout = new TQHBoxLayout( ProfilePskSelectorWidget );
	TQLabel *ProfilePskSelectorLabel = new TQLabel( ProfilePskSelectorWidget );
	ProfilePskSelectorLabel->setText( i18n( "Profile:" ) );
	ProfilePskSelector = new TQComboBox( ProfilePskSelectorWidget );
	ProfilePskSelectorLayout->addWidget( ProfilePskSelectorLabel );
	ProfilePskSelectorLayout->addWidget( ProfilePskSelector );

	ProfilePskOptionsWidget = new ProfilePskOptions( ProfilePskOptionsFrame );
	lo->addWidget( ProfilePskSelectorWidget );
	lo->addWidget( ProfilePskOptionsWidget );
	ProfilePskSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Network" ) << i18n( "General" );
	ProfileNetworkGeneralOptionsFrame = addPage( path, i18n( "General" ), BarIcon( "network", TDEIcon::SizeSmall ) );
	lo = new TQVBoxLayout( ProfileNetworkGeneralOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	TQWidget *ProfileNetworkGeneralSelectorWidget = new TQWidget( ProfileNetworkGeneralOptionsFrame );
	TQHBoxLayout *ProfileNetworkGeneralSelectorLayout = new TQHBoxLayout( ProfileNetworkGeneralSelectorWidget );
	TQLabel *ProfileNetworkGeneralSelectorLabel = new TQLabel( ProfileNetworkGeneralSelectorWidget );
	ProfileNetworkGeneralSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileNetworkGeneralSelector = new TQComboBox( ProfileNetworkGeneralSelectorWidget );
	ProfileNetworkGeneralSelectorLayout->addWidget( ProfileNetworkGeneralSelectorLabel );
	ProfileNetworkGeneralSelectorLayout->addWidget( ProfileNetworkGeneralSelector );

	ProfileNetworkGeneralOptionsWidget = new ProfileNetworkGeneralOptions( ProfileNetworkGeneralOptionsFrame );

	lo->addWidget( ProfileNetworkGeneralSelectorWidget );
	lo->addWidget( ProfileNetworkGeneralOptionsWidget );
	ProfileNetworkGeneralSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Network" ) << i18n( "Routes" );
	ProfileNetworkRouteOptionsFrame = addPage( path, i18n( "Routes" ), BarIcon( "route", TDEIcon::SizeSmall ) );
	lo = new TQVBoxLayout( ProfileNetworkRouteOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	TQWidget *ProfileNetworkRouteSelectorWidget = new TQWidget( ProfileNetworkRouteOptionsFrame );
	TQHBoxLayout *ProfileNetworkRouteSelectorLayout = new TQHBoxLayout( ProfileNetworkRouteSelectorWidget );
	TQLabel *ProfileNetworkRouteSelectorLabel = new TQLabel( ProfileNetworkRouteSelectorWidget );
	ProfileNetworkRouteSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileNetworkRouteSelector = new TQComboBox( ProfileNetworkRouteSelectorWidget );
	ProfileNetworkRouteSelectorLayout->addWidget( ProfileNetworkRouteSelectorLabel );
	ProfileNetworkRouteSelectorLayout->addWidget( ProfileNetworkRouteSelector );
	
	ProfileNetworkRouteOptionsWidget = new ProfileNetworkRouteOptions( ProfileNetworkRouteOptionsFrame );
	
	lo->addWidget( ProfileNetworkRouteSelectorWidget );
	lo->addWidget( ProfileNetworkRouteOptionsWidget );
	ProfileNetworkRouteSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Network" ) << i18n( "NAT" );
	ProfileNetworkNatOptionsFrame = addPage( path, i18n( "NAT" ), BarIcon( "application", TDEIcon::SizeSmall ) );
	lo = new TQVBoxLayout( ProfileNetworkNatOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	TQWidget *ProfileNetworkNatSelectorWidget = new TQWidget( ProfileNetworkNatOptionsFrame );
	TQHBoxLayout *ProfileNetworkNatSelectorLayout = new TQHBoxLayout( ProfileNetworkNatSelectorWidget );
	TQLabel *ProfileNetworkNatSelectorLabel = new TQLabel( ProfileNetworkNatSelectorWidget );
	ProfileNetworkNatSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileNetworkNatSelector = new TQComboBox( ProfileNetworkNatSelectorWidget );
	ProfileNetworkNatSelectorLayout->addWidget( ProfileNetworkNatSelectorLabel );
	ProfileNetworkNatSelectorLayout->addWidget( ProfileNetworkNatSelector );

	ProfileNetworkNatOptionsWidget = new ProfileNetworkNatOptions( ProfileNetworkNatOptionsFrame );

	lo->addWidget( ProfileNetworkNatSelectorWidget );
	lo->addWidget( ProfileNetworkNatOptionsWidget );
	ProfileNetworkNatSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Network" ) << i18n( "HTTP proxy" );
	ProfileNetworkHttpProxyOptionsFrame = addPage( path, i18n( "HTTP proxy" ), BarIcon( "application", TDEIcon::SizeSmall ) );
	lo = new TQVBoxLayout( ProfileNetworkHttpProxyOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	TQWidget *ProfileNetworkHttpProxySelectorWidget = new TQWidget( ProfileNetworkHttpProxyOptionsFrame );
	TQHBoxLayout *ProfileNetworkHttpProxySelectorLayout = new TQHBoxLayout( ProfileNetworkHttpProxySelectorWidget );
	TQLabel *ProfileNetworkHttpProxySelectorLabel = new TQLabel( ProfileNetworkHttpProxySelectorWidget );
	ProfileNetworkHttpProxySelectorLabel->setText( i18n( "Profile:" ) );
	ProfileNetworkHttpProxySelector = new TQComboBox( ProfileNetworkHttpProxySelectorWidget );
	ProfileNetworkHttpProxySelectorLayout->addWidget( ProfileNetworkHttpProxySelectorLabel );
	ProfileNetworkHttpProxySelectorLayout->addWidget( ProfileNetworkHttpProxySelector );

	ProfileNetworkHttpProxyOptionsWidget = new ProfileNetworkHttpProxyOptions( ProfileNetworkHttpProxyOptionsFrame );

	lo->addWidget( ProfileNetworkHttpProxySelectorWidget );
	lo->addWidget( ProfileNetworkHttpProxyOptionsWidget );
	ProfileNetworkHttpProxySelector->setEnabled( true );


	path.clear();
	path << i18n( "Profile" ) << i18n( "Network" ) << i18n( "Virtual IP" );
	ProfileNetworkVirtualIpOptionsFrame = addPage( path, i18n( "Virtual IP" ), BarIcon( "application", TDEIcon::SizeSmall ) );
	lo = new TQVBoxLayout( ProfileNetworkVirtualIpOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	TQWidget *ProfileNetworkVirtualIpSelectorWidget = new TQWidget( ProfileNetworkVirtualIpOptionsFrame );
	TQHBoxLayout *ProfileNetworkVirtualIpSelectorLayout = new TQHBoxLayout( ProfileNetworkVirtualIpSelectorWidget );
	TQLabel *ProfileNetworkVirtualIpSelectorLabel = new TQLabel( ProfileNetworkVirtualIpSelectorWidget );
	ProfileNetworkVirtualIpSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileNetworkVirtualIpSelector = new TQComboBox( ProfileNetworkVirtualIpSelectorWidget );
	ProfileNetworkVirtualIpSelectorLayout->addWidget( ProfileNetworkVirtualIpSelectorLabel );
	ProfileNetworkVirtualIpSelectorLayout->addWidget( ProfileNetworkVirtualIpSelector );

	ProfileNetworkVirtualIpOptionsWidget = new ProfileNetworkVirtualIpOptions( ProfileNetworkVirtualIpOptionsFrame );

	lo->addWidget( ProfileNetworkVirtualIpSelectorWidget );
	lo->addWidget( ProfileNetworkVirtualIpOptionsWidget );
	ProfileNetworkVirtualIpSelector->setEnabled( true );
	connect(ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox, TQT_SIGNAL(activated ( const TQString & )),this, TQT_SLOT(tunnelDeviceTypeChanged(const TQString& )));

	path.clear();
	path << i18n( "Profile" ) << i18n( "Connection specific" ) << i18n( "Cisco" );
	ProfileCiscoOptionsFrame = addPage( path, i18n( "Cisco" ), BarIcon( "cisco", TDEIcon::SizeSmall ) );
	lo = new TQVBoxLayout( ProfileCiscoOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	TQWidget *ProfileCiscoSelectorWidget = new TQWidget( ProfileCiscoOptionsFrame );
	TQHBoxLayout *ProfileCiscoSelectorLayout = new TQHBoxLayout( ProfileCiscoSelectorWidget );
	TQLabel *ProfileCiscoSelectorLabel = new TQLabel( ProfileCiscoSelectorWidget );
	ProfileCiscoSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileCiscoSelector = new TQComboBox( ProfileCiscoSelectorWidget );
	ProfileCiscoSelectorLayout->addWidget( ProfileCiscoSelectorLabel );
	ProfileCiscoSelectorLayout->addWidget( ProfileCiscoSelector );

	ProfileCiscoOptionsWidget = new ProfileCiscoOptions( ProfileCiscoOptionsFrame );

	lo->addWidget( ProfileCiscoSelectorWidget );
	lo->addWidget( ProfileCiscoOptionsWidget );
	ProfileCiscoSelector->setEnabled( true );
	connect (ProfileCiscoOptionsWidget->LocalPortCheckbox, TQT_SIGNAL(toggled(bool)),this, TQT_SLOT(localPortToggled(bool)));
	connect (ProfileCiscoOptionsWidget->ApplicationVersionCheckbox, TQT_SIGNAL(toggled(bool)),this, TQT_SLOT(applicationVersionToggled(bool)));
	connect (ProfileCiscoOptionsWidget->PerfectForwardSecurityCheckbox, TQT_SIGNAL(toggled(bool)),this, TQT_SLOT(perfectForwardSecurityToggled(bool)));
	connect (ProfileCiscoOptionsWidget->IkeGroupCheckbox, TQT_SIGNAL(toggled(bool)),this, TQT_SLOT(IkeGroupToggled(bool)));
	connect (ProfileCiscoOptionsWidget->SingleDesCheckbox, TQT_SIGNAL(toggled(bool)),this, TQT_SLOT(singleDesToggled(bool)));
	connect (ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox, TQT_SIGNAL(toggled(bool)),this, TQT_SLOT(dpdToggled(bool)));

	//ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled( false );
	ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->clear();
	ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->insertItem( "server" );
	ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->insertItem( "nopfs" );
	ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->insertItem( "dh1" );
	ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->insertItem( "dh2" );
	ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->insertItem( "dh5");

	//ProfileCiscoOptionsWidget->IkeGroupCombobox->setEnabled( false );
	ProfileCiscoOptionsWidget->IkeGroupCombobox->clear();
	ProfileCiscoOptionsWidget->IkeGroupCombobox->insertItem( "dh1");
	ProfileCiscoOptionsWidget->IkeGroupCombobox->insertItem( "dh2");
	ProfileCiscoOptionsWidget->IkeGroupCombobox->insertItem( "dh5");

	path.clear();
	path << i18n( "Profile" ) << i18n( "Connection specific" ) << i18n( "Racoon" );
	ProfileRacoonOptionsFrame = addPage( path, i18n( "Racoon" ), BarIcon( "kame", TDEIcon::SizeSmall ) );
	lo = new TQVBoxLayout( ProfileRacoonOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	TQWidget *ProfileRacoonSelectorWidget = new TQWidget( ProfileRacoonOptionsFrame );
	TQHBoxLayout *ProfileRacoonSelectorLayout = new TQHBoxLayout( ProfileRacoonSelectorWidget );
	TQLabel *ProfileRacoonSelectorLabel = new TQLabel( ProfileRacoonSelectorWidget );
	ProfileRacoonSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileRacoonSelector = new TQComboBox( ProfileRacoonSelectorWidget );
	ProfileRacoonSelectorLayout->addWidget( ProfileRacoonSelectorLabel );
	ProfileRacoonSelectorLayout->addWidget( ProfileRacoonSelector );

	ProfileRacoonOptionsWidget = new ProfileRacoonOptions( ProfileRacoonOptionsFrame );
	ProfileRacoonOptionsWidget->ExchangeModeComboBox->insertItem( "main", 0 );
	ProfileRacoonOptionsWidget->ExchangeModeComboBox->insertItem( "aggressive", 1 );
	ProfileRacoonOptionsWidget->ExchangeModeComboBox->insertItem( "base", 2 );
	ProfileRacoonOptionsWidget->ExchangeModeComboBox->setCurrentItem( 0 ); // main
	connect (ProfileRacoonOptionsWidget->PerfectForwardSecurityCheckbox, TQT_SIGNAL(toggled(bool)),this, TQT_SLOT(perfectForwardSecurityToggled(bool)));
	connect (ProfileRacoonOptionsWidget->IkeGroupCheckbox, TQT_SIGNAL(toggled(bool)),this, TQT_SLOT(IkeGroupToggled(bool)));

	//ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled( false );
	ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->clear();
	ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->insertItem( "modp768" );
	ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->insertItem( "modp1024" );
	ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->insertItem( "modp1536" );
	ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->insertItem( "modp2048" );
	ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->insertItem( "modp3072" );
	ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->insertItem( "modp4096" );
	ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->insertItem( "modp6144" );
	ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->insertItem( "modp8192" );
	
	ProfileRacoonOptionsWidget->DHGroupComboBox->setEnabled( false );
	ProfileRacoonOptionsWidget->DHGroupComboBox->clear();
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp768" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp1024" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp1536" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp2048" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp3072" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp4096" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp6144" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp8192" );
	
	lo->addWidget( ProfileRacoonSelectorWidget );
	lo->addWidget( ProfileRacoonOptionsWidget );
	ProfileRacoonSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Connection specific" ) << i18n( "Openswan/strongSwan" );
	ProfileIpsecOptionsFrame = addPage( path, i18n( "Openswan/strongSwan" ), BarIcon( "openswan", TDEIcon::SizeSmall ) );
	lo = new TQVBoxLayout( ProfileIpsecOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	TQWidget *ProfileIpsecSelectorWidget = new TQWidget( ProfileIpsecOptionsFrame );
	TQHBoxLayout *ProfileIpsecSelectorLayout = new TQHBoxLayout( ProfileIpsecSelectorWidget );
	TQLabel *ProfileIpsecSelectorLabel = new TQLabel( ProfileIpsecSelectorWidget );
	ProfileIpsecSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileIpsecSelector = new TQComboBox( ProfileIpsecSelectorWidget );
	ProfileIpsecSelectorLayout->addWidget( ProfileIpsecSelectorLabel );
	ProfileIpsecSelectorLayout->addWidget( ProfileIpsecSelector );

	ProfileIpsecOptionsWidget = new ProfileIpsecOptions( ProfileIpsecOptionsFrame );
	connect (ProfileIpsecOptionsWidget->PerfectForwardSecurityCheckbox, TQT_SIGNAL(toggled(bool)),this, TQT_SLOT(perfectForwardSecurityToggled(bool)));
	connect (ProfileIpsecOptionsWidget->UseXauthCheckBox, TQT_SIGNAL(toggled(bool)),this, TQT_SLOT(useXauthToggled(bool)));

	ProfileIpsecOptionsWidget->IpsecVpnModeCombobox->insertItem( "transport" );
	ProfileIpsecOptionsWidget->IpsecVpnModeCombobox->insertItem( "tunnel" );

	ProfileIpsecOptionsWidget->ExchangeModeComboBox->insertItem( "main", 0 );
	ProfileIpsecOptionsWidget->ExchangeModeComboBox->insertItem( "aggressive", 1 );
	ProfileIpsecOptionsWidget->ExchangeModeComboBox->insertItem( "base", 2 );

	ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled( false );
	ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->clear();
	ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->insertItem( "modp768" );
	ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->insertItem( "modp1024" );
	ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->insertItem( "modp1536" );
	ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->insertItem( "modp2048" );
	ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->insertItem( "modp3072" );
	ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->insertItem( "modp4096" );
	ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->insertItem( "modp6144" );
	ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->insertItem( "modp8192" );

	lo->addWidget( ProfileIpsecSelectorWidget );
	lo->addWidget( ProfileIpsecOptionsWidget );
	ProfileIpsecSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Connection specific" ) << i18n( "OpenVPN" );
	ProfileOpenvpnOptionsFrame = addPage( path, i18n( "OpenVPN" ), BarIcon( "openvpn", TDEIcon::SizeSmall ) );
	lo = new TQVBoxLayout( ProfileOpenvpnOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	TQWidget *ProfileOpenvpnSelectorWidget = new TQWidget( ProfileOpenvpnOptionsFrame );
	TQHBoxLayout *ProfileOpenvpnSelectorLayout = new TQHBoxLayout( ProfileOpenvpnSelectorWidget );
	TQLabel *ProfileOpenvpnSelectorLabel = new TQLabel( ProfileOpenvpnSelectorWidget );
	ProfileOpenvpnSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileOpenvpnSelector = new TQComboBox( ProfileOpenvpnSelectorWidget );
	ProfileOpenvpnSelectorLayout->addWidget( ProfileOpenvpnSelectorLabel );
	ProfileOpenvpnSelectorLayout->addWidget( ProfileOpenvpnSelector );

	ProfileOpenvpnOptionsWidget = new ProfileOpenvpnOptions( ProfileOpenvpnOptionsFrame );

	lo->addWidget( ProfileOpenvpnSelectorWidget );
	lo->addWidget( ProfileOpenvpnOptionsWidget );
	ProfileOpenvpnSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Connection specific" ) << i18n( "PPTP/L2TP" );
	ProfilePptpOptionsFrame = addPage( path, i18n( "PPTP/L2TP" ), BarIcon( "application", TDEIcon::SizeSmall ) );
	lo = new TQVBoxLayout( ProfilePptpOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	TQWidget *ProfilePptpSelectorWidget = new TQWidget( ProfilePptpOptionsFrame );
	TQHBoxLayout *ProfilePptpSelectorLayout = new TQHBoxLayout( ProfilePptpSelectorWidget );
	TQLabel *ProfilePptpSelectorLabel = new TQLabel( ProfilePptpSelectorWidget );
	ProfilePptpSelectorLabel->setText( i18n( "Profile:" ) );
	ProfilePptpSelector = new TQComboBox( ProfilePptpSelectorWidget );
	ProfilePptpSelectorLayout->addWidget( ProfilePptpSelectorLabel );
	ProfilePptpSelectorLayout->addWidget( ProfilePptpSelector );

	ProfilePptpOptionsWidget = new ProfilePptpOptions( ProfilePptpOptionsFrame );

	lo->addWidget( ProfilePptpSelectorWidget );
	lo->addWidget( ProfilePptpOptionsWidget );
	ProfilePptpSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Connection specific" ) << i18n( "Vtun" );
	ProfileVtunOptionsFrame = addPage( path, i18n( "Vtun" ), BarIcon( "application", TDEIcon::SizeSmall ) );
	lo = new TQVBoxLayout( ProfileVtunOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	TQWidget *ProfileVtunSelectorWidget = new TQWidget( ProfileVtunOptionsFrame );
	TQHBoxLayout *ProfileVtunSelectorLayout = new TQHBoxLayout( ProfileVtunSelectorWidget );
	TQLabel *ProfileVtunSelectorLabel = new TQLabel( ProfileVtunSelectorWidget );
	ProfileVtunSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileVtunSelector = new TQComboBox( ProfileVtunSelectorWidget );
	ProfileVtunSelectorLayout->addWidget( ProfileVtunSelectorLabel );
	ProfileVtunSelectorLayout->addWidget( ProfileVtunSelector );

	ProfileVtunOptionsWidget = new ProfileVtunOptions( ProfileVtunOptionsFrame );

	lo->addWidget( ProfileVtunSelectorWidget );
	lo->addWidget( ProfileVtunOptionsWidget );
	ProfileVtunSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Connection specific" ) << i18n( "SSH" );
	ProfileSshOptionsFrame = addPage( path, i18n( "SSH" ), BarIcon( "openssh", TDEIcon::SizeSmall ) );
	lo = new TQVBoxLayout( ProfileSshOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	TQWidget *ProfileSshSelectorWidget = new TQWidget( ProfileSshOptionsFrame );
	TQHBoxLayout *ProfileSshSelectorLayout = new TQHBoxLayout( ProfileSshSelectorWidget );
	TQLabel *ProfileSshSelectorLabel = new TQLabel( ProfileSshSelectorWidget );
	ProfileSshSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileSshSelector = new TQComboBox( ProfileSshSelectorWidget );
	ProfileSshSelectorLayout->addWidget( ProfileSshSelectorLabel );
	ProfileSshSelectorLayout->addWidget( ProfileSshSelector );

	ProfileSshOptionsWidget = new ProfileSshOptions( ProfileSshOptionsFrame );

	lo->addWidget( ProfileSshSelectorWidget );
	lo->addWidget( ProfileSshOptionsWidget );
	ProfileSshSelector->setEnabled( true );
	ProfileSshOptionsWidget->SshKeyComboBox->clear();
	TQString Home= TQString(getenv("HOME"));
	if (!Home.isEmpty())
	{
		TQDir dir( Home+"/.ssh" );
		TQStringList KeyFiles = dir.entryList( "*" );
		
		//if (GlobalConfig->KvpncDebugLevel > 2)
		//{
		//	GlobalConfig->appendLogEntry(i18n("SSH files: %1").arg(KeyFiles.join(",")),GlobalConfig->debug);
		//}
		
		if (KeyFiles.size() > 1)
		{
			for ( TQStringList::Iterator it = KeyFiles.begin(); it != KeyFiles.end(); ++it )
			{
				TQString item = TQString(*it);
				if (GlobalConfig->KvpncDebugLevel > 2)
				{
					GlobalConfig->appendLogEntry(i18n("processing entry: %1").arg(item),GlobalConfig->debug);
				}
				if (!item.contains (".pub", false)  && !item.contains ("authorized_keys", false)  && !item.contains ("known_hosts", false) && !item.contains (".", false) && !item.contains ("..", false) && !item.contains ("config", false) )
				{
					if (GlobalConfig->KvpncDebugLevel > 2)
					{
						GlobalConfig->appendLogEntry(i18n("SSH key found: %1").arg(*it),GlobalConfig->debug);
					}
						ProfileSshOptionsWidget->SshKeyComboBox->insertItem(*it);
				}
			}
		}
	}


	
	path.clear();
	path << i18n( "Profile" ) << i18n( "Command Execution" ) << i18n( "Before Connect" );
	ProfileCmdExecBeforeConnectOptionsFrame = addPage( path, i18n( "Before Connect" ), BarIcon( "application-x-executable", TDEIcon::SizeSmall ) );
	lo = new TQVBoxLayout( ProfileCmdExecBeforeConnectOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	TQWidget *ProfileCmdExecBeforeConnectSelectorWidget = new TQWidget( ProfileCmdExecBeforeConnectOptionsFrame );
	TQHBoxLayout *ProfileCmdExecBeforeConnectSelectorLayout = new TQHBoxLayout( ProfileCmdExecBeforeConnectSelectorWidget );
	TQLabel *ProfileCmdExecBeforeConnectSelectorLabel = new TQLabel( ProfileCmdExecBeforeConnectSelectorWidget );
	ProfileCmdExecBeforeConnectSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileCmdExecBeforeConnectSelector = new TQComboBox( ProfileCmdExecBeforeConnectSelectorWidget );
	ProfileCmdExecBeforeConnectSelectorLayout->addWidget( ProfileCmdExecBeforeConnectSelectorLabel );
	ProfileCmdExecBeforeConnectSelectorLayout->addWidget( ProfileCmdExecBeforeConnectSelector );

	ProfileCmdExecBeforeConnectOptionsWidget = new ProfileCmdExecBeforeConnectOptions( ProfileCmdExecBeforeConnectOptionsFrame );

	lo->addWidget( ProfileCmdExecBeforeConnectSelectorWidget );
	lo->addWidget( ProfileCmdExecBeforeConnectOptionsWidget );
	ProfileCmdExecBeforeConnectSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Command Execution" ) << i18n( "After Connect" );
	ProfileCmdExecAfterConnectOptionsFrame = addPage( path, i18n( "After Connect" ), BarIcon( "application-x-executable", TDEIcon::SizeSmall ) );
	lo = new TQVBoxLayout( ProfileCmdExecAfterConnectOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	TQWidget *ProfileCmdExecAfterConnectSelectorWidget = new TQWidget( ProfileCmdExecAfterConnectOptionsFrame );
	TQHBoxLayout *ProfileCmdExecAfterConnectSelectorLayout = new TQHBoxLayout( ProfileCmdExecAfterConnectSelectorWidget );
	TQLabel *ProfileCmdExecAfterConnectSelectorLabel = new TQLabel( ProfileCmdExecAfterConnectSelectorWidget );
	ProfileCmdExecAfterConnectSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileCmdExecAfterConnectSelector = new TQComboBox( ProfileCmdExecAfterConnectSelectorWidget );
	ProfileCmdExecAfterConnectSelectorLayout->addWidget( ProfileCmdExecAfterConnectSelectorLabel );
	ProfileCmdExecAfterConnectSelectorLayout->addWidget( ProfileCmdExecAfterConnectSelector );

	ProfileCmdExecAfterConnectOptionsWidget = new ProfileCmdExecAfterConnectOptions( ProfileCmdExecAfterConnectOptionsFrame );
	lo->addWidget( ProfileCmdExecAfterConnectSelectorWidget );
	lo->addWidget( ProfileCmdExecAfterConnectOptionsWidget );
	ProfileCmdExecAfterConnectSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Command Execution" ) << i18n( "Before Disconnect" );
	ProfileCmdExecBeforeDisconnectOptionsFrame = addPage( path, i18n( "Before Disconnect" ), BarIcon( "application-x-executable", TDEIcon::SizeSmall ) );
	lo = new TQVBoxLayout( ProfileCmdExecBeforeDisconnectOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	TQWidget *ProfileCmdExecBeforeDisconnectSelectorWidget = new TQWidget( ProfileCmdExecBeforeDisconnectOptionsFrame );
	TQHBoxLayout *ProfileCmdExecBeforeDisconnectSelectorLayout = new TQHBoxLayout( ProfileCmdExecBeforeDisconnectSelectorWidget );
	TQLabel *ProfileCmdExecBeforeDisconnectSelectorLabel = new TQLabel( ProfileCmdExecBeforeDisconnectSelectorWidget );
	ProfileCmdExecBeforeDisconnectSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileCmdExecBeforeDisconnectSelector = new TQComboBox( ProfileCmdExecBeforeDisconnectSelectorWidget );
	ProfileCmdExecBeforeDisconnectSelectorLayout->addWidget( ProfileCmdExecBeforeDisconnectSelectorLabel );
	ProfileCmdExecBeforeDisconnectSelectorLayout->addWidget( ProfileCmdExecBeforeDisconnectSelector );

	ProfileCmdExecBeforeDisconnectOptionsWidget = new ProfileCmdExecBeforeDisconnectOptions( ProfileCmdExecBeforeDisconnectOptionsFrame );
	lo->addWidget( ProfileCmdExecBeforeDisconnectSelectorWidget );
	lo->addWidget( ProfileCmdExecBeforeDisconnectOptionsWidget );
	ProfileCmdExecBeforeDisconnectSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Command Execution" ) << i18n( "After Disconnect" );
	ProfileCmdExecAfterDisconnectOptionsFrame = addPage( path, i18n( "Command Execute After Disconnect" ), BarIcon( "application-x-executable", TDEIcon::SizeSmall ) );
	lo = new TQVBoxLayout( ProfileCmdExecAfterDisconnectOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	TQWidget *ProfileCmdExecAfterDisconnectSelectorWidget = new TQWidget( ProfileCmdExecAfterDisconnectOptionsFrame );
	TQHBoxLayout *ProfileCmdExecAfterDisconnectSelectorLayout = new TQHBoxLayout( ProfileCmdExecAfterDisconnectSelectorWidget );
	TQLabel *ProfileCmdExecAfterDisconnectSelectorLabel = new TQLabel( ProfileCmdExecAfterDisconnectSelectorWidget );
	ProfileCmdExecAfterDisconnectSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileCmdExecAfterDisconnectSelector = new TQComboBox( ProfileCmdExecAfterDisconnectSelectorWidget );
	ProfileCmdExecAfterDisconnectSelectorLayout->addWidget( ProfileCmdExecAfterDisconnectSelectorLabel );
	ProfileCmdExecAfterDisconnectSelectorLayout->addWidget( ProfileCmdExecAfterDisconnectSelector );

	ProfileCmdExecAfterDisconnectOptionsWidget = new ProfileCmdExecAfterDisconnectOptions( ProfileCmdExecAfterDisconnectOptionsFrame );
	lo->addWidget( ProfileCmdExecAfterDisconnectSelectorWidget );
	lo->addWidget( ProfileCmdExecAfterDisconnectOptionsWidget );
	ProfileCmdExecAfterDisconnectSelector->setEnabled( true );

// 	resize(TQSize(800,600));
// 	setFixedSize(TQSize(800,600));
// 	adjustSize();

	if ( !showOnlyProfiles )
	{
// 		DaemonScrollView->adjustSize();	
// 			DaemonScrollView->updateContents();
// 		ConfigDaemonOptionsWidget->resize(ConfigDaemonOptionsWidget->height(),DaemonScrollView->visibleWidth()-100);
			ConfigDaemonOptionsWidget->sizeHint();
	}
// 	CertScrollView->adjustSize();
// 		CertScrollView->updateContents();
// 	ProfileCertOptionsWidget->adjustSize();
// 	adjustSize();
// 	ConfigDaemonOptionsWidget->adjustSize();
	

// 	adjustSize();
	// 	enableButtonApply(false);

	/* connect profile combobox of each profile widget */
	connect( ProfileGeneralSelector, TQT_SIGNAL( activated ( const TQString& ) ), this, TQT_SLOT( profileChanged( const TQString& ) ) );
	connect( ProfileNetworkRouteSelector, TQT_SIGNAL( activated ( const TQString& ) ), this, TQT_SLOT( profileChanged( const TQString& ) ) );
	connect( ProfileNetworkGeneralSelector, TQT_SIGNAL( activated ( const TQString& ) ), this, TQT_SLOT( profileChanged( const TQString& ) ) );
	connect( ProfileNetworkNatSelector, TQT_SIGNAL( activated ( const TQString& ) ), this, TQT_SLOT( profileChanged( const TQString& ) ) );
	connect( ProfileNetworkHttpProxySelector, TQT_SIGNAL( activated ( const TQString& ) ), this, TQT_SLOT( profileChanged( const TQString& ) ) );
	connect( ProfileNetworkVirtualIpSelector, TQT_SIGNAL( activated ( const TQString& ) ), this, TQT_SLOT( profileChanged( const TQString& ) ) );
	connect( ProfileCertSelector, TQT_SIGNAL( activated ( const TQString& ) ), this, TQT_SLOT( profileChanged( const TQString& ) ) );
	connect( ProfileSmartcardSelector, TQT_SIGNAL( activated ( const TQString& ) ), this, TQT_SLOT( profileChanged( const TQString& ) ) );
	connect( ProfilePskSelector, TQT_SIGNAL( activated ( const TQString& ) ), this, TQT_SLOT( profileChanged( const TQString& ) ) );
	connect( ProfileUserSelector, TQT_SIGNAL( activated ( const TQString& ) ), this, TQT_SLOT( profileChanged( const TQString& ) ) );
	connect( ProfileOpenvpnSelector, TQT_SIGNAL( activated ( const TQString& ) ), this, TQT_SLOT( profileChanged( const TQString& ) ) );
	connect( ProfilePptpSelector, TQT_SIGNAL( activated ( const TQString& ) ), this, TQT_SLOT( profileChanged( const TQString& ) ) );
	connect( ProfileRacoonSelector, TQT_SIGNAL( activated ( const TQString& ) ), this, TQT_SLOT( profileChanged( const TQString& ) ) );
	connect( ProfileIpsecSelector, TQT_SIGNAL( activated ( const TQString& ) ), this, TQT_SLOT( profileChanged( const TQString& ) ) );
	connect( ProfileCiscoSelector, TQT_SIGNAL( activated ( const TQString& ) ), this, TQT_SLOT( profileChanged( const TQString& ) ) );
	connect( ProfileVtunSelector, TQT_SIGNAL( activated ( const TQString& ) ), this, TQT_SLOT( profileChanged( const TQString& ) ) );
	connect( ProfileSshSelector, TQT_SIGNAL( activated ( const TQString& ) ), this, TQT_SLOT( profileChanged( const TQString& ) ) );
	connect( ProfileCmdExecBeforeConnectSelector, TQT_SIGNAL( activated ( const TQString& ) ), this, TQT_SLOT( profileChanged( const TQString& ) ) );
	connect( ProfileCmdExecBeforeDisconnectSelector, TQT_SIGNAL( activated ( const TQString& ) ), this, TQT_SLOT( profileChanged( const TQString& ) ) );
	connect( ProfileCmdExecAfterConnectSelector, TQT_SIGNAL( activated ( const TQString& ) ), this, TQT_SLOT( profileChanged( const TQString& ) ) );
	connect( ProfileCmdExecAfterDisconnectSelector, TQT_SIGNAL( activated ( const TQString& ) ), this, TQT_SLOT( profileChanged( const TQString& ) ) );

	connect( ProfileOpenvpnOptionsWidget->AuthWithUsernameAndPasswordCheckBox, TQT_SIGNAL( toggled ( bool ) ), this, TQT_SLOT( userAuthToggled( bool ) ) );

	
// 	connect( ProfileCertOptionsWidget->UseSpecialServerSmartcardificateCheckBox, TQT_SIGNAL (toggled(bool)), TQT_SLOT(useSpecialServerSmartcardificateToggled(bool) ) );
	connect( ProfileCertOptionsWidget->AuthTypeComboBox, TQT_SIGNAL( activated ( int ) ), this, TQT_SLOT( authTypeChanged( int ) ) );
	connect( ProfilePskOptionsWidget->AuthTypeComboBox, TQT_SIGNAL( activated ( int ) ), this, TQT_SLOT( authTypeChanged( int ) ) );



// 	connect ( ProfileGeneralOptionsWidget->NewSessionPushButton , TQT_SIGNAL( clicked () ), this, TQT_SLOT( newSessionClicked() ) );
	connect ( ProfileGeneralOptionsWidget->SaveSessionPushButton, TQT_SIGNAL( clicked () ), this, TQT_SLOT( saveSessionClicked() ) );
	connect ( ProfileGeneralOptionsWidget->RenameSessionPushButton, TQT_SIGNAL( clicked () ), this, TQT_SLOT( renameSessionClicked() ) );
	connect ( ProfileGeneralOptionsWidget->DeleteSessionPushButton, TQT_SIGNAL( clicked () ), this, TQT_SLOT( deleteSessionClicked() ) );
	connect ( this, TQT_SIGNAL( aboutToShowPage( TQWidget * ) ), this, TQT_SLOT( pageChanged( TQWidget * ) ) );
	connect ( this, TQT_SIGNAL( applyClicked () ), this, TQT_SLOT( saveSessionClicked() ) );

}

void PreferencesDialog::accept()
{
	//MyprofileWidget->saveSessionClicked();
	if ( !showOnlyProfiles )
	{
		GlobalConfig->pathToVpnc =ConfigDaemonOptionsWidget->VpncPathInput->url();
		GlobalConfig->pathToRacoon =ConfigDaemonOptionsWidget->RacoonPathInput->url();
		GlobalConfig->pathToPppd =ConfigDaemonOptionsWidget->PppdPathInput->url();
		GlobalConfig->pathToPptp =ConfigDaemonOptionsWidget->PptpPathInput->url();
		GlobalConfig->pathToOpenvpn =ConfigDaemonOptionsWidget->OpenvpnPathInput->url();
		GlobalConfig->pathToIpsec =ConfigDaemonOptionsWidget->FreeswanPathInput->url();
		GlobalConfig->pathToSsh = ConfigDaemonOptionsWidget->SshPathInput->url();
		GlobalConfig->minimizeAfterConnect = ConnectOptionsWidget->checkMinimizeAfterConnectCheck->isChecked();
		GlobalConfig->showDebugConsole = DebugOptionsWidget->showDebugCheck->isChecked();
		GlobalConfig->useSilentQuit = ConnectOptionsWidget->SilentQuitcheckBox->isChecked();
		GlobalConfig->dontQuitOnCloseEvent = GeneralOptionsWidget->DontQuitOnCloseEventCheckBox->isChecked();
		GlobalConfig->useTDEwallet = GeneralOptionsWidget->useTDEwalletCheckBox->isChecked();
		GlobalConfig->writeLogFile = DebugOptionsWidget->WriteLogCheck->isChecked();
		GlobalConfig->KvpncDebugLevel = DebugOptionsWidget->spinKvpncDebugLevel->value();
		GlobalConfig->RacoonDebugLevel = ConfigDaemonOptionsWidget->RacoonDebugLevelComboBox->currentText();
		GlobalConfig->VpncDebugLevel =ConfigDaemonOptionsWidget->spinVpncDebugLevel->value();
		GlobalConfig->OpenvpnDebugLevel =ConfigDaemonOptionsWidget->spinOpenvpnDebugLevel->value() + 1;
		GlobalConfig->SshDebugLevel =ConfigDaemonOptionsWidget->spinSshDebugLevel->value();

		GlobalConfig->pathToIptables = HelperProgramOptionsWidget->IptablesPathInput->url();
		GlobalConfig->pathToOpenssl = HelperProgramOptionsWidget->OpenSSLPathInput->url();
		GlobalConfig->pathToKill = HelperProgramOptionsWidget->KillPathInput->url();
		GlobalConfig->pathToKillall = HelperProgramOptionsWidget->KillallPathInput->url();
		GlobalConfig->pathToPing = HelperProgramOptionsWidget->PingPathInput->url();
		GlobalConfig->pathToIp = HelperProgramOptionsWidget->IpPathInput->url();
		GlobalConfig->pathToIfconfig = HelperProgramOptionsWidget->IfconfigPathInput->url();
		GlobalConfig->pathToTail = HelperProgramOptionsWidget->TailPathInput->url();
		GlobalConfig->pathToRoute = HelperProgramOptionsWidget->RoutePathInput->url();
		GlobalConfig->pathToPkcs11Tool = HelperProgramOptionsWidget->Pkcs11ToolPathInput->url();
		GlobalConfig->pathToKsshAskpass = HelperProgramOptionsWidget->KsshaskpassPathInput->url();
		GlobalConfig->pathToGnomeSshAskpass = HelperProgramOptionsWidget->GnomeaskpassPathInput->url();
		GlobalConfig->pathToCiscoCertMgr = HelperProgramOptionsWidget->CiscoCertMgrPathInput->url();
		GlobalConfig->pathToTail = HelperProgramOptionsWidget->TailPathInput->url();


		if (ConfigDaemonOptionsWidget->PptpLogLevelComboBox->currentText() == i18n( "low" ) )
			GlobalConfig->PptpLogLevel = 0;
		else if (ConfigDaemonOptionsWidget->PptpLogLevelComboBox->currentText() == i18n( "default" ) )
			GlobalConfig->PptpLogLevel = 1;
		else if (ConfigDaemonOptionsWidget->PptpLogLevelComboBox->currentText() == i18n( "high" ) )
			GlobalConfig->PptpLogLevel = 2;

		GlobalConfig->enableDebugPppd =ConfigDaemonOptionsWidget->DebugPppdcheckBox->isChecked();
		GlobalConfig->enableDebugPptpd =ConfigDaemonOptionsWidget->DebugPptpdcheckBox->isChecked();
		GlobalConfig->enableDebugL2tpd =ConfigDaemonOptionsWidget->DebugL2tpdCheckBox->isChecked();

		GlobalConfig->enableDebugXl2tpdtunnel = ConfigDaemonOptionsWidget->EnableDebugXl2tpdtunnelCheckBox->isChecked( );
		GlobalConfig->enableDebugXl2tpdstate = ConfigDaemonOptionsWidget->EnableDebugXl2tpdstateCheckBox ->isChecked(  );
		GlobalConfig->enableDebugXl2tpdpacket = ConfigDaemonOptionsWidget->EnableDebugXl2tpdpacketCheckBox->isChecked(  );
		GlobalConfig->enableDebugXl2tpdNetwork  = ConfigDaemonOptionsWidget->EnableDebugXl2tpdNetworkCheckBox->isChecked( );

		GlobalConfig->tryConnectTimeout = ProfileCiscoOptionsWidget->PeerTimeoutIntNumInput->value();
		GlobalConfig->programsInPath =ConfigDaemonOptionsWidget->ProgramsInPathcheckBox->isChecked();
		GlobalConfig->holdGeneratedScripts = DebugOptionsWidget->KeepConnectionFilesCheckBox->isChecked();
		GlobalConfig->InfoLogColor = LogOptionsWidget->InfoLogLabel->paletteBackgroundColor ();
		GlobalConfig->RemoteLogColor = LogOptionsWidget->RemoteLogLabel->paletteBackgroundColor();
		GlobalConfig->ErrorLogColor = LogOptionsWidget->ErrorLogLabel->paletteBackgroundColor ();
		GlobalConfig->SuccessLogColor = LogOptionsWidget->SuccessLogLabel->paletteBackgroundColor ();
		GlobalConfig->DebugLogColor = LogOptionsWidget->DebugLogLabel->paletteBackgroundColor ();
		GlobalConfig->DebugBackgroundcolor = LogOptionsWidget->BackgroundLogLabel->paletteBackgroundColor ();
		GlobalConfig->useColorizedLogOutput = LogOptionsWidget->UseColorizedLogOutputcheckBox->isChecked();
		GlobalConfig->showInterfaceIPinTooltip =ConfigDaemonOptionsWidget->ShowInterfaceIPinTooltipCheckBox->isChecked();
		GlobalConfig->doAutoConnectAtStartup = ConnectOptionsWidget->DoAutoConnectCheckBox->isChecked();
		GlobalConfig->AutoConnectProfile = ConnectOptionsWidget->AutoConnectProfileComboBox->currentText();
		GlobalConfig->LogViewerFontSize = LogOptionsWidget->LogFontSizeSpinBox->value();
	}
	
	if ( !GlobalConfig->AccountList->isEmpty() )
	{
		if (GlobalConfig->currentProfile == 0)
			GlobalConfig->currentProfile = GlobalConfig->AccountList->first();
	}

	saveSessionClicked();

	if ( canAccept )
		TQDialog::accept();
}

void PreferencesDialog::reject()
{
	if (configChanged)
		saveSessionClicked();
	TQDialog::reject();
}

void PreferencesDialog::slotApply()
{
	saveSessionClicked();
}

PreferencesDialog::~PreferencesDialog()
{
	delete ProfileGeneralSelector;
	delete ProfileNetworkRouteSelector;
	delete ProfileNetworkNatSelector;
	delete ProfileNetworkHttpProxySelector;
	delete ProfileNetworkVirtualIpSelector;
	delete ProfileCertSelector;
	delete ProfileSmartcardSelector;
	delete ProfilePskSelector;
	delete ProfileUserSelector;
	delete ProfileOpenvpnSelector;
	delete ProfilePptpSelector;
	delete ProfileRacoonSelector;
	delete ProfileIpsecSelector;
	delete ProfileCiscoSelector;
	delete ProfileCmdExecBeforeConnectSelector;
	delete ProfileCmdExecBeforeDisconnectSelector;
	delete ProfileCmdExecAfterConnectSelector;
	delete ProfileCmdExecAfterDisconnectSelector;
	GlobalConfig->prefDlgOpen = false;
}

void PreferencesDialog::connectionTypeChanged( int type )
{


	if ( GlobalConfig->KvpncDebugLevel > 1 )
		GlobalConfig->appendLogEntry( i18n( "connectionTypeChanged(): %1" ).arg( TQString().setNum( type ) ), GlobalConfig->debug );

	// 		KMessageBox::information(0,"connection type changed: "+TQString().setNum(type),TQString("type set"));

	if ( GlobalConfig->currentProfile == 0 )
		return ;

	GlobalConfig->currentProfile->setConnectionType( ( VpnAccountData::ConnectionType ) ( type ) );

	ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled ( TRUE );
	ProfileGeneralOptionsWidget->NewSessionPushButton->setEnabled ( TRUE );
	ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled ( TRUE );

	// First we should set a type
	// 	parent->buttonCancel->setEnabled( FALSE );
	// 	parent->buttonOk->setEnabled( FALSE );

	if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::cisco )
	{

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( "new type: cisco", GlobalConfig->debug );

		ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( true );
		ProfileCiscoOptionsWidget->LabelID->setEnabled( true );

		ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled( true );
		ProfileNetworkGeneralOptionsWidget->LabelNetworkDevice->setEnabled( true );
		ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( false );

		ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
		ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		if ( GlobalConfig->currentProfile->getUseUdp() )
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		else
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( false );

		ProfileCiscoOptionsWidget->CiscoNatModeComboBox->setCurrentText(GlobalConfig->currentProfile->getCiscoNatMode());

		emit authTypeChanged( GlobalConfig->currentProfile->getAuthType() );
	} // vpnc
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ciscoorig )
	{

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( "new type: cisco (proprietary)", GlobalConfig->debug );

		ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( true );
		ProfileCiscoOptionsWidget->LabelID->setEnabled( true );


		ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled( true );
		ProfileNetworkGeneralOptionsWidget->LabelNetworkDevice->setEnabled( true );
		ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( false );

		ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
		ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		if ( GlobalConfig->currentProfile->getUseUdp() )
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		else
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( false );
		ProfileCiscoOptionsWidget->CiscoNatModeComboBox->setEnabled(false);
		//ProfileCiscoOptionsWidget->CiscoNatModeComboBox->setCurrentText(GlobalConfig->currentProfile->getCiscoNatMode());
		
		emit authTypeChanged( GlobalConfig->currentProfile->getAuthType() );
	} // vpnc (proprietary)
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon )
	{

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "New type: %1" ).arg( "racoon" ), GlobalConfig->debug );

	}
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_racoon )
	{

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "New type: %1" ).arg( "l2tpd (racoon)" ), GlobalConfig->debug );

	}
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::freeswan )
	{

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "New type: %1" ).arg( "ipsec (openswan/strongswan)" ), GlobalConfig->debug );
	}
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan )
	{

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "New type: %1" ).arg( "l2tpd (openswan/strongswan)" ), GlobalConfig->debug );
	}
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::pptp )
	{
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( "new type: pptp", GlobalConfig->debug );
	} // pptp
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn )
	{
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "new type: %1" ).arg( "openvpn" ), GlobalConfig->debug );

		ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( false );
		ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( false );
		ProfileCiscoOptionsWidget->LabelID->setEnabled( false );
		// 		buttonCancel->setEnabled( TRUE );
		// 		buttonOk->setEnabled( TRUE );

		ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
		ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		if ( GlobalConfig->currentProfile->getUseUdp() )
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		else
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( false );

		emit authTypeChanged( GlobalConfig->currentProfile->getAuthType() );
	} // openvpn
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::vtun )
	{
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "new type: %1" ).arg( "Vtun" ), GlobalConfig->debug );

		ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( false );
		ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( false );
		ProfileCiscoOptionsWidget->LabelID->setEnabled( false );
		// 		buttonCancel->setEnabled( TRUE );
		// 		buttonOk->setEnabled( TRUE );

// 		ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
// 		ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
// 		if ( GlobalConfig->currentProfile->getUseUdp() )
// 			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
// 		else
// 			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( false );

		emit authTypeChanged( GlobalConfig->currentProfile->getAuthType() );
	} // vtun
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ssh )
	{
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "new type: %1" ).arg( "SSH" ), GlobalConfig->debug );

		ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( false );
		ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( false );
		ProfileCiscoOptionsWidget->LabelID->setEnabled( false );
		// 		buttonCancel->setEnabled( TRUE );
		// 		buttonOk->setEnabled( TRUE );

// 		ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
// 		ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
// 		if ( GlobalConfig->currentProfile->getUseUdp() )
// 			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
// 		else
// 			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( false );

		emit authTypeChanged( GlobalConfig->currentProfile->getAuthType() );
	} // ssh
	// other
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::other )
	{

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "new type: none specified" ), GlobalConfig->debug );
	}
	else
	{
		GlobalConfig->appendLogEntry( i18n( "unknown type" ), GlobalConfig->debug );
	}
	

	if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_racoon ||
	        GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon ||
	        GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::freeswan ||
				GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan)
	{
		if ( GlobalConfig->currentProfile != 0 )
		{
			ProfileCertOptionsWidget->privkeypathURLRequester->setURL( GlobalConfig->currentProfile->getPrivateKey() );
			ProfileCertOptionsWidget->PrivkeyPasswordEdit->setText( GlobalConfig->currentProfile->getPrivateKeyPass() );
			ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setChecked ( GlobalConfig->currentProfile->getSavePrivateKeyPassword() );
		}

		ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled ( true );
		ProfileNetworkGeneralOptionsWidget->LabelNetworkDevice->setEnabled( true );

		ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( false );
		ProfileCiscoOptionsWidget->LabelID->setEnabled( false );

		// 		buttonCancel->setEnabled( TRUE );
		// 		buttonOk->setEnabled( TRUE );




		ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
		ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		if ( GlobalConfig->currentProfile->getUseUdp() )
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		else
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( false );

		emit authTypeChanged( GlobalConfig->currentProfile->getAuthType() );
	} // racoon/freeswan

	if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_racoon || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan)
	{
		ProfilePptpOptionsWidget->MppeTab->setEnabled(false);
		ProfilePptpOptionsWidget->PppTab->setEnabled(false);
	}
	else
	{
		ProfilePptpOptionsWidget->MppeTab->setEnabled(true);
		ProfilePptpOptionsWidget->PppTab->setEnabled(true);
	}
}

void PreferencesDialog::authTypeChanged( int authtype )
{
	if ( GlobalConfig->currentProfile == 0 )
		return ;
	TQComboBox *signalsender = (TQComboBox *) TQObject::sender ();
	VpnAccountData::AuthenticationType oldAuthType = GlobalConfig->currentProfile->getAuthType();
	if (signalsender == ProfileCertOptionsWidget->AuthTypeComboBox)
	{
		if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::cisco)
		{
			// we need a fix here
			if (authtype == 0)
			{
				authtype = VpnAccountData::psk;
  			}
			else
			{
				authtype = VpnAccountData::hybrid;
  			}
		}
		GlobalConfig->appendLogEntry( i18n( "authtype changed by %1." ).arg( "ProfileCertOptionsWidget" ) , GlobalConfig->debug );
		if ( ProfileCertOptionsWidget->AuthTypeComboBox->currentText() == i18n( "X.509 Certificate" ))
			GlobalConfig->currentProfile->setAuthType(VpnAccountData::cert);
		else if ( ProfileCertOptionsWidget->AuthTypeComboBox->currentText() == i18n( "Pre Shared Key" ))
			GlobalConfig->currentProfile->setAuthType(VpnAccountData::psk);
		else if ( ProfileCertOptionsWidget->AuthTypeComboBox->currentText() == i18n( "Hybrid" ))
			GlobalConfig->currentProfile->setAuthType(VpnAccountData::hybrid);
			ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentText(ProfileCertOptionsWidget->AuthTypeComboBox->currentText());
	}
	else
	{
		if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::cisco)
		{
			// we need a fix here
			if (authtype == 0)
			{
				authtype = VpnAccountData::psk;
  			}
			else
			{
				authtype = VpnAccountData::hybrid;
  			}
		}
		GlobalConfig->appendLogEntry( i18n( "authtype changed by %1." ).arg( "ProfilePskOptionsWidget" ) , GlobalConfig->debug );
		if ( ProfilePskOptionsWidget->AuthTypeComboBox->currentText() == i18n( "X.509 Certificate" ))
			GlobalConfig->currentProfile->setAuthType(VpnAccountData::cert);
		else if ( ProfilePskOptionsWidget->AuthTypeComboBox->currentText() == i18n( "Pre Shared Key" ))
			GlobalConfig->currentProfile->setAuthType(VpnAccountData::psk);
		else if ( ProfilePskOptionsWidget->AuthTypeComboBox->currentText() == i18n( "Hybrid" ))
			GlobalConfig->currentProfile->setAuthType(VpnAccountData::hybrid);
		ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentText(ProfilePskOptionsWidget->AuthTypeComboBox->currentText());
	}
	
	if ( oldAuthType != GlobalConfig->currentProfile->getAuthType())
		saveSessionClicked();
	ProfilePskOptionsWidget->PskInFileCheckBox->setEnabled( true );

	if ( GlobalConfig->KvpncDebugLevel > 0 )
	{

		TQString type="unknown";
		if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::cert )
			type = "cert";
		else if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::psk )
			type = "psk";
		else if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::hybrid )
			type = "hybrid";
		else
			type ="unknown auth";


		GlobalConfig->appendLogEntry( i18n( "New authtype: \"%1\"." ).arg( type ) , GlobalConfig->debug );
	}

	ProfilePskOptionsWidget->PskGroupBox->setEnabled( false );
	ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled( false );
	ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled( false );
	ProfileCertOptionsWidget->LabelAuthType->setEnabled( false );
	ProfilePskOptionsWidget->LabelAuthType->setEnabled( false );
	ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled( false );
	

	if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::cisco || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ciscoorig  || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::pptp )
	{
		if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::cisco )
		{
			ProfilePskOptionsWidget->PskGroupBox->setEnabled( true );
			ProfilePskOptionsWidget->PSKLineEdit->setEnabled( true );
			ProfilePskOptionsWidget->LabelPsk->setEnabled( true );
			ProfilePskOptionsWidget->PskInFileCheckBox->setChecked( false );
			ProfilePskOptionsWidget->PskInFileCheckBox->setEnabled( false );
			ProfilePskOptionsWidget->PSKFileURLRequester->setEnabled( false );
			ProfilePskOptionsWidget->LabelPskFile->setEnabled( false );
			

			bool hasHybridSupport = getVpncHasHybridSupport();
			if (hasHybridSupport)
			{
				ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled( true );
				ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled( true );
				ProfileCertOptionsWidget->LabelAuthType->setEnabled( true );
				ProfilePskOptionsWidget->LabelAuthType->setEnabled( true );
				GlobalConfig->appendLogEntry ( i18n ( "Hybrid support detected, enabling cert options" ),GlobalConfig->debug );
			}
			else
			{
// 				ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentText( i18n( "Pre Shared Key" ) ); // PSK
				ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled( false );
				ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled( false );
				ProfileCertOptionsWidget->setEnabled (false);
				GlobalConfig->appendLogEntry ( i18n ( "Hybrid support not detected, disabling cert options" ),GlobalConfig->debug );
			}
			if ( authtype == VpnAccountData::cert  ||  authtype == VpnAccountData::hybrid )
			{
				
				// certificate
				ProfileCertOptionsWidget->setEnabled( true );
				if ( authtype == VpnAccountData::cert)
				{
					GlobalConfig->appendLogEntry ( i18n ( "Auth type is cert" ),GlobalConfig->debug );
					ProfileCertOptionsWidget->LabelCertificate->setEnabled( true );
					ProfileCertOptionsWidget->x509certURLRequester->setEnabled( true );
					ProfileCertOptionsWidget->x509certComboBox ->setEnabled( true );
					ProfilePskOptionsWidget->PskGroupBox->setEnabled( false );
					ProfilePskOptionsWidget->PSKFileURLRequester->setEnabled( false );
					ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled( true );
				}
				if ( authtype == VpnAccountData::hybrid)
				{
					GlobalConfig->appendLogEntry ( i18n ( "Auth type is hybrid" ),GlobalConfig->debug );
					ProfileCertOptionsWidget->LabelCertificate->setEnabled( false );
					ProfileCertOptionsWidget->x509certURLRequester->setEnabled( false );
					ProfileCertOptionsWidget->x509certComboBox ->setEnabled( false );
				}

				ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled( true );
				ProfileCertOptionsWidget->certpathURLRequester->setEnabled( true );
				ProfileCertOptionsWidget->LabelCaCertificatePath->setEnabled( true );
				ProfileCertOptionsWidget->LabelCertificatePath->setEnabled( true );
				ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled( false );
				ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled( false );
				ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled( false );
				ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setEnabled( true );
				ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled( true );

				ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled( false );
			}
			if ( authtype == VpnAccountData::psk )
			{
				GlobalConfig->appendLogEntry ( i18n ( "Auth type is psk" ),GlobalConfig->debug );
				// psk
				ProfilePskOptionsWidget->PskGroupBox->setEnabled( true );
				ProfilePskOptionsWidget->PSKLineEdit->setEnabled( true );
				ProfilePskOptionsWidget->LabelPsk->setEnabled( true );
				ProfilePskOptionsWidget->PskInFileCheckBox->setChecked( false );
				ProfilePskOptionsWidget->PskInFileCheckBox->setEnabled( false );
				ProfilePskOptionsWidget->PSKFileURLRequester->setEnabled( false );
				ProfilePskOptionsWidget->LabelPskFile->setEnabled( false );
				ProfileCertOptionsWidget->CaCertpathComboBox->setEnabled( false );
				ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled( false );
					
				ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled( false );
				ProfileCertOptionsWidget->x509certURLRequester->setEnabled( false );
				ProfileCertOptionsWidget->x509certComboBox->setEnabled( false );
				ProfileCertOptionsWidget->LabelCertificate->setEnabled( false );
				ProfileCertOptionsWidget->certpathURLRequester->setEnabled( false );
				ProfileCertOptionsWidget->LabelCaCertificatePath->setEnabled( false );
				ProfileCertOptionsWidget->CaCertpathComboBox->setEnabled( false );
				ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled( false );
				ProfileCertOptionsWidget->LabelCertificatePath->setEnabled( false );
				ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled( false );
				ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setEnabled( false );
				ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled( false );
				ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled( false );
			}
		}
		if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ciscoorig )
		{
			ProfileCertOptionsWidget->setEnabled( true );
			ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled( true );
			ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled( true );
			ProfileCertOptionsWidget->LabelAuthType->setEnabled( true );
			ProfilePskOptionsWidget->LabelAuthType->setEnabled( true );
			// cert
			if ( authtype == VpnAccountData::cert  ||  authtype == VpnAccountData::hybrid )
			{
				// certificate
				ProfileCertOptionsWidget->setEnabled( true );
				if ( authtype == VpnAccountData::cert)
				{
					GlobalConfig->appendLogEntry ( i18n ( "Auth type is cert" ),GlobalConfig->debug );
					ProfileCertOptionsWidget->LabelCertificate->setEnabled( true );
					ProfileCertOptionsWidget->x509certURLRequester->setEnabled( true );
					ProfileCertOptionsWidget->x509certComboBox ->setEnabled( true );
				}
				else
				{
					GlobalConfig->appendLogEntry ( i18n ( "Auth type is hybrid" ),GlobalConfig->debug );
					ProfileCertOptionsWidget->LabelCertificate->setEnabled( false );
					ProfileCertOptionsWidget->x509certURLRequester->setEnabled( false );
					ProfileCertOptionsWidget->x509certComboBox ->setEnabled( false );
				}
				ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled( false );
				ProfileCertOptionsWidget->certpathURLRequester->setEnabled( true );
				ProfileCertOptionsWidget->LabelCaCertificatePath->setEnabled( true );
				ProfileCertOptionsWidget->LabelCertificatePath->setEnabled( true );
				ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled( true );
				ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled( true );
				ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled( true );
				ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setEnabled( true );
				ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled( true );

				ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled( false );

				ProfilePskOptionsWidget->PskGroupBox->setEnabled( false );
				ProfilePskOptionsWidget->PSKFileURLRequester->setEnabled( false );
				ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled( true );
			}

			// psk
			if ( authtype == VpnAccountData::psk )
			{
				// psk
				GlobalConfig->appendLogEntry ( i18n ( "Auth type is psk" ),GlobalConfig->debug );
				ProfilePskOptionsWidget->PskGroupBox->setEnabled( true );
				ProfilePskOptionsWidget->PSKLineEdit->setEnabled( true );
				ProfilePskOptionsWidget->LabelPsk->setEnabled( true );
				ProfilePskOptionsWidget->PskInFileCheckBox->setChecked( false );
				ProfilePskOptionsWidget->PskInFileCheckBox->setEnabled( false );
				ProfilePskOptionsWidget->PSKFileURLRequester->setEnabled( false );
				ProfilePskOptionsWidget->LabelPskFile->setEnabled( false );
				ProfileCertOptionsWidget->CaCertpathComboBox->setEnabled( false );
				ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled( false );
					
				ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled( false );
				ProfileCertOptionsWidget->x509certURLRequester->setEnabled( false );
				ProfileCertOptionsWidget->x509certComboBox->setEnabled( false );
				ProfileCertOptionsWidget->LabelCertificate->setEnabled( false );
				ProfileCertOptionsWidget->certpathURLRequester->setEnabled( false );
				ProfileCertOptionsWidget->LabelCaCertificatePath->setEnabled( false );
				ProfileCertOptionsWidget->CaCertpathComboBox->setEnabled( false );
				ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled( false );
				ProfileCertOptionsWidget->LabelCertificatePath->setEnabled( false );
				ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled( false );
				ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setEnabled( false );
				ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled( false );
				ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled( false );
			}
		}

	}

	// racoon or freeswan
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::freeswan || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan ||
					GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_racoon )
	{

		ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled( true );
		ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled( true );
		ProfileCertOptionsWidget->LabelAuthType->setEnabled( true );
		ProfilePskOptionsWidget->LabelAuthType->setEnabled( true );
		// cert
		if ( authtype == VpnAccountData::cert )
		{
			// certificate
			ProfileCertOptionsWidget->setEnabled( true );
			ProfileCertOptionsWidget->x509certURLRequester->setEnabled( true );
			ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(true);
			ProfileCertOptionsWidget->LabelCertificate->setEnabled( true );
			ProfileCertOptionsWidget->certpathURLRequester->setEnabled( true );
			ProfileCertOptionsWidget->LabelCertificatePath->setEnabled( true );
			ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled( true );
			ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled(true);
			ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled(true);
			ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled(true);
			ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled(true);
			ProfileCertOptionsWidget->x509certComboBox->setEnabled(true);
			ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(true);

			ProfilePskOptionsWidget->PskGroupBox->setEnabled( false );
			ProfilePskOptionsWidget->PSKLineEdit->setEnabled( false );
			ProfilePskOptionsWidget->LabelPsk->setEnabled( false );

			

		}

		// psk
		if ( authtype == VpnAccountData::psk )
		{
			// psk
			ProfilePskOptionsWidget->PskGroupBox->setEnabled( true );
			ProfilePskOptionsWidget->PSKLineEdit->setEnabled( true );
			ProfilePskOptionsWidget->LabelPsk->setEnabled( true );

			ProfileCertOptionsWidget->x509certURLRequester->setEnabled( false );
			ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(false);
			ProfileCertOptionsWidget->LabelCertificate->setEnabled( false );

			ProfileCertOptionsWidget->certpathURLRequester->setEnabled( false );
			ProfileCertOptionsWidget->LabelCertificatePath->setEnabled( false );
			ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled(false);
			ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled(false);
			ProfileCertOptionsWidget->x509certComboBox->setEnabled(false);
			ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(false);

			ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled( false );
			ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled(true);
			ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled(true);
		}

		if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_racoon)
		{
			if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::hybrid)
			{
				ProfileCertOptionsWidget->setEnabled(true);
				ProfileCertOptionsWidget->x509certComboBox->setEnabled(false);
				ProfileCertOptionsWidget->x509certURLRequester->setEnabled(false);
				ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(true);
				ProfileCertOptionsWidget->CaCertpathURLRequester->setURL(GlobalConfig->currentProfile->getCaCertificate());
				ProfileCertOptionsWidget->certpathURLRequester->setURL( GlobalConfig->currentProfile->getCertPath() );
				ProfileCertOptionsWidget->VerifyCaCertCheckBox->setChecked(GlobalConfig->currentProfile->getVerifyCaCert());
				ProfileCertOptionsWidget->PrivkeyPasswordEdit->setText(GlobalConfig->currentProfile->getPrivateKeyPass());
				ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setChecked(GlobalConfig->currentProfile->getSavePrivateKeyPassword());
				ProfileCertOptionsWidget->LabelCertificate->setEnabled(false);
				ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled(false);
				ProfileCertOptionsWidget->LabelPrivateKeyPassword->setEnabled(false);
				ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->setEnabled(false);
				ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled(false);
				ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setEnabled(false);
				ProfileCertOptionsWidget->UseSpecialServerCertificateCheckBox->setEnabled(false);
				ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled(false);
				ProfilePskOptionsWidget->setEnabled(false);
			}
		}

	}
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn )
	{

		ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled( true );
		ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled( true );
		ProfileCertOptionsWidget->LabelAuthType->setEnabled( true );
		ProfilePskOptionsWidget->LabelAuthType->setEnabled( true );
		// cert
		if ( authtype == VpnAccountData::cert )
		{
			// certificate
			ProfileCertOptionsWidget->x509certURLRequester->setEnabled( true );
			ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled( true );
			ProfileCertOptionsWidget->LabelCertificate->setEnabled( true );

			ProfileCertOptionsWidget->certpathURLRequester->setEnabled( true );
			ProfileCertOptionsWidget->LabelCertificatePath->setEnabled( true );
			ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled( true );
			ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled( true );

			ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled( true );

			ProfilePskOptionsWidget->PskGroupBox->setEnabled( false );
			ProfilePskOptionsWidget->PSKFileURLRequester->setEnabled( false );
			ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled( true );
			ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled(true);
			ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled(true);
			ProfileCertOptionsWidget->x509certComboBox->setEnabled(true);
			ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(true);
		}

		// psk
		if ( authtype == VpnAccountData::psk )
		{
			// psk
			ProfilePskOptionsWidget->PskGroupBox->setEnabled( true );
			ProfilePskOptionsWidget->PSKFileURLRequester->setEnabled( true );
			ProfilePskOptionsWidget->PSKLineEdit->setEnabled( true );
			ProfilePskOptionsWidget->LabelPsk->setEnabled( true );

			ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled( false );
			ProfileCertOptionsWidget->x509certURLRequester->setEnabled( false );
			ProfileCertOptionsWidget->LabelCertificate->setEnabled( false );

			ProfileCertOptionsWidget->certpathURLRequester->setEnabled( false );
			ProfileCertOptionsWidget->LabelCertificatePath->setEnabled( false );
			ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled( false );
			ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled(false);
			ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled(false);
			ProfileCertOptionsWidget->x509certComboBox->setEnabled(false);
			ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(false);
		}

	}
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::vtun )
	{
		//TODO
	}
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ssh )
	{
		//TODO
	}
}

void PreferencesDialog::profileChanged( const TQString& itemtext )
{

	if ( !GlobalConfig->AccountList->isEmpty() && !itemtext.isEmpty() )
	{

		//	KMessageBox::information(0,"item clicked",Name);
		// profile data
		VpnAccountData * it;
		for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
		{
			if ( it->getName() == itemtext )
			{
				GlobalConfig->currentProfile = it;
				break;
			}
		}

		if (GlobalConfig->currentProfile == 0)
			return;


		if ( it == 0 )
		{
			ProfileGeneralOptionsWidget->RenameSessionPushButton->setEnabled( false );
			ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled( false );
			ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled( false );
			return ;
		}
		else
		{
			ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled( true );
			ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled( true );
		}

		TQString Name = itemtext;
		lastProfileName = Name;

		ProfileGeneralOptionsWidget->setEnabled( true );
		ProfileNetworkRouteOptionsWidget->setEnabled( true );
		ProfileNetworkNatOptionsWidget->setEnabled( true );
		ProfileNetworkVirtualIpOptionsWidget->setEnabled( true );
		ProfileCertOptionsWidget->setEnabled( true );
		ProfilePskOptionsWidget->setEnabled( true );
		ProfileUserOptionsWidget->setEnabled( true );
		ProfileOpenvpnOptionsWidget->setEnabled( true );
		ProfilePptpOptionsWidget->setEnabled( true );
		ProfileRacoonOptionsWidget->setEnabled( true );
		ProfileIpsecOptionsWidget->setEnabled( true );
		ProfileCiscoOptionsWidget->setEnabled( true );
		ProfileCmdExecBeforeConnectOptionsWidget->setEnabled( true );
		ProfileCmdExecBeforeDisconnectOptionsWidget->setEnabled( true );
		ProfileCmdExecAfterConnectOptionsWidget->setEnabled( true );
		ProfileCmdExecAfterDisconnectOptionsWidget->setEnabled( true );

		ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->RemoteNetDividetextLabel->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->LabelNetworkDevice->setEnabled( false );
		ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->setEnabled( false );
		ProfileNetworkVirtualIpOptionsWidget->SourceIpgroupBox->show();

		ProfileGeneralSelector->setCurrentText( lastProfileName );
		ProfileNetworkRouteSelector->setCurrentText( lastProfileName );
		ProfileNetworkNatSelector->setCurrentText( lastProfileName );
		ProfileNetworkHttpProxySelector->setCurrentText( lastProfileName );
		ProfileNetworkVirtualIpSelector->setCurrentText( lastProfileName );
		ProfileCertSelector->setCurrentText( lastProfileName );
		ProfileSmartcardSelector->setCurrentText( lastProfileName );
		ProfilePskSelector->setCurrentText( lastProfileName );
		ProfileUserSelector->setCurrentText( lastProfileName );
		ProfileOpenvpnSelector->setCurrentText( lastProfileName );
		ProfilePptpSelector->setCurrentText( lastProfileName );
		ProfileVtunSelector->setCurrentText( lastProfileName );
		ProfileSshSelector->setCurrentText( lastProfileName );
		ProfileRacoonSelector->setCurrentText( lastProfileName );
		ProfileIpsecSelector->setCurrentText( lastProfileName );
		ProfileCiscoSelector->setCurrentText( lastProfileName );
		ProfileCmdExecBeforeConnectSelector->setCurrentText( lastProfileName );
		ProfileCmdExecBeforeDisconnectSelector->setCurrentText( lastProfileName );
		ProfileCmdExecAfterConnectSelector->setCurrentText( lastProfileName );
		ProfileCmdExecAfterDisconnectSelector->setCurrentText( lastProfileName );

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "New profile: %1" ).arg( Name ), GlobalConfig->debug );

		profileHasChanged=true;
		NewProfileName = Name;

		ProfileCertOptionsWidget->x509certURLRequester->clear();
		ProfileCertOptionsWidget->certpathURLRequester->clear();
		ProfileUserOptionsWidget->UsernameLineEdit->clear();
		ProfilePskOptionsWidget->PSKLineEdit->clear();
		ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->clear();
		ProfileGeneralOptionsWidget->gatewayLineEdit->clear();
		ProfileNetworkRouteOptionsWidget->NetworkListView->clear();
		ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->clear();

		ProfilePskOptionsWidget->CheckSavePsk->setChecked( false );
		ProfileUserOptionsWidget->CheckUserPass->setChecked( false );
		ProfileCiscoOptionsWidget->IDLineEdit->clear();
		ProfileUserOptionsWidget->UsernameLineEdit->clear();
		ProfileUserOptionsWidget->PasswordEdit->clear();
		ProfileCmdExecBeforeConnectOptionsWidget->CmdBeforeConnectTextEdit->setEnabled( false );
		ProfileCmdExecAfterConnectOptionsWidget->CmdAfterConnectTextEdit->setEnabled( false );
		ProfileCmdExecBeforeDisconnectOptionsWidget->CmdBeforeDisconnectTextEdit->setEnabled( false );
		ProfileCmdExecAfterDisconnectOptionsWidget->CmdAfterDisconnectTextEdit->setEnabled( false );
		ProfileCmdExecBeforeConnectOptionsWidget->ExcuteCmdBeforeConnectCheckBox->setChecked( false );
		ProfileCmdExecAfterConnectOptionsWidget->ExcuteCmdAfterConnectCheckBox->setChecked( false );
		ProfileCmdExecBeforeDisconnectOptionsWidget->ExcuteCmdBeforeDisconnectCheckBox->setChecked( false );
		ProfileCmdExecAfterDisconnectOptionsWidget->ExcuteCmdAfterDisconnectCheckBox->setChecked( false );
		ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked( false );
		ProfileCertOptionsWidget->UseSpecialServerCertificateCheckBox->setChecked( false );

		ProfilePptpOptionsWidget->RequireMppeCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->Refuse128BitEncryptionCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->Refuse40BitEncryptionCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->UseNoMPPECompressionCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->DnsServerCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->DnsServerLineedit->clear();
		ProfilePptpOptionsWidget->AllowStatefulModeCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->UseNoBsdCompCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->UseNoDeflateCheckbox->setChecked( false );
		ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setValue( 1500 );
		ProfileNetworkGeneralOptionsWidget->MruSpinbox->setValue( 1500 );
		ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setChecked( false );
		ProfileNetworkGeneralOptionsWidget->MruCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->DisableCcpCheckbox->setChecked( false );

		ProfileNetworkVirtualIpOptionsWidget->setEnabled( false );
		ProfileVtunOptionsWidget->setEnabled( false );

		ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->setEnabled(false);
		ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeLabel->setEnabled(false);
		ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->MruCheckbox->setEnabled( false );

		ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentText( "24" );
		ProfileGeneralOptionsWidget->DescriptionLineEdit->setText( it->getDescription() );
		ProfileGeneralOptionsWidget->gatewayLineEdit->setText( it->getGateway() );


		if (GlobalConfig->currentProfile->getTunnelDeviceType() == TQString("tap"))
			ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->setCurrentItem(1);
		else
			ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->setCurrentItem(0);


		// 	AdvancedSettingsPushButton->setEnabled( false );
		if ( ( it->getNetworkDevice() ).isEmpty() )
		{
			ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setCurrentText( "default" );

			if ( GlobalConfig->KvpncDebugLevel > 2 )
				GlobalConfig->appendLogEntry( i18n( "profile \"%1\": no network device defined, using \"default\"." ).arg( it->getName() ), GlobalConfig->debug );
		}
		else
		{
			ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setCurrentText( it->getNetworkDevice() );

			if ( GlobalConfig->KvpncDebugLevel > 2 )
				GlobalConfig->appendLogEntry( i18n( "profile \"%1\": network device defined, using \"%2\"." ).arg( it->getName() ).arg( it->getNetworkDevice() ), GlobalConfig->debug );
		}

		ProfileGeneralOptionsWidget->ConnectionTypeComboBox->setCurrentItem( it->getConnectionType() );
		// 	KMessageBox::information(0,"profilechanged() new conntype: "+TQString().setNum(it->getConnectionType()),TQString("type set"));

		ProfileGeneralOptionsWidget->gatewayLineEdit->setText( it->getGateway() );

		ProfilePskOptionsWidget->PSKLineEdit->setText( it->getPreSharedKey() );
		ProfilePskOptionsWidget->PSKFileURLRequester->setURL(it->getPreSharedKeyFile() );

		ProfileCertOptionsWidget->UseMailAddressAsIdentifierCheckBox->setChecked( it->getUseMailAddressAsIdentifier() );

		ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->setText( it->getPingHostIP() );
		ProfileNetworkGeneralOptionsWidget->PingCheckBox ->setChecked( it->getDoPingIP() );

		ProfileUserOptionsWidget->UsernameLineEdit->setText( it->getUserName() );
		ProfileUserOptionsWidget->PasswordEdit->setText( it->getUserPassword() );
		ProfileUserOptionsWidget->CheckUserPass->setChecked( it->getSaveUserPassword() );

		if ( it->getUseUdp() )
			ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked( true );
		else
			ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked( false );

		if ( it->getUseNat() )
			ProfileNetworkNatOptionsWidget->UseNatCheckbox->setChecked( true );
		else
			ProfileNetworkNatOptionsWidget->UseNatCheckbox->setChecked( false );


		ProfileNetworkNatOptionsWidget->UdpPortSpinbox->setValue( it->getUdpPort() );
		if ( it->getUseUdpPort() )
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked( true );
		else
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked( false );

		ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
		ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		if ( it->getUseUdp() )
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		else
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( false );

		if ( it->getConnectionType() == VpnAccountData::openvpn )
			connect ( ProfileNetworkNatOptionsWidget->UseUdpCheckbox, TQT_SIGNAL( toggled( bool ) ), this, TQT_SLOT( useUdpToggled( bool ) ) );
		else
			disconnect ( ProfileNetworkNatOptionsWidget->UseUdpCheckbox, TQT_SIGNAL( toggled( bool ) ), this, TQT_SLOT( useUdpToggled( bool ) ) );


		ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setChecked( it->getUseMtu() );
		ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setValue( it->getMtu() );
		ProfileNetworkGeneralOptionsWidget->MruCheckbox->setChecked( it->getUseMru() );
		ProfileNetworkGeneralOptionsWidget->MruSpinbox->setValue( it->getMru() );
		ProfileNetworkGeneralOptionsWidget->FixPathMtuDiscoveryProblemCheckBox->setChecked(it->getFixPathMtuDiscoveryProblem());

		if ( it->getConnectionType() == VpnAccountData::cisco          ||
		     it->getConnectionType() == VpnAccountData::pptp           ||
		     it->getConnectionType() == VpnAccountData::freeswan       ||
		     it->getConnectionType() == VpnAccountData::l2tpd_freeswan ||
		     it->getConnectionType() == VpnAccountData::openvpn)
		{
			ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setEnabled( true );
			ProfileNetworkGeneralOptionsWidget->MruCheckbox->setEnabled( true );

			if ( GlobalConfig->currentProfile->getUseMtu() )
				ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled( true );
			else
				ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled( false );

			if ( GlobalConfig->currentProfile->getUseMru() )
				ProfileNetworkGeneralOptionsWidget->MruSpinbox->setEnabled( true );
			else
				ProfileNetworkGeneralOptionsWidget->MruSpinbox->setEnabled( false );
		}

		ProfileNetworkGeneralOptionsWidget->UseReconnectDelayCheckBox->setChecked( it->getUseReconnectDelay() );
		ProfileNetworkGeneralOptionsWidget->ReconnectDelayNumInput->setEnabled( it->getUseReconnectDelay() );
		ProfileNetworkGeneralOptionsWidget->ReconnectDelayNumInput->setValue( it->getReconnectDelay() );

		 if ( it->getConnectionType() == VpnAccountData::ConnectionType( VpnAccountData::l2tpd_racoon ) || it->getConnectionType() == VpnAccountData::ConnectionType( VpnAccountData::racoon ) || it->getConnectionType() == VpnAccountData::ConnectionType( VpnAccountData::freeswan ) || it->getConnectionType() == VpnAccountData::ConnectionType( VpnAccountData::l2tpd_freeswan ) ||  it->getConnectionType() == VpnAccountData::ConnectionType( VpnAccountData::openvpn ) ||  it->getConnectionType() == VpnAccountData::ConnectionType( VpnAccountData::ciscoorig ))
		{
			if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::cert)
			{

				if (GlobalConfig->currentProfile->getUseSmartcard() && ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->isEnabled() )
				{
					ProfileCertOptionsWidget->x509certURLRequester->setEnabled(false);
					ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled(false);
					ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setEnabled(false);
					ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled(false);
					ProfileCertOptionsWidget->LabelCertificate->setEnabled(false);
					ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled(false);
					ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(false);
				}
				else
				{
					ProfileCertOptionsWidget->x509certURLRequester->setEnabled(true);
					ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled(true);
					ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setEnabled(true);
					ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled(true);
					ProfileCertOptionsWidget->LabelCertificate->setEnabled(true);
					ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled(true);
					ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(true);
				}
			}
		}

		ProfileCertOptionsWidget->LabelPrivateKeyPassword->setText(i18n("Private key passphrase:"));
		ProfileCertOptionsWidget->LabelCertificate->setText(i18n("Certificate:"));
		ProfileCertOptionsWidget->x509certURLRequester->show();
		ProfileCertOptionsWidget->x509certURLRequester->sizeHint();
		ProfileCertOptionsWidget->x509certComboBox->hide();
		ProfileCertOptionsWidget->UseCiscoCertStoreCheckBox->hide();
		ProfileCertOptionsWidget->VerifyCaCertCheckBox->setEnabled(false);
		ProfileCertOptionsWidget->setEnabled (true);

		ProfileCertOptionsWidget->AuthTypeComboBox->clear();
		ProfilePskOptionsWidget->AuthTypeComboBox->clear();

		ProfileUserOptionsWidget->AskUserPasswordOnEachConnectCheckBox->setChecked(it->getAskUserPasswordOnEachConnect());
		// FIXME: implement in all types
		if (it->getConnectionType() == VpnAccountData::cisco || it->getConnectionType() == VpnAccountData::ciscoorig || it->getConnectionType() == VpnAccountData::l2tpd_racoon || it->getConnectionType() == VpnAccountData::l2tpd_freeswan|| it->getConnectionType() == VpnAccountData::pptp || it->getConnectionType() == VpnAccountData::openvpn || it->getConnectionType() == VpnAccountData::vtun || it->getConnectionType() == VpnAccountData::ssh)
		{
			ProfileUserOptionsWidget->AskUserPasswordOnEachConnectCheckBox->setEnabled(true);
		}
		else
			ProfileUserOptionsWidget->AskUserPasswordOnEachConnectCheckBox->setEnabled(false);

		if (it->getConnectionType() == VpnAccountData::freeswan  || it->getConnectionType() ==  VpnAccountData::l2tpd_freeswan ||  it->getConnectionType() == VpnAccountData::pptp ||  it->getConnectionType() == VpnAccountData::openvpn || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::vtun)
		{
    			ProfileCertOptionsWidget->AuthTypeComboBox->insertItem( i18n( "X.509 Certificate" ) );
    			ProfileCertOptionsWidget->AuthTypeComboBox->insertItem( i18n( "Pre Shared Key" ) );
    			ProfilePskOptionsWidget->AuthTypeComboBox->insertItem( i18n( "X.509 Certificate" ) );
    			ProfilePskOptionsWidget->AuthTypeComboBox->insertItem( i18n( "Pre Shared Key" ) );
		}
		
		ProfileCertOptionsWidget->UseMailAddressAsIdentifierCheckBox->show();
		ProfileCertOptionsWidget->UseSpecialServerCertificateCheckBox->show();

		ProfileCertOptionsWidget->LabelAuthType->setEnabled( true );
		ProfilePskOptionsWidget->LabelAuthType->setEnabled( true );

		/* connection specific */
		if ( it->getConnectionType() == VpnAccountData::cisco || it->getConnectionType() == VpnAccountData::ciscoorig ) 
		{
			bool vpncHasHybridSupport = false;
			ProfilePskOptionsWidget->CheckSavePsk->setChecked( it->getSavePsk() );
			ProfileUserOptionsWidget->CheckUserPass->setChecked ( it->getSaveUserPassword() );
			ProfileCiscoOptionsWidget->IDLineEdit->setText( it->getID() );
			ProfileUserOptionsWidget->UsernameLineEdit->setText ( it->getUserName() );
			ProfilePskOptionsWidget->PSKLineEdit->setText( it->getPreSharedKey() );
			ProfileUserOptionsWidget->PasswordEdit->setText ( it->getUserPassword() );
			ProfileUserOptionsWidget->DontSaveUsernameCheckBox->setChecked(it->getDontSaveUsername() );
			ProfileUserOptionsWidget->HideGroupPasswordInAccountDataDialogCheckBox->show();
			ProfileUserOptionsWidget->HideGroupPasswordInAccountDataDialogCheckBox->setChecked(it->getHideGroupPasswordInAccountDataDialog());

			if ( it->getAuthType() == VpnAccountData::cert )
			{
// 				ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled(true);
// 				ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled(true);
// 				ProfileCertOptionsWidget->x509certComboBox->setEnabled(true);
// 				ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(true);
				ProfileCertOptionsWidget->setEnabled(true);
				ProfileCertOptionsWidget->x509certURLRequester->setURL( it->getX509Certificate() );

			}
			if ( it->getAuthType() == VpnAccountData::psk || it->getAuthType() == VpnAccountData::hybrid )
			{
				ProfilePskOptionsWidget->PSKLineEdit->setText( it->getPreSharedKey() );
				ProfilePskOptionsWidget->CheckSavePsk->setChecked( it->getSavePsk() );
				ProfilePskOptionsWidget->PskGroupBox->setEnabled( true );
				ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( true );
				ProfileCiscoOptionsWidget->LabelID->setEnabled( true );
				ProfileCiscoOptionsWidget->AllowEmptyGroupPasswordCheckBox->setChecked ( it->getAllowEmptyGroupPassword() );

// 				ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled(false);
// 				ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled(false);
// 				ProfileCertOptionsWidget->x509certComboBox->setEnabled(false);
// 				ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(false);
			}

			if ( it->getConnectionType() == VpnAccountData::ciscoorig)
			{
				ProfileCertOptionsWidget->AuthTypeComboBox->insertItem( i18n( "X.509 Certificate" ) );
				ProfileCertOptionsWidget->AuthTypeComboBox->insertItem( i18n( "Pre Shared Key" ) );
				ProfilePskOptionsWidget->AuthTypeComboBox->insertItem( i18n( "X.509 Certificate" ) );
				ProfilePskOptionsWidget->AuthTypeComboBox->insertItem( i18n( "Pre Shared Key" ) );
				ProfileCertOptionsWidget->AuthTypeComboBox->insertItem( i18n( "Hybrid" ) );
				ProfilePskOptionsWidget->AuthTypeComboBox->insertItem( i18n( "Hybrid" ) );
				
				ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled( true );
				ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled( true );
				
				if ( it->getAuthType() == VpnAccountData::cert || it->getAuthType() == VpnAccountData::hybrid )
				{
					ProfileCertOptionsWidget->UseMailAddressAsIdentifierCheckBox->hide();
					ProfileCertOptionsWidget->UseSpecialServerCertificateCheckBox->hide();
					if (it->getAuthType() == VpnAccountData::cert )
					{
						ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentText( i18n( "X.509 Certificate" ) );
						ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentText( i18n( "X.509 Certificate" ) );
					}
					else
					{
						ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentText( i18n( "Hybrid" ) );
						ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentText( i18n( "Hybrid" ) );
					}
					ProfileCertOptionsWidget->PrivkeyPasswordEdit->setText( it->getPrivateKeyPass() );
					ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setChecked( it->getSavePrivateKeyPassword() );
					//emit useCiscoCertStoreToggled(it->getSavePrivateKeyPassword());
					ProfileCertOptionsWidget->UseCiscoCertStoreCheckBox->show();
					ProfileCertOptionsWidget->UseCiscoCertStoreCheckBox->setChecked(it->getUseCiscoCertStore());
					if (it->getUseCiscoCertStore())
					{
						ProfileCertOptionsWidget->x509certURLRequester->hide();
						ProfileCertOptionsWidget->x509certComboBox->show();
						ProfileCertOptionsWidget->CaCertpathURLRequester->hide();
						ProfileCertOptionsWidget->CaCertpathComboBox->show();
						ProfileCertOptionsWidget->x509certComboBox->sizeHint();
						ProfileCertOptionsWidget->sizeHint();
						ProfileCertOptionsWidget->UseCiscoCertStoreCheckBox->setChecked(true);
					}
					else
					{
						ProfileCertOptionsWidget->x509certURLRequester->show();
						ProfileCertOptionsWidget->CaCertpathURLRequester->show();
						ProfileCertOptionsWidget->x509certComboBox->hide();
						ProfileCertOptionsWidget->CaCertpathComboBox->hide();
						ProfileCertOptionsWidget->x509certComboBox->sizeHint();
						ProfileCertOptionsWidget->sizeHint();
						ProfileCertOptionsWidget->UseCiscoCertStoreCheckBox->setChecked(false);
					}
					
					ProfileCertOptionsWidget->x509certComboBox->clear();
					for ( TQStringList::Iterator ciscoit = CiscoCerts.begin(); ciscoit != CiscoCerts.end(); ++ciscoit )
					{
						//std::cout << "insert item (cisco certs):  " << TQString(*ciscoit) << std::endl;
	
						if (GlobalConfig->KvpncDebugLevel > 4)
							GlobalConfig->appendLogEntry(i18n("insert cisco cert:")+" "+TQString(*ciscoit),GlobalConfig->debug);
						ProfileCertOptionsWidget->x509certComboBox->insertItem( TQString(*ciscoit));
					}
					if (!it->getX509Certificate().isEmpty())
						ProfileCertOptionsWidget->x509certComboBox->setCurrentText( it->getX509Certificate() );
					ProfileCertOptionsWidget->x509certURLRequester->setURL( it->getX509Certificate() );
					
					ProfileCertOptionsWidget->CaCertpathComboBox->clear();
					for ( TQStringList::Iterator ciscocait = CiscoCaCerts.begin(); ciscocait != CiscoCaCerts.end(); ++ciscocait )
					{
						//std::cout << "insert item (cisco certs):  " << TQString(*ciscocait) << std::endl;
	
						if (GlobalConfig->KvpncDebugLevel > 4)
							GlobalConfig->appendLogEntry(i18n("insert cisco ca cert:")+" "+TQString(*ciscocait),GlobalConfig->debug);
						ProfileCertOptionsWidget->CaCertpathComboBox->insertItem( TQString(*ciscocait));
					}
					if (!it->getCaCertificate().isEmpty())
						ProfileCertOptionsWidget->CaCertpathComboBox->setCurrentText( it->getCaCertificate() );
				}
				else
				{
					ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentText(  i18n( "Pre Shared Key" ) );
					ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentText(  i18n( "Pre Shared Key" ) );
				}

				ProfileCertOptionsWidget->LabelPrivateKeyPassword->setText("Certificate password:");
				// ProfileCertOptionsWidget->LabelCertificate->setText(i18n("Certificate (enter name here):"));

				if (!it->getX509Certificate().isEmpty())
				{
					ProfileCertOptionsWidget->x509certComboBox->setCurrentText(it->getX509Certificate());
					ProfileCertOptionsWidget->x509certURLRequester->setURL(it->getX509Certificate());
				}
				else
				{
					ProfileCertOptionsWidget->x509certComboBox->setCurrentItem(0);
				}
			}
			if ( it->getConnectionType() == VpnAccountData::cisco)
			{
				ProfileCertOptionsWidget->AuthTypeComboBox->insertItem( i18n( "Pre Shared Key" ) );
    				ProfilePskOptionsWidget->AuthTypeComboBox->insertItem( i18n( "Pre Shared Key" ) );
				ProfileCertOptionsWidget->x509certComboBox->hide();
				ProfileCertOptionsWidget->CaCertpathComboBox->hide();
				ToolInfo *tool;
				bool hasHybridSupport = getVpncHasHybridSupport();
				
				if (hasHybridSupport)
				{
    					ProfileCertOptionsWidget->AuthTypeComboBox->insertItem( i18n( "Hybrid" ) );
    					ProfilePskOptionsWidget->AuthTypeComboBox->insertItem( i18n( "Hybrid" ) );
					ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled( true );
					ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled( true );
					ProfileCertOptionsWidget->CaCertpathURLRequester->setURL(GlobalConfig->currentProfile->getCaCertificate());
					ProfileCertOptionsWidget->certpathURLRequester->setURL( GlobalConfig->currentProfile->getCertPath() );
					ProfileCertOptionsWidget->VerifyCaCertCheckBox->setChecked(GlobalConfig->currentProfile->getVerifyCaCert());
					ProfileCertOptionsWidget->PrivkeyPasswordEdit->setText(GlobalConfig->currentProfile->getPrivateKeyPass());
					ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setChecked(GlobalConfig->currentProfile->getSavePrivateKeyPassword());
					if (it->getAuthType() == VpnAccountData::psk )
					{
						ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentText( i18n( "Pre Shared Key" ) );
						ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentText( i18n( "Pre Shared Key" ) );
					}
					else
					{
						ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentText( i18n( "Hybrid" ) );
						ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentText( i18n( "Hybrid" ) );
					}
					GlobalConfig->appendLogEntry ( i18n ( "Hybrid support detected, enabling cert options" ),GlobalConfig->debug );
				}
				else
				{
					ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentText( i18n( "Pre Shared Key" ) ); // PSK
					ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled( false );
					ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled( false );
					ProfileCertOptionsWidget->setEnabled (false);
					GlobalConfig->appendLogEntry ( i18n ( "Hybrid support not detected, disabling cert options" ),GlobalConfig->debug );
				}
			}
			
			ProfileCiscoOptionsWidget->UseXauthInteractiveCheckBox->setChecked( it->getUseXauthInteractive() );
			ProfileCiscoOptionsWidget->LocalPortCheckbox->setChecked ( it->getUseLocalPort() );
			ProfileCiscoOptionsWidget->LocalPortSpinbox->setValue( it->getLocalPort() );
			
			int vpnc_version_major = 0;
			int vpnc_version_minor = 2;
			int vpnc_version_subminor = 1;

			ToolInfo *Tool = Utils( GlobalConfig ).getToolInfo ( "vpnc" );
			if ( !Tool->Version.isEmpty() )
			{
				vpnc_version_major = ( Tool->Version.section( '.', 0, 0 ) ).toInt();
				vpnc_version_minor = ( Tool->Version.section( '.', 1, 1 ) ).toInt();
				vpnc_version_subminor = ( Tool->Version.section( '.', 2, 2 ) ).toInt();
			}

			if ( vpnc_version_major ==0 && vpnc_version_minor < 3 )
			{
				GlobalConfig->appendLogEntry( i18n( "%1 is too old. Minimum requirement is %2, disabling Xauth interactive option." ).arg( "vpnc" ).arg( "0.3.x" ), GlobalConfig->error );
				ProfileCiscoOptionsWidget->UseXauthInteractiveCheckBox->setEnabled( false );
			}

    			if ( it->getConnectionType() == VpnAccountData::cisco)
			{
				if ( (vpnc_version_major == 0 && vpnc_version_minor >= 5 ) || ( vpnc_version_major > 0 ))
				{
					std::cout << "vpnc >= 0.5.0" << std::endl;
					ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox->setEnabled(true);
					ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox->setChecked(it->getUseDpdIdleTimeout());
				}
				else
				{
					std::cout << "vpnc < 0.5.0" << std::endl;
					ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox->setEnabled(false);
					ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox->setChecked(false);
				}
				
				ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox->show();
				TQWhatsThis::add( ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox, i18n( "This enables DPD. Requires vpnc >= 0.5.0." ) );
			}
			if ( it->getConnectionType() == VpnAccountData::ciscoorig)
			{
				ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox->setChecked(true);
				ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox->hide();
				TQWhatsThis::add( ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox, i18n( "This enables DPD." ) );
			}
			ProfileCiscoOptionsWidget->DpdIdleTimeoutSpinbox->setValue(it->getDpdIdleTimeout());



			if ( it->getUseUdp() )
				ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked( true );
			else
				ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked( false );

			ProfileNetworkNatOptionsWidget->UdpPortSpinbox->setValue( it->getUdpPort() );
			if ( it->getUseUdpPort() )
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked( true );
			else
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked( false );

			ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
			if ( it->getUseUdp() )
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
			else
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( false );

			ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( false );
			ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( false );
			ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( false );

			ProfilePptpOptionsWidget->setEnabled( false );
			ProfileOpenvpnOptionsWidget->setEnabled( false );
			ProfileCiscoOptionsWidget->setEnabled( true );
			ProfileRacoonOptionsWidget->setEnabled( false );
			ProfileIpsecOptionsWidget->setEnabled( false );
			ProfileSshOptionsWidget->setEnabled( false );

			ProfileCiscoOptionsWidget->PeerTimeoutIntNumInput->setValue( it->getPeerTimeout() );

			ProfileUserOptionsWidget->NtDomainNameCheckbox->setEnabled( true );
			ProfileUserOptionsWidget->NtDomainNameLineedit->setEnabled ( false );
			ProfileUserOptionsWidget->NtDomainNameLineedit->setText( it->getNtDomainName() );
			if ( it->getUseNtDomainName() )
			{
				ProfileUserOptionsWidget->NtDomainNameLineedit->setEnabled ( true );
				ProfileUserOptionsWidget->NtDomainNameCheckbox->setChecked( true );
			}

			ProfilePptpOptionsWidget->UseSearchDomainInResolvConfCheckbox->setEnabled(true);
			ProfilePptpOptionsWidget->SearchDomainInResolvConfLineedit->setEnabled(false);
			if ( it->getUseSearchDomainInResolvConf() )
			{
				ProfilePptpOptionsWidget->SearchDomainInResolvConfLineedit->setEnabled ( true );
				ProfilePptpOptionsWidget->UseSearchDomainInResolvConfCheckbox->setChecked( true );
			}
			ProfilePptpOptionsWidget->SearchDomainInResolvConfLineedit->setText(it->getSearchDomainInResolvConf());



			if ( it->getUseGlobalIpsecSecret() )
				ProfileCiscoOptionsWidget->UseGlobalIpsecSecretCheckbox->setChecked ( true );
			else
				ProfileCiscoOptionsWidget->UseGlobalIpsecSecretCheckbox->setChecked ( false );

			ProfileCiscoOptionsWidget->UseGlobalIpsecSecretCheckbox->setChecked ( it->getUseGlobalIpsecSecret() );
			

			//FIXME
			// 			ProfileNetworkRouteOptionsWidget->InterfaceComboBox->insertItem("tun0");
			ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->setEnabled(true);
			ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeLabel->setEnabled(true);

			if ( it->getConnectionType() == VpnAccountData::ConnectionType( VpnAccountData::cisco ))
			{

				ProfileCiscoOptionsWidget->SingleDesCheckbox->setChecked ( false );
				ProfileCiscoOptionsWidget->IkeGroupCombobox->setEnabled( false );
				ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled( false );
				ProfileCiscoOptionsWidget->PerfectForwardSecurityCheckbox->setChecked ( false );
				ProfileCiscoOptionsWidget->ApplicationVersionLineedit->setEnabled ( false );
				ProfileCiscoOptionsWidget->IkeGroupCombobox->setCurrentText ( it->getIkeGroup() );
				ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->setCurrentText ( it->getPerfectForwardSecrety() );
				ProfileCiscoOptionsWidget->ApplicationVersionLineedit->setText ( it->getApplicationVersion() );
	
				ProfileCiscoOptionsWidget->IkeGroupCheckbox->setEnabled ( true );
				ProfileCiscoOptionsWidget->PerfectForwardSecurityCheckbox->setEnabled ( true );
				ProfileCiscoOptionsWidget->SingleDesCheckbox->setEnabled ( true );
				ProfileCiscoOptionsWidget->ApplicationVersionCheckbox->setEnabled ( true );
	
				if ( it->getUseSingleDes() )
				{
					ProfileCiscoOptionsWidget->SingleDesCheckbox->setChecked ( true );
				}
	
				if ( it->getUseIkeGroup() )
				{
					ProfileCiscoOptionsWidget->IkeGroupCheckbox->setChecked ( true );
					ProfileCiscoOptionsWidget->IkeGroupCombobox->setEnabled ( true );
				}
	
				if ( it->getUsePerfectForwardSecrety() )
				{
					ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled ( true );
					ProfileCiscoOptionsWidget->PerfectForwardSecurityCheckbox->setChecked ( true );
				}
				else
				{
					ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled ( false );
					ProfileCiscoOptionsWidget->PerfectForwardSecurityCheckbox->setChecked ( false );
				}
	
				if ( it->getUseApplicationVersion() )
				{
					ProfileCiscoOptionsWidget->ApplicationVersionLineedit->setEnabled ( true );
					ProfileCiscoOptionsWidget->ApplicationVersionCheckbox->setChecked ( true );
				}
				ProfileCiscoOptionsWidget->DisableDataEncryptionCheckbox->setChecked(it->getDisableDataEncryption());
			}
			else
			{
				ProfileCiscoOptionsWidget->SingleDesCheckbox->setEnabled( false );
				ProfileCiscoOptionsWidget->IkeGroupCombobox->setEnabled( false );
				ProfileCiscoOptionsWidget->IkeGroupCombobox->setCurrentText ( it->getIkeGroup() );
				ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled( false );
				ProfileCiscoOptionsWidget->PerfectForwardSecurityCheckbox->setChecked ( false );
				ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->setCurrentText ( it->getPerfectForwardSecrety() );
				ProfileCiscoOptionsWidget->ApplicationVersionLineedit->setEnabled ( false );
				ProfileCiscoOptionsWidget->ApplicationVersionLineedit->setText ( it->getApplicationVersion() );
			}
		} // vpnc

		else if ( it->getConnectionType() == VpnAccountData::l2tpd_racoon  || it->getConnectionType() == VpnAccountData::racoon  || it->getConnectionType() == VpnAccountData::freeswan  || it->getConnectionType() ==  VpnAccountData::l2tpd_freeswan  )
		{
			ProfileNetworkGeneralOptionsWidget->UseRemoteNetworkCheckBox->setChecked(it->getUseRemoteNetwork());
			ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setText( it->getRemoteNetAddr() );
			if ( !it->getRemoteNetMask().isEmpty() )
				ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentText( it->getRemoteNetMask() );

			ProfileCertOptionsWidget->x509certComboBox->hide();
			ProfileCertOptionsWidget->CaCertpathComboBox->hide();

			if (it->getConnectionType() == VpnAccountData::freeswan  || it->getConnectionType() ==  VpnAccountData::l2tpd_freeswan)
			{
				if ( it->getAuthType() == VpnAccountData::cert )
				{
					ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentItem( 0 );
					ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentItem( 0 );
				}
				if ( it->getAuthType() == VpnAccountData::psk )
				{
					ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentText(  i18n( "Pre Shared Key" ) );
					ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentText(  i18n( "Pre Shared Key" ) );
				}
			}
			if (it->getConnectionType() == VpnAccountData::l2tpd_racoon  || it->getConnectionType() == VpnAccountData::racoon)
			{
				ProfileCertOptionsWidget->AuthTypeComboBox->insertItem( i18n( "X.509 Certificate" ) );
				ProfileCertOptionsWidget->AuthTypeComboBox->insertItem( i18n( "Pre Shared Key" ) );
				ProfilePskOptionsWidget->AuthTypeComboBox->insertItem( i18n( "X.509 Certificate" ) );
				ProfilePskOptionsWidget->AuthTypeComboBox->insertItem( i18n( "Pre Shared Key" ) );
				ProfileCertOptionsWidget->AuthTypeComboBox->insertItem( i18n( "Hybrid" ) );
				ProfilePskOptionsWidget->AuthTypeComboBox->insertItem( i18n( "Hybrid" ) );
				if ( it->getAuthType() == VpnAccountData::cert )
				{
					ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentText( i18n( "X.509 Certificate" ) );
					ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentText( i18n( "X.509 Certificate" ) );
				}
				if ( it->getAuthType() == VpnAccountData::psk )
				{
					ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentText(  i18n( "Pre Shared Key" ) );
					ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentText(  i18n( "Pre Shared Key" ) );
				}
				if ( it->getAuthType() == VpnAccountData::hybrid )
				{
					// hybrid
					ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentText( i18n( "Hybrid" ) );
					ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentText( i18n( "Hybrid" ) );
				}
				ProfileRacoonOptionsWidget->RemoteIDLineEdit->setText( it->getSpecialRemoteID() );

			}

			ProfileCertOptionsWidget->x509certURLRequester->setURL( it->getX509Certificate() );
			ProfileCertOptionsWidget->CaCertpathURLRequester->setURL( it->getCaCertificate() );
			ProfileCertOptionsWidget->certpathURLRequester->setURL( it->getCertPath() );
// 			std::cout << "certPath: " << it->getCertPath() << std::endl;
			ProfileCertOptionsWidget->PrivkeyPasswordEdit->setText( it->getPrivateKeyPass() );
			ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setChecked( it->getSavePrivateKeyPassword() );
			ProfileCertOptionsWidget->privkeypathURLRequester->setURL( it->getPrivateKey() );
// 			std::cout << "privateKey: " << it->getPrivateKey() << std::endl;
			ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->setEnabled(it->getUseSpecialServerCertificate());

			ProfileNetworkGeneralOptionsWidget->PingCheckBox->setChecked( it->getDoPingIP() );
			ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->setText( it->getPingHostIP() );

			ProfilePskOptionsWidget->PSKLineEdit->setText( it->getPreSharedKey() );
			ProfilePskOptionsWidget->CheckSavePsk->setChecked( it->getSavePsk() );

			ProfileIpsecOptionsWidget->UseRightNextHopCheckBox->setChecked(it->getUseRightNextHop());
			ProfileIpsecOptionsWidget->UseLeftNextHopCheckBox->setChecked(it->getUseLeftNextHop());
			ProfileIpsecOptionsWidget->LeftNextHopLineEdit->setText( it->getLeftNextHop() );
			ProfileIpsecOptionsWidget->RightNextHopLineEdit->setText( it->getRightNextHop() );
			ProfileIpsecOptionsWidget->DisableOpportunisticEncryptionCheckBox->setChecked( it->getDisableOpportunisticEncryption() );
			ProfileRacoonOptionsWidget->LocalIDLineEdit->setText(it->getSpecialLocalID());
			ProfileIpsecOptionsWidget->LocalIDLineEdit->setText(it->getSpecialLocalID());
			ProfileRacoonOptionsWidget->RemoteIDLineEdit->setText(it->getSpecialRemoteID());
			ProfileIpsecOptionsWidget->RemoteIDLineEdit->setText(it->getSpecialRemoteID());
//  			ProfileRacoonOptionsWidget->UseSpecialLocalIDcheckBox->setChecked(it->getUseSpecialLocalID());

			if (it->getIpsecVpnMode() == "transport")
				ProfileIpsecOptionsWidget->IpsecVpnModeCombobox->setCurrentText("transport");
			else
				ProfileIpsecOptionsWidget->IpsecVpnModeCombobox->setCurrentItem("tunnel");


			if (it->getLocalIDType() =="")
				it->setLocalIDType("none");

			if (it->getRemoteIDType() =="")
				it->setRemoteIDType("none");

			ProfileRacoonOptionsWidget->LocalIdTypeCombobox->setCurrentText(it->getLocalIDType());
			ProfileRacoonOptionsWidget->RemoteIdTypeCombobox->setCurrentText(it->getRemoteIDType());

			ProfileIpsecOptionsWidget->LocalIdTypeCombobox->setCurrentText(it->getLocalIDType());
			ProfileIpsecOptionsWidget->RemoteIdTypeCombobox->setCurrentText(it->getRemoteIDType());

			ProfileRacoonOptionsWidget->LocalIDLineEdit->setText(it->getSpecialLocalID());
			ProfileRacoonOptionsWidget->RemoteIDLineEdit->setText(it->getSpecialRemoteID());

			ProfileIpsecOptionsWidget->LocalIDLineEdit->setText(it->getSpecialLocalID());
			ProfileRacoonOptionsWidget->RemoteIDLineEdit->setText(it->getSpecialRemoteID());

			ProfileRacoonOptionsWidget->localIDTypeToggled(it->getLocalIDType());
			ProfileRacoonOptionsWidget->remoteIDTypeToggled(it->getRemoteIDType());
			ProfileIpsecOptionsWidget->localIDTypeToggled(it->getLocalIDType());
			ProfileIpsecOptionsWidget->remoteIDTypeToggled(it->getRemoteIDType());

			// TODO made it useable for freeswan
			if ( it->getConnectionType() == VpnAccountData::freeswan || it->getConnectionType() == VpnAccountData::l2tpd_freeswan)
			{
				if (it->getConnectionType() == VpnAccountData::l2tpd_freeswan)
				{
					ProfilePptpOptionsWidget->setEnabled( true );
				}
				else
				{
					ProfilePptpOptionsWidget->setEnabled( false );
				}
				ProfileOpenvpnOptionsWidget->setEnabled( false );
				ProfileCiscoOptionsWidget->setEnabled( false );
				ProfileRacoonOptionsWidget->setEnabled( false );
				ProfileIpsecOptionsWidget->setEnabled( true );
				ProfileSshOptionsWidget->setEnabled( false );

				ProfileIpsecOptionsWidget->UseModeConfigCheckBox->hide();
				
				ProfileCertOptionsWidget->UseSpecialServerCertificateCheckBox->setChecked( it->getUseSpecialServerCertificate() );
				ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->setURL( it->getSpecialServerCertificate() );
				
				if ( it->getUseSpecialServerCertificate() )
					ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->setEnabled(true);
				else
					ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->setEnabled( false );

				// ike + esp
				if (it->getUseCustomEsp())
				{
					ProfileIpsecOptionsWidget->EspGroupBox->setEnabled(true);
					ProfileIpsecOptionsWidget->UseCustomEspCheckBox->setChecked(true);
				}
				else
				{
					ProfileIpsecOptionsWidget->EspGroupBox->setEnabled(false);
					ProfileIpsecOptionsWidget->UseCustomEspCheckBox->setChecked(false);
				}

				if (it->getUseCustomIke())
				{
					ProfileIpsecOptionsWidget->IkeGroupBox->setEnabled(true);
					ProfileIpsecOptionsWidget->UseCustomIkeCheckBox->setChecked(true);
				}
				else
				{
					ProfileIpsecOptionsWidget->IkeGroupBox->setEnabled(false);
					ProfileIpsecOptionsWidget->UseCustomIkeCheckBox->setChecked(false);
				}

				TQStringList IkeList= TQStringList::split(",", it->getIpsecIke());
				TQStringList EspList= TQStringList::split(",", it->getIpsecEsp());
				TQString IkeOther="";
				TQString EspOther="";

				for ( TQStringList::Iterator ikeit = IkeList.begin(); ikeit != IkeList.end(); ++ikeit )
				{
					std::cout << "ike: " << *ikeit << ":" << std::endl;

					if (*ikeit == "aes256-sha1")
						ProfileIpsecOptionsWidget->IkeAes256Sha1CheckBox->setChecked(true);
					else if (*ikeit == "aes128-sha1")
						ProfileIpsecOptionsWidget->IkeAes128Sha1CheckBox->setChecked(true);
					else if (*ikeit == "3des-sha1-modp2048")
						ProfileIpsecOptionsWidget->IkeDesSha1Modp2048CheckBox->setChecked(true);
					else if (*ikeit == "3des-md5")
						ProfileIpsecOptionsWidget->IkeDesMd5CheckBox->setChecked(true);
					else if (*ikeit == "3des-sha1")
						ProfileIpsecOptionsWidget->IkeDesSha1CheckBox->setChecked(true);
					else
					{
						if (!IkeOther.isEmpty())
							IkeOther+=",";
						IkeOther+= *ikeit;
					}
				}
				if (!IkeOther.isEmpty())
					ProfileIpsecOptionsWidget->OtherIkeLineEdit->setText(IkeOther);

				for ( TQStringList::Iterator espit = EspList.begin(); espit != EspList.end(); ++espit )
				{
					std::cout << "esp: " << *espit << ":" << std::endl;

					if (*espit == "3des-md5")
						ProfileIpsecOptionsWidget->Esp3desMd5CheckBox->setChecked(true);
					else if (*espit == "3des-sha1")
						ProfileIpsecOptionsWidget->EspDesSha1CheckBox->setChecked(true);
					else if (*espit == "aes128-sha1")
						ProfileIpsecOptionsWidget->EspAes128Sha1CheckBox->setChecked(true);
					else if (*espit == "aes256-sha1")
						ProfileIpsecOptionsWidget->EspAes256Sha1CheckBox->setChecked(true);
					else
					{
						if (!EspOther.isEmpty())
							EspOther+=",";
						EspOther+= *espit;
					}
				}
				if (!EspOther.isEmpty())
					ProfileIpsecOptionsWidget->OtherEspLineEdit->setText(EspOther);

// 				IkeAes256Sha1CheckBox->setText( tr2i18n( "aes256-sha1" ) );
// 				IkeAes128Sha1CheckBox->setText( tr2i18n( "aes128-sha1" ) );
// 				IkeDesSha1Modp2048CheckBox->setText( tr2i18n( "3des-sha1-modp2048" ) );
// 				IkeDesMd5CheckBox->setText( tr2i18n( "3des-md5" ) );
// 				IkeDesSha1CheckBox->setText( tr2i18n( "3des-sha1" ) );

// 				Esp3desMd5CheckBox->setText( tr2i18n( "3des-md5" ) );
// 				EspDesSha1CheckBox->setText( tr2i18n( "3des-sha1" ) );
// 				EspAes128Sha1CheckBox->setText( tr2i18n( "aes128-sha1" ) );
// 				EspAes256Sha1CheckBox->setText( tr2i18n( "aes256-sha1" ) );
				

				ProfileIpsecOptionsWidget->LocalIdTypeCombobox->setCurrentText(it->getLocalIDType());
				ProfileIpsecOptionsWidget->RemoteIdTypeCombobox->setCurrentText(it->getRemoteIDType());

				ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( true );
				ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( true );
				ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( true );
				
				ToolInfo *tool = Utils( GlobalConfig ).getToolInfo ( "ipsec" );
				TQString realversion = tool->Version.section( ' ', 1, 1 ).section( '/', 0, 0 ).right( tool->Version.section( ' ', 1, 1 ).section( '/', 0, 0 ).length() - 1 );
				TQString realtype = tool->Version.section( ' ', 0, 0 ).lower();

				if ( it->getConnectionType() == VpnAccountData::l2tpd_freeswan )
					ProfileUserOptionsWidget->setEnabled( true );
				else
					ProfileUserOptionsWidget->setEnabled( false );


				ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setEnabled( true );
				ProfileNetworkGeneralOptionsWidget->MruCheckbox->setEnabled( true );

				if ( it->getUseMtu() )
					ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled( true );
				else
					ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled( false );

				if ( it->getUseMru() )
					ProfileNetworkGeneralOptionsWidget->MruSpinbox->setEnabled( true );
				else
					ProfileNetworkGeneralOptionsWidget->MruSpinbox->setEnabled( false );


				ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->setEnabled( true );

				ProfileIpsecOptionsWidget->LocalIdentifierGroupBox->setEnabled ( true );

				ProfileIpsecOptionsWidget->PerfectForwardSecurityCheckbox->setText(i18n("Enable Perfect for&ward secrecy (PFS)"));
				ProfileIpsecOptionsWidget->PerfectForwardSecurityCheckbox->setChecked(it->getUsePerfectForwardSecrety());
				if (it->getPerfectForwardSecrety().isEmpty())
					it->setPerfectForwardSecrety("dh1024"); // dh group 2
				ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->setCurrentText(it->getPerfectForwardSecrety());
				if (it->getConnectionType() == VpnAccountData::l2tpd_freeswan)
				{
					ProfilePptpOptionsWidget->setEnabled( true );
					ProfileIpsecOptionsWidget->IpsecVpnModeCombobox->setCurrentText("transport");
					ProfileIpsecOptionsWidget->IpsecVpnModeCombobox->setEnabled(false);
				}
				else
				{
					ProfileIpsecOptionsWidget->IpsecVpnModeCombobox->setEnabled(true);
					ProfilePptpOptionsWidget->setEnabled( false );
					if (it->getAuthWithUsernameAndPassword())
					{
						ProfileUserOptionsWidget->setEnabled(true);
					}
					else
					{
						ProfileUserOptionsWidget->setEnabled(false);
					}

				}
				ToolInfo *IpsecToolInfo = Utils ( GlobalConfig ).getToolInfo ( "ipsec" ) ;
				TQString IpsecType;
				if ( IpsecToolInfo->Version.contains ( "Openswan" ) )
				{
					ProfileIpsecOptionsWidget->ExchangeModeComboBox->setEnabled(true);
	// 				if (GlobalConfig->currentProfile->getExchangeMode()=="main")
	// 					ProfileIpsecOptionsWidget->ExchangeModeComboBox->setCurrentItem(0);
	// 				if (GlobalConfig->currentProfile->getExchangeMode()=="aggressive")
	// 					ProfileIpsecOptionsWidget->ExchangeModeComboBox->setCurrentItem(1);
	// 				if (GlobalConfig->currentProfile->getExchangeMode()=="base")
	// 					ProfileIpsecOptionsWidget->ExchangeModeComboBox->setCurrentItem(2);
					ProfileIpsecOptionsWidget->ExchangeModeComboBox->setCurrentText(GlobalConfig->currentProfile->getExchangeMode());

				}
					
				else if ( IpsecToolInfo->Version.contains ( "strongSwan" ) )
				{
					// no aggressive mode :(
					ProfileIpsecOptionsWidget->ExchangeModeComboBox->setEnabled(false);
					ProfileIpsecOptionsWidget->ExchangeModeComboBox->setCurrentText("main");
				}


				// xauth
				if ( it->getConnectionType() == VpnAccountData::freeswan && GlobalConfig->currentProfile->getAuthType() == VpnAccountData::psk )
				{
					if (it->getAuthWithUsernameAndPassword())
					{
						ProfileIpsecOptionsWidget->UseXauthCheckBox->setChecked(true);
// 						ProfilePskOptionsWidget->setEnabled(true);
						if (it->getPskIsInFile())
						{
							TQFile PskFile(it->getPreSharedKeyFile());
							TQString Psk="";
							if (PskFile.exists())
								Psk = TQString(PskFile.readAll());
							ProfilePskOptionsWidget->PSKLineEdit->setText(Psk);
						}
						else
							ProfilePskOptionsWidget->PSKLineEdit->setText(it->getPreSharedKey());
						if (it->getSavePsk() && !ProfilePskOptionsWidget->PSKLineEdit->text().isEmpty())
							ProfilePskOptionsWidget->CheckSavePsk->setChecked(true);
						else
							ProfilePskOptionsWidget->CheckSavePsk->setChecked(true);

					}
					else
					{
						ProfileIpsecOptionsWidget->UseXauthCheckBox->setChecked(false);
// 						ProfilePskOptionsWidget->setEnabled(false);
					}
				}


				ProfileNetworkVirtualIpOptionsWidget->setEnabled(true);

				// temporary
				ProfileNetworkVirtualIpOptionsWidget->VirtualIpGroupBox->setEnabled(true);
				ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked(it->getUseVirtualIP());
				ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setText(it->getLocalVirtualIP());
				ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled(false);
				ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setText(it->getRemoteVirtualIP());


				ProfileNetworkVirtualIpOptionsWidget->SourceIpgroupBox->show();
				ProfileNetworkVirtualIpOptionsWidget->UseLeftSourceIpCheckBox->setChecked( it->getUseLeftSourceIp());
				ProfileNetworkVirtualIpOptionsWidget->UseRightSourceIpCheckBox->setChecked(it->getUseRightSourceIp());
				ProfileNetworkVirtualIpOptionsWidget->LeftSourceIpLineEdit->setText(it->getLeftSourceIp());
				ProfileNetworkVirtualIpOptionsWidget->RightSourceIpLineEdit->setText(it->getRightSourceIp());

				ProfileNetworkVirtualIpOptionsWidget->UseVirtualSubnetsCheckBox->setChecked(it->getUseVirtualSubnetworks());
				ProfileNetworkVirtualIpOptionsWidget->VirtualSubnetsLineEdit->setText(it->getVirtualSubnetworks());



			}
			else
			{
				// racoon

				ProfileRacoonOptionsWidget->setEnabled( true );
				ProfileIpsecOptionsWidget->setEnabled( false );

				ProfileRacoonOptionsWidget->HashAlgoComboBox->setEnabled( true );
				ProfileRacoonOptionsWidget->HashAlgoTextLabel->setEnabled( true );
				ProfileRacoonOptionsWidget->UseModeConfigCheckBox->setEnabled( true );
				ProfileRacoonOptionsWidget->ExchangeModeComboBox->setEnabled( true );
				ProfileRacoonOptionsWidget->LocalIdentifierGroupBox->setEnabled ( true );
				ProfileCertOptionsWidget->UseMailAddressAsIdentifierCheckBox->setEnabled ( false );
				ProfileCertOptionsWidget->UseMailAddressAsIdentifierCheckBox->setChecked(false);

				ProfileRacoonOptionsWidget->PerfectForwardSecurityCheckbox->setText(i18n("Perfect for&ward secrecy (PFS):"));
				ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->show();

				ProfileNetworkVirtualIpOptionsWidget->SourceIpgroupBox->show();
				ProfileNetworkVirtualIpOptionsWidget->UseLeftSourceIpCheckBox->setChecked( it->getUseLeftSourceIp());
				ProfileNetworkVirtualIpOptionsWidget->UseRightSourceIpCheckBox->setChecked(it->getUseRightSourceIp());
				ProfileNetworkVirtualIpOptionsWidget->LeftSourceIpLineEdit->setText(it->getLeftSourceIp());
				ProfileNetworkVirtualIpOptionsWidget->RightSourceIpLineEdit->setText(it->getRightSourceIp());				

				if ( it->getConnectionType() == VpnAccountData::racoon )
				{
					ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( true );
					ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( true );
					ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( true );
					ProfileNetworkGeneralOptionsWidget->RemoteNetDividetextLabel->setEnabled( true );
				}



				if ( it->getConnectionType() == VpnAccountData::l2tpd_racoon )
				{
					ProfileUserOptionsWidget->setEnabled( true );

		

					ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( false );
					ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( false );
					ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( false );
					ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( false );
					ProfileNetworkGeneralOptionsWidget->RemoteNetDividetextLabel->setEnabled( false );

					ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setEnabled( true );
					ProfileNetworkGeneralOptionsWidget->MruCheckbox->setEnabled( true );

					if ( GlobalConfig->currentProfile->getUseMtu() )
						ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled( true );
					else
						ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled( false );

					if ( GlobalConfig->currentProfile->getUseMru() )
						ProfileNetworkGeneralOptionsWidget->MruSpinbox->setEnabled( true );
					else
						ProfileNetworkGeneralOptionsWidget->MruSpinbox->setEnabled( false );
				}
// 				else
// 				{
// 					ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setEnabled( false );
// 					ProfileNetworkGeneralOptionsWidget->MruCheckbox->setEnabled( false );
// 				}

				ProfileRacoonOptionsWidget->IkeGroupCheckbox->setChecked ( false );
				ProfileRacoonOptionsWidget->PerfectForwardSecurityCheckbox->setChecked ( false );
				if (!it->getIkeGroup().isEmpty())
					ProfileRacoonOptionsWidget->DHGroupComboBox->setCurrentText ( it->getIkeGroup() );
				else
					ProfileRacoonOptionsWidget->DHGroupComboBox->setCurrentItem(0);

				if (!it->getPerfectForwardSecrety().isEmpty())
					ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->setCurrentText ( it->getPerfectForwardSecrety() );
				else
					ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->setCurrentItem ( 0 );
	
				if ( it->getUseIkeGroup() )
				{
					ProfileRacoonOptionsWidget->IkeGroupCheckbox->setChecked ( true );
				}
	
				if ( GlobalConfig->currentProfile->getUsePerfectForwardSecrety() )
				{
					ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled ( true );
					ProfileRacoonOptionsWidget->PerfectForwardSecurityCheckbox->setChecked ( true );
				}
	
	
				if ( it->getUseIkeGroup() )
				{
					ProfileRacoonOptionsWidget->DHGroupComboBox->setEnabled ( true );
				}

				// xauth
				if ( it->getConnectionType() == VpnAccountData::racoon && ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::psk || GlobalConfig->currentProfile->getAuthType() == VpnAccountData::hybrid ) )
				{
					if (it->getAuthWithUsernameAndPassword())
					{
						ProfileRacoonOptionsWidget->UseXauthCheckBox->setChecked(true);
// 						ProfilePskOptionsWidget->setEnabled(true);
						if (it->getPskIsInFile())
						{
							TQFile PskFile(it->getPreSharedKeyFile());
							TQString Psk="";
							if (PskFile.exists())
								Psk = TQString(PskFile.readAll());
							ProfilePskOptionsWidget->PSKLineEdit->setText(Psk);
						}
						else
							ProfilePskOptionsWidget->PSKLineEdit->setText(it->getPreSharedKey());
						if (it->getSavePsk() && !ProfilePskOptionsWidget->PSKLineEdit->text().isEmpty())
							ProfilePskOptionsWidget->CheckSavePsk->setChecked(true);
						else
							ProfilePskOptionsWidget->CheckSavePsk->setChecked(true);

					}
					else
					{
						ProfileIpsecOptionsWidget->UseXauthCheckBox->setChecked(false);
// 						ProfilePskOptionsWidget->setEnabled(false);
					}
				}

				if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::hybrid)
				{
					ProfileCertOptionsWidget->setEnabled(true);
					ProfileCertOptionsWidget->x509certComboBox->setEnabled(false);
					ProfilePskOptionsWidget->setEnabled(false);
				}

				if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::hybrid)
				{
					ProfileCertOptionsWidget->x509certURLRequester->setURL(it->getX509Certificate());
				}


			} // racoon


			// FIXME
			// 					ProfileNetworkRouteOptionsWidget->main->InterfaceComboBox->insertItem("ppp0");

			//FIXME
			// 				ProfileNetworkRouteOptionsWidget->main->InterfaceComboBox->insertItem("tun0");
			ProfileUserOptionsWidget->HideGroupPasswordInAccountDataDialogCheckBox->hide();
		}

		if (it->getConnectionType() == VpnAccountData::l2tpd_racoon ||it->getConnectionType() == VpnAccountData::l2tpd_freeswan )
		{
				if (it->getAuthMethod() == "chap")
					ProfilePptpOptionsWidget->AuthMethodComboBox->setCurrentItem(0);
				if (it->getAuthMethod() == "pap")
					ProfilePptpOptionsWidget->AuthMethodComboBox->setCurrentItem(1);
				if (it->getAuthMethod() == "mschap")
					ProfilePptpOptionsWidget->AuthMethodComboBox->setCurrentItem(2);
				if (it->getAuthMethod() == "mschap-v2")
					ProfilePptpOptionsWidget->AuthMethodComboBox->setCurrentItem(3);
			}

		if ( it->getConnectionType() == VpnAccountData::racoon || it->getConnectionType() == VpnAccountData::l2tpd_racoon )
		{

			ProfilePptpOptionsWidget->setEnabled( false );
			ProfileOpenvpnOptionsWidget->setEnabled( false );
			ProfileCiscoOptionsWidget->setEnabled( false );
			ProfileRacoonOptionsWidget->setEnabled( true );
			ProfileSshOptionsWidget->setEnabled( false );
			ProfileNetworkHttpProxyOptionsWidget ->setEnabled( false );

			if (it->getConnectionType() == VpnAccountData::l2tpd_racoon)
			{
				ProfilePptpOptionsWidget->setEnabled( true );
				ProfileUserOptionsWidget->setEnabled( true );
			}
			else
			{
				if (it->getAuthWithUsernameAndPassword())
				{
					ProfilePptpOptionsWidget->setEnabled( true );
					ProfileUserOptionsWidget->setEnabled( true );
				}
				else
				{
					ProfilePptpOptionsWidget->setEnabled( false );
					ProfileUserOptionsWidget->setEnabled( false );
				}
			}

// 			ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->clear();
// 			ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->clear();
// 
// 			TQStringList KernelCrypto = Utils( GlobalConfig ).getKernelCrypto();
// 		// 	std::cout << "kernel crypto start "  << std::endl;
// 
// 			for ( TQStringList::Iterator it = KernelCrypto.begin(); it != KernelCrypto.end(); ++it )
// 			{
// 				ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem( TQString(*it) );
// 		// 		std::cout << "kernel crypto: " << *it << std::endl;
// 			}
// 			//FIXME why this is not in kernel crypto list???
// 			// 	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem( "3des" );
// 			// 	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("des" );
// 			// 	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("des_iv64" );
// 			// 	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("des_iv32" );
// 			// 	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("rc5" );
// 			// 	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("rc4" );
// 			// 	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("idea" );
// 			// 	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("3idea" );
// 			// 	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("cast128" );
// 			// 	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("blowfish" );
// 			// 	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("null_enc" );
// 			// 	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("twofish" );
// 			// 	ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("rijndael" );
// 		// 		ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem("aes" );
// 
// 			ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem( "des" );
// 			ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem( "3des" );
// 			ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem( "des_iv64" );
// 			ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem( "des_iv32" );
// 			ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_md5" );
// 			ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_sha1" );
// 			ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_sha256" );
// 			ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_sha384" );
// 			ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem( "hmac_sha512" );
// 			ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem( "non_auth" );
// 

// 			if ( it->getHashAlgo() == "sha1" )
// 				ProfileRacoonOptionsWidget->HashAlgoComboBox->setCurrentText( "SHA1" );
// 			if ( it->getHashAlgo() == "md5" )
// 				ProfileRacoonOptionsWidget->HashAlgoComboBox->setCurrentText( "MD5" );

			ProfileRacoonOptionsWidget->HashAlgoComboBox->setCurrentText( it->getHashAlgo());

			ProfileRacoonOptionsWidget->DHGroupComboBox->setCurrentText( it->getIkeGroup() );
			if (!it->getEncryptionAlgorithm().isEmpty())
				ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->setCurrentText( it->getEncryptionAlgorithm() );
			ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->setCurrentText( it->getAuthenticationAlgorithm() );

			if (!it->getIpsecIke().isEmpty())
				ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->setCurrentText(it->getIpsecIke());

			ProfileRacoonOptionsWidget->ExchangeModeComboBox->setCurrentText( it->getExchangeMode() );
			ProfileRacoonOptionsWidget->UseModeConfigCheckBox->setChecked( it->getUseModeConfig() );

			ProfileCertOptionsWidget->VerifyCaCertCheckBox->setEnabled(true);
			ProfileCertOptionsWidget->VerifyCaCertCheckBox->setChecked(it->getVerifyCaCert());

			ProfileNetworkVirtualIpOptionsWidget->setEnabled( true );
			ProfileNetworkVirtualIpOptionsWidget->SourceIpgroupBox->show();
			ProfileNetworkVirtualIpOptionsWidget->VirtualIpGroupBox->setEnabled(false);
// 			ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setEnabled( true );
// 
// 			ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setText( it->getLocalVirtualIP() );
// 			ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setText( it->getRemoteVirtualIP() );
// 			ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked(it->getUseVirtualIP());
// 
// 			if (it->getUseVirtualIP())
// 			{
// 				ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled(true);
// 				ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled(true);
// 			}
// 			else
// 			{
// 				ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled(false);
// 				ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled(false);
// 			}


			if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::hybrid)
			{
				ProfileCertOptionsWidget->setEnabled(true);
				ProfileCertOptionsWidget->x509certComboBox->setEnabled(false);
				ProfileCertOptionsWidget->x509certURLRequester->setEnabled(false);
				ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(true);
				ProfileCertOptionsWidget->CaCertpathURLRequester->setURL(it->getCaCertificate());
				ProfileCertOptionsWidget->certpathURLRequester->setURL( it->getCertPath() );
				ProfileCertOptionsWidget->LabelCertificate->setEnabled(false);
				ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled(false);
				ProfileCertOptionsWidget->LabelPrivateKeyPassword->setEnabled(false);
				ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->setEnabled(false);
				ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled(false);
				ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setEnabled(false);
				ProfileCertOptionsWidget->UseSpecialServerCertificateCheckBox->setEnabled(false);
				ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled(false);
				ProfilePskOptionsWidget->setEnabled(false);
			}


		} // racoon 

		else if ( it->getConnectionType() == VpnAccountData::ConnectionType( VpnAccountData::pptp ) )
		{
			ProfilePskOptionsWidget->CheckSavePsk->setChecked( it->getSavePsk() );
			ProfileUserOptionsWidget->CheckUserPass->setChecked ( it->getSaveUserPassword() );
			ProfileUserOptionsWidget->UsernameLineEdit->setText ( it->getUserName() );
			ProfileUserOptionsWidget->PasswordEdit->setText ( it->getUserPassword() );
			ProfileUserOptionsWidget->DontSaveUsernameCheckBox->setChecked(it->getDontSaveUsername() );
			ProfileNetworkGeneralOptionsWidget->PingCheckBox->setChecked( it->getDoPingIP() );
			ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->setText( it->getPingHostIP() );

			if ( !it->getRemoteNetAddr().isEmpty() && !it->getRemoteNetMask().isEmpty() )
			{
				ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setText( it->getRemoteNetAddr() );
				if ( !it->getRemoteNetMask().isEmpty() )
					ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentText( it->getRemoteNetMask() );
			}

			ProfilePptpOptionsWidget->RequireMppeCheckbox->setChecked( it->getRequireMppe() );
			ProfilePptpOptionsWidget->Refuse128BitEncryptionCheckbox->setChecked( it->getRefuse128BitEncryption() );
			ProfilePptpOptionsWidget->Refuse40BitEncryptionCheckbox->setChecked( it->getRefuse40BitEncryption() );
			ProfilePptpOptionsWidget->UseNoMPPECompressionCheckbox->setChecked( it->getDisableMPPEComp() );
			ProfilePptpOptionsWidget->DnsServerCheckbox->setChecked( it->getUseDnsServer() );
			ProfilePptpOptionsWidget->DnsServerLineedit->setText( it->getDnsServer() );
			ProfilePptpOptionsWidget->UseNoBsdCompCheckbox->setChecked( it->getUseNoBsdComp() );
			ProfilePptpOptionsWidget->UseNoDeflateCheckbox->setChecked( it->getUseNoDeflate() );
			ProfilePptpOptionsWidget->AllowStatefulModeCheckbox->setChecked( it->getAllowStatefulMode() );
			ProfilePptpOptionsWidget->UseNoIpDefaultCheckbox->setChecked( it->getUseNoIpDefault() );
			ProfilePptpOptionsWidget->DisableCcpCheckbox->setChecked( it->getDisableCcp() );
			ProfilePptpOptionsWidget->DisableHeaderCompressionCheckbox->setChecked(it->getDisableHeaderCompression());
			ProfilePptpOptionsWidget->DisableMagicNumberNegotiationCheckbox->setChecked(it->getDisableMagicNumberNegotiation());
			ProfilePptpOptionsWidget->DisableIpxCheckbox->setChecked(it->getDisableIpx());
			ProfilePptpOptionsWidget->DisableAdressControlCompressionCheckbox->setChecked(it->getDisableAdressControlCompression());
			ProfilePptpOptionsWidget->DisableProtocolFieldCompressionCheckbox->setChecked(it->getDisableProtocolFieldCompression());
			ProfilePptpOptionsWidget->RequireEapCheckbox->setChecked(it->getRequireEap());

			ProfileUserOptionsWidget->NtDomainNameCheckbox->setEnabled( true );
			ProfileUserOptionsWidget->NtDomainNameLineedit->setEnabled ( false );
			ProfileUserOptionsWidget->NtDomainNameLineedit->setText( it->getNtDomainName() );
			if ( it->getUseNtDomainName() )
			{
				ProfileUserOptionsWidget->NtDomainNameLineedit->setEnabled ( true );
				ProfileUserOptionsWidget->NtDomainNameCheckbox->setChecked( true );
			}

			ProfilePptpOptionsWidget->UseSearchDomainInResolvConfCheckbox->setEnabled(true);
			ProfilePptpOptionsWidget->SearchDomainInResolvConfLineedit->setEnabled(false);
			ProfilePptpOptionsWidget->SearchDomainInResolvConfLineedit->setText(it->getSearchDomainInResolvConf());
			if ( it->getUseSearchDomainInResolvConf() )
			{
				ProfilePptpOptionsWidget->SearchDomainInResolvConfLineedit->setEnabled ( true );
				ProfilePptpOptionsWidget->UseSearchDomainInResolvConfCheckbox->setChecked( true );
			}


			ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( false );
			ProfileCiscoOptionsWidget->LabelID->setEnabled( false );

			ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( false );
			ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( false );
			ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( false );
			ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled( false );
			ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled( false );
			ProfileNetworkGeneralOptionsWidget->RemoteNetDividetextLabel->setEnabled( false );
			ProfileNetworkGeneralOptionsWidget->LabelNetworkDevice->setEnabled( false );

			ProfilePptpOptionsWidget->setEnabled( true );
			ProfileOpenvpnOptionsWidget->setEnabled( false );
			ProfileCiscoOptionsWidget->setEnabled( false );
			ProfileRacoonOptionsWidget->setEnabled( false );
			ProfileIpsecOptionsWidget->setEnabled( false );
			ProfileSshOptionsWidget->setEnabled( false );

			if (it->getAuthMethod() == "chap")
				ProfilePptpOptionsWidget->AuthMethodComboBox->setCurrentItem(0);
			if (it->getAuthMethod() == "pap")
				ProfilePptpOptionsWidget->AuthMethodComboBox->setCurrentItem(1);
			if (it->getAuthMethod() == "mschap")
				ProfilePptpOptionsWidget->AuthMethodComboBox->setCurrentItem(2);
			if (it->getAuthMethod() == "mschap-v2")
				ProfilePptpOptionsWidget->AuthMethodComboBox->setCurrentItem(3);

			//FIXME
			// 			ProfileNetworkRouteOptionsWidget->InterfaceComboBox->insertItem("ppp0");

			ProfileNetworkVirtualIpOptionsWidget->setEnabled( true );
			ProfileNetworkVirtualIpOptionsWidget->SourceIpgroupBox->hide();
			ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setEnabled( true );

			ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setText( it->getLocalVirtualIP() );
			ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setText( it->getRemoteVirtualIP() );
			ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked(it->getUseVirtualIP());

			if (it->getUseVirtualIP())
			{
				ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled(true);
				ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled(true);
			}
			else
			{
				ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled(false);
				ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled(false);
			}
			ProfileUserOptionsWidget->HideGroupPasswordInAccountDataDialogCheckBox->hide();

		} // pptp

		else if ( it->getConnectionType() == VpnAccountData::ConnectionType( VpnAccountData::openvpn ) )
		{

			if ( it->getAuthType() == VpnAccountData::cert )
			{
				ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentItem( 0 );
				ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentItem( 0 );
			}
			if ( it->getAuthType() == VpnAccountData::psk )
			{
				ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentItem( 1 );
				ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentItem( 1 );
			}
			
			ProfileCertOptionsWidget->x509certComboBox->hide();
			ProfileCertOptionsWidget->CaCertpathComboBox->hide();

			ProfileCertOptionsWidget->x509certURLRequester->setURL( it->getX509Certificate() );
			ProfileCertOptionsWidget->CaCertpathURLRequester->setURL( it->getCaCertificate() );
			ProfileCertOptionsWidget->certpathURLRequester->setURL( it->getCertPath() );
			ProfileCertOptionsWidget->PrivkeyPasswordEdit->setText( it->getPrivateKeyPass() );
			ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setChecked( it->getSavePrivateKeyPassword() );
			ProfileCertOptionsWidget->privkeypathURLRequester->setURL( it->getPrivateKey() );
			ProfilePskOptionsWidget->PSKLineEdit->setText( it->getPreSharedKey() );
			ProfilePskOptionsWidget->PskInFileCheckBox->setChecked( it->getPskIsInFile() );
			ProfilePskOptionsWidget->CheckSavePsk->setChecked( it->getSavePsk() );
			ProfileNetworkGeneralOptionsWidget->PingCheckBox->setChecked( it->getDoPingIP() );
			ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->setText( it->getPingHostIP() );

			ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setText( it->getLocalVirtualIP() );
			ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setText( it->getRemoteVirtualIP() );
			ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked(it->getUseVirtualIP());

			if (it->getUseVirtualIP())
			{
				ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled(true);
				ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled(true);
				tunnelDeviceTypeChanged(it->getTunnelDeviceType());
			}
			else
			{
				ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled(false);
				ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled(false);
			}
			// 			ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setText( it->getRemoteNetAddr() );
			//
			// 			if (!it->getRemoteNetMask().isEmpty())
			// 				ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentText( it->getRemoteNetMask() );


			if ( it->getUseUdp() )
				ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked( true );
			else
				ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked( false );

			ProfileNetworkNatOptionsWidget->UdpPortSpinbox->setValue( it->getUdpPort() );
			if ( it->getUseUdpPort() )
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked( true );
			else
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked( false );

			ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
			if ( it->getUseUdp() )
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
			else
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( false );

			ProfileNetworkVirtualIpOptionsWidget->setEnabled( true );

			ProfilePptpOptionsWidget->setEnabled( false );
			ProfileOpenvpnOptionsWidget->setEnabled( true );
			ProfileCiscoOptionsWidget->setEnabled( false );
			ProfileRacoonOptionsWidget->setEnabled( false );
			ProfileIpsecOptionsWidget->setEnabled( false );
			ProfileSshOptionsWidget->setEnabled( false );
			ProfileNetworkHttpProxyOptionsWidget ->setEnabled( true );
			ProfileNetworkVirtualIpOptionsWidget->SourceIpgroupBox->hide();

			if ( GlobalConfig->currentProfile->getAuthWithUsernameAndPassword() )
				ProfileUserOptionsWidget->setEnabled( true );
			else
				ProfileUserOptionsWidget->setEnabled( false );

// 			ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled( false );
// 			ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled( false );

			if ( GlobalConfig->currentProfile->getUseUserdefinedPort() )
			{
				ProfileOpenvpnOptionsWidget->UseUserdefinedPortCheckBox->setChecked( true );
				ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setEnabled( true );
			}
			else
			{
				ProfileOpenvpnOptionsWidget->UseUserdefinedPortCheckBox->setChecked( false );
				ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setEnabled( false );
			}

			if ( it->getAuthType() == VpnAccountData::cert )
			{
				ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setEnabled( true );
				ProfileOpenvpnOptionsWidget->UseTlsRemoteHostCheckBox->setEnabled( true );
			}
			else
			{
				ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setEnabled( false );
				ProfileOpenvpnOptionsWidget->UseTlsRemoteHostCheckBox->setEnabled( false );
			}

			if ( GlobalConfig->currentProfile->getUseNsCertType() )
			{
				ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setChecked( true );
				ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setEnabled( true );

				if ( GlobalConfig->currentProfile->getNsCertType() == "client" )
					ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setCurrentItem( 0 );
				else
					ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setCurrentItem( 1 );
			}
			else
			{
				ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setChecked( false );
				ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setEnabled( false );
			}
			ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setValue( GlobalConfig->currentProfile->getUserdefinedPort() );

			if ( GlobalConfig->currentProfile->getDisableLzoCompression() )
				ProfileOpenvpnOptionsWidget->DisableLzoCompressionCheckBox->setChecked( true );
			else
				ProfileOpenvpnOptionsWidget->DisableLzoCompressionCheckBox->setChecked( false );

			ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setValue( GlobalConfig->currentProfile->getUserdefinedPort() );

			if ( GlobalConfig->currentProfile->getAuthWithUsernameAndPassword() )
				ProfileOpenvpnOptionsWidget->AuthWithUsernameAndPasswordCheckBox->setChecked ( true );
			else
				ProfileOpenvpnOptionsWidget->AuthWithUsernameAndPasswordCheckBox->setChecked ( false );

			if ( GlobalConfig->currentProfile->getUseTlsRemoteHost() )
			{
				ProfileOpenvpnOptionsWidget->UseTlsRemoteHostCheckBox->setChecked( true );
				ProfileOpenvpnOptionsWidget->TlsRemoteHostLineEdit->setEnabled( true );
			}
			else
			{
				ProfileOpenvpnOptionsWidget->UseTlsRemoteHostCheckBox->setChecked( false );
				ProfileOpenvpnOptionsWidget->TlsRemoteHostLineEdit->setEnabled( false );
			}


			if ( GlobalConfig->currentProfile->getUseTlsAuth() )
			{
				ProfileOpenvpnOptionsWidget->UseTlsAuthCheckBox->setChecked( true );
				ProfileOpenvpnOptionsWidget->TlsAuthURLRequester->setEnabled( true );
			}
			else
			{
				ProfileOpenvpnOptionsWidget->UseTlsAuthCheckBox->setChecked( false );
				ProfileOpenvpnOptionsWidget->TlsAuthURLRequester->setEnabled( false );
			}

			ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setEnabled( true );

			ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked( GlobalConfig->currentProfile->getUseVirtualIP() );

			if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn )
				ProfileNetworkVirtualIpOptionsWidget->setEnabled( true );
			else
			{
				ProfileNetworkVirtualIpOptionsWidget->setEnabled( false );

				ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setText( GlobalConfig->currentProfile->getRemoteVirtualIP() );
				ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setText( GlobalConfig->currentProfile->getLocalVirtualIP() );
			}

			ProfilePskOptionsWidget->CheckSavePsk->setChecked( it->getSavePsk() );
			ProfileUserOptionsWidget->CheckUserPass->setChecked ( it->getSaveUserPassword() );
			ProfileUserOptionsWidget->UsernameLineEdit->setText ( it->getUserName() );
			ProfileUserOptionsWidget->PasswordEdit->setText ( it->getUserPassword() );
			ProfileUserOptionsWidget->DontSaveUsernameCheckBox->setChecked(it->getDontSaveUsername() );

			ProfileOpenvpnOptionsWidget->TlsAuthURLRequester->setURL ( it->getTlsAuthFile() );
			ProfileOpenvpnOptionsWidget->TlsRemoteHostLineEdit->setText( it->getTlsRemoteHost() );

			ProfileOpenvpnOptionsWidget->UseUserdefinedRemotePortCheckBox->setChecked( it->getUseRemotePort() );
			ProfileOpenvpnOptionsWidget->UserdefinedRemotePortSpinBox->setValue( it->getRemotePort() );

			ProfileOpenvpnOptionsWidget->UserdefinedFragmentSizeSpinBox->setValue( it->getFragment() );

			ProfileOpenvpnOptionsWidget->UseUserdefinedFragmentationSizeCheckBox->setChecked( it->getUseFragment() );

			ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyCheckBox->setChecked( GlobalConfig->currentProfile->getUseHttpProxy() );
			ProfileNetworkHttpProxyOptionsWidget->HttpProxyLineEdit->setText( GlobalConfig->currentProfile->getHttpProxy() );
			ProfileNetworkHttpProxyOptionsWidget->HttpProxyTimeoutIntSpinBox->setValue( GlobalConfig->currentProfile->getHttpProxyTimeout() );
			ProfileNetworkHttpProxyOptionsWidget->HttpProxyPortIntNumInput->setValue( GlobalConfig->currentProfile->getHttpProxyPort() );

			if ( GlobalConfig->currentProfile->getHttpProxyAuthType() == "basic" )
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->setCurrentText( "Basic" );
			else if ( GlobalConfig->currentProfile->getHttpProxyAuthType() == "ntlm" )
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->setCurrentText( "NTLM" );
			else
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->setCurrentText( "Basic" );

			ProfileNetworkHttpProxyOptionsWidget->useHttpProxyToggeled(GlobalConfig->currentProfile->getUseHttpProxy());

			ProfileNetworkHttpProxyOptionsWidget->HttpProxyUserLineEdit->setText( GlobalConfig->currentProfile->getHttpProxyUser() );
			ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthPasswordEdit->setText( GlobalConfig->currentProfile->getHttpProxyPass() );

			ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyAuthCheckBox->setChecked( GlobalConfig->currentProfile->getUseHttpProxyAuth() );

			if ( GlobalConfig->currentProfile->getUseHttpProxyAuth() )
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyGroupBox->setEnabled(true);
			else
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyGroupBox->setEnabled(false);
			

			if ( GlobalConfig->currentProfile->getUseOnlyCaCertAndUserAuth() )
				ProfileOpenvpnOptionsWidget->UseOnlyCaCertAndUserAuthCheckBox->setChecked( true );
			else
				ProfileOpenvpnOptionsWidget->UseOnlyCaCertAndUserAuthCheckBox->setChecked( false );


			ProfileOpenvpnOptionsWidget->UserdefiniedDigestComboBox->setCurrentText(GlobalConfig->currentProfile->getAuthenticationAlgorithm());
			ProfileOpenvpnOptionsWidget->UserdefiniedDigestComboBox->setEnabled(GlobalConfig->currentProfile->getUseAuthenticationAlgorithm());
			ProfileOpenvpnOptionsWidget->UseAuthenticationAlgorithmCheckBox->setChecked(GlobalConfig->currentProfile->getUseAuthenticationAlgorithm());

			ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->setEnabled( true );

			//FIXME
			// 			ProfileNetworkRouteOptionsWidget->InterfaceComboBox->insertItem("tun0");
			ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->setEnabled(true);
			ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeLabel->setEnabled(true);


			if (GlobalConfig->currentProfile->getAuthenticationDirection() == "none")
				ProfileOpenvpnOptionsWidget->AuthenticationDirectionComboBox->setCurrentText(i18n("none"));
			if (GlobalConfig->currentProfile->getAuthenticationDirection() == "0")
				ProfileOpenvpnOptionsWidget->AuthenticationDirectionComboBox->setCurrentText(i18n("0"));
			if (GlobalConfig->currentProfile->getAuthenticationDirection() == "1")
				ProfileOpenvpnOptionsWidget->AuthenticationDirectionComboBox->setCurrentText(i18n("1"));
			
			ProfileUserOptionsWidget->HideGroupPasswordInAccountDataDialogCheckBox->hide();


			if (GlobalConfig->currentProfile->getUseRenegSec())
				ProfileOpenvpnOptionsWidget->RenegSecCheckBox->setChecked(true);
			else
				ProfileOpenvpnOptionsWidget->RenegSecCheckBox->setChecked(false);
				
			ProfileOpenvpnOptionsWidget->RenegSecSpinBox->setValue(GlobalConfig->currentProfile->getRenegSec());

			if (GlobalConfig->currentProfile->getUseTunnelPing())
			{
				ProfileOpenvpnOptionsWidget->TunnelPingCheckBox->setChecked(true);
				ProfileOpenvpnOptionsWidget->TunnelPingSpinBox->setValue(GlobalConfig->currentProfile->getTunnelPing());
			}

			if (GlobalConfig->currentProfile->getUseTunnelPingRestart())
				ProfileOpenvpnOptionsWidget->TunnelPingRestartCheckBox->setChecked(true);
			else
				ProfileOpenvpnOptionsWidget->TunnelPingRestartCheckBox->setChecked(false);

			ProfileOpenvpnOptionsWidget->TunnelPingRestartSpinBox->setValue(GlobalConfig->currentProfile->getTunnelPingRestart());
			

			ProfileOpenvpnOptionsWidget->DisableSocketBindCheckBox->setChecked(GlobalConfig->currentProfile->getDisableBind());

		} // openvpn

		if ( it->getConnectionType() == VpnAccountData::vtun )
		{

			ProfileVtunOptionsWidget->setEnabled( true );

			ProfileVtunOptionsWidget->PortCheckbox->setChecked(GlobalConfig->currentProfile->getUseLocalPort());
			ProfileVtunOptionsWidget->PortSpinbox->setValue(GlobalConfig->currentProfile->getLocalPort());

			ProfileVtunOptionsWidget->VtunProfileLineEdit->setText(GlobalConfig->currentProfile->getVtunProfile());

			ProfileUserOptionsWidget->UsernameLineEdit->setEnabled(false);

			ProfileNetworkVirtualIpOptionsWidget->setEnabled( true );
			ProfileNetworkVirtualIpOptionsWidget->SourceIpgroupBox->hide();
			ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setEnabled( true );
			ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked( GlobalConfig->currentProfile->getUseVirtualIP() );

			ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setText( GlobalConfig->currentProfile->getRemoteVirtualIP() );
			ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setText( GlobalConfig->currentProfile->getLocalVirtualIP() );

			ProfileUserOptionsWidget->HideGroupPasswordInAccountDataDialogCheckBox->hide();
		} // vtun
		if ( it->getConnectionType() == VpnAccountData::ssh )
		{

			ProfileVtunOptionsWidget->setEnabled( true );

			ProfileVtunOptionsWidget->PortCheckbox->setChecked(it->getUseLocalPort());
			ProfileVtunOptionsWidget->PortSpinbox->setValue(it->getLocalPort());
			ProfileUserOptionsWidget->UsernameLineEdit->setEnabled(true);
			ProfileNetworkVirtualIpOptionsWidget->setEnabled( true );
			ProfileNetworkVirtualIpOptionsWidget->SourceIpgroupBox->hide();
			ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setEnabled( true );
			ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked( it->getUseVirtualIP() );
			ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setText( it->getRemoteVirtualIP() );
			ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setText( it->getLocalVirtualIP() );

			ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->setEnabled(true);
			ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeLabel->setEnabled(true);

			ProfileCertOptionsWidget->setEnabled(false);
			ProfileCiscoOptionsWidget->setEnabled(false);
			ProfileIpsecOptionsWidget->setEnabled(false);
			ProfileRacoonOptionsWidget->setEnabled(false);
			ProfileOpenvpnOptionsWidget->setEnabled(false);
			ProfilePptpOptionsWidget->setEnabled(false);
			ProfileVtunOptionsWidget->setEnabled(false);
			ProfileSshOptionsWidget->setEnabled(true);

			ProfileUserOptionsWidget->HideGroupPasswordInAccountDataDialogCheckBox->hide();

			ProfileSshOptionsWidget->UseUserdefinedRemotePortCheckBox->setChecked(it->getUseRemotePort( ) );
			ProfileSshOptionsWidget->UserdefinedRemotePortSpinBox->setValue(it->getRemotePort ( ) );

			ProfileNetworkVirtualIpOptionsWidget->SourceIpgroupBox->hide();
			
			ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->hide();
			ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->hide();
			ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->hide();
			ProfileNetworkGeneralOptionsWidget->RemoteNetDividetextLabel->hide();
			ProfileNetworkGeneralOptionsWidget->UseRemoteNetworkCheckBox->hide();

			if (it->getAuthWithUsernameAndPassword())
			{
// 				KMessageBox::information(0,"auth pass",Name);
				ProfileSshOptionsWidget->AuthPassRadioButton->setChecked(true);
				ProfileSshOptionsWidget->AuthKeyRadioButton->setChecked(false);
// 				ProfileSshOptionsWidget->SshkeyButtonGroup->setEnabled(false);
				ProfileUserOptionsWidget->PasswordEdit->setEnabled(true);
			}
			else
			{
// 				KMessageBox::information(0,"auth key",Name);
				ProfileSshOptionsWidget->SshKeyComboBox->setEnabled(true);
				ProfileSshOptionsWidget->AuthPassRadioButton->setChecked(false);
				ProfileSshOptionsWidget->AuthKeyRadioButton->setChecked(true);
// 				ProfileSshOptionsWidget->SshkeyButtonGroup->setEnabled(true);
				ProfileUserOptionsWidget->PasswordEdit->setEnabled(false);

				if (it->getPskIsInFile())
				{
					ProfileSshOptionsWidget->CostumkeyURLRequester->setURL(it->getPreSharedKeyFile());
					ProfileSshOptionsWidget->CostumKeyRadioButton->setChecked(true);
					ProfileSshOptionsWidget->AutoKeyRadioButton->setChecked(false);
				}
				else
				{
					ProfileSshOptionsWidget->CostumKeyRadioButton->setChecked(false);
					ProfileSshOptionsWidget->AutoKeyRadioButton->setChecked(true);
					if (!it->getPreSharedKey().isEmpty())
						ProfileSshOptionsWidget->SshKeyComboBox->setCurrentText(it->getPreSharedKey());
				}
				ProfileSshOptionsWidget->sshAuthToggled(true);
			}

				ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setText( it->getLocalVirtualIP() );
				ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setText( it->getRemoteVirtualIP() );
				ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked(it->getUseVirtualIP());
	
				if (it->getUseVirtualIP())
				{
					ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled(true);
					ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled(true);
					tunnelDeviceTypeChanged(it->getTunnelDeviceType());
				}
				else
				{
					ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled(false);
					ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled(false);
				}

				if (it->getUseSshConfigRemoteScript() && !it->getSshConfigRemoteScript().isEmpty())
				{
					ProfileSshOptionsWidget->UseSshConfigRemoteScriptCheckBox->setChecked(true);
					ProfileSshOptionsWidget->SshConfigRemoteScriptLineEdit->setText(it->getSshConfigRemoteScript());
				}

		} // ssh

		/* all types */

		ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked( it->getUseVirtualIP() );
		ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setEnabled( true );

		// 			ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked(it->getUseUdp());
		// 			ProfileNetworkNatOptionsWidget->UdpPortSpinbox->setValue(it->getUdpPort());
		// 			if (it->getUseUdpPort() )
		// 				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(true);
		// 			else
		// 				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(false);


		ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
		ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		if ( it->getUseUdp() )
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		else
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( false );


		ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled( true );

		ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( false );
		ProfileCiscoOptionsWidget->LabelID->setEnabled( false );
		ProfileUserOptionsWidget->UsernameLineEdit->setEnabled(true);


		if ( it->getConnectionType() == VpnAccountData::l2tpd_freeswan || it->getConnectionType() == VpnAccountData::l2tpd_racoon )
		{
			ProfilePptpOptionsWidget->L2tpDaemonComboBox->setEnabled(true);
			if (it->getL2tpDaemon() == VpnAccountData::l2tpd )
				ProfilePptpOptionsWidget->L2tpDaemonComboBox->setCurrentItem(0); // l2tpd
			else
				ProfilePptpOptionsWidget->L2tpDaemonComboBox->setCurrentItem(1); //openl2tp
		}
		else
		{
			ProfilePptpOptionsWidget->L2tpDaemonComboBox->setEnabled(false);
		}

		if ( it->getReplaceDefaultRoute() == false )
			ProfileNetworkRouteOptionsWidget->DefaultRouteComboBox->setCurrentItem( 0 );
		else
			ProfileNetworkRouteOptionsWidget->DefaultRouteComboBox->setCurrentItem( 1 );

		ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->setChecked( it->getUseSmartcard() );

		ProfileCmdExecBeforeConnectOptionsWidget->ExcuteCmdBeforeConnectCheckBox->setChecked( it->getExecuteCmdBeforeConnect() );
		ProfileCmdExecAfterConnectOptionsWidget->ExcuteCmdAfterConnectCheckBox->setChecked( it->getExecuteCmdAfterConnect() );
		ProfileCmdExecBeforeDisconnectOptionsWidget->ExcuteCmdBeforeDisconnectCheckBox->setChecked( it->getExecuteCmdBeforeDisconnect() );
		ProfileCmdExecAfterDisconnectOptionsWidget->ExcuteCmdAfterDisconnectCheckBox->setChecked( it->getExecuteCmdAfterDisconnect() );
		ProfileCmdExecBeforeConnectOptionsWidget->CmdBeforeConnectTextEdit->setText( it->getCommandBeforeConnect() );
		ProfileCmdExecAfterConnectOptionsWidget->CmdAfterConnectTextEdit->setText( it->getCommandAfterConnect() );
		ProfileCmdExecBeforeDisconnectOptionsWidget->CmdBeforeDisconnectTextEdit->setText ( it->getCommandBeforeDisconnect() );
		ProfileCmdExecAfterDisconnectOptionsWidget->CmdAfterDisconnectTextEdit->setText ( it->getCommandAfterDisconnect() );
		ProfileCmdExecBeforeConnectOptionsWidget->CmdBeforeConnectTextEdit->setEnabled( it->getExecuteCmdBeforeConnect() );
		ProfileCmdExecAfterConnectOptionsWidget->CmdAfterConnectTextEdit->setEnabled( it->getExecuteCmdAfterConnect() );
		ProfileCmdExecBeforeDisconnectOptionsWidget->CmdBeforeDisconnectTextEdit->setEnabled( it->getExecuteCmdBeforeDisconnect() );
		ProfileCmdExecAfterDisconnectOptionsWidget->CmdAfterDisconnectTextEdit->setEnabled( it->getExecuteCmdAfterDisconnect() );
		ProfileCmdExecAfterConnectOptionsWidget->CommandAfterConnectDelayTimeNumInput->setValue(it->getCommandAfterConnectDelayTime());

		if ( GlobalConfig->currentProfile->getDoPingIP() )
			ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->setEnabled( true );
		else
			ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->setEnabled( false );

		ProfileCertOptionsWidget->AllowEmptyPrivateKeyPasswordCheckBox->setChecked(it->getAllowEmptyPrivateKeyPassword());
		ProfileOpenvpnOptionsWidget->AllowIpAddressChangeOfPeerCheckBox->setChecked(it->getAllowIpAddressChangeOfPeer());

		ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->setText( GlobalConfig->currentProfile->getPingHostIP() );
		ProfileNetworkGeneralOptionsWidget->PingCheckBox ->setChecked( GlobalConfig->currentProfile->getDoPingIP() );
		ProfileNetworkGeneralOptionsWidget->UseConnectionStatusCheckCheckBox->setChecked( GlobalConfig->currentProfile->getUseConnectionStatusCheck() );
		ProfileNetworkGeneralOptionsWidget->ConnectionStatusSuccessCountNumInput->setValue( GlobalConfig->currentProfile->getConnectionStatusCheckSuccessCount() );
		ProfileNetworkGeneralOptionsWidget->ConnectionStatusCheckIntervalNumInput->setValue( GlobalConfig->currentProfile->getConnectionStatusInterval() );
		ProfileNetworkGeneralOptionsWidget->DoReconnectAfterConnectionLostCheckBox->setChecked( GlobalConfig->currentProfile->getDoReconnectAfterConnectionLost() );
		ProfileNetworkGeneralOptionsWidget->UseDnsUpdateCheckBox->setChecked( GlobalConfig->currentProfile->getUseDnsUpdate() );

		ProfileNetworkRouteOptionsWidget->UseExtraNetworkRoutesCheckbox->setChecked( it->getUseAdditionalNetworkRoutes() );
		TQStringList AdditionalNetworkRoutes = it->getAdditionalNetworkRoutes();
		// example entry:
		// <network>/<netmask>#<gateway>

		for ( TQStringList::Iterator it2 = AdditionalNetworkRoutes.begin() ; it2 != AdditionalNetworkRoutes.end(); ++it2 )
		{
			TQString networkstring = *it2;
			TQString Network = networkstring.section( '#', 0, 0 ).section( '/', 0, 0 );
			TQString Netmask = networkstring.section( '#', 0, 0 ).section( '/', 1, 1 );
			TQString Gateway = networkstring.section( '#', 1, 1 ).section( '/', 0, 0 );
			TQString Interface = networkstring.section( '#', 2, 2 );

			ProfileNetworkRouteOptionsWidget->NetworkListView->insertItem( new TQListViewItem( ProfileNetworkRouteOptionsWidget->NetworkListView, Network, Netmask, Gateway, Interface ) );

			ProfileNetworkRouteOptionsWidget->checkList();

		}

		ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setText( it->getRemoteNetAddr() );
		if ( !it->getRemoteNetMask().isEmpty() )
			ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentText( it->getRemoteNetMask() );

		connectionTypeChanged( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() );
// 		ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentItem( it->getAuthType() );
// 		ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentItem( it->getAuthType() );
		ProfileCertOptionsWidget->x509certURLRequester->setFilter( "*.pem *.crt *.der" );
		ProfileCertOptionsWidget->certpathURLRequester->setMode( KFile::Directory );


		ProfileSmartcardOptionsWidget->UsePkcs11ProvidersCheckBox->setChecked(it->getUsePkcs11Providers());

		
		if (!it->getPkcs11Id().isEmpty())
			ProfileSmartcardOptionsWidget->Pkcs11IdComboBox->insertItem(it->getPkcs11Id());
		if (!it->getPkcs11Slot().isEmpty())
			ProfileSmartcardOptionsWidget->Pkcs11SlotComboBox->insertItem(it->getPkcs11Slot());
		
// 		TQString Pkcs11SlotType = it->getPkcs11SlotType();
// 		if (Pkcs11SlotType == "id")
// 			ProfileSmartcardOptionsWidget->Pkcs11SlotTypeComboBox->setCurrentText(i18n("ID"));
// 		else if (Pkcs11SlotType == "name")
// 			ProfileSmartcardOptionsWidget->Pkcs11SlotTypeComboBox->setCurrentText(i18n("Name"));
// 		else
// 			ProfileSmartcardOptionsWidget->Pkcs11SlotTypeComboBox->setCurrentText(i18n("Label"));
		ProfileSmartcardOptionsWidget->Pkcs11SlotTypeComboBox->setCurrentText(i18n("ID"));
		ProfileSmartcardOptionsWidget->Pkcs11SlotTypeComboBox->setEnabled(false);
		ProfileSmartcardOptionsWidget->Pkcs11SlotTypeLabel->setEnabled(false);

		TQString Pkcs11IdType = it->getPkcs11IdType();
		if (Pkcs11IdType == "id")
			ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->setCurrentText(i18n("ID"));
		else if (Pkcs11IdType == "label")
			ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->setCurrentText(i18n("Label"));
		else
			ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->setCurrentText(i18n("Subject"));

// 		ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->setCurrentText(i18n("ID"));
// 		ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->setEnabled(false);

		TQString Pkcs11SignMode = it->getPkcs11SignMode();
		if (Pkcs11SignMode == "auto")
			ProfileSmartcardOptionsWidget->Pkcs11SignModeComboBox->setCurrentText(i18n("auto"));
		else if (Pkcs11SignMode == "sign")
			ProfileSmartcardOptionsWidget->Pkcs11SignModeComboBox->setCurrentText(i18n("sign"));
		else if (Pkcs11SignMode == "recover")
			ProfileSmartcardOptionsWidget->Pkcs11SignModeComboBox->setCurrentText(i18n("recover"));
		else
			ProfileSmartcardOptionsWidget->Pkcs11SignModeComboBox->setCurrentText(i18n("any"));

		ProfileSmartcardOptionsWidget->Pkcs11ProvidersURLRequester->setURL(it->getPkcs11Providers());

// 		authTypeChanged(it->getAuthType());

	}
	else
	{
		// 		ProfileGeneralOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileNetworkRouteOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileNetworkNatOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileCertPskOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileUserOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileOpenvpnOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfilePptpOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileRacoonOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileCiscoOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->setCurrentText( "" );

		ProfileGeneralOptionsWidget->setEnabled( false );
		ProfileNetworkRouteOptionsWidget->setEnabled( false );
		ProfileNetworkNatOptionsWidget->setEnabled( false );
		ProfileNetworkVirtualIpOptionsWidget->setEnabled( false );
		ProfileCertOptionsWidget->setEnabled( false );
		ProfilePskOptionsWidget->setEnabled( false );
		ProfileUserOptionsWidget->setEnabled( false );
		ProfileOpenvpnOptionsWidget->setEnabled( false );
		ProfilePptpOptionsWidget->setEnabled( false );
		ProfileRacoonOptionsWidget->setEnabled( false );
		ProfileCiscoOptionsWidget->setEnabled( false );
		ProfileSshOptionsWidget->setEnabled( false );
		ProfileCmdExecBeforeConnectOptionsWidget->setEnabled( false );
		ProfileCmdExecBeforeDisconnectOptionsWidget->setEnabled( false );
		ProfileCmdExecAfterConnectOptionsWidget->setEnabled( false );
		ProfileCmdExecAfterDisconnectOptionsWidget->setEnabled( false );
		ProfileGeneralOptionsWidget->NewSessionPushButton->setEnabled( true );

	}
}

void PreferencesDialog::saveSessionClicked()
{
	if ( !showOnlyProfiles )
	{
		GlobalConfig->pathToVpnc =ConfigDaemonOptionsWidget->VpncPathInput->url();
		GlobalConfig->pathToIpsec =ConfigDaemonOptionsWidget->FreeswanPathInput->url();
		GlobalConfig->pathToRacoon =ConfigDaemonOptionsWidget->RacoonPathInput->url();

		if (ConfigDaemonOptionsWidget->PptpLogLevelComboBox->currentText() == "low" )
			GlobalConfig->PptpLogLevel = 0;
		else if (ConfigDaemonOptionsWidget->PptpLogLevelComboBox->currentText() == "default" )
			GlobalConfig->PptpLogLevel = 1;
		else if (ConfigDaemonOptionsWidget->PptpLogLevelComboBox->currentText() == "high" )
			GlobalConfig->PptpLogLevel = 2;

		if (ConfigDaemonOptionsWidget->PppdKernelLogLevelComboBox->currentText() ==i18n("none") )
			GlobalConfig->PppdKernelLogLevel =0;
		if (ConfigDaemonOptionsWidget->PppdKernelLogLevelComboBox->currentText() ==i18n("general") )
			GlobalConfig->PppdKernelLogLevel =1;
		if (ConfigDaemonOptionsWidget->PppdKernelLogLevelComboBox->currentText() ==i18n("general + packets") )
			GlobalConfig->PppdKernelLogLevel =4;

		GlobalConfig->pathToPppd =ConfigDaemonOptionsWidget->PppdPathInput->url();
		GlobalConfig->pathToPptp =ConfigDaemonOptionsWidget->PptpPathInput->url();
		GlobalConfig->pathToOpenvpn =ConfigDaemonOptionsWidget->OpenvpnPathInput->url();
		GlobalConfig->pathToVtund =ConfigDaemonOptionsWidget->VtundPathInput->url();
		GlobalConfig->pathToSsh =ConfigDaemonOptionsWidget->SshPathInput->url();


		GlobalConfig->pathToIptables = HelperProgramOptionsWidget->IptablesPathInput->url();
		GlobalConfig->pathToOpenssl = HelperProgramOptionsWidget->OpenSSLPathInput->url();
		GlobalConfig->pathToKill = HelperProgramOptionsWidget->KillPathInput->url();
		GlobalConfig->pathToKillall = HelperProgramOptionsWidget->KillallPathInput->url();
		GlobalConfig->pathToPing = HelperProgramOptionsWidget->PingPathInput->url();
		GlobalConfig->pathToIp = HelperProgramOptionsWidget->IpPathInput->url();
		GlobalConfig->pathToIfconfig = HelperProgramOptionsWidget->IfconfigPathInput->url();
		GlobalConfig->pathToRoute = HelperProgramOptionsWidget->RoutePathInput->url();
		GlobalConfig->pathToPkcs11Tool = HelperProgramOptionsWidget->Pkcs11ToolPathInput->url();

		GlobalConfig->minimizeAfterConnect = ConnectOptionsWidget->checkMinimizeAfterConnectCheck->isChecked();
		GlobalConfig->showDebugConsole = DebugOptionsWidget->showDebugCheck->isChecked();
		GlobalConfig->writeLogFile = DebugOptionsWidget->WriteLogCheck->isChecked();
		GlobalConfig->KvpncDebugLevel = DebugOptionsWidget->spinKvpncDebugLevel->value ();
		GlobalConfig->RacoonDebugLevel =ConfigDaemonOptionsWidget->RacoonDebugLevelComboBox->currentText ();
		GlobalConfig->VpncDebugLevel =ConfigDaemonOptionsWidget->spinVpncDebugLevel->value ();
		GlobalConfig->OpenvpnDebugLevel =ConfigDaemonOptionsWidget->spinOpenvpnDebugLevel->value () + 1;
		GlobalConfig->SshDebugLevel =ConfigDaemonOptionsWidget->spinSshDebugLevel->value ();
		GlobalConfig->enableDebugPppd =ConfigDaemonOptionsWidget->DebugPppdcheckBox->isChecked();
		GlobalConfig->enableDebugPptpd =ConfigDaemonOptionsWidget->DebugPptpdcheckBox->isChecked();

		GlobalConfig->enableDebugXl2tpdtunnel = ConfigDaemonOptionsWidget->EnableDebugXl2tpdtunnelCheckBox->isChecked( );
		GlobalConfig->enableDebugXl2tpdstate = ConfigDaemonOptionsWidget->EnableDebugXl2tpdstateCheckBox ->isChecked(  );
		GlobalConfig->enableDebugXl2tpdpacket = ConfigDaemonOptionsWidget->EnableDebugXl2tpdpacketCheckBox->isChecked(  );
		GlobalConfig->enableDebugXl2tpdNetwork  = ConfigDaemonOptionsWidget->EnableDebugXl2tpdNetworkCheckBox->isChecked( );

		GlobalConfig->enableDebugOpenl2tp  = ConfigDaemonOptionsWidget->DebugOpenl2tpCheckBox->isChecked( );

		GlobalConfig->PlutoDebug.clear();
		if (ConfigDaemonOptionsWidget->IpsecRawDebugCheckBox->isChecked())
			GlobalConfig->PlutoDebug.append("raw");
		if (ConfigDaemonOptionsWidget->IpsecCryptDebugCheckBox->isChecked())
			GlobalConfig->PlutoDebug.append("crypt");
		if (ConfigDaemonOptionsWidget->IpsecParsingDebugCheckBox->isChecked())
			GlobalConfig->PlutoDebug.append("parsing");
		if (ConfigDaemonOptionsWidget->IpsecEmittingDebugCheckBox->isChecked())
			GlobalConfig->PlutoDebug.append("emitting");
		if (ConfigDaemonOptionsWidget->IpsecControlDebugCheckBox->isChecked())
			GlobalConfig->PlutoDebug.append("control");
		if (ConfigDaemonOptionsWidget->IpsecKlipsDebugCheckBox->isChecked())
			GlobalConfig->PlutoDebug.append("klips");
		if (ConfigDaemonOptionsWidget->IpsecPrivateDebugCheckBox->isChecked())
			GlobalConfig->PlutoDebug.append("private");

		GlobalConfig->KlipsDebug.clear();
		if (ConfigDaemonOptionsWidget->KlipsDebugTunnel_xmitCheckBox->isChecked())
			GlobalConfig->KlipsDebug.append("tunnel-xmit");
		if (ConfigDaemonOptionsWidget->KlipsDebugPfkeyCheckBox->isChecked())
			GlobalConfig->KlipsDebug.append("pfkey");
		if (ConfigDaemonOptionsWidget->KlipsDebugXformCheckBox->isChecked())
			GlobalConfig->KlipsDebug.append("xform");
		if (ConfigDaemonOptionsWidget->KlipsDebugErouteCheckBox->isChecked())
			GlobalConfig->KlipsDebug.append("eroute");
		if (ConfigDaemonOptionsWidget->KlipsDebugSpiCheckBox->isChecked())
			GlobalConfig->KlipsDebug.append("spi");
		if (ConfigDaemonOptionsWidget->KlipsDebugRadijCheckBox->isChecked())
			GlobalConfig->KlipsDebug.append("radij");
		if (ConfigDaemonOptionsWidget->KlipsDebugEspCheckBox->isChecked())
			GlobalConfig->KlipsDebug.append("esp");
		if (ConfigDaemonOptionsWidget->KlipsDebugAhCheckBox->isChecked())
			GlobalConfig->KlipsDebug.append("ah");
		if (ConfigDaemonOptionsWidget->KlipsDebugIpcompCheckBox->isChecked())
			GlobalConfig->KlipsDebug.append("ipcomp");
		if (ConfigDaemonOptionsWidget->KlipsDebugVerboseCheckBox->isChecked())
			GlobalConfig->KlipsDebug.append("verbose");
		
		GlobalConfig->tryConnectTimeout = ProfileCiscoOptionsWidget->PeerTimeoutIntNumInput->value();
		GlobalConfig->useSilentQuit = ConnectOptionsWidget->SilentQuitcheckBox->isChecked();
		GlobalConfig->dontQuitOnCloseEvent = GeneralOptionsWidget->DontQuitOnCloseEventCheckBox->isChecked();
		GlobalConfig->hideMainWindow = GeneralOptionsWidget->HideOnStartupCheckBox->isChecked ();
		GlobalConfig->useTDEwallet = GeneralOptionsWidget->useTDEwalletCheckBox->isChecked();
		GlobalConfig->programsInPath =ConfigDaemonOptionsWidget->ProgramsInPathcheckBox->isChecked();
		GlobalConfig->holdGeneratedScripts = DebugOptionsWidget->KeepConnectionFilesCheckBox->isChecked();
		GlobalConfig->InfoLogColor = LogOptionsWidget->InfoLogLabel->paletteBackgroundColor ();
		GlobalConfig->RemoteLogColor = LogOptionsWidget->RemoteLogLabel->paletteBackgroundColor ();
		GlobalConfig->ErrorLogColor = LogOptionsWidget->ErrorLogLabel->paletteBackgroundColor ();
		GlobalConfig->SuccessLogColor = LogOptionsWidget->SuccessLogLabel->paletteBackgroundColor ();
		GlobalConfig->DebugLogColor = LogOptionsWidget->DebugLogLabel->paletteBackgroundColor ();
		GlobalConfig->useColorizedLogOutput = LogOptionsWidget->UseColorizedLogOutputcheckBox->isChecked();
		GlobalConfig->showInterfaceIPinTooltip =ConfigDaemonOptionsWidget->ShowInterfaceIPinTooltipCheckBox->isChecked();
		GlobalConfig->doAutoConnectAtStartup = ConnectOptionsWidget->DoAutoConnectCheckBox->isChecked();
		GlobalConfig->LogViewerFontSize = LogOptionsWidget->LogFontSizeSpinBox->value();
		GlobalConfig->doKillL2tpdIfStillRunning =ConfigDaemonOptionsWidget->DoKillL2tpdIfStillRunningCheckBox->isChecked();
		GlobalConfig->doKillXl2tpdIfStillRunning =ConfigDaemonOptionsWidget->DoKillXl2tpdIfStillRunningCheckBox->isChecked();
		GlobalConfig->doKillRacoonIfStillRunning =ConfigDaemonOptionsWidget->DoKillRacoonIfStillRunningCheckBox->isChecked();
	}

	canAccept = true;
	configChanged=true;


	if ( GlobalConfig->currentProfile == 0 || GlobalConfig->AccountList->isEmpty())
		return ;
	
	GlobalConfig->appPointer->setOverrideCursor( TQCursor( TQt::WaitCursor ) );

	VpnAccountData *profile = GlobalConfig->currentProfile;

	//TQString itemString=ConnectionTypeComboBox->currentText();
	int item = ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() ;
	GlobalConfig->currentProfile->setConnectionType( ( VpnAccountData::ConnectionType ) ( item ) );

// 	KMessageBox::information(0,"connection type changed: "+TQString().setNum(item),TQString("type set"));

	profile->setDescription( ProfileGeneralOptionsWidget->DescriptionLineEdit->text() );

	// cisco
	if ( item == VpnAccountData::cisco || item == VpnAccountData::ciscoorig )
	{

		// 		std::cout << "currentItem: " << ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() << ", guessed type: cisco" << std::endl;
	
		if ( ProfileCertOptionsWidget->AuthTypeComboBox->currentText() == i18n( "X.509 Certificate" ))
			profile->setAuthType(VpnAccountData::cert);
		if ( ProfileCertOptionsWidget->AuthTypeComboBox->currentText() == i18n( "Pre Shared Key" ))
			profile->setAuthType(VpnAccountData::psk);
		if ( ProfileCertOptionsWidget->AuthTypeComboBox->currentText() == i18n( "Hybrid" ))
			profile->setAuthType(VpnAccountData::hybrid);

		if ( ProfileUserOptionsWidget->CheckUserPass->isChecked() && ! ProfileUserOptionsWidget->UsernameLineEdit->text().isEmpty() )
		{
			profile->setSaveUserPassword( true );
			profile->setUserPassword( ProfileUserOptionsWidget->UsernameLineEdit->text() );
		}
		else
		{
			profile->setSaveUserPassword( false );
		}

		if ( ProfilePskOptionsWidget->CheckSavePsk->isChecked() && !ProfilePskOptionsWidget->PSKLineEdit->text().isEmpty() )
		{
			profile->setSavePsk( true );
			profile->setPreSharedKey( ProfilePskOptionsWidget->PSKLineEdit->text() );
		}
		else
		{
			profile->setSavePsk( false );
		}
		profile->setAllowEmptyGroupPassword( ProfileCiscoOptionsWidget->AllowEmptyGroupPasswordCheckBox->isChecked() );
		profile->setUseXauthInteractive( ProfileCiscoOptionsWidget->UseXauthInteractiveCheckBox->isChecked() );
		profile->setUseGlobalIpsecSecret( ProfileCiscoOptionsWidget->UseGlobalIpsecSecretCheckbox->isChecked());
		profile->setID( ProfileCiscoOptionsWidget->IDLineEdit->text() );
		profile->setNtDomainName(ProfileUserOptionsWidget->NtDomainNameLineedit->text() );

		if ( ProfileUserOptionsWidget->NtDomainNameCheckbox->isChecked() )
		{
			profile->setNtDomainName( ProfileUserOptionsWidget->NtDomainNameLineedit->text() );
			profile->setUseNtDomainName( true );
		}
		else
		{
			profile->setUseNtDomainName( false );
		}

		profile->setUseSearchDomainInResolvConf(ProfilePptpOptionsWidget->UseSearchDomainInResolvConfCheckbox->isChecked());
		profile->setUseDomainInResolvConf(ProfilePptpOptionsWidget->UseDomainInResolvConfCheckbox->isChecked());
		profile->setSearchDomainInResolvConf(ProfilePptpOptionsWidget->SearchDomainInResolvConfLineedit->text());
		profile->setDomainInResolvConf(ProfilePptpOptionsWidget->DomainInResolvConfLineedit->text());

		profile->setUseLocalPort(ProfileCiscoOptionsWidget->LocalPortCheckbox->isChecked ( ) );
		profile->setLocalPort(ProfileCiscoOptionsWidget->LocalPortSpinbox->value( ) );

		profile->setPeerTimeout( ProfileCiscoOptionsWidget->PeerTimeoutIntNumInput->value() );


		if (item == VpnAccountData::cisco)
		{
			profile->setDisableDataEncryption(ProfileCiscoOptionsWidget->DisableDataEncryptionCheckbox->isChecked());
			profile->setUseDpdIdleTimeout(ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox->isChecked());
			if ( profile->getAuthType() == VpnAccountData::hybrid)
			{
				profile->setCaCertificate(ProfileCertOptionsWidget->CaCertpathURLRequester->url());
				profile->setCertPath(ProfileCertOptionsWidget->certpathURLRequester->url());
				profile->setPrivateKeyPass( ProfileCertOptionsWidget->PrivkeyPasswordEdit->text());
				profile->setSavePrivateKeyPassword( ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->isChecked());
			}
		}
		
		if ( item == VpnAccountData::ciscoorig)
		{
			if (profile->getAuthType() == VpnAccountData::cert || profile->getAuthType() == VpnAccountData::hybrid)
			{
				profile->setUseCiscoCertStore(ProfileCertOptionsWidget->UseCiscoCertStoreCheckBox->isChecked());
				if (ProfileCertOptionsWidget->UseCiscoCertStoreCheckBox->isChecked())
				{
					profile->setX509Certificate( ProfileCertOptionsWidget->x509certComboBox->currentText());
					profile->setCaCertificate(ProfileCertOptionsWidget->CaCertpathComboBox->currentText());
				}
				else
				{
					profile->setX509Certificate( ProfileCertOptionsWidget->x509certURLRequester->url());
					profile->setCaCertificate(ProfileCertOptionsWidget->CaCertpathURLRequester->url());
					profile->setCertPath(ProfileCertOptionsWidget->certpathURLRequester->url());
				}
				profile->setPrivateKeyPass( ProfileCertOptionsWidget->PrivkeyPasswordEdit->text());
				profile->setSavePrivateKeyPassword( ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->isChecked());
			}
			profile->setUseDpdIdleTimeout(true);
		}
		profile->setDpdIdleTimeout(ProfileCiscoOptionsWidget->DpdIdleTimeoutSpinbox->value());
		profile->setCiscoNatMode(ProfileCiscoOptionsWidget->CiscoNatModeComboBox->currentText());


			if ( ProfileCiscoOptionsWidget->ApplicationVersionCheckbox->isChecked() )
			{
				profile->setApplicationVersion ( ProfileCiscoOptionsWidget->ApplicationVersionLineedit->text() );
				profile->setUseApplicationVersion ( true );
			}
			else
			{
				profile->setUseApplicationVersion ( false );
			}

			if ( ProfileCiscoOptionsWidget->IkeGroupCheckbox->isChecked() )
			{
				profile->setIkeGroup ( ProfileCiscoOptionsWidget->IkeGroupCombobox->currentText() );
				profile->setUseIkeGroup ( true );
			}
			else
			{
				profile->setUseIkeGroup ( false );
			}

			if ( ProfileCiscoOptionsWidget->PerfectForwardSecurityCheckbox->isChecked() )
			{
				profile->setPerfectForwardSecrety ( ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->currentText() );
				profile->setUsePerfectForwardSecrety ( true );
			}
			else
			{
				profile->setUsePerfectForwardSecrety ( false );
			}


			if ( ProfileCiscoOptionsWidget->SingleDesCheckbox->isChecked() )
			{
				profile->setUseSingleDes ( true );
			}
			else
			{
				profile->setUseSingleDes ( false );
			}


		profile->setHideGroupPasswordInAccountDataDialog(ProfileUserOptionsWidget->HideGroupPasswordInAccountDataDialogCheckBox->isChecked());
	}
	else if ( item == VpnAccountData::racoon || item == VpnAccountData::l2tpd_racoon || item == VpnAccountData::freeswan || item == VpnAccountData::l2tpd_freeswan )
	{

		bool validAddr = true;

		if (ProfileNetworkGeneralOptionsWidget->UseRemoteNetworkCheckBox->isChecked())
		{
			if ( ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->text().contains( '.' ) != 3 )
			{
				KMessageBox::error ( this, i18n( "No remote network entered!" ), i18n( "No remote network" ) );
				GlobalConfig->appendLogEntry( i18n( "No remote network entered!" ) , GlobalConfig->error );
				validAddr = false;
			}
			else
			{
				TQString addr = ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->text();
				int part0 = addr.section( '.', 0, 0 ).toInt();
				int part1 = addr.section( '.', 1, 1 ).toInt();
				int part2 = addr.section( '.', 2, 2 ).toInt();
				int part3 = addr.section( '.', 3, 3 ).toInt();

				/*
							LogOutput->append ("part0: "+TQString().setNum(part0));
							LogOutput->append ("part1: "+TQString().setNum(part1));
							LogOutput->append ("part2: "+TQString().setNum(part2));
							LogOutput->append ("part3: "+TQString().setNum(part3));
				*/
				if ( ( part0 < 1 || part0 > 254 ) || ( part1 < 0 || part1 > 254 ) || ( part2 < 0 || part2 > 254 ) || ( part3 < 0 || part3 > 254 ) )
				{
					KMessageBox::error ( this, i18n( "IP address (remote net) is not valid!" ), i18n( "Invalid IP Address" ) );
					// 				GlobalConfig->appendLogEntry( i18n( "IP address (remote net) is not valid!" ) ,GlobalConfig->error);
					canAccept = false;
					validAddr = false;
				}
				if ( validAddr == true )
				{
					profile->setUseRemoteNetwork(true);
					profile->setRemoteNetAddr( addr );
					profile->setRemoteNetMask( ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->currentText() );
				}
			}
		}
		else
		{
			profile->setUseRemoteNetwork(false);
		}

		if ( item == VpnAccountData::racoon || item == VpnAccountData::l2tpd_racoon)
		{
			if (ProfileRacoonOptionsWidget->RemoteIdTypeCombobox->currentText() != "none")
				profile->setUseSpecialRemoteID( true );
			else
				profile->setUseSpecialRemoteID( false );
	
			if (ProfileRacoonOptionsWidget->LocalIdTypeCombobox->currentText() != "none")
				profile->setUseSpecialLocalID( true );
			else
				profile->setUseSpecialLocalID( false );

			if ( ProfileCertOptionsWidget->AuthTypeComboBox->currentItem() == 0 )
				profile->setAuthType( VpnAccountData::cert );
			if ( ProfileCertOptionsWidget->AuthTypeComboBox->currentItem() == 1 )
				profile->setAuthType( VpnAccountData::psk );
			if ( ProfileCertOptionsWidget->AuthTypeComboBox->currentItem() == 2 )
				profile->setAuthType( VpnAccountData::hybrid );

			if ( ProfilePskOptionsWidget->AuthTypeComboBox->currentItem() == 0 )
				profile->setAuthType( VpnAccountData::cert );
			if ( ProfilePskOptionsWidget->AuthTypeComboBox->currentItem() == 1 )
				profile->setAuthType( VpnAccountData::psk );
			if ( ProfilePskOptionsWidget->AuthTypeComboBox->currentItem() == 2 )
				profile->setAuthType( VpnAccountData::hybrid );

			profile->setLocalIDType( ProfileRacoonOptionsWidget->LocalIdTypeCombobox->currentText());
			profile->setSpecialLocalID(ProfileRacoonOptionsWidget->LocalIDLineEdit->text());

			profile->setRemoteIDType( ProfileRacoonOptionsWidget->RemoteIdTypeCombobox->currentText());
			profile->setSpecialRemoteID(ProfileRacoonOptionsWidget->RemoteIDLineEdit->text());

			if  (item == VpnAccountData::l2tpd_racoon)
			{
				if (ProfilePptpOptionsWidget->AuthMethodComboBox->currentItem() == 0)
					profile->setAuthMethod("chap");
				if (ProfilePptpOptionsWidget->AuthMethodComboBox->currentItem() == 1)
					profile->setAuthMethod("pap");
				if (ProfilePptpOptionsWidget->AuthMethodComboBox->currentItem() == 2)
					profile->setAuthMethod("mschap");
				if (ProfilePptpOptionsWidget->AuthMethodComboBox->currentItem() == 3)
					profile->setAuthMethod("mschap-v2");
			}

			// xauth
			if (profile->getConnectionType() == VpnAccountData::racoon && ProfileRacoonOptionsWidget->UseXauthCheckBox->isChecked())
			{
				if (ProfilePskOptionsWidget->CheckSavePsk->isChecked())
				{
					TQString Psk=ProfilePskOptionsWidget->PSKLineEdit->text();
					if (ProfilePskOptionsWidget->PskInFileCheckBox->isChecked())
					{
						TQString PskFileName = ProfilePskOptionsWidget->PSKFileURLRequester->url();
						TQFile PskFile (PskFileName);
						if (PskFile.open(IO_WriteOnly))
						{
							TQTextStream stream ( &PskFile );
							stream << Psk;
							profile->setPskIsInFile(true);
							profile->setSavePsk(true);
							PskFile.close();
						}
						else
						{
							profile->setSavePsk(false);
						}
					}
					else
					{
						if (!Psk.isEmpty())
						{
							profile->setPreSharedKey(Psk);
							profile->setSavePsk(true);
						}
					}
				}
				profile->setAuthWithUsernameAndPassword(true);
				profile->setUserName(ProfileUserOptionsWidget->UsernameLineEdit->text());
				if (ProfileUserOptionsWidget->CheckUserPass->isChecked())
				{
					TQString UserPassword = ProfileUserOptionsWidget->PasswordEdit->text();
					if (!UserPassword.isEmpty())
					{
						profile->setUserPassword(UserPassword);
						profile->setSaveUserPassword(true);
					}
					else
						profile->setSaveUserPassword(false);
				}

// 				if ( ProfileIpsecOptionsWidget->LocalIDLineEdit->text().isEmpty() )
// 				{
// 					KMessageBox::error ( this, i18n( "Local ID (Group ID)  is empty!" ), i18n( "Local ID  (Group ID) is empty" ) );
// 					GlobalConfig->appendLogEntry( i18n( "Local ID (Group ID)  is empty!" ) , GlobalConfig->error );
// 					canAccept = false;
// 				}

			}
			else
			{
				profile->setAuthWithUsernameAndPassword(false);
			}

			if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::hybrid)
			{
				profile->setCaCertificate(ProfileCertOptionsWidget->CaCertpathURLRequester->url());
				profile->setVerifyCaCert(ProfileCertOptionsWidget->VerifyCaCertCheckBox->isChecked());
				profile->setAuthWithUsernameAndPassword(true);
				profile->setUserName(ProfileUserOptionsWidget->UsernameLineEdit->text());
				if (ProfileUserOptionsWidget->CheckUserPass->isChecked())
				{
					TQString UserPassword = ProfileUserOptionsWidget->PasswordEdit->text();
					if (!UserPassword.isEmpty())
					{
						profile->setUserPassword(UserPassword);
						profile->setSaveUserPassword(true);
					}
					else
						profile->setSaveUserPassword(false);
				}
			}

			profile->setUseModeConfig(ProfileRacoonOptionsWidget->UseModeConfigCheckBox->isChecked( ) );

			profile->setUseLeftSourceIp(ProfileNetworkVirtualIpOptionsWidget->UseLeftSourceIpCheckBox->isChecked( ));
			profile->setUseRightSourceIp(ProfileNetworkVirtualIpOptionsWidget->UseRightSourceIpCheckBox->isChecked());

			if (ProfileNetworkVirtualIpOptionsWidget->UseLeftSourceIpCheckBox->isChecked( ) &&ProfileNetworkVirtualIpOptionsWidget->LeftSourceIpLineEdit->text().isEmpty() )
			{
				KMessageBox::error ( this, i18n( "Local Source IP address is empty!" ), i18n( "Local Source IP empty" ) );
				GlobalConfig->appendLogEntry( i18n( "Local Source IP address is empty!" ) , GlobalConfig->error );
				canAccept = false;
			}
			else
				profile->setLeftSourceIp(ProfileNetworkVirtualIpOptionsWidget->LeftSourceIpLineEdit->text());

			if (ProfileNetworkVirtualIpOptionsWidget->UseRightSourceIpCheckBox->isChecked( ) &&ProfileNetworkVirtualIpOptionsWidget->RightSourceIpLineEdit->text().isEmpty() )
			{
				KMessageBox::error ( this, i18n( "Remote Source IP address is empty!" ), i18n( "Remote Source IP empty" ) );
				GlobalConfig->appendLogEntry( i18n( "Remote Source IP address is empty!" ) , GlobalConfig->error );
				canAccept = false;
			}
			else
				profile->setRightSourceIp(ProfileNetworkVirtualIpOptionsWidget->LeftSourceIpLineEdit->text());

		}
		if ( item == VpnAccountData::freeswan || item == VpnAccountData::l2tpd_freeswan)
		{

			if (ProfileIpsecOptionsWidget->RemoteIdTypeCombobox->currentText() != "none")
				profile->setUseSpecialRemoteID( true );
			else
				profile->setUseSpecialRemoteID( false );
	
			if (ProfileIpsecOptionsWidget->LocalIdTypeCombobox->currentText() != "none")
				profile->setUseSpecialLocalID( true );
			else
				profile->setUseSpecialLocalID( false );

			if ( ProfileCertOptionsWidget->AuthTypeComboBox->currentItem() == 0 )
				profile->setAuthType( VpnAccountData::cert );
			if ( ProfileCertOptionsWidget->AuthTypeComboBox->currentItem() == 1 )
				profile->setAuthType( VpnAccountData::psk );

			if ( ProfilePskOptionsWidget->AuthTypeComboBox->currentItem() == 0 )
				profile->setAuthType( VpnAccountData::cert );
			if ( ProfilePskOptionsWidget->AuthTypeComboBox->currentItem() == 1 )
				profile->setAuthType( VpnAccountData::psk );

			profile->setDisableOpportunisticEncryption( ProfileIpsecOptionsWidget->DisableOpportunisticEncryptionCheckBox->isChecked( ) );
			if (ProfileIpsecOptionsWidget->IpsecVpnModeCombobox->currentText() == "transport" )
				profile->setIpsecVpnMode("transport");
			else
				profile->setIpsecVpnMode("tunnel");

			profile->setPrivateKey( ProfileCertOptionsWidget->privkeypathURLRequester->url() );
			profile->setPrivateKeyPass( ProfileCertOptionsWidget->PrivkeyPasswordEdit->text() );
			profile->setSaveUserPassword ( ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->isChecked() );

			// ike + esp
			TQStringList IkeList;
			TQStringList EspList;

			if (ProfileIpsecOptionsWidget->IkeAes256Sha1CheckBox->isChecked())
				IkeList.append("aes256-sha1");
			if (ProfileIpsecOptionsWidget->IkeAes128Sha1CheckBox->isChecked())
				IkeList.append("aes128-sha1");
			if (ProfileIpsecOptionsWidget->IkeDesSha1Modp2048CheckBox->isChecked())
				IkeList.append("3des-sha1-modp2048");
			if (ProfileIpsecOptionsWidget->IkeDesMd5CheckBox->isChecked())
				IkeList.append("3des-md5");
			if (ProfileIpsecOptionsWidget->IkeDesSha1CheckBox->isChecked())
				IkeList.append("3des-sha1");

			if (!ProfileIpsecOptionsWidget->OtherIkeLineEdit->text().isEmpty())
				IkeList.append(ProfileIpsecOptionsWidget->OtherIkeLineEdit->text());

			if (ProfileIpsecOptionsWidget->Esp3desMd5CheckBox->isChecked())
				EspList.append("3des-md5");
			if (ProfileIpsecOptionsWidget->EspDesSha1CheckBox->isChecked())
				EspList.append("3des-sha1");
			if (ProfileIpsecOptionsWidget->EspAes128Sha1CheckBox->isChecked())
				EspList.append( "aes128-sha1");
			if (ProfileIpsecOptionsWidget->EspAes256Sha1CheckBox->isChecked())
				EspList.append( "aes256-sha1");

			if (!ProfileIpsecOptionsWidget->OtherEspLineEdit->text().isEmpty())
				EspList.append(ProfileIpsecOptionsWidget->OtherEspLineEdit->text());

			if(ProfileIpsecOptionsWidget->UseCustomIkeCheckBox->isChecked() && IkeList.isEmpty())
			{
				KMessageBox::error ( this, i18n( "Use custom IKE checked but none selected!" ), i18n( "No custom IKE" ) );
				canAccept = false;
			}

			if(ProfileIpsecOptionsWidget->UseCustomEspCheckBox->isChecked() && EspList.isEmpty())
			{
				KMessageBox::error ( this, i18n( "Use custom ESP checked but none selected!" ), i18n( "No custom ESP" ) );
				canAccept = false;
			}



			profile->setIpsecEsp(EspList.join(","));
			profile->setIpsecIke(IkeList.join(","));

			for ( TQStringList::Iterator ikeit = IkeList.begin(); ikeit != IkeList.end(); ++ikeit )
				std::cout << "ike: " << *ikeit << ":" << std::endl;

			for ( TQStringList::Iterator espit = EspList.begin(); espit != EspList.end(); ++espit )
				std::cout << "esp: " << *espit << ":" << std::endl;

			if(ProfileIpsecOptionsWidget->UseCustomEspCheckBox->isChecked() && !EspList.isEmpty())
				profile->setUseCustomEsp(true);
			else
				profile->setUseCustomEsp(false);

			if(ProfileIpsecOptionsWidget->UseCustomIkeCheckBox->isChecked() && !IkeList.isEmpty())
				profile->setUseCustomIke(true);
			else
				profile->setUseCustomIke(false);

			if  (item == VpnAccountData::l2tpd_freeswan)
			{
				if (ProfilePptpOptionsWidget->AuthMethodComboBox->currentItem() == 0)
					profile->setAuthMethod("chap");
				if (ProfilePptpOptionsWidget->AuthMethodComboBox->currentItem() == 1)
					profile->setAuthMethod("pap");
				if (ProfilePptpOptionsWidget->AuthMethodComboBox->currentItem() == 2)
					profile->setAuthMethod("mschap");
				if (ProfilePptpOptionsWidget->AuthMethodComboBox->currentItem() == 3)
					profile->setAuthMethod("mschap-v2");
			}
			else
			{
				profile->setAuthWithUsernameAndPassword(ProfileIpsecOptionsWidget->UseXauthCheckBox->isChecked());
				profile->setUserName(ProfileUserOptionsWidget->UsernameLineEdit->text());

				if (!ProfileUserOptionsWidget->PasswordEdit->text().isEmpty())
					profile->setUserPassword(ProfileUserOptionsWidget->PasswordEdit->text());
			}

// 			if (ProfileIpsecOptionsWidget->ExchangeModeComboBox->currentItem() == 0)
// 				profile->setExchangeMode("main");
// 
// 			if (ProfileIpsecOptionsWidget->ExchangeModeComboBox->currentItem() == 1)
// 				profile->setExchangeMode("aggressive");
// 
// 			if (ProfileIpsecOptionsWidget->ExchangeModeComboBox->currentItem() == 2)
// 				profile->setExchangeMode("base");
			profile->setExchangeMode(ProfileIpsecOptionsWidget->ExchangeModeComboBox->currentText());

			// xauth
			if (profile->getConnectionType() == VpnAccountData::freeswan && ProfileIpsecOptionsWidget->UseXauthCheckBox->isChecked())
			{
				if (ProfilePskOptionsWidget->CheckSavePsk->isChecked())
				{
					TQString Psk=ProfilePskOptionsWidget->PSKLineEdit->text();
					if (ProfilePskOptionsWidget->PskInFileCheckBox->isChecked())
					{
						TQString PskFileName = ProfilePskOptionsWidget->PSKFileURLRequester->url();
						TQFile PskFile (PskFileName);
						if (PskFile.open(IO_WriteOnly))
						{
							TQTextStream stream ( &PskFile );
							stream << Psk;
							profile->setPskIsInFile(true);
							profile->setSavePsk(true);
							PskFile.close();
						}
						else
						{
							profile->setSavePsk(false);
						}
					}
					else
					{
						if (!Psk.isEmpty())
						{
							profile->setPreSharedKey(Psk);
							profile->setSavePsk(true);
						}
					}
				}
				profile->setAuthWithUsernameAndPassword(true);
				profile->setUserName(ProfileUserOptionsWidget->UsernameLineEdit->text());
				if (ProfileUserOptionsWidget->CheckUserPass->isChecked())
				{
					TQString UserPassword = ProfileUserOptionsWidget->PasswordEdit->text();
					if (!UserPassword.isEmpty())
					{
						profile->setUserPassword(UserPassword);
						profile->setSaveUserPassword(true);
					}
					else
						profile->setSaveUserPassword(false);
				}

				if ( ProfileIpsecOptionsWidget->LocalIDLineEdit->text().isEmpty() )
				{
					KMessageBox::error ( this, i18n( "Local ID (Group ID)  is empty!" ), i18n( "Local ID  (Group ID) is empty" ) );
					GlobalConfig->appendLogEntry( i18n( "Local ID (Group ID)  is empty!" ) , GlobalConfig->error );
					canAccept = false;
				}

			}
			else
			{
				profile->setAuthWithUsernameAndPassword(false);
			}

			profile->setUseLeftSourceIp(ProfileNetworkVirtualIpOptionsWidget->UseLeftSourceIpCheckBox->isChecked( ));
			profile->setUseRightSourceIp(ProfileNetworkVirtualIpOptionsWidget->UseRightSourceIpCheckBox->isChecked());

			if (ProfileNetworkVirtualIpOptionsWidget->UseLeftSourceIpCheckBox->isChecked( ) &&ProfileNetworkVirtualIpOptionsWidget->LeftSourceIpLineEdit->text().isEmpty() )
			{
				KMessageBox::error ( this, i18n( "Local Source IP address is empty!" ), i18n( "Local Source IP empty" ) );
				GlobalConfig->appendLogEntry( i18n( "Local Source IP address is empty!" ) , GlobalConfig->error );
				canAccept = false;
			}
			else
				profile->setLeftSourceIp(ProfileNetworkVirtualIpOptionsWidget->LeftSourceIpLineEdit->text());

			profile->setUseVirtualIP(ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked());
			profile->setLocalVirtualIP(ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text());
			profile->setRemoteVirtualIP(ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->text());

			if (ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked( ) &&ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->text().isEmpty() )
			{
				KMessageBox::error ( this, i18n( "Remote virtual IP address is empty!" ), i18n( "Remote virtual IP empty" ) );
				GlobalConfig->appendLogEntry( i18n( "Remote virtual IP address is empty!" ) , GlobalConfig->error );
				canAccept = false;
			}



		} // freeswan


		profile->setX509Certificate( ProfileCertOptionsWidget->x509certURLRequester->url() );
		profile->setCertPath( ProfileCertOptionsWidget->certpathURLRequester->url() );
		profile->setCaCertificate( ProfileCertOptionsWidget->CaCertpathURLRequester->url() );
		profile->setPrivateKey ( ProfileCertOptionsWidget->privkeypathURLRequester->url() );
		profile->setPrivateKeyPass ( ProfileCertOptionsWidget->PrivkeyPasswordEdit->text() );
		profile->setPreSharedKey( ProfilePskOptionsWidget->PSKLineEdit->text() );
		
		if (ProfileNetworkVirtualIpOptionsWidget->UseRightSourceIpCheckBox->isChecked( ) &&ProfileNetworkVirtualIpOptionsWidget->RightSourceIpLineEdit->text().isEmpty() )
		{
			KMessageBox::error ( this, i18n( "Remote Source IP address is empty!" ), i18n( "Remote Source IP empty" ) );
			GlobalConfig->appendLogEntry( i18n( "Remote Source IP address is empty!" ) , GlobalConfig->error );
			canAccept = false;
		}
		else
			profile->setRightSourceIp(ProfileNetworkVirtualIpOptionsWidget->RightSourceIpLineEdit->text());

		if (ProfileNetworkVirtualIpOptionsWidget->UseVirtualSubnetsCheckBox->isChecked())
		{
			if(ProfileNetworkVirtualIpOptionsWidget->VirtualSubnetsLineEdit->text().isEmpty())
			{
				KMessageBox::error ( this, i18n( "Virtual subnets are empty!" ), i18n( "Virtual subnets empty" ) );
				GlobalConfig->appendLogEntry( i18n( "Virtual subnets are empty!" ) , GlobalConfig->error );
				canAccept = false;
			}
		}
		profile->setVirtualSubnetworks(ProfileNetworkVirtualIpOptionsWidget->VirtualSubnetsLineEdit->text()); //FIXME hacking subnets list from linedit!
		profile->setUseVirtualSubnetworks(ProfileNetworkVirtualIpOptionsWidget->UseVirtualSubnetsCheckBox->isChecked());

		if ( ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked() && !ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text().isEmpty() )
		{
			// do check for vailid IP
			if ( !Utils( GlobalConfig ).isValidIPv4Address( ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text() ) )
			{
				KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No Valid IP Address" ) );
				GlobalConfig->appendLogEntry( i18n( "No valid IP address entered!" ) , GlobalConfig->error );
				canAccept = false;
			}
			else
			{
				profile->setVirtualIP( ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text() );
				profile->setUseVirtualIP( ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked() );
			}
		}
		else
		{
			if ( ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked())
			{
				if( ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text().isEmpty() &&  ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->text().isEmpty())
				{
					KMessageBox::error ( this, i18n( "No IP address (virtual IP) entered!" ), i18n( "No IP Address" ) );
					// 				GlobalConfig->appendLogEntry(i18n( "No IP address (virtual IP) entered!" ) ,GlobalConfig->error);
					canAccept = false;
				}
			}
			else
			{
				profile->setVirtualIP( "" );
				profile->setUseVirtualIP( false );
			}
		}




		if ( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() == VpnAccountData::racoon ||
		        ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() == VpnAccountData::l2tpd_racoon
		   )
		{
		
			// phase 1
			profile->setIpsecIke(ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->currentText());
			profile->setHashAlgo( ProfileRacoonOptionsWidget->HashAlgoComboBox->currentText());
			profile->setUseAuthenticationAlgorithm(true);
			profile->setIkeGroup( ProfileRacoonOptionsWidget->DHGroupComboBox->currentText() );


			profile->setEncryptionAlgorithm( ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->currentText() );
			profile->setAuthenticationAlgorithm( ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->currentText() );


			if ( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() == VpnAccountData::l2tpd_racoon )
			{
				profile->setUserName( ProfileUserOptionsWidget->UsernameLineEdit->text() );

				if ( ProfileUserOptionsWidget->CheckUserPass->isChecked() )
				{
					profile->setSaveUserPassword( true );
					profile->setUserPassword( ProfileUserOptionsWidget->PasswordEdit->text() );
				}
				else
					profile->setSaveUserPassword( true );
			}

			if ( ProfileRacoonOptionsWidget->IkeGroupCheckbox->isChecked() )
			{
				profile->setIkeGroup ( ProfileRacoonOptionsWidget->DHGroupComboBox->currentText() );
				profile->setUseIkeGroup ( true );
			}
			else
			{
				profile->setUseIkeGroup ( false );
			}

			if ( ProfileRacoonOptionsWidget->PerfectForwardSecurityCheckbox->isChecked() )
			{
				profile->setPerfectForwardSecrety ( ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->currentText() );
				profile->setUsePerfectForwardSecrety ( true );
			}
			else
			{
				profile->setUsePerfectForwardSecrety ( false );
			}


// 			if (ProfileRacoonOptionsWidget->UseSpecialLocalIDcheckBox->isChecked())
// 			{
// 				profile->setSpecialLocalID(ProfileRacoonOptionsWidget->LocalIDLineEdit->text());
// 				profile->setUseSpecialLocalID(true);
// 			}
// 			else
// 			{
// 				profile->setUseSpecialLocalID(false);
// 			}
			profile->setLocalIDType( ProfileRacoonOptionsWidget->LocalIdTypeCombobox->currentText());
			profile->setSpecialLocalID(ProfileRacoonOptionsWidget->LocalIDLineEdit->text());
			profile->setRemoteIDType( ProfileRacoonOptionsWidget->RemoteIdTypeCombobox->currentText());
			profile->setSpecialRemoteID(ProfileRacoonOptionsWidget->RemoteIDLineEdit->text());

			profile->setExchangeMode( ProfileRacoonOptionsWidget->ExchangeModeComboBox->currentText() );
			profile->setVerifyCaCert(ProfileCertOptionsWidget->VerifyCaCertCheckBox->isChecked());
		}
		if ( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() == VpnAccountData::freeswan ||
		        ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() == VpnAccountData::l2tpd_freeswan
		   )
		{

			if ( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() == VpnAccountData::l2tpd_freeswan )
			{
				profile->setUserName( ProfileUserOptionsWidget->UsernameLineEdit->text() );

				if ( ProfileUserOptionsWidget->CheckUserPass->isChecked() )
				{
					profile->setSaveUserPassword( true );
					profile->setUserPassword( ProfileUserOptionsWidget->PasswordEdit->text() );
				}
				else
					profile->setSaveUserPassword( true );
			}

			if ( ProfileIpsecOptionsWidget->PerfectForwardSecurityCheckbox->isChecked() )
			{
				profile->setUsePerfectForwardSecrety ( true );
			}
			else
			{
				profile->setUsePerfectForwardSecrety ( false );
			}
			profile->setPerfectForwardSecrety( ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->currentText() );
			
			if (ProfileIpsecOptionsWidget->RemoteIdTypeCombobox->currentText() != "none" && !ProfileIpsecOptionsWidget->RemoteIDLineEdit->text().isEmpty())
			{
				profile->setUseSpecialRemoteID(true);
				
			}
			else
				profile->setUseSpecialRemoteID(false);
		}



		if ( profile->getConnectionType() == VpnAccountData::l2tpd_freeswan || profile->getConnectionType() == VpnAccountData::l2tpd_racoon )
		{
			if (ProfilePptpOptionsWidget->L2tpDaemonComboBox->currentItem() == 0)
				profile->setL2tpDaemon(VpnAccountData::l2tpd);
   			if (ProfilePptpOptionsWidget->L2tpDaemonComboBox->currentItem() == 1)
				profile->setL2tpDaemon(VpnAccountData::openl2tp);
		}

	}
	else if ( item == VpnAccountData::pptp )
	{
		
		bool validAddr = true;
		if ( !ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->text().isEmpty() )
		{
			if ( ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->text().contains( '.' ) != 3 )
			{
				//KMessageBox::error ( this, i18n( "No IP address entered!" ), i18n( "No IP Address" ) );
				validAddr = false;
			}
			else
			{
				TQString addr = ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->text();
				int part0 = addr.section( '.', 0, 0 ).toInt();
				int part1 = addr.section( '.', 1, 1 ).toInt();
				int part2 = addr.section( '.', 2, 2 ).toInt();
				int part3 = addr.section( '.', 3, 3 ).toInt();

				/*
							LogOutput->append ("part0: "+TQString().setNum(part0));
							LogOutput->append ("part1: "+TQString().setNum(part1));
							LogOutput->append ("part2: "+TQString().setNum(part2));
							LogOutput->append ("part3: "+TQString().setNum(part3));
				*/

				if ( ( part0 < 1 || part0 > 254 ) || ( part1 < 0 || part1 > 254 ) || ( part2 < 0 || part2 > 254 ) || ( part3 < 0 || part3 > 254 ) )
				{
					KMessageBox::error ( this, i18n( "Invalid values in IP address (remote net)!" ), i18n( "Invalid Values in IP Address" ) );
					GlobalConfig->appendLogEntry( i18n( "Invalid values in IP address (remote net)!" ) , GlobalConfig->error );
					validAddr = false;
				}


				if ( validAddr == true )
				{
					profile->setRemoteNetAddr( addr );
					profile->setRemoteNetMask( ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->currentText() );
				}

			}
		}
		else
		{
			profile->setRemoteNetAddr( "" );
			profile->setRemoteNetMask( "" );
		}

		// 		if (ProfileNetworkRouteOptionsWidget->DefaultRouteComboBox->currentText() == i18n("Keep default route"))
		if ( ProfileNetworkRouteOptionsWidget->DefaultRouteComboBox->currentItem() == 0 )
		{
			profile->setReplaceDefaultRoute( false );
		}

		profile->setAllowStatefulMode( ProfilePptpOptionsWidget->AllowStatefulModeCheckbox->isChecked() );
		profile->setUseNoIpDefault( ProfilePptpOptionsWidget->UseNoIpDefaultCheckbox->isChecked() );
		profile->setDisableMPPEComp( ProfilePptpOptionsWidget->UseNoMPPECompressionCheckbox->isChecked() );
		profile->setRequireMppe( ProfilePptpOptionsWidget->RequireMppeCheckbox->isChecked() );
		profile->setRefuse128BitEncryption( ProfilePptpOptionsWidget->Refuse128BitEncryptionCheckbox->isChecked() );
		profile->setRefuse40BitEncryption( ProfilePptpOptionsWidget->Refuse40BitEncryptionCheckbox->isChecked() );
		profile->setDisableMPPEComp( ProfilePptpOptionsWidget->UseNoMPPECompressionCheckbox->isChecked() );
		profile->setUseDnsServer( ProfilePptpOptionsWidget->DnsServerCheckbox->isChecked() );
		profile->setDnsServer( ProfilePptpOptionsWidget->DnsServerLineedit->text() );
		profile->setUseNoBsdComp( ProfilePptpOptionsWidget->UseNoBsdCompCheckbox->isChecked() );
		profile->setUseNoDeflate( ProfilePptpOptionsWidget->UseNoDeflateCheckbox->isChecked() );
		profile->setDisableHeaderCompression(ProfilePptpOptionsWidget->DisableHeaderCompressionCheckbox->isChecked());
		profile->setDisableMagicNumberNegotiation(ProfilePptpOptionsWidget->DisableMagicNumberNegotiationCheckbox->isChecked());
		profile->setDisableIpx(ProfilePptpOptionsWidget->DisableIpxCheckbox->isChecked());
		profile->setDisableAdressControlCompression(ProfilePptpOptionsWidget->DisableAdressControlCompressionCheckbox->isChecked());
		profile->setDisableProtocolFieldCompression(ProfilePptpOptionsWidget->DisableProtocolFieldCompressionCheckbox->isChecked());
		profile->setRequireEap(ProfilePptpOptionsWidget->RequireEapCheckbox->isChecked());

		// 		if (ProfileNetworkRouteOptionsWidget->DefaultRouteComboBox->currentText() == i18n("Keep default route"))
	
		profile->setNtDomainName(ProfileUserOptionsWidget->NtDomainNameLineedit->text() );
		profile->setUseSearchDomainInResolvConf(ProfilePptpOptionsWidget->UseSearchDomainInResolvConfCheckbox->isChecked());
		profile->setUseDomainInResolvConf(ProfilePptpOptionsWidget->UseDomainInResolvConfCheckbox->isChecked());
		profile->setSearchDomainInResolvConf(ProfilePptpOptionsWidget->SearchDomainInResolvConfLineedit->text());
		profile->setDomainInResolvConf(ProfilePptpOptionsWidget->DomainInResolvConfLineedit->text());

		if ( ProfileUserOptionsWidget->NtDomainNameCheckbox->isChecked() && !ProfileUserOptionsWidget->NtDomainNameLineedit->text().isEmpty() )
		{
			profile->setNtDomainName( ProfileUserOptionsWidget->NtDomainNameLineedit->text() );
			profile->setUseNtDomainName( true );
		}
		else
		{
			profile->setUseNtDomainName( false );
		}
		if (ProfilePptpOptionsWidget->AuthMethodComboBox->currentItem() == 0)
			profile->setAuthMethod("chap");
		if (ProfilePptpOptionsWidget->AuthMethodComboBox->currentItem() == 1)
			profile->setAuthMethod("pap");
		if (ProfilePptpOptionsWidget->AuthMethodComboBox->currentItem() == 2)
			profile->setAuthMethod("mschap");
		if (ProfilePptpOptionsWidget->AuthMethodComboBox->currentItem() == 3)
			profile->setAuthMethod("mschap-v2");

		bool IPOk=true;
		if ( ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked())
		{
			TQString LocalVirtualIp = ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text();
			if (Utils( GlobalConfig ).isValidIPv4Address (LocalVirtualIp) == false)
			{
				KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No Valid IP Address" ) );
				IPOk=false;
			}
			else
			{
				profile->setLocalVirtualIP( LocalVirtualIp);
			}
	
			TQString RemoteVirtualIp = ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->text();
			if (Utils( GlobalConfig ).isValidIPv4Address(RemoteVirtualIp) == false)
			{
				KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No Valid IP Address" ) );
				IPOk=false;
			}
			else
			{
				profile->setRemoteVirtualIP( RemoteVirtualIp);
			}
		}
		if (IPOk )
			profile->setUseVirtualIP( ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked());
		else
			profile->setUseVirtualIP( false );

	}
	else if ( item == VpnAccountData::openvpn )
	{

		ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( false );

		bool validAddr = true;
		if ( ProfileNetworkGeneralOptionsWidget->PingCheckBox->isChecked() && ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->text().contains( '.' ) != 3 )
		{
			KMessageBox::error ( this, i18n( "No IP address entered!" ), i18n( "No IP Address" ) );
			GlobalConfig->appendLogEntry( i18n( "No IP address entered!" ) , GlobalConfig->error );
			validAddr = false;
		}
		else
		{
			TQString addr = ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->text();
			// 					int part0 = addr.section( '.', 0, 0 ).toInt();
			// 					int part1 = addr.section( '.', 1, 1 ).toInt();
			// 					int part2 = addr.section( '.', 2, 2 ).toInt();
			// 					int part3 = addr.section( '.', 3, 3 ).toInt();

			/*
						LogOutput->append ("part0: "+TQString().setNum(part0));
						LogOutput->append ("part1: "+TQString().setNum(part1));
						LogOutput->append ("part2: "+TQString().setNum(part2));
						LogOutput->append ("part3: "+TQString().setNum(part3));
			*/ 
			// 					if ( ( part0 < 1 || part0 > 254 ) || ( part1 < 0 || part1 > 254 ) || ( part2 < 0 || part2 > 254 ) || ( part3 < 0 || part3 > 254 ) )
			// 					{
			// 						KMessageBox::error ( this, i18n( "IP address (remote net) is invalid!" ), i18n( "Invalid IP Address" ) );
			// 						GlobalConfig->appendLogEntry(i18n( "IP address (remote net) is invalid!" ) ,GlobalConfig->error);
			// 						validAddr = false;
			// 					}


		}

		bool IPOk=true;
		if (ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked())
		{
			TQString LocalVirtualIp = ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text();
			if (Utils( GlobalConfig ).isValidIPv4Address (LocalVirtualIp) == false)
			{
				KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No Valid IP Address" ) );
				IPOk=false;
			}
			else
			{
				profile->setLocalVirtualIP( LocalVirtualIp);
			}
	
			TQString RemoteVirtualIp = ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->text();
	
			if (ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->currentText().lower() == "tun")
			{
				if (Utils( GlobalConfig ).isValidIPv4Address(RemoteVirtualIp) == false)
				{
					KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No valid IP address" ) );
					IPOk=false;
				}
				else
				{
					profile->setRemoteVirtualIP( RemoteVirtualIp);
				}
			}
			if (ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->currentText().lower() == "tap")
			{
				if (Utils( GlobalConfig ).isValidIPv4Netmask (RemoteVirtualIp) == false)
				{
					KMessageBox::error ( this, i18n( "No valid netmask entered!" ), i18n( "No valid netmask" ) );
					IPOk=false;
				}
				else
				{
					profile->setRemoteVirtualIP( RemoteVirtualIp);
				}
			}
		}
		if (IPOk )
			profile->setUseVirtualIP( ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked());
		else
			profile->setUseVirtualIP( false );
		
		if ( ProfileCertOptionsWidget->AuthTypeComboBox->currentItem() == 0 )
			profile->setAuthType( VpnAccountData::cert );
		if ( ProfileCertOptionsWidget->AuthTypeComboBox->currentItem() == 1 )
			profile->setAuthType( VpnAccountData::psk );

		if ( ProfilePskOptionsWidget->AuthTypeComboBox->currentItem() == 0 )
			profile->setAuthType( VpnAccountData::cert );
		if ( ProfilePskOptionsWidget->AuthTypeComboBox->currentItem() == 1 )
			profile->setAuthType( VpnAccountData::psk );

		

		profile->setPreSharedKeyFile( ProfilePskOptionsWidget->PSKFileURLRequester->url() );
		profile->setPskIsInFile( ProfilePskOptionsWidget->PskInFileCheckBox->isChecked() );
		profile->setX509Certificate( ProfileCertOptionsWidget->x509certURLRequester->url() );
		profile->setCaCertificate( ProfileCertOptionsWidget->CaCertpathURLRequester->url() );
		profile->setCertPath( ProfileCertOptionsWidget->certpathURLRequester->url() );
		profile->setPrivateKey ( ProfileCertOptionsWidget->privkeypathURLRequester->url() );
		profile->setPrivateKeyPass ( ProfileCertOptionsWidget->PrivkeyPasswordEdit->text() );
		profile->setSavePrivateKeyPassword( ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->isChecked() );
		
		if (ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->currentItem() == 1)
			profile->setTunnelDeviceType( "tap");
		else
			profile->setTunnelDeviceType("tun");

		profile->setUserdefinedPort( ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->value() );
		profile->setUseUserdefinedPort( ProfileOpenvpnOptionsWidget->UseUserdefinedPortCheckBox->isChecked() );
		profile->setDisableLzoCompression ( ProfileOpenvpnOptionsWidget->DisableLzoCompressionCheckBox->isChecked() );
		profile->setUserdefinedPort( ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->value() );
		profile->setAuthWithUsernameAndPassword( ProfileOpenvpnOptionsWidget->AuthWithUsernameAndPasswordCheckBox->isChecked () );
		profile->setUserName( ProfileUserOptionsWidget->UsernameLineEdit->text() );
		profile->setUserPassword( ProfileUserOptionsWidget->PasswordEdit->text() );


		profile->setUserdefiniedCipher( ProfileOpenvpnOptionsWidget->UserdefiniedCipherComboBox->currentText() );
		profile->setUseUserdefiniedCipher( ProfileOpenvpnOptionsWidget->UseUserdefiniedCipherCheckBox->isChecked() );

		profile->setUseTlsAuth( ProfileOpenvpnOptionsWidget->UseTlsAuthCheckBox->isChecked() );
		profile->setTlsAuthFile( ProfileOpenvpnOptionsWidget->TlsAuthURLRequester->url() );

		profile->setUseTlsRemoteHost( ProfileOpenvpnOptionsWidget->UseTlsRemoteHostCheckBox->isChecked() );
		profile->setTlsRemoteHost( ProfileOpenvpnOptionsWidget->TlsRemoteHostLineEdit->text() );

		GlobalConfig->currentProfile->setMssfix( ProfileOpenvpnOptionsWidget->UserdefinedPacketSizeSpinBox->value() );
		GlobalConfig->currentProfile->setFragment( ProfileOpenvpnOptionsWidget->UserdefinedFragmentSizeSpinBox->value() );
		GlobalConfig->currentProfile->setUseMssfix( ProfileOpenvpnOptionsWidget->UseUserdefinedPacketSizeCheckBox->isChecked() );
		GlobalConfig->currentProfile->setUseFragment( ProfileOpenvpnOptionsWidget->UseUserdefinedFragmentationSizeCheckBox->isChecked() );

		if ( ProfilePskOptionsWidget->AuthTypeComboBox->currentItem() == 1 && ProfilePskOptionsWidget->PskInFileCheckBox->isChecked() && ProfilePskOptionsWidget->PSKFileURLRequester->url().isEmpty() )
		{
			KMessageBox::error ( this, i18n( "PSK file can't be empty!" ), i18n( "Empty PSK file" ) );
			// 			GlobalConfig->appendLogEntry(i18n( "PSK file can't be empty!" ) ,GlobalConfig->error);
			canAccept = false;
		}

		if ( ProfilePskOptionsWidget->AuthTypeComboBox->currentItem() == 1 && ( !ProfilePskOptionsWidget->PskInFileCheckBox->isChecked() && ProfilePskOptionsWidget->CheckSavePsk->isChecked() ) && ProfilePskOptionsWidget->PSKLineEdit->text().isEmpty() )
		{
			KMessageBox::error ( this, i18n( "PSK can't be empty!" ), i18n( "Empty PSK" ) );
			// 			GlobalConfig->appendLogEntry(i18n( "PSK can't be empty!" ) ,GlobalConfig->error);
			canAccept = false;
		}

		if ( ProfileOpenvpnOptionsWidget->UseTlsAuthCheckBox->isChecked() && ProfileOpenvpnOptionsWidget->TlsAuthURLRequester->url().isEmpty() )
		{
			KMessageBox::error ( this, i18n( "TLS authentication file can't be empty!" ), i18n( "Empty TLS authentication file" ) );
			// 			GlobalConfig->appendLogEntry(i18n( "TLS authentication file can't be empty!" ) ,GlobalConfig->error);
			canAccept = false;
		}

		if ( ProfileOpenvpnOptionsWidget->UseUserdefinedRemotePortCheckBox->isChecked() )
			profile->setUseRemotePort( true );
		else
			profile->setUseRemotePort( false );
		profile->setRemotePort( ProfileOpenvpnOptionsWidget->UserdefinedRemotePortSpinBox->value() );



		profile->setUseOnlyCaCertAndUserAuth( ProfileOpenvpnOptionsWidget->UseOnlyCaCertAndUserAuthCheckBox->isChecked() );

		profile->setAuthenticationAlgorithm(ProfileOpenvpnOptionsWidget->UserdefiniedDigestComboBox->currentText());
		profile->setUseAuthenticationAlgorithm(ProfileOpenvpnOptionsWidget->UseAuthenticationAlgorithmCheckBox->isChecked());


		if (ProfileOpenvpnOptionsWidget->AuthenticationDirectionComboBox->currentText()==i18n("none"))
			profile->setAuthenticationDirection("none");
		if (ProfileOpenvpnOptionsWidget->AuthenticationDirectionComboBox->currentText() == i18n("0"))
			profile->setAuthenticationDirection("0");
		if (ProfileOpenvpnOptionsWidget->AuthenticationDirectionComboBox->currentText()==i18n("1"))
			profile->setAuthenticationDirection("1");

		if (ProfileOpenvpnOptionsWidget->RenegSecCheckBox->isChecked())
			profile->setUseRenegSec(true);
		else
			profile->setUseRenegSec(false);
		GlobalConfig->currentProfile->setRenegSec(ProfileOpenvpnOptionsWidget->RenegSecSpinBox->value());
		

		if (ProfileOpenvpnOptionsWidget->TunnelPingCheckBox->isChecked())
			profile->setUseTunnelPing(true);
		profile->setTunnelPing(ProfileOpenvpnOptionsWidget->TunnelPingSpinBox->value());
		
		if (ProfileOpenvpnOptionsWidget->TunnelPingRestartCheckBox->isChecked())
			profile->setUseTunnelPingRestart(true);
		profile->setTunnelPing(ProfileOpenvpnOptionsWidget->TunnelPingSpinBox->value());

		profile->setDisableBind(ProfileOpenvpnOptionsWidget->DisableSocketBindCheckBox->isChecked());
		
		profile->setUseNsCertType( ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->isChecked() );
	
		if ( ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->currentText() == "client" )
			profile->setNsCertType( "client" );
		else
			profile->setNsCertType( "server" );
	} // openvpn
	if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::vtun )
	{


		if ( ProfileCertOptionsWidget->AuthTypeComboBox->currentItem() == 0 )
			profile->setAuthType( VpnAccountData::cert );
		if ( ProfileCertOptionsWidget->AuthTypeComboBox->currentItem() == 1 )
			profile->setAuthType( VpnAccountData::psk );

		if ( ProfilePskOptionsWidget->AuthTypeComboBox->currentItem() == 0 )
			profile->setAuthType( VpnAccountData::cert );
		if ( ProfilePskOptionsWidget->AuthTypeComboBox->currentItem() == 1 )
			profile->setAuthType( VpnAccountData::psk );

		profile->setUseLocalPort( ProfileVtunOptionsWidget->PortCheckbox->isChecked());
		profile->setLocalPort ( ProfileVtunOptionsWidget->PortSpinbox->value());

		if (ProfileVtunOptionsWidget->VtunProfileLineEdit->text().isEmpty())
		{
			KMessageBox::error ( this, i18n( "No profile name entered!" ), i18n( "No profile name" ) );
			canAccept = false;
		}
		else
			profile->setVtunProfile(ProfileVtunOptionsWidget->VtunProfileLineEdit->text());

		bool IPOk=true;
		if (ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked())
		{
			TQString LocalVirtualIp = ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text();
			if (Utils( GlobalConfig ).isValidIPv4Address (LocalVirtualIp) == false)
			{
				KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No Valid IP Address" ) );
				IPOk=false;
			}
			else
			{
				profile->setLocalVirtualIP( LocalVirtualIp);
			}

			TQString RemoteVirtualIp = ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->text();

			if (ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->currentText().lower() == "tun")
			{
				if (Utils( GlobalConfig ).isValidIPv4Address(RemoteVirtualIp) == false)
				{
					KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No valid IP address" ) );
					IPOk=false;
				}
				else
				{
					profile->setRemoteVirtualIP( RemoteVirtualIp);
				}
			}
			if (IPOk)
				profile->setUseVirtualIP(true);
			else
				profile->setUseVirtualIP(false);
		}
	} // vtun
	if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ssh )
	{

		if ( ProfileCertOptionsWidget->AuthTypeComboBox->currentItem() == 0 )
			profile->setAuthType( VpnAccountData::cert );
		if ( ProfileCertOptionsWidget->AuthTypeComboBox->currentItem() == 1 )
			profile->setAuthType( VpnAccountData::psk );

		if ( ProfilePskOptionsWidget->AuthTypeComboBox->currentItem() == 0 )
			profile->setAuthType( VpnAccountData::cert );
		if ( ProfilePskOptionsWidget->AuthTypeComboBox->currentItem() == 1 )
			profile->setAuthType( VpnAccountData::psk );

		profile->setUseLocalPort( ProfileSshOptionsWidget->UseUserdefinedRemotePortCheckBox->isChecked());
		profile->setLocalPort ( ProfileSshOptionsWidget->UserdefinedRemotePortSpinBox->value());

		bool IPOk=true;

		profile->setUseVirtualIP(ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked());

		if (ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked())
		{
			TQString LocalVirtualIp = ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text();
			if (Utils( GlobalConfig ).isValidIPv4Address (LocalVirtualIp) == false)
			{
				KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No Valid IP Address" ) );
				IPOk=false;
			}
			else
			{
				profile->setLocalVirtualIP( LocalVirtualIp);
			}


			TQString RemoteVirtualIp = ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->text();

			if (ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->currentText().lower() == "tun")
			{
				if (Utils( GlobalConfig ).isValidIPv4Address(RemoteVirtualIp) == false)
				{
					KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No valid IP address" ) );
					IPOk=false;
				}
				else
				{
					profile->setRemoteVirtualIP( RemoteVirtualIp);
				}
			}
			if (IPOk)
				profile->setUseVirtualIP(true);
			else
				profile->setUseVirtualIP(false);
		}
		else
		{
			KMessageBox::error ( this, i18n( "Virtual IP address must be enabled!" ), i18n( "Virtual IP address disabled" ) );
			IPOk=false;
		}
		profile->setUseRemotePort( ProfileSshOptionsWidget->UseUserdefinedRemotePortCheckBox->isChecked() );
		profile->setRemotePort ( ProfileSshOptionsWidget->UserdefinedRemotePortSpinBox->value() );

		// password or key auth
		if (ProfileSshOptionsWidget->AuthPassRadioButton->isChecked())
		{
			profile->setAuthWithUsernameAndPassword(true);
// 			KMessageBox::error ( this,"save: pass", "pass" );
		}
		else
		{
			profile->setAuthWithUsernameAndPassword(false);
// 			KMessageBox::error ( this,"save: key", "key" );
		}
		profile->setPreSharedKey(ProfileSshOptionsWidget->SshKeyComboBox->currentText());
		profile->setPreSharedKeyFile(ProfileSshOptionsWidget->CostumkeyURLRequester->url());

		if (ProfileSshOptionsWidget->CostumKeyRadioButton->isChecked())
		{
			profile->setPskIsInFile(true);
		}
		else
		{
			profile->setPskIsInFile(false);
		}

		if (ProfileSshOptionsWidget->UseSshConfigRemoteScriptCheckBox->isChecked() && !ProfileSshOptionsWidget->SshConfigRemoteScriptLineEdit->text().isEmpty())
		{
			profile->setUseSshConfigRemoteScript(true);
			profile->setSshConfigRemoteScript(ProfileSshOptionsWidget->SshConfigRemoteScriptLineEdit->text());
		}
		else
			profile->setUseSshConfigRemoteScript(false);

		if (ProfileSshOptionsWidget->UseSshConfigRemoteScriptCheckBox->isChecked() && ProfileSshOptionsWidget->SshConfigRemoteScriptLineEdit->text().isEmpty())
		{
			KMessageBox::error ( this, i18n( "%1 cant be empty!" ).arg(i18n("ssh config remote script")), i18n( "%1 empty" ).arg(i18n("ssh config remote script")) );
			IPOk=false;
		}

	} // ssh

	if ( ProfileNetworkGeneralOptionsWidget->PingCheckBox->isChecked() && !ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->text().isEmpty() )
	{
		profile->setPingHostIP( ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->text() );
		profile->setDoPingIP( ProfileNetworkGeneralOptionsWidget->PingCheckBox->isChecked() );
	}
	else
	{
		if ( ProfileNetworkGeneralOptionsWidget->PingCheckBox->isChecked() && ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->text() == TQString( "" ) )
		{
			KMessageBox::error ( this, i18n( "No hostname/IP address (ping host) entered!" ), i18n( "No hostname/IP address" ) );
			GlobalConfig->appendLogEntry( i18n( "No hostname/IP address (ping host) entered!" ) , GlobalConfig->error );
			canAccept = false;
		}
		else
			profile->setPingHostIP( "" );
	}

	if ( ProfileNetworkRouteOptionsWidget->DefaultRouteComboBox->currentItem() == 1 )
	{
		profile->setReplaceDefaultRoute( true );
	}
	else
	{
		profile->setReplaceDefaultRoute( false );
	}

	profile->setUseSmartcard( ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->isChecked() );

	profile->setAllowEmptyPrivateKeyPassword( ProfileCertOptionsWidget->AllowEmptyPrivateKeyPasswordCheckBox->isChecked());
	profile->setAllowIpAddressChangeOfPeer(ProfileOpenvpnOptionsWidget->AllowIpAddressChangeOfPeerCheckBox->isChecked());

	profile->setUseConnectionStatusCheck( ProfileNetworkGeneralOptionsWidget->UseConnectionStatusCheckCheckBox->isChecked() );
	profile->setConnectionStatusCheckSuccessCount( ProfileNetworkGeneralOptionsWidget->ConnectionStatusSuccessCountNumInput->value() );
	profile->setConnectionStatusInterval( ProfileNetworkGeneralOptionsWidget->ConnectionStatusCheckIntervalNumInput->value() );
	profile->setDoReconnectAfterConnectionLost( ProfileNetworkGeneralOptionsWidget->DoReconnectAfterConnectionLostCheckBox->isChecked() );
	profile->setUseReconnectDelay( ProfileNetworkGeneralOptionsWidget->UseReconnectDelayCheckBox->isChecked() );
	profile->setReconnectDelay( ProfileNetworkGeneralOptionsWidget->ReconnectDelayNumInput->value() );
	profile->setUseDnsUpdate( ProfileNetworkGeneralOptionsWidget->UseDnsUpdateCheckBox->isChecked() );

	profile->setLeftNextHop( ProfileIpsecOptionsWidget->LeftNextHopLineEdit->text() ); //TODO check valid IP
	profile->setRightNextHop( ProfileIpsecOptionsWidget->RightNextHopLineEdit->text( ) ); //TODO check valid IP
	profile->setUseRightNextHop(ProfileIpsecOptionsWidget->UseRightNextHopCheckBox->isChecked());
	profile->setUseLeftNextHop(ProfileIpsecOptionsWidget->UseLeftNextHopCheckBox->isChecked());
	
	profile->setSavePsk( ProfilePskOptionsWidget->CheckSavePsk->isChecked() );
	profile->setSaveUserPassword( ProfileUserOptionsWidget->CheckUserPass->isChecked () );
	profile->setUserName( ProfileUserOptionsWidget->UsernameLineEdit->text () );

	if ( ProfileUserOptionsWidget->CheckUserPass->isChecked() )
		profile->setUserPassword( ProfileUserOptionsWidget->PasswordEdit->text ( ) );
	else
		profile->setUserPassword( "" );

	if ( ProfilePskOptionsWidget->CheckSavePsk->isChecked() )
		profile->setPreSharedKey( ProfilePskOptionsWidget->PSKLineEdit->text( ) );
	else
		profile->setPreSharedKey( "" );

	profile->setUseMailAddressAsIdentifier( ProfileCertOptionsWidget->UseMailAddressAsIdentifierCheckBox->isChecked() );

	profile->setGateway( ProfileGeneralOptionsWidget->gatewayLineEdit->text() );
	// 	std::cout << "save: set gateway to: " << ProfileGeneralOptionsWidget->gatewayLineEdit->text() << ", now it is in profile: " << profile->getGateway() << std::endl;
	profile->setPreSharedKey( ProfilePskOptionsWidget->PSKLineEdit->text() );
	profile->setX509Certificate( ProfileCertOptionsWidget->x509certURLRequester->url() );
	profile->setCertPath( ProfileCertOptionsWidget->certpathURLRequester->url() );
	profile->setPrivateKeyPass( ProfileCertOptionsWidget->PrivkeyPasswordEdit->text() );
	profile->setSavePrivateKeyPassword( ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->isChecked() );
	profile->setNetworkDevice( ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->currentText() );

	profile->setDoPingIP( ProfileNetworkGeneralOptionsWidget->PingCheckBox->isChecked() );

	if ( ProfileNetworkNatOptionsWidget->UseNatCheckbox->isChecked() )
		profile->setUseNat( true );
	else
		profile->setUseNat( false );

	if ( ProfileNetworkNatOptionsWidget->UseUdpCheckbox->isChecked() )
		profile->setUseUdp( true );
	else
		profile->setUseUdp( false );

	if ( ProfileNetworkNatOptionsWidget->UdpPortCheckbox->isChecked() )
	{
		profile->setUdpPort( ProfileNetworkNatOptionsWidget->UdpPortSpinbox->value() );
		profile->setUseUdpPort( true );
	}
	else
	{
		profile->setUdpPort( 0 );
		profile->setUseUdpPort( false );
	}

	profile->setUseMtu( ProfileNetworkGeneralOptionsWidget->MtuCheckbox->isChecked() );
	profile->setMtu ( ProfileNetworkGeneralOptionsWidget->MtuSpinbox->value() );
	profile->setUseMru( ProfileNetworkGeneralOptionsWidget->MruCheckbox->isChecked() );
	profile->setMru ( ProfileNetworkGeneralOptionsWidget->MruSpinbox->value() );
	profile->setFixPathMtuDiscoveryProblem(ProfileNetworkGeneralOptionsWidget->FixPathMtuDiscoveryProblemCheckBox->isChecked());

	profile->setExecuteCmdBeforeConnect( ( ProfileCmdExecBeforeConnectOptionsWidget->ExcuteCmdBeforeConnectCheckBox->isChecked() ) );
	profile->setExecuteCmdAfterConnect( ( ProfileCmdExecAfterConnectOptionsWidget->ExcuteCmdAfterConnectCheckBox->isChecked() ) );
	profile->setExecuteCmdBeforeDisconnect( ( ProfileCmdExecBeforeDisconnectOptionsWidget->ExcuteCmdBeforeDisconnectCheckBox->isChecked() ) );
	profile->setExecuteCmdAfterDisconnect( ( ProfileCmdExecAfterDisconnectOptionsWidget->ExcuteCmdAfterDisconnectCheckBox->isChecked() ) );

	profile->setCommandBeforeConnect( ProfileCmdExecBeforeConnectOptionsWidget->CmdBeforeConnectTextEdit->text() );
	profile->setCommandAfterConnect( ProfileCmdExecAfterConnectOptionsWidget->CmdAfterConnectTextEdit->text() );
	profile->setCommandBeforeDisconnect( ProfileCmdExecBeforeDisconnectOptionsWidget->CmdBeforeDisconnectTextEdit->text() );
	profile->setCommandAfterDisconnect( ProfileCmdExecAfterDisconnectOptionsWidget->CmdAfterDisconnectTextEdit->text() );
	profile->setCommandAfterConnectDelayTime(ProfileCmdExecAfterConnectOptionsWidget->CommandAfterConnectDelayTimeNumInput->value());

	if ( ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->currentText() == "Basic" )
		profile->setHttpProxyAuthType( "basic" );
	if ( ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->currentText() == "NTLM" )
		profile->setHttpProxyAuthType( "ntlm" );
	

	profile->setUseHttpProxy( ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyCheckBox->isChecked() );
	profile->setHttpProxy( ProfileNetworkHttpProxyOptionsWidget->HttpProxyLineEdit->text( ) );
	profile->setHttpProxyPort( ProfileNetworkHttpProxyOptionsWidget->HttpProxyPortIntNumInput->value( ) );
	profile->setHttpProxyTimeout( ProfileNetworkHttpProxyOptionsWidget->HttpProxyTimeoutIntSpinBox->value() );
	profile->setHttpProxyPass( ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthPasswordEdit->text() );
	profile->setHttpProxyUser( ProfileNetworkHttpProxyOptionsWidget->HttpProxyUserLineEdit->text() );

	if (ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyCheckBox->isChecked())
	{
		if(ProfileNetworkHttpProxyOptionsWidget->HttpProxyLineEdit->text().isEmpty())
		{
			KMessageBox::error ( this, i18n( "HTTP proxy server can't be empty!" ), i18n( "Empty HTTP proxy server" ) );
			// 			GlobalConfig->appendLogEntry(i18n( "HTTP proxy server can't be empty!" ) ,GlobalConfig->error);
			canAccept = false;
			profile->setUseHttpProxy( false );
		}
		else
			profile->setUseHttpProxy( ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyCheckBox->isChecked() );

		if ( ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyAuthCheckBox->isChecked())
		{
			if ( ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthPasswordEdit->text().isEmpty() )
			{
				KMessageBox::error ( this, i18n( "Password for HTTP proxy authentication can't be empty!" ), i18n( "Empty HTTP proxy password for authentication" ) );
				// 			GlobalConfig->appendLogEntry(i18n( "Password for HTTP proxy authentication can't be empty!" ) ,GlobalConfig->error);
				canAccept = false;
				profile->setUseHttpProxyAuth( false );
			}

			if(ProfileNetworkHttpProxyOptionsWidget->HttpProxyUserLineEdit->text().isEmpty() )
			{
				KMessageBox::error ( this, i18n( "Username for HTTP proxy authentication can't be empty!" ), i18n( "Empty HTTP proxy username for authentication" ) );
				// 			GlobalConfig->appendLogEntry(i18n( "Username for HTTP proxy authentication can't be empty!" ) ,GlobalConfig->error);
				canAccept = false;
				profile->setUseHttpProxyAuth( false );
			}
			if (canAccept==true)
				profile->setUseHttpProxyAuth( ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyAuthCheckBox->isChecked() );
		}


	}

	TQStringList AdditionalNetworkRoutes;
	if ( ProfileNetworkRouteOptionsWidget->UseExtraNetworkRoutesCheckbox->isChecked()  )
		profile->setUseAdditionalNetworkRoutes( true );
	else
		profile->setUseAdditionalNetworkRoutes( false );

	if (ProfileNetworkRouteOptionsWidget->NetworkListView->childCount() > 0)
	{
		TQListViewItemIterator it( ProfileNetworkRouteOptionsWidget->NetworkListView );
		for ( ; it.current(); ++it )
		{
			// example entry:
			// <network>/<netmask>#<gateway>
			TQString network = TQString( it.current() ->text( 0 ) + "/" + it.current() ->text( 1 ) );
			network.append( "#" );
			network.append( it.current() ->text( 2 ) ); // gateway
			network.append( "#" );
			network.append( it.current() ->text( 3 ) ); // interface
			AdditionalNetworkRoutes.append( network );
		}
	}

	profile->setAdditionalNetworkRoutes( AdditionalNetworkRoutes );

	profile->setUseSpecialServerCertificate( ProfileCertOptionsWidget->UseSpecialServerCertificateCheckBox->isChecked() );

	if ( ProfileCertOptionsWidget->UseSpecialServerCertificateCheckBox->isChecked() )
	{
		if ( !ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->url().isEmpty() )
			profile->setSpecialServerCertificate( ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->url() );
		else
		{
			KMessageBox::error ( this, i18n( "Special server certificate can't be empty!" ), i18n( "No Server Certificate" ) );
			// 			GlobalConfig->appendLogEntry( i18n( "Special server certificate can't be empty!" ) ,GlobalConfig->error);
			canAccept = false;
		}
	}



	if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::cert && 
			ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->isEnabled() &&
			ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->isChecked() )
	{
		if ( !ProfileSmartcardOptionsWidget->Pkcs11SlotComboBox->currentText().isEmpty() )
			profile->setPkcs11Slot(ProfileSmartcardOptionsWidget->Pkcs11SlotComboBox->currentText());
		else
		{
			KMessageBox::error ( this, i18n( "Slot at smartcard can't be empty!" ), i18n( "No smartcard slot" ) );
			// 			GlobalConfig->appendLogEntry( i18n( "Slot at smartcard can't be empty!" ) ,GlobalConfig->error);
			canAccept = false;
		}
		if ( !ProfileSmartcardOptionsWidget->Pkcs11IdComboBox->currentText().isEmpty() )
			profile->setPkcs11Id(ProfileSmartcardOptionsWidget->Pkcs11IdComboBox->currentText());
		else
		{
			KMessageBox::error ( this, i18n( "ID for certificate at smartcard can't be empty!" ), i18n( "No certificate ID" ) );
			// 			GlobalConfig->appendLogEntry( i18n( "ID for certificate at smartcard can't be empty!" ) ,GlobalConfig->error);
			canAccept = false;
		}
		TQString Pkcs11SlotType = ProfileSmartcardOptionsWidget->Pkcs11SlotTypeComboBox->currentText();
		if (Pkcs11SlotType == i18n("ID"))
			profile->setPkcs11SlotType("id");
		else if (Pkcs11SlotType == i18n("Name"))
			profile->setPkcs11SlotType("name");
		else
			profile->setPkcs11SlotType("label");

		TQString Pkcs11IdType = ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->currentText();
		if (Pkcs11IdType == i18n("ID"))
			profile->setPkcs11IdType("id");
		else if (Pkcs11IdType == i18n("Label"))
			profile->setPkcs11IdType("label");
		else
			profile->setPkcs11IdType("subject");

		TQString Pkcs11SignMode = ProfileSmartcardOptionsWidget->Pkcs11SignModeComboBox->currentText();
		if (Pkcs11SignMode == i18n("auto"))
			profile->setPkcs11SignMode("auto");
		else if (Pkcs11SignMode == i18n("sign"))
			profile->setPkcs11SignMode("sign");
		else if (Pkcs11SignMode == i18n("recover"))
			profile->setPkcs11SignMode("recover");
		else
			profile->setPkcs11SignMode("any");
	}

	if (ProfileSmartcardOptionsWidget->UsePkcs11ProvidersCheckBox->isChecked())
	{
		if ( !ProfileSmartcardOptionsWidget->Pkcs11ProvidersURLRequester->url().isEmpty() )
			profile->setPkcs11Providers(ProfileSmartcardOptionsWidget->Pkcs11ProvidersURLRequester->url());
		else
		{
			KMessageBox::error ( this, i18n( "Library path to lib for use with smartcard can't be empty!" ), i18n( "No providers lib" ) );
			// 			GlobalConfig->appendLogEntry( i18n( "Library path to lib for use with smartcard can't be empty!" ) ,GlobalConfig->error);
			canAccept = false;
		}
	}

	profile->setUsePkcs11Providers (ProfileSmartcardOptionsWidget->UsePkcs11ProvidersCheckBox->isChecked());
	profile->setDontSaveUsername( ProfileUserOptionsWidget->DontSaveUsernameCheckBox->isChecked() );
	profile->setDisableCcp( ProfilePptpOptionsWidget->DisableCcpCheckbox->isChecked() );

	if (!GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ssh)
		profile->setPskIsInFile ( ProfilePskOptionsWidget->PskInFileCheckBox->isChecked() );


	if (ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->currentItem() == 1)
		GlobalConfig->currentProfile->setTunnelDeviceType("tap");
	else
		GlobalConfig->currentProfile->setTunnelDeviceType("tun");

	GlobalConfig->currentProfile->setAskUserPasswordOnEachConnect( ProfileUserOptionsWidget->AskUserPasswordOnEachConnectCheckBox->isChecked());
	
	GlobalConfig->saveOptions(true, GlobalConfig->currentProfile->getName());
	GlobalConfig->config->sync();
 	GlobalConfig->appPointer->restoreOverrideCursor();
	
	//GlobalConfig->appendLogEntry( i18n( "Profile \"%1\" saved." ).arg( newName ),GlobalConfig->debug);
	// 	enableButtonApply(false);

}

void PreferencesDialog::deleteSessionClicked()
{
	TQString Name = ProfileGeneralSelector->currentText();


	ToolInfo *IpsecToolInfo = Utils ( GlobalConfig ).getToolInfo ( "ipsec" ) ;
	TQString IpsecType;

	TQString TypeString = i18n ( "unknown" );
	if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::cisco )
		TypeString =  i18n("Cisco");
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ciscoorig )
		TypeString =  i18n("Cisco (propritary)");
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::pptp )
		TypeString =  i18n("PPTP");
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::freeswan )
	{
		if ( IpsecToolInfo->Version.contains ( "Openswan" ) )
			IpsecType = TypeString =  i18n("Openswan");
		else if ( IpsecToolInfo->Version.contains ( "strongSwan" ) )
			IpsecType = TypeString =  i18n("strongSwan");
		else
			IpsecType = TypeString =  i18n("FreeS/WAN");
	}
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon )
		TypeString = "racoon";
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn )
		TypeString = "OpenVPN";
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_racoon )
	{
		TypeString = "L2TP (racoon)";
	}
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan )
	{
		if ( IpsecToolInfo->Version.contains ( "Openswan" ) )
			IpsecType = TypeString = "L2TP (Openswan)";
		else if ( IpsecToolInfo->Version.contains ( "strongSwan" ) )
			IpsecType = TypeString = "L2TP (strongSwan)";
		else
			IpsecType = TypeString = "L2TP (FreeS/WAN)";
	}
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::vtun )
		TypeString = "Vtun";
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ssh )
		TypeString = "SSH";

	if ( !ProfileGeneralSelector->currentText().isEmpty() )
	{
		int result = KMessageBox::questionYesNo ( this, i18n ( "Really delete profile \"%1\" (type: %2, Server: %3)?" ).arg ( GlobalConfig->currentProfile->getName() ).arg(TypeString).arg(GlobalConfig->currentProfile->getGateway()), i18n ( "Delete?" ), KStdGuiItem::del(), KStdGuiItem::cancel() );
		//LogOutput->append( "Result: "+ TQString().setNum(result) ) ;
		if ( result == 3 )        // Yes
		{
			VpnAccountData * it;
			if ( !GlobalConfig->AccountList->isEmpty() )
			{
				for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
				{
					if ( ProfileGeneralSelector->currentText().isEmpty() )
					{
						// 					this->deleteSessionAction->setEnabled ( FALSE );
						//			this->advancedSessionAction->setEnabled ( FALSE );
						// 					this->saveSessionAction->setEnabled ( FALSE );
					}
					else
					{
						if ( it->getName() == Name )
						{
							profileAddedOrDeleted=true;
							GlobalConfig->removeEntry( GlobalConfig->currentProfile->getName() );
							ProfileGeneralSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileNetworkRouteSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileNetworkNatSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileNetworkHttpProxySelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileNetworkVirtualIpSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileCertSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileSmartcardSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfilePskSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileUserSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileOpenvpnSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfilePptpSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileVtunSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileSshSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileRacoonSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileIpsecSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileCiscoSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileCmdExecBeforeConnectSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileCmdExecBeforeDisconnectSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileCmdExecAfterConnectSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileCmdExecAfterDisconnectSelector->removeItem( ProfileGeneralSelector->currentItem() );
							break;
						}
					}
				}
			}

			if ( !GlobalConfig->AccountList->isEmpty() )
			{
				GlobalConfig->currentProfile = GlobalConfig->AccountList->first();
				GlobalConfig->lastProfile = GlobalConfig->AccountList->first()->getName();
				ProfileGeneralSelector->setCurrentText( GlobalConfig->AccountList->first() ->getName() );
				//ConnectOptionsWidget->ProfileGeneralOptionsWidget->ProfileComboBox->setSelected(0, true);
				profileChanged ( GlobalConfig->AccountList->first() ->getName() );
				connectionTypeChanged( GlobalConfig->AccountList->first() ->getConnectionType() );
				authTypeChanged( GlobalConfig->AccountList->first() ->getAuthType() );
				// 				buttonCancel->setEnabled( true );
				// 				buttonOk->setEnabled( true );
			}
			else
			{
				ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled ( FALSE );
				ProfileGeneralOptionsWidget->RenameSessionPushButton->setEnabled ( FALSE );
				ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled ( FALSE );
				GlobalConfig->lastProfile = "";
				GlobalConfig->currentProfile = 0L;
				// 				CiscoPptpGroupBox->setEnabled( false );
				//				FreeswanRacoonGroupBox->setEnabled( false );
				// 				OpenvpnGroupBox->setEnabled( false );
				// 				GeneralGroupbox->setEnabled( false );
				//				CommandExecutionGroupBox->setEnabled( false );
			}

			//		slotStatusMsg ( i18n( "Profile \"%1\" deleted." ).arg( Name ), ID_FLASH_MSG );

			profileAddedOrDeleted = true;
			saveSessionClicked();
			GlobalConfig->removeEntry( Name );
			GlobalConfig->appendLogEntry ( i18n( "Profile \"%1\" deleted." ).arg( Name ), GlobalConfig->debug );

			
			//saveOptions(); // TODO save, currently after closing dialog
			//			sessionToggled();
			//if ( ConnectOptionsWidget->ProfileGeneralOptionsWidget->ProfileComboBox->currentText().isEmpty() )
			//	ConnectOptionsWidget->ProfileGeneralOptionsWidget->ProfileComboBox->setEnabled ( FALSE );
		}
	}

}

void PreferencesDialog::newSessionClicked()
{

	// call new profile dialog...
	NewProfileDialog newdlg( GlobalConfig->appPointer, this, i18n( "New profile" ), GlobalConfig );
	newdlg.exec();
	if ( newdlg.newProfileCreated )
	{

		VpnAccountData * it;
		bool nameOk = false;
		bool ok;
		TQString newName=newdlg.getName();
		TQString Oldname =  newdlg.getName();
		while ( nameOk == false )
		{
			for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
			{
				if ( ( it != GlobalConfig->currentProfile ) && ( it->getName() == newName ) )
				{
					//account->setName( TQString( account->getName() + "_2" ) );
					// 				KMessageBox::information ( this, i18n( "Profile name exists!\n It will be renamed to \"%1\"." ).arg( account->getName() ), i18n( "Name exist, renamed" ) );
					KMessageBox::error ( this, i18n ( "Profile name exists!" ), i18n ( "Name Exists" ) );
	
					newName = KInputDialog::getText ( i18n ( "New Name" ), i18n ( "New name for profile:" ), TQString ( Oldname + "_2" ), &ok );
					if ( ok == false )
					{
						KMessageBox::information ( 0, i18n ( "Rename at new created profile was canceled." ) );
						GlobalConfig->appendLogEntry ( i18n ( "Rename at new created profile was canceled." ), GlobalConfig->info );
						return ;
					}
				}
				if ( newName.isEmpty() )
					nameOk=false;
				else
					nameOk = true;
			}
			if ( newName.isEmpty() )
				nameOk=false;
			else
				nameOk = true;
		}
		
		if (nameOk)
		{
			GlobalConfig->AccountList->append(newdlg.profileData);
			for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
			{
				if ( it->getName() == newName )
				{
					if (GlobalConfig->KvpncDebugLevel > 3)
						GlobalConfig->appendLogEntry ( i18n( "New created profile \"%1\" found in profile list." ).arg( newName ), GlobalConfig->debug );
					profileAddedOrDeleted=true;
					ProfileGeneralSelector->insertItem( newName );
					ProfileNetworkRouteSelector->insertItem( newName );
					ProfileNetworkNatSelector->insertItem( newName );
					ProfileNetworkHttpProxySelector->insertItem( newName );
					ProfileNetworkVirtualIpSelector->insertItem( newName );
					ProfileCertSelector->insertItem( newName );
					ProfileSmartcardSelector->insertItem( newName );
					ProfilePskSelector->insertItem( newName );
					ProfileUserSelector->insertItem( newName );
					ProfileOpenvpnSelector->insertItem( newName );
					ProfilePptpSelector->insertItem( newName );
					ProfileVtunSelector->insertItem( newName );
					ProfileSshSelector->insertItem( newName );
					ProfileRacoonSelector->insertItem( newName );
					ProfileIpsecSelector->insertItem( newName );
					ProfileCiscoSelector->insertItem( newName );
					ProfileCmdExecBeforeConnectSelector->insertItem( newName );
					ProfileCmdExecBeforeDisconnectSelector->insertItem( newName );
					ProfileCmdExecAfterConnectSelector->insertItem( newName );
					ProfileCmdExecAfterDisconnectSelector->insertItem( newName );
	
					slotProfileCreated(newName);
	
					GlobalConfig->currentProfile = it;
					break;
				}
			}
	
			ProfileGeneralOptionsWidget->RenameSessionPushButton->setEnabled( TRUE );
			ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled( TRUE );
			ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled ( TRUE );
	
			// 		CiscoPptpGroupBox->setEnabled( true );
			// 		//		FreeswanRacoonGroupBox->setEnabled( true );
			// 		OpenvpnGroupBox->setEnabled( true );
			// 		GeneralGroupbox->setEnabled( true );
			// 		CommandExecutionGroupBox->setEnabled( true );
	
			KMessageBox::information ( this, i18n( "Profile \"%1\" added.\nNow set the right type,\n fill in the fields\nand press \"Save\" to complete the profile." ).arg( newName ), i18n( "Complete Profile" ) );
			//slotStatusMsg ( i18n( "Profile \"%1\" added." ).arg( Name ), ID_FLASH_MSG );
	
			GlobalConfig->appendLogEntry ( i18n( "Profile \"%1\" added." ).arg( newName ), GlobalConfig->debug );
			profileAddedOrDeleted = true;
			configChanged=true;
			NewProfileName = newName;
			profileChanged ( newName );
			connectionTypeChanged( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() );
			authTypeChanged( ProfileCertOptionsWidget->AuthTypeComboBox->currentItem() );
			authTypeChanged( ProfilePskOptionsWidget->AuthTypeComboBox->currentItem() );
			saveSessionClicked();
		}
		else
		{
			GlobalConfig->appendLogEntry ( i18n ( "Rename at new created profile was canceled." ), GlobalConfig->info );
			slotStatusMsg ( i18n ( "Creating new profile canceled." ), ID_FLASH_MSG );
			GlobalConfig->appendLogEntry ( i18n ( "Creating new profile canceled." ), GlobalConfig->info );
		}
	}
	else
	{

		GlobalConfig->appendLogEntry ( i18n( "Creation of the new profile canceled." ), GlobalConfig->debug );
	}
}

void PreferencesDialog::renameSessionClicked()
{
	bool ok = true;
	bool nameOk = false;
	TQString oldName = GlobalConfig->currentProfile->getName();
	TQString *newName;

	while ( nameOk == false )
	{
		newName = new TQString( KInputDialog::getText ( i18n( "New Name" ), i18n( "Enter new name for profile:" ), oldName, &ok, this ) );
		if ( newName->contains( ' ' ) )
		{
			KMessageBox::error ( this, i18n( "Blanks are not allowed in profile names!" ), i18n( "Illegal Character in Name" ) );
			GlobalConfig->appendLogEntry( i18n( "Blanks are not allowed in profile names!" ) , GlobalConfig->error );
			ok = false;
		}
		if ( *newName == oldName  )
		{
// 			KMessageBox::error ( this, i18n( "Profile name can be same!" ), i18n( "Same name" ) );
// 			GlobalConfig->appendLogEntry( i18n( "Profile name can be same!" ) , GlobalConfig->error );
			ok = false;
			nameOk=true;
		}
		else
			nameOk=true;
	}
	if ( ok )
	{
		profileAddedOrDeleted=true;
		GlobalConfig->currentProfile->setName( *newName );
		ProfileGeneralSelector->clear();
		ProfileNetworkRouteSelector->clear();
		ProfileNetworkNatSelector->clear();
		ProfileNetworkHttpProxySelector->clear();
		ProfileNetworkVirtualIpSelector->clear();
		ProfileCertSelector->clear();
		ProfileSmartcardSelector->clear();
		ProfilePskSelector->clear();
		ProfileUserSelector->clear();
		ProfileOpenvpnSelector->clear();
		ProfilePptpSelector->clear();
		ProfileVtunSelector->clear();
		ProfileSshSelector->clear();
		ProfileRacoonSelector->clear();
		ProfileIpsecSelector->clear();
		ProfileCiscoSelector->clear();
		ProfileCmdExecBeforeConnectSelector->clear();
		ProfileCmdExecBeforeDisconnectSelector->clear();
		ProfileCmdExecAfterConnectSelector->clear();
		ProfileCmdExecAfterDisconnectSelector->clear();

		if ( !GlobalConfig->AccountList->isEmpty() )
		{
			VpnAccountData * it;
			for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
			{
				if ( it != 0 )
				{
					ProfileGeneralSelector->insertItem( it->getName() );
					ProfileNetworkRouteSelector->insertItem( it->getName() );
					ProfileNetworkNatSelector->insertItem( it->getName() );
					ProfileNetworkHttpProxySelector->insertItem( it->getName() );
					ProfileNetworkVirtualIpSelector->insertItem( it->getName() );
					ProfileCertSelector->insertItem( it->getName() );
					ProfileSmartcardSelector->insertItem( it->getName() );
					ProfilePskSelector->insertItem( it->getName() );
					ProfileUserSelector->insertItem( it->getName() );
					ProfileOpenvpnSelector->insertItem( it->getName() );
					ProfilePptpSelector->insertItem( it->getName() );
					ProfileVtunSelector->insertItem( it->getName() );
					ProfileSshSelector->insertItem( it->getName() );
					ProfileRacoonSelector->insertItem( it->getName() );
					ProfileIpsecSelector->insertItem( it->getName() );
					ProfileCiscoSelector->insertItem( it->getName() );
					ProfileCmdExecBeforeConnectSelector->insertItem( it->getName() );
					ProfileCmdExecBeforeDisconnectSelector->insertItem( it->getName() );
					ProfileCmdExecAfterConnectSelector->insertItem( it->getName() );
					ProfileCmdExecAfterDisconnectSelector->insertItem( it->getName() );
					slotProfileCreated(it->getName());
  					break;
				}
			}
		}

		if ( !showOnlyProfiles )
		{
			ConnectOptionsWidget->AutoConnectProfileComboBox->clear();
			for ( uint i = 1; i < GlobalConfig->AccountList->count();i++ )
			{
				ConnectOptionsWidget->AutoConnectProfileComboBox->insertItem( GlobalConfig->AccountList->at( i ) ->getName() );
			}
		}
		profileAddedOrDeleted = true;
		configChanged=true;

		GlobalConfig->lastProfile = TQString(*newName);

		saveSessionClicked();
		GlobalConfig->removeEntry( oldName );

		KMessageBox::information ( 0, i18n ( "Rename of \"%1\" to \"%2\" was successful." ).arg ( oldName ).arg(GlobalConfig->currentProfile->getName()) );
		GlobalConfig->appendLogEntry ( i18n ( "Rename of \"%1\" to \"%2\" was successful." ).arg ( oldName ).arg(GlobalConfig->currentProfile->getName()), GlobalConfig->info );


	}

}

void PreferencesDialog::importCertificate()
{
	ImportCertificateDialog dlg( this, i18n( "Import certificate..." ).ascii(), GlobalConfig );
	//int result =
	dlg.exec();
}

void PreferencesDialog::pageChanged( TQWidget* page )
{
// 	std::cout << "page changed, new profile: "<< lastProfileName << std::endl;

	prev_page = current_page;
	current_page = page;
// 	std::cout << "page changed, page: "<< page << std::endl;
// 	std::cout << "page changed, old page: "<< prev_page << std::endl;

	bool page_data_changed=false;

	if ( !showOnlyProfiles )
	{
		if (prev_page == ConfigConnectOptionsFrame && ConnectOptionsWidget->dialogModified )
		{
			page_data_changed=true;
			ConnectOptionsWidget->dialogModified = false;
		}
		else if (prev_page == DaemonOptionsFrame && ConfigDaemonOptionsWidget->dialogModified )
		{
			page_data_changed=true;
			ConfigDaemonOptionsWidget->dialogModified = false;
		}
		else if (prev_page == DebugFrame && DebugOptionsWidget->dialogModified )
		{
			page_data_changed=true;
			DebugOptionsWidget->dialogModified = false;
		}
		else if (prev_page == LogFrame && LogOptionsWidget->dialogModified )
		{
			page_data_changed=true;
			LogOptionsWidget->dialogModified = false;
		}
		else if (prev_page == HelperProgramFrame && HelperProgramOptionsWidget->dialogModified )
		{
			page_data_changed=true;
			HelperProgramOptionsWidget->dialogModified = false;
		}

	}

	if (prev_page == ProfileNetworkRouteOptionsFrame && ProfileNetworkRouteOptionsWidget->dialogModified )
	{
		page_data_changed=true;
		ProfileNetworkRouteOptionsWidget->dialogModified = false;
	}
	else if (prev_page == ProfileGeneralOptionsFrame && ProfileGeneralOptionsWidget->dialogModified )
	{
		page_data_changed=true;
		ProfileGeneralOptionsWidget->dialogModified = false;
	}
	else if (prev_page == ProfileUserOptionsFrame && ProfileUserOptionsWidget->dialogModified )
	{
		page_data_changed=true;
		ProfileUserOptionsWidget->dialogModified = false;
	}
	else if (prev_page == ProfileCertOptionsFrame && ProfileCertOptionsWidget->dialogModified )
	{
		page_data_changed=true;
		ProfileCertOptionsWidget->dialogModified = false;
	}
	else if (prev_page == ProfileCiscoOptionsFrame && ProfileCiscoOptionsWidget->dialogModified )
	{
		page_data_changed=true;
		ProfileCiscoOptionsWidget->dialogModified = false;
	}
	else if (prev_page == ProfileNetworkHttpProxyOptionsFrame && ProfileNetworkHttpProxyOptionsWidget->dialogModified )
	{
		page_data_changed=true;
		ProfileNetworkHttpProxyOptionsWidget->dialogModified = false;
	}
	else if (prev_page == ProfileCmdExecAfterConnectOptionsFrame && ProfileCmdExecAfterConnectOptionsWidget->dialogModified )
	{
		page_data_changed=true;
		ProfileCmdExecAfterConnectOptionsWidget->dialogModified = false;
	}
	else if (prev_page == ProfileCmdExecAfterDisconnectOptionsFrame && ProfileCmdExecAfterDisconnectOptionsWidget->dialogModified )
	{
		page_data_changed=true;
		ProfileCmdExecAfterDisconnectOptionsWidget->dialogModified = false;
	}
	else if (prev_page == ProfileCmdExecBeforeConnectOptionsFrame && ProfileCmdExecBeforeConnectOptionsWidget->dialogModified )
	{
		page_data_changed=true;
		ProfileCmdExecBeforeConnectOptionsWidget->dialogModified = false;
	}
	else if (prev_page == ProfileCmdExecBeforeDisconnectOptionsFrame && ProfileCmdExecBeforeDisconnectOptionsWidget->dialogModified )
	{
		page_data_changed=true;
		ProfileCmdExecBeforeDisconnectOptionsWidget->dialogModified = false;
	}
	else if (prev_page == ProfileNetworkNatOptionsFrame && ProfileNetworkNatOptionsWidget->dialogModified )
	{
		page_data_changed=true;
		ProfileNetworkNatOptionsWidget->dialogModified = false;
	}
	else if (prev_page == ProfileNetworkVirtualIpOptionsFrame && ProfileNetworkVirtualIpOptionsWidget->dialogModified )
	{
		page_data_changed=true;
		ProfileNetworkVirtualIpOptionsWidget->dialogModified = false;
	}
	else if (prev_page == ProfileOpenvpnOptionsFrame && ProfileOpenvpnOptionsWidget->dialogModified )
	{
		page_data_changed=true;
		ProfileOpenvpnOptionsWidget->dialogModified = false;
	}
	else if (prev_page == ProfilePptpOptionsFrame && ProfilePptpOptionsWidget->dialogModified )
	{
		page_data_changed=true;
		ProfilePptpOptionsWidget->dialogModified = false;
	}
	else if (prev_page == ProfilePskOptionsFrame && ProfilePskOptionsWidget->dialogModified )
	{
		page_data_changed=true;
		ProfilePskOptionsWidget->dialogModified = false;
	}
	else if (prev_page == ProfileRacoonOptionsFrame && ProfileRacoonOptionsWidget->dialogModified )
	{
		page_data_changed=true;
		ProfileRacoonOptionsWidget->dialogModified = false;
	}
	else if (prev_page == ProfileIpsecOptionsFrame && ProfileIpsecOptionsWidget->dialogModified )
	{
		page_data_changed=true;
		ProfileIpsecOptionsWidget->dialogModified = false;
	}
	else if (prev_page == ProfileSshOptionsFrame && ProfileSshOptionsWidget->dialogModified )
	{
		page_data_changed=true;
		ProfileSshOptionsWidget->dialogModified = false;
	}
	else if (prev_page == ProfileSmartcardOptionsFrame && ProfileSmartcardOptionsWidget->dialogModified )
	{
		page_data_changed=true;
		ProfileSmartcardOptionsWidget->dialogModified = false;
	}
	else if (prev_page == ProfileVtunOptionsFrame && ProfileVtunOptionsWidget->dialogModified )
	{
		page_data_changed=true;
		ProfileVtunOptionsWidget->dialogModified = false;
	}
	else if (prev_page == ProfileNetworkGeneralOptionsFrame && ProfileNetworkGeneralOptionsWidget->dialogModified )
	{
		page_data_changed=true;
		ProfileNetworkGeneralOptionsWidget->dialogModified = false;
	}

	if (page_data_changed)
	{
		std::cout << "page data changed => save need" << std::endl;
		saveSessionClicked();
	}

	profileChanged( lastProfileName );
	
}

void PreferencesDialog::userAuthToggled( bool )
{
	if ( ProfileOpenvpnOptionsWidget->AuthWithUsernameAndPasswordCheckBox->isChecked() )
		ProfileUserOptionsWidget->setEnabled( true );
	else
		ProfileUserOptionsWidget->setEnabled( false );

}

void PreferencesDialog::useUdpToggled( bool )
{
	if ( ProfileNetworkNatOptionsWidget->UseUdpCheckbox->isChecked() )
	{
		ProfileOpenvpnOptionsWidget->UseUserdefinedPacketSizeCheckBox->setEnabled( true );
		ProfileOpenvpnOptionsWidget->userdefiniedPacketSizeToggled( ProfileOpenvpnOptionsWidget->UseUserdefinedPacketSizeCheckBox->isChecked() );
		ProfileOpenvpnOptionsWidget->userdefiniedFragmentationSizeToggled( ProfileOpenvpnOptionsWidget->UseUserdefinedFragmentationSizeCheckBox->isChecked() );
	}
	else
	{
		ProfileOpenvpnOptionsWidget->UseUserdefinedPacketSizeCheckBox->setEnabled( false );
		ProfileOpenvpnOptionsWidget->userdefiniedPacketSizeToggled( ProfileOpenvpnOptionsWidget->UseUserdefinedPacketSizeCheckBox->isChecked() );
		ProfileOpenvpnOptionsWidget->userdefiniedFragmentationSizeToggled( ProfileOpenvpnOptionsWidget->UseUserdefinedFragmentationSizeCheckBox->isChecked() );
	}
}

void PreferencesDialog::OpenvpnPathChanged( const TQString& )
{
	ToolInfo * OpenvpnInfo = Utils( GlobalConfig ).getToolInfo ( "openvpn" );
// 	OpenvpnInfo->PathToExec = ConfigDaemonOptionsWidget->OpenvpnPathInput->url();
// 	GlobalConfig->pathToOpenvpn = ConfigDaemonOptionsWidget->OpenvpnPathInput->url();
// 	OpenvpnInfo->addSearchPath(ConfigDaemonOptionsWidget->OpenvpnPathInput->url());
	OpenvpnInfo->TryPath_first = ConfigDaemonOptionsWidget->OpenvpnPathInput->url();
	OpenvpnInfo->collectToolInfo();

	ConfigDaemonOptionsWidget->OpenvpnVersionLineEdit->setText( OpenvpnInfo->Version );

	if ( OpenvpnInfo->found )
		ConfigDaemonOptionsWidget->OpenvpnStatePixmapLabel->setPixmap( ok_icon );
	else
		ConfigDaemonOptionsWidget->OpenvpnStatePixmapLabel->setPixmap( wrong_icon );
}

void PreferencesDialog::FreeswanPathChanged( const TQString& )
{
	// 	KMessageBox::information(0,"path changed","ipsec");

	ToolInfo * IpsecInfo = Utils( GlobalConfig ).getToolInfo ( "ipsec" );
// 	IpsecInfo->removeSearchPath( IpsecInfo->PathToExec );
// 	IpsecInfo->PathToExec = ConfigDaemonOptionsWidget->FreeswanPathInput->url();
// 	GlobalConfig->pathToIpsec = ConfigDaemonOptionsWidget->FreeswanPathInput->url();
// 	IpsecInfo->addSearchPath(ConfigDaemonOptionsWidget->FreeswanPathInput->url());
	IpsecInfo->TryPath_first = ConfigDaemonOptionsWidget->FreeswanPathInput->url();
	IpsecInfo->collectToolInfo();

	ConfigDaemonOptionsWidget->IpsecVersionLineEdit->setText( IpsecInfo->Version );

	if ( IpsecInfo->found )
		ConfigDaemonOptionsWidget->IpsecStatePixmapLabel->setPixmap( ok_icon );
	else
		ConfigDaemonOptionsWidget->IpsecStatePixmapLabel->setPixmap( wrong_icon );
}

void PreferencesDialog::PppdPathChanged( const TQString& )
{
	// 	KMessageBox::information(0,"path changed","Pppd");

	ToolInfo * PppdInfo = Utils( GlobalConfig ).getToolInfo ( "pppd" );
// 	PppdInfo->removeSearchPath( PppdInfo->PathToExec );
// 	PppdInfo->PathToExec = ConfigDaemonOptionsWidget->PppdPathInput->url();
// 	GlobalConfig->pathToPppd = ConfigDaemonOptionsWidget->PppdPathInput->url();
// 	PppdInfo->addSearchPath(ConfigDaemonOptionsWidget->PppdPathInput->url());
	PppdInfo->TryPath_first = ConfigDaemonOptionsWidget->PppdPathInput->url();
	PppdInfo->collectToolInfo();

	ConfigDaemonOptionsWidget->PppdVersionLineEdit->setText( PppdInfo->Version );

	if ( PppdInfo->found )
		ConfigDaemonOptionsWidget->PppdStatePixmapLabel->setPixmap( ok_icon );
	else
		ConfigDaemonOptionsWidget->PppdStatePixmapLabel->setPixmap( wrong_icon );
}

void PreferencesDialog::PptpPathChanged( const TQString& )
{
	// 	KMessageBox::information(0,"path changed","Pptp");

	ToolInfo *PptpInfo = Utils( GlobalConfig ).getToolInfo ( "pptp" );
// 	PptpInfo->PathToExec = ConfigDaemonOptionsWidget->PptpPathInput->url();
// 	GlobalConfig->pathToPptp = ConfigDaemonOptionsWidget->PptpPathInput->url();
// 	PptpInfo->removeSearchPath( PptpInfo->PathToExec );
// 	PptpInfo->addSearchPath(ConfigDaemonOptionsWidget->PptpPathInput->url());
	PptpInfo->TryPath_first = ConfigDaemonOptionsWidget->PptpPathInput->url();
	PptpInfo->collectToolInfo();

	ConfigDaemonOptionsWidget->PptpVersionLineEdit->setText( PptpInfo->Version );

	if ( PptpInfo->found )
		ConfigDaemonOptionsWidget->PptpStatePixmapLabel->setPixmap( ok_icon );
	else
		ConfigDaemonOptionsWidget->PptpStatePixmapLabel->setPixmap( wrong_icon );
}

void PreferencesDialog::RacoonPathChanged( const TQString& )
{
	// 	KMessageBox::information(0,"path changed","Racoon");

	ToolInfo * RacoonInfo = Utils( GlobalConfig ).getToolInfo ( "racoon" );
// 	RacoonInfo->removeSearchPath( RacoonInfo->PathToExec );
// 	RacoonInfo->PathToExec = ConfigDaemonOptionsWidget->RacoonPathInput->url();
// 	GlobalConfig->pathToRacoon = ConfigDaemonOptionsWidget->RacoonPathInput->url();
// 	RacoonInfo->addSearchPath(ConfigDaemonOptionsWidget->RacoonPathInput->url());
	RacoonInfo->TryPath_first = ConfigDaemonOptionsWidget->RacoonPathInput->url();
	RacoonInfo->collectToolInfo();

	ConfigDaemonOptionsWidget->RacoonVersionLineEdit->setText( RacoonInfo->Version );

	TQPixmap ok_icon = TDEGlobal::iconLoader() ->loadIcon( "button_ok", TDEIcon::NoGroup );
	TQPixmap wrong_icon = TDEGlobal::iconLoader() ->loadIcon( "button_cancel", TDEIcon::NoGroup );

	if ( RacoonInfo->found )
		ConfigDaemonOptionsWidget->RacoonStatePixmapLabel->setPixmap( ok_icon );
	else
		ConfigDaemonOptionsWidget->RacoonStatePixmapLabel->setPixmap( wrong_icon );
}

void PreferencesDialog::VpncPathChanged( const TQString& )
{
	// 		KMessageBox::information(0,"path changed","Vpnc");

	ToolInfo * VpncInfo = Utils( GlobalConfig ).getToolInfo ( "vpnc" );

// 	VpncInfo->removeSearchPath( VpncInfo->PathToExec );

// 	VpncInfo->PathToExec = ConfigDaemonOptionsWidget->VpncPathInput->url();
// 	GlobalConfig->pathToVpnc = ConfigDaemonOptionsWidget->VpncPathInput->url();
	// 	KMessageBox::information(0,VpncInfo->PathToExec,"vpnc path");
// 	VpncInfo->addSearchPath(ConfigDaemonOptionsWidget->VpncPathInput->url());
	VpncInfo->TryPath_first = ConfigDaemonOptionsWidget->VpncPathInput->url();
	VpncInfo->collectToolInfo();

	ConfigDaemonOptionsWidget->VpncVersionLineEdit->setText( VpncInfo->Version );
	// 	KMessageBox::information(0,VpncInfo->Version,"vpnc version");

	if ( VpncInfo->found )
		ConfigDaemonOptionsWidget->VpncStatePixmapLabel->setPixmap( ok_icon );
	else
		ConfigDaemonOptionsWidget->VpncStatePixmapLabel->setPixmap( wrong_icon );
}

void PreferencesDialog::CiscoVpncPathChanged( const TQString& )
{
	// 		KMessageBox::information(0,"path changed","Vpnc");

	ToolInfo * CiscoVpncInfo = Utils( GlobalConfig ).getToolInfo ( "vpnclient" );

// 	CiscoVpncInfo->removeSearchPath( CiscoVpncInfo->PathToExec );

// 	CiscoVpncInfo->PathToExec = ConfigDaemonOptionsWidget->CiscoVpncPathInput->url();
// 	GlobalConfig->pathToCiscoVpnc = ConfigDaemonOptionsWidget->CiscoVpncPathInput->url();
	// 	KMessageBox::information(0,VpncInfo->PathToExec,"vpnclient (proprietary) path");
// 	CiscoVpncInfo->addSearchPath(ConfigDaemonOptionsWidget->CiscoVpncPathInput->url());
	CiscoVpncInfo->TryPath_first = ConfigDaemonOptionsWidget->CiscoVpncPathInput->url();
	CiscoVpncInfo->collectToolInfo();

	ConfigDaemonOptionsWidget->CiscoVpncVersionLineEdit->setText( CiscoVpncInfo->Version );
	// 	KMessageBox::information(0,CiscoVpncInfo->Version,"vpnclient version");

	if ( CiscoVpncInfo->found )
		ConfigDaemonOptionsWidget->CiscoVpncStatePixmapLabel->setPixmap( ok_icon );
	else
		ConfigDaemonOptionsWidget->CiscoVpncStatePixmapLabel->setPixmap( wrong_icon );
}

void PreferencesDialog::L2tpdPathChanged( const TQString& )
{
	// 		KMessageBox::information(0,"path changed","L2tpd");

	ToolInfo * L2tpdInfo = Utils( GlobalConfig ).getToolInfo ( "l2tpd" );

// 	L2tpdInfo->removeSearchPath( L2tpdInfo->PathToExec );

// 	L2tpdInfo->PathToExec =ConfigDaemonOptionsWidget->L2tpdPathInput->url();
// 	GlobalConfig->pathToL2tpd =ConfigDaemonOptionsWidget->L2tpdPathInput->url();
	// 	KMessageBox::information(0,L2tpdInfo->PathToExec,"l2tpd path");
// 	L2tpdInfo->addSearchPath(ConfigDaemonOptionsWidget->L2tpdPathInput->url());
	L2tpdInfo->TryPath_first =ConfigDaemonOptionsWidget->L2tpdPathInput->url();

	L2tpdInfo->collectToolInfo();

	ConfigDaemonOptionsWidget->L2tpdVersionLineEdit->setText( L2tpdInfo->Version );
	// 	KMessageBox::information(0,L2tpdInfo->Version,"l2tpd version");

	if ( L2tpdInfo->found )
		ConfigDaemonOptionsWidget->L2tpdStatePixmapLabel->setPixmap( ok_icon );
	else
		ConfigDaemonOptionsWidget->L2tpdStatePixmapLabel->setPixmap( wrong_icon );
}

void PreferencesDialog::Xl2tpdPathChanged( const TQString& )
{
	// 		KMessageBox::information(0,"path changed","Xl2tpd");

	ToolInfo * Xl2tpdInfo = Utils( GlobalConfig ).getToolInfo ( "l2tpd" );

// 	Xl2tpdInfo->removeSearchPath( Xl2tpdInfo->PathToExec );

// 	Xl2tpdInfo->PathToExec = ConfigDaemonOptionsWidget->Xl2tpdPathInput->url();
// 	GlobalConfig->pathToXl2tpd = ConfigDaemonOptionsWidget->Xl2tpdPathInput->url();
	// 	KMessageBox::information(0,Xl2tpdInfo->PathToExec,"l2tpd path");
// 	Xl2tpdInfo->addSearchPath(ConfigDaemonOptionsWidget->Xl2tpdPathInput->url());
	Xl2tpdInfo->TryPath_first = ConfigDaemonOptionsWidget->Xl2tpdPathInput->url();

	Xl2tpdInfo->collectToolInfo();

	ConfigDaemonOptionsWidget->Xl2tpdVersionLineEdit->setText( Xl2tpdInfo->Version );
	// 	KMessageBox::information(0,Xl2tpdInfo->Version,"l2tpd version");

	if ( Xl2tpdInfo->found )
		ConfigDaemonOptionsWidget->Xl2tpdStatePixmapLabel->setPixmap( ok_icon );
	else
		ConfigDaemonOptionsWidget->Xl2tpdStatePixmapLabel->setPixmap( wrong_icon );
}

void PreferencesDialog::Openl2tpPathChanged( const TQString& )
{
	// 		KMessageBox::information(0,"path changed","Openl2tp");

	ToolInfo * Openl2tpInfo = Utils( GlobalConfig ).getToolInfo ( "openl2tpd" );

// 	Openl2tpInfo->removeSearchPath( Openl2tpInfo->PathToExec );

// 	Openl2tpInfo->PathToExec = ConfigDaemonOptionsWidget->Openl2tpPathInput->url();
// 	GlobalConfig->pathToOpenl2tp = ConfigDaemonOptionsWidget->Openl2tpPathInput->url();
	// 	KMessageBox::information(0,Openl2tpInfo->PathToExec,"l2tpd path");
// 	Openl2tpInfo->addSearchPath(ConfigDaemonOptionsWidget->Openl2tpPathInput->url());
	Openl2tpInfo->TryPath_first = ConfigDaemonOptionsWidget->Openl2tpPathInput->url();

	Openl2tpInfo->collectToolInfo();

	ConfigDaemonOptionsWidget->Openl2tpVersionLineEdit->setText( Openl2tpInfo->Version );
	// 	KMessageBox::information(0,Openl2tpInfo->Version,"openl2tp version");

	if ( Openl2tpInfo->found )
		ConfigDaemonOptionsWidget->Openl2tpStatePixmapLabel->setPixmap( ok_icon );
	else
		ConfigDaemonOptionsWidget->Openl2tpStatePixmapLabel->setPixmap( wrong_icon );
}

void PreferencesDialog::VtundPathChanged( const TQString& )
{
	// 		KMessageBox::information(0,"path changed","vtund");

	ToolInfo * VtunInfo = Utils( GlobalConfig ).getToolInfo ( "vtund" );

// 	VtunInfo->removeSearchPath( Xl2tpdInfo->PathToExec );

// 	VtunInfo->PathToExec = ConfigDaemonOptionsWidget->VtunddPathInput->url();
// 	GlobalConfig->pathToXl2tpd = ConfigDaemonOptionsWidget->VtunddPathInput->url();
	// 	KMessageBox::information(0,Xl2tpdInfo->PathToExec,"vtund path");
// 	VtunInfo->addSearchPath(ConfigDaemonOptionsWidget->VtunddPathInput->url());
	VtunInfo->TryPath_first = ConfigDaemonOptionsWidget->VtundPathInput->url();

	VtunInfo->collectToolInfo();

	ConfigDaemonOptionsWidget->VtunVersionLineEdit->setText( VtunInfo->Version );
	// 	KMessageBox::information(0,Xl2tpdInfo->Version,"vtun version");

	if ( VtunInfo->found )
		ConfigDaemonOptionsWidget->VtundStatePixmapLabel->setPixmap( ok_icon );
	else
		ConfigDaemonOptionsWidget->VtundStatePixmapLabel->setPixmap( wrong_icon );
}

void PreferencesDialog::SshPathChanged( const TQString& )
{
	// 		KMessageBox::information(0,"path changed","ssh");

	ToolInfo * SshInfo = Utils( GlobalConfig ).getToolInfo ( "ssh" );

// 	SshInfo->removeSearchPath( SshInfo->PathToExec );

// 	SshInfo->PathToExec = ConfigDaemonOptionsWidget->SshdPathInput->url();
// 	GlobalConfig->pathToSsh = ConfigDaemonOptionsWidget->SshdPathInput->url();
	// 	KMessageBox::information(0,SshInfo->PathToExec,"ssh path");
// 	SshInfo->addSearchPath(ConfigDaemonOptionsWidget->SshdPathInput->url());
	SshInfo->TryPath_first = ConfigDaemonOptionsWidget->SshPathInput->url();

	SshInfo->collectToolInfo();

	ConfigDaemonOptionsWidget->SshVersionLineEdit->setText( SshInfo->Version );
	// 	KMessageBox::information(0,SshInfo->Version,"ssh version");

	if ( SshInfo->found )
		ConfigDaemonOptionsWidget->SshStatePixmapLabel->setPixmap( ok_icon );
	else
		ConfigDaemonOptionsWidget->SshStatePixmapLabel->setPixmap( wrong_icon );
}

void PreferencesDialog::showEvent(TQShowEvent* e)
{
  KDialogBase::showEvent(e);

  TQSplitter* splitter = ((TQSplitter*)child(0, TQSPLITTER_OBJECT_NAME_STRING, true));
  TDEListView* listView = ((TDEListView*)child(0, "TDEListView", true));

  if (splitter && listView)
  {
    int visible = listView->visibleWidth();
    int content = listView->contentsWidth();

    if (visible < content)
    {
      int shiftSplitterBy = content - visible;
      resize(width()+shiftSplitterBy, height());
      TQValueList<int> oldSizes = splitter->sizes();
      TQValueList<int> newSizes;
      newSizes << oldSizes[0] + shiftSplitterBy << oldSizes[1] - shiftSplitterBy;
      splitter->setSizes(newSizes);
    }
  }
}

void PreferencesDialog::detectPkcs11Ids()
{
	GlobalConfig->appPointer->setOverrideCursor( TQCursor(TQt::WaitCursor) );
	ProfileSmartcardOptionsWidget->Pkcs11IdComboBox->clear();
	
	int Pkcs11IdType = ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->currentItem();
	TQString Pkcs11IdTypeTmp;
		if (Pkcs11IdType == 0)
		{
			Pkcs11IdTypeTmp="id";

			if (KvpncDebugLevel > 1)
				GlobalConfig->appendLogEntry(i18n("Pkcs11IdType: %1").arg(Pkcs11IdTypeTmp),KVpncConfig::debug);
		}
		else if (Pkcs11IdType == 1)
		{
			Pkcs11IdTypeTmp="label";
			if (KvpncDebugLevel > 1)
				GlobalConfig->appendLogEntry(i18n("Pkcs11IdType: %1").arg(Pkcs11IdTypeTmp),KVpncConfig::debug);
		}
		else
		{
			Pkcs11IdTypeTmp="subject";
			if (KvpncDebugLevel > 1)
				GlobalConfig->appendLogEntry(i18n("Pkcs11IdType: %1").arg(Pkcs11IdTypeTmp),KVpncConfig::debug);
		}

		TQString ProviderLib="";
		bool isOpenvpn = GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn;
		if (ProfileSmartcardOptionsWidget->UsePkcs11ProvidersCheckBox->isChecked() && !ProfileSmartcardOptionsWidget->Pkcs11ProvidersURLRequester->url().isEmpty())
			ProviderLib = ProfileSmartcardOptionsWidget->Pkcs11ProvidersURLRequester->url();

		// we have to split slot id and name ("0 : foobar") => 0
		TQString Pkcs11Slot = ProfileSmartcardOptionsWidget->Pkcs11SlotComboBox->currentText().section(':',0,0).stripWhiteSpace();

		
 		TQStringList Pkcs11Ids;
		if (isOpenvpn)
			Pkcs11Ids = Utils(GlobalConfig).getOpenvpnPkcs11Ids(ProviderLib);
		else
			Pkcs11Ids = Utils(GlobalConfig).getSmartcardCertsFromSlot(Pkcs11Slot,Pkcs11IdTypeTmp, ProviderLib );
			
		for ( TQStringList::Iterator it = Pkcs11Ids.begin(); it != Pkcs11Ids.end(); ++it )
			ProfileSmartcardOptionsWidget->Pkcs11IdComboBox->insertItem( TQString(*it));
		
		GlobalConfig->appPointer->restoreOverrideCursor();
}

void PreferencesDialog::detectPkcs11Slots()
{
	GlobalConfig->appPointer->setOverrideCursor( TQCursor(TQt::WaitCursor) );
	ProfileSmartcardOptionsWidget->Pkcs11SlotComboBox->clear();
	TQString ProviderLib="";
	bool isOpenvpn = GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn;
	if (ProfileSmartcardOptionsWidget->UsePkcs11ProvidersCheckBox->isChecked() && !ProfileSmartcardOptionsWidget->Pkcs11ProvidersURLRequester->url().isEmpty())
		ProviderLib = ProfileSmartcardOptionsWidget->Pkcs11ProvidersURLRequester->url();
	TQStringList Pkcs11Slots;

	if (isOpenvpn)
		Pkcs11Slots.append("0");
	else
	 	Pkcs11Slots = Utils(GlobalConfig).getSmartcardSlots(ProviderLib);
	
	for ( TQStringList::Iterator it = Pkcs11Slots.begin(); it != Pkcs11Slots.end(); ++it )
		ProfileSmartcardOptionsWidget->Pkcs11SlotComboBox->insertItem( TQString(*it));
	
	GlobalConfig->appPointer->restoreOverrideCursor();
}

void PreferencesDialog::localPortToggled(bool)
{
	if ( ProfileCiscoOptionsWidget->LocalPortCheckbox->isChecked() )
		ProfileCiscoOptionsWidget->LocalPortSpinbox->setEnabled( true );
	else
		ProfileCiscoOptionsWidget->LocalPortSpinbox->setEnabled( false );
}

void PreferencesDialog::useSpecialServerSmartcardificateToggled(bool)
{
// 	if (ProfileCertOptionsWidget->UseSpecialServerSmartcardificateCheckBox->isChecked())
// 	{
// 		ProfileSmartcardOptionsWidget->SpecialServerSmartcardificateURLRequester->setEnabled(TRUE);
// 	}
// 	else
// 	{
// 		ProfileSmartcardOptionsWidget->SpecialServerSmartcardificateURLRequester->setEnabled(FALSE);
// 	}
}

void PreferencesDialog::applicationVersionToggled(bool)
{
        if ( ProfileCiscoOptionsWidget->ApplicationVersionCheckbox->isChecked() )
                ProfileCiscoOptionsWidget->ApplicationVersionLineedit->setEnabled( true );
        else
                ProfileCiscoOptionsWidget->ApplicationVersionLineedit->setEnabled( false );
}

void PreferencesDialog::IkeGroupToggled(bool)
{
if ( GlobalConfig->currentProfile->getConnectionType() ==  VpnAccountData::cisco )
		{
        if ( ProfileCiscoOptionsWidget->IkeGroupCheckbox->isChecked() )
                ProfileCiscoOptionsWidget->IkeGroupCombobox->setEnabled( true );
        else
                ProfileCiscoOptionsWidget->IkeGroupCombobox->setEnabled( false );
	}
if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon || GlobalConfig->currentProfile->getConnectionType() ==  VpnAccountData::l2tpd_racoon)
		{
        if ( ProfileRacoonOptionsWidget->IkeGroupCheckbox->isChecked() )
                ProfileRacoonOptionsWidget->DHGroupComboBox->setEnabled( true );
        else
                ProfileRacoonOptionsWidget->DHGroupComboBox->setEnabled( false );

}
}

void PreferencesDialog::perfectForwardSecurityToggled(bool)
{
		if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::cisco )
		{
        if ( ProfileCiscoOptionsWidget->PerfectForwardSecurityCheckbox->isChecked() )
                ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled( true );
        else
                ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled( false );
		}
if ( GlobalConfig->currentProfile->getConnectionType() ==  VpnAccountData::racoon || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_racoon)
		{
        if ( ProfileRacoonOptionsWidget->PerfectForwardSecurityCheckbox->isChecked() )
                ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled( true );
        else
                ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled( false );

		}
}

void PreferencesDialog::singleDesToggled(bool)
{}

void PreferencesDialog::tunnelDeviceTypeChanged(const TQString & string )
{
	if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ssh)
	{
		if (string.lower() == "tun")
		{
			ProfileNetworkVirtualIpOptionsWidget->LabelRemoteVirtualIp->setText(i18n("Remote IP (virtual):"));
		}
		if (string.lower() == "tap")
		{
			ProfileNetworkVirtualIpOptionsWidget->LabelRemoteVirtualIp->setText(i18n("Netmask for local IP address:"));
		}
	}
}

void PreferencesDialog::natModeToggled( const TQString &)
{
	if (ProfileCiscoOptionsWidget->CiscoNatModeComboBox->currentText() == "none")
	{
		ProfileNetworkNatOptionsWidget->UseNatCheckbox->setChecked(false);
	}
	else
	{
		ProfileNetworkNatOptionsWidget->UseNatCheckbox->setChecked(true);
	}
}

void PreferencesDialog::useTDEwalletToggled(bool)
{
	if (!GeneralOptionsWidget->useTDEwalletCheckBox->isChecked())
	{

		int result = KMessageBox::questionYesNo ( this, i18n ( "Do you really want disable the use of TDEWallet? KVpnc will save passwords and psk in config file if requested." ), i18n ( "Disable TDEWallet?" ) );
		//LogOutput->append( "Result: "+ TQString().setNum(result) ) ;
		if ( result == 2 || result == 4 )  // No or Cancel
		{
			GeneralOptionsWidget->useTDEwalletCheckBox->setChecked(true);
			GlobalConfig->useTDEwallet=true;
		}
		if (result == 3) //Yes
			GlobalConfig->useTDEwallet=false;
		
	}
}

void PreferencesDialog::dpdToggled(bool)
{
	if (ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox->isChecked())
		ProfileCiscoOptionsWidget->DpdIdleTimeoutSpinbox->setEnabled(true);
	else
		ProfileCiscoOptionsWidget->DpdIdleTimeoutSpinbox->setEnabled(false);
}

void PreferencesDialog::useXauthToggled(bool)
{
	if (ProfileIpsecOptionsWidget->UseXauthCheckBox->isChecked())
	{
		ProfileUserOptionsWidget->setEnabled(true);
		ProfilePskOptionsWidget->setEnabled(true);
		ProfileIpsecOptionsWidget->LocalIdTypeCombobox->setEnabled(true);
		ProfileIpsecOptionsWidget->LocalIDLineEdit->setEnabled(true);
		ProfileIpsecOptionsWidget->LocalIdTypeCombobox->setCurrentText("keyid");
	}
	else
	{
		ProfileUserOptionsWidget->setEnabled(false);
		ProfilePskOptionsWidget->setEnabled(false);
		ProfileIpsecOptionsWidget->LocalIdTypeCombobox->setEnabled(true);
		ProfileIpsecOptionsWidget->LocalIDLineEdit->setEnabled(false);
		ProfileIpsecOptionsWidget->LocalIdTypeCombobox->setCurrentText("asn1dn");
	}
}

void PreferencesDialog::useCiscoCertStoreToggled(bool)
{
	if (ProfileCertOptionsWidget->UseCiscoCertStoreCheckBox->isChecked())	
	{
		ProfileCertOptionsWidget->x509certComboBox->show();
		ProfileCertOptionsWidget->x509certURLRequester->hide();
		ProfileCertOptionsWidget->CaCertpathComboBox->show();
		ProfileCertOptionsWidget->CaCertpathURLRequester->hide();
		ProfileCertOptionsWidget->certpathURLRequester->hide();
		ProfileCertOptionsWidget->sizeHint();
	}
	else
	{
		ProfileCertOptionsWidget->x509certComboBox->hide();
		ProfileCertOptionsWidget->x509certURLRequester->show();
		ProfileCertOptionsWidget->CaCertpathComboBox->hide();
		ProfileCertOptionsWidget->CaCertpathURLRequester->show();
		ProfileCertOptionsWidget->certpathURLRequester->show();
		ProfileCertOptionsWidget->sizeHint();
	}
}

bool PreferencesDialog::getVpncHasHybridSupport()
{
	bool hasHybridSupport = false;
	ToolInfo *tool;
	for ( tool = GlobalConfig->ToolList->first(); tool; tool = GlobalConfig->ToolList->next() )
	{
		if (tool->Name == "vpnc")
		{
			GlobalConfig->appendLogEntry ( i18n ( "vpnc capabilities: %1" ).arg( tool->Capabilities),GlobalConfig->debug );
			if( tool->Capabilities.find(i18n("openssl (certificate) support"),0,-1) > -1 )
			{
				hasHybridSupport = true;
				return hasHybridSupport;
			}
			
		}
	}
	return hasHybridSupport;
}

void PreferencesDialog::slotStatusMsg ( const TQString &text, int id )
{
	if (!GlobalConfig->statusbar != 0)
	{
		if ( id != ID_FLASH_MSG )
		{
			GlobalConfig->statusbar->clear();
			GlobalConfig->statusbar->changeItem ( text, id );
		}
		else
		{
			GlobalConfig->statusbar->message ( text, 2000 );
		}
	}
}

void PreferencesDialog::slotProfileCreated(TQString Name)
{
	ProfileGeneralSelector->insertItem( Name );
	ProfileNetworkRouteSelector->insertItem( Name );
	ProfileNetworkNatSelector->insertItem( Name );
	ProfileNetworkHttpProxySelector->insertItem( Name );
	ProfileNetworkVirtualIpSelector->insertItem( Name );
	ProfileCertSelector->insertItem( Name );
	ProfileSmartcardSelector->insertItem( Name );
	ProfilePskSelector->insertItem( Name );
	ProfileUserSelector->insertItem( Name );
	ProfileOpenvpnSelector->insertItem( Name );
	ProfilePptpSelector->insertItem( Name );
	ProfileVtunSelector->insertItem( Name );
	ProfileSshSelector->insertItem( Name );
	ProfileRacoonSelector->insertItem( Name );
	ProfileIpsecSelector->insertItem( Name );
	ProfileCiscoSelector->insertItem( Name );
	ProfileCmdExecBeforeConnectSelector->insertItem( Name );
	ProfileCmdExecBeforeDisconnectSelector->insertItem( Name );
	ProfileCmdExecAfterConnectSelector->insertItem( Name );
	ProfileCmdExecAfterDisconnectSelector->insertItem( Name );
	
	profileChanged( Name );
}
