/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "displaycertdialog.h"
#include "tdelocale.h"
#include <klineedit.h>
#include <tqstringlist.h>
#include <iostream>

DisplayCertDialog::DisplayCertDialog(TQWidget *parent, const char* caption, KVpncConfig *GlobalConfig)
 : KDialogBase ( parent, i18n ( "Certificate data" ).ascii(), true, caption,
		                KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true )
{
	main = new DisplayCertDialogBase ( this );
	setMainWidget ( main );
	main->setMinimumSize ( main->sizeHint() );
	this->GlobalConfig = GlobalConfig;
}


DisplayCertDialog::~DisplayCertDialog()
{
	delete main;
}

void DisplayCertDialog::parseCertData()
{
	std::cout << "certdatalist" << CertDataList.join (" ") << std::endl;
	for ( TQStringList::Iterator it = CertDataList.begin(); it != CertDataList.end(); ++it ) {
		if (GlobalConfig->KvpncDebugLevel > 2)
			GlobalConfig->appendLogEntry("[cert data]: "+*it,GlobalConfig->debug);
        	if ((*it).contains("Common Name:"))
			main->NameLineEdit->setText((*it).section(':',1,-1).stripWhiteSpace());
		else if((*it).contains("Department:"))
			main->DepartmentLineEdit->setText((*it).section(':',1,-1).stripWhiteSpace());
		else if((*it).contains("Company:"))
			main->CompanyLineEdit->setText((*it).section(':',1,-1).stripWhiteSpace());
		else if((*it).contains("State:"))
			main->StateLineEdit->setText((*it).section(':',1,-1).stripWhiteSpace());
		else if((*it).contains("Country:"))
			main->CountryLineEdit->setText((*it).section(':',1,-1).stripWhiteSpace());
		else if((*it).contains("Email:"))
			main->EmailLineEdit->setText((*it).section(':',1,-1).stripWhiteSpace());
// 		else if((*it).contains("Thumb Print:"))
// 			main->ThumbPrintLineEdit->setText((*it).section(':',1,-1).stripWhiteSpace());
		else if((*it).contains("Key Size:"))
			main->KeySizeLineEdit->setText((*it).section(':',1,-1).stripWhiteSpace());
		else if((*it).contains("Subject:"))
			main->SubjectLineEdit->setText((*it).section(':',1,-1).stripWhiteSpace());
		else if((*it).contains("Serial #:"))
			main->SerialLineEdit->setText((*it).section(':',1,-1).stripWhiteSpace());
		else if((*it).contains("Issuer:"))
			main->IssuerLineEdit->setText((*it).section(':',1,-1).stripWhiteSpace());
		else if((*it).contains("Not before:"))
			main->ValidFromLineEdit->setText((*it).section(':',1,-1).stripWhiteSpace());
		else if((*it).contains("Not after:"))
			main->ValidToLineEdit->setText((*it).section(':',1,-1).stripWhiteSpace());
    	}
}

