/***************************************************************************
 *   Copyright (C) 2005 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "debugoutputtextedit.h"

#include <tdelocale.h>
#include <ktextbrowser.h>
#include <iostream>
#include <tqwidget.h>

DebugOutputTextEdit::DebugOutputTextEdit( TQWidget* parent, const char* name)
    : KTextBrowser( parent, name)
{


}

DebugOutputTextEdit::~DebugOutputTextEdit()
{
	if (popup != 0)
		delete popup;
}

TQPopupMenu* DebugOutputTextEdit::createPopupMenu(const TQPoint &)
{
	popup = new TQPopupMenu(this);
	popup->insertItem(i18n("Cut Content"), this, TQT_SLOT(cut() ) );
 	popup->insertItem(i18n("Copy Content"), this, TQT_SLOT(copy() ) );
	popup->insertSeparator();
	popup->insertItem(i18n("Clear Log Window"), this, TQT_SLOT(clear() ) );
  popup->insertSeparator();

	return popup;
}

void DebugOutputTextEdit::append ( const TQString & text )
{
	KTextBrowser::append(text);
}
