/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "configconnectoptions.h"
#include <tqcheckbox.h>
#include <kcombobox.h>

#include <iostream>

ConfigConnectOptions::ConfigConnectOptions(TQWidget *parent) : ConfigConnectOptionsBase(parent)
{
	dialogModified=false;

	// connect changed signals to own signal
	connect(AutoConnectProfileComboBox,TQT_SIGNAL(textChanged ( const TQString & )),this,TQT_SIGNAL(changed()));
	connect(checkMinimizeAfterConnectCheck,TQT_SIGNAL(stateChanged ( int )),this,TQT_SIGNAL(changed()));
	connect(SilentQuitcheckBox,TQT_SIGNAL(stateChanged ( int )),this,TQT_SIGNAL(changed()));
	connect(DoAutoConnectCheckBox,TQT_SIGNAL(stateChanged ( int )),this,TQT_SIGNAL(changed()));

	// connect changed to slot
	connect(this,TQT_SIGNAL(changed ()),this,TQT_SLOT(dialogChanged()));
}


ConfigConnectOptions::~ConfigConnectOptions()
{}


void ConfigConnectOptions::autoConnectToggled(bool)
{
	if (DoAutoConnectCheckBox->isChecked())
		AutoConnectProfileComboBox->setEnabled(true);
	else
		AutoConnectProfileComboBox->setEnabled(false);
}

void ConfigConnectOptions::dialogChanged()
{
// 	std::cout << "ConfigConnectOptions::dialogChanged()" << std::endl;
	dialogModified=true;
}

