/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MANAGECISCOCERT_H
#define MANAGECISCOCERT_H

#include <manageciscocertbase.h>
#include <kdialogbase.h>

#include <tqprocess.h>
#include <tqpopupmenu.h>
#include <tqstringlist.h>

#include "kvpncconfig.h"

/**
	@author Christoph Thielecke <crissi99@gmx.de>
*/
class ManageCiscoCert : public KDialogBase
{
	Q_OBJECT
  
	public:
		ManageCiscoCert(TQWidget *parent, const char* caption, KVpncConfig *GlobalConfig);

		~ManageCiscoCert();
	

	private:
		KVpncConfig *GlobalConfig;
		TQProcess *DeleteProcess;
		TQProcess *ShowProcess;
		TQPopupMenu *ContextMenu;
		TQStringList CertDataList;
		TQString CertDataName;
		TQString CertType;
		bool CertStartFound;

	private slots:
		void deleteCertClicked();
		void importCertClicked();
		void showCertClicked();
		void deleteProcessFinished();
		void showProcessFinished();
		void checkList();
		void readFromStdout_remove();
		void readFromStderr_remove();
		void readFromStdout_display();
		void readFromStderr_display();
		void contextMenuRequested ( TQListViewItem * item, const TQPoint &pos, int );
		void doContextMenuAction ( int action);

	public:
		ManageCiscoCertBase *main;

};

#endif
