/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   @description This class imports a openvpn configuration file                             *
*                                                                         *
*   @author Christoph Thielecke <crissi99@gmx.de>                    *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
//BEGIN INCLUDES
#include <tdemessagebox.h>
#include <tdeio/netaccess.h>
#include <tdetempfile.h>
#include <tdelocale.h>
#include <tdeconfig.h>
#include <kdialogbase.h>
#include <kcombobox.h>
#include <kurlrequester.h>
#include <klineedit.h>
#include <kpassdlg.h>
#include <kpushbutton.h>
#include <kstandarddirs.h>
#include <tqfile.h>
#include <tqurl.h>
#include <kurl.h>
#include <tqtextstream.h>
#include <tqcheckbox.h>
#include <tqlistview.h>
#include <string>
#include <tqprocess.h>
#include <tqregexp.h>
#include <tqdialog.h>

#include <iostream>

#include "importipsecprofiledialog.h"
#include "utils.h"
#include "importcertificatedialog.h"
#include <tdelistview.h>
#include "kvpncimportprofileselectiondialogbase.h"


//END INCLUDES

ImportIpsecProfileDialog::ImportIpsecProfileDialog ( KVpncConfig *GlobalConfig, TQWidget *parent, const TQString& caption, TQString file )
		: KDialogBase ( parent, "Import_Ipsec_profile", true, caption, KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Ok, true )
{
	if ( !file.isEmpty() )
		filename = file;
	else
		filename = "";
	Pkcs12CertFile = "";
	CertPath="/etc/ipsec/certs";
	importOk = false;
	this->GlobalConfig = GlobalConfig;

	main = new ImportOpenvpnProfileDialogBase ( this );
	setMainWidget ( main );
	//main->setMinimumSize(main->sizeHint());

	main->FilenameUrlrequester->setFilter ( "*.conf" );
	main->FilenameUrlrequester->setURL ( filename );
	main->OpenProfileManagerCheckBox->hide();
	main->TextLabel->setText ( i18n ( "Select IPSec config file:" ) );

}

ImportIpsecProfileDialog::~ImportIpsecProfileDialog()
{
	delete main;
}

void ImportIpsecProfileDialog::accept()
{
	filename = main->FilenameUrlrequester->url();
	if ( !filename.isEmpty() )
	{
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n ( "IPSec import: file: %1" ).arg ( filename ), GlobalConfig->debug );
		canAccept();
	}
	else
	{
		GlobalConfig->appendLogEntry ( i18n ( "IPSec import: file name empty" ), GlobalConfig->error );
		KMessageBox::sorry ( 0, i18n ( "File name can not be empty!" ), i18n ( "Empty File Name" ) );
	}
}

void ImportIpsecProfileDialog::reject()
{
	importOk=false;
}

void ImportIpsecProfileDialog::canAccept()
{

	TQFile f ( filename );
	if ( !f.exists() )
	{
		KMessageBox::sorry ( 0, i18n ( "File not found." ), i18n ( "No File" ) );

		//		emit progress( 100 );
		return ;
	}


	TQFile IpsecConfigFile ( filename );
	TQString importprefix = TQFileInfo ( filename ).dirPath();

	if ( GlobalConfig->KvpncDebugLevel > 2 )
		GlobalConfig->appendLogEntry ( i18n ( "IPSec import: import prefix: %1" ).arg ( importprefix ), GlobalConfig->debug );

	TQString certprefix = locateLocal ( "data", "kvpnc" );

	if ( IpsecConfigFile.open ( IO_ReadOnly ) )
	{

		TQPtrList<VpnAccountData> *ImportedAccountList = new TQPtrList<VpnAccountData>();
		ImportedAccountList->setAutoDelete ( TRUE ); // the list owns the objects
		TQPtrList<IpsecImportSection> *IpsecImportSectionList = new TQPtrList<IpsecImportSection>();

		bool isIpsecGlobalSection=false;
		bool firstSectionFound=false;
		bool defaultSectionFound=false;
		bool useNat=false;
		bool disableOpportunisticEncryption=true;
		TQStringList InterfaceList;
		int IpsecVersion=1;
// 	bool pskIsInFile=true;
		TQString PskFile="/etc/ipsec.secrets";
		TQString CertPath="/etc/ipsec.d/certs";

		TQString IpsecConfigSection="";
		bool validLineFound=false;

		TQString line = NULL;
		TQString IpsecConfigSectionName="";
		TQString IpsecConfigData="";
		bool sectionEndFound=false;

// 		std::cout << "pass1: collecting sections" << std::endl;
		if ( GlobalConfig->KvpncDebugLevel > 2 )
			GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: pass1: collecting sections" ),GlobalConfig->debug );
		TQTextStream stream ( &IpsecConfigFile );
		while ( !stream.atEnd() )
		{
			line = stream.readLine().replace ( "\"","" );

// 			std::cout << "line: \"" << line << "\"" << std::endl;

			if ( IpsecConfigSectionName!="" && ( line=="\n" || GlobalConfig->removeWhiteSpaceAtBegin ( line ) =="\n" ||  line == NULL || line.startsWith ( "include" ) || line.startsWith ( "conn" ) ) )
			{
				// end of section found
// 				std::cout << "end of section " << IpsecConfigSectionName << " found." << std::endl;
				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: end of section %1 found." ).arg ( IpsecConfigSectionName ),GlobalConfig->debug );
				sectionEndFound=true;

				IpsecImportSection *section = new IpsecImportSection();
				section->SectionName = IpsecConfigSectionName;
				section->SectionData = IpsecConfigData;
				IpsecImportSectionList->append ( section );
				IpsecConfigData="";
				IpsecConfigSectionName="";

// 				std::cout << "Section:"<< std::endl;
// 				std::cout << section->SectionName << std::endl;
// 				std::cout << section->SectionData.join("\n");
// 				std::cout << "-------------------"<< std::endl;

				if ( GlobalConfig->KvpncDebugLevel > 2 )
				{
					GlobalConfig->appendLogEntry ( "import ipsec config: Section:",GlobalConfig->debug );
					GlobalConfig->appendLogEntry ( section->SectionName ,GlobalConfig->debug );
					GlobalConfig->appendLogEntry ( section->SectionData.join ( "\n" ),GlobalConfig->debug );
					GlobalConfig->appendLogEntry ( "-------------------",GlobalConfig->debug );
				}
			}

			if ( line.startsWith ( "conn" ) )
			{
				// section found
				IpsecConfigSectionName=line.simplifyWhiteSpace().section ( '#',0,0 ).section ( " ",1,1 );
// 				std::cout << "normal section found: " << IpsecConfigSectionName << std::endl;

				isIpsecGlobalSection=false;

				if ( IpsecConfigSectionName == "%default" )
				{
					defaultSectionFound=true;
					sectionEndFound=false;
					firstSectionFound=true;
					if ( GlobalConfig->KvpncDebugLevel > 2 )
						GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: default section found." ),GlobalConfig->debug );
				}
				else
				{
					if ( GlobalConfig->KvpncDebugLevel > 2 )
						GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: normal section found: " ) + IpsecConfigSectionName ,GlobalConfig->debug );
					sectionEndFound=false;
					firstSectionFound=true;
				}
			}
			if ( line.startsWith ( "version" ) )
			{
				IpsecVersion=TQString ( line.simplifyWhiteSpace().section ( '#',0,0 ).section ( " ",1,1 ).stripWhiteSpace() ).toFloat();
				validLineFound=true;
// 				std::cout << "ipsec version found: " << IpsecVersion << std::endl;
				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: ipsec version found: " ) + TQString().setNum ( IpsecVersion ) ,GlobalConfig->debug );
			}
			if ( line.startsWith ( "config setup" ) )
			{
				// config section found
				isIpsecGlobalSection=true;
				validLineFound=true;
// 				std::cout << "global section found." << std::endl;
				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: global section found." ),GlobalConfig->debug );
			}

			if ( isIpsecGlobalSection==true )
			{
				TQString line2 = GlobalConfig->removeWhiteSpaceAtBegin ( line );
// 				std::cout << "global section line: " << line2 << std::endl;
				if ( line2.startsWith ( "plutodebug" ) )
				{
					validLineFound=true;
					// FIXME not implemented yet
				}
				if ( line2.startsWith ( "nat_traversal=" ) )
				{
					validLineFound=true;
					useNat=false;
					if ( line2.section ( '=',1,1 ) == "yes" )
					{
						useNat=true;
						if ( GlobalConfig->KvpncDebugLevel > 2 )
							GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: use NAT." ),GlobalConfig->debug );
					}
					else
					{
						useNat=false;
						if ( GlobalConfig->KvpncDebugLevel > 2 )
							GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: use no NAT." ),GlobalConfig->debug );
					}
				}

				if ( line2.startsWith ( "interfaces=" ) )
				{
					validLineFound=true;
					if ( line2.section ( '=',1,1 ) == "%defaultroute" )
					{
						InterfaceList.append ( "default" );
						if ( GlobalConfig->KvpncDebugLevel > 2 )
							GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: use interface where default route points" ),GlobalConfig->debug );
					}
					else
					{
						InterfaceList = TQStringList::split ( ' ',line2.replace ( "interfaces=","" ).replace ( TQRegExp ( "ipsec[0-9]=" ),"" ) );
// 						std::cout << "interface list: " << InterfaceList << std::endl;
						if ( GlobalConfig->KvpncDebugLevel > 2 )
							GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: use interface from list:" ) + " "+InterfaceList.join ( ", " ),GlobalConfig->debug );
					}
				}
			}

			if ( line.startsWith ( "include /etc/ipsec.d/examples/no_oe.conf" ) )
			{
				validLineFound=true;
				isIpsecGlobalSection=false;
// 				std::cout << "opportunistic enncrytion disabled found." << std::endl;
				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: opportunistic encrytion disabled found" ),GlobalConfig->debug );

				disableOpportunisticEncryption=true;
			}

			if ( !sectionEndFound && firstSectionFound==true )
			{
				// collecting data
				TQString cleanLine = GlobalConfig->removeWhiteSpaceAtBegin ( line ) +"\n";
// 				std:: cout << "clean line: \"" << cleanLine << "\"" << std::endl;
				if ( !cleanLine.startsWith ( "#" ) && !cleanLine.startsWith ( "include" )  && cleanLine != ""  && !line.startsWith ( "conn" ) && cleanLine != "\n" )
				{
// 					std:: cout << "appending line: \"" << line << "\"" << std::endl;
					IpsecConfigData.append ( line+"\n" );
				}
				else
				{
// 					std:: cout << "skipping line: \"" << line << "\"" << std::endl;
				}
			}
		}
		if ( IpsecConfigSectionName!="" )
		{
			// end of section found
// 			std::cout << "end of section " << IpsecConfigSectionName << " found." << std::endl;
			if ( GlobalConfig->KvpncDebugLevel > 2 )
				GlobalConfig->appendLogEntry ( "end of section " + IpsecConfigSectionName +" found.",GlobalConfig->debug );
			sectionEndFound=true;

			IpsecImportSection *section = new IpsecImportSection();
			section->SectionName = IpsecConfigSectionName;
			section->SectionData = IpsecConfigData;
			IpsecImportSectionList->append ( section );
			IpsecConfigData="";
			IpsecConfigSectionName="";
		}

		IpsecConfigFile.close();


// 		std::cout << "pass2: modifiy sections" << std::endl;
		if ( GlobalConfig->KvpncDebugLevel > 2 )
			GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: pass2: modifiy sections" ),GlobalConfig->debug );

// 		std::cout << "sections: IpsecImportSectionList: " << IpsecImportSectionList->count() << std::endl;
		if ( GlobalConfig->KvpncDebugLevel > 2 )
			GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: sections: " ) + TQString().setNum ( IpsecImportSectionList->count() ),GlobalConfig->debug );

		if ( !IpsecImportSectionList->isEmpty() )
		{
			for ( int i=0; i< ( int ) IpsecImportSectionList->count();i++ )
			{
				IpsecImportSection *section = IpsecImportSectionList->at ( i );
				TQString Name= section->SectionName;
				TQStringList data = TQStringList::split ( '\n',section->SectionData.join ( "\n" ) );

// 				std::cout << "	 => processing section: \"" << Name << "\"" << std::endl;

				if ( Name != "%default" )
				{
					if ( GlobalConfig->KvpncDebugLevel > 2 )
						GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: => processing section: " ) +"\"" + Name + "\"",GlobalConfig->debug );

					for ( TQStringList::Iterator it2 = data.begin(); it2 != data.end(); ++it2 )
					{
						TQString dataline = *it2;
						// 					std::cout << "dataline found: \"" << dataline.remove("\n") << "\"" << std::endl;
						if ( GlobalConfig->removeWhiteSpaceAtBegin ( dataline ).startsWith ( "also=" ) )
						{
							// 						std::cout << "also= found, looking for other section..." << std::endl;
							if ( GlobalConfig->KvpncDebugLevel > 2 )
								GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: also= found, looking for other section..." ),GlobalConfig->debug );

							TQString newdata = TQString ( section->SectionData.join ( "\n" ) );
							newdata.replace ( TQRegExp ( "^.*also=.*$" ),"" );
							section->SectionData= newdata;

							TQString OtherSection=dataline.simplifyWhiteSpace().section ( '#',0,0 ).section ( "=",1,1 );
							// we have to find the other section and replace this line by the config data of the other section (after the =)
							bool section_found=false;
							for ( IpsecImportSection * it3 = IpsecImportSectionList->first(); it3; it3 = IpsecImportSectionList->next() )
							{
								if ( it3->SectionName == OtherSection )
								{
									// 								std::cout << "section " << OtherSection << " found, appending:" << std::endl;
									if ( GlobalConfig->KvpncDebugLevel > 2 )
										GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: section %1 found, appending:" ).arg ( OtherSection ),GlobalConfig->debug );
									// 								std::cout << "other data:" << std::endl << it3->SectionData.join("\n")  << "--------" << std::endl;
									// 								std::cout << "section data:" << std::endl << section->SectionData.join("\n")  << "--------" << std::endl;
									section_found=true;
									// 								data.remove(dataline);
									dataline="";
									// 								TQStringList otherdata = TQStringList::split("\n",TQString(it3->SectionData.join("\n")));
									TQString OtherData = TQString ( it3->SectionData.join ( "\n" ) );

									TQStringList newdata;

									for ( TQStringList::Iterator it6 = data.begin(); it6 != data.end(); ++it6 )
									{
										// 									std::cout << " also line: " << *it6 << std::endl;
										if ( GlobalConfig->KvpncDebugLevel > 2 )
											GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: also line: " ) + TQString ( *it6 ),GlobalConfig->debug );

										if ( TQString ( *it6 ).find ( "also=" ) < 0 )
										{
											// 										std::cout << " also= found." << std::endl;
											if ( GlobalConfig->KvpncDebugLevel > 2 )
												GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: also= found." ),GlobalConfig->debug );
											newdata.append ( TQString ( *it6 ) );
										}
										else
										{
											// 										std::cout << " also= not found." << std::cout;
											if ( GlobalConfig->KvpncDebugLevel > 2 )
												GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: also= not found." ) ,GlobalConfig->debug );
										}
									}
									// 								newdata.append(data.join("\n"));
									newdata.append ( OtherData );
									section->SectionData= newdata;

								}
							}
							if ( !section_found )
							{
								// 							std::cout << "section " << OtherSection << " not found, skipping" << std::endl;
								if ( GlobalConfig->KvpncDebugLevel > 2 )
									GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: section %1 not found, skipping" ).arg ( OtherSection ) ,GlobalConfig->debug );
							}

						}
					}

					if ( defaultSectionFound==true )
					{
						if ( GlobalConfig->KvpncDebugLevel > 2 )
							GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: => default section is set... " ),GlobalConfig->debug );

						for ( int i=0; i< ( int ) IpsecImportSectionList->count();i++ )
						{
							IpsecImportSection *section2 = IpsecImportSectionList->at ( i );
							TQString Name= section2->SectionName;
							if ( Name == "%default" )
							{

								if ( GlobalConfig->KvpncDebugLevel > 2 )
									GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: => appending %default section: " ) +"\"" + section2->SectionData.join ( "\n" ) ,GlobalConfig->debug );

								TQStringList defaultdata = TQStringList::split ( '\n',section2->SectionData.join ( "\n" ) );


								for ( TQStringList::Iterator defaultit = defaultdata.begin(); defaultit != defaultdata.end(); ++defaultit )
								{
									if ( GlobalConfig->KvpncDebugLevel > 2 )
										GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: => appending %default line: " ) +"\"" + *defaultit,GlobalConfig->debug );
									section->SectionData.append ( *defaultit );
								}
								break;
							}
						}
					}
				}
			}
		}

// 		std::cout << "modified config" << std::endl << "---------------------" << std::endl;
// 		KVpncConfig->IpsecImportSection *it5=NULL;
// 		for ( it5 = IpsecImportSectionList->first(); it5; it5 = IpsecImportSectionList->next() )
// 		{
// 			TQString SectionName= it5->SectionName;
// 			TQStringList data = it5->SectionData;
//
// 			std::cout << SectionName << std::endl;
// 			std::cout << data.join("\n") << std::endl;
// 		}

		// remove default section
		for ( int i=0; i< ( int ) IpsecImportSectionList->count();i++ )
		{
			IpsecImportSection *section = IpsecImportSectionList->at ( i );
			TQString Name= section->SectionName;
			if ( Name == "%default" )
			{
				IpsecImportSectionList->remove ( IpsecImportSectionList->at ( i ) );
				break;
			}
		}

		if ( GlobalConfig->KvpncDebugLevel > 2 )
		{
			GlobalConfig->appendLogEntry ( i18n ( "modified config" ) ,GlobalConfig->debug );
			GlobalConfig->appendLogEntry ( "---------------------" ,GlobalConfig->debug );
			IpsecImportSection *it5=NULL;
			for ( it5 = IpsecImportSectionList->first(); it5; it5 = IpsecImportSectionList->next() )
			{
				TQString SectionName= it5->SectionName;
				TQStringList data = it5->SectionData;

				GlobalConfig->appendLogEntry ( SectionName  ,GlobalConfig->debug );
				GlobalConfig->appendLogEntry ( data.join ( "\n" )  ,GlobalConfig->debug );
			}
		}


// 		std::cout << "pass3: parse sections" << std::endl;
		if ( GlobalConfig->KvpncDebugLevel > 2 )
			GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: pass3: parse sections" ) ,GlobalConfig->debug );


		if ( !IpsecImportSectionList->isEmpty() )
		{
			for ( int i=0; i< ( int ) IpsecImportSectionList->count();i++ )
			{
				IpsecImportSection *section = IpsecImportSectionList->at ( i );

				TQStringList sectiondata = TQStringList::split ( '\n',section->SectionData.join ( "\n" ) );

// 				std::cout << "	 => processing section: \"" << section->SectionName << "\"" << std::endl;
// 				std::cout << "	 => data: \"" << section->SectionData.join("\n") << "\"" << std::endl;
				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: 	 => processing section: " ) +"\"" + section->SectionName + "\"" ,GlobalConfig->debug );

				VpnAccountData *profiledata = new VpnAccountData ( VpnAccountData::freeswan,TQString ( section->SectionName ) ) ;


				for ( TQStringList::Iterator it2 = sectiondata.begin(); it2!= sectiondata.end() ; it2++ )
				{
					TQString dataline = *it2;


					TQString line2 = GlobalConfig->removeWhiteSpaceAtBegin ( dataline ); // line of text excluding '\n' and replace all white chars with one blank
// 					std::cout << "dataline: \"" << line2 << "\"";
					if ( line2.startsWith ( "rightsubnet=" ) )
					{
						validLineFound=true;
						TQString RightSubnet=line2.section ( "rightsubnet=",1,-1 );
// 						std::cout << "right subnet (remote) found: " << RightSubnet << std::endl;
						if ( GlobalConfig->KvpncDebugLevel > 2 )
							GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: right subnet (remote) found: " ) + RightSubnet ,GlobalConfig->debug );
						profiledata->setRemoteNetAddr ( RightSubnet.section ( '/',0,0 ) );
						profiledata->setRemoteNetMask ( RightSubnet.section ( '/',1,1 ) );

						profiledata->setUseRemoteNetwork ( true );
// 						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
// 						if (GlobalConfig->KvpncDebugLevel > 2)
// 							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "leftsubnet=" ) )
					{
						validLineFound=true;
						TQString LeftSubnet=line2.section ( "leftsubnet=",1,-1 );
// 						std::cout << "left subnet (local) found: " << LeftSubnet << std::endl;
						if ( GlobalConfig->KvpncDebugLevel > 2 )
							GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: left subnet (local) found: " ) + LeftSubnet ,GlobalConfig->debug );
						//						local subnet cant be set yet.
						// 					profiledata->setLocalNetAddr(RightSubnet.section('/',0,0));
						// 					profiledata->setLocalNetMask(RightSubnet.section('/',1,1));
						// 					std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;

					}
					if ( line2.startsWith ( "rightnexthop=" ) )
					{
						validLineFound=true;
						TQString RightNextHop=line2.section ( "rightnexthop=",1,-1 );
// 						std::cout << "right next hop (remote) found: " << RightNextHop << std::endl;
						if ( GlobalConfig->KvpncDebugLevel > 2 )
							GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: right next hop (remote) found: " ) +RightNextHop ,GlobalConfig->debug );
						profiledata->setRightNextHop ( RightNextHop );
						profiledata->setUseRightNextHop(true);
// 						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
// 						if (GlobalConfig->KvpncDebugLevel > 2)
// 							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "leftnexthop=" ) )
					{
						validLineFound=true;
						TQString LeftNextHop=line2.section ( "leftnexthop=",1,-1 );
						std::cout << "left next hop (local) found: " << LeftNextHop << std::endl;
						if (GlobalConfig->KvpncDebugLevel > 2)
							GlobalConfig->appendLogEntry("import ipsec config: left next hop (local) found: " +LeftNextHop ,GlobalConfig->debug);
						profiledata->setLeftNextHop(LeftNextHop);
						profiledata->setUseLeftNextHop(true);
						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
						if (GlobalConfig->KvpncDebugLevel > 2)
							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "left=" ) )
					{
						validLineFound=true;
						TQString left=line2.section ( "left=",1,-1 );
						//						local ip cant be set yet.
						// 					std::cout << "left found: " << left << std::endl;
// 							if (GlobalConfig->KvpncDebugLevel > 2)
// 								GlobalConfig->appendLogEntry("import ipsec config: left found: " + left ,GlobalConfig->debug);
						// 					profiledata->setLocal (left);
						// 					std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
// 						if (GlobalConfig->KvpncDebugLevel > 2)
// 							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "right=" ) )
					{
						validLineFound=true;
						TQString right=line2.section ( "right=",1,-1 );
// 						std::cout << "right (remote gateway) found: " << right << std::endl;
						if ( GlobalConfig->KvpncDebugLevel > 2 )
							GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: right (remote gateway) found: " ) + right ,GlobalConfig->debug );
						profiledata->setGateway ( right );
// 						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
// 						if (GlobalConfig->KvpncDebugLevel > 2)
// 							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "leftcert=" ) )
					{
						validLineFound=true;
						TQString LeftCert=line2.section ( "leftcert=",1,-1 );
// 						std::cout << "left cert (local) found: " << LeftCert << std::endl;
						if ( GlobalConfig->KvpncDebugLevel > 2 )
							GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: left cert (local) found: " ) + LeftCert ,GlobalConfig->debug );
						profiledata->setX509Certificate ( LeftCert );
// 						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
// 						if (GlobalConfig->KvpncDebugLevel > 2)
// 							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "rightcert=" ) )
					{
						validLineFound=true;
						TQString RightCert=line2.section("rightcert=",1,-1);
// 						std::cout << "right cert (remote) found: " << RightCert << std::endl;
						if (GlobalConfig->KvpncDebugLevel > 2)
							GlobalConfig->appendLogEntry(i18n ("import ipsec config: right cert (remote) found: ") + RightCert ,GlobalConfig->debug);
						profiledata->setUseSpecialServerCertificate(true);
						profiledata->setSpecialServerCertificate(RightCert);
// 						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
// 						if (GlobalConfig->KvpncDebugLevel > 2)
// 							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "rightca=" ) )
					{
						validLineFound=true;
						TQString RightCA=line2.section ( "rightca=",1,-1 );
// 						std::cout << "right CA (remote) found: " << RightCA << std::endl;
						if ( GlobalConfig->KvpncDebugLevel > 2 )
							GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: right CA (remote) found: " ) +RightCA ,GlobalConfig->debug );
						profiledata->setCaCertificate ( RightCA );
// 						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
// 						if (GlobalConfig->KvpncDebugLevel > 2)
// 							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "rightid=" ) )
					{
						validLineFound=true;
						TQString RightID=line2.section ( "rightid=",1,-1 );
// 						std::cout << "right ID (remote) found: " << RightID << std::endl;
						if ( GlobalConfig->KvpncDebugLevel > 2 )
							GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: right ID (remote) found: " ) + RightID ,GlobalConfig->debug );
						profiledata->setUseSpecialRemoteID ( true );
						profiledata->setSpecialRemoteID ( RightID );
						profiledata->setRemoteIDType("keyid");
// 						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
// 						if (GlobalConfig->KvpncDebugLevel > 2)
// 							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "leftid=" ) )
					{
						validLineFound=true;
						TQString LeftID=line2.section ( "leftid=",1,-1 );
// 						std::cout << "local ID (local) found: " << LeftID << std::endl;
						if ( GlobalConfig->KvpncDebugLevel > 2 )
							GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: local ID (local) found: " ) + LeftID ,GlobalConfig->debug );
						profiledata->setUseSpecialLocalID ( true );
						profiledata->setSpecialLocalID ( LeftID );
						profiledata->setLocalIDType("keyid");
// 						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
// 						if (GlobalConfig->KvpncDebugLevel > 2)
// 							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "rightrsasigkey=" ) )
					{
						validLineFound=true;
						TQString RightRsaSigKey=line2.section ( "rightrsasigkey=",1,-1 );
// 						std::cout << "right uses (remote) " << RightRsaSigKey << std::endl;
						if (RightRsaSigKey=="%cert")
						{
							if ( GlobalConfig->KvpncDebugLevel > 2 )
								GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: right (remote) uses cert" ),GlobalConfig->debug );
							profiledata->setAuthType ( VpnAccountData::cert );
						}
						else
						{

							if ( GlobalConfig->KvpncDebugLevel > 2 )
								GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: right (remote) uses " ) + RightRsaSigKey ,GlobalConfig->debug );
							profiledata->setAuthType ( VpnAccountData::psk );

							// ok, we use special server cert here because at psk its unused
							profiledata->setSpecialServerCertificate( RightRsaSigKey );
							profiledata->setUseSpecialServerCertificate(true);
						}
// 						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
// 						if (GlobalConfig->KvpncDebugLevel > 2)
// 							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "leftrsasigkey=" ) )
					{
						validLineFound=true;
						TQString LeftRsaSigKey=line2.section ( "leftrsasigkey=",1,-1 );
// 						std::cout << "right uses (remote) " << LeftRsaSigKey << std::endl;
						if (LeftRsaSigKey=="%cert")
						{
							if ( GlobalConfig->KvpncDebugLevel > 2 )
								GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: left (local) uses cert" ),GlobalConfig->debug );
							profiledata->setAuthType ( VpnAccountData::cert );

						}
						else
						{

							if ( GlobalConfig->KvpncDebugLevel > 2 )
								GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: left (local) uses " ) + LeftRsaSigKey ,GlobalConfig->debug );
							profiledata->setAuthType ( VpnAccountData::psk );
	
							profiledata->setPreSharedKeyFile( LeftRsaSigKey );
							profiledata->setPskIsInFile( true );
						}
// 						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
// 						if (GlobalConfig->KvpncDebugLevel > 2)
// 							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "authby=" ) )
					{
						validLineFound=true;
						TQString Authby=line2.simplifyWhiteSpace().section ( "authby=",1,1 );
// 						std::cout << "left and right use certs " << std::endl;
						if ( Authby.find ( "rsasig", 0 , FALSE ) > -1 )
						{
							if ( GlobalConfig->KvpncDebugLevel > 2 )
								GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: left and right use certs." ) ,GlobalConfig->debug );
							profiledata->setAuthType ( VpnAccountData::cert );
							profiledata->setCertPath ( "/etc/ipsec.d/certs" );
							//profiledata->setPskIsInFile ( true );
							//profiledata->setPrivateKeyFile ( "/etc/ipsec.secrets" );
						}
						else if ( Authby.find ( "secret", 0 , FALSE ) > -1 )
						{
							if ( GlobalConfig->KvpncDebugLevel > 2 )
								GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: left and right use psk." ) ,GlobalConfig->debug );
							profiledata->setAuthType ( VpnAccountData::psk );
							//profiledata->setPskIsInFile ( true );
							//profiledata->setPreSharedKeyFile ( "/etc/ipsec.secrets" );
						}
						else
						{
							if ( GlobalConfig->KvpncDebugLevel > 2 )
								GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: left and right use unknown auth, guess psk" ) ,GlobalConfig->debug );
							profiledata->setAuthType ( VpnAccountData::psk );
						}


// 						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
// 						if (GlobalConfig->KvpncDebugLevel > 2)
// 							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "auto=start" ) )
					{
						// 					validLineFound=true;
						// 					TQString Authby=line2.simplifyWhiteSpace().section('#',0,0).section("=",1,1);
						// 					std::cout << "profile should be started" << std::endl;
// 						if (GlobalConfig->KvpncDebugLevel > 2)
// 							GlobalConfig->appendLogEntry("import ipsec config: profile should be started" ,GlobalConfig->debug);
						// 					profiledata->setAuthType(VpnAccountData::cert);
						// 					std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
// 						if (GlobalConfig->KvpncDebugLevel > 2)
// 							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "leftsourceip=" ) )
					{
						validLineFound=true;
						TQString leftsourceip=line2.section ( "leftsourceip=",1,-1 );
							std::cout << "left (local) have to use IP address " << leftsourceip << std::endl;
						if (GlobalConfig->KvpncDebugLevel > 2)
							GlobalConfig->appendLogEntry("import ipsec config: left (local) have to use IP address " + leftsourceip ,GlobalConfig->debug);
						profiledata->setLocalVirtualIP(leftsourceip);
// 						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
						if (GlobalConfig->KvpncDebugLevel > 2)
							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "virtual_private=" ) )
					{
						validLineFound=true;
						TQString virtualprivate=line2.section ( "virtual_private=",1,-1 );
											std::cout << "virtual private networks " << virtualprivate << std::endl;
						if (GlobalConfig->KvpncDebugLevel > 2)
							GlobalConfig->appendLogEntry("import ipsec config: virtual private networks " +virtualprivate ,GlobalConfig->debug);
						profiledata->setLocalVirtualIP(virtualprivate);
						profiledata->setUseVirtualIP(true);
// 						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
						if (GlobalConfig->KvpncDebugLevel > 2)
							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "rightsourceip=" ) )
					{
						validLineFound=true;
						TQString rightsourceip=line2.section ( "rightsourceip=",1,-1 );
											std::cout << "right (remote) have to use IP address " << rightsourceip << std::endl;
						if (GlobalConfig->KvpncDebugLevel > 2)
							GlobalConfig->appendLogEntry("import ipsec config: right (remote) have to use IP address " + rightsourceip ,GlobalConfig->debug);
						profiledata->setRightSourceIp(rightsourceip);
						profiledata->setUseRightSourceIp(true);
// 						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
						if (GlobalConfig->KvpncDebugLevel > 2)
							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "esp=" ) )
					{
						validLineFound=true;
						TQString IpsecEsp=line2.section ( "esp=",1,-1 );
// 						std::cout << "esp settings found: " << IpsecEsp << std::endl;
						if ( GlobalConfig->KvpncDebugLevel > 2 )
							GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: esp settings found: " ) + IpsecEsp ,GlobalConfig->debug );
						profiledata->setIpsecEsp ( IpsecEsp );
						profiledata->setUseCustomEsp(true);
// 						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
// 						if (GlobalConfig->KvpncDebugLevel > 2)
// 							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "ike=" ) )
					{
						validLineFound=true;
						TQString IpsecIke=line2.section ( "ike=",1,-1 );
// 						std::cout << "ike settings found: " << IpsecIke << std::endl;
						if ( GlobalConfig->KvpncDebugLevel > 2 )
							GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: ike settings found: " ) + IpsecIke ,GlobalConfig->debug );
						profiledata->setIpsecIke ( IpsecIke );
						profiledata->setUseCustomIke(true);
// 						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
// 						if (GlobalConfig->KvpncDebugLevel > 2)
// 							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "type=" ) )
					{
						validLineFound=true;
						TQString IpsecVpnMode=line2.section ( "type=",1,1 );
// 						std::cout << "IpsecType found: " << IpsecType << std::endl;
						if ( GlobalConfig->KvpncDebugLevel > 2 )
							GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: IPsec vpn mode found: " ) + IpsecVpnMode ,GlobalConfig->debug );
						if ( IpsecVpnMode == "tunnel" )
							profiledata->setIpsecVpnMode ( "tunnel" );
						else
							profiledata->setIpsecVpnMode ( "transport" );
// 						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
// 						if (GlobalConfig->KvpncDebugLevel > 2)
// 							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "leftxauthclient=" ) )
					{
						validLineFound=true;
						TQString useXauth=line2.section ( "leftxauthclient=",1,1 );
						if (useXauth=="yes")
						{
 							//std::cout << "Use XAUTH: " << i18n("yes") << std::endl;
							if ( GlobalConfig->KvpncDebugLevel > 2 )
								GlobalConfig->appendLogEntry ( i18n ( "Use XAUTH (leftxauthclient found):" )+" " + i18n("yes") ,GlobalConfig->debug );
							profiledata->setAuthWithUsernameAndPassword( true );
						}
						else
						{
 							//std::cout << "Use XAUTH: " << i18n("no") << std::endl;
							if ( GlobalConfig->KvpncDebugLevel > 2 )
								GlobalConfig->appendLogEntry ( i18n ( "Use XAUTH (leftxauthclient found):" )+" " + i18n("no") ,GlobalConfig->debug );
							profiledata->setAuthWithUsernameAndPassword( false );
						}
// 						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
// 						if (GlobalConfig->KvpncDebugLevel > 2)
// 							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "rightxauthserver=" ) )
					{
						validLineFound=true;
						TQString  useXauth=line2.section ( "rightxauthserver=",1,-1 );
						if (useXauth == "yes")
						{
 							//std::cout << "Use XAUTH: " << i18n("yes") << std::endl;
							if ( GlobalConfig->KvpncDebugLevel > 2 )
								GlobalConfig->appendLogEntry ( i18n ( "Use XAUTH (rightxauthserver found):" )+" " + i18n("yes") ,GlobalConfig->debug );
							profiledata->setAuthWithUsernameAndPassword( true );
						}
						else
						{
 							//std::cout << "Use XAUTH: " << i18n("no") << std::endl;
							if ( GlobalConfig->KvpncDebugLevel > 2 )
								GlobalConfig->appendLogEntry ( i18n ( "Use XAUTH (rightxauthserver found):" )+" " + i18n("no") ,GlobalConfig->debug );
							profiledata->setAuthWithUsernameAndPassword( false );
						}
// 						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
// 						if (GlobalConfig->KvpncDebugLevel > 2)
// 							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "keyingtries=" ) )
					{
						validLineFound=true;
						int MaxConnectTries=TQString(line2.section ( "keyingtries=",1,1 )).toInt();
// 						std::cout << "keyingtries found: " << MaxConnectTries << std::endl;
						if ( GlobalConfig->KvpncDebugLevel > 2 )
							GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: keyingtries found: " ) + TQString().setNum(MaxConnectTries) ,GlobalConfig->debug );
						profiledata->setMaxConnectTries ( MaxConnectTries );
// 						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
// 						if (GlobalConfig->KvpncDebugLevel > 2)
// 							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "pfs=" ) )
					{
						validLineFound=true;
						TQString UsePerfectForwardSecrety=line2.section ( "pfs=",1,1 ).remove ( '"' );
						if (UsePerfectForwardSecrety =="yes")
						{
 							//std::cout << "Use PFS: " << i18n("yes") << std::endl;
							if ( GlobalConfig->KvpncDebugLevel > 2 )
								GlobalConfig->appendLogEntry ( i18n ( "Use PFS:" )+" " + i18n("yes") ,GlobalConfig->debug );
							profiledata->setUsePerfectForwardSecrety( true );
						}
						else
						{
 							//std::cout << "Use PFS: " << i18n("no") << std::endl;
							if ( GlobalConfig->KvpncDebugLevel > 2 )
								GlobalConfig->appendLogEntry ( i18n ( "Use PFS:" )+" " + i18n("no") ,GlobalConfig->debug );
							profiledata->setUsePerfectForwardSecrety( false );
						}
// 						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
// 						if (GlobalConfig->KvpncDebugLevel > 2)
// 							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "pfsgroup=" ) )
					{
						validLineFound=true;
						TQString PerfectForwardSecrety=line2.section ( "pfsgroup=",1,1 );
// 						std::cout << "keyingtries found: " << MaxConnectTries << std::endl;
						if ( GlobalConfig->KvpncDebugLevel > 2 )
							GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: PFS group found: " ) + PerfectForwardSecrety ,GlobalConfig->debug );
						profiledata->setPerfectForwardSecrety ( PerfectForwardSecrety );
// 						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
// 						if (GlobalConfig->KvpncDebugLevel > 2)
// 							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}
					if ( line2.startsWith ( "aggrmode=" ) )
					{
						validLineFound=true;
						TQString UseAgressiveMode=line2.section ( "aggrmode=",1,1 ).remove ( '"' );
						if (UseAgressiveMode == "yes")
						{
 							//std::cout << "Exchange mode: " << i18n("aggressive") << std::endl;
							if ( GlobalConfig->KvpncDebugLevel > 2 )
								GlobalConfig->appendLogEntry ( i18n ( "Exchange mode:" )+" " + "aggressive" ,GlobalConfig->debug );
							profiledata->setExchangeMode( "aggressive" );
						}
						else
						{
 							//std::cout << "Exchange mode: " << i18n("main") << std::endl;
							if ( GlobalConfig->KvpncDebugLevel > 2 )
								GlobalConfig->appendLogEntry ( i18n ( "Exchange mode:" )+" " + "main" ,GlobalConfig->debug );
							profiledata->setExchangeMode( "main" );
						}
// 						std::cout << "	=> set it for profile " << IpsecConfigSection << " ." << std::endl;
// 						if (GlobalConfig->KvpncDebugLevel > 2)
// 							GlobalConfig->appendLogEntry("import ipsec config: => set it for profile " + IpsecConfigSection + " ." ,GlobalConfig->debug);
					}

					else
					{
						// 				std::cout << "comment found." << std::endl;
					}
				}

				if ( useNat )
				{
					profiledata->setUseNat ( true );
// 					std::cout << "nat_traversal=yes found, enabling nat." << std::endl;
					if ( GlobalConfig->KvpncDebugLevel > 2 )
						GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: nat_traversal=yes found, enabling nat." ) ,GlobalConfig->debug );
				}
				else
				{
					profiledata->setUseNat ( false );
// 					std::cout << "nat_traversal=no found, disabling nat." << std::endl;
					if ( GlobalConfig->KvpncDebugLevel > 2 )
						GlobalConfig->appendLogEntry ( i18n ( "import ipsec config: nat_traversal=no found, disabling nat." ) ,GlobalConfig->debug );
				}
				if ( disableOpportunisticEncryption==  true )
				{
					profiledata->setDisableOpportunisticEncryption ( true );
				}
				else
				{
					profiledata->setDisableOpportunisticEncryption ( false );
				}


				// FIXME we only use the first in list
				TQString Interface = InterfaceList.first();
				profiledata->setNetworkDevice ( Interface );

				profiledata->setName ( "kvpnc_import_"+profiledata->getName() );
				profiledata->setDescription ( TQString ( i18n ( "import from " ) +filename ) );
				ImportedAccountList->append ( profiledata );
			}
		}


		KvpncImportProfileSelectionBase selectdlg;
		selectdlg.ImportGlobalSettingsCheckBox->hide();
		selectdlg.OpenProfileManagerCheckBox->hide();
		selectdlg.ImportPushButton->setText(i18n("Import selected profile"));
		VpnAccountData *it=NULL;
		int importCount=0;

		if ( !ImportedAccountList->isEmpty() )
		{
			selectdlg.ImportProfileListView->takeItem ( selectdlg.ImportProfileListView->currentItem() );
			selectdlg.ImportProfileListView->addColumn ( i18n ( "Name" ) );
			selectdlg.ImportProfileListView->addColumn ( i18n ( "Type" ) );
			selectdlg.ImportProfileListView->addColumn ( i18n ( "Gateway" ) );
			selectdlg.ImportProfileListView->addColumn ( i18n ( "Authentication" ) );
			selectdlg.ImportProfileListView->addColumn ( i18n ( "Remote network" ) );
			TQCheckListItem *item;
			for ( it = ImportedAccountList->first(); it; it = ImportedAccountList->next() )
			{
				TQString name = it->getName();
				TQString type="";
				if ( it->getConnectionType() == VpnAccountData::cisco )
					type = "cisco" ;
				else if ( it->getConnectionType() == VpnAccountData::ciscoorig )
					type = "ciscoorig" ;
				else if ( it->getConnectionType() == VpnAccountData::racoon )
					type = "racoon" ;
				else if ( it->getConnectionType() == VpnAccountData::l2tpd_racoon )
					type = "l2tpd (racoon)" ;
				else if ( it->getConnectionType() == VpnAccountData::freeswan )
					type = "ipsec" ;
				else if ( it->getConnectionType() == VpnAccountData::l2tpd_freeswan )
					type = "l2tpd (ipsec)" ;
				else if ( it->getConnectionType() == VpnAccountData::pptp )
					type = "pptp" ;
				else if ( it->getConnectionType() == VpnAccountData::openvpn )
					type = "openvpn" ;
				else
					type =  i18n ( "other" );

// 				litem->setSelectable(true);
				item = new TQCheckListItem ( selectdlg.ImportProfileListView,it->getName(),TQCheckListItem::RadioButton );
				item->setText ( 1,type );
				item->setText ( 2,it->getGateway() );
				if ( it->getAuthType() == VpnAccountData::cert )
					item->setText ( 3,i18n ( "certificate" ) );
				else if ( it->getAuthType() == VpnAccountData::psk )
					item->setText ( 3,i18n ( "preshared key" ) );
				else
					item->setText ( 3,i18n ( "unknown" ) );
				selectdlg.ImportProfileListView->insertItem ( item );
				TQString RemoteNetDiv="/";
				if ( it->getRemoteNetAddr() == "" )
				{
					it->setRemoteNetMask ( "" );
					RemoteNetDiv="";
				}
				item->setText ( 4,TQString ( it->getRemoteNetAddr() +RemoteNetDiv+it->getRemoteNetMask() ) );

// 			std::cout << "insert profile into listview: " << name << std::endl;
			}
		}
		bool ret = selectdlg.exec();
		bool profilefound=false;

		if ( ret == true )
		{
			TQListViewItemIterator it2 ( selectdlg.ImportProfileListView );
			for ( ; it2.current(); ++it2 )
			{
				if ( profilefound==false )
				{
					if ( ( ( TQCheckListItem* ) it2.current() )->isOn() )
					{
						VpnAccountData *data=NULL;
						it = 0;
						for ( it = ImportedAccountList->first(); it; it = ImportedAccountList->next() )
						{
							if ( it->getName() == ( ( TQCheckListItem* ) it2.current() )->text() && ( ( TQCheckListItem* ) it2.current() )->isOn() )
							{
								acc = it;
								profilefound=true;
								importOk = true;
								break;
							}
						}
					}
				}
			}
		}
		else
		{
			KMessageBox::sorry ( 0, i18n ( "IPSec file import canceled." ) );
			return;
		}


// 		KMessageBox::information ( 0, msg,i18n("Import success") );
		importOk = true;
	}
	else
		importOk = false;

	//std::cout << "accept" << std::endl;
	TQDialog::accept();
}

