/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   @description This class imports a certificate                             *
*                                                                         *
*   @author Christoph Thielecke <crissi99@gmx.de>                    *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
//BEGIN includes
#include "importcertificatedialog.h"
#include <tdemessagebox.h>
#include <tdelocale.h>
#include <kurlrequester.h>
#include <kpassdlg.h>
#include <kcombobox.h>
#include <kdebug.h>
#include <klineedit.h>
#include <iostream>
#include <tqfile.h>
#include <tqdir.h>
#include <tqtextstream.h>
#include <tqcursor.h>
#include <tqcheckbox.h>
#include <tqurl.h>
#include <iostream>
#include "kvpncconfig.h"
#include "utils.h"
//END includes

ImportCertificateDialog::ImportCertificateDialog ( TQWidget *parent, const char* caption, KVpncConfig *GlobalConfig )
		: KDialogBase ( parent, i18n ( "Import Certificate" ).ascii(), true, caption,
		                KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true )
{
	main = new ImportCertificateDialogBase ( this );
	setMainWidget ( main );
	main->setMinimumSize ( main->sizeHint() );

	this->GlobalConfig = GlobalConfig;
	filename = "";
	certHash = "";
	CertFullPath="";
	CaCertFullPath="";
	importOk = false;
	importSuccess = true;
	doHash = false;
	doExit=true;
	error_found=false;
	certName = "";
	certpath = "/etc/racoon/certs/";
	pathToOpenSSL = GlobalConfig->pathToOpenssl;
	main->RacoonCertificatePathUrlrequester->setMode ( 2 ); // directory
	main->FilenameUrlrequester->setFilter ( "*" );
	askpasscount=0;

	env = new TQStringList();
	*env << "LC_ALL=C" << "LANG=C" << "PATH=/bin:/usr/bin:/usr/sbin:/sbin";

	connect ( main->ImporttypeComboBox, TQT_SIGNAL ( activated ( int ) ), this, TQT_SLOT ( typeToggeled ( int ) ) );
	typeToggeled ( main->ImporttypeComboBox->currentItem() );

	connect (main->UsePrivateKeyPasswordCheckBox, TQT_SIGNAL( toggled(bool)), this, TQT_SLOT(usePrivateKeyPassToggled(bool)));
	usePrivateKeyPassToggled(main->UsePrivateKeyPasswordCheckBox->isChecked());

	// TMP
	/*
		main->FilenameUrlrequester->setURL( "/home/crissi/thielecke.p12" );
		//main->RacoonCertificatePathUrlrequester->setURL( "/etc/racoon/certs/" );
	main->ImporttypeComboBox->setCurrentItem( 1 );
		main->PrivateKeyPasswordEdit->setText( "12345678" );
		main->PrivateKeyAgainPasswordEdit->setText( "12345678" );
	*/
	//main->ImportPasswordEdit->setText( "blah99" );


}

ImportCertificateDialog::~ImportCertificateDialog()
{
	delete main;
}

void ImportCertificateDialog::accept()
{

	importOk = true;
	done=false;
	error_found=false;

	filename = main->FilenameUrlrequester->url();
	importpassword = main->ImportPasswordEdit->text();
	certpath = main->RacoonCertificatePathUrlrequester->url();

	if ( filename.isEmpty() )
	{
		KMessageBox::sorry ( 0, i18n ( "File name cannot be empty!" ), i18n ( "Empty File Name" ) );
		importOk = false;
		importSuccess=false;
		GlobalConfig->appPointer->restoreOverrideCursor();
		return;
	}

	// 	if ( filename.right( 3 ) != "p12" || filename.right (3) != "der" || filename.right (3) != "crt" ) {
	// 		KMessageBox::sorry( 0, i18n( "File name isnt ended by \'p12\', 'der' or \'crt\'!" ), i18n( "Wrong File Name" ) );
	// 		importOk = false;
	// 		return;
	// 	}

	GlobalConfig->appPointer->setOverrideCursor ( TQCursor ( TQt::WaitCursor ) );

	TQFile f ( filename );
	if ( f.exists() )
	{
		if ( f.open ( IO_ReadOnly ) )
		{
			f.close();
		}
		else
		{
			KMessageBox::sorry ( 0, i18n ( "File does not exist!" ), i18n ( "No File" ) );
			GlobalConfig->appendLogEntry ( i18n ( "Certificate import: file \"%1\" does not exist." ).arg ( filename ),GlobalConfig->error );

			importOk = false;
			GlobalConfig->appPointer->restoreOverrideCursor();
			return;
		}
	}
	else
	{
		KMessageBox::sorry ( 0, i18n ( "File not readable!" ), i18n ( "Insufficient Rights" ) );

		GlobalConfig->appendLogEntry ( i18n ( "Certificate import: file \"%1\" is not readable." ).arg ( filename ),GlobalConfig->error );
		importOk = false;
		GlobalConfig->appPointer->restoreOverrideCursor();
		return;
	}

	if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
	{
		certpath="/etc/ipsec.d";
		if ( !TQDir ( certpath ).exists() )
		{
			if ( !TQDir().mkdir ( certpath ) )
			{
				KMessageBox::error ( this, i18n ( "\"%1\" could not be created!" ).arg ( "/etc/ipsec.d" ) );
				GlobalConfig->appendLogEntry ( i18n ( "Certificate import: directory \"%1\" does not exist and could not be created." ).arg ( "/etc/ipsec.d" ),GlobalConfig->error );
			}
			else
			{
				if ( GlobalConfig->KvpncDebugLevel > 0 )
					GlobalConfig->appendLogEntry ( i18n ( "Certificate import: directory \"%1\" does not exist but was successful created." ).arg ( "/etc/ipsec.d" ),GlobalConfig->debug );
				if ( !TQDir ( "/etc/ipsec.d/certs" ).exists() )
				{
					if ( !TQDir().mkdir ( "/etc/ipsec.d/certs" ) )
					{
						KMessageBox::error ( this, i18n ( "\"%1\" could not be created!" ).arg ( "/etc/ipsec.d/certs" ) );
						GlobalConfig->appendLogEntry ( i18n ( "Certificate import: directory \"%1\" does not exist and could not be created." ).arg ( "/etc/ipsec.d/certs" ),GlobalConfig->error );
						GlobalConfig->appPointer->restoreOverrideCursor();
						return;
					}
					else
					{
						GlobalConfig->appendLogEntry ( i18n ( "Certificate import: directory \"%1\" does not exist but was successful created." ).arg ( "/etc/ipsec.d/certs" ),GlobalConfig->debug );
						if ( !TQDir ( "/etc/ipsec.d/cacerts" ).exists() )
							if ( !TQDir().mkdir ( "/etc/ipsec.d/cacerts" ) )
							{
								KMessageBox::error ( this, i18n ( "\"%1\" could not be created!" ).arg ( "/etc/ipsec.d/cacerts" ) );
								GlobalConfig->appendLogEntry ( i18n ( "Certificate import: directory \"%1\" does not exist and could not  be created." ).arg ( "/etc/ipsec.d/cacerts" ),GlobalConfig->error );
								GlobalConfig->appPointer->restoreOverrideCursor();
								return;
							}
							else
							{
								if ( GlobalConfig->KvpncDebugLevel > 0 )
									GlobalConfig->appendLogEntry ( i18n ( "Certificate import: directory \"%1\" does not exist but was successful created." ).arg ( "/etc/ipsec.d/cacerts" ),GlobalConfig->debug );
							}
					}
				}
			}
		}
	}
	else if ( main->ImporttypeComboBox->currentItem() == pkcs12_racoon || main->ImporttypeComboBox->currentItem() == ca_der )
	{
		certpath="/etc/racoon/certs";
		if ( !TQDir ( certpath ).exists() )
			if ( !TQDir().mkdir ( certpath ) )
			{
				KMessageBox::error ( this, i18n ( "\"%1\" could not be created!" ).arg ( certpath ) );
				GlobalConfig->appendLogEntry ( i18n ( "Certificate import: directory \"%1\" does not exist." ).arg ( certpath ),GlobalConfig->error );
				GlobalConfig->appPointer->restoreOverrideCursor();
				return;
			}
			else
			{
				if ( GlobalConfig->KvpncDebugLevel > 3 )
					GlobalConfig->appendLogEntry ( i18n ( "Certificate import: directory \"%1\" does not exist but was successful created." ).arg ( certpath ),GlobalConfig->debug );
			}
	}
	else if ( main->ImporttypeComboBox->currentItem() == pkcs12_openvpn )
	{
		certpath = main->RacoonCertificatePathUrlrequester->url();
		if ( !TQDir ( certpath ).exists() )
			if ( !TQDir().mkdir ( certpath ) )
			{
				KMessageBox::error ( this, i18n ( "\"%1\" could not be created!" ).arg ( certpath ) );
				GlobalConfig->appendLogEntry ( i18n ( "Certificate import: directory \"%1\" does not exist." ).arg ( certpath ),GlobalConfig->error );
				GlobalConfig->appPointer->restoreOverrideCursor();
				return;
			}
			else
			{
				if ( GlobalConfig->KvpncDebugLevel > 3 )
					GlobalConfig->appendLogEntry ( i18n ( "Certificate import: directory \"%1\" does not exist but was successful created." ).arg ( certpath ),GlobalConfig->debug );
			}
	}

// 	if ( (main->ImporttypeComboBox->currentItem() == pkcs12_freeswan ||
// 	        main->ImporttypeComboBox->currentItem() == pkcs12_racoon ||
// 					main->ImporttypeComboBox->currentItem() == pkcs12_racoon
// 			) &&
// 	        importpassword.isEmpty() )
// 	{
// 		importOk = false;
// 		KMessageBox::sorry( 0, i18n( "Password can't be empty!" ), i18n( "Empty Password" ) );
// 		return;
// 	}

	if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan || main->ImporttypeComboBox->currentItem() == pkcs12_openvpn )
	{
		
		if ( main->UsePrivateKeyPasswordCheckBox->isChecked() && (main->PrivateKeyPasswordEdit->text().isEmpty() || main->PrivateKeyPasswordEdit->text().length() < 4) )
		{
			importOk = false;
			KMessageBox::sorry ( 0, i18n ( "Private key password field can not be empty or less than 4 characters!" ), i18n ( "Password Empty or Too Short" ) );
			GlobalConfig->appPointer->restoreOverrideCursor();
			return;
		}

		if ( main->UsePrivateKeyPasswordCheckBox->isChecked() && (main->PrivateKeyAgainPasswordEdit->text().isEmpty() || main->PrivateKeyAgainPasswordEdit->text().length() < 4 ))
		{
			importOk = false;
			KMessageBox::sorry ( 0, i18n ( "Private key password (again) field can not be empty!" ), i18n ( "Password Empty or Too Short" ) );
			GlobalConfig->appPointer->restoreOverrideCursor();
			return;
		}
		if ( importOk )
		{
			if ( TQString ( main->PrivateKeyPasswordEdit->password() ) != TQString ( main->PrivateKeyAgainPasswordEdit->password() ) )
			{
				importOk = false;
				KMessageBox::sorry ( 0, i18n ( "Private key passwords does not match!" ), i18n ( "Passwords Do Not Match" ) );
				GlobalConfig->appPointer->restoreOverrideCursor();
				return;
			}
			else
			{
				privatekeypassword= TQString ( main->PrivateKeyAgainPasswordEdit->password() );
			}
		}
	}
	if ( main->ImporttypeComboBox->currentItem() == cisco || main->ImporttypeComboBox->currentItem() == ciscoca || main->ImporttypeComboBox->currentItem() == ciscouserca )
	{
		if (main->UsePrivateKeyPasswordCheckBox->isChecked() && ( main->PrivateKeyPasswordEdit->text().isEmpty() || main->PrivateKeyPasswordEdit->text().length() < 4 ))
		{
			importOk = false;
			KMessageBox::sorry ( 0, i18n ( "Certificate password field can not be empty or less than 4 characters!" ), i18n ( "Password Empty or Too Short" ) );
			GlobalConfig->appPointer->restoreOverrideCursor();
			return;
		}

		if (main->UsePrivateKeyPasswordCheckBox->isChecked() && ( main->PrivateKeyAgainPasswordEdit->text().isEmpty() || main->PrivateKeyAgainPasswordEdit->text().length() < 4 ))
		{
			importOk = false;
			KMessageBox::sorry ( 0, i18n ( "Certificate password (again) field can not be empty!" ), i18n ( "Password Empty or Too Short" ) );
			GlobalConfig->appPointer->restoreOverrideCursor();
			return;
		}
		if ( importOk )
		{
			if ( main->UsePrivateKeyPasswordCheckBox->isChecked() && (TQString ( main->PrivateKeyPasswordEdit->password() ) != TQString ( main->PrivateKeyAgainPasswordEdit->password() ) ))
			{
				importOk = false;
				KMessageBox::sorry ( 0, i18n ( "Certificate passwords does not match!" ), i18n ( "Passwords Do Not Match" ) );
				GlobalConfig->appPointer->restoreOverrideCursor();
				return;
			}
			else
			{
				if (main->UsePrivateKeyPasswordCheckBox->isChecked() )
					privatekeypassword= TQString ( main->PrivateKeyAgainPasswordEdit->password() );
			}
		}
	}
	if ( GlobalConfig->KvpncDebugLevel > 3 )
		kdDebug() << "file: " << filename << ", type: " << main->ImporttypeComboBox->currentItem() << endl;

	bool found=true;
	if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan || main->ImporttypeComboBox->currentItem() == pkcs12_openvpn || main->ImporttypeComboBox->currentItem() == pkcs12_racoon || main->ImporttypeComboBox->currentItem() == ca_der )
	{
		// looking for openssl

		TQString bin="openssl";
		ToolInfo *tool = Utils ( GlobalConfig ).getToolInfo ( "openssl" );
		//std::cout << "Tool (bin): " << bin << std::endl;

		if ( tool->PathToExec.section ( '/',-1 ) != bin )
		{
			// program is NOT installed
			KMessageBox::error ( this, i18n ( "The required tool (%1) is not installed, please install it first and restart kvpnc." ).arg ( bin ), i18n ( "Tool missing" ) );
			found=false;
			GlobalConfig->appPointer->restoreOverrideCursor();
			return;
		}

		if ( !found )
		{
			KMessageBox::error ( this, i18n ( "Unable to find \"%1\"!" ).arg ( "openssl" ) );
			GlobalConfig->appendLogEntry ( i18n ( "Unable to find \"%1\"!" ).arg ( "openssl" ) ,GlobalConfig->error );
			importOk = false;
			GlobalConfig->appPointer->restoreOverrideCursor();
			return;
		}


		TQString file = Utils ( this->GlobalConfig ).removeSpecialCharsForFilename ( TQUrl ( filename ).fileName() );
		certName = file.left ( file.length() - 4 ); // peter_pan.p12 -> peter_pan

		if ( main->ImporttypeComboBox->currentItem() == pkcs12_racoon || main->ImporttypeComboBox->currentItem() == pkcs12_openvpn )
		{
			TQString type="";
			if ( main->ImporttypeComboBox->currentItem() == pkcs12_racoon )
				type="racoon";
			else
				type="OpenVPN";
			TQFile certpathtest ( certpath + "/." );

			if ( !certpathtest.exists() )
			{
				KMessageBox::error ( this, i18n ( "%1 certificate path (%2) does not exist!" ).arg ( type ).arg ( certpath ) );
				GlobalConfig->appendLogEntry ( i18n ( "%1 certificate path (%2) does not exist!" ).arg ( type ).arg ( certpath ) ,GlobalConfig->error );
				importOk=false;
				GlobalConfig->appPointer->restoreOverrideCursor();
				return;
			}
			else
			{
				TQFile testfile ( TQString ( certpath + "/test" ) );
				if ( !testfile.open ( IO_WriteOnly ) )
				{
					KMessageBox::error ( this, i18n ( "%1 certificate path (%2) is not writeable!" ).arg ( type ).arg ( certpath ) );
					GlobalConfig->appendLogEntry ( i18n ( "%1 certificate path (%2) is not writeable!" ).arg ( type ).arg ( certpath )  ,GlobalConfig->error );
					importOk = false;
					GlobalConfig->appPointer->restoreOverrideCursor();
					return;
				}
				else
				{
					testfile.remove();
				}
			}
		}
	}

	// here we go
	if ( importOk )
	{

		/*
		FreeSWAN/Racoon:
		openssl pkcs12 -in cert.p12 -clcerts -out /etc/racoon/certs/mykeys_company.pem -nodes

		DER:
		openssl x509 -in cert.crt -out ca_company.pem -inform DER

		*/
		// 		 		std::cout << "[std]:" << "settings ok." << std::endl;

		ImportProcess = new TQProcess ( this );


		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan || main->ImporttypeComboBox->currentItem() == pkcs12_openvpn || main->ImporttypeComboBox->currentItem() == pkcs12_racoon || main->ImporttypeComboBox->currentItem() == ca_der )
		{
			ImportProcess->addArgument ( pathToOpenSSL );
		}
		if ( main->ImporttypeComboBox->currentItem() == cisco || main->ImporttypeComboBox->currentItem() == ciscoca || main->ImporttypeComboBox->currentItem() == ciscouserca )
		{
			ImportProcess->addArgument ( GlobalConfig->pathToCiscoCertMgr );
		}

		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan ||
		        main->ImporttypeComboBox->currentItem() == pkcs12_racoon ||
		        main->ImporttypeComboBox->currentItem() == pkcs12_openvpn
		   )
		{
			ImportProcess->addArgument ( "pkcs12" );
			ImportProcess->addArgument ( "-in" );
			ImportProcess->addArgument ( filename );
			ImportProcess->addArgument ( "-nodes" );
			ImportProcess->addArgument ( "-clcerts" );
			ImportProcess->addArgument ( "-out" );
		}
		else if ( main->ImporttypeComboBox->currentItem() == ca_der )
		{

			ImportProcess->addArgument ( "x509" );
			ImportProcess->addArgument ( "-in" );
			ImportProcess->addArgument ( filename );
			ImportProcess->addArgument ( "-out" );
			ImportProcess->addArgument ( certpath + "/ca_" + certName + ".pem" );
			ImportProcess->addArgument ( "-inform" );
			ImportProcess->addArgument ( "DER" );
		}
		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
		{
			ImportProcess->addArgument ( "/etc/ipsec.d/certs/mykeys_" + certName + ".pem" ); // warning: static
		}
		else if ( main->ImporttypeComboBox->currentItem() == pkcs12_racoon || main->ImporttypeComboBox->currentItem() == pkcs12_openvpn )
		{
			ImportProcess->addArgument ( certpath + "/mykeys_" + certName + ".pem" );
		}
		else if ( main->ImporttypeComboBox->currentItem() == cisco || main->ImporttypeComboBox->currentItem() == ciscoca || main->ImporttypeComboBox->currentItem() == ciscouserca )
		{
			if (main->ImporttypeComboBox->currentItem() == cisco)
				ImportProcess->addArgument ( "-U" );
			if (main->ImporttypeComboBox->currentItem() == ciscoca)
				ImportProcess->addArgument ( "-R" );
			if (main->ImporttypeComboBox->currentItem() == ciscouserca)
			{
				ImportProcess->addArgument ( "-U" );
				ImportProcess->addArgument ( "-R" );
			}
			ImportProcess->addArgument ( "-op" );
			ImportProcess->addArgument ( "import" );
			ImportProcess->addArgument ( "-f" );
			ImportProcess->addArgument ( filename );

		}


		connect ( ImportProcess, TQT_SIGNAL ( readyReadStdout() ), this, TQT_SLOT ( readFromStdout_import() ) );
		connect ( ImportProcess, TQT_SIGNAL ( readyReadStderr() ), this, TQT_SLOT ( readFromStderr_import() ) );
		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan ||
		        main->ImporttypeComboBox->currentItem() == pkcs12_racoon ||
		        main->ImporttypeComboBox->currentItem() == pkcs12_openvpn
		   )
		{
			connect ( ImportProcess, TQT_SIGNAL ( processExited () ), this, TQT_SLOT ( doCacert() ) );
		}
		if ( main->ImporttypeComboBox->currentItem() == ca_der )
		{
			connect ( ImportProcess, TQT_SIGNAL ( processExited () ), this, TQT_SLOT ( doCreateHash() ) );
		}

		if ( main->ImporttypeComboBox->currentItem() == cisco || main->ImporttypeComboBox->currentItem() == ciscoca)
		{
			connect ( ImportProcess, TQT_SIGNAL ( processExited () ), this, TQT_SLOT ( ciscoCertMgrExited() ) );
		}

		if ( !ImportProcess->start ( env ) )
		{
			if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan || main->ImporttypeComboBox->currentItem() == pkcs12_openvpn || main->ImporttypeComboBox->currentItem() == pkcs12_racoon || main->ImporttypeComboBox->currentItem() == ca_der )
				KMessageBox::sorry ( this, i18n ( "Unable to start process (%1)!" ).arg ( "openssl" ) );
			if ( main->ImporttypeComboBox->currentItem() == cisco  )
				KMessageBox::sorry ( this, i18n ( "Unable to start process (%1)!" ).arg ( "cisco_cert_mgr" ) );
			GlobalConfig->appPointer->restoreOverrideCursor();
			return;
		}
		else
		{
			doExit=true;

			TQString processname = "";

			if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan || main->ImporttypeComboBox->currentItem() == pkcs12_openvpn || main->ImporttypeComboBox->currentItem() == pkcs12_racoon || main->ImporttypeComboBox->currentItem() == ca_der )
			{
				processname="openssl";

				if ( GlobalConfig->KvpncDebugLevel >3 )
					GlobalConfig->appendLogEntry ( i18n ( "Certificate import: %1: send %2" ).arg("accept()").arg ( i18n ( " import password" ) ),GlobalConfig->debug );

				if ( main->ImportPasswordEdit->text().isEmpty() )
					ImportProcess->writeToStdin ( "\n" );
				else
					ImportProcess->writeToStdin ( main->ImportPasswordEdit->text() + "\n" );
		
			}
			if ( main->ImporttypeComboBox->currentItem() == cisco  )
				processname="cisco_cert_mgr";

			if ( GlobalConfig->KvpncDebugLevel > 3 )
				GlobalConfig->appendLogEntry ( i18n ( "Process (%1) started." ).arg (processname ),GlobalConfig->debug );

			if ( main->ImporttypeComboBox->currentItem() == cisco /*|| main->ImporttypeComboBox->currentItem() == ciscoca*/  )
			{
				ImportProcess->writeToStdin ( main->ImportPasswordEdit->text() +"\n");
				if (main->UsePrivateKeyPasswordCheckBox->isChecked() )
				{
					ImportProcess->writeToStdin ( TQString ( main->PrivateKeyPasswordEdit->password() ) + "\n" );
					ImportProcess->writeToStdin ( TQString ( main->PrivateKeyPasswordEdit->password() ) + "\n" );
				}
			}
		}
	}
}

void ImportCertificateDialog::canAccept()
{
	if ( importSuccess )
	{
		KMessageBox::information ( 0, i18n ( "Certificate was sucessfully imported." ), i18n ( "Import Successful" ) );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n ( "Certificate import: certificate was successfully imported." ),GlobalConfig->debug );
	}
	else
	{
		KMessageBox::sorry ( 0, i18n ( "Certificate import failed." ), i18n ( "Import Failed" ) );
		GlobalConfig->appendLogEntry ( i18n ( "Certificate import: certificate could not be imported." ),GlobalConfig->error );
		GlobalConfig->appPointer->restoreOverrideCursor();
		return;
	}

	if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
	{
		TQString bin="ipsec";
		ToolInfo *tool;
		//std::cout << "Tool (bin): " << bin << std::endl;
		if ( !GlobalConfig->ToolList->isEmpty() )
		{
			for ( tool = GlobalConfig->ToolList->first(); tool; tool = GlobalConfig->ToolList->next() )
			{
				if ( bin == tool->Name )
				{
					if ( tool->PathToExec.section ( '/',-1 ) != bin )
					{
						// program is NOT installed
						KMessageBox::information ( this, i18n ( "The required tool (%1) is not installed, please install it before you are connecting and restart kvpnc." ).arg ( bin ), i18n ( "Tool Missing" ) );
						GlobalConfig->appPointer->restoreOverrideCursor();
						return;
					}
					break;
				}
			}
		}
	}
	else if ( main->ImporttypeComboBox->currentItem() == pkcs12_racoon )
	{
		TQString bin="racoon";
		ToolInfo *tool;
		//std::cout << "Tool (bin): " << bin << std::endl;
		if ( !GlobalConfig->ToolList->isEmpty() )
		{
			for ( tool = GlobalConfig->ToolList->first(); tool; tool = GlobalConfig->ToolList->next() )
			{
				if ( bin == tool->Name )
				{
					if ( tool->PathToExec.section ( '/',-1 ) != bin )
					{
						// program is NOT installed
						KMessageBox::information ( this, i18n ( "The required tool (%1) is not installed, please install it before you are connecting and restart kvpnc." ).arg ( bin ), i18n ( "Tool Missing" ) );
						GlobalConfig->appPointer->restoreOverrideCursor();
						return;
					}
					break;
				}
			}
		}
	}
	else if ( main->ImporttypeComboBox->currentItem() == pkcs12_openvpn )
	{
		TQString bin="openvpn";
		ToolInfo *tool;
		//std::cout << "Tool (bin): " << bin << std::endl;
		if ( !GlobalConfig->ToolList->isEmpty() )
		{
			for ( tool = GlobalConfig->ToolList->first(); tool; tool = GlobalConfig->ToolList->next() )
			{
				if ( bin == tool->Name )
				{
					if ( tool->PathToExec.section ( '/',-1 ) != bin )
					{
						// program is NOT installed
						KMessageBox::information ( this, i18n ( "The required tool (%1) is not installed, please install it before you are connecting and restart kvpnc." ).arg ( bin ), i18n ( "Tool Missing" ) );
						GlobalConfig->appPointer->restoreOverrideCursor();
						return;
					}
					break;
				}
			}
		}
	}
	else if ( main->ImporttypeComboBox->currentItem() == cisco || main->ImporttypeComboBox->currentItem() == ciscoca || main->ImporttypeComboBox->currentItem() == ciscouserca )
	{
		TQString bin="cisco_cert_mgr";
		ToolInfo *tool;
		//std::cout << "Tool (bin): " << bin << std::endl;
		if ( !GlobalConfig->ToolList->isEmpty() )
		{
			for ( tool = GlobalConfig->ToolList->first(); tool; tool = GlobalConfig->ToolList->next() )
			{
				if ( bin == tool->Name )
				{
					if ( tool->PathToExec.section ( '/',-1 ) != bin )
					{
						// program is NOT installed
						KMessageBox::information ( this, i18n ( "The required tool (%1) is not installed, please install it before you are connecting and restart kvpnc." ).arg ( bin ), i18n ( "Tool Missing" ) );
						GlobalConfig->appPointer->restoreOverrideCursor();
						return;
					}
					break;
				}
			}
		}
	}
	GlobalConfig->appPointer->restoreOverrideCursor();

	if ( doExit )
		TQDialog::accept();
}

void ImportCertificateDialog::reject()
{
	importOk=false;
	importSuccess=false;
	TQDialog::reject();
}

void ImportCertificateDialog::doCacert()
{
	disconnect ( ImportProcess, TQT_SIGNAL ( processExited () ), this, TQT_SLOT ( doCacert() ) );
	if ( GlobalConfig->KvpncDebugLevel > 3 )
		GlobalConfig->appendLogEntry ( i18n ( "Certificate import: %1" ).arg("doCacert()"),GlobalConfig->debug );

	if ( ImportProcess->normalExit () )
	{
		
		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
		{
			Utils ( GlobalConfig,this ).doChmod ( "/etc/ipsec.d/certs/mykeys_" + certName + ".pem","go-rwx" );
		}
		else if ( main->ImporttypeComboBox->currentItem() == pkcs12_racoon || main->ImporttypeComboBox->currentItem() == pkcs12_openvpn )
		{
			Utils ( GlobalConfig,this ).doChmod ( certpath + "/mykeys_" + certName + ".pem","go-rwx" );
		}

		/*
		openssl pkcs12 -in cert.p12 -nokeys -cacerts -out /etc/racoon/certs/ca_company.pem -nodes
		*/
		ImportProcess->clearArguments();
		ImportProcess->addArgument ( pathToOpenSSL );
		ImportProcess->addArgument ( "pkcs12" );
		ImportProcess->addArgument ( "-in" );
		ImportProcess->addArgument ( filename );
		ImportProcess->addArgument ( "-nokeys" );
		ImportProcess->addArgument ( "-cacerts" );
		ImportProcess->addArgument ( "-out" );

		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
		{
			ImportProcess->addArgument ( "/etc/ipsec.d/cacerts/ca_" + certName + ".pem" ); // warning: static
			CaCertFullPath="/etc/ipsec.d/cacerts/ca_" + certName + ".pem";
		}
		else
		{
			ImportProcess->addArgument ( certpath + "/ca_" + certName + ".pem" );
			CaCertFullPath=certpath + "/ca_" + certName + ".pem";
		}

		ImportProcess->addArgument ( "-nodes" );

		connect ( ImportProcess, TQT_SIGNAL ( processExited () ), this, TQT_SLOT ( doCreateHash() ) );

		if ( ! ImportProcess->start ( env ) )
		{
			KMessageBox::error ( this, i18n ( "Unable to extract CA certificate!" ), i18n ( "Extract Failed" ) );
			GlobalConfig->appendLogEntry ( i18n ( "Certificate import: CA certificate could not be extracted." ),GlobalConfig->error );
			importSuccess=false;
			GlobalConfig->appPointer->restoreOverrideCursor();
			return;
		}
		else
		{

			if ( GlobalConfig->KvpncDebugLevel > 3 )
				GlobalConfig->appendLogEntry ( i18n ( "Certificate import: %1: send %2" ).arg("doCacert()").arg ( i18n ( " import password" ) ),GlobalConfig->debug );

			if ( main->ImportPasswordEdit->text().isEmpty() )
				ImportProcess->writeToStdin ( "\n" );
			else
				ImportProcess->writeToStdin ( main->ImportPasswordEdit->text() + "\n" );

			doExit=true;
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Certificate import: CA certificate successful extracted." ),GlobalConfig->debug );
		}
	}
	else
	{
		importSuccess=false;
		GlobalConfig->appendLogEntry ( i18n ( "Certificate import: import process from accept() failed." ),GlobalConfig->error );
	}
}

void ImportCertificateDialog::doPrivateKey()
{

	if ( GlobalConfig->KvpncDebugLevel > 3 )
		GlobalConfig->appendLogEntry ( "[dbg]: doPrivateKey()",GlobalConfig->debug );
	disconnect ( ImportProcess, TQT_SIGNAL ( processExited () ), this, TQT_SLOT ( doPrivateKey() ) );

	if ( ImportProcess->normalExit () )
	{

		/*
		openssl pkcs12 -in cert.p12 -nocerts -out /etc/racoon/certs/ca_company.pem
		*/
		ImportProcess->clearArguments();
		ImportProcess->addArgument ( pathToOpenSSL );
		ImportProcess->addArgument ( "pkcs12" );
		ImportProcess->addArgument ( "-nocerts" );
		ImportProcess->addArgument ( "-in" );
		ImportProcess->addArgument ( filename );
		ImportProcess->addArgument ( "-out" );


		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
			ImportProcess->addArgument ( certpath+"/private/" + certName + ".pem" ); // warning: static
		else if ( main->ImporttypeComboBox->currentItem() == pkcs12_openvpn )
			ImportProcess->addArgument ( certpath+"/" + certName + ".pem" ); // warning: static

		if ( !certpath.isEmpty() )
			if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
				CertFullPath=certpath+"/private/" + certName + ".pem";
		if ( main->ImporttypeComboBox->currentItem() == pkcs12_openvpn )
			CertFullPath=certpath+"/" + certName + ".pem";

		if ( main->UsePrivateKeyPasswordCheckBox->isChecked() )
			connect ( ImportProcess, TQT_SIGNAL ( processExited () ), this, TQT_SLOT ( exit() ) );
		else
			connect ( ImportProcess, TQT_SIGNAL ( processExited () ), this, TQT_SLOT ( removePrivateKey() ) );

		//LogOutput->append( "priv key: we starting..." );
		if ( !ImportProcess->start( ) )
		{
			KMessageBox::sorry ( this, i18n ( "Unable to start process (private key)!" ) );

			GlobalConfig->appendLogEntry ( i18n ( "Certificate import: private key could not extracted." ),GlobalConfig->error );
			importSuccess=false;
			GlobalConfig->appPointer->restoreOverrideCursor();
			return;
		}
		else
		{

			if ( GlobalConfig->KvpncDebugLevel > 3 )
				GlobalConfig->appendLogEntry ( i18n ( "Certificate import: %1: send %2" ).arg("doPrivateKey()").arg ( i18n ( " import password" ) ),GlobalConfig->debug );

// 			if ( main->ImportPasswordEdit->text().isEmpty() )
// 				ImportProcess->writeToStdin ( "\n" );
// 			else
				ImportProcess->writeToStdin ( main->ImportPasswordEdit->text() + "\n" );


				if ( main->UsePrivateKeyPasswordCheckBox->isChecked() )
				{
					if ( GlobalConfig->KvpncDebugLevel > 3 )
						GlobalConfig->appendLogEntry ( i18n ( "Certificate import: %1: send %2..." ).arg("doPrivateKey").arg ( i18n ( " private key password" ) ),GlobalConfig->debug );

					ImportProcess->writeToStdin ( main->PrivateKeyPasswordEdit->text() + "\n" );
				}
				else
				{
					if ( GlobalConfig->KvpncDebugLevel > 3 )
						GlobalConfig->appendLogEntry ( i18n ( "Certificate import: %1: send %2..." ).arg("doPrivateKey").arg ( i18n ( " private key password dummy" ) ),GlobalConfig->debug );

					// we need 4 chars here
					ImportProcess->writeToStdin ( "abcd\n" );

				}

				if ( main->UsePrivateKeyPasswordCheckBox->isChecked() )
				{
					if ( GlobalConfig->KvpncDebugLevel > 3 )
						GlobalConfig->appendLogEntry ( i18n ( "Certificate import: %1: send %2..." ).arg("doPrivateKey").arg ( i18n ( " private key password" ) ),GlobalConfig->debug );

					ImportProcess->writeToStdin ( main->PrivateKeyPasswordEdit->text() + "\n" );
				}
				else
				{
					if ( GlobalConfig->KvpncDebugLevel > 3 )
						GlobalConfig->appendLogEntry ( i18n ( "Certificate import: %1: send %2..." ).arg("doPrivateKey").arg ( i18n ( " private key password dummy" ) ),GlobalConfig->debug );

					// we need 4 chars here
					ImportProcess->writeToStdin ( "abcd\n" );

				}

		}

	}
	else
	{
		importSuccess=false;
		GlobalConfig->appendLogEntry ( i18n ( "Certificate import: import process from doLink() failed." ),GlobalConfig->error );
		GlobalConfig->appPointer->restoreOverrideCursor();
		return;
	}
}

void ImportCertificateDialog::doCreateHash()
{

	disconnect ( ImportProcess, TQT_SIGNAL ( processExited () ), this, TQT_SLOT ( doCreateHash() ) );

	if ( GlobalConfig->KvpncDebugLevel > 3 )
		GlobalConfig->appendLogEntry ( i18n ( "Certificate import: %1" ).arg("doCreateHash()"),GlobalConfig->debug );

	if ( ImportProcess->normalExit () )
	{

		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
			Utils ( GlobalConfig,this ).doChmod ( certpath+"/cacerts/ca_" + certName + ".pem","go-rwx" );
		else
			Utils ( GlobalConfig,this ).doChmod ( certpath + "/ca_" + certName + ".pem","go-rwx" );

		/*
		openssl x509 -noout -hash < /etc/racoon/certs/ca_company.pem
		*/
		ImportProcess->clearArguments();
		ImportProcess->addArgument ( pathToOpenSSL );
		ImportProcess->addArgument ( "x509" );
		ImportProcess->addArgument ( "-noout" );
		ImportProcess->addArgument ( "-hash" );
		ImportProcess->addArgument ( "-in" );
		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
			ImportProcess->addArgument ( certpath+"/cacerts/ca_" + certName + ".pem" ); // warning: static
		else
			ImportProcess->addArgument ( certpath + "/ca_" + certName + ".pem" );

		connect ( ImportProcess, TQT_SIGNAL ( processExited () ), this, TQT_SLOT ( doLink() ) );


		//		LogOutput->append( "hash: we starting..." );
		if ( !ImportProcess->start( ) )
		{
			KMessageBox::sorry ( this, i18n ( "Unable to start process (%1)!" ).arg ( "hash" ) );
			GlobalConfig->appendLogEntry ( i18n ( "Certificate import: hash could not created." ),GlobalConfig->error );
			importSuccess=false;
			GlobalConfig->appPointer->restoreOverrideCursor();
			return;
		}
		else
		{

			if ( GlobalConfig->KvpncDebugLevel > 3 )
				GlobalConfig->appendLogEntry ( i18n ( "Certificate import: %1: send %2" ).arg("doCreateHash()").arg ( i18n ( " import password" ) ),GlobalConfig->debug );

			if ( main->ImportPasswordEdit->text().isEmpty() )
				ImportProcess->writeToStdin ( "\n" );
			else
				ImportProcess->writeToStdin ( main->ImportPasswordEdit->text() + "\n" );
			while (ImportProcess->isRunning())
			{
				sleep (1);
			}

			doExit=true;
			doHash = true;
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Certificate import: hash successful created." ),GlobalConfig->debug );
		}
	}
	else
	{
		importSuccess=false;
		GlobalConfig->appendLogEntry ( i18n ( "Certificate import: import process from doCert() failed." ),GlobalConfig->error );
	}
}

void ImportCertificateDialog::doLink()
{
	disconnect ( ImportProcess, TQT_SIGNAL ( processExited () ), this, TQT_SLOT ( doLink() ) );
	if ( GlobalConfig->KvpncDebugLevel > 3 )
		GlobalConfig->appendLogEntry ( i18n ( "Certificate import: %1" ).arg("doLink()"),GlobalConfig->debug );

	if ( ImportProcess->normalExit () )
	{

		doHash = false;
		ImportProcess->clearArguments();
		/*
		ln -s /etc/racoon/certs/ca_company.pem /etc/racoon/certs/<hash>.0
		*/
		ImportProcess->addArgument ( "ln" );
		ImportProcess->addArgument ( "-sf" );
		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
		{
			ImportProcess->addArgument ( certpath+"/cacerts/ca_" + certName + ".pem" );
			ImportProcess->addArgument ( certpath+"/cacerts/" + certHash + ".0" );
		}
		else
		{
			ImportProcess->addArgument ( certpath + "/ca_" + certName + ".pem" );
			ImportProcess->addArgument ( certpath +"/"+ certHash + ".0" );
		}

		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan ||
		        main->ImporttypeComboBox->currentItem() == pkcs12_openvpn )
			connect ( ImportProcess, TQT_SIGNAL ( processExited () ), this, TQT_SLOT ( doPrivateKey() ) );
		else
			connect ( ImportProcess, TQT_SIGNAL ( processExited () ), this, TQT_SLOT ( exit() ) );


		if ( !ImportProcess->start( ) )
		{
			KMessageBox::sorry ( this, i18n ( "Unable to start process (%1)!" ).arg ( "ln -s" ) );
			GlobalConfig->appendLogEntry ( i18n ( "Certificate import: Link could not created." ),GlobalConfig->error );
			importSuccess=false;
			GlobalConfig->appPointer->restoreOverrideCursor();
			return;
		}
		else
		{
			while (ImportProcess->isRunning())
			{
				usleep (500);
			}

			delete ImportProcess;
			GlobalConfig->appPointer->restoreOverrideCursor();
			if ( GlobalConfig->KvpncDebugLevel > 3 )
				GlobalConfig->appendLogEntry ( i18n ( "Certificate import: Link creation sucessful." ),GlobalConfig->error );
			ImportProcess =0L;
			exit();
		}
	}
	else
	{
		importSuccess=false;
		GlobalConfig->appendLogEntry ( i18n ( "Certificate import: Skipping link creation." ),GlobalConfig->error );
	}
}

void ImportCertificateDialog::exit()
{
	if ( GlobalConfig->KvpncDebugLevel > 0 )
		GlobalConfig->appendLogEntry ( i18n ( "Certificate import: %1" ).arg("exit()"),GlobalConfig->debug );

	
	if ( (ImportProcess != 0L && ImportProcess->normalExit() ) || ImportProcess == 0L )
	{
		doExit=true;
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n ( "Certificate import: Link successful created." ),GlobalConfig->debug );

		// 	if ( ImportProcess->normalExit() )
		// 		importOk=true;
		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
			Utils ( GlobalConfig,this ).doChmod ( certpath+"/private/" + certName + ".pem","go-rwx" );

		if ( main->ImporttypeComboBox->currentItem() == pkcs12_openvpn )
			Utils ( GlobalConfig,this ).doChmod ( certpath+"/" + certName + ".pem","go-rwx" );
		done=true;
		canAccept();
	}
	else
	{
		GlobalConfig->appPointer->restoreOverrideCursor();
		importSuccess=false;
		GlobalConfig->appendLogEntry ( i18n ( "Certificate import: import process from doPrivateKey() failed." ),GlobalConfig->error );
	}
}

void ImportCertificateDialog::readFromStdout_import()
{

// 	TQString line = TQString( ImportProcess->readStdout() );
	while ( ImportProcess->canReadLineStdout() )
	{
		TQString line = TQString ( ImportProcess->readLineStdout() );

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n ( "Certificate import stdout: %1" ).arg ( line ),GlobalConfig->debug );
		if ( doHash )
		{
			certHash = line.left ( line.length() - 1 );
			doHash = false;
			//		LogOutput->append( "<font color=\"red\">[std]: hash" + line + "</font>" );
		}

		if ( line.find ( "Enter Import Password" , 0, FALSE ) > -1 )
		{
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n ( "Certificate import: %1 was requested, send it..." ).arg ( i18n ( " import password" ) ),GlobalConfig->debug );

			if ( main->ImportPasswordEdit->text().isEmpty() )
				ImportProcess->writeToStdin ( "\n" );
			else
				ImportProcess->writeToStdin ( main->ImportPasswordEdit->text() + "\n" );
		}

		else if ( line.find ( "Enter PEM pass phrase" , 0, FALSE ) > -1 )
		{

			if ( askpasscount < 10 )
			{

				if ( main->UsePrivateKeyPasswordCheckBox->isChecked() )
				{
					if ( GlobalConfig->KvpncDebugLevel > 3 )
						GlobalConfig->appendLogEntry ( i18n ( "Certificate import: %1: send %2..." ).arg("doPrivateKey").arg ( i18n ( " private key password" ) ),GlobalConfig->debug );

					ImportProcess->writeToStdin ( main->PrivateKeyPasswordEdit->text() + "\n" );
				}
				else
				{
					if ( GlobalConfig->KvpncDebugLevel > 3 )
						GlobalConfig->appendLogEntry ( i18n ( "Certificate import: %1: send %2..." ).arg("doPrivateKey").arg ( i18n ( " private key password dummy" ) ),GlobalConfig->debug );

					// we need 4 chars here
					ImportProcess->writeToStdin ( "abcd\n" );

				}
				askpasscount+=1;
			}
			else
			{
				// whats happen???
				// 			doExit=true;
			}
		}


		if ( main->ImporttypeComboBox->currentItem() == cisco  )
		{

			if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry ("[cisco_cert_mgr raw] "+line,GlobalConfig->debug);

			if ( line.find ( "Password:" , 0, FALSE ) > -1 ||  line.find ( "Confirm Password:" , 0, FALSE ) > -1 )
			{
				if ( GlobalConfig->KvpncDebugLevel > 0 )
					GlobalConfig->appendLogEntry ( i18n ( "Certificate import: %1 was requested, send it..." ).arg ( i18n ( "certificate password" ) ),GlobalConfig->debug );
				ImportProcess->writeToStdin ( TQString ( main->PrivateKeyPasswordEdit->password() ) + "\n" );

			}
			if ( line.find ( "Success: certificate imported from path:", 0, FALSE ) > -1 )
			{
				
				GlobalConfig->appendLogEntry ( i18n ( "Certificate import was successful." ) ,GlobalConfig->info );
				importOk=true;
				importSuccess=true;
				doExit=true;
				done=true;
			}
		
		}
	}
}

void ImportCertificateDialog::readFromStderr_import()
{
// 	TQString line = TQString ( ImportProcess->readStderr() );
	while ( ImportProcess->canReadLineStderr() )
	{
		TQString line = TQString ( ImportProcess->readLineStderr() );
		if ( GlobalConfig->KvpncDebugLevel > 3 )
		{
			if ( line.find ( "Enter Import Pass", 0, FALSE ) > -1 || line.find ( "Enter PEM pass phrase", 0, FALSE ) > -1 || line.find ( "MAC verified OK", 0, FALSE ) > -1  || line.find ( "Enter pass phrase for", 0, FALSE ) > -1 || line.find ( "writing RSA key", 0, FALSE ) > -1 )
			{
				GlobalConfig->appendLogEntry ( i18n ( "Certificate import: %1" ).arg ( line ),GlobalConfig->info );
			}
			else
			{
				GlobalConfig->appendLogEntry ( i18n ( "Certificate import stderr: %1" ).arg ( line ),GlobalConfig->error );
			}
		}
		if ( line.find ( "Error",9, FALSE ) > -1 )
		{
			GlobalConfig->appendLogEntry ( i18n ( "Certificate import: %1" ).arg ( line ),GlobalConfig->error );
			importSuccess=false;
			importOk = false;
			doExit=false;
// 			error_found=true;
		}

		else if ( line.find ( "invalid password" , 0, FALSE ) > -1  || line.find ( "Mac verify error: invalid password?", 0, FALSE ) > -1 )
		{
			if (error_found==false)
				KMessageBox::sorry ( this , i18n ( "Wrong password." ), i18n ( "Password Failed" ) );
			GlobalConfig->appendLogEntry ( i18n ( "Certificate import: password was invalid" ),GlobalConfig->error );
			importSuccess=false;
			importOk = false;
			doExit=false;
			error_found=true;
			GlobalConfig->appPointer->restoreOverrideCursor();
		}

		else if ( line.find ( "unable to load certificate", 0, FALSE ) > -1 )
		{
			if (error_found==false)
				KMessageBox::error ( this, i18n ( "Unable to load certificate!" ), i18n ( "Load Failed" ) );
			GlobalConfig->appendLogEntry ( i18n ( "Unable to load certificate!" ) ,GlobalConfig->error );
			importOk=false;
			importSuccess=false;
			doExit=false;
			error_found=true;
// 			if ( ImportProcess != 0L && ImportProcess->isRunning() )
// 			{
// 				disconnect ( ImportProcess, TQT_SIGNAL ( readyReadStdout() ), this, TQT_SLOT ( readFromStdout_import() ) );
// 				disconnect ( ImportProcess, TQT_SIGNAL ( readyReadStderr() ), this, TQT_SLOT ( readFromStderr_import() ) );
// 				ImportProcess->kill();
// 				ImportProcess = 0L;
// 			}
			GlobalConfig->appPointer->restoreOverrideCursor();
			done=true;
			return;
		}
		else if ( line.find ( "unable to load Private Key", 0, FALSE ) > -1 )
		{
			if (error_found==false)
				KMessageBox::error ( this, i18n ( "unable to load Private Key!" ), i18n ( "Load Failed" ) );
			GlobalConfig->appendLogEntry ( i18n ( "unable to load Private Key!" ) ,GlobalConfig->error );
			importOk=false;
			importSuccess=false;
			doExit=false;
			error_found=true;
			GlobalConfig->appPointer->restoreOverrideCursor();
			if ( ImportProcess->isRunning() )
			{
				ImportProcess->kill();
			}
			done=true;
		}

		else if ( line.find ( "Error opening output file", 0, FALSE ) > -1 )
		{
			if (error_found==false)
				KMessageBox::error ( this, i18n ( "Error opening output file." ), i18n ( "File open failed" ) );
			GlobalConfig->appendLogEntry ( i18n ( "Error opening output file!" ) ,GlobalConfig->error );
			importOk=false;
			importSuccess=false;
			doExit=true;
			error_found=true;
			GlobalConfig->appPointer->restoreOverrideCursor();
			done=true;
		}
		else if ( line.find ( "Verify failure", 0, FALSE ) > -1 )
		{
			if (error_found==false)
				KMessageBox::error ( this, i18n ( "Verify failure at private key password." ), i18n ( "Verify failure" ) );
			GlobalConfig->appendLogEntry ( i18n ( "Verify failure at private key password." ) ,GlobalConfig->error );
			importOk=false;
			importSuccess=false;
			doExit=true;
			error_found=true;
			GlobalConfig->appPointer->restoreOverrideCursor();
			done=true;
		}

		else if ( line.find ( "MAC verified OK", 0, FALSE ) > -1 )
		{
			GlobalConfig->appendLogEntry ( i18n ( "Import password was ok." ) ,GlobalConfig->debug );
			importSuccess=true;
		}

		else if ( main->ImporttypeComboBox->currentItem() == cisco  )
		{

			if ( GlobalConfig->KvpncDebugLevel > 2 )
				GlobalConfig->appendLogEntry ("[cisco_cert_mgr raw err] "+line,GlobalConfig->debug);

			if ( line.find ( "error: unable to import certificate from path:", 0, FALSE ) > -1 )
			{
				if (error_found==false)
					KMessageBox::error ( this, i18n ( "Unable to load certificate!" ), i18n ( "Load Failed" ) );
				GlobalConfig->appendLogEntry ( i18n ( "Unable to load certificate!" ) ,GlobalConfig->error );
				importOk=false;
				importSuccess=false;
				doExit=false;
				error_found=true;
				GlobalConfig->appPointer->restoreOverrideCursor();
				if ( ImportProcess->isRunning() )
				{
					ImportProcess->kill();
				}
				done=true;
			}

			else if ( line.find ( "Success: certificate imported from path:", 0, FALSE ) > -1 )
			{
				GlobalConfig->appendLogEntry ( i18n ( "Certificate imported from path." ) ,GlobalConfig->error );
				importOk=true;
				importSuccess=true;
				doExit=false;
				done=true;
			}
		}
	}
}

void ImportCertificateDialog::typeToggeled ( int type )
{
	if ( GlobalConfig->KvpncDebugLevel > 0 )
		GlobalConfig->appendLogEntry ( TQString ( "type: "+TQString().setNum ( type ) ),GlobalConfig->debug );
	if ( type == pkcs12_freeswan )
	{
		certpath = "/etc/ipsec.d/certs";
// 		main->PrivateKeyPasswordEdit->setEnabled ( true );
// 		main->PrivateKeyAgainPasswordEdit->setEnabled ( true );
		main->RacoonCertificatePathUrlrequester->setEnabled ( false );
		main->ImportPasswordEdit->setEnabled ( true );
		main->P12GroupBox->setEnabled ( true );
// 		main->PrivateKeyPassGroupBox->setEnabled ( true );
		main->FilenameUrlrequester->setFilter ( "*.p12" );
	}
	else if ( type == pkcs12_racoon )
	{
		certpath = "/etc/racoon/certs/";
// 		main->PrivateKeyPasswordEdit->setEnabled ( false );
// 		main->PrivateKeyAgainPasswordEdit->setEnabled ( false );
		main->RacoonCertificatePathUrlrequester->setEnabled ( true );
		main->ImportPasswordEdit->setEnabled ( true );
		main->P12GroupBox->setEnabled ( true );
// 		main->PrivateKeyPassGroupBox->setEnabled ( false );
		main->FilenameUrlrequester->setFilter ( "*.p12" );
	}
	else if ( type == ca_der )
	{
		certpath = "/etc/certs/";
// 		main->PrivateKeyPasswordEdit->setEnabled ( false );
// 		main->PrivateKeyAgainPasswordEdit->setEnabled ( false );
		main->RacoonCertificatePathUrlrequester->setEnabled ( true );
		main->ImportPasswordEdit->setEnabled ( false );
		main->P12GroupBox->setEnabled ( false );
// 		main->PrivateKeyPassGroupBox->setEnabled ( false );
		main->FilenameUrlrequester->setFilter ( "*.der *.crt" );
	}
	else if ( type == pkcs12_openvpn )
	{
		certpath = "/etc/openvpn";
		main->PrivateKeyPasswordEdit->setEnabled ( true );
		main->PrivateKeyAgainPasswordEdit->setEnabled ( true );
		main->RacoonCertificatePathUrlrequester->setEnabled ( true );
		main->RacoonCertificatePathUrlrequester->setURL( certpath );
		main->ImportPasswordEdit->setEnabled ( true );
		main->P12GroupBox->setEnabled ( true );
		main->PrivateKeyPassGroupBox->setEnabled ( true );
		main->FilenameUrlrequester->setFilter ( "*.p12" );
	}
	else if ( type == cisco )
	{
		main->P12GroupBox->setTitle ( i18n ( "Import" ) );
		main->CertPathTextLabel->hide();
		main->RacoonCertificatePathUrlrequester->hide();
		main->PrivateKeyPassGroupBox->setTitle ( i18n ( "Certificate protection" ) );
		main->PrivateKeyPassTextLabel->setText(i18n ("Certificate password:"));
		main->PrivateKeyPassAgainTextLabel->setText(i18n ("Certificate password again:"));
		main->FilenameUrlrequester->setFilter ( "*" );
	}

	else
	{
		main->P12GroupBox->setTitle ( i18n ( "P12" ) );
		main->CertPathTextLabel->hide();
		main->RacoonCertificatePathUrlrequester->hide();
		main->PrivateKeyPassGroupBox->setTitle ( i18n ( "FreeS/WAN (Openswan)" ) );
		main->PrivateKeyPassTextLabel->setText(i18n ("Private key passphrase:"));
		main->PrivateKeyPassAgainTextLabel->setText(i18n ("Passphrase again:"));
		main->FilenameUrlrequester->setFilter ( "*" );
	}

	main->RacoonCertificatePathUrlrequester->setURL ( certpath );
}

void ImportCertificateDialog::ciscoCertMgrExited()
{
	doExit=true;
	importOk=true;
	importSuccess=true;
	done=true;
	if ( GlobalConfig->KvpncDebugLevel > 0 )
		GlobalConfig->appendLogEntry ( i18n ( "Certificate import: certificate successful imported." ),GlobalConfig->debug );
	canAccept();
}

void ImportCertificateDialog::usePrivateKeyPassToggled(bool)
{
	if (main->UsePrivateKeyPasswordCheckBox->isChecked())
	{
		main->PrivateKeyPassGroupBox->setEnabled(true);
	}
	else
	{
		main->PrivateKeyPassGroupBox->setEnabled(false);
	}
}

void ImportCertificateDialog::removePrivateKey()
{
	disconnect ( ImportProcess, TQT_SIGNAL ( processExited () ), this, TQT_SLOT ( removePrivateKey() ) );
	if ( GlobalConfig->KvpncDebugLevel > 3 )
		GlobalConfig->appendLogEntry ( i18n ( "Certificate import: %1" ).arg("removePrivateKey()"),GlobalConfig->debug );

	if ( ImportProcess->normalExit () )
	{
		ImportProcess->clearArguments();
		ImportProcess->addArgument ( pathToOpenSSL );
		ImportProcess->addArgument ( "rsa" );
		ImportProcess->addArgument ( "-in" );

		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
			ImportProcess->addArgument ( certpath+"/private/" + certName + ".pem" ); // warning: static
		else if ( main->ImporttypeComboBox->currentItem() == pkcs12_openvpn )
			ImportProcess->addArgument ( certpath+"/" + certName + ".pem" ); // warning: static

		ImportProcess->addArgument ( "-out" );

		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
			ImportProcess->addArgument ( certpath+"/private/" + certName + ".pem" ); // warning: static
		else if ( main->ImporttypeComboBox->currentItem() == pkcs12_openvpn )
			ImportProcess->addArgument ( certpath+"/" + certName + ".pem" ); // warning: static

		connect ( ImportProcess, TQT_SIGNAL ( processExited () ), this, TQT_SLOT ( exit() ) );


		if ( !ImportProcess->start( ) )
		{
			KMessageBox::sorry ( this, i18n ( "Unable to start process (%1)!" ).arg ( "ln -s" ) );
			GlobalConfig->appendLogEntry ( i18n ( "Certificate import: passphrase could not removed." ),GlobalConfig->error );
			importSuccess=false;
			GlobalConfig->appPointer->restoreOverrideCursor();
			return;
		}
		else
		{

				if ( GlobalConfig->KvpncDebugLevel > 3 )
					GlobalConfig->appendLogEntry ( i18n ( "Certificate import: %1: send %2..." ).arg("removePrivateKey()").arg ( i18n ( " private key password dummy" ) ),GlobalConfig->debug );

				// we need 4 chars here
				ImportProcess->writeToStdin ( "abcd\n" );
		}
	}
	else
	{
		importSuccess=false;
	}
}
