/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

//BEGIN INCLUDES
#include <tdelocale.h>

#include "configdaemonoptions.h"

#include <tqvariant.h>
#include <tqpushbutton.h>
#include <tqcheckbox.h>
#include <tqgroupbox.h>
#include <tqspinbox.h>
#include <tqlabel.h>
#include <kurlrequester.h>
#include <kcombobox.h>
#include <tqlayout.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>

#include <iostream>

#include "widgetnotifyhelper.h"

#include <tqobjectlist.h>
//END INCLUDES


/*
 *  Constructs a ConfigDaemonOptions as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 */
ConfigDaemonOptions::ConfigDaemonOptions( TQWidget* parent) : ConfigDaemonOptionsBase( parent)
{
	WidgetNotifyHelper h;
	h.setupChangedAction(this);
	dialogModified=false;
}

ConfigDaemonOptions::~ConfigDaemonOptions()
{
}


void ConfigDaemonOptions::programsInPathToggled( bool )
{
	if ( ProgramsInPathcheckBox->isChecked() )
	{
		//spinVpncDebugLevel->setEnabled( false );
		VpncPathInput->setEnabled( false );
		FreeswanPathInput->setEnabled( false );
		//spinRacoonDebugLevel->setEnabled( false );
		RacoonPathInput->setEnabled( false );
		OpenvpnPathInput->setEnabled( false );
// 		ConfigHelperProgramOptionsWidget->OpenSSLPathInput->setEnabled( false );
// 		ConfigHelperProgramOptionsWidget->IptablesPathInput->setEnabled( false );
		PppdPathInput->setEnabled( false );
	}
	else
	{
		//spinVpncDebugLevel->setEnabled( true );
		VpncPathInput->setEnabled( true );
		FreeswanPathInput->setEnabled( true );
		//spinRacoonDebugLevel->setEnabled( true );
		RacoonPathInput->setEnabled( true );
		OpenvpnPathInput->setEnabled( true );
// 		ConfigHelperProgramOptionsWidget->OpenSSLPathInput->setEnabled( true );
// 		ConfigHelperProgramOptionsWidget->IptablesPathInput->setEnabled( true );
		PppdPathInput->setEnabled( true );
	}
}


void ConfigDaemonOptions::dialogChanged()
{
// 	std::cout << "ConfigDaemonOptions::dialogChanged()" << std::endl;
	dialogModified=true;
}
