/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "widgetnotifyhelper.h"
#include <tqobjectlist.h>

#include <iostream>


WidgetNotifyHelper::WidgetNotifyHelper(TQObject *parent, const char *name)
 : TQObject(parent, name)
{
}


WidgetNotifyHelper::~WidgetNotifyHelper()
{
}

void WidgetNotifyHelper::setupChangedAction(TQWidget *w)
{
	// connect changed signals to own signal
	TQObject *obj;
	TQObjectList *list;

	list = w->queryList( TQCOMBOBOX_OBJECT_NAME_STRING );
	for ( obj = list->first(); obj; obj = list->next() )
	{
// 		std::cout << "obj found: " << obj->name() << std::endl;
		connect(obj,TQT_SIGNAL(textChanged ( const TQString & )),w,TQT_SIGNAL(changed()));
	}

	list = w->queryList( "KLineEdit" );
	for ( obj = list->first(); obj; obj = list->next() )
	{
// 		std::cout << "obj found: " << obj->name() << std::endl;
		connect(obj,TQT_SIGNAL(textChanged ( const TQString & )),w,TQT_SIGNAL(changed()));
	}

	list = w->queryList( TQLINEEDIT_OBJECT_NAME_STRING );
	for ( obj = list->first(); obj; obj = list->next() )
	{
// 		std::cout << "obj found: " << obj->name() << std::endl;
		connect(obj,TQT_SIGNAL(textChanged (const TQString & )),w,TQT_SIGNAL(changed()));
	}

	list = w->queryList( "KUrlRquester" );
	for ( obj = list->first(); obj; obj = list->next() )
	{
// 		std::cout << "obj found: " << obj->name() << std::endl;
		connect(obj,TQT_SIGNAL(textChanged ( const TQString & )),w,TQT_SIGNAL(changed()));
	}

	list = w->queryList( TQSPINBOX_OBJECT_NAME_STRING );
	for ( obj = list->first(); obj; obj = list->next() )
	{
// 		std::cout << "obj found: " << obj->name() << std::endl;
		connect(obj,TQT_SIGNAL(valueChanged ( int )),w,TQT_SIGNAL(changed()));
	}

	list = w->queryList( TQCHECKBOX_OBJECT_NAME_STRING );
	for ( obj = list->first(); obj; obj = list->next() )
	{
// 		std::cout << "obj found: " << obj->name() << std::endl;
		connect(obj,TQT_SIGNAL(stateChanged ( int )),w,TQT_SIGNAL(changed()));
	}

	list = w->queryList( TQRADIOBUTTON_OBJECT_NAME_STRING );
	for ( obj = list->first(); obj; obj = list->next() )
	{
// 		std::cout << "obj found: " << obj->name() << std::endl;
		connect(obj,TQT_SIGNAL(stateChanged ( int )),w,TQT_SIGNAL(changed()));
	}

	// connect changed to slot
	connect(w,TQT_SIGNAL(changed ()),w,TQT_SLOT(dialogChanged()));
}
