/***************************************************************************
 *   Copyright (C) 2007 by Todor Gyumyushev   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "numpadvbutton.h"

NumpadVButton::NumpadVButton(TQWidget *parent, const char *name)
 : VButton(parent, name)
{

}


NumpadVButton::~NumpadVButton()
{
}

void NumpadVButton::numlockPressed(bool press)
{
	if (press==true){
		TQPushButton::setText(u);
		VButton::setKeyCode(numlock_code);
	}
	else{
		TQPushButton::setText(l);
		VButton::setKeyCode(cursor_code);
	}
}

void NumpadVButton::setKeyCode(unsigned int numpad_keycode, unsigned int cursor_keycode)
{
	cursor_code = cursor_keycode;
	numlock_code = numpad_keycode;
	VButton::setKeyCode(cursor_code);
}
