/***************************************************************************
 *   Copyright (C) 2007 by Todor Gyumyushev   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/



#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>
#include <kuniqueapplication.h>


#include "MainWidget.h"

#include <X11/Xlib.h>



static const char description[] =
    I18N_NOOP("A virtual keyboard for TDE");

static const char version[] = "0.4.8";

static TDECmdLineOptions options[] =
{
 { "loginhelper", I18N_NOOP("Stand alone version for use with TDM or XDM. \nYou should Add : HOME=/root kvkbd --loginhelper & to Xsetup to run in xdm/tdm"), 0 },
};


void findAloneWindow()
{
	unsigned int numkids, i,mapped,scrn;
	Window r, p;
	Window *kids=0;
	//XWindowAttributes attr;
	Window root;
	Display *dipsy=0;
	char *win_name=0;

	dipsy = XOpenDisplay(0);
	if (!dipsy)return;

	scrn = DefaultScreen(dipsy);
	root = RootWindow(dipsy, scrn);
	
	mapped = 0;
	XQueryTree(dipsy, root, &r, &p, &kids, &numkids);
		

	for (i = 0; i < numkids;  ++i)
	{
			XFetchName(dipsy, kids[i], &win_name);
			TQString c(win_name);
			
			if (c=="kvkbdalone")
 			{
 				long wid = kids[i];
				XDestroyWindow(dipsy,wid);
				XFlush(dipsy);
				i=numkids;
 			}
			XFree(win_name);
	} 
	XCloseDisplay(dipsy);
}

class Kvkbd : public KUniqueApplication
{

public:
	Kvkbd(): KUniqueApplication(true,true,true) {
	
	};
	

	int newInstance(){
		MainWidget *main = (MainWidget *)mainWidget();
		if (!main)
		{
			main = new MainWidget(const_cast<TDEAboutData *>(aboutData()),false, 0, "kvkbd");
			setMainWidget(main);
		}
		
		main->restorePosition(); 
		main->finishInit();
		return 0;
	};

	QCStringList functions () {
		QCStringList c;
		c << "show()";
		c << "hide()";
		c << "state()";
		return c;
	}
	bool process(const TQCString &fun, const TQByteArray &data,
			TQCString &replyType, TQByteArray &replyData) {
				
		
		TQDataStream io(replyData,IO_WriteOnly);
		replyType="TQCString";	
		MainWidget *main = (MainWidget *)mainWidget();
		if (main) {
			if (fun == "show()") {
				main->show();
				io<<"Success";
				return true;
			}
			else if (fun == "hide()") {
				main->hide();
				io<<"Success";
				return true;	
			} 
			else if (fun == "state()") {
				io << (main->isShown()?"visible":"hidden");
				return true;	
			} 
		}
		
		return KUniqueApplication::process(fun,data,replyType,replyData);
		
	};

	bool x11EventFilter ( XEvent *event ){
		MainWidget *main = (MainWidget *)mainWidget();
		if (main) {
			if (event->type==MappingNotify) {
				XMappingEvent *e = (XMappingEvent *)event;
				if (e->request== MappingKeyboard) {
					main->mappingNotify(e);
				}
			}
		}
		
		return false;
	};


};

class KvkbdApp : public TQApplication
{
public:
	KvkbdApp(int argc, char** argv, bool gui):TQApplication(argc,argv,gui){
		
	};

	bool x11EventFilter ( XEvent *event ) {	
		if (event->type == DestroyNotify) {
			TQApplication::exit();
		}
		else if (event->type == MappingNotify) {
			
				MainWidget *main = (MainWidget *)mainWidget();
				if (main) {
					XMappingEvent *e = (XMappingEvent *) event;
					if (e->request==MappingKeyboard) {
						main->mappingNotify(e);	
					}
				}
			
		}
		return false;
	};
};

int main(int argc, char **argv)
{
	
    TDEAboutData about("kvkbd", I18N_NOOP("kvkbd"), version, description,
                     TDEAboutData::License_GPL, "(C) 2007 Todor Gyumyushev", 0, 0, "yodor@developer.bg");
    about.addAuthor( "Todor Gyumyushev", 0, "yodor@developer.bg" );
	
	int alone=0;
	
	if (argc>0) {
		int curr=0;
		while (curr<argc) {
			if (strcmp(argv[curr],"-loginhelper")==0){
				alone=1;
				
				break;
			}
			curr++;
		}
		
	}
	argc++;
	if (alone==1){
		KvkbdApp a(argc,argv,true);
		MainWidget m( &about, true, 0, "kvkbdalone");
		a.setMainWidget(&m);
		m.restorePosition();
		m.show();
		return a.exec();
	}
	else
	{
		
		TDECmdLineArgs::init(argc, argv, &about);
		TDECmdLineArgs::addCmdLineOptions( options );
		Kvkbd::addCmdLineOptions();
		//TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

		findAloneWindow();
		Kvkbd a;
		return a.exec();
	}
  	
}

