/***************************************************************************
 *   Copyright (C) 2007 by Todor Gyumyushev   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *        0000                                                                 *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef KVKBDMAINWIDGET_H
#define KVKBDMAINWIDGET_H


#include <tqevent.h>
#include <tqpoint.h>
#include <tqtimer.h>
#include <tdeaboutdata.h>
#include <ksystemtray.h>
#include <tdepopupmenu.h>
#include <tqpainter.h>
#include <tqthread.h>

#include "resizabledragwidget.h"
#include "VButton.h"
#include "numpadvbutton.h"
#include <X11/Xlib.h>

class KbdDock;
class KbdTray;

class MainWidget : public ResizableDragWidget
{
Q_OBJECT
  
public:
	MainWidget(TDEAboutData *about=0, bool tren=false, TQWidget *parent=0,const char *name="", WFlags f=WStyle_Customize | TQt::WX11BypassWM |WStyle_NormalBorder);
	void mappingNotify(XMappingEvent *e);
	void finishInit();
	bool close ( bool alsoDelete );

public slots:
	void keyPress(unsigned int keycode);
	void toggleNumlock();
	void toggleShiftCapsAltGr(unsigned int keycode);
	void toggleNumericPad();
	void toggleFontAutoRes();
	void toggleLock();
	void queryModState();
	void showDock();
	void chooseFont();
	void chooseBackgroundColor();
	void chooseKeysColor();
	void restorePosition();
	void showConfigMenu();
 	void saveState();
	void quitClicked();

protected:
	void resizeEvent(TQResizeEvent *e);
	void hideEvent(TQHideEvent *e);
	void setLockState(bool lock);

private:
	void updateFont();
	void updateNumlock();
	void updateShiftCapsAltGr();

	bool nresize;

	bool keyState(int iKey);
	void keyPress(int keycode);


	VButton *caps;
	VButton *lshift;
	VButton *rshift;

	VButton *lctrl;
	VButton *rctrl;
	
	VButton *lalt;
	VButton *ralt;

	VButton *lwin;
	VButton *rwin;
	VButton *mnu;

	VButton *numl;
	VButton *div;
	VButton *mul;
	VButton *min;
	VButton *plu;
	VButton *ent;

	NumpadVButton *ins;
	NumpadVButton *del;
	
	TQValueList<VButton *> btns;
	TQValueList<VButton *> mod_keys;
	TQValueList<VButton *> other_keys;
	TQValueList<NumpadVButton *> numl_keys;

	void send_key(unsigned int keycode);
	 
	Display *display;	
	KbdTray *tray;
	KbdDock *dock;

	bool stand_alone;
	bool extent_visible;
	VButton *quit;
	VButton *popup_menu;
	VButton *extent;
	double sdxs;
	double sdxb;
	int mnu_dock;
	int mnu_autores;
	int mnu_lock;
};


class KbdDock : public DragWidget
{
    Q_OBJECT
  

public:
    KbdDock(MainWidget *m);
    ~KbdDock();

	void paintEvent(TQPaintEvent *);


private:
	TQPixmap icn;
	MainWidget *mainWidget;
	

protected:
	void mouseReleaseEvent(TQMouseEvent *e);

};

class KbdTray : public KSystemTray
{

public:
 	KbdTray( TQWidget* parent = 0, const char* name  = 0 );

protected:	
    void mousePressEvent(TQMouseEvent *);

};

#endif
