#ifndef _KVI_KVS_USERACTION_H_
#define _KVI_KVS_USERACTION_H_
//=============================================================================
//
//   File : kvi_kvs_useraction.h
//   Created on Tue 07 Dec 2004 02:00:24 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2004 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_kvs_action.h"

class KviConfig;
class KviKvsScript;

class KVIRC_API KviKvsUserAction : public KviKvsAction
{
	friend class KviActionManager;
	Q_OBJECT
  
public:
	KviKvsUserAction(TQObject * pParent,
		const TQString &szName,
		const TQString &szScriptCode,
		const TQString &szVisibleNameCode,
		const TQString &szDescriptionCode,
		const TQString &szCategory,
		const TQString &szBigIcon,
		const TQString &szSmallIcon,
		unsigned int uFlags,
		const TQString &szKeySequence = TQString());
	KviKvsUserAction(TQObject * pParent);
	~KviKvsUserAction();

	// Static allocator function.
	// This MUST be used by the modules to allocate action structures
	// instead of the new operator.
	// See kvi_heapobject.cpp for an explaination.
	static KviKvsUserAction * createInstance(TQObject * pParent,
		const TQString &szName,
		const TQString &szScriptCode,
		const TQString &szVisibleNameCode,
		const TQString &szDescriptionCode,
		const TQString &szCategory,
		const TQString &szBigIcon,
		const TQString &szSmallIcon,
		unsigned int uFlags,
		const TQString &szKeySequence = TQString());
	void suicide() { delete this; };
protected:
	TQString m_szSmallIcon;
	TQString m_szCategory;
	KviKvsScript * m_pDescriptionScript;
	KviKvsScript * m_pVisibleNameScript;
protected:
	virtual bool isKviUserActionNeverOverrideThis();
	bool load(KviConfig * cfg);
	void save(KviConfig * cfg);
public:
	virtual const TQString & visibleName();
	virtual const TQString & description();
	const TQString & visibleNameCode();
	const TQString & descriptionCode();
	virtual TQPixmap * smallIcon();
	const TQString & category(){ return m_szCategory; };
	const TQString & smallIconString(){ return m_szSmallIcon; };
	static void exportToKvs(TQString &szBuffer,
		const TQString &szName,
		const TQString &szScriptCode,
		const TQString &szVisibleName,
		const TQString &szDescription,
		const TQString &szCategory,
		const TQString &szBigIcon,
		const TQString &szSmallIcon,
		unsigned int uFlags,
		const TQString &szKeySequence);
	void exportToKvs(TQString &szBuffer);
};


#endif //!_KVI_KVS_USERACTION_H_
