#ifndef _FILETRANSFERWINDOW_H_
#define _FILETRANSFERWINDOW_H_
//==================================================================================
//
//   File : filetransferwindow.h
//   Creation date : Mon Apr 21 2003 23:14:12 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the linkss of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//==================================================================================

#include "kvi_window.h"
#include "kvi_string.h"
#include "kvi_ircsocket.h"
#include "kvi_sparser.h"
#include "kvi_console.h"
#include "kvi_moduleextension.h"
#include "kvi_filetransfer.h"
#include "kvi_dynamictooltip.h"

#include "kvi_tal_listview.h"
#include "kvi_tal_popupmenu.h"
#include <tqtoolbutton.h>
#include <tqtimer.h>
#include <tqpixmap.h>



class KviFileTransferItem : public KviTalListViewItem
{
public:
	KviFileTransferItem(KviTalListView * v,KviFileTransfer * t);
	~KviFileTransferItem();
protected:
	KviFileTransfer * m_pTransfer;
public:
	KviFileTransfer * transfer(){ return m_pTransfer; };
	virtual void paintCell(TQPainter * p,const TQColorGroup &cg,int column,int width,int align);
	virtual void setHeight(int h);
	virtual TQString key(int column,bool bAcending) const;
};


class KviFileTransferWindow : public KviWindow , public KviModuleExtension
{
	friend class KviFileTransferItem;
	Q_OBJECT
  
public:
	KviFileTransferWindow(KviModuleExtensionDescriptor * d,KviFrame * lpFrm);
	~KviFileTransferWindow();
protected:
	TQSplitter           * m_pVertSplitter;
	KviTalListView           * m_pListView;
	KviTalPopupMenu          * m_pContextPopup;
	KviTalPopupMenu          * m_pLocalFilePopup;
	KviTalPopupMenu          * m_pOpenFilePopup;
	TQTimer              * m_pTimer;
	TQPixmap             * m_pMemPixmap;
	int                   m_iLineSpacing; // cached fm value
public: // Methods
	virtual void die();
protected:
	TQPixmap * memPixmap(){ return m_pMemPixmap; };
	virtual TQPixmap * myIconPtr();
	virtual void fillCaptionBuffers();
	virtual void applyOptions();
	virtual void resizeEvent(TQResizeEvent *e);
	virtual void getBaseLogFileName(KviStr &buffer);
	KviFileTransferItem * findItem(KviFileTransfer * t);
	void fillTransferView();
	KviFileTransfer * selectedTransfer();
	virtual void fontChange(const TQFont &oldFont);
	bool eventFilter( TQObject *obj, TQEvent *ev );
public:
	virtual TQSize sizeHint() const;
	int lineSpacing(){ return m_iLineSpacing; };
protected slots:
	void transferRegistered(KviFileTransfer *t);
	void transferUnregistering(KviFileTransfer *t);
	void rightButtonPressed(KviTalListViewItem *it,const TQPoint &pnt,int col);
	void doubleClicked(KviTalListViewItem *it,const TQPoint &pnt,int col);
	void heartbeat();
	void clearTerminated();
	void clearAll();
	void tipRequest(KviDynamicToolTip * tip,const TQPoint &pnt);

	void openLocalFile();
	void openLocalFileWith();
	void copyLocalFileToClipboard();
	void openLocalFileFolder();
	void openFilePopupActivated(int id);
	void openLocalFileTerminal();
	void deleteLocalFile();
};

#endif //_FILETRANSFERWINDOW_H_
