#ifndef _KVI_TAL_TOOLTIP_H_
#define _KVI_TAL_TOOLTIP_H_

//=============================================================================
//
//   File : kvi_tal_tooltip.h
//   Creation date : Mon Jan 22 2007 11:25:08 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2007 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_settings.h"

#include <tqtooltip.h>
#include <tqobject.h>

class KviTalToolTip;

// This is useful only with TQt4, but we put it here anyway
// to have both a consistent API and make moc happy
class KviTalToolTipHelper : public TQObject
{
	friend class KviTalToolTip;
	Q_OBJECT
  
public:
	KviTalToolTipHelper(KviTalToolTip * pToolTip,TQWidget * pWidget);
	~KviTalToolTipHelper();
protected:
	KviTalToolTip * m_pToolTip;
protected:
	virtual bool eventFilter(TQObject * pObject,TQEvent * pEvent);
	void toolTipDying();
};


class KVILIB_API KviTalToolTip
#ifndef COMPILE_USE_QT4
 : public TQToolTip
#endif
{
	friend class KviTalToolTipHelper;
public:
	KviTalToolTip(TQWidget * pParent);
	virtual ~KviTalToolTip();
protected:
#ifdef COMPILE_USE_QT4
	KviTalToolTipHelper * m_pHelper;
	TQWidget * m_pParent;
#endif
public:
#ifdef COMPILE_USE_QT4
	static void add(TQWidget * widget,const TQString & text);
	static void remove(TQWidget * widget);
	virtual void tip(const TQRect & rect,const TQString & text);
#endif
protected:
	virtual void maybeTip(const TQPoint & p);
#ifdef COMPILE_USE_QT4
	void helperDying();
#endif
};

#endif // _KVI_TAL_TOOLTIP_H_
