#ifndef _KVI_TAL_POPUPMENU_QT4_H_
#define _KVI_TAL_POPUPMENU_QT4_H_

//=============================================================================
//
//   File : kvi_tal_popupmenu_qt3.h
//   Creation date : Mon Jan 22 2007 11:25:08 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2007 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_qstring.h"

#include <tq3popupmenu.h>
#include <tqwidgetaction.h>

class KVILIB_API KviTalPopupMenu : public Q3PopupMenu
{
	Q_OBJECT
  
public:
	KviTalPopupMenu(TQWidget * pParent=0,const TQString &szName = KviTQString::empty)
	: Q3PopupMenu(pParent)
	{
		setName(szName);
	};
	virtual ~KviTalPopupMenu() {};

	int insertItem(const TQString &szText)
	{
		return Q3PopupMenu::insertItem(szText);
	}
	int insertItem(const TQPixmap &pix,const TQString &szText)
	{
		return Q3PopupMenu::insertItem(TQIcon(pix),szText,-1,-1);
	}
	int insertItem(const TQString &szText,int id)
	{
		return Q3PopupMenu::insertItem(szText,id);
	}
	int insertItem(const TQPixmap &pix,const TQString &szText,int id)
	{
		return Q3PopupMenu::insertItem(TQIcon(pix),szText,id,-1);
	}
	int insertItem(const TQString &szText,const TQObject * pReceiver,const char * szSlot)
	{
		return Q3PopupMenu::insertItem(szText,pReceiver,szSlot);
	}
	int insertItem(const TQPixmap &pix,const TQString &szText,const TQObject * pReceiver,const char * szSlot)
	{
		return Q3PopupMenu::insertItem(TQIcon(pix),szText,pReceiver,szSlot);
	}
	int insertItem(const TQPixmap &pix,const TQString &szText,TQMenu *pMenu)
	{
		return Q3PopupMenu::insertItem(TQIcon(pix),szText,pMenu,-1,-1);
	}
	int insertItem(const TQString &szText,TQMenu *pMenu)
	{
		return Q3PopupMenu::insertItem(szText,pMenu,-1,-1);
	}
	int insertItem(TQWidget * pWidget)
	{
		// needs TQt 4.2
		TQWidgetAction * pAct = new TQWidgetAction(this);
		pAct->setDefaultWidget(pWidget);
		addAction(pAct);
		return 0;
	}


};

#endif // _KVI_TAL_POPUPMENU_QT4_H_
