//=============================================================================
//
//   File : kvi_ircviewtools.cpp
//   Creation date : Sat Oct 9 2004 16:03:01 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2004 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_ircviewtools.h"
#include "kvi_ircview.h"
#include "kvi_styled_controls.h"
#include "kvi_iconmanager.h"
#include "kvi_options.h"
#include "kvi_locale.h"
#include "kvi_malloc.h"
#include "kvi_msgbox.h"
#include "kvi_filedialog.h"
#include "kvi_app.h"
#include "kvi_memmove.h"

#include <tqtoolbutton.h>
#include <tqtabwidget.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqcheckbox.h>
#include <tqpushbutton.h>
#ifdef COMPILE_USE_QT4
	#include <tq3header.h>
#else
	#include <tqheader.h>
#endif
#include <tqlineedit.h>
#include <tqcursor.h>
#include "kvi_accel.h"
#include <tqevent.h>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Tool widget implementation
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


KviIrcMessageCheckListItem::KviIrcMessageCheckListItem(KviTalListView * par,KviIrcViewToolWidget * w,int id)
: KviTalCheckListItem(par,TQString(),KviTalCheckListItem::CheckBox)
{
	m_iId = id;
	m_pToolWidget = 0;
	setPixmap(0,*(g_pIconManager->getSmallIcon(KVI_OPTION_MSGTYPE(id).pixId())));
	setOn(true);
	m_pToolWidget = w;
}

KviIrcMessageCheckListItem::~KviIrcMessageCheckListItem()
{
}

void KviIrcMessageCheckListItem::stateChange(bool bOn)
{
	KviTalCheckListItem::stateChange(bOn);
	if(!m_pToolWidget)return;
	m_pToolWidget->forceRepaint();
}



KviIrcViewToolWidget::KviIrcViewToolWidget(KviIrcView * par)
: TQFrame(par)
{
	m_pIrcView = par;
	setFrameStyle(TQFrame::StyledPanel | TQFrame::Raised);

	TQGridLayout * gl = new TQGridLayout(this,2,2,4,2);

	TQLabel * l = new TQLabel(__tr2qs("<b><font color=\"#EAEAEA\" size=\"-1\">Find Text</font></b>"),this);
	l->setMaximumHeight(14);
	l->setBackgroundColor(TQt::black);
	gl->addWidget(l,0,0);

	TQToolButton *tb = new TQToolButton(TQt::DownArrow,this,"down_arrow");
	tb->setFixedSize(14,14);
	tb->setAutoRepeat(false);
	connect(tb,TQT_SIGNAL(clicked()),m_pIrcView,TQT_SLOT(toggleToolWidget()));
	gl->addWidget(tb,0,1);


	TQTabWidget * tw = new TQTabWidget(this);



	// Find tab
	TQWidget * w = new TQWidget(tw);

	TQGridLayout * g = new TQGridLayout(w,6,2,2,1);

	m_pStringToFind = new TQLineEdit(w);
	g->addMultiCellWidget(m_pStringToFind,0,0,0,2);
	connect(m_pStringToFind,TQT_SIGNAL(returnPressed()),this,TQT_SLOT(findNext()));
	
	m_pRegExp = new KviStyledCheckBox(__tr2qs("&Regular expression"),w);
	g->addMultiCellWidget(m_pRegExp,1,1,0,2);

	m_pExtendedRegExp = new KviStyledCheckBox(__tr2qs("E&xtended regexp."),w);
	g->addMultiCellWidget(m_pExtendedRegExp,2,2,0,2);
	m_pExtendedRegExp->setEnabled(false);
	connect(m_pRegExp,TQT_SIGNAL(toggled(bool)),m_pExtendedRegExp,TQT_SLOT(setEnabled(bool)));

	m_pCaseSensitive = new KviStyledCheckBox(__tr2qs("C&ase sensitive"),w);
	g->addMultiCellWidget(m_pCaseSensitive,3,3,0,2);

	TQPushButton * pb = new TQPushButton(__tr2qs("Find &Prev."),w);
	connect(pb,TQT_SIGNAL(clicked()),this,TQT_SLOT(findPrev()));
	g->addWidget(pb,4,0);

	pb = new TQPushButton(__tr2qs("&Find Next"),w);
	pb->setDefault(true);
	connect(pb,TQT_SIGNAL(clicked()),this,TQT_SLOT(findNext()));
	g->addMultiCellWidget(pb,4,4,1,2);

	m_pFindResult = new TQLabel(w);
	m_pFindResult->setFrameStyle(TQFrame::Sunken | TQFrame::StyledPanel);
	g->addMultiCellWidget(m_pFindResult,5,5,0,2);

	//g->setResizeMode(TQGridLayout::Fixed);

	tw->addTab(w,__tr2qs("Find"));

	// Filter tab
	TQWidget * w1 = new TQWidget(tw);

	g = new TQGridLayout(w1,5,2,2,1);

	m_pFilterView = new KviTalListView(w1);
	m_pFilterView->addColumn(__tr2qs("Type"));
	m_pFilterView->header()->hide();
	m_pFilterView->setMinimumSize(TQSize(10,10));

	g->addMultiCellWidget(m_pFilterView,0,4,0,0);


	m_pFilterItems = (KviIrcMessageCheckListItem **)kvi_malloc(KVI_NUM_MSGTYPE_OPTIONS * sizeof(KviIrcMessageCheckListItem *));

	for(int i=0;i<KVI_NUM_MSGTYPE_OPTIONS;i++)
	{
		m_pFilterItems[i] = new KviIrcMessageCheckListItem(m_pFilterView,this,i);
	}

	pb = new TQPushButton(__tr2qs("Set &All"),w1);
	connect(pb,TQT_SIGNAL(clicked()),this,TQT_SLOT(filterEnableAll()));
	g->addWidget(pb,0,1);

	pb = new TQPushButton(__tr2qs("Set &None"),w1);
	connect(pb,TQT_SIGNAL(clicked()),this,TQT_SLOT(filterEnableNone()));
	g->addWidget(pb,1,1);

	pb = new TQPushButton(__tr2qs("&Load From..."),w1);
	connect(pb,TQT_SIGNAL(clicked()),this,TQT_SLOT(filterLoad()));
	g->addWidget(pb,2,1);

	pb = new TQPushButton(__tr2qs("&Save As..."),w1);
	connect(pb,TQT_SIGNAL(clicked()),this,TQT_SLOT(filterSave()));
	g->addWidget(pb,3,1);

	tw->addTab(w1,__tr2qs("Filter"));

	gl->addMultiCellWidget(tw,1,1,0,1);

	gl->setResizeMode(TQGridLayout::Fixed);
	m_pStringToFind->setFocus();
	tw->showPage(w);
	KviAccel *a = new KviAccel( this );
        a->connectItem( a->insertItem(TQt::Key_Escape), this,TQT_SLOT(close()) );
}

KviIrcViewToolWidget::~KviIrcViewToolWidget()
{
	kvi_free((void *)m_pFilterItems);
}

void KviIrcViewToolWidget::filterEnableAll()
{
	for(int i=0;i<KVI_NUM_MSGTYPE_OPTIONS;i++)
	{
		m_pFilterItems[i]->setToolWidget(0);
		m_pFilterItems[i]->setOn(true);
		m_pFilterItems[i]->setToolWidget(this);
	}
	forceRepaint();
}

void KviIrcViewToolWidget::filterEnableNone()
{
	for(int i=0;i<KVI_NUM_MSGTYPE_OPTIONS;i++)
	{
		m_pFilterItems[i]->setToolWidget(0);
		m_pFilterItems[i]->setOn(false);
		m_pFilterItems[i]->setToolWidget(this);
	}
	forceRepaint();
}

void KviIrcViewToolWidget::hideEvent ( TQHideEvent * ){
	m_pIrcView->toggleToolWidget();
}

void KviIrcViewToolWidget::closeEvent ( TQCloseEvent * e ){
	m_pIrcView->toggleToolWidget();
}

void KviIrcViewToolWidget::filterLoad()
{
	TQString szFile;
	TQString szInit;
	g_pApp->getLocalKvircDirectory(szInit,KviApp::Filters);

	if(KviFileDialog::askForOpenFileName(szFile,__tr2qs("Select a Filter File"),szInit))
	{
		TQFile f(szFile);
		if(f.open(IO_ReadOnly))
		{
			char buffer[KVI_NUM_MSGTYPE_OPTIONS];
			kvi_memset(buffer,0,KVI_NUM_MSGTYPE_OPTIONS);
			f.readBlock(buffer,KVI_NUM_MSGTYPE_OPTIONS);
			f.close();
			for(int i=0;i<KVI_NUM_MSGTYPE_OPTIONS;i++)
			{
				m_pFilterItems[i]->setToolWidget(0);
				m_pFilterItems[i]->setOn(buffer[i]);
				m_pFilterItems[i]->setToolWidget(this);
			}
			forceRepaint();
		} else {
			KviMessageBox::warning(__tr2qs("Can't open the filter file %s for reading."),&szFile);
		}
	}
}

void KviIrcViewToolWidget::filterSave()
{
	TQString szFile;
	TQString szInit;
	g_pApp->getLocalKvircDirectory(szInit,KviApp::Filters,"filter.kvf");
	if(KviFileDialog::askForSaveFileName(szFile,__tr2qs("Select a Name for the Filter File"),szInit,0,false,true))
	{
		TQFile f(szFile);
		if(f.open(IO_WriteOnly))
		{
			char buffer[KVI_NUM_MSGTYPE_OPTIONS];
			for(int i=0;i<KVI_NUM_MSGTYPE_OPTIONS;i++)
			{
				buffer[i] = messageEnabled(i) ? 1 : 0;
			}
			if(f.writeBlock(buffer,KVI_NUM_MSGTYPE_OPTIONS) < KVI_NUM_MSGTYPE_OPTIONS)
				KviMessageBox::warning(__tr2qs("Failed to write the filter file %Q (IO Error)"),&szFile);
			f.close();
		} else KviMessageBox::warning(__tr2qs("Can't open the filter file %Q for writing"),&szFile);
	}
}

void KviIrcViewToolWidget::forceRepaint()
{
	#if defined(COMPILE_USE_QT4) && defined(COMPILE_ON_WINDOWS) 
		m_pIrcView->repaint();
	#else
		m_pIrcView->paintEvent(0);
	#endif

}

void KviIrcViewToolWidget::setFindResult(const TQString & text)
{
	m_pFindResult->setText(text);
}

void KviIrcViewToolWidget::findPrev()
{
	bool bRegExp = m_pRegExp->isChecked();
	m_pIrcView->findPrev(m_pStringToFind->text(),m_pCaseSensitive->isChecked(),bRegExp,bRegExp && m_pExtendedRegExp->isChecked());
}

void KviIrcViewToolWidget::findNext()
{
	bool bRegExp = m_pRegExp->isChecked();
	m_pIrcView->findNext(m_pStringToFind->text(),m_pCaseSensitive->isChecked(),bRegExp,bRegExp && m_pExtendedRegExp->isChecked());
}


void KviIrcViewToolWidget::mousePressEvent(TQMouseEvent *e)
{
	m_pressPoint = e->pos();
}

void KviIrcViewToolWidget::mouseMoveEvent(TQMouseEvent *)
{
	TQPoint p=m_pIrcView->mapFromGlobal(TQCursor::pos());
	p-=m_pressPoint;
	if(p.x() < 1)p.setX(1);
	else {
		int www = (m_pIrcView->width() - (m_pIrcView->m_pScrollBar->width() + 1));
		if((p.x() + width()) > www)p.setX(www - width());
	}
	if(p.y() < 1)p.setY(1);
	else {
		int hhh = (m_pIrcView->height() - 1);
		if((p.y() + height()) > hhh)p.setY(hhh - height());
	}
	move(p);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Link tip label implementation
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

KviIrcViewToolTip::KviIrcViewToolTip(KviIrcView * pView)
: KviTalToolTip(pView)
{
	m_pView = pView;
}

KviIrcViewToolTip::~KviIrcViewToolTip()
{
}

void KviIrcViewToolTip::maybeTip(const TQPoint &pnt)
{
	m_pView->maybeTip(pnt);
}

