#ifndef _KVI_TAL_WIZARD_H_
#define _KVI_TAL_WIZARD_H_

//=============================================================================
//
//   File : kvi_tal_wizard.h
//   Creation date : Tue Feb 06 2007 14:35:08 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2007 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_settings.h"

#ifdef COMPILE_USE_QT4
	#include <TQDialog>
#else
	#include <tqdialog.h>
#endif

class TQShowEvent;
class TQPushButton;
class KviTalWizardPrivate;
class KviTalWizardPageData;

///
/// \class KviTalWizard
///
/// \brief Provides a wizard-style dialog with steps
///
class KVILIB_API KviTalWizard : public TQDialog
{
	Q_OBJECT
  
public:
	KviTalWizard(TQWidget * pParent);
	~KviTalWizard();
protected:
	KviTalWizardPrivate * m_p;
public:
	///
	/// Adds a page to the wizard with the specified title.
	/// The pages are displayed in order they're added.
	/// Adding a page a second time is equivalent to calling
	/// setPageTitle() and enabling the page.
	///
	void addPage(TQWidget * pWidget,const TQString &szTitle);
	///
	/// Adds a page to the wizard with the specified title
	/// and in the specified position.
	/// Adding a page a second time is equivalent to calling
	/// setPageTitle() and enabling the page.
	///
	void insertPage(TQWidget * pWidget,const TQString &szTitle,int iIndex);
	///
	/// Enables or disables a page. A disabled page
	/// is skipped when the user presses "Next" in the
	/// previous page or "Back" in the page after.
	/// Disabling the current page has no effect.
	///
	/// Returns true on success or false if the pWidget
	/// does not identify a page that has been added to this wizard.
	///
	bool setPageEnabled(TQWidget * pWidget,bool bEnabled);
	///
	/// Changes a page title.
	///
	/// Returns true on success or false if the pWidget
	/// does not identify a page that has been added to this wizard.
	///
	bool setPageTitle(TQWidget * pWidget,const TQString &szTitle);
	///
	/// Switches the wizard to the specified page.
	/// Please note that this class handles page switching
	/// automatically so you usually don't need to call this function.
	///
	/// Returns true on success or false if the pWidget
	/// does not identify a page that has been added to this wizard.
	///
	bool setCurrentPage(TQWidget * pWidget);
	///
	/// Returns a pointer to the current page
	///
	TQWidget * currentPage();
	///
	/// Enables or disables the help button for the specified page.
	/// By default the help button is always disabled.
	///
	void setHelpEnabled(TQWidget * pWidget,bool bEnabled);
	///
	/// Enables or disables the cancel button for the specified page.
	/// By default the cancel button is always enabled.
	///
	void setCancelEnabled(TQWidget * pWidget,bool bEnabled);
	///
	/// Enables or disables the finish button for the specified page.
	/// By default the finish button is always disabled.
	///
	void setFinishEnabled(TQWidget * pWidget,bool bEnabled);
	///
	/// Enables or disables the next button for the specified page.
	/// By default the next button is always enabled.
	///
	void setNextEnabled(TQWidget * pWidget,bool bEnabled);
	///
	/// Enables or disables the prev button for the specified page.
	/// By default the prev button is always enabled.
	///
	void setBackEnabled(TQWidget * pWidget,bool bEnabled);
	///
	/// Returns a pointer to the cancel button displayed in the dialog.
	///
	TQPushButton * cancelButton();
	///
	/// Returns a pointer to the help button displayed in the dialog.
	///
	TQPushButton * helpButton();
	///
	/// Returns a pointer to the finish button displayed in the dialog.
	///
	TQPushButton * finishButton();
	///
	/// Returns a pointer to the next button displayed in the dialog.
	///
	TQPushButton * nextButton();
	///
	/// Returns a pointer to the back button displayed in the dialog.
	///
	TQPushButton * backButton();
signals:
	///
	/// Emitted when the help button is clicked.
	///
	void helpClicked();
protected:
	///
	/// Displays the first page if no other page is shown yet.
	///
	virtual void showEvent(TQShowEvent * e);
	///
	/// Handles redirects the close button to the "cancel" operation.
	///
	virtual void closeEvent(TQCloseEvent * e);
protected:
	void setCurrentPage(KviTalWizardPageData * pData);
protected slots:
	void backButtonClicked();
	void nextButtonClicked();
	void helpButtonClicked();
	void cancelButtonClicked();
	void finishButtonClicked();
};


#endif // _KVI_TAL_WIZARD_H_
