#ifndef _TOOLBAREDITOR_H_
#define _TOOLBAREDITOR_H_
//=============================================================================
//
//   File : toolbareditor.h
//   Created on Wed 01 Dec 2004 14:42:20 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2004 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include <tqwidget.h>
#include <tqlabel.h>
#include <tqdialog.h>
#include <tqcolor.h>

class TQPushButton;
class KviActionDrawer;

class KviCustomizeToolBarsDialog : public TQDialog
{
	Q_OBJECT
  
protected:
	KviCustomizeToolBarsDialog(TQWidget * p);
public:
	~KviCustomizeToolBarsDialog();
protected:
	KviActionDrawer * m_pDrawer;
	static KviCustomizeToolBarsDialog * m_pInstance;
	TQPushButton * m_pDeleteToolBarButton;
	TQPushButton * m_pRenameToolBarButton;
	TQPushButton * m_pExportToolBarButton;
public:
	static KviCustomizeToolBarsDialog * instance(){ return m_pInstance; };
	static void display();
	static void cleanup();
protected:
	virtual void showEvent(TQShowEvent * e);
	virtual void closeEvent(TQCloseEvent *e);
protected slots:
	void closeClicked();
	void newToolBar();
	void deleteToolBar();
	void renameToolBar();
	void exportToolBar();
	void currentToolBarChanged();
};

class TQLineEdit;
class TQPushButton;

class KviCustomToolBarPropertiesDialog : public TQDialog
{
	Q_OBJECT
  
public:
	KviCustomToolBarPropertiesDialog(TQWidget * p,const TQString &szText,const TQString &szId = TQString(),const TQString &szLabel = TQString(),const TQString &szIconId = TQString());
	~KviCustomToolBarPropertiesDialog();
protected:
	TQString m_szId;
	TQString m_szOriginalId;
	TQString m_szLabel;
	TQString m_szIconId;
	TQWidget * m_pAdvanced;
	TQLineEdit * m_pIdEdit;
	TQLineEdit * m_pLabelEdit;
	TQLineEdit * m_pIconEdit;
	TQPushButton * m_pIconButton;
	TQPushButton * m_pAdvancedButton;
public:
	const TQString &id(){ return m_szId; };
	const TQString &label(){ return m_szLabel; };
	const TQString &iconId(){ return m_szIconId; };
protected slots:
	void okClicked();
	void advancedClicked();
	void iconButtonClicked();
	void labelTextChanged(const TQString &s);
protected:
	void iconSelected(const TQString &szIconId);
};

class TQTimer;

class KviTrashcanLabel : public TQLabel
{
	Q_OBJECT
  
public:
	KviTrashcanLabel(TQWidget * p);
	virtual ~KviTrashcanLabel();
protected:
	unsigned int m_uFlashCount;
	TQTimer * m_pFlashTimer;
	TQColor   m_clrOriginal;
protected:
	virtual void dragEnterEvent(TQDragEnterEvent * e);
	virtual void dropEvent(TQDropEvent * e);
public slots:
	void flash();
protected slots:
	void heartbeat();
};

#endif //!_TOOLBAREDITOR_H_
