#ifndef _OPTW_PROXY_H_
#define _OPTW_PROXY_H_

//
//   File : optw_proxy.h
//   Creation date : Mon Jun 24 2000 21:58:25 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//

#include "kvi_optionswidget.h"
#include "kvi_tal_listview.h"


class KviProxy;
class KviProxyDataBase;

extern KVIRC_API KviProxyDataBase * g_pProxyDataBase;

class KviProxyOptionsListViewItem : public KviTalListViewItem
{
public:
	KviProxyOptionsListViewItem(KviTalListView *parent,const TQPixmap &pm,KviProxy * prx);
	~KviProxyOptionsListViewItem();
public:
	KviProxy * m_pProxyData;
};

class TQLabel;
class TQLineEdit;
class KviIpEditor;
class TQCheckBox;
class KviTalPopupMenu;
class TQComboBox;

#define KVI_OPTIONS_WIDGET_ICON_KviProxyOptionsWidget KVI_SMALLICON_PROXY
#define KVI_OPTIONS_WIDGET_NAME_KviProxyOptionsWidget __tr2qs_no_lookup("Proxy Hosts")
#define KVI_OPTIONS_WIDGET_PARENT_KviProxyOptionsWidget KviConnectionOptionsWidget
#define KVI_OPTIONS_WIDGET_KEYWORDS_KviProxyOptionsWidget __tr2qs_no_lookup("connection,servers")
#define KVI_OPTIONS_WIDGET_PRIORITY_KviProxyOptionsWidget 70000

class KviProxyOptionsWidget : public KviOptionsWidget
{
	Q_OBJECT
  
public:
	KviProxyOptionsWidget(TQWidget * parent);
	~KviProxyOptionsWidget();
protected:
	KviTalListView    * m_pListView;
	TQLabel       * m_pProxyLabel;
	TQLineEdit    * m_pProxyEdit;
	TQLabel       * m_pIpLabel;
	KviIpEditor  * m_pIpEditor;
	TQLabel       * m_pUserLabel;
	TQLineEdit    * m_pUserEdit;
	TQLabel       * m_pPassLabel;
	TQLineEdit    * m_pPassEdit;
	TQLabel       * m_pPortLabel;
	TQLineEdit    * m_pPortEdit;
	TQLabel       * m_pProtocolLabel;
	TQComboBox    * m_pProtocolBox;
	KviTalPopupMenu   * m_pContextPopup;
	TQCheckBox    * m_pIpV6Check;
	KviProxyOptionsListViewItem * m_pLastEditedItem;
private:

	void fillProxyList();
	void saveLastItem();
protected slots:
	void listViewItemSelectionChanged(KviTalListViewItem *it);
	void listViewRightButtonPressed(KviTalListViewItem *it,const TQPoint &pnt,int col);
	void newProxy();
	void removeCurrent();
	void ipV6CheckToggled(bool bEnabled);
public:
	virtual void commit();
};

#endif //!_OPTW_PROXY_H_
