#ifndef _NOTIFIERWINDOW_H_
#define _NOTIFIERWINDOW_H_
//==================================================================================
//
//   File : notifierwindow.h
//   Creation date : Tue Jul 6 2004 20:25:12 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2005 Iacopo Palazzi < iakko(at)siena(dot)linux(dot)it >
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the linkss of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//==================================================================================

#include "kvi_settings.h"

#include <tqbitmap.h>
#include <tqcolor.h>
#include <tqcursor.h>
#include <tqdatetime.h> 
#include <tqfont.h>
#include <tqimage.h>
#include <tqlineedit.h>
#include <tqpixmap.h>
#include <tqrect.h>
#include <tqtimer.h>
#include <tqwidget.h>

#include "kvi_qstring.h"
#include "kvi_pointerlist.h"
#include "kvi_time.h"

#include "notifiersettings.h"

class KviWindow;
class KviNotifierMessage;

class KviNotifierWindowBody;
class KviNotifierWindowBorder;
class KviNotifierWindowProgressBar;
class KviNotifierWindowTabs;

class TQPainter;
class TQPopupMenu;

extern kvi_time_t g_tNotifierDisabledUntil;

class KviNotifierWindow : public TQWidget
{
	Q_OBJECT
  
public:
	KviNotifierWindow();
	~KviNotifierWindow();
protected:
	TQTimer * m_pShowHideTimer;
	TQTimer * m_pProgressTimer;
	TQTimer * m_pBlinkTimer;
	TQTimer * m_pAutoHideTimer;
	State   m_eState;
	bool    m_bBlinkOn;
	double  m_dOpacity;
	TQImage  m_imgDesktop;            // the desktop screenshot
	TQPixmap m_pixBackground;         // our background image
	TQPixmap m_pixBackgroundHighlighted;
	TQPixmap m_pixForeground;         // we paint the stuff HERE
	
	// Notifier graphic layout
	TQPixmap m_pixBckgrnd;

	TQImage  m_imgBuffer;             // here we merge the two images

	bool    m_bCloseDown;
	bool    m_bPrevDown;
	bool    m_bNextDown;
	bool    m_bWriteDown;
	bool m_bCrashShowWorkAround;

	bool	m_bKeyShiftPressed;

	TQFont * m_pDefaultFont;
	TQFont * m_pTitleFont;
	
	TQRect	m_wndRect;

	TQColor  m_clrCurText;
	TQColor  m_clrOldText[NUM_OLD_COLORS];
	TQColor  m_clrHistoricText;
	TQColor  m_clrTitle;

	KviNotifierMessage * m_pCurrentMessage;
	TQLineEdit * m_pLineEdit;

	bool	m_bDragging;
	bool	m_bLeftButtonIsPressed;
	bool	m_bDiagonalResizing;
	bool	m_bResizing;
	
	int		m_whereResizing;
	
	TQPoint       m_pntDrag;
	TQPoint       m_pntPos;
	TQPoint		 m_pntClick;
	int          m_iInputHeight;
	int          m_iBlinkTimeout;
	int          m_iBlinkCount;
	TQPopupMenu * m_pContextPopup;
	TQPopupMenu * m_pDisablePopup;
	KviWindow * m_pWindowToRaise;
	kvi_time_t  m_tAutoHideAt;
	kvi_time_t  m_tStartedAt;
	TQTime	    m_qtStartedAt;
	bool		m_bDisableHideOnMainWindowGotAttention;
	//bool		m_bForceShowing;
	
	TQCursor m_cursor;
	
	KviNotifierWindowTabs 		* m_pWndTabs;
	KviNotifierWindowProgressBar	* m_pProgressBar;
	KviNotifierWindowBody 		* m_pWndBody;
	KviNotifierWindowBorder 	* m_pWndBorder;
public:
	void doShow(bool bDoAnimate);
	void doHide(bool bDoAnimate);
	const TQFont & defaultFont(){ return *m_pDefaultFont; };
	int textWidth();
	void addMessage(KviWindow * pWnd,const TQString &szImageId,const TQString &szText,unsigned int uMessageTime);
	State state() { return m_eState; };
	void setDisableHideOnMainWindowGotAttention(bool b){ m_bDisableHideOnMainWindowGotAttention = b; };
	int countTabs();
	void showLineEdit(bool bShow);
protected:
	virtual void showEvent(TQShowEvent *e);
	virtual void hideEvent(TQHideEvent * e);
	virtual void paintEvent(TQPaintEvent * e);
	virtual void mousePressEvent(TQMouseEvent * e);
	virtual void mouseReleaseEvent(TQMouseEvent * e);
	virtual void mouseMoveEvent(TQMouseEvent * e);
	virtual void leaveEvent(TQEvent * e);
	virtual void enterEvent(TQEvent * e);
	virtual void mouseDoubleClickEvent(TQMouseEvent * e);
	virtual void wheelEvent(TQWheelEvent * e);
	virtual bool eventFilter(TQObject * pEdit,TQEvent * e);
	virtual void keyPressEvent ( TQKeyEvent * e );
	virtual void keyReleaseEvent ( TQKeyEvent * e );
protected slots:
	void blink();
	void heartbeat();
	void returnPressed();
	void reloadImages();
	void fillContextPopup();
	void hideNow();
	void disableFor1Minute();
	void disableFor5Minutes();
	void disableFor15Minutes();
	void disableFor30Minutes();
	void disableFor60Minutes();
	void disableUntilKVIrcRestarted();
	void disablePermanently();
	void delayedRaiseSlot();
	void autoHide();
	void progressUpdate();
private:
	void contextPopup(const TQPoint &pos);
	void startBlinking();
	void markAllMessagesAsHistoric();
	void computeRect();
	void stopShowHideTimer();
	void stopBlinkTimer();
	void stopAutoHideTimer();
	void startAutoHideTimer();
	void delayedRaise(KviWindow * pWnd);
	void prevButtonClicked();
	void nextButtonClicked();
	bool shouldHideIfMainWindowGotAttention();
	void setCursor(int);
	void resize(TQPoint p, bool = true);
	void redrawWindow();
	void redrawText();
	bool checkResizing(TQPoint);
};

#endif //_NOTIFIERWINDOW_H_
