#ifndef _KVI_IPEDITOR_H_
#define _KVI_IPEDITOR_H_

//
//   File : kvi_ipeditor.h
//   Creation date : Wed Jun 12 2000 14:16:02 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//

#include "kvi_settings.h"

#include <tqwidget.h>
#include <tqstring.h>
#include <tqframe.h>

class TQLineEdit;
class TQLabel;

class KVIRC_API KviIpEditor : public TQFrame
{
	Q_OBJECT
  
public:
	enum AddressType { IpV4 , IpV6 };
	KviIpEditor(TQWidget * parent,AddressType = IpV4,const TQString &ipAddr = TQString(),const char *name = 0);
	~KviIpEditor();
private:
	TQLabel      * m_pLabel[7];
	TQLineEdit   * m_pEdit[8];
	AddressType   m_addrType;
public:
	bool setAddress(const TQString &ipAddr);
	TQString address() const;
	void setAddressType(AddressType addrType);
	AddressType addressType() const;
	bool hasEmptyFields() const;
	void clear();
	virtual void setEnabled(bool bEnabled);
protected:
	virtual bool eventFilter(TQObject * o,TQEvent *e);
	virtual void resizeEvent(TQResizeEvent *e);
	virtual TQSize sizeHint();
private:
	void recreateChildren();
};

#endif //_KVI_IPEDITOR_H_
