//=============================================================================
//
//   File : kvi_tal_iconview.cpp
//   Creation date : Mon Jan 22 2007 11:25:08 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2007 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#define __KVILIB__
#include "kvi_tal_iconview.h"

#ifdef COMPILE_USE_QT4

	KviTalIconView::KviTalIconView(TQWidget * pParent,TQt::WFlags f)
	: Q3IconView(pParent,0,f)
	{
		connect(this,TQT_SIGNAL(selectionChanged(Q3IconViewItem *)),this,TQT_SLOT(redirect_selectionChanged(Q3IconViewItem *)));
		connect(this,TQT_SIGNAL(currentChanged(Q3IconViewItem *)),this,TQT_SLOT(redirect_currentChanged(Q3IconViewItem *)));
		connect(this,TQT_SIGNAL(clicked(Q3IconViewItem *)),this,TQT_SLOT(redirect_clicked(Q3IconViewItem *)));
		connect(this,TQT_SIGNAL(clicked(Q3IconViewItem *,const TQPoint &)),this,TQT_SLOT(redirect_clicked(Q3IconViewItem *,const TQPoint &)));
		connect(this,TQT_SIGNAL(pressed(Q3IconViewItem *)),this,TQT_SLOT(redirect_pressed(Q3IconViewItem *)));
		connect(this,TQT_SIGNAL(pressed(Q3IconViewItem *,const TQPoint &)),this,TQT_SLOT(redirect_pressed(Q3IconViewItem *,const TQPoint &)));
		connect(this,TQT_SIGNAL(doubleClicked(Q3IconViewItem *)),this,TQT_SLOT(redirect_doubleClicked(Q3IconViewItem *)));
		connect(this,TQT_SIGNAL(returnPressed(Q3IconViewItem *)),this,TQT_SLOT(redirect_returnPressed(Q3IconViewItem *)));
		connect(this,TQT_SIGNAL(rightButtonClicked(Q3IconViewItem *,const TQPoint &)),this,TQT_SLOT(redirect_rightButtonClicked(Q3IconViewItem *,const TQPoint &)));
		connect(this,TQT_SIGNAL(rightButtonPressed(Q3IconViewItem *,const TQPoint &)),this,TQT_SLOT(redirect_rightButtonPressed(Q3IconViewItem *,const TQPoint &)));
		connect(this,TQT_SIGNAL(mouseButtonClicked(int,Q3IconViewItem *,const TQPoint &)),this,TQT_SLOT(redirect_mouseButtonClicked(int,Q3IconViewItem *,const TQPoint &)));
		connect(this,TQT_SIGNAL(mouseButtonPressed(int,Q3IconViewItem *,const TQPoint &)),this,TQT_SLOT(redirect_mouseButtonPressed(int,Q3IconViewItem *,const TQPoint &)));
		connect(this,TQT_SIGNAL(contextMenuRequested(Q3IconViewItem *,const TQPoint &)),this,TQT_SLOT(redirect_contextMenuRequested(Q3IconViewItem *,const TQPoint &)));
		connect(this,TQT_SIGNAL(onItem(Q3IconViewItem *)),this,TQT_SLOT(redirect_onItem(Q3IconViewItem *)));
	}

	void KviTalIconView::redirect_selectionChanged(Q3IconViewItem * pItem)
	{
		emit selectionChanged((KviTalIconViewItem *)pItem);
	}

	void KviTalIconView::redirect_currentChanged(Q3IconViewItem * pItem)
	{
		emit currentChanged((KviTalIconViewItem *)pItem);
	}

	void KviTalIconView::redirect_clicked(Q3IconViewItem * pItem)
	{
		emit clicked((KviTalIconViewItem *)pItem);
	}

	void KviTalIconView::redirect_clicked(Q3IconViewItem * pItem,const TQPoint &pnt)
	{
		emit clicked((KviTalIconViewItem *)pItem,pnt);
	}

	void KviTalIconView::redirect_pressed(Q3IconViewItem * pItem)
	{
		emit pressed((KviTalIconViewItem *)pItem);
	}

	void KviTalIconView::redirect_pressed(Q3IconViewItem * pItem,const TQPoint &pnt)
	{
		emit pressed((KviTalIconViewItem *)pItem,pnt);
	}

	void KviTalIconView::redirect_doubleClicked(Q3IconViewItem * pItem)
	{
		emit doubleClicked((KviTalIconViewItem *)pItem);
	}

	void KviTalIconView::redirect_returnPressed(Q3IconViewItem * pItem)
	{
		emit returnPressed((KviTalIconViewItem *)pItem);
	}

	void KviTalIconView::redirect_rightButtonClicked(Q3IconViewItem * pItem,const TQPoint &pnt)
	{
		emit rightButtonClicked((KviTalIconViewItem *)pItem,pnt);
	}

	void KviTalIconView::redirect_rightButtonPressed(Q3IconViewItem * pItem,const TQPoint &pnt)
	{
		emit rightButtonPressed((KviTalIconViewItem *)pItem,pnt);
	}

	void KviTalIconView::redirect_mouseButtonClicked(int iButton,Q3IconViewItem * pItem,const TQPoint &pnt)
	{
		emit mouseButtonClicked(iButton,(KviTalIconViewItem *)pItem,pnt);
	}

	void KviTalIconView::redirect_mouseButtonPressed(int iButton,Q3IconViewItem * pItem,const TQPoint &pnt)
	{
		emit mouseButtonPressed(iButton,(KviTalIconViewItem *)pItem,pnt);
	}

	void KviTalIconView::redirect_contextMenuRequested(Q3IconViewItem * pItem,const TQPoint &pnt)
	{
		emit contextMenuRequested((KviTalIconViewItem *)pItem,pnt);
	}

	void KviTalIconView::redirect_onItem(Q3IconViewItem * pItem)
	{
		emit onItem((KviTalIconViewItem *)pItem);
	}


	#include "kvi_tal_iconview_qt4.moc"
#else

	KviTalIconView::KviTalIconView(TQWidget * pParent,TQt::WFlags f)
	: TQIconView(pParent,0,f)
	{
		connect(this,TQT_SIGNAL(selectionChanged(TQIconViewItem *)),this,TQT_SLOT(redirect_selectionChanged(TQIconViewItem *)));
		connect(this,TQT_SIGNAL(currentChanged(TQIconViewItem *)),this,TQT_SLOT(redirect_currentChanged(TQIconViewItem *)));
		connect(this,TQT_SIGNAL(clicked(TQIconViewItem *)),this,TQT_SLOT(redirect_clicked(TQIconViewItem *)));
		connect(this,TQT_SIGNAL(clicked(TQIconViewItem *,const TQPoint &)),this,TQT_SLOT(redirect_clicked(TQIconViewItem *,const TQPoint &)));
		connect(this,TQT_SIGNAL(pressed(TQIconViewItem *)),this,TQT_SLOT(redirect_pressed(TQIconViewItem *)));
		connect(this,TQT_SIGNAL(pressed(TQIconViewItem *,const TQPoint &)),this,TQT_SLOT(redirect_pressed(TQIconViewItem *,const TQPoint &)));
		connect(this,TQT_SIGNAL(doubleClicked(TQIconViewItem *)),this,TQT_SLOT(redirect_doubleClicked(TQIconViewItem *)));
		connect(this,TQT_SIGNAL(returnPressed(TQIconViewItem *)),this,TQT_SLOT(redirect_returnPressed(TQIconViewItem *)));
		connect(this,TQT_SIGNAL(rightButtonClicked(TQIconViewItem *,const TQPoint &)),this,TQT_SLOT(redirect_rightButtonClicked(TQIconViewItem *,const TQPoint &)));
		connect(this,TQT_SIGNAL(rightButtonPressed(TQIconViewItem *,const TQPoint &)),this,TQT_SLOT(redirect_rightButtonPressed(TQIconViewItem *,const TQPoint &)));
		connect(this,TQT_SIGNAL(mouseButtonClicked(int,TQIconViewItem *,const TQPoint &)),this,TQT_SLOT(redirect_mouseButtonClicked(int,TQIconViewItem *,const TQPoint &)));
		connect(this,TQT_SIGNAL(mouseButtonPressed(int,TQIconViewItem *,const TQPoint &)),this,TQT_SLOT(redirect_mouseButtonPressed(int,TQIconViewItem *,const TQPoint &)));
		connect(this,TQT_SIGNAL(contextMenuRequested(TQIconViewItem *,const TQPoint &)),this,TQT_SLOT(redirect_contextMenuRequested(TQIconViewItem *,const TQPoint &)));
		connect(this,TQT_SIGNAL(onItem(TQIconViewItem *)),this,TQT_SLOT(redirect_onItem(TQIconViewItem *)));
	}

	void KviTalIconView::redirect_selectionChanged(TQIconViewItem * pItem)
	{
		emit selectionChanged((KviTalIconViewItem *)pItem);
	}

	void KviTalIconView::redirect_currentChanged(TQIconViewItem * pItem)
	{
		emit currentChanged((KviTalIconViewItem *)pItem);
	}

	void KviTalIconView::redirect_clicked(TQIconViewItem * pItem)
	{
		emit clicked((KviTalIconViewItem *)pItem);
	}

	void KviTalIconView::redirect_clicked(TQIconViewItem * pItem,const TQPoint &pnt)
	{
		emit clicked((KviTalIconViewItem *)pItem,pnt);
	}

	void KviTalIconView::redirect_pressed(TQIconViewItem * pItem)
	{
		emit pressed((KviTalIconViewItem *)pItem);
	}

	void KviTalIconView::redirect_pressed(TQIconViewItem * pItem,const TQPoint &pnt)
	{
		emit pressed((KviTalIconViewItem *)pItem,pnt);
	}

	void KviTalIconView::redirect_doubleClicked(TQIconViewItem * pItem)
	{
		emit doubleClicked((KviTalIconViewItem *)pItem);
	}

	void KviTalIconView::redirect_returnPressed(TQIconViewItem * pItem)
	{
		emit returnPressed((KviTalIconViewItem *)pItem);
	}

	void KviTalIconView::redirect_rightButtonClicked(TQIconViewItem * pItem,const TQPoint &pnt)
	{
		emit rightButtonClicked((KviTalIconViewItem *)pItem,pnt);
	}

	void KviTalIconView::redirect_rightButtonPressed(TQIconViewItem * pItem,const TQPoint &pnt)
	{
		emit rightButtonPressed((KviTalIconViewItem *)pItem,pnt);
	}

	void KviTalIconView::redirect_mouseButtonClicked(int iButton,TQIconViewItem * pItem,const TQPoint &pnt)
	{
		emit mouseButtonClicked(iButton,(KviTalIconViewItem *)pItem,pnt);
	}

	void KviTalIconView::redirect_mouseButtonPressed(int iButton,TQIconViewItem * pItem,const TQPoint &pnt)
	{
		emit mouseButtonPressed(iButton,(KviTalIconViewItem *)pItem,pnt);
	}

	void KviTalIconView::redirect_contextMenuRequested(TQIconViewItem * pItem,const TQPoint &pnt)
	{
		emit contextMenuRequested((KviTalIconViewItem *)pItem,pnt);
	}

	void KviTalIconView::redirect_onItem(TQIconViewItem * pItem)
	{
		emit onItem((KviTalIconViewItem *)pItem);
	}


	#include "kvi_tal_iconview_qt3.moc"
#endif

