//=============================================================================
//
//   File : kvi_kvs_kernel.cpp
//   Creation date : Tue 30 Sep 2003 05.12 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2003 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_kvs_kernel.h"
#include "kvi_kvs_parser.h"
#include "kvi_kvs_hash.h"
#include "kvi_kvs_aliasmanager.h"
#include "kvi_kvs_coresimplecommands.h"
#include "kvi_kvs_corefunctions.h"
#include "kvi_kvs_corecallbackcommands.h"
#include "kvi_kvs_switchlist.h"
#include "kvi_kvs_variantlist.h"
#include "kvi_kvs_script.h"
#include "kvi_kvs_object_controller.h"
#include "kvi_kvs_asyncoperation.h"
#include "kvi_modulemanager.h"

KviKvsKernel * KviKvsKernel::m_pKvsKernel = 0;

////////////////////////////////////////////////////////////////////////////////
// CONSTRUCTION AND DESTRUCTION

KviKvsKernel::KviKvsKernel()
{
	m_pKvsKernel = this;

	m_pSpecialCommandParsingRoutineDict = new KviPointerHashTable<TQString,KviKvsSpecialCommandParsingRoutine>(17,false);
	m_pSpecialCommandParsingRoutineDict->setAutoDelete(true);
	m_pCoreSimpleCommandExecRoutineDict = new KviPointerHashTable<TQString,KviKvsCoreSimpleCommandExecRoutine>(51,false);
	m_pCoreSimpleCommandExecRoutineDict->setAutoDelete(true);
	m_pCoreFunctionExecRoutineDict = new KviPointerHashTable<TQString,KviKvsCoreFunctionExecRoutine>(51,false);
	m_pCoreFunctionExecRoutineDict->setAutoDelete(true);
	m_pCoreCallbackCommandExecRoutineDict = new KviPointerHashTable<TQString,KviKvsCoreCallbackCommandExecRoutine>(17,false);
	m_pCoreCallbackCommandExecRoutineDict->setAutoDelete(true);

	m_pGlobalVariables = new KviKvsHash();
	m_pEmptyParameterList = new KviKvsVariantList();
	m_pObjectController = new KviKvsObjectController();
	m_pObjectController->init();
	m_pAsyncOperationManager = new KviKvsAsyncOperationManager();
	
	KviKvsParser::init();

	KviKvsCoreSimpleCommands::init();
	KviKvsCoreFunctions::init();
	KviKvsCoreCallbackCommands::init();
}

KviKvsKernel::~KviKvsKernel()
{
	delete m_pAsyncOperationManager;
	delete m_pObjectController;
	delete m_pEmptyParameterList;
	delete m_pGlobalVariables;

	delete m_pSpecialCommandParsingRoutineDict;
	delete m_pCoreSimpleCommandExecRoutineDict;
	delete m_pCoreFunctionExecRoutineDict;
	delete m_pCoreCallbackCommandExecRoutineDict;
}

////////////////////////////////////////////////////////////////////////////////
// INSTANCE MANAGEMENT

void KviKvsKernel::init()
{
	if(!m_pKvsKernel)m_pKvsKernel = new KviKvsKernel();
}

void KviKvsKernel::done()
{
	if(m_pKvsKernel)
	{
		delete m_pKvsKernel;
		m_pKvsKernel = 0;
	}
}

#define COMPLETE_COMMAND_BY_DICT(__type,__dict) \
	{ \
		KviPointerHashTableIterator<TQString,__type> it(*__dict); \
		int l = szCommandBegin.length(); \
		while(it.current()) \
		{ \
			if(KviTQString::equalCIN(szCommandBegin,it.currentKey(),l)) \
				pMatches->append(new TQString(it.currentKey())); \
			++it; \
		} \
	}


void KviKvsKernel::completeCommand(const TQString &szCommandBegin,KviPointerList<TQString> * pMatches)
{
	int idx = szCommandBegin.find(TQChar('.'));
	if(idx == -1)
	{
		// no module name inside
		COMPLETE_COMMAND_BY_DICT(KviKvsCoreSimpleCommandExecRoutine,m_pCoreSimpleCommandExecRoutineDict)
		COMPLETE_COMMAND_BY_DICT(KviKvsSpecialCommandParsingRoutine,m_pSpecialCommandParsingRoutineDict)
		COMPLETE_COMMAND_BY_DICT(KviKvsCoreCallbackCommandExecRoutine,m_pCoreCallbackCommandExecRoutineDict)

		KviPointerList<TQString> lModules;
		lModules.setAutoDelete(true);
		g_pModuleManager->completeModuleNames(szCommandBegin,&lModules);
		TQString szEmpty = "";
		for(TQString * pszModuleName = lModules.first();pszModuleName;pszModuleName = lModules.next())
			completeModuleCommand(*pszModuleName,szEmpty,pMatches);

		KviKvsAliasManager::instance()->completeCommand(szCommandBegin,pMatches);
	} else {
		// contains a module name
		TQString szModuleName = szCommandBegin.left(idx);
		TQString szRight = szCommandBegin.right(szCommandBegin.length() - (idx+1));
		completeModuleCommand(szModuleName,szRight,pMatches);
	}
}

void KviKvsKernel::completeModuleCommand(const TQString &szModuleName,const TQString &szCommandBegin,KviPointerList<TQString> * pMatches)
{
	KviModule * pModule = g_pModuleManager->getModule(szModuleName.latin1());
	if(!pModule)return;

	KviPointerList<TQString> lModuleMatches;
	lModuleMatches.setAutoDelete(true);
	pModule->completeCommand(szCommandBegin,&lModuleMatches);
	for(TQString * pszModuleMatch = lModuleMatches.first();pszModuleMatch;pszModuleMatch = lModuleMatches.next())
	{
		TQString * pszMatch = new TQString(*pszModuleMatch);
		pszMatch->prepend(".");
		pszMatch->prepend(szModuleName);
		pMatches->append(pszMatch);
	}
}

void KviKvsKernel::completeFunction(const TQString &szFunctionBegin,KviPointerList<TQString> * pMatches)
{
	int idx = szFunctionBegin.find(TQChar('.'));
	if(idx == -1)
	{
		// no module name inside

		KviPointerHashTableIterator<TQString,KviKvsCoreFunctionExecRoutine> it(*m_pCoreFunctionExecRoutineDict);
		int l = szFunctionBegin.length();
		while(it.current())
		{
			if(KviTQString::equalCIN(szFunctionBegin,it.currentKey(),l))
			{
				TQString * pMatch = new TQString(it.currentKey());
				//pMatch->prepend("$");
				pMatches->append(pMatch);
			}
			++it;
		}

		KviPointerList<TQString> lModules;
		lModules.setAutoDelete(true);
		g_pModuleManager->completeModuleNames(szFunctionBegin,&lModules);
		TQString szEmpty = "";
		for(TQString * pszModuleName = lModules.first();pszModuleName;pszModuleName = lModules.next())
			completeModuleFunction(*pszModuleName,szEmpty,pMatches);

		KviPointerList<TQString> lAliases;
		lAliases.setAutoDelete(true);

		KviKvsAliasManager::instance()->completeCommand(szFunctionBegin,&lAliases);
		for(TQString * pszAlias = lAliases.first();pszAlias;pszAlias = lAliases.next())
		{
			TQString * pszAliasMatch = new TQString(*pszAlias);
			//pszAliasMatch->prepend("$");
			pMatches->append(pszAliasMatch);
		}
	} else {
		// contains a module name
		TQString szModuleName = szFunctionBegin.left(idx);
		TQString szRight = szFunctionBegin.right(szFunctionBegin.length() - (idx+1));
		completeModuleFunction(szModuleName,szRight,pMatches);
	}

	
}

void KviKvsKernel::completeModuleFunction(const TQString &szModuleName,const TQString &szCommandBegin,KviPointerList<TQString> * pMatches)
{
	KviModule * pModule = g_pModuleManager->getModule(szModuleName.latin1());
	if(!pModule)return;

	KviPointerList<TQString> lModuleMatches;
	lModuleMatches.setAutoDelete(true);
	pModule->completeFunction(szCommandBegin,&lModuleMatches);
	for(TQString * pszModuleMatch = lModuleMatches.first();pszModuleMatch;pszModuleMatch = lModuleMatches.next())
	{
		TQString * pszMatch = new TQString(*pszModuleMatch);
		pszMatch->prepend(".");
		pszMatch->prepend(szModuleName);
		//pszMatch->prepend("$");
		pMatches->append(pszMatch);
	}
}
