/***************************************************************************
 *   Copyright (C) 2003-2005 by David Saxton                               *
 *   david@bluehaze.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "ktechlab.h"

#include <dcopclient.h>
#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <tdeconfig.h>
#include <tdelocale.h>

static const char description[] =
    I18N_NOOP("An IDE for microcontrollers and electronics");

static const char version[] = "0.3";

static TDECmdLineOptions options[] =
{
    { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
    TDECmdLineLastOption
};


int main(int argc, char **argv)
{
    TDEAboutData about("ktechlab", I18N_NOOP("KTechlab"), version, description,
					 TDEAboutData::License_GPL, "(C) 2003-2005, The KTechlab developers", "", "http://ktechlab.org", "ktechlab-devel@lists.sourceforge.net" );
    about.addAuthor( "David Saxton", 0, "david@bluehaze.org" );
	about.addAuthor( "Daniel Clarke", 0, "daniel.jc@gmail.com" );
	about.addCredit( "Couriousous", "JK flip-flop, asyncronous preset/reset in the D flip-flop." );
	about.addCredit( "John Myers", "Rotary Switch" );
	about.addCredit( "Ali Akcaagac", "Glib friendliness." );
	about.addCredit( "David Leggett", "Website hosting and feedback during early development." );
    TDECmdLineArgs::init(argc, argv, &about);
    TDECmdLineArgs::addCmdLineOptions(options);
    TDEApplication app;
	
    // register ourselves as a dcop client
	app.dcopClient()->registerAs(app.name(), false);
	
	KTechlab *ktechlab = new KTechlab();
	
	TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();
	for ( int i=0; i < args->count(); ++i )
		ktechlab->load( args->url(i) );
	
	ktechlab->show();
	args->clear(); // Free up some memory
	return app.exec();
}

void exit_gpsim(int ret)
{
	printf("gpsim attempted to call exit_gpsim(%d), ***IGNORING***\n", ret);
//	exit(ret);
}
