/***************************************************************************
 *   Copyright (C) 2005 by David Saxton                                    *
 *   david@bluehaze.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef PROJECTDLGS_H
#define PROJECTDLGS_H

#include <kdialogbase.h>

class CreateSubprojectWidget;
class LinkerOptions;
class LinkerOptionsWidget;
class KURLRequester;
class NewProjectWidget;
class ProcessingOptions;
class ProcessingOptionsWidget;
class ProjectItem;

/**
A standard dialog for getting project details from the user for a new project
@short Dialog for new project details
@author David Saxton
*/
class NewProjectDlg : public KDialogBase
{
	Q_OBJECT
  
	public:
		NewProjectDlg( TQWidget * parent );

	    /**
		 * Called when the 'Cancel' button is pressed.
		 */
		void reject();
    
  	  	/**
		 * Called when the 'OK' button is pressed.
		 * User entered values are read in
		 */
		void accept();
		
		bool accepted() const { return m_bAccepted; }
		TQString projectName() const { return m_projectName; }
		TQString projectLocation() const { return m_projectLocation; }
		TQString location() const { return m_location; }
    
	public slots:
   		 /**
		 * Called when the projectName or projectLocation edit boxes are edited.
		 * Checks whether the resultant location combination is a valid path -
		 * if so, enabels the OK button; otherwise disables it.
		  */
		void locationChanged( const TQString & );

	protected:
		NewProjectWidget * m_pWidget;
		bool m_bAccepted;
		TQString m_projectName;
		TQString m_projectLocation;
		TQString m_location;
};


/**
@author David Saxton
*/
class CreateSubprojectDlg : public KDialogBase
{
	Q_OBJECT
  
	public:
		CreateSubprojectDlg( TQWidget *parent = 0 );
		~CreateSubprojectDlg();
		
		// The following values should agree with the positions in the combo box
		enum Type
		{
			ProgramType = 0,
			LibraryType = 1
		};

	    /**
		 * Called when the 'Cancel' button is pressed.
		 */
		void reject();
  	  	/**
		 * Called when the 'OK' button is pressed. User entered values are read
		 * in.
		 */
		void accept();
		
		bool accepted() const { return m_bAccepted; }
		Type type() const { return m_type; }
		TQString targetFile() const { return m_targetFile; }

	protected:
		CreateSubprojectWidget * m_pWidget;
		bool m_bAccepted;
		Type m_type;
		TQString m_targetFile;
};


/**
@author David Saxton
*/
class LinkerOptionsDlg : public KDialogBase
{
	Q_OBJECT
  
	public:
		LinkerOptionsDlg( LinkerOptions * linkingOptions, TQWidget *parent = 0 );
		virtual ~LinkerOptionsDlg();

	    /**
		 * Called when the 'Cancel' button is pressed.
		 */
		void reject();
  	  	/**
		 * Called when the 'OK' button is pressed. User entered values are read
		 * in.
		 */
		void accept();
		
	protected:
		LinkerOptions * m_pLinkerOptions;
		LinkerOptionsWidget * m_pWidget;
		KURLRequester * m_pExternalLibraryRequester;
};


/**
@author David Saxton
*/
class ProcessingOptionsDlg : public KDialogBase
{
	public:
		ProcessingOptionsDlg( ProjectItem * projectItem, TQWidget *parent = 0 );
		virtual ~ProcessingOptionsDlg();

	    /**
		 * Called when the 'Cancel' button is pressed.
		 */
		void reject();
  	  	/**
		 * Called when the 'OK' button is pressed. User entered values are read
		 * in.
		 */
		void accept();
		
	protected:
		ProjectItem * m_pProjectItem;
		ProcessingOptionsWidget * m_pWidget;
};

#endif
