/***************************************************************************
 *   Copyright (C) 2004-2005 by David Saxton                               *
 *   david@bluehaze.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef ITEMINTERFACE_H
#define ITEMINTERFACE_H

#include <tqguardedptr.h>

class CNItemGroup;
class DoubleSpinBox;
class Item;
class ItemDocument;
class ItemGroup;
class ItemInterface;
class KTechlab;
class MechanicsGroup;
class Variant;

class ColorCombo;
class KComboBox;
class TDEToolBar;
class KURLRequester;
class TQCheckBox;
class KLineEdit;
class KIntSpinBox;


typedef TQMap<TQString, Variant*> VariantDataMap;
typedef TQMap<TQString, KComboBox*> KComboBoxMap;
typedef TQMap<TQString, KLineEdit*> KLineEditMap;
typedef TQMap<TQString, DoubleSpinBox*> DoubleSpinBoxMap;
typedef TQMap<TQString, KIntSpinBox*> IntSpinBoxMap;
typedef TQMap<TQString, ColorCombo*> ColorComboMap;
typedef TQMap<TQString, KURLRequester*> KURLReqMap;
typedef TQMap<TQString, TQCheckBox*> TQCheckBoxMap;

/**
This acts as an interface between the ItemDocument's and the associated
Items's, and the various objects that like to know about them
(e.g. ContextHelp, ItemEditor, ItemEditTB)
@author David Saxton
*/
class ItemInterface : public TQObject
{
	Q_OBJECT
  
	public:
		~ItemInterface();
		static ItemInterface * self( KTechlab * ktechlab = 0l );
		
		/**
		 * Sets the orientation of all flowparts in the group.
		 */
		void setFlowPartOrientation( unsigned orientation );
		/**
		 * Sets the orientation of all components in the group.
		 */
		void setComponentOrientation( int angleDegrees, bool flipped );
		/**
		 * Updates actions based on the items currently selected (e.g. rotate,
		 * flip, etc)
		 */
		void updateItemActions();
		/**
		 * Returns a configuration widget for the component for insertion into te
		 * ItemEditTB.
		 * @param showAdvanced Whether advanced data should be shown
		 */
		virtual TQWidget * configWidget();
	
	public slots:
		/**
		 * If cnItemsAreSameType() returns true, then set the
		 * data with the given id for all the CNItems in the group.
		 * Else, it only sets the data for the activeCNItem()
		 */
		void slotSetData( const TQString &id, TQVariant value );
		/**
		 * Called when the ItemEditTB is cleared. This clears all widget maps.
		 */
		void itemEditTBCleared();
		void tbDataChanged();
		void slotItemDocumentChanged( ItemDocument *view );
		void slotUpdateItemInterface();
		void slotClearAll();
		void slotMultipleSelected();
		void clearItemEditorToolBar();
	
	protected:
		/**
		 * Connects the specified widget to either tbDataChanged or advDataChanged
		 * as specified by mi.
		 */
		void connectMapWidget( TQWidget *widget, const char *_signal);
		
		KTechlab * const p_ktechlab;
	
		// Widget maps.
		KLineEditMap m_stringLineEditMap;
		KComboBoxMap m_stringComboBoxMap;
		KURLReqMap m_stringURLReqMap;
		DoubleSpinBoxMap m_doubleSpinBoxMap;
		IntSpinBoxMap m_intSpinBoxMap;
		ColorComboMap m_colorComboMap;
		TQCheckBoxMap m_boolCheckMap;
		
		// Use by item editor toolbar
		TQGuardedPtr<TDEToolBar> m_pActiveItemEditorToolBar;
		int m_toolBarWidgetID;
		
		
	protected slots:
		void slotGetActionTicket();

	private:
		ItemInterface( KTechlab * ktechlab );
		static ItemInterface * m_pSelf;
	
		TQGuardedPtr<ItemDocument> p_cvb;
		TQGuardedPtr<ItemGroup> p_itemGroup;
		TQGuardedPtr<Item> p_lastItem;
		int m_currentActionTicket;
};

#endif
